/**************************************************************************
*
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_comp_asm.h
*
* @author Andrey Butok
*
* @date May-31-2011
*
* @version 0.1.8.0
*
* @brief Compiler-specific definitions that resolve
* differences between different assemblers.
*
***************************************************************************/


#ifndef _FNET_COMP_ASM_H_

#define _FNET_COMP_ASM_H_

#define __FNET_ASM_CODE /* To eliminate non-assembler code.*/

#include "fnet_config.h"

/* --------------- CodeWarrior ---------------*/
#if FNET_CFG_COMP_CW

/* CW compiler adds leading underscores to assembly symbols.*/
#define FNET_COMP_ASM_PREFIX(x) _##x

/* Macro for the equate directive. */    
FNET_COMP_ASM_EQU:  .macro  label,  value
label   .equ    value
        .endm    

/* Extern. */
FNET_COMP_ASM_EXTERN:  .macro  value
	.extern  value
        .endm
        
/* Global.*/
FNET_COMP_ASM_GLOBAL: .macro label
	.global label
	.endm
            
/* Align. */
FNET_COMP_ASM_ALIGN:  .macro  value
	.align  value
        .endm

/* DC.W */
FNET_COMP_ASM_DC16:   .macro value
	.word value
	.endm
/* DC.L */
FNET_COMP_ASM_DC32:    .macro value
	.long value
	.endm


/* Code section. */
#define FNET_COMP_ASM_CODE  .text            

/* No END in CW.*/
#define FNET_COMP_ASM_END
   
#endif /* FNET_CFG_COMP_CW */

/* --------------- IAR ----------------------*/
#if FNET_CFG_COMP_IAR

/* IAR compiler does not add any leading underscores to assembly symbols*/
#define FNET_COMP_ASM_PREFIX(x) x

/* Macro for the equate directive */
FNET_COMP_ASM_EQU MACRO label, value
label   EQU  value
	ENDM

/* Extern. */
FNET_COMP_ASM_EXTERN  MACRO value
	EXTERN  value
	ENDM

/* Global.*/
FNET_COMP_ASM_GLOBAL MACRO label
	PUBLIC label
	ENDM

/* Align. */
FNET_COMP_ASM_ALIGN  MACRO value
	ALIGN  value
	ENDM
/*DC.W*/
FNET_COMP_ASM_DC16  MACRO value
	DC16 value
	ENDM

/* DC.L */
FNET_COMP_ASM_DC32 MACRO value
	DC32 value
	ENDM


/* Code section. */
#if FNET_MCF      
    #define FNET_COMP_ASM_CODE  RSEG CODE 
#endif      

#if FNET_MK      
    #define FNET_COMP_ASM_CODE  RSEG .text:CODE
#endif          
      

/*END - END directive is placed after the last
statement of a program to tell the assembler that this is the end
of the program module. The assembler will ignore any
statement after an END directive. Carriage return is required
after the END directive.*/
#define FNET_COMP_ASM_END   END 

/* Registers.*/
#if FNET_MCF       
FLASHBAR  DEFINE  0xC04
RAMBAR    DEFINE  0xC05
#endif
                                     
    
#endif /* FNET_CFG_COMP_IAR */


#endif /* _FNET_COMP_ASM_H_ */

