/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_comp_config.h
*
* @author Andrey Butok
*
* @date May-16-2011
*
* @version 0.1.9.0
*
* @brief Compiler-specific default configuration file.
*
***************************************************************************/

/************************************************************************
 * !!!DO NOT MODIFY THIS FILE!!!
 ************************************************************************/

#ifndef _FNET_COMP_CONFIG_H_

#define _FNET_COMP_CONFIG_H_

#include "fnet_config.h"


/*! @addtogroup fnet_platform_config  */
/*! @{ */
/**************************************************************************/ /*!
 * @def      FNET_CFG_COMP_compiler_type 
 * @brief    This is the set of the @c FNET_CFG_COMP_[compiler_type] definitions that 
 *           define a currently used compiler. @n
 *           Current version of the FNET supports the following compiler definitions:
 *            - @c FNET_CFG_COMP_CW  = Used compiler is the CodeWarrior (by default).
 *            - @c FNET_CFG_COMP_IAR = Used compiler is the IAR.
 *            @n @n
 *            Selected compiler definition should be only one and must be defined as 1. 
 *            All others may be defined but must have the 0 value.
 *            If no compiler definition is defined, the default compiler is CodeWarrior.
 * 
 ******************************************************************************/
#define FNET_CFG_COMP_compiler_type /* Ignore it. Just only for Doxygen documentation */


/* IAR compiler. */
#ifndef FNET_CFG_COMP_IAR
    #define FNET_CFG_COMP_IAR   (0)
#endif

/* CW compiler. */
#ifndef FNET_CFG_COMP_CW
    #define FNET_CFG_COMP_CW   (0)
#endif

/* GHS compiler. */
#ifndef FNET_CFG_COMP_GHS
    #define FNET_CFG_COMP_GHS   (0)
#endif

#if FNET_CFG_COMP_CW
    #define FNET_COMP_STR    "CW"
#elif FNET_CFG_COMP_IAR
    #define FNET_COMP_STR    "IAR"
#elif FNET_CFG_COMP_GHS
    #define FNET_COMP_STR    "GHS"
#elif FNET_CFG_COMP_DIAB
    #define FNET_COMP_STR    "DIAB"
#else
    #if (defined(__MWERKS__) || defined(__CODEWARRIOR__))
        #undef FNET_CFG_COMP_CW
        #define FNET_CFG_COMP_CW    (1)
        #define FNET_COMP_STR       "CW"
    #elif (defined(IAR))
        #undef FNET_CFG_COMP_IAR 
        #define FNET_CFG_COMP_IAR   (1)
        #define FNET_COMP_STR       "IAR"
    #elif (defined(__ghs__))
        #undef FNET_CFG_COMP_GHS 
        #define FNET_CFG_COMP_GHS   (1)
        #define FNET_COMP_STR       "GHS"
    #elif (defined(__DCC__))
        #undef FNET_CFG_COMP_DIAB 
        #define FNET_CFG_COMP_DIAB   (1)
        #define FNET_COMP_STR       "DIAB"
    #elif (defined(__GNUC__))
		#undef FNET_CFG_COMP_GCC
        #define FNET_CFG_COMP_GCC   (1)
        #define FNET_COMP_STR       "GCC"
    #else
        #error It is not possible to define the compiler. Please set a FNET_CFG_COMP_XXXX parameter.
    #endif
#endif



/*! @} */

#endif /* _FNET_COMP_CONFIG_H_ */
