/**************************************************************************
*
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_eth_prv.h
*
* @author Andrey Butok
*
* @date Apr-20-2011
*
* @version 0.1.10.0
*
* @brief Private. Ethernet platform independent API functions.
*
***************************************************************************/

#ifndef _FNET_ETHERNET_PRV_H_

#define _FNET_ETHERNET_PRV_H_

#include "fnet_config.h"

#if FNET_CFG_ETH

#include "fnet_eth.h"
#include "fnet_arp.h"


/************************************************************************
*     Definitions
*************************************************************************/
// Ethernet Frame Types
#define FNET_ETH_TYPE_IP        (0x0800)
#define FNET_ETH_TYPE_ARP       (0x0806)

#define FNET_ETH_HDR_SIZE       (14)    /* Size of Ethernet header.*/
#define FNET_ETH_CRC_SIZE       (4)     /* Size of Ethernet CRC.*/


/**************************************************************************/ /*!
* @internal
* @brief    Ethernet Frame header.
******************************************************************************/
FNET_COMP_PACKED_BEGIN
typedef struct
{
    fnet_mac_addr_t destination_addr;   /**< 48-bit destination address.*/
    fnet_mac_addr_t source_addr;        /**< 48-bit source address.*/
    unsigned short type;                /**< 16-bit type field.*/
} fnet_eth_header_t;
FNET_COMP_PACKED_END

/************************************************************************
*     Global Data Structures
*************************************************************************/
extern fnet_mac_addr_t fnet_eth_null_addr;
extern fnet_mac_addr_t fnet_eth_broadcast;
extern fnet_netif_t fnet_eth0_if;

#define FNET_ETH_IF (&fnet_eth0_if)

/************************************************************************
*     Function Prototypes
*************************************************************************/
fnet_arp_if_t *fnet_eth_arp_if( fnet_netif_t *netif );
void fnet_eth_output_low( fnet_netif_t *netif, unsigned short type, fnet_mac_addr_t* dest_addr,
                          fnet_netbuf_t *nb );

#if FNET_CFG_DEBUG_TRACE_ETH
void fnet_eth_trace(char *str, fnet_eth_header_t *eth_hdr);
#else
#define fnet_eth_trace(str, eth_hdr)
#endif                          

#endif

#endif
