/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_loop.h
*
* @author Andrey Butok
*
* @date Feb-4-2011
*
* @version 0.1.6.0
*
* @brief Private. Loopback driver function definitions, data structures, etc.
*
***************************************************************************/

#ifndef _FNET_LOOP_H_

#define _FNET_LOOP_H_

#include "fnet_config.h"

#if FNET_CFG_LOOP

#include "fnet_netif_prv.h"

#define FNET_LOOP_MTU        (FNET_CFG_LOOP_MTU) /* The loopback MTU.*/

#if (FNET_LOOP_MTU <200)

#undef FNET_LOOP_MTU
#define FNET_LOOP_MTU  (200)

#endif

/************************************************************************
*     Global Data Structures
*************************************************************************/

extern fnet_netif_t fnet_loop_if;

#define FNET_LOOP_IF    (&fnet_loop_if)

/************************************************************************
*     Function Prototypes
*************************************************************************/

void fnet_loop_output( fnet_netif_t *netif, fnet_ip_addr_t dest_ip_addr, fnet_netbuf_t *nb,
                       int do_not_route );

#endif

#endif
