/**************************************************************************
*
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_mempool.h
*
* @author Andrey Butok
*
* @date Mar-8-2011
*
* @version 0.0.8.0
*
* @brief FNET memory pools API.
*
***************************************************************************/

#ifndef _FNET_MEMPOOL_H_

#define _FNET_MEMPOOL_H_

#include "fnet_config.h"
#include "fnet_comp.h"

/**************************************************************************/ /*!
 * @internal
 * @brief Memory pool descriptor.
 * @see fnet_mempool_init()
 ******************************************************************************/
typedef long fnet_mempool_desc_t;


FNET_COMP_PACKED_BEGIN
/* Memory pool unit header.*/
typedef struct fnet_mempool_unit_header 
{
    unsigned long size;                     /* Unit size. */
    struct fnet_mempool_unit_header *ptr;   /* Pointer to the next free block. */
} 
fnet_mempool_unit_header_t;
FNET_COMP_PACKED_END


typedef enum
{
    FNET_MEMPOOL_ALIGN_8 = (0x7),       /* Evenly divisible by 8.*/
    FNET_MEMPOOL_ALIGN_16 = (0xF),      /* Evenly divisible by 16.*/
    FNET_MEMPOOL_ALIGN_32 = (0x1F),     /* Evenly divisible by 32.*/
    FNET_MEMPOOL_ALIGN_64 = (0x3F)      /* Evenly divisible by 64.*/
}
fnet_mempool_align_t;


fnet_mempool_desc_t fnet_mempool_init( void *pool_ptr, unsigned long pool_size, fnet_mempool_align_t alignment );
void fnet_mempool_release( fnet_mempool_desc_t mempool );
void fnet_mempool_free( fnet_mempool_desc_t mempool, void *ap );
void *fnet_mempool_malloc(fnet_mempool_desc_t mempool, unsigned nbytes );
unsigned long fnet_mempool_free_mem_status( fnet_mempool_desc_t mempool);
unsigned long fnet_mempool_malloc_max( fnet_mempool_desc_t mempool );

#if 0 /* For Debug needs.*/
int fnet_mempool_check( fnet_mempool_desc_t mpool );
#endif

#endif
