/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_serial_config.h
*
* @author Andrey Butok
*
* @date Mar-16-2011
*
* @version 0.0.1.0
*
* @brief FNET Serial lib. configuration file.
*
***************************************************************************/

/**************************************************************************
 * !!!DO NOT MODIFY THIS FILE!!!
 **************************************************************************/

#ifndef _FNET_SERIAL_CONFIG_H_

#define _FNET_SERIAL_CONFIG_H_

/*! @addtogroup fnet_services_config */
/*! @{ */

/**************************************************************************/ /*!
 * @def     FNET_CFG_SERIAL_PRINTF_N_TO_RN 
 * @brief   Automatic replacing of all line feeds ("\n") inside the format 
 *          string to CR LF ("\r\n") by fnet_(s)printf() functions:
 *               - @c 1 = is enabled (deafault value, to save some ROM).
 *               - @c 0 = is disabled.@n
 *           @n
 * To save some bytes from all the hard coded strings the fnet_(s)printf() functions will 
 * expand all line feeds ("\n") inside the format string to CR LF ("\r\n"). 
 * So do not use "\r\n" in	the format string - it will be expanded to 
 * "\r\r\n". It is save to add it via a parameter though, e.g. 
 * fnet_printf("%s", "\r\n");
 * @showinitializer 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_SERIAL_PRINTF_N_TO_RN
/*! @endcond */
#define FNET_CFG_SERIAL_PRINTF_N_TO_RN     (1)
/*! @cond */
    #endif
/*! @endcond */


/*! @} */

#endif
