/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_stdlib.h
*
* @date Sep-2-2011
*
* @version 0.1.16.0
*
* @brief Standard functions API.
*
***************************************************************************/

#ifndef _FNET_STDLIB_H_

#define _FNET_STDLIB_H_

#include "fnet_config.h"



/********************************************************************
* Standard library functions
*********************************************************************/
#if !FNET_MPC && FNET_CFG_COMP_CW
    /* Type to hold information about variable arguments. */
    typedef char *fnet_va_list;
    /* Initialize a variable argument list.*/
    #define fnet_va_start(ap, parm) ap = (char *)(&parm + 1)
    /* End using variable argument list.*/
    #define fnet_va_end(ap)         ((void)0)
    /* Retrieve next argument.*/
    #define fnet_va_arg(ap, type)   (*(type *)((ap += (sizeof(type) + 3U) & ~3U) - (sizeof(type))))
#else //TBD
    #include <stdarg.h>
    #define fnet_va_list    va_list   
    #define fnet_va_start   va_start
    #define fnet_va_end     va_end
    #define fnet_va_arg     va_arg
#endif

void fnet_memcpy( void *, const void *, unsigned );
void *fnet_memset( void *, int, unsigned );
int fnet_memcmp( void *, const void *, int );

unsigned long fnet_strlen (const char *str);
char * fnet_strcat (char *dest, const char *src);
char * fnet_strncat (char *dest, const char *src, int n);
char * fnet_strcpy (char *dest, const char *src);
char *fnet_strncpy( char *dest, const char *src, unsigned long n );
char *fnet_strrchr( const char *str, int chr );
char *fnet_strchr( const char *str, int chr );
char *fnet_strstr( const char *str, const char *pat );
int fnet_strcmp( const char *, const char * );
int fnet_strncmp( const char *str1, const char *str2, unsigned int n );
unsigned long fnet_strtoul (char *str, char **ptr, int base);
int fnet_strcasecmp( const char *s1, const char *s2 );
int fnet_strcmp_splitter( const char *in_str, const char *name, char splitter);
char * fnet_strtok(char *str, const char *delimiter);

/***************************************************************************/ /*!
 *
 * @brief    Breaks a string into a sequence of tokens. 
 *
 * @param str           The string from which to extract tokens (null-terminated).
 *
 * @param delimiter     The string that contains a set of delimiter 
 *                      characters (null-terminated).
 *
 * @param last          Return parameter used by @ref fnet_strtok_r() to record 
 *                      its progress through @c str. @n
 *                      This pointer, must be the same while parsing the 
 *                      same string.
 *
 * @return       This function returns a pointer to the next token in @c str. 
 *               If there are no remaining tokens, it returns a @ref FNET_NULL
 *               pointer.
 *
 ******************************************************************************
 *
 * This function parses the string  @c str  into  tokens. @n
 * The  first function call should have @c str as its first argument. Subse-
 * quent calls should have the first  argument  set  to  @ref FNET_NULL.  Each  call
 * returns  a  pointer  to the next token, or @ref FNET_NULL when no more tokens are
 * found. @n
 * The function also updates the @c last parameter with the starting address 
 * of the token following the first occurrence of the @c delimiter parameter. @n
 * The @c delimiter string may be different for each call.
 *
 ******************************************************************************/
char * fnet_strtok_r(char *str, const char *delimiter, char **last);


#define FNET_TRUE       (1)
#define FNET_FALSE      (0)
#define FNET_NULL       (0)

#include "fnet_serial.h"

#endif
