/**************************************************************************
*
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_mpc_eth.c
*
* @author Gordon jahn
*
* @date Sep-5-2011
*
* @version 0.1.29.0
*
* @brief Ethernet driver implementation.
*
***************************************************************************/

#include "fnet_config.h"
#if FNET_MPC && FNET_CFG_ETH
#include "fnet_fec.h"

/************************************************************************
* Ethernet interface structure.
*************************************************************************/
fnet_netif_t fnet_eth0_if =
{
   0,                           /* pointer to the next net_if structure.*/
   0,                           /* pointer to the previous net_if structure.*/
   FNET_NETIF_TYPE_ETHERNET,    /* data-link type.*/
   "eth0",                      /* network interface name.*/
   {0,0,0,0,0,0,0,0},           /* the interface address structure.*/
   FNET_CFG_ETH_MTU,            /* maximum transmission unit.*/
   0,                           /* points to interface specific data structure.*/
   fnet_fec_init,               /* initialization function.*/
   fnet_fec_release,            /* shutdown function.*/
   fnet_fec_input,              /* receive function.*/
   fnet_fec_output,             /* transmit function.*/
   fnet_fec_set_addr_notify,    /* address change notification function.*/
   fnet_fec_drain,              /* drain function.*/
   fnet_fec_get_mac,
   fnet_fec_set_mac,
   fnet_fec_is_connected,
   fnet_fec_get_statistics
};

/************************************************************************
* NAME: fnet_eth_io_init
*
* DESCRIPTION: Ethernet IO initialization.
*************************************************************************/
void fnet_eth_io_init() 
{

    /* PH7 MDIO */
FNET_MPC5744_GPIO_MSCR(119) = 0x32080003;  	/* SRC = 0x3, OBE = 0x1, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x0, SSS = 0x3 */						
//FNET_MPC5744_GPIO_IMCR() = 0x00000001;	/* SSS = 0x1 */						

    /* PF0 MDC */
FNET_MPC5744_GPIO_MSCR(80) = 0x32010003; 	/* SRC = 0x3, OBE = 0x1, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x0, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x3 */						

    /* PG5 TX_EN */
FNET_MPC5744_GPIO_MSCR(101) = 0x32000003;	/* SRC = 0x3, OBE = 0x1, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x0, HYS = 0x0, PUS = 0x0, PUE = 0x0, SSS = 0x3 */						

    /* PG9 TDXD0 */
FNET_MPC5744_GPIO_MSCR(105) = 0x32000003;	/* SRC = 0x3, OBE = 0x1, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x0, HYS = 0x0, PUS = 0x0, PUE = 0x0, SSS = 0x3 */						

    /* PG10 TDXD1 */
FNET_MPC5744_GPIO_MSCR(106) = 0x32000003;	/* SRC = 0x3, OBE = 0x1, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x0, HYS = 0x0, PUS = 0x0, PUE = 0x0, SSS = 0x3 */						
#if 0
    /* PD10 TDXD2 */
FNET_MPC5744_GPIO_MSCR(58) = 0x32000003;	/* SRC = 0x3, OBE = 0x1, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x0, HYS = 0x0, PUS = 0x0, PUE = 0x0, SSS = 0x3 */						

    /* PG11 TDXD3 */
FNET_MPC5744_GPIO_MSCR(107) = 0x32000003;	/* SRC = 0x3, OBE = 0x1, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x0, HYS = 0x0, PUS = 0x0, PUE = 0x0, SSS = 0x3 */						

    /* PH5 COL */
FNET_MPC5744_GPIO_MSCR(117) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */	
FNET_MPC5744_GPIO_IMCR(230) = 0x00000001;	/* SSS = 0x1 */							
#endif
    /* PG8 TX_CLK */
FNET_MPC5744_GPIO_MSCR(104) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */
FNET_MPC5744_GPIO_IMCR(233) = 0x00000001;	/* SSS = 0x1 */			    
#if 0
    /* PH4 CRS */
FNET_MPC5744_GPIO_MSCR(116) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */	  
FNET_MPC5744_GPIO_IMCR(231) = 0x00000001;	/* SSS = 0x1 */		 

    /* PD8 RX_CLK */
FNET_MPC5744_GPIO_MSCR(56) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */	 
FNET_MPC5744_GPIO_IMCR(224) = 0x00000001;	/* SSS = 0x1 */		       
#endif
    /* PD7 RX_DV */
FNET_MPC5744_GPIO_MSCR(55) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */	
FNET_MPC5744_GPIO_IMCR(225) = 0x00000001;	/* SSS = 0x1 */		             

    /* PD6 RXD0 */
FNET_MPC5744_GPIO_MSCR(54) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */  
FNET_MPC5744_GPIO_IMCR(226) = 0x00000001;	/* SSS = 0x1 */		          

    /* PD5 RXD1 */
FNET_MPC5744_GPIO_MSCR(53) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */ 
FNET_MPC5744_GPIO_IMCR(227) = 0x00000001;	/* SSS = 0x1 */		             
#if 0
    /* PH8 RXD2 */
FNET_MPC5744_GPIO_MSCR(120) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */ 
FNET_MPC5744_GPIO_IMCR(228) = 0x00000001;	/* SSS = 0x1 */		         

    /* PJ9 RXD3 */
FNET_MPC5744_GPIO_MSCR(153) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */
FNET_MPC5744_GPIO_IMCR(229) = 0x00000001;	/* SSS = 0x1 */		            
#endif
    /* PI1 RX_ER */
FNET_MPC5744_GPIO_MSCR(129) =  0x30090000; 	/* SRC = 0x3, OBE = 0x0, ODE = 0x0, SMC = 0x0, APC = 0x0, TTL = 0x0, IBE = 0x1, HYS = 0x0, PUS = 0x0, PUE = 0x1, SSS = 0x0 */ 
FNET_MPC5744_GPIO_IMCR(232) = 0x00000001;	/* SSS = 0x1 */		        

}


/************************************************************************
* NAME: fnet_eth_phy_init
*
* DESCRIPTION: Ethernet Physical Transceiver initialization and/or reset.
*************************************************************************/
void fnet_eth_phy_init(fnet_fec_if_t *ethif) 
{
    fnet_uint16 reg_value;
    fnet_uint16 status_value = 0;

    fnet_fec_mii_read(ethif, FNET_FEC_MII_REG_CR, &reg_value);
   
    // ANE ENABLED:
    fnet_fec_mii_write(ethif, FNET_FEC_MII_REG_CR, (fnet_uint16)(reg_value | FNET_FEC_MII_REG_CR_ANE | FNET_FEC_MII_REG_CR_ANE_RESTART));

	while (status_value != 0x0024) 
	{
        fnet_fec_mii_read(ethif, FNET_FEC_MII_REG_SR, &status_value);
        status_value &= 0x0024;
	}

	fnet_printf("Link established with ETHERPHY\n");
       
}

#endif /* FNET_MPC && FNET_CFG_ETH */


