/**************************************************************************
* 
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file FNET_MPC_serial.c
*
* @author Gordon jahn
*
* @date Sep-5-2011
*
* @version 0.0.12.0
*
* @brief Bolero3M Serial port I/O functions; baud rate is NOT automatically
* 		 set at this time and interrupts/DMA are not used
*
***************************************************************************/

#include "fnet_config.h"

#if FNET_MPC

#include "fnet.h"
#include "fnet_cpu.h"

/********************************************************************/
void fnet_cpu_serial_putchar( long port_number, int character)
{
	
#if FNET_CFG_MPC_UART

    /* Send the character */
    FNET_MPC_LIN_BDRL(port_number) = (unsigned char)character;
	while(!(FNET_MPC_LIN_UARTSR(port_number) & 0x2)){}
	/* Clear Data Send Complete */
    FNET_MPC_LIN_UARTSR(port_number) = 0x2;
	
#endif
      
}

/********************************************************************/
int fnet_cpu_serial_getchar( long port_number )
{

#if FNET_CFG_MPC_UART
    /* If character received 
     */
    if (FNET_MPC_LIN_UARTSR(port_number) & 0x4) { 
    	// Clear recieved flag
    	FNET_MPC_LIN_UARTSR(port_number) = 0x4;
    	return (FNET_MPC_LIN_BDRM(port_number) & 0xFF);
    };

#endif    

    return FNET_ERR;    
}

/********************************************************************/
/* Enable the proper UART pins */

void fnet_cpu_serial_gpio_init(long port_number) 
{    
    /* LINFlex 0 is available on MPC5744P */
	/* LINFlex0 - TX PD9 */
	FNET_MPC5744_GPIO_MSCR(57) = 0x22800002; 						
	/* LINFlex0 - RX PD12 */
	FNET_MPC5744_GPIO_MSCR(60) = 0x00880002; 				
	FNET_MPC5744_GPIO_IMCR(166) = 0x00000002;		
}


/********************************************************************/
void fnet_cpu_serial_init(long port_number, unsigned long baud_rate)
{
    int lfdivx16 = 0;
	/*
	 * Initialize UART for serial communications
	 */

    /* Init GPIO.*/
    fnet_cpu_serial_gpio_init(port_number); 

#if FNET_CFG_MPC_UART
	/*
	 * Reset Transmitter - set sleep = 0 and init = 1
	 */
	FNET_MPC_LIN_CR1(port_number) = (FNET_MPC_LIN_CR1(port_number) & 0x0000FFFC) | 0x00000001;
	FNET_MPC_LIN_UARTCR(port_number) = 0x0001;	// Turn on UART mode so settings can be... set
	FNET_MPC_LIN_UARTCR(port_number) = 0x0033;
	
	/* Calculate LINIBRR and LINFBRR based on baud rate, assumes 160MHz busclk, LINFlex runs at busclk/2 in Panther */
	lfdivx16 = (FNET_CFG_CPU_CLOCK_HZ / 2) / baud_rate; 

	FNET_MPC_LIN_LINIBRR(port_number) = lfdivx16 / 16;	
	FNET_MPC_LIN_LINFBRR(port_number) = lfdivx16 % 16;
	
	FNET_MPC_LIN_CR1(port_number) = FNET_MPC_LIN_CR1(port_number) & 0x0000FFFE;

#endif		
}

#endif /*FNET_MPC*/
