/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_flash.c
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.3.0
*
* @brief On-chip Flash Module driver.
*
***************************************************************************/
#include "fnet_config.h" 
#include "fnet_flash.h" 
#include "fnet_cpu.h"
#include "fnet_stdlib.h"



#if !FNET_MPC && FNET_CFG_FLASH

static void fnet_flash_write_low( unsigned long *dest, unsigned long *src, unsigned int n_blocks );

/************************************************************************
* NAME: fnet_flash_erase
*
* DESCRIPTION:
************************************************************************/
void fnet_flash_erase( void *flash_addr, unsigned bytes)
{
    unsigned long n_pages;
    
    unsigned long page_shift = (unsigned long)flash_addr & (FNET_CFG_CPU_FLASH_PAGE_SIZE - 1);
    
    flash_addr = (void *)((unsigned long)flash_addr - page_shift);
    
    bytes += page_shift;
    
    n_pages = (unsigned long)( bytes/FNET_CFG_CPU_FLASH_PAGE_SIZE + ((bytes%FNET_CFG_CPU_FLASH_PAGE_SIZE)?1:0));

    while (n_pages)
    {
        fnet_cpu_flash_erase(flash_addr);
        flash_addr = (void *)((unsigned long)flash_addr + FNET_CFG_CPU_FLASH_PAGE_SIZE);
        n_pages --;
    }
}

/************************************************************************
* NAME: fnet_flash_write_low
*
* DESCRIPTION:
************************************************************************/
static void fnet_flash_write_low( unsigned long *dest, unsigned long *src, unsigned int n_blocks  )
{
    while (n_blocks)
    {
        fnet_cpu_flash_write(dest, *src);
        dest++;
        src++;
        n_blocks--;
    }
}

/************************************************************************
* NAME: fnet_flash_memcpy
*
* DESCRIPTION:
************************************************************************/
void fnet_flash_memcpy( void *flash_addr, const void *src, unsigned n  )
{
    int i;
    union 
    {
      unsigned char b_data[4];  
      unsigned long l_data;
    }
    data;    

    unsigned long bytes;
    unsigned long longs;
    unsigned long count;
    
    if(n)
    {
        count = (unsigned long)flash_addr & 0x3;
        
        /* Align dest. */
        if(count)
        {   
            flash_addr = (unsigned long *) ((unsigned long)flash_addr - count);
            bytes=4-count;

            if(bytes > n)
                bytes = n;

            data.l_data = 0xFFFFFFFF;            
            for(i=(int)(count); i<count+bytes; i++)
            {
                data.b_data[i] = *((unsigned char *)src); 
                src = (unsigned char *) ((unsigned long)src + 1);
            }
            
            fnet_flash_write_low( (unsigned long *)flash_addr, &data.l_data, 1 );
            
            flash_addr = (unsigned long *) ((unsigned long)flash_addr + 4);
            
            n-=bytes;   
        }
        
        if(n)
        {
            bytes = (n & 0x3);
		    longs = (n - bytes) >> 2;

            fnet_flash_write_low((unsigned long *)flash_addr, (unsigned long *)src, longs );
			
			flash_addr = (unsigned long *) ((unsigned long)flash_addr + 4*longs);
			src = (unsigned long *) ((unsigned long)src + 4*longs);
            
            if(bytes)
            {
                data.l_data = 0xFFFFFFFF;
                
                for(i=0;i<bytes;i++)
                {
                    data.b_data[i] = *((unsigned char *)src); 
                    src = (unsigned char *) ((unsigned long)src + 1);
                }

    		    fnet_flash_write_low((unsigned long *)flash_addr, &data.l_data, 1 );
            }
        
        }
    
    }

}

#endif
