/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_http_cgi.c
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.14.0
*
* @brief FNET HTTP server  CGI implementation.
*
***************************************************************************/

#include "fnet_config.h"

#if FNET_CFG_HTTP && FNET_CFG_HTTP_CGI

#include "fnet_http.h"
#include "fnet_http_prv.h"
#include "fnet_timer.h"
#include "fnet_eth.h"
#include "fnet_debug.h"
#include "fnet_stdlib.h"
#include "fnet_fs.h"


static int fnet_http_cgi_handle (struct fnet_http_if * http, struct fnet_http_uri * uri);
static unsigned long fnet_http_cgi_send (struct fnet_http_if * http);

/************************************************************************
*     Definitions
************************************************************************/

const struct fnet_http_file_handler fnet_http_cgi_handler =
{
    FNET_HTTP_CGI_EXTENSION,  
    fnet_http_cgi_handle, 
    fnet_http_cgi_send, 
    0
};

/************************************************************************
* NAME: fnet_http_cgi_handle
*
* DESCRIPTION: 
************************************************************************/
static int fnet_http_cgi_handle (struct fnet_http_if * http, struct fnet_http_uri * uri)
{
    int result = FNET_ERR;
    const struct fnet_http_cgi *cgi_ptr;
    
    if(http->cgi_table)
    /* CGI table is initialized.*/
    {
        /* Skip first '/' and ' ' */
        while(*uri->path == '/' || *uri->path == ' ')
            uri->path++;
        
        http->send_param.data_ptr = 0; /* Clear. */    
        
        /* Find CGI function */
        for(cgi_ptr = http->cgi_table; cgi_ptr->name; cgi_ptr++)
    	{
    	    if (!fnet_strncmp( uri->path, 
    		                   cgi_ptr->name,
    		                   fnet_strlen(cgi_ptr->name))) 
    		{				 
    		    http->send_param.data_ptr = (void*)cgi_ptr;
    		    if(cgi_ptr->handle)
    		        result = cgi_ptr->handle(uri->query, &http->response.cookie);
    		    else
    		        result = FNET_OK;
    		        
    	        break;
    	    }
    	}
	}
    return result;
}
/************************************************************************
* NAME: fnet_http_cgi_send
*
* DESCRIPTION: 
************************************************************************/
static unsigned long fnet_http_cgi_send (struct fnet_http_if * http)
{
    const struct fnet_http_cgi *cgi_ptr;
    unsigned long result = 0;
    
    if(http->send_param.data_ptr)
    {
        cgi_ptr = (const struct fnet_http_cgi *) http->send_param.data_ptr;
        
        if(cgi_ptr->send)
            result = cgi_ptr->send(http->buffer, sizeof(http->buffer), &http->response.send_eof, &http->response.cookie);
    }
    
        
    return result;
}



#endif
