/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_common.h"
#include "fsl_pca9420.h"
#include "fsl_dsp.h"
#include "board.h"
#include "dsp_support.h"
#include "pmic_support.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
void BOARD_DSP_Init(void)
{
#if DSP_IMAGE_COPY_TO_RAM
    dsp_copy_image_t tcm_image;
    dsp_copy_image_t sram_image;

    tcm_image.destAddr  = DSP_BOOT_ADDRESS;
    sram_image.destAddr = DSP_SRAM_ADDRESS;

#if defined(__CC_ARM)
    size = (uint32_t)&Image$$DSP_REGION$$Length;
#elif defined(__ICCARM__)
#pragma section = "__dsp_tcm_section"
#pragma section = "__dsp_sram_section"
    tcm_image.srcAddr  = DSP_IMAGE_TCM_START;
    tcm_image.size     = DSP_IMAGE_TCM_SIZE;
    sram_image.srcAddr = DSP_IMAGE_SRAM_START;
    sram_image.size    = DSP_IMAGE_SRAM_SIZE;
#elif defined(__GNUC__)
    tcm_image.srcAddr  = DSP_IMAGE_TCM_START;
    tcm_image.size     = DSP_IMAGE_TCM_SIZE;
    sram_image.srcAddr = DSP_IMAGE_SRAM_START;
    sram_image.size    = DSP_IMAGE_SRAM_SIZE;
#endif
#endif
    /* Initialize PMIC PCA9420 */
//    BOARD_InitPmic();
    /* Configure PMIC Vddcore value according to main/dsp clock. */
//    BOARD_SetPmicVoltageForFreq(CLOCK_GetMainClkFreq(), CLK_600MHZ);

    /* Enable DSP PLL clock 559MHz. */
    CLOCK_InitSysPfd(kCLOCK_Pfd1, 18);
    /*Let DSP run on DSP PLL clock with divider 1 (594Mhz). */
    CLOCK_AttachClk(kDSP_PLL_to_DSP_MAIN_CLK);
    CLOCK_SetClkDiv(kCLOCK_DivDspCpuClk, 1);
    CLOCK_SetClkDiv(kCLOCK_DivDspRamClk, 2);
    /* Initializing DSP core */
    DSP_Init();

#if DSP_IMAGE_COPY_TO_RAM
    /* Copy application from RAM to DSP_TCM */
    DSP_CopyImage(&tcm_image);

    /* Copy application from RAM to DSP_RAM */
    DSP_CopyImage(&sram_image);
#endif

    /* Run DSP core */
    DSP_Start();
}
