/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _DSP_SUPPORT_H_
#define _DSP_SUPPORT_H_

/*******************************************************************************
 * DEFINITION
 ******************************************************************************/
/* Address of RAM, where the image for dsp should be copied */
#define DSP_BOOT_ADDRESS (uint32_t *)0x24000000
#define DSP_SRAM_ADDRESS (uint32_t *)0x00300000

#if defined(__CC_ARM)
extern uint32_t Image$$DSP_REGION$$Base;
extern uint32_t Image$$DSP_REGION$$Length;
#define DSP_IMAGE_START &Image$$DSP_REGION$$Base
#elif defined(__ICCARM__)
#define DSP_IMAGE_TCM_START (uint32_t *)__section_begin("__dsp_tcm_section")
#define DSP_IMAGE_TCM_SIZE \
    (int32_t) __section_end("__dsp_tcm_section") - (uint32_t)__section_begin("__dsp_tcm_section");
#define DSP_IMAGE_SRAM_START (uint32_t *)__section_begin("__dsp_sram_section")
#define DSP_IMAGE_SRAM_SIZE \
    (int32_t) __section_end("__dsp_sram_section") - (uint32_t)__section_begin("__dsp_sram_section");
#elif (defined(__ARMCC_VERSION))
extern const char dsp_tcm_image_start[];
extern const char dsp_tcm_image_end[];
extern const char dsp_sram_image_start[];
extern const char dsp_sram_image_end[];
#define DSP_IMAGE_TCM_START ((uint32_t *)dsp_tcm_image_start)
#define DSP_IMAGE_TCM_SIZE ((uint32_t)dsp_tcm_image_end - (uint32_t)dsp_tcm_image_start)
#define DSP_IMAGE_SRAM_START ((uint32_t)dsp_sram_image_start)
#define DSP_IMAGE_SRAM_SIZE ((uint32_t)dsp_sram_image_end - (uint32_t)dsp_sram_image_start)
#elif defined(__GNUC__)
extern const char dsp_tcm_image_start[];
extern int dsp_tcm_image_size;
extern const char dsp_sram_image_start[];
extern int dsp_sram_image_size;
#define DSP_IMAGE_TCM_START ((uint32_t *)dsp_tcm_image_start)
#define DSP_IMAGE_TCM_SIZE ((int32_t)dsp_tcm_image_size)
#define DSP_IMAGE_SRAM_START ((uint32_t *)dsp_sram_image_start)
#define DSP_IMAGE_SRAM_SIZE ((int32_t)dsp_sram_image_size)
#endif
/*******************************************************************************
 * API
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

void BOARD_DSP_Init(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

#endif /* _DSP_SUPPORT_H_ */
