/* Use DSP Services with RPMSG messages */

#ifndef DSP_MESSAGE_H
#define DSP_MESSAGE_H

#include "fsl_common.h"

typedef enum {
    ARM_DSP_REQ_MASK = 0x1000,
    ARM_DSP_START_REMOTE_AUDIOSINK_REQ,
    ARM_DSP_STOP_REMOTE_AUDIOSINK_REQ,
    ARM_DSP_START_REMOTE_AUDIOSOURCE_REQ,
    ARM_DSP_STOP_REMOTE_AUDIOSOURCE_REQ,

    ARM_DSP_RSP_MASK = 0x2000,
    ARM_DSP_NEWDATA_RSP,

    ARM_DSP_IND_MASK = 0x4000,
    ARM_DSP_NEW_DATA_IND,

    DSP_ARM_REQ_MASK = 0x10000,
    DSP_ARM_NEWDATA_REQ,

    DSP_ARM_RSP_MASK = 0x20000,
    DSP_ARM_START_REMOTE_AUDIOSINK_RSP,
    DSP_ARM_STOP_REMOTE_AUDIOSINK_RSP,
    DSP_ARM_START_REMOTE_AUDIOSOURCE_RSP,
    DSP_ARM_STOP_REMOTE_AUDIOSOURCE_RSP,

    DSP_ARM_IND_MASK = 0x40000,
    DSP_ARM_NEW_DATA_IND,
} DSP_Message_Code;


#define DSP_MESSAGE_OPCODE(x) (x & 0xFF000) 


typedef enum {
    DSP_MESSAGE_RATE_UNCHANGED,
    DSP_MESSAGE_RATE_INCREASE,
    DSP_MESSAGE_RATE_DECREASE,
} DSP_Message_RateControl;

typedef struct _DSP_Message
{
    int32_t op_code;
    union{
        struct _DSP_Message_Req {
            int32_t param[7];
        } req;
        struct _DSP_Message_Rsp {
            int32_t error;
			int32_t param[6];
        } rsp;
        struct _DSP_Message_Ind {
            int32_t param[7];
        } ind;
        int32_t dummy[7];
    }u;
} DSP_Message;

#endif

