#include "fsl_inputmux.h"
#include "board.h"
#include "rpmsg_lite.h"
#include "rpmsg_queue.h"
#include "fsl_debug_console.h"

#include "FreeRTOS.h"
#include "queue.h"
#include "fsl_dsp.h"
#include "dsp_message.h"
#include "dsp_services.h"

#include "FreeRTOS.h"
#include "semphr.h"
#include "queue.h"
#include "dsp_support.h"

#define RPMSG_LITE_LINK_ID (0)
#define RPMSG_LITE_SHMEM_BASE (void *)0x202C0000
#define SH_MEM_TOTAL_SIZE_RPMSG (0x8000)
#define DATA_RECORD_SHMEM_BASE 0x202C8000
#define DATA_PLAYER_SHMEM_BASE 0x202D0000
#define ARM_DSP_REQUEST_QUEUE_LENGTH (10)

#define DSP_EPT_ADDR (30)
#define ARM_EPT_ADDR (40)
static struct rpmsg_lite_instance *arm_dsp_rpmsg = NULL;
static struct rpmsg_lite_endpoint *arm_dsp_endpoint_arm = NULL;
QueueHandle_t arm_dsp_msg_request_queue;
QueueHandle_t arm_dsp_msg_req_ack_sem;


void DSP_SendMessageToDSP(DSP_Message *p_dsp_message)
{
    BaseType_t xHigherPriorityTaskWoken;
    xQueueSendFromISR(arm_dsp_msg_request_queue, p_dsp_message, &xHigherPriorityTaskWoken);
	
    if(xHigherPriorityTaskWoken)
    {
        // Actual macro used here is port specific.
        portYIELD_FROM_ISR(xHigherPriorityTaskWoken);
    }
}

void DSPTask_Rx(void *Handle)
{
    rpmsg_queue_handle rpmsg_queue;
    volatile int32_t delay = 0x100000;
    DSP_Message dsp_message;
    int32_t message_source, len;
    int ret, request_counter = 0;
    int32_t counter = 0;
	uint32_t buffer_avail, buffer_all;
    /* MUB interrupt signal is selected for DSP interrupt input 1 */
    INPUTMUX_AttachSignal(INPUTMUX, 1U, kINPUTMUX_MuBToDspInterrupt); /* XCHAL_EXTINT2_NUM, intlevel 1 */

    /* Enable MUA clock before run DSP core */
    CLOCK_EnableClock(kCLOCK_Mu);
    RESET_PeripheralReset(kMU_RST_SHIFT_RSTn);

    PRINTF("DSP Start\n");

    BOARD_DSP_Init();
    while(delay-- > 0);
    arm_dsp_rpmsg = rpmsg_lite_master_init((void *)RPMSG_LITE_SHMEM_BASE, SH_MEM_TOTAL_SIZE_RPMSG, RPMSG_LITE_LINK_ID, RL_NO_FLAGS);
    rpmsg_queue = rpmsg_queue_create(arm_dsp_rpmsg);
	/* Callback runs in ISR context */
    arm_dsp_endpoint_arm = rpmsg_lite_create_ept(arm_dsp_rpmsg, ARM_EPT_ADDR, rpmsg_queue_rx_cb, rpmsg_queue);

    while(1) {
        rpmsg_queue_recv(arm_dsp_rpmsg, rpmsg_queue, &message_source, (char *)&dsp_message, sizeof(DSP_Message), &len, portMAX_DELAY);
        switch(DSP_MESSAGE_OPCODE(dsp_message.op_code))
        {
            case DSP_ARM_REQ_MASK:
            if(dsp_message.op_code == DSP_ARM_NEWDATA_REQ) {
                dsp_message.op_code = ARM_DSP_NEWDATA_RSP;
                if(request_counter == 0) {
                    buffer_avail = USB_AudioSpeakerBufferSpaceUsed();
                    buffer_all = USB_AudioSpeakerBufferSpaceAll();
                    if (buffer_avail >= ((buffer_all * 3) >> 2))
                    {
                        PRINTF("SINK RATE INCREASE\n");
                        request_counter = 100;
                        dsp_message.u.rsp.param[0] = DSP_MESSAGE_RATE_INCREASE;
                    } 
                    else if (buffer_avail <= ((buffer_all * 1) >> 2) && (buffer_avail != 0))
                    {
                        PRINTF("SINK RATE DECREASE\n");
                        request_counter = 100;
                        dsp_message.u.rsp.param[0] = DSP_MESSAGE_RATE_DECREASE;
                    }
                    else
                    {
                        dsp_message.u.rsp.param[0] = DSP_MESSAGE_RATE_UNCHANGED;
                    }
                } else {
                    request_counter--;
                    dsp_message.u.rsp.param[0] = DSP_MESSAGE_RATE_UNCHANGED;
                }
//                if((counter++) == 100) {
//                    PRINTF("Buffer Level %d%\n", (buffer_avail * 100)/buffer_all);
//                    counter = 0;
//                }				
                portENTER_CRITICAL();
                USB_AudioSpeakerGetBuffer(DATA_PLAYER_SHMEM_BASE, dsp_message.u.req.param[0]);
                xQueueSend(arm_dsp_msg_request_queue,&dsp_message, 0);
                portEXIT_CRITICAL();
            }
            break;
            case DSP_ARM_RSP_MASK:
            PRINTF("Get DSP Response 0x%x\n", dsp_message.op_code);
            xSemaphoreGive(arm_dsp_msg_req_ack_sem);
            break;
            case DSP_ARM_IND_MASK:
            if(dsp_message.op_code == DSP_ARM_NEW_DATA_IND) {
                portENTER_CRITICAL();
                USB_AudioRecorderPutBuffer(DATA_RECORD_SHMEM_BASE, dsp_message.u.ind.param[0]);
                portEXIT_CRITICAL();
            }
            break;
        }
    }
}

void DSPTask_Tx(void *Handle)
{
    DSP_Message dsp_message;
    int ret;
    arm_dsp_msg_request_queue = xQueueCreate(ARM_DSP_REQUEST_QUEUE_LENGTH, sizeof(DSP_Message));
    arm_dsp_msg_req_ack_sem = xSemaphoreCreateBinary();

    while(1) {
        xQueueReceive(arm_dsp_msg_request_queue, &dsp_message, portMAX_DELAY);
        switch(DSP_MESSAGE_OPCODE(dsp_message.op_code))
        {
            case ARM_DSP_REQ_MASK:
            PRINTF("DSP_SendMessageToDSP 0x%x\n", dsp_message.op_code);
            ret = rpmsg_lite_send(arm_dsp_rpmsg, arm_dsp_endpoint_arm, DSP_EPT_ADDR,
                                (char *)&dsp_message, sizeof(DSP_Message), RL_DONT_BLOCK);
            if (RL_SUCCESS == ret) {
                xSemaphoreTake(arm_dsp_msg_req_ack_sem, portMAX_DELAY);
            }
            break;
            case ARM_DSP_RSP_MASK:	
            case ARM_DSP_IND_MASK:
            ret = rpmsg_lite_send(arm_dsp_rpmsg, arm_dsp_endpoint_arm, DSP_EPT_ADDR,
                                (char *)&dsp_message, sizeof(DSP_Message), RL_DONT_BLOCK);
            break;
        }
    }
}

