/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <secure_gpio.h>
#include "board.h"
#include "pin_mux.h"
#include "fsl_device_registers.h"
#include "fsl_debug_console.h"

#include "fsl_inputmux.h"
#include "fsl_pint.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define DEMO_SECURE_SW1_GPIO SECGPIO
#define DEMO_SECURE_SW1_GPIO_PORT 0U
#define DEMO_SECURE_SW1_GPIO_PIN 10U

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
* Prototypes
*******************************************************************************/
void sec_pint_intr_callback(pint_pin_int_t pintr, uint32_t pmatch_status);

/*******************************************************************************
 * Code
 ******************************************************************************/
void sec_pint_intr_callback(pint_pin_int_t pintr, uint32_t pmatch_status)
{
    if (pintr == kPINT_PinInt0)
    {
    	PRINTF("\f\r\nSecure PINT SW1 Interrupt event detected.");
    }
}

void SecureGPIO_Init (void)
{
    /* Initialize secure GPIO for button SW1. */
    CLOCK_EnableClock(kCLOCK_ShsGpio0);
    RESET_PeripheralReset(kSHSGPIO0_RST_SHIFT_RSTn);
    GPIO_PinInit(DEMO_SECURE_SW1_GPIO, DEMO_SECURE_SW1_GPIO_PORT, DEMO_SECURE_SW1_GPIO_PIN, &(gpio_pin_config_t){kGPIO_DigitalInput, 0});

    /* Connect INPUTMUX trigger sources for button S1 */
    INPUTMUX_Init(INPUTMUX);
    INPUTMUX_AttachSignal(INPUTMUX, kPINT_PinInt0, kINPUTMUX_GpioPort0Pin10ToPintsel);
    INPUTMUX_Deinit(INPUTMUX);

    /* Initialize secure PINT for button SW1 */
    PINT_Init(PINT);
    PINT_PinInterruptConfig(PINT, kPINT_PinInt0, kPINT_PinIntEnableFallEdge, sec_pint_intr_callback);
    PINT_EnableCallbackByIndex(PINT, kPINT_PinInt0);
}

bool SecureGPIO_Mask (void)
{
	return (AHB_SECURE_CTRL->SEC_GPIO_MASK0 & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_MASK);
}
