/* ###################################################################
**     Filename    : main.c
**     Processor   : S32K11x
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.00
** @brief
**         Main module.
**         This module contains user's application code.
*/
/*!
**  @addtogroup main_module main module documentation
**  @{
*/
/* MODULE main */


/* Including necessary module. Cpu.h contains other modules needed for compiling.*/
#include "Cpu.h"
#include "pin_mux.h"
#include "clockMan1.h"
#include "lpuart0.h"
#include "dmaController1.h"
#include "adConv1.h"
#include "lpTmr1.h"
#include "main.h"
#include "freemaster.h"
#include "freemaster_example.h"
#include "timer.h"
#include "adc.h"
#include "ets.h"
#include "power_mode.h"

/*******************************************************************************
* Variables
*******************************************************************************/
volatile int exit_code = 0;
extern uint8_t  lowPowerModeCtrl, lowPowerModeEnable; /* Low power mode */
extern unsigned char DemoOnline;
unsigned char ActiveLED = 0;

/*******************************************************************************
* Function implementations
*******************************************************************************/
void BlinkingLED(void)
{
  if(DemoOnline == 0){
    if(ActiveLED < 20){
      PINS_DRV_SetPins(PTD,1<<16); /* GREEN LED OFF */
      PINS_DRV_ClearPins(PTE,1<<8); /* BLUE LED ON */
    }else{
      if(ActiveLED >= 20 && ActiveLED < 40){
        PINS_DRV_SetPins(PTE,1<<8); /* BLUE LED OFF */
        PINS_DRV_ClearPins(PTD,1<<15); /* RED LED ON */
      }else{
        if(ActiveLED >= 40){
          PINS_DRV_SetPins(PTD,1<<15); /* RED LED OFF */
          PINS_DRV_ClearPins(PTD,1<<16); /* GREEN LED ON */
        }
      }
    }
  }
}
void LPUART_transmit_char(LPUART_Type * base, char send);
/* FlexCAN0 init */
void FlexCAN_0_Init(void)
{
  int i = 0;

  /* FlexCAN0 TxD pin */
  /* Alternative 5 (CAN0_TX) */
  PORTE->PCR[5] = PORT_PCR_MUX(5) | PORT_PCR_DSE(1) | PORT_PCR_PE(0) | PORT_PCR_PS(1);
  /* FlexCAN0 RxD pin */
  /* Alternative 5 (CAN0_RX) */
  PORTE->PCR[4] = PORT_PCR_MUX(5) | PORT_PCR_PFE(0) | PORT_PCR_PE(1) | PORT_PCR_PS(1);
  /* Disable the FlexCAN module */
  CAN0->MCR |= CAN_MCR_MDIS_MASK;
  while((CAN0->MCR & CAN_MCR_NOTRDY_MASK)!=CAN_MCR_NOTRDY_MASK);
  /* Sets clock source */
  /* 40 MHz bus clock */
  CAN0->CTRL1 |= CAN_CTRL1_CLKSRC(1);
  /* Enable the FlexCAN module */
  CAN0->MCR &= ~CAN_MCR_MDIS_MASK;
  /* Wait for entering the freeze mode */
  while((CAN0->MCR & CAN_MCR_FRZACK_MASK ) == 0){}
  /* Set Final bit rate: 500 kbit/s @40MHz */
  /* set prescaler, phase segments, clock sourceand propagation segment */
  CAN0->CTRL1 = CAN_CTRL1_PRESDIV(7) | CAN_CTRL1_RJW(3) | CAN_CTRL1_PSEG1(3) | CAN_CTRL1_PSEG2(3) | CAN_CTRL1_PROPSEG(0);
  /* Set Masks */
  /* Sets RX Global Mask */
  CAN0->RXMGMASK = 0xFFFFFFFFUL;
  /* Sets RX MB14 Mask */
  CAN0->RX14MASK = 0xFFFFFFFFUL;
  /* RX MB15 Mask */
  CAN0->RX15MASK = 0xFFFFFFFFUL;
  /* Clear all MB flags */
  CAN0->IFLAG1 = 0xFFFFFFFFUL;
  /* Disable all MB interrupts */
  CAN0->IMASK1 = 0x00000000UL;
  /* Set maximum number of FlaxCAN MB to 16 (of 32 available) */
  CAN0->MCR &= ~CAN_MCR_MAXMB_MASK;
  CAN0->MCR |= CAN_MCR_MAXMB(15);
  /* Transmit a frame in nominal rate */
  /* 8 bytes per message buffer for region 0 */
  /* 8 bytes per message buffer for region 1 */
  CAN0->FDCTRL = CAN_FDCTRL_FDRATE(0) | CAN_FDCTRL_MBDSR0(0);
  /* Clear messages buffers */
  for(i=0;i<CAN_RAMn_COUNT;++i){
      CAN0->RAMn[i] = 0x0;
  }
  /* Enable CAN */
  /* Set No freeze mode request */
  /* Enable the FlexCAN module */
  CAN0->MCR &= ~( CAN_MCR_HALT_MASK | CAN_MCR_MDIS_MASK );
}

int main(void)
{

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  #ifdef PEX_RTOS_INIT
    PEX_RTOS_INIT();                   /* Initialization of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of Processor Expert internal initialization.                    ***/

  /* Initialize and configure clocks */
  CLOCK_SYS_Init(g_clockManConfigsArr, CLOCK_MANAGER_CONFIG_CNT, g_clockManCallbacksArr, CLOCK_MANAGER_CALLBACK_CNT);
  CLOCK_SYS_UpdateConfiguration(0U, CLOCK_MANAGER_POLICY_AGREEMENT);

  /* Wake-up timer */
  LPTMR0_Init(LPTMR_ELEC_CAL); /* Wake-up timer */

  /* Initialize ADC0 (sample time, samples number to average) */
  ADC0_Init(11, 0, RUN_FIRC);

  /* S32K116EVB-Q048 board - Setup Input Pins */
  PINS_DRV_Init(NUM_OF_CONFIGURED_PINS, g_pin_mux_InitConfigArr);

  /* Initialize FreeMASTER communication channel */
  #if FMSTR_USE_FLEXCAN
    /* Initialize FlexCAN0 */
    FlexCAN_0_Init(); /* Initialize FlexCAN */
  #elif FMSTR_USE_LPUART
    /* Initialize LPUART instance */
    LPUART_DRV_Init(INST_LPUART0, &lpuart0_State, &lpuart0_InitConfig0);
    INT_SYS_InstallHandler(LPUART0_RxTx_IRQn, FMSTR_Isr, NULL);
  #endif

  /* Touch Sense low power mode */
  lowPowerModeCtrl = OFF; /* Low power mode control disabled */
  lowPowerModeEnable = ON; /* Disable low power mode */

  /* Initialize FreeMASTER driver */
  FMSTR_Example_Init();

  /* Initialize Electrode TouchSense */
  electrodeTouchSenseInit();

  /* Enable IRQ for LPTMR */
  INT_SYS_InstallHandler(LPTMR0_IRQn, &LPTMR0_IRQHandler, (isr_t *)0); /* Install IRQ handler for LPTMR interrupt */
  INT_SYS_EnableIRQ(LPTMR0_IRQn);

  /* Loop forever */
  while(1){
    BlinkingLED(); /* blinking LEDs after startup */
    FMSTR_Example_Poll(); /* FreeMASTER polling */
  }

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;) {
    if(exit_code != 0) {
      break;
    }
  }
  return exit_code;
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/


void LPUART_transmit_char(LPUART_Type * base, char send) {    /* Function to Transmit single Char */
  while((base->STAT & LPUART_STAT_TDRE_MASK)>>LPUART_STAT_TDRE_SHIFT==0);
 uint8_t sendd = send;                   /* Wait for transmit buffer to be empty */
  base->DATA=sendd;              /* Send data */
}


/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.1 [05.21]
**     for the Freescale S32K series of microcontrollers.
**
** ###################################################################
*/

