/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
******************************************************************************/

/****************************************************************************//*!
*
* @file     timer.c
*
* @brief    Timer routines
*
*******************************************************************************/

/*******************************************************************************
* Includes
*******************************************************************************/
#include "device_registers.h"
#include "pcc.h"
#include "main.h"
#include "power_mode.h"
#include "ets.h"

/*****************************************************************************
*
* Function: void PCC_Init(void)
*
* Description: Init PCC
*
*****************************************************************************/
void PCC_Init(uint8_t mode)
{
    // PORTA 
    PCC->PCCn[PCC_PORTA_INDEX] = PCC_PCCn_CGC_MASK;
    // PORTB 
    PCC->PCCn[PCC_PORTB_INDEX] = PCC_PCCn_CGC_MASK;
    // PORTC 
    PCC->PCCn[PCC_PORTC_INDEX] = PCC_PCCn_CGC_MASK;
    // PORTD 
    PCC->PCCn[PCC_PORTD_INDEX] = PCC_PCCn_CGC_MASK;
    // PORTE 
    PCC->PCCn[PCC_PORTE_INDEX] = PCC_PCCn_CGC_MASK;


    switch (mode)
    {
    	case (RUN_PLL):
		{
    	    // LPTMR0
    		if(PCC->PCCn[PCC_LPTMR0_INDEX] & 0x40000000){PCC->PCCn[PCC_LPTMR0_INDEX]  = 0x80000000;}
    		PCC->PCCn[PCC_LPTMR0_INDEX] = 0xC6000000;		// enable clock, use PLLDIV2 clock, no clock division

    	    // ADC0
    	    if(PCC->PCCn[PCC_ADC0_INDEX] & 0x40000000){PCC->PCCn[PCC_ADC0_INDEX]  = 0x80000000;}
    	    PCC->PCCn[PCC_ADC0_INDEX] = 0xC6000000;			// enable clock, use PLLDIV2 clock, no clock division

#if(LOW_POWER_MODE == LPM_DISABLE)
    	    // LPUART1
    	    PCC->PCCn[PCC_PORTC_INDEX] = PCC_PCCn_CGC_MASK;
    	    PCC->PCCn[PCC_LPUART1_INDEX] = 0xC6000000;		// enable clock, use PLLDIV2 clock, no clock division
#endif

    		break;
		}
    	case (RUN_FIRC):
		{

    	    // LPTMR0
    		if(PCC->PCCn[PCC_LPTMR0_INDEX] & 0x40000000){PCC->PCCn[PCC_LPTMR0_INDEX]  = 0x80000000;}
    		PCC->PCCn[PCC_LPTMR0_INDEX] = 0xC3000000;		// enable clock, use FIRCDIV2 clock, no clock division

    	    // ADC0
    	    if(PCC->PCCn[PCC_ADC0_INDEX] & 0x40000000){PCC->PCCn[PCC_ADC0_INDEX]  = 0x80000000;}
    	    PCC->PCCn[PCC_ADC0_INDEX] = 0xC3000000;			// enable clock, use FIRCDIV2 clock, no clock division

#if(LOW_POWER_MODE == LPM_DISABLE)
    	    // LPUART1
    	    PCC->PCCn[PCC_PORTC_INDEX] = PCC_PCCn_CGC_MASK;
    	    PCC->PCCn[PCC_LPUART1_INDEX] = 0xC3000000;		// enable clock, use FIRCDIV2 clock, no clock division
#endif

    		break;
		}
    	case (VLPR):
		{

    	    // LPTMR0
    		if(PCC->PCCn[PCC_LPTMR0_INDEX] & 0x40000000){PCC->PCCn[PCC_LPTMR0_INDEX]  = 0x80000000;}
    		PCC->PCCn[PCC_LPTMR0_INDEX] = 0xC2000000;		// enable clock, use SIRCDIV2 clock, no clock division

    	    // ADC0
    	    if(PCC->PCCn[PCC_ADC0_INDEX] & 0x40000000){PCC->PCCn[PCC_ADC0_INDEX]  = 0x80000000;}
    	    PCC->PCCn[PCC_ADC0_INDEX] = 0xC2000000;			// enable clock, use SIRCDIV2 clock, no clock division

#if(LOW_POWER_MODE == LPM_DISABLE)
    	    // LPUART1
    	    PCC->PCCn[PCC_PORTC_INDEX] = PCC_PCCn_CGC_MASK;
    	    PCC->PCCn[PCC_LPUART1_INDEX] = 0xC2000000;			// enable clock, use SIRCDIV2 clock, no clock division
#endif

    		break;
		}
    }
}
