/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
******************************************************************************/

/****************************************************************************//*!
*
* @file     ets.h
*
* @brief    Electrode touch sense routines for S32K144
*
*******************************************************************************/
/*******************************************************************************
* Includes
*******************************************************************************/
#include "device_registers.h"
#include "ts_cfg_hw.h"
#include "ts_cfg_app.h"

/*******************************************************************************
* Calibration after power-up and reset
* Define number of cycles to calculate DC tracker power-up value
* LPTMR 1ms period
******************************************************************************/
#define NUMBER_OF_CYCLES_DCTRACKER_PWRUP  100

/*******************************************************************************
* Define number of cycles to calculate DC tracker power-up value
******************************************************************************/
#define DCTRACKER_PWRUP_INIT_DONE  0x0FFF

/*******************************************************************************
* PCR defines
******************************************************************************/
// Configure pin as GPIO, clear ISF, ISF disabled, ALT1=GPIO, high drive strength, disable pulls, fast slew rate
#define PCR_GPIO	0x01000140
// Configure pin as analog input
#define PCR_ANA		0x00000000

/*******************************************************************************
* Type defines
******************************************************************************/
typedef union
{
	uint8_t byte;
    struct
    {
    	uint8_t selfTrimDone:1;                // LSB
    	uint8_t na:7;                          // MSB
    }bit;
}tElecStatus;

typedef struct
{
	// Hardware
	ADC_Type   *adcBasePtr;
	uint32_t   adcChNum:32;
	PORT_Type  *portBasePtr;
	GPIO_Type  *gpioBasePtr;
	uint32_t   pinNumberElec:32;
	uint32_t   pinNumberCext:32;
	uint32_t   portMask:32;
}
tElecStruct;

/*******************************************************************************
* Function prototypes
******************************************************************************/
void electrodeTouchSenseInit(void);
void electrodeSelfTrimSense(void);
void electrodeWakeElecSense(void);
void electrodeWakeAndTouchElecSense(void);
void electrodeTouchElecSense(void);
