/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
******************************************************************************/

/****************************************************************************//*!
*
* @file     main.h
*
* @brief    Touch sense main for S32K144
*
*******************************************************************************/

/*******************************************************************************
* Interrupts
*******************************************************************************/
/*!< Macro to enable all interrupts. */
// This function enables IRQ interrupts by clearing the I-bit in the CPSR.
#define EnableInterrupts __asm__(" CPSIE i");

/*!< Macro to disable all interrupts. */
// This function disables IRQ interrupts by setting the I-bit in the CPSR.
#define DisableInterrupts __asm__(" CPSID i");

/* Set IRQ priority */
/* Accepts NVIC IRQ number (not the Cortex-M4F vector number) */
#define NVIC_SET_IRQ_PRIORITY_LEVEL(IrqNum,Priority)    (FSL_NVIC->IP[IrqNum] = ((Priority & 0x0F) << 4))

/* Enable IRQ */
/* Accepts NVIC IRQ number (not the Cortex-M4F vector number) */
#define NVIC_IRQ_ENABLE(IrqNum)                         (FSL_NVIC->ISER[IrqNum / 32] |= (1 << (IrqNum % 32)))

/* Disable IRQ */
/* Accepts NVIC IRQ number (not the Cortex-M4F vector number) */
#define NVIC_IRQ_DISABLE(IrqNum)                        (FSL_NVIC->ICER[IrqNum / 32] |= (1 << (IrqNum % 32)))

/*******************************************************************************
* Defines
*******************************************************************************/
#define YES   1
#define NO    0
#define ON    1
#define OFF   0
