/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
******************************************************************************/

/****************************************************************************//*!
*
* @file     power_mode.c
*
* @brief    Power modes for S32K144
*
*******************************************************************************/

/*******************************************************************************
* Includes
*******************************************************************************/
#include "power_mode.h"
#include "device_registers.h"
#include "main.h"

/*******************************************************************************
* Variables
******************************************************************************/
uint8_t  lowPowerModeCtrl, lowPowerModeEnable;

/*****************************************************************************
*
* Function: void Run_to_VLPS(void)
*
* Description: Enter VLPS. All main clocks are gated off.
*
*****************************************************************************/
void Run_to_VLPS(void)
{
	// Disable system oscillator clock monitor
	SCG->SOSCCSR &= ~SCG_SOSCCSR_SOSCCM_MASK;
	 // Enable very low power modes
	SMC->PMPROT |= SMC_PMPROT_AVLP_MASK;
	// Enable Stop Modes in the PMC
	SMC->PMCTRL |= SMC_PMCTRL_STOPM(0b10);
    // Transition from RUN to VLPS
	if(SMC->PMSTAT == RUN)
	{
		// Go to VLPS mode
		__asm__("WFI");
	}
	else
	{
		// Error trap
		while(1);
	}
}

/*****************************************************************************
*
* Function: void Run_to_VLPR(void)
*
* Description: Transition from RUN to VLPR
*
*****************************************************************************/
void Run_to_VLPR(void)
{
	if(SMC->PMSTAT==RUN)
	{
		SMC->PMCTRL=SMC_PMCTRL_RUNM(0b10);

		// Wait for transition
		while(SMC->PMSTAT!=VLPR)
		{};
	}
	else
	{
		// Error trap
		while(1);
	}
}

/*****************************************************************************
*
* Function: void Run_to_VLPR(void)
*
* Description:  Transition from VLPR to VLPW
*
*****************************************************************************/
void VLPR_to_VLPS(void)
{
	// Enable Stop Modes in the PMC
	SMC->PMCTRL|=SMC_PMCTRL_STOPM(0b10);

	if(SMC->PMSTAT==VLPR)
	{
		// Move to to VLPS
		asm("WFI");
	}
	else
	{
		// Error trap
		while(1);
	}
}
