/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
******************************************************************************/

/****************************************************************************//*!
*
* @file     timer.c
*
* @brief    Timer routines
*
*******************************************************************************/

/*******************************************************************************
* Includes
*******************************************************************************/
#include "device_registers.h"
#include "timer.h"
#include "main.h"
#include "ets.h"
#include "freemaster.h"
#define BITBAND_ACCESS32(Reg,Bit) (*((uint32_t volatile*)(0x42000000u + (32u*((uintptr_t)(Reg) - (uintptr_t)0x40000000u)) + (4u*((uintptr_t)(Bit))))))
/*******************************************************************************
* Variables
******************************************************************************/
// All electrodes status
extern tElecStatus  electrodesStatus;
extern unsigned char ActiveLED;

/*****************************************************************************
*
* Function: void LPTMR0_Init(uint32_t timeout)
*
* Description: Init LPTMR
*
*****************************************************************************/
void LPTMR0_Init(uint32_t timeout)
{
	// Disable LPTMR
	LPTMR0->CSR = 0x00000000;
	// Bypass prescaler
	LPTMR0->PSR = 0x00000005;
	// Set timeout period
	LPTMR0->CMR = timeout;
	// Clear TCF, enable interrupt, count rising edges, reset when TCF is set, counter mode, enable timer
	LPTMR0->CSR = 0x000000C1;
}

/*****************************************************************************
*
* Function: void LPTMR0_IRQHandler(void)
*
* Description: LPTMR interrupt
*
*****************************************************************************/
void LPTMR0_IRQHandler(void)
{
    // Clear TCF
    //BITBAND_ACCESS32(&LPTMR0->CSR,7) = 1;

    LPTMR0->CSR |= LPTMR_CSR_TCF_MASK;

    // Original EVB software - increase counter for RGB LED switching
    if(ActiveLED >= 60){ActiveLED = 0;}else{ActiveLED++;}

    // Electrodes self-trim done?
    if(electrodesStatus.bit.selfTrimDone == YES)
    {
        electrodeTouchElecSense();
    }else{
        // Self-trim electrodes after power-up / reset
    	electrodeSelfTrimSense();
    }
}
