/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
******************************************************************************/

/****************************************************************************//*!
*
* @file     ts_cfg_app.h
*
* @brief    Touch sense application configuration file
*
*******************************************************************************/
/*******************************************************************************
* Includes
*******************************************************************************/
#include "device_registers.h"
#include "ts_cfg_hw.h"

/*******************************************************************************
* Modify: Number of following electrode cycles per single sample
******************************************************************************/
// Value from 1 to 8
#define NUMBER_OF_ELECTRODE_SENSING_CYCLES_PER_SAMPLE    4

/*******************************************************************************
* Modify: Define electrodes sensing (scanning) cycle in miliseconds [ms]
******************************************************************************/
#define ELECTRODES_SENSE_PERIOD   25

/*******************************************************************************
* Modify: Number of IIR1 filters with different cutoff frequency used by an
*         application. Value can be either 1 or 2 or 3
******************************************************************************/
#define NUMBER_OF_FILTERS_USED  1

/*******************************************************************************
* Do not modify !
******************************************************************************/

#if (NUMBER_OF_FILTERS_USED > 0)
	#define FILTER_1     0
#endif

#if (NUMBER_OF_FILTERS_USED > 1)
	#define FILTER_2     1
#endif

#if (NUMBER_OF_FILTERS_USED > 2)
	#define FILTER_3     2
#endif

/*******************************************************************************
* Modify: Define filter parameters
*         Coefficients B0, B1 and A0 are dependent on filter cutoff frequency [Hz]
*         and electrode sensing period, see ELECTRODES_SENSE_PERIOD above.
*         Coefficient bellow calculated for filter sampling period 20ms
*         (see ELECTRODES_SENSE_PERIOD) using tool:
*         http://engineerjs.com/?sidebar=docs/iir.html
******************************************************************************/
#ifdef FILTER_1
	// Cutoff frequency in Hertz [Hz]
	#define FILTER_1_CUTOFF_FREQ_HZ    2
	// Coefficient B0
	#define FILTER_1_COEF_B0           0.1367
	// Coefficient B1
	#define FILTER_1_COEF_B1           0.1367
	// Coefficient A0
	#define FILTER_1_COEF_A0           -0.7265
#endif

#ifdef FILTER_2
	#define FILTER_2_CUTOFF_FREQ_HZ   1.5
	#define FILTER_2_COEF_B0          0.1058
	#define FILTER_2_COEF_B1          0.1058
	#define FILTER_2_COEF_A0          -0.7883
#endif

#ifdef FILTER_3
	#define FILTER_3_CUTOFF_FREQ_HZ   1
	#define FILTER_3_COEF_B0          0.07296
	#define FILTER_3_COEF_B1          0.07296
	#define FILTER_3_COEF_A0          -0.8541
#endif

/******************************************************************************
* Modify: Electrode 0 defines
******************************************************************************/
#ifdef ELEC0
	// DC tracker response, the highest number, the slower response.
	// Select values from 1 to 10
	#define ELEC0_DCTRACKER_FILTER_FACTOR     8
	// IIR1 LP filter selection
	#define ELEC0_LPFILTER_TYPE               FILTER_1
	// Touch threshold relative to DC tracker value
	#define ELEC0_TOUCH_THRESHOLD_DELTA       500
	// Release threshold relative to DC tracker value
	#define ELEC0_RELEASE_THRESHOLD_DELTA     300
#endif

/******************************************************************************
* Modify: Electrode 0 defines
******************************************************************************/
#ifdef ELEC1
	#define ELEC1_DCTRACKER_FILTER_FACTOR     8
	#define ELEC1_LPFILTER_TYPE               FILTER_1
	#define ELEC1_TOUCH_THRESHOLD_DELTA       500
	#define ELEC1_RELEASE_THRESHOLD_DELTA     300
#endif

/******************************************************************************
* Modify: Electrode 0 defines
******************************************************************************/
#ifdef ELEC2
	#define ELEC2_DCTRACKER_FILTER_FACTOR     8
	#define ELEC2_LPFILTER_TYPE               FILTER_1
	#define ELEC2_TOUCH_THRESHOLD_DELTA       18
	#define ELEC2_RELEASE_THRESHOLD_DELTA     15
#endif
