/******************************************************************************
*
* Copyright 2006-2015 Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
*
******************************************************************************/

/****************************************************************************//*!
*
* @file     ts_cfg_hw.h
*
* @brief    Touch sense application hardware configuration file
*
*******************************************************************************/
/*******************************************************************************
* Includes
*******************************************************************************/
#include "device_registers.h"

/*******************************************************************************
* Do not modify !
******************************************************************************/
#define WAKE_ELEC_YES    1
#define WAKE_ELEC_NO     0
#define LPM_ENABLE       1
#define LPM_DISABLE      0

/*******************************************************************************
* Modify: Define number of electrodes
******************************************************************************/
// Number of touch button electrodes from 1 to 10
#define NUMBER_OF_TOUCH_ELECTRODES   1

/*******************************************************************************
* Do not modify !
******************************************************************************/
#define NUMBER_OF_ELECTRODES   NUMBER_OF_TOUCH_ELECTRODES

/*******************************************************************************
* Modify: Electrode 0 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 0)
	#define ELEC0
	#define ELEC0_ADC             ADC0      // Modify: ADC module
	#define ELEC0_ADC_CHANNEL     14        // Modify: Cext ADC channel
	#define ELEC0_PORT            PORTC     // Modify: Electrode and Cext PORT
	#define ELEC0_GPIO            PTC       // Modify: Electrode and Cext GPIO
	#define ELEC0_ELEC_GPIO_PIN   1         // Modify: Electrode GPIO pin
	#define ELEC0_CEXT_GPIO_PIN   16         // Modify: Cext GPIO pin
	#define ELEC0_PORT_MASK       (1 << ELEC0_ELEC_GPIO_PIN) | (1 << ELEC0_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 1 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 1)
	#define ELEC1
	#define ELEC1_ADC             ADC0
	#define ELEC1_ADC_CHANNEL     11
	#define ELEC1_PORT            PORTC
	#define ELEC1_GPIO            PTC
	#define ELEC1_ELEC_GPIO_PIN   1
	#define ELEC1_CEXT_GPIO_PIN   3
	#define ELEC1_PORT_MASK       (1 << ELEC1_ELEC_GPIO_PIN) | (1 << ELEC1_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 2 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 2)
	#define ELEC2
	#define ELEC2_ADC             ADC0
	#define ELEC2_ADC_CHANNEL     1
	#define ELEC2_PORT            PORTA
	#define ELEC2_GPIO            PTA
	#define ELEC2_ELEC_GPIO_PIN   0
	#define ELEC2_CEXT_GPIO_PIN   1
	#define ELEC2_PORT_MASK       (1 << ELEC2_ELEC_GPIO_PIN) | (1 << ELEC2_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 3 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 3)
	#define ELEC3
	#define ELEC3_ADC
	#define ELEC3_ADC_CHANNEL
	#define ELEC3_PORT
	#define ELEC3_GPIO
	#define ELEC3_ELEC_GPIO_PIN
	#define ELEC3_CEXT_GPIO_PIN
	#define ELEC3_PORT_MASK       (1 << ELEC3_ELEC_GPIO_PIN) | (1 << ELEC3_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 4 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 4)
	#define ELEC4
	#define ELEC4_ADC
	#define ELEC4_ADC_CHANNEL
	#define ELEC4_PORT
	#define ELEC4_GPIO
	#define ELEC4_ELEC_GPIO_PIN
	#define ELEC4_CEXT_GPIO_PIN
	#define ELEC4_PORT_MASK       (1 << ELEC4_ELEC_GPIO_PIN) | (1 << ELEC4_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 5 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 5)
	#define ELEC5
	#define ELEC5_ADC
	#define ELEC5_ADC_CHANNEL
	#define ELEC5_PORT
	#define ELEC5_GPIO
	#define ELEC5_ELEC_GPIO_PIN
	#define ELEC5_CEXT_GPIO_PIN
	#define ELEC5_PORT_MASK       (1 << ELEC5_ELEC_GPIO_PIN) | (1 << ELEC5_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 6 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 6)
	#define ELEC6
	#define ELEC6_ADC
	#define ELEC6_ADC_CHANNEL
	#define ELEC6_PORT
	#define ELEC6_GPIO
	#define ELEC6_ELEC_GPIO_PIN
	#define ELEC6_CEXT_GPIO_PIN
	#define ELEC6_PORT_MASK       (1 << ELEC6_ELEC_GPIO_PIN) | (1 << ELEC6_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 7 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 7)
	#define ELEC7
	#define ELEC7_ADC
	#define ELEC7_ADC_CHANNEL
	#define ELEC7_PORT
	#define ELEC7_GPIO
	#define ELEC7_ELEC_GPIO_PIN
	#define ELEC7_CEXT_GPIO_PIN
	#define ELEC7_PORT_MASK       (1 << ELEC7_ELEC_GPIO_PIN) | (1 << ELEC7_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 8 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 8)
	#define ELEC8
	#define ELEC8_ADC
	#define ELEC8_ADC_CHANNEL
	#define ELEC8_PORT
	#define ELEC8_GPIO
	#define ELEC8_ELEC_GPIO_PIN
	#define ELEC8_CEXT_GPIO_PIN
	#define ELEC8_PORT_MASK       (1 << ELEC8_ELEC_GPIO_PIN) | (1 << ELEC8_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 9 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 9)
	#define ELEC9
	#define ELEC9_ADC
	#define ELEC9_ADC_CHANNEL
	#define ELEC9_PORT
	#define ELEC9_GPIO
	#define ELEC9_ELEC_GPIO_PIN
	#define ELEC9_CEXT_GPIO_PIN
	#define ELEC9_PORT_MASK       (1 << ELEC9_ELEC_GPIO_PIN) | (1 << ELEC9_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Electrode 10 defines
******************************************************************************/
#if (NUMBER_OF_ELECTRODES > 10)
	#define ELEC10
	#define ELEC10_ADC
	#define ELEC10_ADC_CHANNEL
	#define ELEC10_PORT
	#define ELEC10_GPIO
	#define ELEC10_ELEC_GPIO_PIN
	#define ELEC10_CEXT_GPIO_PIN
	#define ELEC10_PORT_MASK      (1 << ELEC10_ELEC_GPIO_PIN) | (1 << ELEC10_CEXT_GPIO_PIN)
#endif

/*******************************************************************************
* Modify: Low power mode enable
*         If low power mode is enabled (LPM_ENABLE), the application debug and
*         FreeMASTER data visualization are disabled.
*         If low power mode is disabled (LPM_DISABLE), the application debug and
*         FreeMASTER data visualization are enabled.
******************************************************************************/
#define LOW_POWER_MODE   LPM_DISABLE

// Defined?
#ifdef DEBUG_ELECTRODE_SENSE
	// Assign PORT
	#define DES_PORT  PORTB
	// Assign GPIO
	#define DES_GPIO  PTB
	// Assign pin
	#define DES_PIN   3

#endif

// Defined?
#ifdef DEBUG_ALGORITHM
	// Assign PORT
	#define DA_PORT  PORTB
	// Assign GPIO
	#define DA_GPIO  PTB
	// Assign pin
	#define DA_PIN   2
#endif
