/* ---------------------------------------------------------------------------------------*/
/*  @file:    startup_S32K144.s                                                           */
/*  @purpose: CMSIS Cortex-M4 Core Device Startup File                                    */
/*            S32K144                                                                     */
/*  @version: 1.0                                                                         */
/*  @date:    2015-4-9                                                                    */
/*  @build:   b150416                                                                     */
/* ---------------------------------------------------------------------------------------*/
/*                                                                                        */
/* Copyright (c) 1997 - 2015 , Freescale Semiconductor, Inc.                              */
/* All rights reserved.                                                                   */
/*                                                                                        */
/* Redistribution and use in source and binary forms, with or without modification,       */
/* are permitted provided that the following conditions are met:                          */
/*                                                                                        */
/* o Redistributions of source code must retain the above copyright notice, this list     */
/*   of conditions and the following disclaimer.                                          */
/*                                                                                        */
/* o Redistributions in binary form must reproduce the above copyright notice, this       */
/*   list of conditions and the following disclaimer in the documentation and/or          */
/*   other materials provided with the distribution.                                      */
/*                                                                                        */
/* o Neither the name of Freescale Semiconductor, Inc. nor the names of its               */
/*   contributors may be used to endorse or promote products derived from this            */
/*   software without specific prior written permission.                                  */
/*                                                                                        */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND        */
/* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED          */
/* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                 */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR       */
/* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         */
/* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;           */
/* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON         */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT                */
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                           */
/*****************************************************************************/
/* Version: GCC for ARM Embedded Processors                                  */
/*****************************************************************************/
    .syntax unified
    .arch armv7-m

    .section .isr_vector, "a"
    .align 2
    .globl __isr_vector
__isr_vector:
    .long   __StackTop                                      /* Top of Stack */
    .long   Reset_Handler                                   /* Reset Handler */
    .long   NMI_Handler                                     /* NMI Handler*/
    .long   HardFault_Handler                               /* Hard Fault Handler*/
    .long   MemManage_Handler                               /* MPU Fault Handler*/
    .long   BusFault_Handler                                /* Bus Fault Handler*/
    .long   UsageFault_Handler                              /* Usage Fault Handler*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   SVC_Handler                                     /* SVCall Handler*/
    .long   DebugMon_Handler                                /* Debug Monitor Handler*/
    .long   0                                               /* Reserved*/
    .long   PendSV_Handler                                  /* PendSV Handler*/
    .long   SysTick_Handler                                 /* SysTick Handler*/

                                                            /* External Interrupts*/
    .long   DMA0_IRQHandler                                 /* DMA channel 0 transfer complete*/
    .long   DMA1_IRQHandler                                 /* DMA channel 1 transfer complete*/
    .long   DMA2_IRQHandler                                 /* DMA channel 2 transfer complete*/
    .long   DMA3_IRQHandler                                 /* DMA channel 3 transfer complete*/
    .long   DMA4_IRQHandler                                 /* DMA channel 4 transfer complete*/
    .long   DMA5_IRQHandler                                 /* DMA channel 5 transfer complete*/
    .long   DMA6_IRQHandler                                 /* DMA channel 6 transfer complete*/
    .long   DMA7_IRQHandler                                 /* DMA channel 7 transfer complete*/
    .long   DMA8_IRQHandler                                 /* DMA channel 8 transfer complete*/
    .long   DMA9_IRQHandler                                 /* DMA channel 9 transfer complete*/
    .long   DMA10_IRQHandler                                /* DMA channel 10 transfer complete*/
    .long   DMA11_IRQHandler                                /* DMA channel 11 transfer complete*/
    .long   DMA12_IRQHandler                                /* DMA channel 12 transfer complete*/
    .long   DMA13_IRQHandler                                /* DMA channel 13 transfer complete*/
    .long   DMA14_IRQHandler                                /* DMA channel 14 transfer complete*/
    .long   DMA15_IRQHandler                                /* DMA channel 15 transfer complete*/
    .long   DMA_Error_IRQHandler                            /* DMA error interrupt channels 0-15*/
    .long   MCM_IRQHandler                                  /* FPU sources*/
    .long   FTFE_IRQHandler                                 /* FTFE command complete*/
    .long   Read_Collision_IRQHandler                       /* FTFE read collision*/
    .long   LVD_LVW_IRQHandler                              /* PMC controller low-voltage detect, low-voltage warning*/
    .long   Reserved37_IRQHandler                           /* Reserved interrupt*/
    .long   Watchdog_IRQHandler                             /* Single interrupt vector for  WDOG and EWM*/
    .long   Reserved39_IRQHandler                           /* Reserved interrupt*/
    .long   LPI2C0_IRQHandler                               /* Inter-integrated circuit 0*/
    .long   LPI2C1_IRQHandler                               /* Inter-integrated circuit 1*/
    .long   LPSPI0_IRQHandler                               /* Serial peripheral Interface 0*/
    .long   LPSPI1_IRQHandler                               /* Serial peripheral Interface 1*/
    .long   LPSPI2_IRQHandler                               /* Serial peripheral Interface 2*/
    .long   Reserved45_IRQHandler                           /* Reserved interrupt*/
    .long   Reserved46_IRQHandler                           /* Reserved interrupt*/
    .long   LPUART0_RxTx_IRQHandler                         /* LPUART0 receive/transmit interrupt*/
    .long   LPUART0_Error_IRQHandler                        /* LPUART0 receive/transmit/error interrupt*/
    .long   LPUART1_RxTx_IRQHandler                         /* LPUART1 receive/transmit interrupt*/
    .long   LPUART1_Error_IRQHandler                        /* LPUART1 receive/transmit/error interrupt*/
    .long   LPUART2_RxTx_IRQHandler                         /* LPUART2 receive/transmit interrupt*/
    .long   LPUART2_Error_IRQHandler                        /* LPUART2 receive/transmit/error interrupt*/
    .long   LPUART3_RxTx_IRQHandler                         /* LPUART3 receive/transmit interrupt*/
    .long   LPUART3_Error_IRQHandler                        /* LPUART3 receive/transmit/error interrupt*/
    .long   ADC0_IRQHandler                                 /* ADC conversion complete interrupt*/
    .long   ACMP0_IRQHandler                                /* ACMP0 interrupt*/
    .long   ACMP1_IRQHandler                                /* ACMP1 interrupt*/
    .long   FTM0_IRQHandler                                 /* FTM0 single interrupt vector for all sources*/
    .long   FTM1_IRQHandler                                 /* FTM1 single interrupt vector for all sources*/
    .long   FTM2_IRQHandler                                 /* FTM2 single interrupt vector for all sources*/
    .long   Reserved61_IRQHandler                           /* Reserved interrupt*/
    .long   RTC_IRQHandler                                  /* RTC overflow*/
    .long   RTC_Seconds_IRQHandler                          /* RTC overflow*/
    .long   LPIT0_Ch0_IRQHandler                            /* LPIT CH0 overflow*/
    .long   LPIT0_Ch1_IRQHandler                            /* LPIT CH1 overflow*/
    .long   LPIT0_Ch2_IRQHandler                            /* LPIT CH2 overflow*/
    .long   LPIT0_Ch3_IRQHandler                            /* LPIT CH3 overflow*/
    .long   PDB0_IRQHandler                                 /* Programmable delay block*/
    .long   Reserved69_IRQHandler                           /* Reserved interrupt*/
    .long   Reserved70_IRQHandler                           /* Reserved interrupt*/
    .long   Reserved71_IRQHandler                           /* Reserved interrupt*/
    .long   DAC0_IRQHandler                                 /* Digital-to-analog converter 0*/
    .long   SCG_IRQHandler                                  /* Multipurpose clock generator*/
    .long   LPTMR0_IRQHandler                               /* Single interrupt vector for  Low Power Timer 0*/
    .long   PORTA_IRQHandler                                /* Port A pin detect interrupt*/
    .long   PORTB_IRQHandler                                /* Port B pin detect interrupt*/
    .long   PORTC_IRQHandler                                /* Port C pin detect interrupt*/
    .long   PORTD_IRQHandler                                /* Port D pin detect interrupt*/
    .long   PORTE_IRQHandler                                /* Port E pin detect interrupt*/
    .long   SWI_IRQHandler                                  /* Software interrupt*/
    .long   Reserved81_IRQHandler                           /* Reserved interrupt*/
    .long   Reserved82_IRQHandler                           /* Reserved interrupt*/
    .long   Reserved83_IRQHandler                           /* Reserved interrupt*/
    .long   PDB1_IRQHandler                                 /* Programmable delay block*/
    .long   FLEXIO_IRQHandler                               /* FLEXIO*/
    .long   ACMP2_IRQHandler                                /* Comparator 2*/
    .long   FTM3_IRQHandler                                 /* FlexTimer module 3 fault, overflow and channels interrupt*/
    .long   Reserved88_IRQHandler                           /* Reserved interrupt*/
    .long   ADC1_IRQHandler                                 /* ADC conversion complete interrupt*/
    .long   ADC2_IRQHandler                                 /* ADC conversion complete interrupt*/
    .long   EMVSIM_IRQHandler                               /* EMVSIM common interrupt*/
    .long   TSI_IRQHandler                                  /* Touch Sensing Input Interrupt*/
    .long   PDB2_IRQHandler                                 /* Programmable delay block*/
    .long   CAN0_Ored_IRQHandler                            /* can*/
    .long   CAN0_Error_IRQHandler                           /* can*/
    .long   CAN0_Wakeup_IRQHandler                          /* can*/
    .long   CAN0_Oredbuf_IRQHandler                         /* can*/
    .long   CAN0_Reserved1_IRQHandler                       /* can*/
    .long   CAN0_Reserved2_IRQHandler                       /* can*/
    .long   CAN0_Reserved3_IRQHandler                       /* can*/
    .long   CAN1_Ored_IRQHandler                            /* can*/
    .long   CAN1_Error_IRQHandler                           /* can*/
    .long   CAN1_Wakeup_IRQHandler                          /* can*/
    .long   CAN1_Oredbuf_IRQHandler                         /* can*/
    .long   CAN1_Reserved1_IRQHandler                       /* can*/
    .long   CAN1_Reserved2_IRQHandler                       /* can*/
    .long   CAN1_Reserved3_IRQHandler                       /* can*/
    .long   CAN2_Ored_IRQHandler                            /* can*/
    .long   CAN2_Error_IRQHandler                           /* can*/
    .long   CAN2_Wakeup_IRQHandler                          /* can*/
    .long   CAN2_Oredbuf_IRQHandler                         /* can*/
    .long   CAN2_Reserved1_IRQHandler                       /* can*/
    .long   CAN2_Reserved2_IRQHandler                       /* can*/
    .long   CAN2_Reserved3_IRQHandler                       /* can*/

    .text
    .thumb

/* Reset Handler */
    .thumb_func
    .align 2
    .globl   Reset_Handler
    .weak    Reset_Handler
    .type    Reset_Handler, %function
Reset_Handler:
    cpsid   i               /* Mask interrupts */
	
        // Init the rest of the registers
        ldr     r2,=0
        ldr     r3,=0
        ldr     r4,=0
        ldr     r5,=0
        ldr     r6,=0
        ldr     r7,=0
        mov     r8,r7
        mov     r9,r7
        mov     r10,r7
        mov     r11,r7
        mov     r12,r7

        // Initialize the stack pointer
        ldr     r0,=__StackTop
        mov     r13,r0
		
/*#ifndef __NO_SYSTEM_INIT*/
        // Call the CMSIS system init routine
		//    bl SystemInit
        ldr     r0,=SystemInit
        blx     r0
/*#endif*/

        // Init .data and .bss sections
        ldr     r0,=init_data_bss
        blx     r0

        // Init interrupts
        //ldr     r0,=init_interrupts
        //blx     r0



  /*  bl init_data_bss*/
    cpsie   i               /* Unmask interrupts */
    bl    main
    .pool
    .size Reset_Handler, . - Reset_Handler

    .align	1
    .thumb_func
    .weak DefaultISR
    .type DefaultISR, %function
DefaultISR:
    b	DefaultISR
    .size DefaultISR, . - DefaultISR

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
    .macro def_irq_handler	handler_name
    .weak \handler_name
    .set  \handler_name, DefaultISR
    .endm

/* Exception Handlers */
    def_irq_handler    NMI_Handler
    def_irq_handler    HardFault_Handler
    def_irq_handler    MemManage_Handler
    def_irq_handler    BusFault_Handler
    def_irq_handler    UsageFault_Handler
    def_irq_handler    SVC_Handler
    def_irq_handler    DebugMon_Handler
    def_irq_handler    PendSV_Handler
    def_irq_handler    SysTick_Handler
    def_irq_handler    DMA0_IRQHandler
    def_irq_handler    DMA1_IRQHandler
    def_irq_handler    DMA2_IRQHandler
    def_irq_handler    DMA3_IRQHandler
    def_irq_handler    DMA4_IRQHandler
    def_irq_handler    DMA5_IRQHandler
    def_irq_handler    DMA6_IRQHandler
    def_irq_handler    DMA7_IRQHandler
    def_irq_handler    DMA8_IRQHandler
    def_irq_handler    DMA9_IRQHandler
    def_irq_handler    DMA10_IRQHandler
    def_irq_handler    DMA11_IRQHandler
    def_irq_handler    DMA12_IRQHandler
    def_irq_handler    DMA13_IRQHandler
    def_irq_handler    DMA14_IRQHandler
    def_irq_handler    DMA15_IRQHandler
    def_irq_handler    DMA_Error_IRQHandler
    def_irq_handler    MCM_IRQHandler
    def_irq_handler    FTFE_IRQHandler
    def_irq_handler    Read_Collision_IRQHandler
    def_irq_handler    LVD_LVW_IRQHandler
    def_irq_handler    Reserved37_IRQHandler
    def_irq_handler    Watchdog_IRQHandler
    def_irq_handler    Reserved39_IRQHandler
    def_irq_handler    LPI2C0_IRQHandler
    def_irq_handler    LPI2C1_IRQHandler
    def_irq_handler    LPSPI0_IRQHandler
    def_irq_handler    LPSPI1_IRQHandler
    def_irq_handler    LPSPI2_IRQHandler
    def_irq_handler    Reserved45_IRQHandler
    def_irq_handler    Reserved46_IRQHandler
    def_irq_handler    LPUART0_RxTx_IRQHandler
    def_irq_handler    LPUART0_Error_IRQHandler
    def_irq_handler    LPUART1_RxTx_IRQHandler
    def_irq_handler    LPUART1_Error_IRQHandler
    def_irq_handler    LPUART2_RxTx_IRQHandler
    def_irq_handler    LPUART2_Error_IRQHandler
    def_irq_handler    LPUART3_RxTx_IRQHandler
    def_irq_handler    LPUART3_Error_IRQHandler
    def_irq_handler    ADC0_IRQHandler
    def_irq_handler    ACMP0_IRQHandler
    def_irq_handler    ACMP1_IRQHandler
    def_irq_handler    FTM0_IRQHandler
    def_irq_handler    FTM1_IRQHandler
    def_irq_handler    FTM2_IRQHandler
    def_irq_handler    Reserved61_IRQHandler
    def_irq_handler    RTC_IRQHandler
    def_irq_handler    RTC_Seconds_IRQHandler
    def_irq_handler    LPIT0_Ch0_IRQHandler
    def_irq_handler    LPIT0_Ch1_IRQHandler
    def_irq_handler    LPIT0_Ch2_IRQHandler
    def_irq_handler    LPIT0_Ch3_IRQHandler
    def_irq_handler    PDB0_IRQHandler
    def_irq_handler    Reserved69_IRQHandler
    def_irq_handler    Reserved70_IRQHandler
    def_irq_handler    Reserved71_IRQHandler
    def_irq_handler    DAC0_IRQHandler
    def_irq_handler    SCG_IRQHandler
    def_irq_handler    LPTMR0_IRQHandler
    def_irq_handler    PORTA_IRQHandler
    def_irq_handler    PORTB_IRQHandler
    def_irq_handler    PORTC_IRQHandler
    def_irq_handler    PORTD_IRQHandler
    def_irq_handler    PORTE_IRQHandler
    def_irq_handler    SWI_IRQHandler
    def_irq_handler    Reserved81_IRQHandler
    def_irq_handler    Reserved82_IRQHandler
    def_irq_handler    Reserved83_IRQHandler
    def_irq_handler    PDB1_IRQHandler
    def_irq_handler    FLEXIO_IRQHandler
    def_irq_handler    ACMP2_IRQHandler
    def_irq_handler    FTM3_IRQHandler
    def_irq_handler    Reserved88_IRQHandler
    def_irq_handler    ADC1_IRQHandler
    def_irq_handler    ADC2_IRQHandler
    def_irq_handler    EMVSIM_IRQHandler
    def_irq_handler    TSI_IRQHandler
    def_irq_handler    PDB2_IRQHandler
    def_irq_handler    CAN0_Ored_IRQHandler
    def_irq_handler    CAN0_Error_IRQHandler
    def_irq_handler    CAN0_Wakeup_IRQHandler
    def_irq_handler    CAN0_Oredbuf_IRQHandler
    def_irq_handler    CAN0_Reserved1_IRQHandler
    def_irq_handler    CAN0_Reserved2_IRQHandler
    def_irq_handler    CAN0_Reserved3_IRQHandler
    def_irq_handler    CAN1_Ored_IRQHandler
    def_irq_handler    CAN1_Error_IRQHandler
    def_irq_handler    CAN1_Wakeup_IRQHandler
    def_irq_handler    CAN1_Oredbuf_IRQHandler
    def_irq_handler    CAN1_Reserved1_IRQHandler
    def_irq_handler    CAN1_Reserved2_IRQHandler
    def_irq_handler    CAN1_Reserved3_IRQHandler
    def_irq_handler    CAN2_Ored_IRQHandler
    def_irq_handler    CAN2_Error_IRQHandler
    def_irq_handler    CAN2_Wakeup_IRQHandler
    def_irq_handler    CAN2_Oredbuf_IRQHandler
    def_irq_handler    CAN2_Reserved1_IRQHandler
    def_irq_handler    CAN2_Reserved2_IRQHandler
    def_irq_handler    CAN2_Reserved3_IRQHandler

    .end
