/*
 * main implementation: use this 'C' sample to create your own application
 *
 */


#include "derivative.h" /* include peripheral declarations S32K144 */
void delay(volatile int cycles);
int main(void)
{
	int counter = 0;
    WDOG->CNT = 0xD928C520;                // unlock watchdog
    WDOG->TOVAL = 0x0000FFFF;            // maximum timeout value
    WDOG->CS = 0x00002100;                // disable watchdog

    PCC->PCCn[PCC_PORTD_INDEX ]|=PCC_PCCn_CGC_MASK; /* Enable clock for PORTD */
	PORTD->PCR[0]|=PORT_PCR_MUX(0b001);  /* Select PTD0 MUX as GPIO */
	PORTD->PCR[16]|=PORT_PCR_MUX(0b001);  /* Select PTD16 MUX as GPIO */
	PORTD->PCR[15]|=PORT_PCR_MUX(0b001);  /* Select PTD15 MUX as GPIO */

	PTD->PDDR |= 1<<0; /*PTD0 as Output*/
	PTD->PDDR |= 1<<16; /*PTD16 as Output*/
	PTD->PDDR |= 1<<15; /*PTD15 as Output*/
	PTD->PSOR|=1<<0;
	PTD->PSOR|=1<<15;
	PTD->PSOR|=1<<16;


	for(;;) {
   		/*Toggle Blue LED*/
   		PTD->PCOR|=1<<0;
	   	 delay(3000000);
		/*Toggle Blue LED*/
		PTD->PSOR|=1<<0;

		/*Toggle Red LED*/
		PTD->PCOR|=1<<15;
	   	 delay(3000000);
		/*Toggle Red LED*/
		PTD->PSOR|=1<<15;

		/*Toggle Green LED*/
		PTD->PCOR|=1<<16;
		 delay(3000000);
		/*Toggle Green LED*/
		PTD->PSOR|=1<<16;
	}
	return 0;
}
void delay(volatile int cycles)
{
    /* Delay function - do nothing for a number of cycles */
    while(cycles--);
}
