#include "common.h" /* include peripheral declarations */

#if 0
#ifdef SIM_DEFINES

  /**********STARTFUNC**************************************************
   * Name:  SIM_CLKOUT
   * Purpose: Bringing a particular clock on CLKOUT for observability
   * Algorithm:
   * Inputs:	clk : Clock which has to be observed
   * 		      pad : selects the pad on which the CLKOUT will come
   * Outputs: NONE
   * Return value: NONE
   * Assumptions : NONE
   * Child Functions : NONE
   *
   ***********ENDFUNC***************************************************/
  void SIM_CLKOUT(SIM_CLKOUT_CLK_T clk,SIM_CLKOUT_PAD_T pad) {

    // configure CLKOUT to come on Chip PAD
    if(pad ==CLKOUT_PTD5){ // PTD5 will be used
      MC_PTDPF3 = (MC_PTDPF3 & 0x0F) | (0x20);
    }else{ // PTA6 will be used
      MC_PTAPF4 = (MC_PTAPF4 & 0xF0) | (0x02);
    }
    // configure CLKOUT selection mux
  	SIMCO = clk;
  }
  /**********STARTFUNC**************************************************
   * Name:  DBG_SIG_OUT
   * Purpose: Bringing a particular debug signal out on a particular GPIO
   * Algorithm:
   * Inputs:	dbg_sig : select the DBG signal
   * 		pad     : selects the pad on which the DBG signal will come
   * Outputs: NONE
   * Return value: NONE
   * Assumptions : NONE
   * Child Functions : NONE
   ***********ENDFUNC***************************************************/
  void DBG_SIG_OUT(int dbg_sig,DBG_OUT_PAD_T pad) {
        // enable debug mux clock
  	    SCGC2 |=BIT6;
  	// bring the dbg signal on pad
  	switch(pad){
  		case DBG_PTE4:
  			MC_PTEPF3 = ( MC_PTEPF3 & 0xF0) |DBGOUT0_AT_PTE4;
  			DBGMUX10 = (DBGMUX10 & 0xF0) | dbg_sig;
  			break;
  		case DBG_PTE5:
  			MC_PTEPF3 = ( MC_PTEPF3 & 0x0F) |(DBGOUT1_AT_PTE5<<4);
  			DBGMUX10 = (DBGMUX10 & 0x0F) | (dbg_sig<<4);
  			break;
  		case DBG_PTE6:
  			MC_PTEPF4 = ( MC_PTEPF4 & 0xF0) |DBGOUT2_AT_PTE6;
  			DBGMUX32 = (DBGMUX32 & 0xF0) | dbg_sig;
  			break;
  		case DBG_PTE7:
  			MC_PTEPF4 = ( MC_PTEPF4 & 0x0F) |(DBGOUT3_AT_PTE7<<4);
  			DBGMUX32 = (DBGMUX32 & 0x0F) | (dbg_sig<<4);
  			break;
  	}

  }

#else

  /**********STARTFUNC**************************************************
   * Name:  SIM_CLKOUT
   * Purpose: Bringing a particular clock on CLKOUT for observability
   * Algorithm:
   * Inputs:	clk : Clock which has to be observed
   * 		      pad : selects the pad on which the CLKOUT will come
   * Outputs: NONE
   * Return value: NONE
   * Assumptions : NONE
   * Child Functions : NONE
   *
   ***********ENDFUNC***************************************************/
  void SIM_CLKOUT(SIM_CLKOUT_CLK_T clk, SIM_CLKOUT_PAD_T pad) 
  {
    // configure CLKOUT to come on Chip PAD
    if(pad ==CLKOUT_PTD5){ // PTD5 will be used
      SCGC3_PTD = 1;
      PTDPF3 = (PTDPF3 & 0x0F) | (0x20);
    }else{ // PTA6 will be used
      SCGC3_PTA = 1;
      PTAPF4 = (PTAPF4 & 0xF0) | (0x02);
    }
    // configure CLKOUT selection mux
  	SIMCO = clk;
  }
  /**********STARTFUNC**************************************************
   * Name:  DBG_SIG_OUT
   * Purpose: Bringing a particular debug signal out on a particular GPIO
   * Algorithm:
   * Inputs:	dbg_sig : select the DBG signal
   * 		pad     : selects the pad on which the DBG signal will come
   * Outputs: NONE
   * Return value: NONE
   * Assumptions : NONE
   * Child Functions : NONE
   ***********ENDFUNC***************************************************/
  void DBG_SIG_OUT(int dbg_sig,DBG_OUT_PAD_T pad) {
    // enable debug mux clock
  	SCGC2 |=0x40;
  	// bring the dbg signal on pad
  	switch(pad){
  		case DBG_PTE4:
  			PTEPF3 = ( PTEPF3 & 0xF0) |DBGOUT0_AT_PTE4;
  			DBGMUX10 = (DBGMUX10 & 0xF0) | dbg_sig;
  			break;
  		case DBG_PTE5:
  			PTEPF3 = ( PTEPF3 & 0x0F) |(DBGOUT1_AT_PTE5<<4);
  			DBGMUX10 = (DBGMUX10 & 0x0F) | (dbg_sig<<4);
  			break;
  		case DBG_PTE6:
  			PTEPF4 = ( PTEPF4 & 0xF0) |DBGOUT2_AT_PTE6;
  			DBGMUX32 = (DBGMUX32 & 0xF0) | dbg_sig;
  			break;
  		case DBG_PTE7:
  			PTEPF4 = ( PTEPF4 & 0x0F) |(DBGOUT3_AT_PTE7<<4);
  			DBGMUX32 = (DBGMUX32 & 0x0F) | (dbg_sig<<4);
  			break;
  	}
  }
#endif
#endif



