
/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file wdog.c
*
* @author a13984
*
* @version 0.0.2
*
* @date Jul-15-2011
*
* @brief Provide common watchdog module routines. 
*
* @history:
* 	Jul.20, 2011	modified the watch dog unlock sequence and disable sequence
*******************************************************************************
* NOTE: Need to add more functionality. Right now it
* 				is just a disable routine since we know almost
* 				all projects will need that.    
******************************************************************************/
#include "common.h"
#include "wdog.h"
 
/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/

/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: wdog_disable
*
* @brief Watchdog timer disable routine
*        
* @param  send	a char to print 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void wdog_disable(void)
{
	/* First unlock the watchdog so that we can write to registers */
	 wdog_unlock();	
	/* Clear the WDOGE bit to disable the watchdog */
	/* WDOG_CS1 &= ~WDOG_CS1_WDOGE_MASK; */
	/*
		*((unsigned char*)0x3030) = 0x20;	//WDOGA = 1 to allow reconfigure watchdog at any time by executing an unlock sequence
	
		*((unsigned char*)0x3031) = 0x0;
		*((unsigned char*)0x3034) = 0xFF;
		*((unsigned char*)0x3035) = 0xFF;
		*((unsigned char*)0x3036) = 0x0;
		*((unsigned char*)0x3037) = 0x0;
	  asm{	// unlock watch dog
	  		LDA	#0xC5
			STA	0x3032
			LDA	#0x20
			STA	0x3033
			LDA	#0xD9
			STA	0x3032
			LDA	#0x28
			STA	0x3033	
		}
	*/

	/* Write all 6 registers once within 128 bus cycles after unlocking */
	WDOG_CS1 = 0x20; /* WDOGA = 1 to allow reconfigure watchdog at any time by executing an unlock sequence */
	WDOG_CS2 = 0;
	WDOG_TMRH = 0;//0xFF;
	WDOG_TMRL = 0xFF;
	WDOG_WINH = 0;
	WDOG_WINL = 0;
}

#if 0
/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: wdog_unlock
*
* @brief Watchdog timer unlock routine. Writing 0xC520 followed by 0xD928
* will unlock the write once registers in the WDOG so they are writable
* within the WCT period.
*        
* @param  send	a char to print 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void wdog_unlock(void)
{
  /* NOTE: DO NOT SINGLE STEP THROUGH THIS FUNCTION!!! */
  /* There are timing requirements for the execution of the unlock. If
   * you single step through the code you will cause the CPU to reset.
   */

	/* This sequence must execute within 16 bus clock cycles, so disable
         * interrupts will keep the code atomic and ensure the timing.
         */
   /* DisableInterrupts;*/
	
	/* Write 0xC520 to the unlock register */
    /* WDOG_CNT = 0xC520; */
	
	/* Followed by 0xD928 to complete the unlock */
    /* WDOG_CNT = 0xD928; */
    asm{	
    	  		LDA	#0xC5
    			STA	0x3032
    			LDA	#0x20
    			STA	0x3033
    			LDA	#0xD9
    			STA	0x3032
    			LDA	#0x28
    			STA	0x3033	
    };	
	/* Re-enable interrupts now that we are done */	
   /* EnableInterrupts;*/
}
#endif

/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: wdog_enable
*
* @brief Watchdog timer enable routine
*        
* @param  send	a char to print 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void wdog_enable(PTWatchdogConfig pDogConfig)
{
	/* First unlock the watchdog so that we can write to registers */
	 wdog_unlock();	

	/*
	  asm{	// unlock watch dog
	  		LDA	#0xC5
			STA	0x3032
			LDA	#0x20
			STA	0x3033
			LDA	#0xD9
			STA	0x3032
			LDA	#0x28
			STA	0x3033	
		}
	*/
	/* NOTE: the following write sequence must be completed within 128 buc clocks
	 * 
	 */
	 /* enable watchdog */
#if 0	 
	 WDOG_CS1 = 0x20 | WDOG_CS1_WDOGE_MASK ; /* WDOGA = 1 to allow reconfigure watchdog at any time by executing an unlock sequence */	 
	if(pDogConfig->interruptEnable)
	{
		WDOG_CS1 |= WDOG_CS1_WDOGI_MASK;
	}
	if(pDogConfig->stopEnable)
	{
		WDOG_CS1 |= WDOG_CS1_WDOGSE_MASK;
	}
	if(pDogConfig->waitEnable)
	{
		WDOG_CS1 |= WDOG_CS1_WDOGWE_MASK;
	}	
#else
	WDOG_CS1 = 0x20 | WDOG_CS1_WDOGE_MASK | WDOG_CS1_WDOGI_MASK 
	           | WDOG_CS1_WDOGSE_MASK | WDOG_CS1_WDOGWE_MASK
	           | WDOG_CS1_WDOGDE_MASK 		// debug enable
	           ;
	#if	(WDOG_CLK == WDOG_CLK_INTERNAL_32KHZ)	
		WDOG_CS2 = 2;	/* use internal reference clock (32K) as clock source */
	#elif (WDOG_CLK == WDOG_CLK_INTERNAL_1KHZ)
		WDOG_CS2 = 1;	/* use internal 1K clock as clock source */	
	#elif (WDOG_CLK == WDOG_CLK_EXTERNAL)
		WDOG_CS2 = 3;	/* use internal 1K clock as clock source */	
	#elif (WDOG_CLK == WDOG_CLK_BUS)
		WDOG_CS2 = 0;	/* use internal 1K clock as clock source */	
	#else
	#error "not supported WDOG clock source\n";
	#endif
	WDOG_TMR = 0x00FF;
#endif
}

/********************************************************************/


