/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file pt60_tower.c
*
* @author a13984
*
* @version 0.0.1
*
* @date Aug 23, 2011
*
* @brief application entry point which performs application specific tasks. 
* 
* User buttons: 
* SW1 :  PTA4/BKGD/MS
* SW2 :  PTD5/KBI1P5
* SW3 :  PTD4/KBI1P4
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/
#ifdef	TWR_PT60
#include "common.h"
/******************************************************************************
* External objects
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/


/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local types
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/
void Button_Init(void);

/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: Button_Init
*
* @brief initialize button switches.
*        
* @param  none 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void Button_Init(void)	
{
	/* Initialize SW1 */
	/* PTA4 is output only */
	/* Initialize SW2 */
	PORT_PTDOE_PTDOE5 = 0;	/* configure PTD5 as input */
	PORT_PTDIE_PTDIE5 = 1;	/* configure PTD5 as input */
	
	/* Initialize SW3 */
	PORT_PTDOE_PTDOE4 = 0;	/* configure PTD4 as input */
	PORT_PTDIE_PTDIE4 = 1;	/* configure PTD4 as input */
	
	/* Initialize Keyboard 1 */
	KBI1_SC_KBIE = 0;	/* mask interrupt */ 
	//KBI1_ES = KBI1_ES_KBEDG4_MASK | KBI1_ES_KBEDG5_MASK;  /* rising edge */ 
	PORT_PTDPE = PORT_PTDPE_PTDPE4_MASK | PORT_PTDPE_PTDPE5_MASK  ;	/* enable pullup */
	KBI1_PE = KBI1_PE_KBIPE4_MASK | KBI1_PE_KBIPE5_MASK; /* enable KBI pin */
	KBI1_SC_KBACK = 1;		
}
#endif


