/*
 * File:		stdlib.h
 * Purpose:		Function prototypes for standard library functions
 *
 * Notes:
 */

#ifndef _STDLIB_H
#define _STDLIB_H

/********************************************************************
 * Standard library functions
 ********************************************************************/

int8_t
isspace (int8_t ch);

int8_t
isalnum (int8_t ch);

int8_t
isdigit (int8_t ch);

int8_t
isupper (int8_t ch);

int8_t
strcasecmp (const char *s1, const char *s2);

int8_t
strncasecmp (const char *s1, const char *s2, int8_t n);

int8_t
strlen (const char *str);

char *
strcat (char *dest, const char *src);

char *
strncat (char *dest, const char *src, int8_t n);

char *
strcpy (char *dest, const char *src);

char *
strncpy (char *dest, const char *src, int8_t n);

int8_t
strcmp (const char *s1, const char *s2);

int8_t
strncmp (const char *s1, const char *s2, int8_t n);

void *
memcpy (void *dest, const void *src, uint8_t n);

void *
memset (void *s, int8_t c, uint8_t n);

void
free (void *);
 
void *
malloc (unsigned);

/********************************************************************/

#endif
