/** @file ieeetypes.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef IEEETYPES_H
#define IEEETYPES_H

#include "utils.h"

/*--------------------------------------------*/
/* Various sizes used in IEEE 802.11 messages */
/*--------------------------------------------*/
#define IEEEtypes_ADDRESS_SIZE         6

typedef u8 IEEEtypes_Addr_t;
/* */
/* Address type */
/* */

typedef IEEEtypes_Addr_t IEEEtypes_MacAddr_t[IEEEtypes_ADDRESS_SIZE];
/* */
/* MAC address type */
/* */

typedef u16 IEEEtypes_ListenInterval_t;
/* */
/* Listen interval to indicate to an AP how often a STA wakes to listen */
/* to beacon management frames */
/* */


typedef  struct IEEEtypes_FrameCtl_t
{
    u16 ProtocolVersion:2;
    u16 Type:2;
    u16 Subtype:4;
    u16 ToDs:1;
    u16 FromDs:1;
    u16 MoreFrag:1;
    u16 Retry:1;
    u16 PwrMgmt:1;
    u16 MoreData:1;
    u16 Wep:1;
    u16 Order:1;
} PACK_END IEEEtypes_FrameCtl_t;



typedef  struct IEEEtypes_CapInfo_t
{
    u16 Ess:1;
    u16 Ibss:1;
    u16 CfPollable:1;
    u16 CfPollRqst:1;
    u16 Privacy:1;
    u16 ShortPreamble:1;
    u16 Pbcc:1;
    u16 ChanAgility:1 ;
    u16 SpectrumMgmt : 1;
    u16 QoS : 1;
    u16 ShortSlotTime:1;
    u16 APSD : 1;
    u16 Rrm : 1;
    u16 DsssOfdm:1;
    u16 BlckAck : 1;
    u16 Rsrvd2 : 1;
} PACK_END IEEEtypes_CapInfo_t;


#endif /* IEEETYPES_H */
