/** @file utils.c
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */

#include <malloc.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>
#include <errno.h>
#include <pthread.h>
#include <string.h>
#include "utils.h"

void *wlmgr_malloc(size_t size)
{
    void *ptr;

    ptr = malloc(size);

    if (ptr == NULL)
    {
        printf("malloc failed!\n");
        return NULL;
    }

    return ptr;
}

void wlmgr_free(void *ptr)
{
    if (ptr) {
	free(ptr);
	ptr = NULL;
    }
}

void *wlmgr_realloc(void *ptr, size_t size)
{
    void *ptr_new;

    ptr_new = realloc(ptr, size);

    wlmgr_free(ptr);

    if (ptr_new == NULL)
    {
        printf("realloc failed!\n");
        return NULL;
    }

    return ptr_new;
}

const char* mac_display(const char *mac)
{
    static int etherbuf_index;
    static char etherbuf[72];

    etherbuf_index++;
    etherbuf_index &= 3;
    snprintf(&etherbuf[etherbuf_index*18], sizeof(etherbuf)/2, "%02x:%02x:%02x:%02x:%02x:%02x",
        mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
    return &etherbuf[etherbuf_index*18];
}
