/** @file utils.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef UTILS_H
#define UTILS_H

#include <stdio.h>

/****** Type definitions ******/
typedef enum
{ FALSE, TRUE } boolean;

typedef char s8;
typedef unsigned char u8;
typedef signed short s16;
typedef unsigned short u16;
typedef signed int s32;
typedef unsigned int u32;
typedef unsigned long long u64;

#define PACK_END  __attribute__((packed))

#define	MAX_CONFIG_LINE    1024
#define	ETH_ADDR_LEN	    6
#define	ETH_ADDR_STR_LEN    17

#define WL_MODE_EANBLE	   1
#define WL_MODE_DISABLE    0

#define WLMGR_DEBUG_FILE_NAME_LEN   256
/****** Return Status ******/
#define WL_STATUS_FAILURE  (-1)
#define WL_STATUS_SUCCESS  0

#define NELEMENTS(x) (sizeof(x)/sizeof(x[0]))

#define MAX(x, y)  (((x)>(y)) ? (x):(y))

#define MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define MACSTR "%02x:%02x:%02x:%02x:%02x:%02x"

#define SEPARATE_L "*********************************************\n"
#define SEPARATE_L_LEN strlen("*********************************************\n")

#define CMD_BUF_LEN 4096

void *wlmgr_malloc(size_t size);
void wlmgr_free(void *ptr);
void *wlmgr_realloc(void *ptr, size_t size);
const char* mac_display(const char *mac);

#endif /* UTILS_H */
