/** @file drv_ops.c
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */

#include <pthread.h>
#include <time.h>
#include <signal.h>
#include <sys/time.h>
#include "drv_ops.h"

static const char *ether_sprintf(const u8 *addr)
{
    static char buf[sizeof(MACSTR)];

    if (addr != NULL)
        snprintf(buf, sizeof(buf), MACSTR, MAC2STR(addr));
    else
        snprintf(buf, sizeof(buf), MACSTR, 0,0,0,0,0,0);

    return buf;
}

void *drv_ops_init(wlmgr_bss_t *wlmgr, const u8 *iface)
{
    if (!wlmgr || !wlmgr->driver || !wlmgr->driver->init)
        return 0;

    return wlmgr->driver->init((void *)wlmgr, (char *)iface);
}

void drv_ops_deinit(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->deinit)
        return;

    return wlmgr->driver->deinit(drv_priv);
}

s32 drv_ops_get_curchan(wlmgr_bss_t *wlmgr, void* drv_priv, u8 *channel)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_curchan)
        return 0;

    return wlmgr->driver->get_curchan(drv_priv, channel);
}

u32 drv_ops_get_chanutil(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_chanutil)
        return 0;

    return wlmgr->driver->get_chanutil(drv_priv);
}

u32 drv_ops_get_agingtime(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_agingtime)
        return 0;

    return wlmgr->driver->get_agingtime(drv_priv);
}

s32 drv_ops_get_stalist(wlmgr_bss_t *wlmgr,
                        void* drv_priv, u8 *buf)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_stalist)
        return 0;

    return wlmgr->driver->get_stalist(drv_priv, buf);
}

u32 drv_ops_get_stacnt(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_stacnt)
        return 0;

    return wlmgr->driver->get_stacnt(drv_priv);
}

u16 drv_ops_get_maxsta(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_maxsta)
        return 0;

    return wlmgr->driver->get_maxsta(drv_priv);
}

DRV_DEV_ID drv_ops_get_deviceid(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_deviceid)
        return DRV_DEV_ID_FAIL;

    return wlmgr->driver->get_deviceid(drv_priv);
}

DRV_BW_TYPE drv_ops_get_bandwidth(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_bandwidth)
        return DRV_BW_TYPE_FAIL;

    return wlmgr->driver->get_bandwidth(drv_priv);
}

s32 drv_ops_config_btm_target(wlmgr_bss_t *wlmgr, void* drv_priv,
				const u8 *target, const u8 channel)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->config_btm_target)
        return 0;

    return wlmgr->driver->config_btm_target(drv_priv, target, channel);
}

s32 drv_ops_send_wtsbtmreq(wlmgr_bss_t *wlmgr, void* drv_priv,
			const u8 *addr, const u8 *target)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->send_wtsbtmreq)
        return 0;

    return wlmgr->driver->send_wtsbtmreq(drv_priv, addr, target);
}

s32 drv_ops_send_btmreq(wlmgr_bss_t *wlmgr, void* drv_priv, const u8 *addr)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->send_btmreq)
        return 0;

    return wlmgr->driver->send_btmreq(drv_priv, addr);
}

s32 drv_ops_set_btm(wlmgr_bss_t *wlmgr, void* drv_priv,
                   const u8 enable)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_btm)
        return 0;

    return wlmgr->driver->set_btm(drv_priv, enable);
}

s32 drv_ops_set_apsteermode(wlmgr_bss_t *wlmgr, void* drv_priv,
                            const u8 enable)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_btm)
        return 0;

    return wlmgr->driver->set_apsteermode(drv_priv, enable);
}

s32 drv_ops_get_aprssi(wlmgr_bss_t *wlmgr, void* drv_priv, u8 *buf)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_aprssi)
        return 0;

    return wlmgr->driver->get_aprssi(drv_priv, buf);
}

s32 drv_ops_send_disassoc(wlmgr_bss_t *wlmgr, void* drv_priv,
                          const u8 *addr, int reason)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->send_disassoc)
        return 0;

    return wlmgr->driver->send_disassoc(drv_priv, addr, reason);
}

s32 drv_ops_set_acnt_enable(wlmgr_bss_t *wlmgr, void* drv_priv,
                            const u16 action)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_acnt_enable)
        return 0;

    return wlmgr->driver->set_acnt_enable(drv_priv, action);
}

s32 drv_ops_set_muset(wlmgr_bss_t *wlmgr, void* drv_priv,
                   u16 sta_cnt, u8 option, u8 gid, u16 *StnId)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_muset)
        return -1;

    return wlmgr->driver->set_muset(drv_priv, sta_cnt, option, gid, StnId);
}

s32 drv_ops_set_ofdma_config(wlmgr_bss_t *wlmgr, void* drv_priv,
                            const u8 enable, u8 sta_count)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_ofdma_config)
        return -1;

    return wlmgr->driver->set_ofdma_config(drv_priv, enable, sta_count);
}

s32 drv_ops_set_ofdma(wlmgr_bss_t *wlmgr, void* drv_priv,
                   u8 enable, u8 sta_cnt, u16 *StnId)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_ofdma)
        return -1;

    return wlmgr->driver->set_ofdma(drv_priv, enable, sta_cnt, StnId);
}

s32 drv_ops_ul_muset(wlmgr_bss_t *wlmgr, void* drv_priv, u8 action, u32 rateinfo,
                   u32 flag, u8 gid, u8 mode, u8 bw, u16 sta_cnt, u32 param_cnt, u32 *param, u32 mu_version)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_ul_muset)
        return -1;

    return wlmgr->driver->set_ul_muset(drv_priv, action, rateinfo, flag, gid, mode, bw, sta_cnt, param_cnt, param, mu_version);
}

u8 drv_ops_get_dl_gid(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_dl_gid)
        return 0;

    return wlmgr->driver->get_dl_gid(drv_priv);
}

u8 drv_ops_get_ul_gid(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_ul_gid)
        return 0;

    return wlmgr->driver->get_ul_gid(drv_priv);
}

s32 drv_ops_set_dl_gid(wlmgr_bss_t *wlmgr, void* drv_priv, u8 gid)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_dl_gid)
        return 0;

    return wlmgr->driver->set_dl_gid(drv_priv, gid);
}

s32 drv_ops_set_ul_gid(wlmgr_bss_t *wlmgr, void* drv_priv, u8 gid)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_ul_gid)
        return 0;

    return wlmgr->driver->set_ul_gid(drv_priv, gid);
}

u8 drv_ops_get_dl_ofdma(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_dl_ofdma)
        return 0;

    return wlmgr->driver->get_dl_ofdma(drv_priv);
}

u8 drv_ops_get_dl_mimo(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_dl_mimo)
        return 0;

    return wlmgr->driver->get_dl_mimo(drv_priv);
}

u8 drv_ops_get_ul_ofdma(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_ul_ofdma)
        return 0;

    return wlmgr->driver->get_ul_ofdma(drv_priv);
}

u8 drv_ops_get_ul_mimo(wlmgr_bss_t *wlmgr, void* drv_priv)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->get_ul_mimo)
        return 0;

    return wlmgr->driver->get_ul_mimo(drv_priv);
}
s32 drv_ops_set_muedca(wlmgr_bss_t *wlmgr, void* drv_priv, u8 on_off)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_muedca)
        return 0;

    return wlmgr->driver->set_muedca(drv_priv, on_off);
}

s32 drv_ops_set_fw_mib(wlmgr_bss_t *wlmgr, void* drv_priv, char *mib_name, u8 valcnt, u32 *val)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_muedca)
        return 0;

    return wlmgr->driver->set_fw_mib(drv_priv, mib_name, valcnt, val);
}

u8 drv_ops_compare_drv_ver(wlmgr_bss_t *wlmgr, void* drv_priv, u16 version)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->compare_drv_ver)
        return 0;

    return wlmgr->driver->compare_drv_ver(drv_priv, version);
}

u8 drv_ops_set_sched_mode(wlmgr_bss_t *wlmgr, void* drv_priv, u8 *mode, u8 *on_off)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_sched_mode)
        return 0;

    return wlmgr->driver->set_sched_mode(drv_priv, mode, on_off);
}
s32 drv_ops_set_dl_expiretime(wlmgr_bss_t *wlmgr, void* drv_priv, u32 expiretime)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_dl_expiretime)
        return 0;

    return wlmgr->driver->set_dl_expiretime(drv_priv, expiretime);
}
s32 drv_ops_set_sta_aggregation(wlmgr_bss_t *wlmgr, void* drv_priv, u8 enable, u16 StnId)
{
    if (!wlmgr || !drv_priv || !wlmgr->driver ||
        !wlmgr->driver->set_sta_aggregation)
        return 0;

    return wlmgr->driver->set_sta_aggregation(drv_priv, enable, StnId);
}

