/** @file mu_mode_func.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef mu_mode_func_H_
#define mu_mode_func_H_

#include "utils.h"
#include "ieeetypes.h"
#include "stadb.h"

extern s32 mums_sta_update_from_drv(wlmgr_bss_t *wlmgr, u8 *mac_addr);
extern void mu_mode_config_defaults(mu_mode_config_t *conf);
extern void mu_mode_task_deinit(void *ctx);
extern void mu_mode_task(void *ctx);
extern void mums_sta_assoc_event(void *priv, u8 *SrcAddr);
extern void mums_sta_disassoc_event(void *priv, u8 *SrcAddr);
extern s32 mu_mode_cmd_set(void *ctx, char *cmd);
extern s32 mu_mode_cmd_get(void *ctx, char *cmd, char *reply, size_t *reply_len);
extern u8 mums_get_new_gid(wlmgr_bss_t *wlmgr, mu_mode_e mode);
extern void mums_release_gid(wlmgr_bss_t *wlmgr, u8 gid, mu_mode_e mode);

extern s32 mums_del_sta_from_all_list(wlmgr_bss_t *wlmgr, u8 *mac_addr);
extern SFW_BW_TYPE mums_bw_drv_to_sfw(DRV_BW_TYPE bw);
extern void mums_custom_event(void *priv, u8 *cmd);
extern void *mums_radio_init(void *ctx);
extern void *mums_bss_init(void *ctx);
extern void mums_radio_deinit(void *ctx);
extern void mums_bss_deinit(void *ctx);

extern void mums_reset_Group_List(Group_List *glist);
extern void mums_mimo_result(void *ctx, u16 sta_cnt, u16 *StnId, mums_calc_status cal_status);
extern void mums_set_range_list_changed(Range_List *range_list, boolean changed);
extern u8 *mums_mode_display(mu_mode_e mode);
extern u16 mums_count_all_vap_mu_sta(wlmgr_bss_t *wlmgr, mu_mode_e mode);

#endif /* mu_mode_func_H_ */
