/** @file wlmgr.h
  *
  * @brief This file contains WLAN application specific defines etc.
  *
  * Copyright 2019-2020 NXP
  *
  * NXP CONFIDENTIAL
  * The source code contained or described herein and all documents related to
  * the source code ("Materials") are owned by NXP, its
  * suppliers and/or its licensors. Title to the Materials remains with NXP,
  * its suppliers and/or its licensors. The Materials contain
  * trade secrets and proprietary and confidential information of NXP, its
  * suppliers and/or its licensors. The Materials are protected by worldwide copyright
  * and trade secret laws and treaty provisions. No part of the Materials may be
  * used, copied, reproduced, modified, published, uploaded, posted,
  * transmitted, distributed, or disclosed in any way without NXP's prior
  * express written permission.
  *
  * No license under any patent, copyright, trade secret or other intellectual
  * property right is granted to or conferred upon you by disclosure or delivery
  * of the Materials, either expressly, by implication, inducement, estoppel or
  * otherwise. Any license under such intellectual property rights must be
  * express and approved by NXP in writing.
  *
  */


#ifndef _wlmgr_H_
#define _wlmgr_H_

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <errno.h>
#include <linux/if.h>
#include <linux/if_packet.h>
#include <linux/wireless.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include "utils.h"
#include "mu_mode.h"
#include "driver.h"
#include "mu_mimo.h"

struct wlmgr_iface_t;

/*
 * struct wlmgr_interfaces_t - wlmgr interfaces data structure
 */
typedef struct wlmgr_interfaces_t {
    u8 max_bss_num;
    u8 iface_num;
    struct wlmgr_iface_t **iface;
} wlmgr_interfaces_t;

/**
 * struct wlmgr_bss_config_t - wlmgr Per-BSS configuration
 */
typedef struct wlmgr_bss_config_t
{
    u8 ifname[IFNAMSIZ + 1];
    mumimo_config_t mumimo;
    mu_mode_config_t mu_mode;
} wlmgr_bss_config_t;

/**
 * struct wlmgr_config_t - wlmgr Per-Radio interface configuration
 */
typedef struct wlmgr_config_t
{
    wlmgr_bss_config_t **bss;
} wlmgr_config_t;

/*
 * struct wlmgr_bss_t - wlmgr Per-BSS data structure
 */
typedef struct wlmgr_bss_t {
    /* private driver */
    void *drv_priv;
    const struct driver_ops *driver;

    /* configuration value */
    //u8 config_fname[MAX_CONFIG_LINE];
    struct wlmgr_iface_t *iface;
    wlmgr_config_t *iconfig;
    wlmgr_bss_config_t *config;

    /* ctrl interface */
    //struct wlmgr_ctrl_iface *ctrl_iface;
    s32 ctrl_iface;

    void *mumimo_data;
    void *mumode_bss_data;
} wlmgr_bss_t;

/*
 * struct wlmgr_iface_t - wlmgr Per-Radio interface data structure
 */
typedef struct wlmgr_iface_t {
    struct wlmgr_interfaces_t *interfaces;
    wlmgr_config_t *config; //not used now

    u8 ifindex;
    u8 ifname[IFNAMSIZ + 1];
    //u8 state;
    u8 bss_num;
    wlmgr_bss_t **bss;

    void *mumimo_data;
    void *mumode_iface_data;
} wlmgr_iface_t;

s32 wlmgr_cmd_get(void *ctx, char *cmd, char *reply, size_t *reply_len);
s32 wlmgr_cmd_set(void *ctx, char *cmd);
#endif /* _wlmgr_H_ */
