// File Name:  63z818.v   
// Verilog model of Motorola's MCM63Z818 
// 256Kx18 Pipelined ZBT-RAM  
// Revision: 1.1         June 1997 
// MOTOROLA PROPRIETARY/CONFIDENTIAL 
// PLS DO NOT DISTRIBUTE THIS MODEL 
 
// 133MHZ timing values used // 
 
/*  This document contains Motorola confidential/proprietary  
  information.  The information contained herein is not to be  
  reproduced or disclosed to third parties without the express  
  permission of an officer of Motorola. 
   
  Motorola makes no warranty for the use of this information and  
  assumes no responsibility for any errors which may appear in this 
  document nor does it make any commitment to update the  
  information contained herein.  */ 
 
/*      Revision Notes 
r1.1 
        o fixed g_ logic to allow g_=0 operation. -jmh 
        o LBO functionality not added as yet, linear busrt only. -rg
*/ 
 
`timescale 1ns / 100ps 
module MCM63Z818(dq, sa, ck, cke_, se1_, se2, se3_, g_, adv, sba_, sbb_, sw_); 
 
inout [18:1] dq; 
input [17:0] sa; 
input           ck,             // Clock 
                        cke_,   // clock enable  
                        se1_,   // Chip enable 1  
                        se2,    // Chip enable 2 
                        se3_,   // Chip enable 3 
                        g_,     // output enable                 
                        adv,    // async ~load/advance 
                        sba_,   // Byte Write byte 'a'  - dq[9:1] 
                        sbb_,   // Byte Write byte 'b'  - dq[18:10] 
                        sw_;    // sync write enable 
 
`protect 
 
 
/*************************************************/ 
/*     UBRAM logic written & verified by:        */ 
/* Joe Haas, ra5981@email.sps.mot.com July, 1997 */ 
/*********************************************jmh*/ 
 
 
/***  Initialize EnaReg  ***/ 
reg  EnaReg1; 
reg  EnaRegd; 
reg  EnaReg; 
reg  dv; 
initial  
        begin 
                EnaReg1 = 0; EnaRegd = 0; EnaReg = 0; dv = 0; 
        end 
         
 
/******************** Delay Specification section ********************/ 
reg notifier; 
wire CE = (!se1_ && se2 && !se3_); 
wire SBv = (!sba_ | !sbb_);                             // sbv valid if any sbx_ = 0 
wire DESELECT = !cke_ && !adv && !CE;                   // define deselect cycle 
wire NEWwe = !cke_ && CE && !sw_ && !adv && SBv;        // new write, load cycle 
wire NEWrd = !cke_ && CE && sw_ && !adv;                // new write, load cycle 
 
wire Addr_setuphold = (CE); 
wire Data_setuphold = (EnaReg1 && NEWwe); 
wire ADV_setuphold = (EnaReg1); 
wire SE_setuphold = (!se1_); 
wire SGW_setuphold = (EnaReg1); 
wire SW_setuphold = (EnaReg1 && SBv); 
wire SBW_setuphold = (EnaReg1 && !sw_); 
 
specify 
specparam  
          Tkhkh_min   = 7.5,    // Cycle Time 
          Tkhkl_min   = 3,      // Clock High Pulse Width 
          Tklkh_min   = 3,      // Clock Low  Pulse Width 
          Tkhqv       = 4.2,    // clock to output max  
          Tglqv_max   = 4.2,    // Output Enable to Output Valid 
          Tkhqx1 = 1.5:2.0:2.5, // Clock High to Output Active min:typ:max 
          Tkhqx  = 1.5:2.0:2.5, // Clock High to Output Change min:typ:max 
          Tglqx  = 0.0:0.5:1.0, // Output Enable to Output Active 
          Tghqz  = 2.5:3.0:3.5, // Output Enable to Output High-Z 
          Tkhqz  = 1.5:3.0:3.5, // Clock High to Q High-Z min:typ:max 
          Tavkh_min   = 2,      // Address Setup 
          Tlvkh_min   = 2,      // Address Advance Setup 
          Tdvkh_min   = 1.7,    // Data in Setup 
          Twvkh_min   = 2,      // Write Setup 
          Tevkh_min   = 2,      // Chip Select Setup 
          Tcvkh_min   = 2,      // Clock enable setup 
          Tkhax_min   = 0.5,    // Address Hold 
          Tkhlx_min   = 0.5,    // Address Advance Hold 
          Tkhdx_min   = 0.5,    // Data in Hold 
          Tkhwx_min   = 0.5,    // Write Hold 
          Tkhex_min   = 0.5,    // Chip Select Hold 
          Tkhcx_min   = 0.5,    // Clock enable hold 
          Tdummy      = 0.1;    // Should never be used 
 
  $setuphold(posedge ck, cke_,Tcvkh_min,Tkhcx_min,notifier); 
  $setuphold(posedge ck &&& Addr_setuphold,sa,Tavkh_min,Tkhax_min,notifier); 
  $setuphold(posedge ck &&& ADV_setuphold,adv,Tlvkh_min,Tkhlx_min,notifier); 
  $setuphold(posedge ck &&& SE_setuphold,se1_,Tevkh_min,Tkhex_min,notifier); 
  $setuphold(posedge ck &&& SE_setuphold,se2,Tevkh_min,Tkhex_min,notifier); 
  $setuphold(posedge ck &&& SE_setuphold,se3_,Tevkh_min,Tkhex_min,notifier); 
  $setuphold(posedge ck &&& SW_setuphold,sw_,Twvkh_min,Tkhwx_min,notifier); 
  $setuphold(posedge ck &&& SBW_setuphold,sba_,Twvkh_min,Tkhwx_min,notifier); 
  $setuphold(posedge ck &&& SBW_setuphold,sbb_,Twvkh_min,Tkhwx_min,notifier); 
  $setuphold(posedge ck &&& Data_setuphold,dq,Tdvkh_min,Tkhdx_min,notifier); 
  $period(posedge ck,Tkhkh_min,notifier);     // clock minimum period check 
  $period(negedge ck,Tkhkh_min,notifier);     // clock minimum period check 
  $width(posedge ck,Tkhkl_min,,notifier); 
  $width(negedge ck,Tklkh_min,,notifier); 
 
  (ck *> dq) =   Tkhqv,             // 0 -> 1 transition 
                 Tkhqv,             // 1 -> 0 transition 
                 Tkhqz,             // 0 -> z transition 
                 Tkhqx1,            // z -> 1 transition 
                 Tkhqz,             // 1 -> z transition 
                 Tkhqx1;            // z -> 0 transition 
 
  (g_  *> dq) = (Tdummy,Tdummy,     // 0 -> 1 and 1 -> 0 transition 
                 Tghqz,             // 0 -> z transition 
                 Tglqx,             // z -> 1 transition 
                 Tghqz,             // 1 -> z transition 
                 Tglqx);            // z -> 0 transition 
 
endspecify 
 
 
//      Declare the RAM array and some external signals 
 
reg   [18:1]    Mem  [0:'h3ffff]; 
reg   [18:1]    TmpData; 
reg   [18:1]    OutReg; 
reg   [18:1]    TmpOut; 
reg   [17:0]    AddrReg, AddrReg2, AddrRegd, AddrB; 
reg   [ 1:0]    BurstReg; 
reg   [ 2:0]    WriteOp, LastOp, LastOpd; 
reg             sba_d,sbb_d; 
reg             sba_2,sbb_2; 
 
wire         read = !(LastOpd[0] | LastOpd[1]); 
wire         OE = (!g_ && EnaRegd && read); 
wire  [18:1] data = dv ? OutReg : 18'bx ; 
 
 
always @(posedge ck) 
  begin 
  if (!cke_) 
        begin 
        LastOp = LastOpd;                                  //propogate op code through pipe 
        EnaReg = EnaRegd;                                  //propogate enable through pipe 
        EnaRegd = EnaReg1; 
        sba_2 = sba_d;                                     //prop sync byte write selects 
        sbb_2 = sbb_d; 

        LastOpd = WriteOp; 
        sba_d = sba_;                                      //prop sync byte write selects 
        sbb_d = sbb_; 
 
    AddrReg2[17:0] = AddrRegd[17:0];                       //xfr IM addr to internal pipeline 
        AddrRegd[17:0] = AddrReg[17:0]; 
 
        if (adv) 
                begin 
                WriteOp = 3'b100 | WriteOp;                //keep old mode & set for burst 
                end 
        else 
                begin 
                EnaReg1 = CE; 
                AddrReg[17:0] = sa[17:0]; 
 
                if (NEWwe)                                                                                      //trap mode: R/W/D 
                        begin 
                        WriteOp = 3'b001; 
                        end 
 
                if (NEWrd)       
                        begin 
                        WriteOp = 3'b000; 
                        end 
 
        if (DESELECT) 
                begin 
                WriteOp = 3'b010; 
                end 
 
                if (!(NEWwe | NEWrd | DESELECT)) 
                        begin 
                        WriteOp = 3'b011;                   // set unknown opcode...trap this as an err 
                        $display("OpCode Error!"); 
                        end 
                end 
 
/**** write ****/ 
    if (EnaReg && ((LastOp & 3'b001) == 3'b001))            //test for write 
                begin 
        if ((LastOp & 3'b100) == 3'b100)                    //test for burst 
            begin 
            BurstReg[ 1:0]  = BurstReg[1:0]+1'b1;           //inc burst counter 
            end 
                else 
                        begin 
                        BurstReg[ 1:0]  = AddrReg2[ 1:0];   //latch new addr into counter 
                        end 
 
                AddrB = (AddrReg2 & ~(18'h03)) + BurstReg; 
                TmpData = Mem[AddrB];                       //temp contents of write addr 
                if (!sba_2) TmpData[9:1]  = dq[9:1];        //write each enabled byte 
                if (!sbb_2) TmpData[18:10] = dq[18:10]; 
                Mem[AddrB] = TmpData;                       //store result of write to core 
                end 
 
/**** read ****/ 
    if (EnaRegd && ((LastOpd & 3'b011) == 3'b000))          //test for read 
                begin 
            if ((LastOpd & 3'b100) == 3'b100)               //test for burst 
                begin 
                BurstReg[ 1:0]  = BurstReg[1:0]+1'b1;       //inc burst counter 
                end 
                else 
                        begin 
                        BurstReg[ 1:0]  = AddrRegd[ 1:0];   //latch new addr into counter 
                        end 
 
        AddrB = (AddrRegd & ~(18'h03)) + BurstReg;          //combine static addr w/ burst reg 
        OutReg = Mem[AddrB];                                //pull core data to outputs 
 
                if ((LastOp & 3'b011) == 3'b000)            //control bus turn & data change 
                begin 
                        fork                                                                                    //if last was a read, use hqx 
                        #Tkhqx dv = 0; 
                        #Tkhqv dv = 1; 
                        join 
                        end 
                else 
                        begin 
                        fork                                                                                    //else use hqx1 
                        #Tkhqx1 dv = 0; 
                        #Tkhqv dv = 1; 
                        join 
                        end 
                end 
 
/**** deselect ****/ 
        if ((LastOpd == 3'b010) | (LastOpd == 3'b110))       // do deselect cycle 
                begin 
                #Tkhqx dv = 0; 
                end 
        end 
  end 
   
 
bufif1 b18 (dq[18],data[18],OE); 
bufif1 b17 (dq[17],data[17],OE); 
bufif1 b16 (dq[16],data[16],OE); 
bufif1 b15 (dq[15],data[15],OE); 
bufif1 b14 (dq[14],data[14],OE); 
bufif1 b13 (dq[13],data[13],OE); 
bufif1 b12 (dq[12],data[12],OE); 
bufif1 b11 (dq[11],data[11],OE); 
bufif1 b10 (dq[10],data[10],OE); 
bufif1 b09 (dq[09],data[09],OE); 
bufif1 b08 (dq[08],data[08],OE); 
bufif1 b07 (dq[07],data[07],OE); 
bufif1 b06 (dq[06],data[06],OE); 
bufif1 b05 (dq[05],data[05],OE); 
bufif1 b04 (dq[04],data[04],OE); 
bufif1 b03 (dq[03],data[03],OE); 
bufif1 b02 (dq[02],data[02],OE); 
bufif1 b01 (dq[01],data[01],OE); 
 
`endprotect 
 
endmodule 
 
 
