`timescale 1ps/1ps

module sram_test(kick_start, addr, ebar, wbar, gbar, dq);
    parameter memory_spec = "mcm6946_10.spc";
    input kick_start;
    wire denali_test_clock;
      reg den_denali_test_clock;
      assign denali_test_clock = den_denali_test_clock;
    output [18:0] addr;
      reg [18:0] den_addr;
      assign addr = den_addr;
    output ebar;
      reg  den_ebar;
      assign ebar = den_ebar;
    output wbar;
      reg  den_wbar;
      assign wbar = den_wbar;
    output gbar;
      reg  den_gbar;
      assign gbar = den_gbar;
    inout [7:0] dq;
      reg [7:0] den_dq;
      assign dq = den_dq;
initial
    $sram_test();
endmodule

module testbench;
    wire kick_start;
      reg den_kick_start;
      assign kick_start = den_kick_start;
    wire [18:0] addr;
    wire ebar;
    wire wbar;
    wire gbar;
    wire [7:0] dq;

    sram memory(addr, ebar, wbar, gbar, dq);
    sram_test test(kick_start, addr, ebar, wbar, gbar, dq);

    initial begin
      den_kick_start = 'b1;
    end
endmodule

