//Part of BDMFlasher (c) Motorola
//distribute under QPL / GPL as stated in README

#include <qwidget.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qfiledialog.h>

#include <iostream.h>

#include "erase.h"
#include "cmds.h"

CErase::CErase(QWidget* data,QApplication *App)
{
  QVBoxLayout* vlay =new QVBoxLayout(data,05,05);
  QHBoxLayout* hlay[(SECTORS+1)/2];

  sectorbox = new QCheckBox* [SECTORS+1];
  pb = new QProgressBar(data);
  pb->hide();
  pb->setTotalSteps(SECTORS);

  theApp=App;

  sectorbox[0]  = new QCheckBox("0 : 0xffe00000-0xffe03fff",data);
  sectorbox[1]  = new QCheckBox("1 : 0xffe04000-0xffe05fff",data);
  sectorbox[2]  = new QCheckBox("2 : 0xffe06000-0xffe07fff",data);
  sectorbox[3]  = new QCheckBox("3 : 0xffe08000-0xffe3ffff",data);
  sectorbox[4]  = new QCheckBox("4 : 0xffe40000-0xffe7ffff",data);
  sectorbox[5]  = new QCheckBox("5 : 0xffe80000-0xffebffff",data);
  sectorbox[6]  = new QCheckBox("6 : 0xffec0000-0xffefffff",data);
  sectorbox[7]  = new QCheckBox("7 : 0xfff00000-0xfff3ffff",data);
  sectorbox[8]  = new QCheckBox("8 : 0xfff40000-0xfff7ffff",data);
  sectorbox[9]  = new QCheckBox("9 : 0xfff80000-0xfffbffff",data);
  sectorbox[10] = new QCheckBox("10: 0xfffc0000-0xffffffff",data);
  //The "all" button under the Erase Tab.
  //Its main use is to make the Layout easier with an even number of Checkboxes.
  //I would throw it out for Flash-Chips with even Sector Numbers
  sectorbox[11] = new QCheckBox("all",data);

  QPushButton* kill = new QPushButton("Erase",data);
  kill->setMaximumWidth(75);

  connect(sectorbox[11],SIGNAL(toggled(bool)),this,SLOT(all(bool)));
  connect(kill,SIGNAL(clicked()),this,SLOT(Erase()));
  int i;

  for(i=0;i<(SECTORS+1)/2;i++)
    {
      hlay[i]=new QHBoxLayout();
      hlay[i]->addWidget(sectorbox[i]);
      hlay[i]->addWidget(sectorbox[i+(SECTORS+1)/2]);
      vlay->addLayout(hlay[i]);
    }
  vlay->addWidget(pb);
  vlay->addWidget(kill);
}

void CErase::Erase()
{
  pb->show();
  pb->setProgress(0);

  int i;
  for(i=0;i<SECTORS;i++)
    {
      pb->setProgress(i);
      theApp->processEvents(); //Update the Progress Bar.
      bool x;
      x=sectorbox[i]->isChecked();
      if(x)
        erase_sector(i);
    }
  pb->hide();
}

void CErase::all(bool onoff)
{
  int i;

  if(onoff)
    for(i=0;i<SECTORS;i++)
      {
        sectorbox[i]->setChecked(onoff);
      }
}

