//Part of BDMFlasher (c) Motorola
//distribute under QPL / GPL as stated in README

#include <qwidget.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qprogressbar.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qfiledialog.h>

#include <iostream.h>
#include <stdlib.h>

#include "cmds.h"
#include "flash.h"
#include "BDMlib.h"

CFlasher::CFlasher(QWidget* flash, QApplication* app)
{
  theApp=app;

  QPushButton* filebutt = new QPushButton("File",flash);
  filename = new QLineEdit("",flash);
  QLabel *addrlab  = new QLabel("Address:", flash);
  addr  = new QLineEdit(flash);
  fast  = new QCheckBox("fast", flash);
  safe  = new QCheckBox("safe", flash);
  QPushButton *flashbutt = new QPushButton ("Flash!!", flash);
  flashbutt->setMaximumWidth(75);

  QToolTip::add
    (filename,"The name of a binary to flash.\nTip: Linux images for colilo are gziped \"image.bin\" files.");

  connect(flashbutt,SIGNAL(clicked()),this,SLOT(Flash()));
  connect(filebutt,SIGNAL(clicked()),this,SLOT(GetFile()));

  QToolTip::add
    (fast,"Check if value is allready programmed.\n(only faster when you write similiar data)");
  QToolTip::add
    (safe,"Check each word before flashing the next one");
  QToolTip::add
    (addr,"The memory location where you want to begin flashing\nNote: Flash is mirrored and in many cases (e.g. Cobra & 5272C3)\njumpers can prevent writing to part of the flash");
  QToolTip::add
    (flashbutt,"Begin to destroy the board :-)");


  QVBoxLayout *cb = new QVBoxLayout (flash,10,10);

  QHBoxLayout* hlay = new QHBoxLayout();
  hlay->addWidget(filebutt);
  hlay->addWidget(filename);
  cb->addLayout(hlay);

  QHBoxLayout *hlay1 = new QHBoxLayout ();
  hlay1->addWidget(addrlab);
  hlay1->addWidget(addr);
  cb->addLayout(hlay1);

  QHBoxLayout *hlay2 = new QHBoxLayout ();
  hlay2->addWidget(fast);
  hlay2->addWidget(safe);
  cb->addLayout(hlay2);

  pb = new QProgressBar(flash);
  pb->setTotalSteps(100);
  pb->hide();
  cb->addWidget(pb);

  cb->addWidget(flashbutt);
}

void CFlasher::Flash()
{
  int i;
  bool bhexerror;

  QString file=filename->text();
  QString CSAdr=addr->text();
  unsigned long ulAdr=CSAdr.toULong(&bhexerror,16);

  if(file.length()==0)
    {
      QMessageBox::warning(0,"Error","no data source",QMessageBox::Cancel,0);
      return;
    }
  else if(CSAdr.length()>8 || ulAdr==-1)
    {
      QMessageBox::warning(0,"Error","Invalid adress.\nPlease enter a hex number without prefix",QMessageBox::Cancel,0);
      return;
    }
  else
    {

      int perc=0;

      int perc_old=0;

      unsigned int flashmode=0;

      pb->show();

      if(safe->isChecked())
        flashmode+=FLASHMODE_SAFE;
      if(fast->isChecked())
        flashmode+=FLASHMODE_FAST;

      QFile inFile(file);

      if(!inFile.open(IO_ReadOnly))
        {
          QMessageBox::warning(0,"Error","This file can not be opened.", QMessageBox::Cancel,0);
          return;
        }

      QFileInfo fi(file);

      unsigned short *buffer;

      int size=(fi.size()+1)/2;
      int filesize=fi.size();

      buffer=new unsigned short[size];

      buffer[size-1]=0xff00;

      if(inFile.readBlock((char*)buffer, filesize)!=filesize)
        {
          QMessageBox::warning(0,"Error","This file can not be opened.", QMessageBox::Cancel,0);
          return;
        }

      for(i=0;i<size;i++)
        {
          perc=(int)((float(i)/float(size))*100);
          if( perc > perc_old)
            {
              pb->setProgress(perc);
              theApp->processEvents();
              perc_old=perc;
            }
          swap(&buffer[i]);
          write_word(ulAdr+2*i,buffer[i],flashmode);
        }

      delete buffer;
      pb->hide();
    }
}
void CFlasher::GetFile()
{
  filename->setText(QFileDialog::getOpenFileName());
}

