//Part of BDMFlasher (c) Motorola
//distribute under QPL / GPL as stated in README

#include <qcolor.h>
#include <qpalette.h>

#include <stdio.h>

#include "hexview.h"
#include "cmds.h"
#include "BDMlib.h"

char char2printable(char c)
{
  if(c>='a' && c<='z')
    return c;
  else if(c>='A' && c<='Z')
    return c;
  else if(c>='0' && c<='9')
    return c;
  else
    return '.';
}

CHexView::CHexView(QWidget* parent, const char* name):QScrollView(parent,name)
{
  offset=0;
  loaded=false;

  setMinimumSize(200,100);

  QPalette pa=palette();

  pa.setColor(QColorGroup::Dark,QColor(0xf0,0xf0,0xf0));
  pa.setColor(QColorGroup::Foreground,QColor(0x0,0x0,0x0));

  setPalette(pa);

  data = new char [VIEWBLOCKSIZE];

  int i;

  for(i=0;i<VIEWBLOCKSIZE;i++)
    data[i]=0x0;
}

CHexView::~CHexView(void)
{
  delete data;
}

void CHexView::drawContents(QPainter* qp, int cx, int cy, int cw, int ch)
{
  if(!loaded)
    return;
  char c[100];

  qp->setFont(QFont("courier",12));
  int i;

  for(i=0;i<VIEWBLOCKSIZE;i+=0x10)
    {
      sprintf(c,"%08X %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX  %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c"
              ,i+offset
              ,data[i]
              ,data[i+1]
              ,data[i+2]
              ,data[i+3]
              ,data[i+4]
              ,data[i+5]
              ,data[i+6]
              ,data[i+7]
              ,data[i+8]
              ,data[i+9]
              ,data[i+10]
              ,data[i+11]
              ,data[i+12]
              ,data[i+13]
              ,data[i+14]
              ,data[i+15]
              ,char2printable(data[i])
              ,char2printable(data[i+1])
              ,char2printable(data[i+2])
              ,char2printable(data[i+3])
              ,char2printable(data[i+4])
              ,char2printable(data[i+5])
              ,char2printable(data[i+6])
              ,char2printable(data[i+7])
              ,char2printable(data[i+8])
              ,char2printable(data[i+9])
              ,char2printable(data[i+10])
              ,char2printable(data[i+11])
              ,char2printable(data[i+12])
              ,char2printable(data[i+13])
              ,char2printable(data[i+14])
              ,char2printable(data[i+15]));
      qp->drawText(0,((i+12)*3)/4,c);
    }

  resizeContents(550,((i+12)*3)/4);

}

void CHexView::UpdateMem(unsigned long addr)
{
  loaded=true;

  int i;

  offset=addr;

  for(i=0;i<VIEWBLOCKSIZE;i+=2)
    {
      unsigned short d;

      bdmReadWord(addr+i,&d);

      data[i]   = char(d >> 8);
      data[i+1] = char(d & 0x00ff);
    }

  repaintContents(contentsX(),contentsY(),visibleWidth(),visibleHeight());
}
