//Part of BDMFlasher (c) Motorola
//distribute under QPL / GPL as stated in README

#include <qwidget.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qfiledialog.h>
#include <qlabel.h>

#include <fstream.h>

#include <BDMlib.h>

#include "load.h"
#include "cmds.h"

CLoad::CLoad(QWidget* flash,QApplication* app)
{
  theApp=app;

  QPushButton* filebutt = new QPushButton("File",flash);
  connect(filebutt,SIGNAL(clicked()),this,SLOT(GetFile()));
  filename = new QLineEdit("",flash);
  QToolTip::add
    (filename,"The file you want to contain the flash's contents.");

  QLabel* from_lbl    = new QLabel("From address",flash);
  from_lin = new QLineEdit("",flash);
  QLabel* to_lbl      = new QLabel("to address",flash);
  QToolTip::add
    (from_lin,"First byte of the data to read in hex (without a 0x prefix)");
  to_lin   = new QLineEdit("",flash);
  QToolTip::add
    (to_lin,"Last byte of the data to read in hex (without a 0x prefix)");

  QVBoxLayout* vlay = new QVBoxLayout(flash,10,10);

  QHBoxLayout* hlay1 = new QHBoxLayout();
  hlay1->addWidget(filebutt);
  hlay1->addWidget(filename);
  vlay->addLayout(hlay1);

  QHBoxLayout* hlay2 = new QHBoxLayout();
  hlay2->addWidget(from_lbl);
  hlay2->addWidget(from_lin);
  vlay->addLayout(hlay2);

  QHBoxLayout* hlay3 = new QHBoxLayout();
  hlay3->addWidget(to_lbl);
  hlay3->addWidget(to_lin);
  vlay->addLayout(hlay3);

  prog = new QProgressBar(flash);
  vlay->addWidget(prog);
  prog->setTotalSteps(100);
  prog->setProgress(0);
  prog->hide();

  QPushButton* load_butt= new QPushButton("Load from target",flash);
  load_butt->setMaximumWidth(100);
  vlay->addWidget(load_butt);
  connect(load_butt,SIGNAL(clicked()), this, SLOT(Download()));
}

void CLoad::GetFile()
{
  filename->setText(QFileDialog::getSaveFileName());
}

void CLoad::Download()
{
  int done,olddone;

  bool bhexerror;

  unsigned long i,start,end;

  start = from_lin->text().toULong(&bhexerror,16);
  end   = to_lin->text().toULong(&bhexerror,16);

  ofstream weg;

  weg.open(filename->text(),ios::binary);

  i=start;
  done=0;
  olddone=0;
  prog->show();


  do
    {
      done=int((float(i-start)/float(end-start))*100);
      if(done!=olddone)
        {
          prog->setProgress(done);
          theApp->processEvents();
          olddone=done;
        }
      unsigned short dat;
      bdmReadWord(i,&dat);
      swap(&dat);
      weg.write(&dat,sizeof(dat));
      i+=2;
    }
  while(i<=end && i>1);

  prog->hide();
}
