;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2007, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                                                                       *
;*               EEPROM Emulation Driver for HCS08 eNVM                  *
;*                                                                       *
;* FILE NAME     :  EED_Flash.inc                                        *
;* DATE          :  01.04.2007                                           *
;* AUTHOR        :  Infosys Team, Mysore                                 *
;* EMAIL         :  r56611@freescale.com                                 *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   01.04.2007     Venkatesh_G/Arvind_Awasthi    Initial Version
;*   1.1    06.04.2008     Arvind_Awasthi Modified to handle boundary 
;*                                         check
;*************************************************************************

; bytes to be copied during a MAX COP period
BYTES_PER_COP:           EQU    $30  

; Flag to indicate whether a Flash HV function is present on stack.
EMU_HV_ONSTACK:          EQU    $5A

; Null callback definition

 IFNDEF NULL_CALLBACK
 NULL_CALLBACK:           EQU    $FFFF
 ENDIF

; record state
RECORD_STATUS_ERASED:    EQU    $FF
RECORD_STATUS_COMPLETED: EQU    $00

; cluster state
SECTOR_STATUS_ERASED:    EQU    $FF
SECTOR_STATUS_ACTIVE:    EQU    $00

; EEPROM Emulation Flash Driver Return Code
EE_OK:                   EQU    $0
EE_ERROR_ACCERR:         EQU    $10    ; flash operation causes access error
EE_ERROR_PVIOL:          EQU    $20    ; flash operation on protected area
EE_ERROR_NOT_BLANK:      EQU    $30    ; Flash page is not erased  
EE_ERROR_SECURITY_ENABLED: EQU  $40    ; flash is in secured state
EE_ERROR_VERIFY:         EQU    $50    ; source and destination data mismatch
EE_ERROR_NOMEM:          EQU    $60    ; no enough EEPROM memory
EE_ERROR_NOFND:          EQU    $70    ; record not found in sector
EE_ERROR_CLOCK_SETTING:  EQU    $80    ; clock divider setting error
EE_ERROR_SSTAT:          EQU    $90    ; sector status error
EE_ERROR_IDRNG:          EQU    $A0    ; recID exceeds the valid range
EE_ERROR_RANGE:          EQU    $B0    ; Address exceeds the Flash size

;Each Sector will be of 512 bytes if each sector has its Error 
;Corrrection Code(ECC) and 768 Bytes if no ECC is there.Each Sector 
;will have 1 Byte long Status and 2 Bytes long Erase Cycles and rest 
;of the Sector will be used for holding Data Records.
;Each Data Record will have a Status of 1 Byte and user configurable 
;ID size and Data size.

OFF:  EQU $0
ON:   EQU $1
ECC:  EQU OFF
;**********************************************************
;Macro to determine the size of the Sector.
;**********************************************************

    IF ECC==OFF
	EED_SECTOR_SIZE:       EQU   $200  ;Select Sector Size=512 Bytes
    ELSE
	EED_SECTOR_SIZE:       EQU   $300  ;Select Sector Size=768 Bytes
    ENDIF
;**********************************************************
;End of Macro
;**********************************************************
;Data Status Size has 1 byte fixed length.
DATA_STATUS_SIZE:        EQU   $1

;Data ID Size is user cofigurable.
DATA_ID_SIZE:            EQU  $1

;Data size is user configurable.
DATA_SIZE:               EQU  $1

 IF (DATA_SIZE>$7C)
 FAIL "Data size cannot exceed 124 bytes."
 ENDIF

; max ID reserved for EED internal use
 IF (DATA_ID_SIZE==1)
 RECORD_ID_MAX:          EQU    $FF
 ELSE 
 RECORD_ID_MAX:          EQU    $FFFF
 ENDIF


;EEPROM size is user configurable.
EEPROM_SIZE:             EQU  $FE

;Number of Data Records is calculated if we know the total Data Size.
 IF (EEPROM_SIZE % DATA_SIZE == 0)

DATA_RECORD_NUMBER:      EQU  (EEPROM_SIZE/DATA_SIZE)

 ELSE

DATA_RECORD_NUMBER:      EQU  ((EEPROM_SIZE/DATA_SIZE)+1)

 ENDIF
;Data Record Size can be calculated as sum of Status,ID and Size.
DATA_RECORD_SIZE:        EQU  (DATA_STATUS_SIZE+DATA_ID_SIZE+DATA_SIZE)

RECORD_LENGTH:           EQU  DATA_RECORD_SIZE

;****************************************************************************
;Macro to determine the total number of sectors alloted for EEPROM Emulation.
;****************************************************************************

;Sector Size actually used to store data.
EED_SECTOR_CAPACITY:     EQU  ((EED_SECTOR_SIZE-3)/DATA_RECORD_SIZE)

;Number of sectors rEQUired to store the specified EEPROM size
 IF (DATA_RECORD_NUMBER % EED_SECTOR_CAPACITY == 0)

 EED_SECTOR_NUMBER:      EQU  (DATA_RECORD_NUMBER/EED_SECTOR_CAPACITY)

 ELSE

EED_SECTOR_NUMBER:       EQU  ((DATA_RECORD_NUMBER/EED_SECTOR_CAPACITY) + 1)

 ENDIF

EED_READY_SECTORS:       EQU  $1
;Total number of sectors alloted will also include some 'alternative sectors'
EED_SECTORS_ALLOTED:     EQU  (EED_SECTOR_NUMBER+EED_READY_SECTORS)

;**********************************************************
;End of Macro
;**********************************************************


;Start Address of Flash for EEPROM emulation. 
EFLASH_START_ADDRESS:    EQU   $8000

;**********************************************************
;Macro to determine the End Address of the emulated EEPROM .
;**********************************************************

;End Address of Flash from EEPROM emulation.
EFLASH_END_ADDRESS:      EQU    (EFLASH_START_ADDRESS + (EED_SECTORS_ALLOTED*EED_SECTOR_SIZE)-1)

;**********************************************************
;End of Macro
;**********************************************************

;**********************************************************
;Macro to determine the number of IDs to be stored in Cache table .
;**********************************************************

;End Address of Flash from EEPROM emulation.
EED_CACHETABLE_ENTRY:    EQU    ($8)

;**********************************************************
;Macro to denote the sector status
;**********************************************************
EE_SECTOR_ACTIVE:        EQU   ($00)
EE_SECTOR_ALTERNATIVE:   EQU   ($55)
EE_SECTOR_BLANK:         EQU   ($FF)
EE_SECTOR_UPDATE:        EQU   ($AA)

;**********************************************************
;End of Macro
;**********************************************************


;**********************************************************
;Macro to denote the Flash Start Address and Flash End 
;Address
;**********************************************************
FLASH_START_ADDRESS:     EQU   ($8000)
FLASH_END_ADDRESS:       EQU   ($BFFF)
;NOTE:User has to define these addresses based on the size
;of FLASH being used in his HCS08 Micro
EE_BOUNDARY_CHECK:       EQU   ($00)
;1 if boundary check is required in FSL_Erase and FSL_Program
;0 if boundary check is NOT required in FSL_Erase and 
;FSL_Program
;**********************************************************
;End of Macro
;**********************************************************
