;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2006, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                                                                       *
;*               EEPROM Emulation Driver for HCS08 eNVM                  *
;*                                                                       *
;* FILE NAME     :  ssd_sgf.inc                                          *
;* DATE          :  03.16.2006                                           *
;* AUTHOR        :  Infosys Team, Mysore                                 *
;* EMAIL         :  r56611@freescale.com                                 *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   03.16.2006      Venkatesh_G    Initial Version
;*************************************************************************

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;flash control register base
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SGF_REG_BASE:                equ $1820
                            
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;flash control and status registers
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SGF_FCDIV:                   equ ($0 + SGF_REG_BASE)   ;clock divider register
SGF_FOPT:                    equ ($1 + SGF_REG_BASE)   ;option register
SGF_FCNFG:                   equ ($3 + SGF_REG_BASE)   ;configuration register
SGF_FPROT:                   equ ($4 + SGF_REG_BASE)   ;protection register
SGF_FSTAT:                   equ ($5 + SGF_REG_BASE)   ;flash status register
SGF_FCMD:                    equ ($6 + SGF_REG_BASE)   ;flash command register

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;bit position masks of flash control registers  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Flash clock divider register 
SGF_FCDIV_DIVLD:             equ %10000000    ;clock divider loaded
SGF_FCDIV_PRDIV8:            equ %01000000    ;enable prescale by 8
SGF_FCDIV_DIV:               equ %00111111    ;flash clock divider field
SGF_FCDIV_DIV5:              equ %00100000    ;flash clock divider bits (high)
SGF_FCDIV_DIV4:              equ %00010000    ; "
SGF_FCDIV_DIV3:              equ %00001000    ; "
SGF_FCDIV_DIV2:              equ %00000100    ; "
SGF_FCDIV_DIV1:              equ %00000010    ; "
SGF_FCDIV_DIV0:              equ %00000001    ;flash clock divider bits (low)

                                              
;flash options register   
SGF_FOPT_KEYEN:              equ %10000000    ;enable backdoor key to security
SGF_FOPT_FNORED:             equ %01000000    ;vector redirection enable
SGF_FOPT_SEC:                equ %00000011    ;security state code field
SGF_FOPT_SEC1:               equ %00000010    ;security state code (high)
SGF_FOPT_SEC0:               equ %00000001    ;security state code (low)
               
;flash configuration register
SGF_FCNFG_KEYACC:            equ %00100000    ;enable security key writing

;flash protection register
SGF_FPROT_FPOPEN:            equ %10000000    ;open unprotected flash for program/erase
SGF_FPROT_FPDIS:             equ %01000000    ;flash protection disable
SGF_FPROT_FPS:               equ %00111000    ;flash protect size select field
SGF_FPROT_FPS2:              equ %00100000    ;flash protect size select (high)
SGF_FPROT_FPS1:              equ %00010000    
SGF_FPROT_FPS0:              equ %00001000    ;flash protect size select (low)

;flash status register                        
SGF_FSTAT_FCBEF:             equ %10000000    ;flash command buffer empty flag
SGF_FSTAT_FCCF:              equ %01000000    ;flash command complete flag
SGF_FSTAT_FPVIOL:            equ %00100000    ;flash protection violation
SGF_FSTAT_FACCERR:           equ %00010000    ;flash access error
SGF_FSTAT_FBLANK:            equ %00000100    ;flash verified as all blank flag

;flash command register
SGF_FCMD_FCMD:               equ %11111111    ;flash command all bits
SGF_FCMD_FCMD7:              equ %10000000    ;flash command (high)   
SGF_FCMD_FCMD6:              equ %01000000    ; "                     
SGF_FCMD_FCMD5:              equ %00100000    ; "                     
SGF_FCMD_FCMD4:              equ %00010000    ; "                     
SGF_FCMD_FCMD3:              equ %00001000    ; "                     
SGF_FCMD_FCMD2:              equ %00000100    ; "                     
SGF_FCMD_FCMD1:              equ %00000010    ; "                     
SGF_FCMD_FCMD0:              equ %00000001    ;flash command (low)    

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;operation command codes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CMD_BYTE_PROG:               equ $20    ;byte program
CMD_BURST_PROG:              equ $25    ;burst program
CMD_PAGE_ERASE:              equ $40    ;page erase
CMD_MASS_ERASE:              equ $41    ;mass erase

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;return codes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SGF_OK:                      equ $00
SGF_ERROR_BACKDOOR_DISABLED: equ $01    ;backdoor key mechanism disabled
SGF_ERROR_INVALID_KEY:       equ $02    ;supplied backdoor key is invalid 
SGF_ERROR_VERIFY:            equ $04    ;there is non blank byte or mismatch byte
SGF_ERROR_ACCERR:            equ $10    ;flash operation causes access error
SGF_ERROR_PVIOL:             equ $20    ;flash operation causes protection violation
SGF_ERROR_SECURITY_ENABLED:  equ $40    ;flash is in secured state
SGF_ERROR_CLOCK_SETTING:     equ $80    ;clock divider setting error
                                        

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;call back step counters
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CALLBACK_DV:                 equ $30    ;call back step for verifying operation
CALLBACK_CS:                 equ $50    ;call back step for check sum operation

 IFNDEF NULL_CALLBACK
 NULL_CALLBACK:           EQU    $FFFF
 ENDIF
