;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2009, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                 EEPROM Emulation Driver for LG32                      *
;*                                                                       *
;* FILE NAME     :  NormalDemo.asm                                       *
;* DATE          :  19.01.2009                                           *
;* AUTHOR        :  Reference Design Team                                *
;* EMAIL         :  rfdsnIDC@freescale.com                               *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   19.01.2009      Saurabh Jhamb           Initial Version
;*************************************************************************

;1. Normal flash demo with EEPROM Emulation Driver for HCS08;
;2. Demo 5 high level functions in total:
;    FSL_InitEeprom
;    FSL_WriteEeprom
;    FSL_ReadEeprom
;    FSL_DeinitEeprom
;    FSL_ReportEepromStatus
;
;
; initStack     0x0880
;
; EEPROM Cluster Configuration:   
; Sector Size: 0x200
;
; **************************************************************************
    
        XDEF main, Entry
        XDEF cbSize, cbSizeN
    
    INCLUDE "EED_Flash.inc"
    INCLUDE "mc9s08lg32.inc"
        
    XREF FSL_InitEeprom, FSL_WriteEeprom, FSL_ReadEeprom, 
    XREF FSL_DeinitEeprom, FSL_ReportEepromStatus, FSL_Erase
    XREF FSL_InitUart, FSL_PrintUart

    XREF.B HVSubSize, HVSubSizeN
    XREF.B recID, erasingCycles, failedAddress, destination, cbAddr
    XREF.B emuStartAddr, emuEndAddr, emuBlank
    XREF.B hvonstack, hvPosition, size, emuBuffer, hvCopyFr, hvCopyTo 
    XREF.B startAddr, buffer, endAddr, cacheTable, emuCount
    
initStack   EQU $0820;$0880            ; stack starting address 

AppData: SECTION
    SRC_BUFF:   ds.b 1               ; source buffer
    data_id:   ds.b 1
END SECTION 

REC_ID_0    EQU $00              ; define the record ID 0
REC_ID_1    EQU $01              ; define the record ID 1
REC_ID_2    EQU $02              ; define the record ID 2
REC_ID_3    EQU $03              ; define the record ID 3
REC_ID_4    EQU $04              ; define the record ID 4
REC_ID_5    EQU $05              ; define the record ID 5

CallBack:
    STA    $1800                   ;service COP
    RTS
    
;the following two macros are used to find the size of the callback function    
cbSize:    EQU    (*-CallBack)
cbSizeN:    EQU   -(*-CallBack)

; Important Notes:
; This demo links all the EED and demo code into flash. For the high-voltage
; operation EED will automatically copy them from flash to stack and run from
; stack.Please ensure there are at least 29 bytes reserved in stack for 
; copying high-voltage operation code. During High voltage operation COP 
; watchdog timer is serviced by the CallBack function. Since HCS08 does not 
; support RWW, user has to take care to copy the callback function onto 
; the stack. The procedure to copy the callback function on to the stack is 
; shown in this demo program.
main:
Entry:
    LDHX    #initStack           ; initialize Stack pointer
    TXS
    SEI                          ; disable interrupts

    lda     #$43
    sta     $1802                 ;disable COP, BKGD and RST pin enable
        
    lda     #$06
    sta     ICSC1                ;clock settings

    AIS     #cbSizeN             ; allocate some space for CALLBACK on stack
    TSX

    STHX    cbAddr               ; store the stack address for calback function
    
    LDHX    #CallBack	         ; parameter hvCopyFr is reused for copying
                                 ;purpose of CallBack function onto stack 
    STHX    hvCopyFr
    JSR     CBCopyDown	         ; function for copying Callback function onto 
                                 ;stack
    clra
    sta     ICSC2
    lda     #$60
    sta     ICSSC
    lda     #$80
    sta     ICSTRM
    
    CLRA
    STA     data_id
    
    ;; FSL_InitEerprom
    JSR     FSL_InitEeprom       ; call FSL_InitEeprom to initialize the EEPROM
    TSTA                         ; Check the return code
    BEQ     go_on1    
    JMP     Demo_Fail	         ; if any error, end the demo

go_on1:
    JSR     FSL_InitUart       ; call FSL_InitUart to initialize prints thru UART
    TSTA
    BEQ     go_on
    JMP     Demo_Fail	         ; if any error, end the demo

go_on:

    ;lda     #'A'
    ;ldx     #10
print:
    ;jsr     FSL_PrintUart
    ;inca
    ;dbnzx   print

read_existing_data:               ;read existing data
    LDA     #REC_ID_1             ;red ID 0
    STA     recID
    JSR     FSL_ReadEeprom        ;call FSL_ReadEeprom to read it from EEPROM
    TSTA
    BEQ     data_found            ;if data found then goto data_found

no_data_found:
    LDA     #$0A
    JSR     FSL_PrintUart
    LDA     #$0D
    JSR     FSL_PrintUart
    LDA     #'E'
    JSR     FSL_PrintUart
    LDA     #'M'
    JSR     FSL_PrintUart
    LDA     #'P'
    JSR     FSL_PrintUart
    LDA     #'T'
    JSR     FSL_PrintUart
    LDA     #'Y'
    JSR     FSL_PrintUart
    BRA     erase_old_values

printrec:                         ;Print the header information
    PSHA
    LDA     #$0A
    JSR     FSL_PrintUart
    LDA     #$0D
    JSR     FSL_PrintUart
    LDA     #$49
    JSR     FSL_PrintUart
    LDA     #$44
    JSR     FSL_PrintUart
    PULA
    ADD     #$30
    JSR     FSL_PrintUart
    LDA     #$2D
    JSR     FSL_PrintUart
    RTS

printdata:
    LDHX    destination
    LDA     ,X
    CLRH
    LDX     #100
    DIV
    ADD     #$30
    JSR     FSL_PrintUart
    PSHH
    CLRH
    PULA
    LDX     #10
    DIV
    ADD     #$30
    JSR     FSL_PrintUart
    PSHH
    CLRH
    PULA
    ADD     #$30
    JSR     FSL_PrintUart
    RTS

data_found:                       ;if data is found
    LDA     #1
    JSR     printrec
    LDHX    destination
    LDA     ,X
    STA     data_id
    JSR     printdata

    LDA     #REC_ID_2             ;read 2nd data
    STA     recID
    JSR     FSL_ReadEeprom        ;read by calling FSL_ReadEeprom
    TSTA
    BNE     erase_old_values      ;if not found then erase old values
    LDA     #2
    JSR     printrec
    JSR     printdata

erase_old_values:
    JSR     FSL_DeinitEeprom     ; call FSL_DeinitEeprom to de-initlaize the EEPROM
    TSTA                         ; check the return code
    BNE     Demo_Fail1            ; if any error, end the demo
    
    JSR     FSL_InitEeprom       ; call FSL_InitEeprom to initialize the EEPROM
    TSTA                         ; Check the return code
    BNE     Demo_Fail1	         ; if any error, end the demo

write_new_values:
    LDX     data_id
    INCX
    STX     SRC_BUFF
    LDHX    #SRC_BUFF
    STHX    emuBuffer            ; store the user's data in emubuffer
    LDA     #REC_ID_1
    STA     recID
    JSR     FSL_WriteEeprom
    TSTA
    BNE     Demo_Fail1
    
    LDX     data_id
    INCX
    INCX
    STX     SRC_BUFF
    LDHX    #SRC_BUFF
    STHX    emuBuffer            ; store the user's data in emubuffer
    LDA     #REC_ID_2
    STA     recID
    JSR     FSL_WriteEeprom
    TSTA
    BEQ     Demo_End

Demo_Fail1:
    LDA     #$0A
    JSR     FSL_PrintUart
    LDA     #$0D
    JSR     FSL_PrintUart
    LDA     #'F'
    JSR     FSL_PrintUart
    LDA     #'A'
    JSR     FSL_PrintUart
    LDA     #'I'
    JSR     FSL_PrintUart
    LDA     #'L'
    JSR     FSL_PrintUart
    BRA *
    
    BRA     Demo_End

    ; FSL_DeinitEeprom
    ; The erase cycle is saved in global parameter - "erasingCycles"
    ; "startAddr"- indiactes the Eeprom emulation start address
    ; "endAddr"- indiactes the Eeprom emulation end address
    ; "size"- indicates number of sectors alloted for eeprom emulation
    JSR     FSL_DeinitEeprom     ; call FSL_DeinitEeprom to de-initlaize the EEPROM
    TSTA                         ; check the return code
    BNE     Demo_Fail            ; if any error, end the demo
    
    LDA     #$b0                 ; data id is not in Cache Table 
    STA     recID                ; save the data ID in EED global parameter
    
    JMP    Demo_End
;***************************************************************************
;* CBCopyDown:
;* Copy the callback function from Flash into stack (pointed by cbAddr).
;*
;* hvCopyTo the destination location for copy down
;* hvCopyFr the source location for copy down
;***************************************************************************
CBCopyDown:
    LDHX    cbAddr               ; 4 cycles
    STHX    hvCopyTo             ; 4 cycles

    ; cbSize, the size to be copied, is the size of CallBack
       
    LDA     #cbSize              ; 2 cycles
    BEQ     Copy_Done            ; 3 cycles

CopyLoop:
    LDHX    hvCopyFr             ; 4 cycles
    PSHA                         ; 2 cycles
    LDA     ,X                   ; get the data, 3 cycles
    AIX     #1                   ; 2 cycles
    STHX    hvCopyFr             ; update the source location, 4 cycles
    LDHX    hvCopyTo             ; 4 cycles
    STA     ,X                   ; save the data, 2 cycles
    AIX     #1                   ; 2 cycles
    STHX    hvCopyTo             ; udpate the destination location, 4 cycles
    PULA                         ; 3 cycles
    DBNZA   CopyLoop             ; 4 cycles
		        
Copy_Done:
    RTS                          ; 6 cycles

Demo_Fail:
    BRA     *                     ; set breakpoint here before runnning the demo

Demo_End:
    AIS     #cbSize
    LDA     #$0A
    JSR     FSL_PrintUart
    LDA     #$0D
    JSR     FSL_PrintUart
    LDA     #'F'
    JSR     FSL_PrintUart
    LDA     #'I'
    JSR     FSL_PrintUart
    LDA     #'N'
    JSR     FSL_PrintUart
    LDA     #'I'
    JSR     FSL_PrintUart
    LDA     #'S'
    JSR     FSL_PrintUart
    LDA     #'H'
    JSR     FSL_PrintUart
    BRA     *                     ; set breakpoint here before runnning the demo
    END


[HI-WAVE]
MainFrame=0,1,-1,-1,-1,-1,77,89,1277,901
TOOLBAR=57600 57601 32795 0 57635 57634 57637 0 57671 57669 0 32777 32776 32782 32780 32781 32778 0 32806
