;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2009, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                 EEPROM Emulation Driver for LG32                      *
;*                                                                       *
;* FILE NAME     :  HighVoltage.asm                                      *
;* DATE          :  19.01.2009                                           *
;* AUTHOR        :  Reference Design Team                                *
;* EMAIL         :  rfdsnIDC@freescale.com                               *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   19.01.2009      Saurabh Jhamb           Initial Version
;*************************************************************************

;*************************************************************************
;*   UINT8 HighVoltage (void) 
;*      Critical high voltage part of a command sequence. 
;*
;*   Main steps in function are: 
;*      s1. launch command;
;*      s2. check error;
;*      s3. wait FSTAT[FCCF] flag set
;*   
;*   Calling convention: 
;*        This function is for internal use only. This function will use
;*        the CallBack address in the caller's stack directly.
;*   
;*   Return code:
;*        return 8-bit value through A
;*   
;*   Stack map:
;*         |                | <- sp (after jsr)
;*         | ReturnAddr msb | 
;*         | ReturnAddr lsb | <- sp (after rts)
;*         | CALLBACK msb   | 
;*         | CALLBACK lsb   | 
;*   
;*   Changes: A, H and X 
;*
;*   Notes: 
;*      1. This function is called by ByteProgram and FlashErase internally.
;*         It shouldn't be directly called by users.
;*      2. This function should be located in RAM.
;*************************************************************************

        XDEF HighVoltage
        XDEF.B HVSubSize, HVSubSizeN
        INCLUDE "ssd_sgf.inc"

HighVoltage:
            ldhx  #SGF_FSTAT  ;load FSTAT address
            lda   #SGF_FSTAT_FCBEF ;A <- $80
            sta   ,x          ;launch command

            lda   ,x          ;check error flags in FSTAT
            and   #(SGF_ERROR_PVIOL|SGF_ERROR_ACCERR) ;reserve FSTAT[PVIOL,ACCERR] bits
            beq   waitFCCF       
            sta   ,x          ;clear error flag
            
waitFCCF:
            psha              ;save result
            ldhx  4,sp        ;load H:X with CallBack function address and call CallBack
            cphx  #NULL_CALLBACK    ; check if callback has to be bypassed 
            beq   SkipCallBack1     ; if yes skip callback 
            jsr   ,x          ;call CallBack function
            
SkipCallBack1:            
            ldx   SGF_FSTAT   ;check FSTAT[FCCF] if it is high
            aslx              ;command is finished when FSTAT[FCCF] is high
            pula
            bpl   waitFCCF    ;wait until FSTAT[FCCF] goes high

            rts   

HVSubSize: EQU   (* - HighVoltage)
HVSubSizeN: EQU   -(HVSubSize)