/******************************************************************************
*                                                  COPYRIGHT (c) Freescale 2009
* FILE NAME: eeprom_wrapper.h     REVISION 1.0
*                                                                           
* PURPOSE: Contains the C wrapper functions for EEPROM Emulation driver
*                                                                           
*******************************************************************************
*******************************************************************************  
**  THIS CODE IS ONLY INTENDED AS AN EXAMPLE FOR THE CODEWARRIOR COMPILER    **  
**      AND THE S08 EVB AND HAS ONLY BEEN GIVEN A MIMIMUM LEVEL OF TEST.     **  
**  IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES AND NO PROMISE OF SUPPORT.   **  
*******************************************************************************  

*******************************************************************************
Freescale reserves the right	to make	changes	without	further	notice to any
product	herein to improve reliability, function	or design. Freescale	does not
assume any liability arising out of	the	application	or use of any product,
circuit, or software described	herein;	neither	does it	convey any license
under its patent rights	nor	the	rights of others. Freescale products are	not
designed, intended,	or authorized for use as components	in systems  intended for
surgical implant into the body, or	other applications intended to support life,
or	for	any	other application in which the failure of the  Freescale product
could create a	situation where	personal injury	or death may occur. Should
Buyer	purchase or	use	Freescale products for any such unintended or
unauthorized	application, Buyer shall idemnify and hold Freescale	and	its
officers, employees, subsidiaries, affiliates, and distributors	harmless
against	all	claims costs, damages, and expenses, and reasonable	attorney fees 
arising	out	of,	directly or	indirectly,	any	claim of personal injury or	death
associated with	such unintended	or unauthorized use,	even if	such claim alleges
that Freescale was negligent	regarding the design or	manufacture	of the part.
Freescale and the Freescale logo*	are	registered trademarks of Freescale Ltd.
*******************************************************************************
*******************************************************************************
*
*
* DESCRIPTION:  file for EEPROM driver
*
* NOTE:
*
* AUTHOR: Saurabh Jhamb        LOCATION: IDC      LAST EDIT DATE: 24APR09
*
******************************************************************************/
#include "eeprom_wrapper.h"    //wrapper for C over assembly

unsigned char FSL_InitEeprom_Wrapper()
{
  unsigned char retval;
  asm
  {
    LDHX #$FFFF
    STHX cbAddr
  }
  FSL_InitEeprom();

  asm
  {
    STA retval
  }
  return retval;
}

unsigned char FSL_ReadEeprom_Wrapper(unsigned char recid)
{
  unsigned char retval;
  asm
  {
    LDA     recid
    STA     recID
  }
  FSL_ReadEeprom();

  asm
  {
    STA retval
  }
  return retval;
}

unsigned char FSL_WriteEeprom_Wrapper(unsigned char recid, unsigned char* dataptr)
{
  unsigned char retval;
  asm
  {
    LDA     recid
    STA     recID
    
    LDHX    dataptr
    STHX    emuBuffer
  }
  FSL_WriteEeprom();

  asm
  {
    STA retval
  }
  return retval;
}

unsigned char FSL_DeinitEeprom_Wrapper()
{
  unsigned char retval;

  FSL_DeinitEeprom();

  asm
  {
    STA retval
  }
  return retval;
}