/**************************************************************************
 * FILE NAME: MPC5748G.h                     COPYRIGHT (c) Freescale 2014 *
 * REVISION:  4.0.00                                  All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5748G.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.1.0      P.A.      24-SEP-12     -First release.                     *
 *                                                                        *
 * 0.1.1      P.A.      25-SEP-12     -TCD registers were set in the same *
 *                                    way than other MCUs as McKinley and *
 *                                    Panther.                            *
 *                                    -USB modules were added.            *
 *                                                                        *
 * 0.2.0      M.D.      06-MAY-13     -First release with new generation  *
 *                                    method.                             *
 *                                    -Does not include BCTU & EMIOS      *
 *                                                                        *
 * 0.3.0      M.D.      14-MAY-13     -Corrected size of CAN message      *
 *                                    buffer. Added eMIOS module.         *
 *                                                                        *
 * 0.3.1      M.D.      15-MAY-13     -Added BCTU, eMIOS200 modules       *
 *                                                                        *
 * 1.0.0      M.D.      16-MAY-13     -Expanded registers for bit access  *
 *                                     In BCTU: SFTRGR1, SFTRGR2, SFTRGR3 *
 *                                     In FCCU: NCF_CFG, NCFS_CFG, NCF_S, *
 *                                     NCF_E, NCF_TOE, IRQ_ALARM_EN,      *
 *                                     NMI_EN, and EOUT_SIG_EN            *
 *                                    -Updated MC_RGM module              *
 *                                                                        *
 * 1.0.1      M.D.      30-MAY-13     -Added SPI                          *
 *                                                                        *
 * 1.0.2      M.D.      27-JUN-13     -Changed GPDO & GPDI array sizes    *
 *                                     from 511 to 512                    *
 *                                                                        *
 * 1.0.3      M.D.      16-AUG-13     -Regenerated with updated generation*
 *                                     program and now SFTRG1,2,3 in BCTU *
 *                                     and NCF_CFG, NCFS_CFG, NCF_S, NCF_E*
 *                                     NCF_TOE, IRQ_ALARM_EN, NMI_EN,     *
 *                                     EOUT_SIG_EN in FCCU have correct   *
 *                                     names for bit positions.           *
 *                                                                        *
 * 2.1.0      M.D.      25-SEP-13     -Regenerated from RDP 2.1           *
 *                                                                        *
 * 2.1.1      M.D.      26-SEP-13     -Corrected endian of registers      *
 *                                                                        *
 * 2.1.2      M.D.      30-SEP-13     -Regenerated with updated ADC       *
 *                                                                        *
 * 2.1.3      M.D.      02-OCT-13     -Corrected some macro definitions:  *
 *                                     ADC, BCTU, ENET, MC_ME             *
 *                                                                        *
 * 2.1.4      M.D.      10-OCT-13     -Regenerated with updates to MEMU_0,*
 *                                     PIT, SPI, and CAN_0(start address) *
 *                                                                        *
 * 2.1.5      M.D.      18-OCT-13     -Removed old SPI_0 macros           *
 *                                                                        *
 * 2.1.6      M.D.      31-OCT-13     -Updated base address for eMIOS_UC  *
 *                                                                        *
 * 2.1.7      M.D.      20-DEC-13     -Removed '_' from macros referencing*
 *                                     LISTCHR array in BCTU incorrectly  *
 *                                                                        *
 * 2.1.8      M.D.      11-FEB-14     -Changed bitfield from PPC to PPCA  *
 *                                     in UHST and UOTG modules HCSPARAMS *
 *                                     registers                          *
 *                                                                        *
 * 2.1.9      M.D.      12-FEB-14     -Corrected macro definitions for    *
 *                                     SIUL2.GPDO and SIUL2.GPDI          *   
 *                                                                        *
 * 2.1.10     M.D.      18-FEB-14     -Corrected macro definition for     *
 *                                     SIUL2.GPDI                         *   
 *                                                                        *
 * 2.1.11     M.D.      25-FEB-14     -Added STCU2.INT_FLG register       * 
 *                                                                        *
 * 2.1.12     M.D.      26-FEB-14     -Added STCU2_INT_FLG macro          * 
 *                                                                        *
 * 2.1.13     M.D.      11-MAR-14     -replaced DMA with eDMA in module   *
 *                                     address declaration                *
 *                                                                        * 
 * 3.0.00     M.D.      15-MAY-14     -regenerated from RDP/RM rev3       * 
 *                                                                        *
 * 4.0.00     M.D.      10-JUL-14     -regenerated from RDP/RM rev4       * 
 * 4.0.01     A.I.      3-OCT-14      -Manual changes                     * 
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5748G_H_
#define _MPC5748G_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

struct ADC_tag {
  union {                              /* Main Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t OWREN:1;               /* Overwrite enable. */
      vuint32_t WLSIDE:1;              /* Write Left/Right aligned. */
      vuint32_t MODE:1;                /* One_Shot/Scan. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t NSTART:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t JSTART:1;              /* Injection start. */
      vuint32_t  :2;
      vuint32_t CTUEN:1;               /* Crosstrigger Unit Enable. */
      vuint32_t CTU_MODE:1;            /* Crosstrigger Unit MODE bit */
      vuint32_t  :1;
      vuint32_t  :6;
      vuint32_t ADCLKSEL:1;            /* Analog Clock frequency Selector. */
      vuint32_t ABORT_CHAIN:1;         /* Abort Chain. */
      vuint32_t ABORT:1;               /* Abort Conversion. */
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t REFSEL:2;              /* Reference voltage selection for ADC analog part. */
      vuint32_t PWDN:1;                /* Power-down enable. */
    } B;
  } MCR;

  union {                              /* Main Status register */
    vuint32_t R;
    struct {
      vuint32_t CALIBRTD:1;            /* This bit indicates the ADC calibration status. */
      vuint32_t  :6;
      vuint32_t NSTART:1;              /* This status bit is used to signal that a Normal conversion is ongoing. */
      vuint32_t JABORT:1;
      vuint32_t  :2;
      vuint32_t JSTART:1;              /* This status bit is used to signal that an Injected conversion is ongoing. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t CTUSTART:1;            /* This status bit is used to signal that a CTU conversion is ongoing. */
      vuint32_t CHADDR:7;              /* Channel under measure address. */
      vuint32_t  :3;
      vuint32_t ACKO:1;                /* Auto clock off enable. */
      vuint32_t  :2;
      vuint32_t ADCSTATUS:3;           /* Status of the ADC. */
    } B;
  } MSR;

  uint8_t ADC_reserved0[8];
  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t EOCTU:1;
      vuint32_t JEOC:1;                /* End of injected channel conversion. */
      vuint32_t JECH:1;                /* End of injected chain conversion. */
      vuint32_t EOC:1;                 /* End of channel conversion. */
      vuint32_t ECH:1;                 /* End of chain conversion. */
    } B;
  } ISR;

  union {                              /* Channel Pending register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t EOCCH15:1;             /* EOC Channel 15. */
      vuint32_t EOCCH14:1;             /* EOC Channel 14. */
      vuint32_t EOCCH13:1;             /* EOC Channel 13. */
      vuint32_t EOCCH12:1;             /* EOC Channel 12. */
      vuint32_t EOCCH11:1;             /* EOC Channel 11. */
      vuint32_t EOCCH10:1;             /* EOC Channel 10. */
      vuint32_t EOCCH9:1;              /* EOC Channel 9. */
      vuint32_t EOCCH8:1;              /* EOC Channel 8. */
      vuint32_t EOCCH7:1;              /* EOC Channel 7. */
      vuint32_t EOCCH6:1;              /* EOC Channel 6. */
      vuint32_t EOCCH5:1;              /* EOC Channel 5. */
      vuint32_t EOCCH4:1;              /* EOC Channel 4. */
      vuint32_t EOCCH3:1;              /* EOC Channel 3. */
      vuint32_t EOCCH2:1;              /* EOC Channel 2. */
      vuint32_t EOCCH1:1;              /* EOC Channel 1. */
      vuint32_t EOCCH0:1;              /* EOC Channel 0. */
    } B;
  } CEOCFR0;

  union {                              /* Channel Pending register 1 */
    vuint32_t R;
    struct {
      vuint32_t EOCCH63:1;             /* EOC Channel 63. */
      vuint32_t EOCCH62:1;             /* EOC Channel 62. */
      vuint32_t EOCCH61:1;             /* EOC Channel 61. */
      vuint32_t EOCCH60:1;             /* EOC Channel 60. */
      vuint32_t EOCCH59:1;             /* EOC Channel 59. */
      vuint32_t EOCCH58:1;             /* EOC Channel 58. */
      vuint32_t EOCCH57:1;             /* EOC Channel 57. */
      vuint32_t EOCCH56:1;             /* EOC Channel 56. */
      vuint32_t EOCCH55:1;             /* EOC Channel 55. */
      vuint32_t EOCCH54:1;             /* EOC Channel 54. */
      vuint32_t EOCCH53:1;             /* EOC Channel 53. */
      vuint32_t EOCCH52:1;             /* EOC Channel 52. */
      vuint32_t EOCCH51:1;             /* EOC Channel 51. */
      vuint32_t EOCCH50:1;             /* EOC Channel 50. */
      vuint32_t EOCCH49:1;             /* EOC Channel 49. */
      vuint32_t EOCCH48:1;             /* EOC Channel 48 */
      vuint32_t EOCCH47:1;             /* EOC Channel 47. */
      vuint32_t EOCCH46:1;             /* EOC Channel 46. */
      vuint32_t EOCCH45:1;             /* EOC Channel 45. */
      vuint32_t EOCCH44:1;             /* EOC Channel 44. */
      vuint32_t EOCCH43:1;             /* EOC Channel 43. */
      vuint32_t EOCCH42:1;             /* EOC Channel 42. */
      vuint32_t EOCCH41:1;             /* EOC Channel 41. */
      vuint32_t EOCCH40:1;             /* EOC Channel 40. */
      vuint32_t EOCCH39:1;             /* EOC Channel 39. */
      vuint32_t EOCCH38:1;             /* EOC Channel 38. */
      vuint32_t EOCCH37:1;             /* EOC Channel 37. */
      vuint32_t EOCCH36:1;             /* EOC Channel 36. */
      vuint32_t EOCCH35:1;             /* EOC Channel 35. */
      vuint32_t EOCCH34:1;             /* EOC Channel 34. */
      vuint32_t EOCCH33:1;             /* EOC Channel 33. */
      vuint32_t EOCCH32:1;             /* EOC Channel 32. */
    } B;
  } CEOCFR1;

  union {                              /* Channel Pending register 2 */
    vuint32_t R;
    struct {
      vuint32_t EOCCH95:1;             /* EOC Channel 95. */
      vuint32_t EOCCH94:1;             /* EOC Channel 94. */
      vuint32_t EOCCH93:1;             /* EOC Channel 93. */
      vuint32_t EOCCH92:1;             /* EOC Channel 92. */
      vuint32_t EOCCH91:1;             /* EOC Channel 91. */
      vuint32_t EOCCH90:1;             /* EOC Channel 90. */
      vuint32_t EOCCH89:1;             /* EOC Channel 89. */
      vuint32_t EOCCH88:1;             /* EOC Channel 88. */
      vuint32_t EOCCH87:1;             /* EOC Channel 87. */
      vuint32_t EOCCH86:1;             /* EOC Channel 86. */
      vuint32_t EOCCH85:1;             /* EOC Channel 85. */
      vuint32_t EOCCH84:1;             /* EOC Channel 84. */
      vuint32_t EOCCH83:1;             /* EOC Channel 83. */
      vuint32_t EOCCH82:1;             /* EOC Channel 82. */
      vuint32_t EOCCH81:1;             /* EOC Channel 81. */
      vuint32_t EOCCH80:1;             /* EOC Channel 80. */
      vuint32_t EOCCH79:1;             /* EOC Channel 79. */
      vuint32_t EOCCH78:1;             /* EOC Channel 78. */
      vuint32_t EOCCH77:1;             /* EOC Channel 77. */
      vuint32_t EOCCH76:1;             /* EOC Channel 76. */
      vuint32_t EOCCH75:1;             /* EOC Channel 75. */
      vuint32_t EOCCH74:1;             /* EOC Channel 74. */
      vuint32_t EOCCH73:1;             /* EOC Channel 73. */
      vuint32_t EOCCH72:1;             /* EOC Channel 72. */
      vuint32_t EOCCH71:1;             /* EOC Channel 71. */
      vuint32_t EOCCH70:1;             /* EOC Channel 70. */
      vuint32_t EOCCH69:1;             /* EOC Channel 69. */
      vuint32_t EOCCH68:1;             /* EOC Channel 68. */
      vuint32_t EOCCH67:1;             /* EOC Channel 67. */
      vuint32_t EOCCH66:1;             /* EOC Channel 66. */
      vuint32_t EOCCH65:1;             /* EOC Channel 65. */
      vuint32_t EOCCH64:1;             /* EOC Channel 64. */
    } B;
  } CEOCFR2;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :1;
      vuint32_t  :10;
      vuint32_t MSKEOCTU:1;            /* Mask bit for EOCTU. */
      vuint32_t MSKJEOC:1;             /* Mask bit for JEOC. */
      vuint32_t MSKJECH:1;             /* Mask bit for JECH. */
      vuint32_t MSKEOC:1;              /* Mask bit for EOC. */
      vuint32_t MSKECH:1;              /* Mask bit for ECH. */
    } B;
  } IMR;

  union {                              /* Channel Interrupt Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CIM15:1;               /* Channel 15 interrupt enable. */
      vuint32_t CIM14:1;               /* Channel 14 interrupt enable. */
      vuint32_t CIM13:1;               /* Channel 13 interrupt enable. */
      vuint32_t CIM12:1;               /* Channel 12 interrupt enable. */
      vuint32_t CIM11:1;               /* Channel 11 interrupt enable. */
      vuint32_t CIM10:1;               /* Channel 10 interrupt enable. */
      vuint32_t CIM9:1;                /* Channel 9 interrupt enable. */
      vuint32_t CIM8:1;                /* Channel 8 interrupt enable. */
      vuint32_t CIM7:1;                /* Channel 7 interrupt enable. */
      vuint32_t CIM6:1;                /* Channel 6 interrupt enable. */
      vuint32_t CIM5:1;                /* Channel 5 interrupt enable. */
      vuint32_t CIM4:1;                /* Channel 4 interrupt enable. */
      vuint32_t CIM3:1;                /* Channel 3 interrupt enable. */
      vuint32_t CIM2:1;                /* Channel 2 interrupt enable. */
      vuint32_t CIM1:1;                /* Channel 1 interrupt enable. */
      vuint32_t CIM0:1;                /* Channel 0 interrupt enable. */
    } B;
  } CIMR0;

  union {                              /* Channel Interrupt Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CIM63:1;               /* Channel 63 interrupt enable. */
      vuint32_t CIM62:1;               /* Channel 62 interrupt enable. */
      vuint32_t CIM61:1;               /* Channel 61 interrupt enable. */
      vuint32_t CIM60:1;               /* Channel 60 interrupt enable. */
      vuint32_t CIM59:1;               /* Channel 59 interrupt enable. */
      vuint32_t CIM58:1;               /* Channel 58 interrupt enable. */
      vuint32_t CIM57:1;               /* Channel 57 interrupt enable. */
      vuint32_t CIM56:1;               /* Channel 56 interrupt enable. */
      vuint32_t CIM55:1;               /* Channel 55 interrupt enable. */
      vuint32_t CIM54:1;               /* Channel 54 interrupt enable. */
      vuint32_t CIM53:1;               /* Channel 53 interrupt enable. */
      vuint32_t CIM52:1;               /* Channel 52 interrupt enable. */
      vuint32_t CIM51:1;               /* Channel 51 interrupt enable. */
      vuint32_t CIM50:1;               /* Channel 50 interrupt enable. */
      vuint32_t CIM49:1;               /* Channel 49 interrupt enable. */
      vuint32_t CIM48:1;               /* Channel 48 interrupt enable. */
      vuint32_t CIM47:1;               /* Channel 47 interrupt enable. */
      vuint32_t CIM46:1;               /* Channel 46 interrupt enable. */
      vuint32_t CIM45:1;               /* Channel 45 interrupt enable. */
      vuint32_t CIM44:1;               /* Channel 44 interrupt enable. */
      vuint32_t CIM43:1;               /* Channel 43 interrupt enable. */
      vuint32_t CIM42:1;               /* Channel 42 interrupt enable. */
      vuint32_t CIM41:1;               /* Channel 41 interrupt enable. */
      vuint32_t CIM40:1;               /* Channel 40 interrupt enable. */
      vuint32_t CIM39:1;               /* Channel 39 interrupt enable. */
      vuint32_t CIM38:1;               /* Channel 38 interrupt enable. */
      vuint32_t CIM37:1;               /* Channel 37 interrupt enable. */
      vuint32_t CIM36:1;               /* Channel 36 interrupt enable. */
      vuint32_t CIM35:1;               /* Channel 35 interrupt enable. */
      vuint32_t CIM34:1;               /* Channel 34 interrupt enable. */
      vuint32_t CIM33:1;               /* Channel 33 interrupt enable. */
      vuint32_t CIM32:1;               /* Channel 32 interrupt enable. */
    } B;
  } CIMR1;

  union {                              /* Channel Interrupt Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CIM95:1;               /* Channel 95 interrupt enable. */
      vuint32_t CIM94:1;               /* Channel 94 interrupt enable. */
      vuint32_t CIM93:1;               /* Channel 93 interrupt enable. */
      vuint32_t CIM92:1;               /* Channel 92 interrupt enable. */
      vuint32_t CIM91:1;               /* Channel 91 interrupt enable. */
      vuint32_t CIM90:1;               /* Channel 90 interrupt enable. */
      vuint32_t CIM89:1;               /* Channel 89 interrupt enable. */
      vuint32_t CIM88:1;               /* Channel 88 interrupt enable. */
      vuint32_t CIM87:1;               /* Channel 87 interrupt enable. */
      vuint32_t CIM86:1;               /* Channel 86 interrupt enable. */
      vuint32_t CIM85:1;               /* Channel 85 interrupt enable. */
      vuint32_t CIM84:1;               /* Channel 84 interrupt enable. */
      vuint32_t CIM83:1;               /* Channel 83 interrupt enable. */
      vuint32_t CIM82:1;               /* Channel 82 interrupt enable. */
      vuint32_t CIM81:1;               /* Channel 81 interrupt enable. */
      vuint32_t CIM80:1;               /* Channel 80 interrupt enable. */
      vuint32_t CIM79:1;               /* Channel 79 interrupt enable. */
      vuint32_t CIM78:1;               /* Channel 78 interrupt enable. */
      vuint32_t CIM77:1;               /* Channel 77 interrupt enable. */
      vuint32_t CIM76:1;               /* Channel 76 interrupt enable. */
      vuint32_t CIM75:1;               /* Channel 75 interrupt enable. */
      vuint32_t CIM74:1;               /* Channel 74 interrupt enable. */
      vuint32_t CIM73:1;               /* Channel 73 interrupt enable. */
      vuint32_t CIM72:1;               /* Channel 72 interrupt enable. */
      vuint32_t CIM71:1;               /* Channel 71 interrupt enable. */
      vuint32_t CIM70:1;               /* Channel 70 interrupt enable. */
      vuint32_t CIM69:1;               /* Channel 69 interrupt enable. */
      vuint32_t CIM68:1;               /* Channel 68 interrupt enable. */
      vuint32_t CIM67:1;               /* Channel 67 interrupt enable. */
      vuint32_t CIM66:1;               /* Channel 66 interrupt enable. */
      vuint32_t CIM65:1;               /* Channel 65 interrupt enable. */
      vuint32_t CIM64:1;               /* Channel 64 interrupt enable. */
    } B;
  } CIMR2;

  union {                              /* Watchdog Threshold Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t WDG5H:1;
      vuint32_t WDG5L:1;
      vuint32_t WDG4H:1;
      vuint32_t WDG4L:1;
      vuint32_t WDG3H:1;
      vuint32_t WDG3L:1;
      vuint32_t WDG2H:1;
      vuint32_t WDG2L:1;
      vuint32_t WDG1H:1;
      vuint32_t WDG1L:1;
      vuint32_t WDG0H:1;
      vuint32_t WDG0L:1;
    } B;
  } WTISR;

  union {                              /* Watchdog Threshold Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MSKWDG5H:1;
      vuint32_t MSKWDG5L:1;
      vuint32_t MSKWDG4H:1;
      vuint32_t MSKWDG4L:1;
      vuint32_t MSKWDG3H:1;
      vuint32_t MSKWDG3L:1;
      vuint32_t MSKWDG2H:1;
      vuint32_t MSKWDG2L:1;
      vuint32_t MSKWDG1H:1;
      vuint32_t MSKWDG1L:1;
      vuint32_t MSKWDG0H:1;
      vuint32_t MSKWDG0L:1;
    } B;
  } WTIMR;

  uint8_t ADC_reserved1[8];
  union {                              /* DMA Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t DCLR:1;                /* DMA Clear sequence enable. */
      vuint32_t DMAEN:1;               /* DMA global enable. */
    } B;
  } DMAE;

  union {                              /* DMA Channel Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DMA15:1;               /* DMA enable for channel 15. */
      vuint32_t DMA14:1;               /* DMA enable for channel 14. */
      vuint32_t DMA13:1;               /* DMA enable for channel 13. */
      vuint32_t DMA12:1;               /* DMA enable for channel 12. */
      vuint32_t DMA11:1;               /* DMA enable for channel 11. */
      vuint32_t DMA10:1;               /* DMA enable for channel 10. */
      vuint32_t DMA9:1;                /* DMA enable for channel 9. */
      vuint32_t DMA8:1;                /* DMA enable for channel 8. */
      vuint32_t DMA7:1;                /* DMA enable for channel 7. */
      vuint32_t DMA6:1;                /* DMA enable for channel 6. */
      vuint32_t DMA5:1;                /* DMA enable for channel 5. */
      vuint32_t DMA4:1;                /* DMA enable for channel 4. */
      vuint32_t DMA3:1;                /* DMA enable for channel 3. */
      vuint32_t DMA2:1;                /* DMA enable for channel 2. */
      vuint32_t DMA1:1;                /* DMA enable for channel 1. */
      vuint32_t DMA0:1;                /* DMA enable for channel 0. */
    } B;
  } DMAR0;

  union {                              /* DMA Channel Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DMA63:1;               /* DMA enable for channel 63. */
      vuint32_t DMA62:1;               /* DMA enable for channel 62. */
      vuint32_t DMA61:1;               /* DMA enable for channel 61. */
      vuint32_t DMA60:1;               /* DMA enable for channel 60. */
      vuint32_t DMA59:1;               /* DMA enable for channel 59. */
      vuint32_t DMA58:1;               /* DMA enable for channel 58. */
      vuint32_t DMA57:1;               /* DMA enable for channel 57. */
      vuint32_t DMA56:1;               /* DMA enable for channel 56. */
      vuint32_t DMA55:1;               /* DMA enable for channel 55. */
      vuint32_t DMA54:1;               /* DMA enable for channel 54. */
      vuint32_t DMA53:1;               /* DMA enable for channel 53. */
      vuint32_t DMA52:1;               /* DMA enable for channel 52. */
      vuint32_t DMA51:1;               /* DMA enable for channel 51. */
      vuint32_t DMA50:1;               /* DMA enable for channel 50. */
      vuint32_t DMA49:1;               /* DMA enable for channel 49. */
      vuint32_t DMA48:1;               /* DMA enable for channel 48. */
      vuint32_t DMA47:1;               /* DMA enable for channel 47. */
      vuint32_t DMA46:1;               /* DMA enable for channel 46. */
      vuint32_t DMA45:1;               /* DMA enable for channel 45. */
      vuint32_t DMA44:1;               /* DMA enable for channel 44. */
      vuint32_t DMA43:1;               /* DMA enable for channel 43. */
      vuint32_t DMA42:1;               /* DMA enable for channel 42. */
      vuint32_t DMA41:1;               /* DMA enable for channel 41. */
      vuint32_t DMA40:1;               /* DMA enable for channel 40. */
      vuint32_t DMA39:1;               /* DMA enable for channel 39. */
      vuint32_t DMA38:1;               /* DMA enable for channel 38. */
      vuint32_t DMA37:1;               /* DMA enable for channel 37. */
      vuint32_t DMA36:1;               /* DMA enable for channel 36. */
      vuint32_t DMA35:1;               /* DMA enable for channel 35. */
      vuint32_t DMA34:1;               /* DMA enable for channel 34. */
      vuint32_t DMA33:1;               /* DMA enable for channel 33. */
      vuint32_t DMA32:1;               /* DMA enable for channel 32. */
    } B;
  } DMAR1;

  union {                              /* DMA Channel Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t DMA95:1;               /* DMA enable for channel 95. */
      vuint32_t DMA94:1;               /* DMA enable for channel 94. */
      vuint32_t DMA93:1;               /* DMA enable for channel 93. */
      vuint32_t DMA92:1;               /* DMA enable for channel 92. */
      vuint32_t DMA91:1;               /* DMA enable for channel 91. */
      vuint32_t DMA90:1;               /* DMA enable for channel 90. */
      vuint32_t DMA89:1;               /* DMA enable for channel 89. */
      vuint32_t DMA88:1;               /* DMA enable for channel 88. */
      vuint32_t DMA87:1;               /* DMA enable for channel 87. */
      vuint32_t DMA86:1;               /* DMA enable for channel 86. */
      vuint32_t DMA85:1;               /* DMA enable for channel 85. */
      vuint32_t DMA84:1;               /* DMA enable for channel 84. */
      vuint32_t DMA83:1;               /* DMA enable for channel 83. */
      vuint32_t DMA82:1;               /* DMA enable for channel 82. */
      vuint32_t DMA81:1;               /* DMA enable for channel 81. */
      vuint32_t DMA80:1;               /* DMA enable for channel 80. */
      vuint32_t DMA79:1;               /* DMA enable for channel 79. */
      vuint32_t DMA78:1;               /* DMA enable for channel 78. */
      vuint32_t DMA77:1;               /* DMA enable for channel 77. */
      vuint32_t DMA76:1;               /* DMA enable for channel 76. */
      vuint32_t DMA75:1;               /* DMA enable for channel 75. */
      vuint32_t DMA74:1;               /* DMA enable for channel 74. */
      vuint32_t DMA73:1;               /* DMA enable for channel 73. */
      vuint32_t DMA72:1;               /* DMA enable for channel 72. */
      vuint32_t DMA71:1;               /* DMA enable for channel 71. */
      vuint32_t DMA70:1;               /* DMA enable for channel 70. */
      vuint32_t DMA69:1;               /* DMA enable for channel 69. */
      vuint32_t DMA68:1;               /* DMA enable for channel 68. */
      vuint32_t DMA67:1;               /* DMA enable for channel 67. */
      vuint32_t DMA66:1;               /* DMA enable for channel 66. */
      vuint32_t DMA65:1;               /* DMA enable for channel 65. */
      vuint32_t DMA64:1;               /* DMA enable for channel 64. */
    } B;
  } DMAR2;

  uint8_t ADC_reserved2[16];
  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR0;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR1;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR2;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for watchdog n. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for watchdog n. */
    } B;
  } THRHLR3;

  uint8_t ADC_reserved3[16];
  union {                              /* Presampling Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t PREVAL2:2;             /* Internal voltage selection for Presampling */
      vuint32_t PREVAL1:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PREVAL0:2;             /* Internal voltage selection for Presampling. */
      vuint32_t PRECONV:1;             /* Convert Presampled value */
    } B;
  } PSCR;

  union {                              /* Presampling register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t PRES15:1;              /* Presampling enable for channel 15. */
      vuint32_t PRES14:1;              /* Presampling enable for channel 14. */
      vuint32_t PRES13:1;              /* Presampling enable for channel 13. */
      vuint32_t PRES12:1;              /* Presampling enable for channel 12. */
      vuint32_t PRES11:1;              /* Presampling enable for channel 11. */
      vuint32_t PRES10:1;              /* Presampling enable for channel 10. */
      vuint32_t PRES9:1;               /* Presampling enable for channel 9. */
      vuint32_t PRES8:1;               /* Presampling enable for channel 8. */
      vuint32_t PRES7:1;               /* Presampling enable for channel 7. */
      vuint32_t PRES6:1;               /* Presampling enable for channel 6. */
      vuint32_t PRES5:1;               /* Presampling enable for channel 5. */
      vuint32_t PRES4:1;               /* Presampling enable for channel 4. */
      vuint32_t PRES3:1;               /* Presampling enable for channel 3. */
      vuint32_t PRES2:1;               /* Presampling enable for channel 2. */
      vuint32_t PRES1:1;               /* Presampling enable for channel 1. */
      vuint32_t PRES0:1;               /* Presampling enable for channel 0. */
    } B;
  } PSR0;

  union {                              /* Presampling register 1 */
    vuint32_t R;
    struct {
      vuint32_t PRES63:1;              /* Presampling enable for channel 63. */
      vuint32_t PRES62:1;              /* Presampling enable for channel 62. */
      vuint32_t PRES61:1;              /* Presampling enable for channel 61. */
      vuint32_t PRES60:1;              /* Presampling enable for channel 60. */
      vuint32_t PRES59:1;              /* Presampling enable for channel 59. */
      vuint32_t PRES58:1;              /* Presampling enable for channel 58. */
      vuint32_t PRES57:1;              /* Presampling enable for channel 57. */
      vuint32_t PRES56:1;              /* Presampling enable for channel 56. */
      vuint32_t PRES55:1;              /* Presampling enable for channel 55. */
      vuint32_t PRES54:1;              /* Presampling enable for channel 54. */
      vuint32_t PRES53:1;              /* Presampling enable for channel 53. */
      vuint32_t PRES52:1;              /* Presampling enable for channel 52. */
      vuint32_t PRES51:1;              /* Presampling enable for channel 51. */
      vuint32_t PRES50:1;              /* Presampling enable for channel 50. */
      vuint32_t PRES49:1;              /* Presampling enable for channel 49. */
      vuint32_t PRES48:1;              /* Presampling enable for channel 48. */
      vuint32_t PRES47:1;              /* Presampling enable for channel 47. */
      vuint32_t PRES46:1;              /* Presampling enable for channel 46. */
      vuint32_t PRES45:1;              /* Presampling enable for channel 45. */
      vuint32_t PRES44:1;              /* Presampling enable for channel 44. */
      vuint32_t PRES43:1;              /* Presampling enable for channel 43. */
      vuint32_t PRES42:1;              /* Presampling enable for channel 42. */
      vuint32_t PRES41:1;              /* Presampling enable for channel 41. */
      vuint32_t PRES40:1;              /* Presampling enable for channel 40. */
      vuint32_t PRES39:1;              /* Presampling enable for channel 39. */
      vuint32_t PRES38:1;              /* Presampling enable for channel 38. */
      vuint32_t PRES37:1;              /* Presampling enable for channel 37. */
      vuint32_t PRES36:1;              /* Presampling enable for channel 36. */
      vuint32_t PRES35:1;              /* Presampling enable for channel 35. */
      vuint32_t PRES34:1;              /* Presampling enable for channel 34. */
      vuint32_t PRES33:1;              /* Presampling enable for channel 33. */
      vuint32_t PRES32:1;              /* Presampling enable for channel 32. */
    } B;
  } PSR1;

  union {                              /* Presampling register 2 */
    vuint32_t R;
    struct {
      vuint32_t PRES95:1;              /* Presampling enable for channel 95. */
      vuint32_t PRES94:1;              /* Presampling enable for channel 94. */
      vuint32_t PRES93:1;              /* Presampling enable for channel 93. */
      vuint32_t PRES92:1;              /* Presampling enable for channel 92. */
      vuint32_t PRES91:1;              /* Presampling enable for channel 91. */
      vuint32_t PRES90:1;              /* Presampling enable for channel 90. */
      vuint32_t PRES89:1;              /* Presampling enable for channel 89. */
      vuint32_t PRES88:1;              /* Presampling enable for channel 88. */
      vuint32_t PRES87:1;              /* Presampling enable for channel 87. */
      vuint32_t PRES86:1;              /* Presampling enable for channel 86. */
      vuint32_t PRES85:1;              /* Presampling enable for channel 85. */
      vuint32_t PRES84:1;              /* Presampling enable for channel 84. */
      vuint32_t PRES83:1;              /* Presampling enable for channel 83. */
      vuint32_t PRES82:1;              /* Presampling enable for channel 82. */
      vuint32_t PRES81:1;              /* Presampling enable for channel 81. */
      vuint32_t PRES80:1;              /* Presampling enable for channel 80. */
      vuint32_t PRES79:1;              /* Presampling enable for channel 79. */
      vuint32_t PRES78:1;              /* Presampling enable for channel 78. */
      vuint32_t PRES77:1;              /* Presampling enable for channel 77. */
      vuint32_t PRES76:1;              /* Presampling enable for channel 76. */
      vuint32_t PRES75:1;              /* Presampling enable for channel 75. */
      vuint32_t PRES74:1;              /* Presampling enable for channel 74. */
      vuint32_t PRES73:1;              /* Presampling enable for channel 73. */
      vuint32_t PRES72:1;              /* Presampling enable for channel 72. */
      vuint32_t PRES71:1;              /* Presampling enable for channel 71. */
      vuint32_t PRES70:1;              /* Presampling enable for channel 70. */
      vuint32_t PRES69:1;              /* Presampling enable for channel 69. */
      vuint32_t PRES68:1;              /* Presampling enable for channel 68. */
      vuint32_t PRES67:1;              /* Presampling enable for channel 67. */
      vuint32_t PRES66:1;              /* Presampling enable for channel 66. */
      vuint32_t PRES65:1;              /* Presampling enable for channel 65. */
      vuint32_t PRES64:1;              /* Presampling enable for channel 64. */
    } B;
  } PSR2;

  uint8_t ADC_reserved4[4];
  union {                              /* Conversion Timing Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR0;

  union {                              /* Conversion Timing Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR1;

  union {                              /* Conversion Timing Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t INPSAMP:8;             /* Configuration of sampling phase duration. */
    } B;
  } CTR2;

  uint8_t ADC_reserved5[4];
  union {                              /* Normal Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CH15:1;                /* Normal sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Normal sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Normal sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Normal sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Normal sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Normal sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Normal sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Normal sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Normal sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Normal sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Normal sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Normal sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Normal sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Normal sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Normal sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Normal sampling enable for channel 0. */
    } B;
  } NCMR0;

  union {                              /* Normal Conversion Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CH63:1;                /* Normal sampling enable for channel 63. */
      vuint32_t CH62:1;                /* Normal sampling enable for channel 62. */
      vuint32_t CH61:1;                /* Normal sampling enable for channel 61. */
      vuint32_t CH60:1;                /* Normal sampling enable for channel 60. */
      vuint32_t CH59:1;                /* Normal sampling enable for channel 59. */
      vuint32_t CH58:1;                /* Normal sampling enable for channel 58. */
      vuint32_t CH57:1;                /* Normal sampling enable for channel 57. */
      vuint32_t CH56:1;                /* Normal sampling enable for channel 56. */
      vuint32_t CH55:1;                /* Normal sampling enable for channel 55. */
      vuint32_t CH54:1;                /* Normal sampling enable for channel 54. */
      vuint32_t CH53:1;                /* Normal sampling enable for channel 53. */
      vuint32_t CH52:1;                /* Normal sampling enable for channel 52. */
      vuint32_t CH51:1;                /* Normal sampling enable for channel 51. */
      vuint32_t CH50:1;                /* Normal sampling enable for channel 50. */
      vuint32_t CH49:1;                /* Normal sampling enable for channel 49. */
      vuint32_t CH48:1;                /* Normal sampling enable for channel 48. */
      vuint32_t CH47:1;                /* Normal sampling enable for channel 47. */
      vuint32_t CH46:1;                /* Normal sampling enable for channel 46. */
      vuint32_t CH45:1;                /* Normal sampling enable for channel 45. */
      vuint32_t CH44:1;                /* Normal sampling enable for channel 44. */
      vuint32_t CH43:1;                /* Normal sampling enable for channel 43. */
      vuint32_t CH42:1;                /* Normal sampling enable for channel 42. */
      vuint32_t CH41:1;                /* Normal sampling enable for channel 41. */
      vuint32_t CH40:1;                /* Normal sampling enable for channel 40. */
      vuint32_t CH39:1;                /* Normal sampling enable for channel 39. */
      vuint32_t CH38:1;                /* Normal sampling enable for channel 38. */
      vuint32_t CH37:1;                /* Normal sampling enable for channel 37. */
      vuint32_t CH36:1;                /* Normal sampling enable for channel 36. */
      vuint32_t CH35:1;                /* Normal sampling enable for channel 35. */
      vuint32_t CH34:1;                /* Normal sampling enable for channel 34. */
      vuint32_t CH33:1;                /* Normal sampling enable for channel 33. */
      vuint32_t CH32:1;                /* Normal sampling enable for channel 32. */
    } B;
  } NCMR1;

  union {                              /* Normal Conversion Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CH95:1;                /* Normal sampling enable for channel 95. */
      vuint32_t CH94:1;                /* Normal sampling enable for channel 94. */
      vuint32_t CH93:1;                /* Normal sampling enable for channel 93. */
      vuint32_t CH92:1;                /* Normal sampling enable for channel 92. */
      vuint32_t CH91:1;                /* Normal sampling enable for channel 91. */
      vuint32_t CH90:1;                /* Normal sampling enable for channel 90. */
      vuint32_t CH89:1;                /* Normal sampling enable for channel 89. */
      vuint32_t CH88:1;                /* Normal sampling enable for channel 88. */
      vuint32_t CH87:1;                /* Normal sampling enable for channel 87. */
      vuint32_t CH86:1;                /* Normal sampling enable for channel 86. */
      vuint32_t CH85:1;                /* Normal sampling enable for channel 85. */
      vuint32_t CH84:1;                /* Normal sampling enable for channel 84. */
      vuint32_t CH83:1;                /* Normal sampling enable for channel 83. */
      vuint32_t CH82:1;                /* Normal sampling enable for channel 82. */
      vuint32_t CH81:1;                /* Normal sampling enable for channel 81. */
      vuint32_t CH80:1;                /* Normal sampling enable for channel 80. */
      vuint32_t CH79:1;                /* Normal sampling enable for channel 79. */
      vuint32_t CH78:1;                /* Normal sampling enable for channel 78. */
      vuint32_t CH77:1;                /* Normal sampling enable for channel 77. */
      vuint32_t CH76:1;                /* Normal sampling enable for channel 76. */
      vuint32_t CH75:1;                /* Normal sampling enable for channel 75. */
      vuint32_t CH74:1;                /* Normal sampling enable for channel 74. */
      vuint32_t CH73:1;                /* Normal sampling enable for channel 73. */
      vuint32_t CH72:1;                /* Normal sampling enable for channel 72. */
      vuint32_t CH71:1;                /* Normal sampling enable for channel 71. */
      vuint32_t CH70:1;                /* Normal sampling enable for channel 70. */
      vuint32_t CH69:1;                /* Normal sampling enable for channel 69. */
      vuint32_t CH68:1;                /* Normal sampling enable for channel 68. */
      vuint32_t CH67:1;                /* Normal sampling enable for channel 67. */
      vuint32_t CH66:1;                /* Normal sampling enable for channel 66. */
      vuint32_t CH65:1;                /* Normal sampling enable for channel 65. */
      vuint32_t CH64:1;                /* Normal sampling enable for channel 64. */
    } B;
  } NCMR2;

  uint8_t ADC_reserved6[4];
  union {                              /* Injected Conversion Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CH15:1;                /* Injected sampling enable for channel 15. */
      vuint32_t CH14:1;                /* Injected sampling enable for channel 14. */
      vuint32_t CH13:1;                /* Injected sampling enable for channel 13. */
      vuint32_t CH12:1;                /* Injected sampling enable for channel 12. */
      vuint32_t CH11:1;                /* Injected sampling enable for channel 11. */
      vuint32_t CH10:1;                /* Injected sampling enable for channel 10. */
      vuint32_t CH9:1;                 /* Injected sampling enable for channel 9. */
      vuint32_t CH8:1;                 /* Injected sampling enable for channel 8. */
      vuint32_t CH7:1;                 /* Injected sampling enable for channel 7. */
      vuint32_t CH6:1;                 /* Injected sampling enable for channel 6. */
      vuint32_t CH5:1;                 /* Injected sampling enable for channel 5. */
      vuint32_t CH4:1;                 /* Injected sampling enable for channel 4. */
      vuint32_t CH3:1;                 /* Injected sampling enable for channel 3. */
      vuint32_t CH2:1;                 /* Injected sampling enable for channel 2. */
      vuint32_t CH1:1;                 /* Injected sampling enable for channel 1. */
      vuint32_t CH0:1;                 /* Injected sampling enable for channel 0. */
    } B;
  } JCMR0;

  union {                              /* Injected Conversion Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CH63:1;                /* Injected sampling enable for channel 63. */
      vuint32_t CH62:1;                /* Injected sampling enable for channel 62. */
      vuint32_t CH61:1;                /* Injected sampling enable for channel 61. */
      vuint32_t CH60:1;                /* Injected sampling enable for channel 60. */
      vuint32_t CH59:1;                /* Injected sampling enable for channel 59. */
      vuint32_t CH58:1;                /* Injected sampling enable for channel 58. */
      vuint32_t CH57:1;                /* Injected sampling enable for channel 57. */
      vuint32_t CH56:1;                /* Injected sampling enable for channel 56. */
      vuint32_t CH55:1;                /* Injected sampling enable for channel 55. */
      vuint32_t CH54:1;                /* Injected sampling enable for channel 54. */
      vuint32_t CH53:1;                /* Injected sampling enable for channel 53. */
      vuint32_t CH52:1;                /* Injected sampling enable for channel 52. */
      vuint32_t CH51:1;                /* Injected sampling enable for channel 51. */
      vuint32_t CH50:1;                /* Injected sampling enable for channel 50. */
      vuint32_t CH49:1;                /* Injected sampling enable for channel 49. */
      vuint32_t CH48:1;                /* Injected sampling enable for channel 48. */
      vuint32_t CH47:1;                /* Injected sampling enable for channel 47. */
      vuint32_t CH46:1;                /* Injected sampling enable for channel 46. */
      vuint32_t CH45:1;                /* Injected sampling enable for channel 45. */
      vuint32_t CH44:1;                /* Injected sampling enable for channel 44. */
      vuint32_t CH43:1;                /* Injected sampling enable for channel 43. */
      vuint32_t CH42:1;                /* Injected sampling enable for channel 42. */
      vuint32_t CH41:1;                /* Injected sampling enable for channel 41. */
      vuint32_t CH40:1;                /* Injected sampling enable for channel 40. */
      vuint32_t CH39:1;                /* Injected sampling enable for channel 39. */
      vuint32_t CH38:1;                /* Injected sampling enable for channel 38. */
      vuint32_t CH37:1;                /* Injected sampling enable for channel 37. */
      vuint32_t CH36:1;                /* Injected sampling enable for channel 36. */
      vuint32_t CH35:1;                /* Injected sampling enable for channel 35. */
      vuint32_t CH34:1;                /* Injected sampling enable for channel 34. */
      vuint32_t CH33:1;                /* Injected sampling enable for channel 33. */
      vuint32_t CH32:1;                /* Injected sampling enable for channel 32. */
    } B;
  } JCMR1;

  union {                              /* Injected Conversion Mask Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CH95:1;                /* Injected sampling enable for channel 95. */
      vuint32_t CH94:1;                /* Injected sampling enable for channel 94. */
      vuint32_t CH93:1;                /* Injected sampling enable for channel 93. */
      vuint32_t CH92:1;                /* Injected sampling enable for channel 92. */
      vuint32_t CH91:1;                /* Injected sampling enable for channel 91. */
      vuint32_t CH90:1;                /* Injected sampling enable for channel 90. */
      vuint32_t CH89:1;                /* Injected sampling enable for channel 89. */
      vuint32_t CH88:1;                /* Injected sampling enable for channel 88. */
      vuint32_t CH87:1;                /* Injected sampling enable for channel 87. */
      vuint32_t CH86:1;                /* Injected sampling enable for channel 86. */
      vuint32_t CH85:1;                /* Injected sampling enable for channel 85. */
      vuint32_t CH84:1;                /* Injected sampling enable for channel 84. */
      vuint32_t CH83:1;                /* Injected sampling enable for channel 83. */
      vuint32_t CH82:1;                /* Injected sampling enable for channel 82. */
      vuint32_t CH81:1;                /* Injected sampling enable for channel 81. */
      vuint32_t CH80:1;                /* Injected sampling enable for channel 80. */
      vuint32_t CH79:1;                /* Injected sampling enable for channel 79. */
      vuint32_t CH78:1;                /* Injected sampling enable for channel 78. */
      vuint32_t CH77:1;                /* Injected sampling enable for channel 77. */
      vuint32_t CH76:1;                /* Injected sampling enable for channel 76. */
      vuint32_t CH75:1;                /* Injected sampling enable for channel 75. */
      vuint32_t CH74:1;                /* Injected sampling enable for channel 74. */
      vuint32_t CH73:1;                /* Injected sampling enable for channel 73. */
      vuint32_t CH72:1;                /* Injected sampling enable for channel 72. */
      vuint32_t CH71:1;                /* Injected sampling enable for channel 71. */
      vuint32_t CH70:1;                /* Injected sampling enable for channel 70. */
      vuint32_t CH69:1;                /* Injected sampling enable for channel 69. */
      vuint32_t CH68:1;                /* Injected sampling enable for channel 68. */
      vuint32_t CH67:1;                /* Injected sampling enable for channel 67. */
      vuint32_t CH66:1;                /* Injected sampling enable for channel 66. */
      vuint32_t CH65:1;                /* Injected sampling enable for channel 65. */
      vuint32_t CH64:1;                /* Injected sampling enable for channel 64. */
    } B;
  } JCMR2;

  uint8_t ADC_reserved7[4];
  union {                              /* Decode Signals Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DSD:16;
    } B;
  } DSDR;

  union {                              /* Power Down Exit Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t PDED:8;
    } B;
  } PDEDR;

  uint8_t ADC_reserved8[52];
  union {                              /* Channel Data Register n (Precision Channels) */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t VALID:1;               /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
      vuint32_t OVERW:1;               /* Overwrite data */
      vuint32_t RESULT:2;
      vuint32_t CDATA:16;              /* Converted Data 11:0. */
    } B;
  } CDR[96];                           /* Note CDR[16..31] are reserved               */

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR4;

  union {                              /* Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;               /* High threshold value for channel x. */
      vuint32_t  :4;
      vuint32_t THRL:12;               /* Low threshold value for channel x. */
    } B;
  } THRHLR5;

  uint8_t ADC_reserved9[40];
  union {                              /* Channel Watchdog Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH7:4;            /* Channel Watchdog select for channel 7. */
      vuint32_t WSEL_CH6:4;            /* Channel Watchdog select for channel 6. */
      vuint32_t WSEL_CH5:4;            /* Channel Watchdog select for channel 5. */
      vuint32_t WSEL_CH4:4;            /* Channel Watchdog select for channel 4. */
      vuint32_t WSEL_CH3:4;            /* Channel Watchdog select for channel 3. */
      vuint32_t WSEL_CH2:4;            /* Channel Watchdog select for channel 2. */
      vuint32_t WSEL_CH1:4;            /* Channel Watchdog select for channel 1. */
      vuint32_t WSEL_CH0:4;            /* Channel Watchdog select for channel 0. */
    } B;
  } CWSELR0;

  union {                              /* Channel Watchdog Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH15:4;           /* Channel Watchdog select for channel 15. */
      vuint32_t WSEL_CH14:4;           /* Channel Watchdog select for channel 14. */
      vuint32_t WSEL_CH13:4;           /* Channel Watchdog select for channel 13. */
      vuint32_t WSEL_CH12:4;           /* Channel Watchdog select for channel 12. */
      vuint32_t WSEL_CH11:4;           /* Channel Watchdog select for channel 11. */
      vuint32_t WSEL_CH10:4;           /* Channel Watchdog select for channel 10. */
      vuint32_t WSEL_CH9:4;            /* Channel Watchdog select for channel 9. */
      vuint32_t WSEL_CH8:4;            /* Channel Watchdog select for channel 8. */
    } B;
  } CWSELR1;

  uint8_t ADC_reserved10[8];
  union {                              /* Channel Watchdog Select Register 4 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH39:4;           /* Channel Watchdog select for channel 39. */
      vuint32_t WSEL_CH38:4;           /* Channel Watchdog select for channel 38. */
      vuint32_t WSEL_CH37:4;           /* Channel Watchdog select for channel 37. */
      vuint32_t WSEL_CH36:4;           /* Channel Watchdog select for channel 36. */
      vuint32_t WSEL_CH35:4;           /* Channel Watchdog select for channel 35. */
      vuint32_t WSEL_CH34:4;           /* Channel Watchdog select for channel 34. */
      vuint32_t WSEL_CH33:4;           /* Channel Watchdog select for channel 33. */
      vuint32_t WSEL_CH32:4;           /* Channel Watchdog select for channel 32. */
    } B;
  } CWSELR4;

  union {                              /* Channel Watchdog Select Register 5 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH47:4;           /* Channel Watchdog select for channel 47. */
      vuint32_t WSEL_CH46:4;           /* Channel Watchdog select for channel 46. */
      vuint32_t WSEL_CH45:4;           /* Channel Watchdog select for channel 45. */
      vuint32_t WSEL_CH44:4;           /* Channel Watchdog select for channel 44. */
      vuint32_t WSEL_CH43:4;           /* Channel Watchdog select for channel 43. */
      vuint32_t WSEL_CH42:4;           /* Channel Watchdog select for channel 42. */
      vuint32_t WSEL_CH41:4;           /* Channel Watchdog select for channel 41. */
      vuint32_t WSEL_CH40:4;           /* Channel Watchdog select for channel 40. */
    } B;
  } CWSELR5;

  union {                              /* Channel Watchdog Select Register 6 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH55:4;           /* Channel Watchdog select for channel 55. */
      vuint32_t WSEL_CH54:4;           /* Channel Watchdog select for channel 54. */
      vuint32_t WSEL_CH53:4;           /* Channel Watchdog select for channel 53. */
      vuint32_t WSEL_CH52:4;           /* Channel Watchdog select for channel 52. */
      vuint32_t WSEL_CH51:4;           /* Channel Watchdog select for channel 51. */
      vuint32_t WSEL_CH50:4;           /* Channel Watchdog select for channel 50. */
      vuint32_t WSEL_CH49:4;           /* Channel Watchdog select for channel 49. */
      vuint32_t WSEL_CH48:4;           /* Channel Watchdog select for channel 48. */
    } B;
  } CWSELR6;

  union {                              /* Channel Watchdog Select Register 7 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH63:4;           /* Channel Watchdog select for channel 63. */
      vuint32_t WSEL_CH62:4;           /* Channel Watchdog select for channel 62. */
      vuint32_t WSEL_CH61:4;           /* Channel Watchdog select for channel 61. */
      vuint32_t WSEL_CH60:4;           /* Channel Watchdog select for channel 60. */
      vuint32_t WSEL_CH59:4;           /* Channel Watchdog select for channel 59. */
      vuint32_t WSEL_CH58:4;           /* Channel Watchdog select for channel 58. */
      vuint32_t WSEL_CH57:4;           /* Channel Watchdog select for channel 57. */
      vuint32_t WSEL_CH56:4;           /* Channel Watchdog select for channel 56. */
    } B;
  } CWSELR7;

  union {                              /* Channel Watchdog Select Register 8 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH71:4;           /* Channel Watchdog select for channel 71. */
      vuint32_t WSEL_CH70:4;           /* Channel Watchdog select for channel 70. */
      vuint32_t WSEL_CH69:4;           /* Channel Watchdog select for channel 69. */
      vuint32_t WSEL_CH68:4;           /* Channel Watchdog select for channel 68. */
      vuint32_t WSEL_CH67:4;           /* Channel Watchdog select for channel 67. */
      vuint32_t WSEL_CH66:4;           /* Channel Watchdog select for channel 66. */
      vuint32_t WSEL_CH65:4;           /* Channel Watchdog select for channel 65. */
      vuint32_t WSEL_CH64:4;           /* Channel Watchdog select for channel 64. */
    } B;
  } CWSELR8;

  union {                              /* Channel Watchdog Select Register 9 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH79:4;           /* Channel Watchdog select for channel 79. */
      vuint32_t WSEL_CH78:4;           /* Channel Watchdog select for channel 78. */
      vuint32_t WSEL_CH77:4;           /* Channel Watchdog select for channel 77. */
      vuint32_t WSEL_CH76:4;           /* Channel Watchdog select for channel 76. */
      vuint32_t WSEL_CH75:4;           /* Channel Watchdog select for channel 75. */
      vuint32_t WSEL_CH74:4;           /* Channel Watchdog select for channel 74. */
      vuint32_t WSEL_CH73:4;           /* Channel Watchdog select for channel 73. */
      vuint32_t WSEL_CH72:4;           /* Channel Watchdog select for channel 72. */
    } B;
  } CWSELR9;

  union {                              /* Channel Watchdog Select Register 10 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH87:4;           /* Channel Watchdog select for channel 87. */
      vuint32_t WSEL_CH86:4;           /* Channel Watchdog select for channel 86. */
      vuint32_t WSEL_CH85:4;           /* Channel Watchdog select for channel 85. */
      vuint32_t WSEL_CH84:4;           /* Channel Watchdog select for channel 84. */
      vuint32_t WSEL_CH83:4;           /* Channel Watchdog select for channel 83. */
      vuint32_t WSEL_CH82:4;           /* Channel Watchdog select for channel 82. */
      vuint32_t WSEL_CH81:4;           /* Channel Watchdog select for channel 81. */
      vuint32_t WSEL_CH80:4;           /* Channel Watchdog select for channel 80. */
    } B;
  } CWSELR10;

  union {                              /* Channel Watchdog Select Register 11 */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH95:4;           /* Channel Watchdog select for channel 95. */
      vuint32_t WSEL_CH94:4;           /* Channel Watchdog select for channel 94. */
      vuint32_t WSEL_CH93:4;           /* Channel Watchdog select for channel 93. */
      vuint32_t WSEL_CH92:4;           /* Channel Watchdog select for channel 92. */
      vuint32_t WSEL_CH91:4;           /* Channel Watchdog select for channel 91. */
      vuint32_t WSEL_CH90:4;           /* Channel Watchdog select for channel 90. */
      vuint32_t WSEL_CH89:4;           /* Channel Watchdog select for channel 89. */
      vuint32_t WSEL_CH88:4;           /* Channel Watchdog select for channel 88. */
    } B;
  } CWSELR11;

  union {                              /* Channel Watchdog Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CWEN15:1;              /* Watchdog enable for channel 15. */
      vuint32_t CWEN14:1;              /* Watchdog enable for channel 14. */
      vuint32_t CWEN13:1;              /* Watchdog enable for channel 13. */
      vuint32_t CWEN12:1;              /* Watchdog enable for channel 12. */
      vuint32_t CWEN11:1;              /* Watchdog enable for channel 11. */
      vuint32_t CWEN10:1;              /* Watchdog enable for channel 10. */
      vuint32_t CWEN9:1;               /* Watchdog enable for channel 9. */
      vuint32_t CWEN8:1;               /* Watchdog enable for channel 8. */
      vuint32_t CWEN7:1;               /* Watchdog enable for channel 7. */
      vuint32_t CWEN6:1;               /* Watchdog enable for channel 6. */
      vuint32_t CWEN5:1;               /* Watchdog enable for channel 5. */
      vuint32_t CWEN4:1;               /* Watchdog enable for channel 4. */
      vuint32_t CWEN3:1;               /* Watchdog enable for channel 3. */
      vuint32_t CWEN2:1;               /* Watchdog enable for channel 2. */
      vuint32_t CWEN1:1;               /* Watchdog enable for channel 1. */
      vuint32_t CWEN0:1;               /* Watchdog enable for channel 0. */
    } B;
  } CWENR0;

  union {                              /* Channel Watchdog Enable Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CWEN63:1;              /* Watchdog enable for channel 63. */
      vuint32_t CWEN62:1;              /* Watchdog enable for channel 62. */
      vuint32_t CWEN61:1;              /* Watchdog enable for channel 61. */
      vuint32_t CWEN60:1;              /* Watchdog enable for channel 60. */
      vuint32_t CWEN59:1;              /* Watchdog enable for channel 59. */
      vuint32_t CWEN58:1;              /* Watchdog enable for channel 58. */
      vuint32_t CWEN57:1;              /* Watchdog enable for channel 57. */
      vuint32_t CWEN56:1;              /* Watchdog enable for channel 56. */
      vuint32_t CWEN55:1;              /* Watchdog enable for channel 55. */
      vuint32_t CWEN54:1;              /* Watchdog enable for channel 54. */
      vuint32_t CWEN53:1;              /* Watchdog enable for channel 53. */
      vuint32_t CWEN52:1;              /* Watchdog enable for channel 52. */
      vuint32_t CWEN51:1;              /* Watchdog enable for channel 51. */
      vuint32_t CWEN50:1;              /* Watchdog enable for channel 50. */
      vuint32_t CWEN49:1;              /* Watchdog enable for channel 49. */
      vuint32_t CWEN48:1;              /* Watchdog enable for channel 48. */
      vuint32_t CWEN47:1;              /* Watchdog enable for channel 47. */
      vuint32_t CWEN46:1;              /* Watchdog enable for channel 46. */
      vuint32_t CWEN45:1;              /* Watchdog enable for channel 45. */
      vuint32_t CWEN44:1;              /* Watchdog enable for channel 44. */
      vuint32_t CWEN43:1;              /* Watchdog enable for channel 43. */
      vuint32_t CWEN42:1;              /* Watchdog enable for channel 42. */
      vuint32_t CWEN41:1;              /* Watchdog enable for channel 41. */
      vuint32_t CWEN40:1;              /* Watchdog enable for channel 40. */
      vuint32_t CWEN39:1;              /* Watchdog enable for channel 39. */
      vuint32_t CWEN38:1;              /* Watchdog enable for channel 38. */
      vuint32_t CWEN37:1;              /* Watchdog enable for channel 37. */
      vuint32_t CWEN36:1;              /* Watchdog enable for channel 36. */
      vuint32_t CWEN35:1;              /* Watchdog enable for channel 35. */
      vuint32_t CWEN34:1;              /* Watchdog enable for channel 34. */
      vuint32_t CWEN33:1;              /* Watchdog enable for channel 33. */
      vuint32_t CWEN32:1;              /* Watchdog enable for channel 32. */
    } B;
  } CWENR1;

  union {                              /* Channel Watchdog Enable Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CWEN95:1;              /* Watchdog enable for channel 95. */
      vuint32_t CWEN94:1;              /* Watchdog enable for channel 94. */
      vuint32_t CWEN93:1;              /* Watchdog enable for channel 93. */
      vuint32_t CWEN92:1;              /* Watchdog enable for channel 92. */
      vuint32_t CWEN91:1;              /* Watchdog enable for channel 91. */
      vuint32_t CWEN90:1;              /* Watchdog enable for channel 90. */
      vuint32_t CWEN89:1;              /* Watchdog enable for channel 89. */
      vuint32_t CWEN88:1;              /* Watchdog enable for channel 88. */
      vuint32_t CWEN87:1;              /* Watchdog enable for channel 87. */
      vuint32_t CWEN86:1;              /* Watchdog enable for channel 86. */
      vuint32_t CWEN85:1;              /* Watchdog enable for channel 85. */
      vuint32_t CWEN84:1;              /* Watchdog enable for channel 84. */
      vuint32_t CWEN83:1;              /* Watchdog enable for channel 83. */
      vuint32_t CWEN82:1;              /* Watchdog enable for channel 82. */
      vuint32_t CWEN81:1;              /* Watchdog enable for channel 81. */
      vuint32_t CWEN80:1;              /* Watchdog enable for channel 80. */
      vuint32_t CWEN79:1;              /* Watchdog enable for channel 79. */
      vuint32_t CWEN78:1;              /* Watchdog enable for channel 78. */
      vuint32_t CWEN77:1;              /* Watchdog enable for channel 77. */
      vuint32_t CWEN76:1;              /* Watchdog enable for channel 76. */
      vuint32_t CWEN75:1;              /* Watchdog enable for channel 75. */
      vuint32_t CWEN74:1;              /* Watchdog enable for channel 74. */
      vuint32_t CWEN73:1;              /* Watchdog enable for channel 73. */
      vuint32_t CWEN72:1;              /* Watchdog enable for channel 72. */
      vuint32_t CWEN71:1;              /* Watchdog enable for channel 71. */
      vuint32_t CWEN70:1;              /* Watchdog enable for channel 70. */
      vuint32_t CWEN69:1;              /* Watchdog enable for channel 69. */
      vuint32_t CWEN68:1;              /* Watchdog enable for channel 68. */
      vuint32_t CWEN67:1;              /* Watchdog enable for channel 67. */
      vuint32_t CWEN66:1;              /* Watchdog enable for channel 66. */
      vuint32_t CWEN65:1;              /* Watchdog enable for channel 65. */
      vuint32_t CWEN64:1;              /* Watchdog enable for channel 64. */
    } B;
  } CWENR2;

  uint8_t ADC_reserved11[4];
  union {                              /* Analog Watchdog Out of Range Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t AWOR_CH15:1;           /* Analog watchdog out of range for channel 15. */
      vuint32_t AWOR_CH14:1;           /* Analog watchdog out of range for channel 14. */
      vuint32_t AWOR_CH13:1;           /* Analog watchdog out of range for channel 13. */
      vuint32_t AWOR_CH12:1;           /* Analog watchdog out of range for channel 12. */
      vuint32_t AWOR_CH11:1;           /* Analog watchdog out of range for channel 11. */
      vuint32_t AWOR_CH10:1;           /* Analog watchdog out of range for channel 10. */
      vuint32_t AWOR_CH9:1;            /* Analog watchdog out of range for channel 9. */
      vuint32_t AWOR_CH8:1;            /* Analog watchdog out of range for channel 8. */
      vuint32_t AWOR_CH7:1;            /* Analog watchdog out of range for channel 7. */
      vuint32_t AWOR_CH6:1;            /* Analog watchdog out of range for channel 6. */
      vuint32_t AWOR_CH5:1;            /* Analog watchdog out of range for channel 5. */
      vuint32_t AWOR_CH4:1;            /* Analog watchdog out of range for channel 4. */
      vuint32_t AWOR_CH3:1;            /* Analog watchdog out of range for channel 3. */
      vuint32_t AWOR_CH2:1;            /* Analog watchdog out of range for channel 2. */
      vuint32_t AWOR_CH1:1;            /* Analog watchdog out of range for channel 1. */
      vuint32_t AWOR_CH0:1;            /* Analog watchdog out of range for channel 0. */
    } B;
  } AWORR0;

  union {                              /* Analog Watchdog Out of Range Register 1 */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CH63:1;           /* Analog watchdog out of range for channel 63. */
      vuint32_t AWOR_CH62:1;           /* Analog watchdog out of range for channel 62. */
      vuint32_t AWOR_CH61:1;           /* Analog watchdog out of range for channel 61. */
      vuint32_t AWOR_CH60:1;           /* Analog watchdog out of range for channel 60. */
      vuint32_t AWOR_CH59:1;           /* Analog watchdog out of range for channel 59. */
      vuint32_t AWOR_CH58:1;           /* Analog watchdog out of range for channel 58. */
      vuint32_t AWOR_CH57:1;           /* Analog watchdog out of range for channel 57. */
      vuint32_t AWOR_CH56:1;           /* Analog watchdog out of range for channel 56. */
      vuint32_t AWOR_CH55:1;           /* Analog watchdog out of range for channel 55. */
      vuint32_t AWOR_CH54:1;           /* Analog watchdog out of range for channel 54. */
      vuint32_t AWOR_CH53:1;           /* Analog watchdog out of range for channel 53. */
      vuint32_t AWOR_CH52:1;           /* Analog watchdog out of range for channel 52. */
      vuint32_t AWOR_CH51:1;           /* Analog watchdog out of range for channel 51. */
      vuint32_t AWOR_CH50:1;           /* Analog watchdog out of range for channel 50. */
      vuint32_t AWOR_CH49:1;           /* Analog watchdog out of range for channel 49. */
      vuint32_t AWOR_CH48:1;           /* Analog watchdog out of range for channel 48. */
      vuint32_t AWOR_CH47:1;           /* Analog watchdog out of range for channel 47. */
      vuint32_t AWOR_CH46:1;           /* Analog watchdog out of range for channel 46. */
      vuint32_t AWOR_CH45:1;           /* Analog watchdog out of range for channel 45. */
      vuint32_t AWOR_CH44:1;           /* Analog watchdog out of range for channel 44. */
      vuint32_t AWOR_CH43:1;           /* Analog watchdog out of range for channel 43. */
      vuint32_t AWOR_CH42:1;           /* Analog watchdog out of range for channel 42. */
      vuint32_t AWOR_CH41:1;           /* Analog watchdog out of range for channel 41. */
      vuint32_t AWOR_CH40:1;           /* Analog watchdog out of range for channel 40. */
      vuint32_t AWOR_CH39:1;           /* Analog watchdog out of range for channel 39. */
      vuint32_t AWOR_CH38:1;           /* Analog watchdog out of range for channel 38. */
      vuint32_t AWOR_CH37:1;           /* Analog watchdog out of range for channel 37. */
      vuint32_t AWOR_CH36:1;           /* Analog watchdog out of range for channel 36. */
      vuint32_t AWOR_CH35:1;           /* Analog watchdog out of range for channel 35. */
      vuint32_t AWOR_CH34:1;           /* Analog watchdog out of range for channel 34. */
      vuint32_t AWOR_CH33:1;           /* Analog watchdog out of range for channel 33. */
      vuint32_t AWOR_CH32:1;           /* Analog watchdog out of range for channel 32. */
    } B;
  } AWORR1;

  union {                              /* Analog Watchdog Out of Range Register 2 */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CH95:1;           /* Analog watchdog out of range for channel 95. */
      vuint32_t AWOR_CH94:1;           /* Analog watchdog out of range for channel 94. */
      vuint32_t AWOR_CH93:1;           /* Analog watchdog out of range for channel 93. */
      vuint32_t AWOR_CH92:1;           /* Analog watchdog out of range for channel 92. */
      vuint32_t AWOR_CH91:1;           /* Analog watchdog out of range for channel 91. */
      vuint32_t AWOR_CH90:1;           /* Analog watchdog out of range for channel 90. */
      vuint32_t AWOR_CH89:1;           /* Analog watchdog out of range for channel 89. */
      vuint32_t AWOR_CH88:1;           /* Analog watchdog out of range for channel 88. */
      vuint32_t AWOR_CH87:1;           /* Analog watchdog out of range for channel 87. */
      vuint32_t AWOR_CH86:1;           /* Analog watchdog out of range for channel 86. */
      vuint32_t AWOR_CH85:1;           /* Analog watchdog out of range for channel 85. */
      vuint32_t AWOR_CH84:1;           /* Analog watchdog out of range for channel 84. */
      vuint32_t AWOR_CH83:1;           /* Analog watchdog out of range for channel 83. */
      vuint32_t AWOR_CH82:1;           /* Analog watchdog out of range for channel 82. */
      vuint32_t AWOR_CH81:1;           /* Analog watchdog out of range for channel 81. */
      vuint32_t AWOR_CH80:1;           /* Analog watchdog out of range for channel 80. */
      vuint32_t AWOR_CH79:1;           /* Analog watchdog out of range for channel 79. */
      vuint32_t AWOR_CH78:1;           /* Analog watchdog out of range for channel 78. */
      vuint32_t AWOR_CH77:1;           /* Analog watchdog out of range for channel 77. */
      vuint32_t AWOR_CH76:1;           /* Analog watchdog out of range for channel 76. */
      vuint32_t AWOR_CH75:1;           /* Analog watchdog out of range for channel 75. */
      vuint32_t AWOR_CH74:1;           /* Analog watchdog out of range for channel 74. */
      vuint32_t AWOR_CH73:1;           /* Analog watchdog out of range for channel 73. */
      vuint32_t AWOR_CH72:1;           /* Analog watchdog out of range for channel 72. */
      vuint32_t AWOR_CH71:1;           /* Analog watchdog out of range for channel 71. */
      vuint32_t AWOR_CH70:1;           /* Analog watchdog out of range for channel 70. */
      vuint32_t AWOR_CH69:1;           /* Analog watchdog out of range for channel 69. */
      vuint32_t AWOR_CH68:1;           /* Analog watchdog out of range for channel 68. */
      vuint32_t AWOR_CH67:1;           /* Analog watchdog out of range for channel 67. */
      vuint32_t AWOR_CH66:1;           /* Analog watchdog out of range for channel 66. */
      vuint32_t AWOR_CH65:1;           /* Analog watchdog out of range for channel 65. */
      vuint32_t AWOR_CH64:1;           /* Analog watchdog out of range for channel 64. */
    } B;
  } AWORR2;

  uint8_t ADC_reserved12[164];
  union {                              /* Calibration, BIST Control and status Register */
    vuint32_t R;
    struct {
      vuint32_t OPMODE:3;
      vuint32_t TSAMP:2;               /* Test Sample period in Calibration, BIST and Offset calculation process. */
      vuint32_t ACC_C:1;
      vuint32_t ACC_B:2;
      vuint32_t  :8;
      vuint32_t C_T_BUSY:1;
      vuint32_t  :1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t NR_SMPL:2;             /* Number of Samples for averaging. */
      vuint32_t AVG_EN:1;              /* Average Enable (for Calibration only). */
      vuint32_t TEST_FAIL:1;           /* Test Fail. */
      vuint32_t ACC_A:2;
      vuint32_t TEST_EN:1;             /* Enable the test. */
    } B;
  } CALBISTREG;

  uint8_t ADC_reserved13[4];
  union {                              /* Offset and Gain User Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t GAIN_USER:10;
      vuint32_t  :8;
      vuint32_t OFFSET_USER:8;
    } B;
  } OFSGNUSR;
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

struct AIPS_tag {
  union {                              /* Master Privilege Register A */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MTR0:1;                /* Master 0 Trusted For Read */
      vuint32_t MTW0:1;                /* Master 0 Trusted For Writes */
      vuint32_t MPL0:1;                /* Master 0 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR1:1;                /* Master 1 trusted for read */
      vuint32_t MTW1:1;                /* Master 1 trusted for writes */
      vuint32_t MPL1:1;                /* Master 1 privilege level */
      vuint32_t  :1;
      vuint32_t MTR2:1;                /* Master 2 Trusted For Read */
      vuint32_t MTW2:1;                /* Master 2 Trusted For Writes */
      vuint32_t MPL2:1;                /* Master 2 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR3:1;                /* Master 3 Trusted For Read */
      vuint32_t MTW3:1;                /* Master 3 Trusted For Writes */
      vuint32_t MPL3:1;                /* Master 3 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR4:1;                /* Master 4 Trusted For Read */
      vuint32_t MTW4:1;                /* Master 4 Trusted For Writes */
      vuint32_t MPL4:1;                /* Master 4 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR5:1;                /* Master 5 Trusted For Read */
      vuint32_t MTW5:1;                /* Master 5 Trusted For Writes */
      vuint32_t MPL5:1;                /* Master 5 Privilege Level */
      vuint32_t  :1;
      vuint32_t MTR6:1;                /* Master 6 trusted for read */
      vuint32_t MTW6:1;                /* Master 6 trusted for writes */
      vuint32_t MPL6:1;                /* Master 6 privilege level */
      vuint32_t  :4;
    } B;
  } MPRA;

  union {                              /* Master Privilege Register B */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t MTR9:1;                /* Master 9 trusted for read */
      vuint32_t MTW9:1;                /* Master 9 trusted for writes */
      vuint32_t MPL9:1;                /* Master 9 privilege level */
      vuint32_t  :1;
      vuint32_t MTR10:1;               /* Master 10 trusted for read */
      vuint32_t MTW10:1;               /* Master 10 trusted for writes */
      vuint32_t MPL10:1;               /* Master 10 privilege level */
      vuint32_t  :1;
      vuint32_t MTR11:1;               /* Master 11 trusted for read */
      vuint32_t MTW11:1;               /* Master 11 trusted for writes */
      vuint32_t MPL11:1;               /* Master 11 privilege level */
      vuint32_t  :1;
      vuint32_t MTR12:1;               /* Master 12 trusted for read */
      vuint32_t MTW12:1;               /* Master 12 trusted for writes */
      vuint32_t MPL12:1;               /* Master 12 privilege level */
      vuint32_t  :1;
      vuint32_t MTR13:1;               /* Master 13 trusted for read */
      vuint32_t MTW13:1;               /* Master 13 trusted for writes */
      vuint32_t MPL13:1;               /* Master 13 Privilege Level */
      vuint32_t  :4;
      vuint32_t  :4;
    } B;
  } MPRB;

  uint8_t AIPS_reserved0[248];
  union {                              /* Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } PACR[8];

  uint8_t AIPS_reserved1[32];
  union {                              /* Off-Platform Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SP0:1;                 /* Supervisor Protect */
      vuint32_t WP0:1;                 /* Write Protect */
      vuint32_t TP0:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP1:1;                 /* Supervisor Protect */
      vuint32_t WP1:1;                 /* Write Protect */
      vuint32_t TP1:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP2:1;                 /* Supervisor Protect */
      vuint32_t WP2:1;                 /* Write Protect */
      vuint32_t TP2:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP3:1;                 /* Supervisor Protect */
      vuint32_t WP3:1;                 /* Write Protect */
      vuint32_t TP3:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP4:1;                 /* Supervisor Protect */
      vuint32_t WP4:1;                 /* Write Protect */
      vuint32_t TP4:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP5:1;                 /* Supervisor Protect */
      vuint32_t WP5:1;                 /* Write Protect */
      vuint32_t TP5:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP6:1;                 /* Supervisor Protect */
      vuint32_t WP6:1;                 /* Write Protect */
      vuint32_t TP6:1;                 /* Trusted Protect */
      vuint32_t  :1;
      vuint32_t SP7:1;                 /* Supervisor Protect */
      vuint32_t WP7:1;                 /* Write Protect */
      vuint32_t TP7:1;                 /* Trusted Protect */
    } B;
  } OPACR[32];
};


/* ============================================================================
   =============================== Module: AXBS ===============================
   ============================================================================ */

struct AXBS_tag {
  struct {
    union {                            /* Priority Registers Slave */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t M7:3;                /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M6:3;                /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M5:3;                /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M4:3;                /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M3:3;                /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M2:3;                /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M1:3;                /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
        vuint32_t  :1;
        vuint32_t M0:3;                /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
      } B;
    } PRS;
    uint8_t PORT_reserved0[12];
    union {                            /* Control Register */
      vuint32_t R;
      struct {
        vuint32_t RO:1;                /* Read Only */
        vuint32_t  :1;
        vuint32_t  :6;
        vuint32_t HPE7:1;
        vuint32_t HPE6:1;
        vuint32_t HPE5:1;
        vuint32_t HPE4:1;
        vuint32_t HPE3:1;
        vuint32_t HPE2:1;
        vuint32_t HPE1:1;
        vuint32_t HPE0:1;
        vuint32_t  :6;
        vuint32_t ARB:2;               /* Arbitration Mode */
        vuint32_t  :2;
        vuint32_t PCTL:2;              /* Parking Control */
        vuint32_t  :1;
        vuint32_t PARK:3;              /* Park */
      } B;
    } CRS;
    uint8_t PORT_reserved1[236];
  } PORT[8];

  struct {
    union {                            /* Master General Purpose Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t AULB:3;              /* Arbitrates On Undefined Length Bursts */
      } B;
    } MGPCR;
    uint8_t MGPCR_reserved0[252];
  } MGPCR[8];
};


/* ============================================================================
   =============================== Module: BCTU ===============================
   ============================================================================ */

struct BCTU_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze mode - for debug operation. */
      vuint32_t  :2;
      vuint32_t GTRGEN:1;              /* Global Trigger Enable. */
      vuint32_t  :6;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;
      vuint32_t DMA1:1;                /* ADC1DR data transferring by DMA. */
      vuint32_t DMA0:1;                /* ADC0DR data transferring by DMA. */
      vuint32_t  :8;
      vuint32_t TRGEN:1;               /* Trigger interrupt request enable. */
      vuint32_t  :1;
      vuint32_t LIST_IEN:1;            /* LIST interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t IEN1:1;                /* Interrupt enable bit for ADC1DR new data. */
      vuint32_t IEN0:1;                /* Interrupt enable bit for ADC0DR new data. */
    } B;
  } MCR;

  uint8_t BCTU_reserved0[4];
  union {                              /* Module Status register */
    vuint32_t R;
    struct {
      vuint32_t TRGF_CLR:1;            /* TRGF clear */
      vuint32_t  :3;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t LIST1_Last_CLR:1;
      vuint32_t LIST0_Last_CLR:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t DATAOVR1_CLR:1;        /* Clears DATAOVR1 flag */
      vuint32_t DATAOVR0_CLR:1;        /* Clears DATAOVR0 flag */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t NDATA1_CLR:1;          /* Clears NDATA1 flag */
      vuint32_t NDATA0_CLR:1;          /* Clears NDATA0 flag */
      vuint32_t TRGF:1;                /* Trigger Flag */
      vuint32_t  :3;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t LIST1_Last:1;
      vuint32_t LIST0_Last:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t DATAOVR1:1;
      vuint32_t DATAOVR0:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t NDATA1:1;
      vuint32_t NDATA0:1;
    } B;
  } MSR;

  uint8_t BCTU_reserved1[12];
  union {                              /* Trigger Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t LOOP:1;                /* LOOP bit */
      vuint32_t  :7;
      vuint32_t  :8;                   /* Reserved. */
      vuint32_t TRIGEN:1;              /* Trigger enable */
      vuint32_t TRG_FLAG:1;
      vuint32_t TRS:1;                 /* Trigger resolution */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t ADC_SEL1:1;
      vuint32_t ADC_SEL0:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t CHANNEL_VALUE_OR_LADDR:7; /* Channel Value or List Address Value. */
    } B;
  } TRGCFG[96];

  uint8_t BCTU_reserved2[144];
  union {                              /* Write Protection register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t PROTEC_CODE:4;         /* The Protection code sets protection for the write protected registers */
    } B;
  } WRPROT;

  union {                              /* Software Trigger register 1 */
    vuint32_t R;
    struct {
      vuint32_t SFTRG31:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG30:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG29:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG28:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG27:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG26:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG25:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG24:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG23:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG22:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG21:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG20:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG19:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG18:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG17:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG16:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG15:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG14:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG13:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG12:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG11:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG10:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG9:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG8:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG7:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG6:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG5:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG4:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG3:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG2:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG1:1;              /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG0:1;              /* Software trigger to start an ADC conversion. */
    } B;
  } SFTRGR1;

  union {                              /* Software Trigger register 1 */
    vuint32_t R;
    struct {
      vuint32_t SFTRG63:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG62:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG61:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG60:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG59:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG58:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG57:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG56:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG55:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG54:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG53:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG52:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG51:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG50:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG49:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG48:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG47:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG46:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG45:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG44:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG43:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG42:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG41:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG40:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG39:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG38:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG37:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG36:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG35:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG34:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG33:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG32:1;             /* Software trigger to start an ADC conversion. */
    } B;
  } SFTRGR2;

  union {                              /* Software Trigger register 1 */
    vuint32_t R;
    struct {
      vuint32_t SFTRG95:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG94:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG93:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG92:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG91:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG90:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG89:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG88:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG87:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG86:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG85:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG84:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG83:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG82:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG81:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG80:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG79:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG78:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG77:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG76:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG75:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG74:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG73:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG72:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG71:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG70:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG69:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG68:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG67:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG66:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG65:1;             /* Software trigger to start an ADC conversion. */
      vuint32_t SFTRG64:1;             /* Software trigger to start an ADC conversion. */
    } B;
  } SFTRGR3;

  uint8_t BCTU_reserved3[4];
  union {                              /* ADC0 Result Data register */
    vuint32_t R;
    struct {
      vuint32_t TRG_SRC:8;
      vuint32_t CH:8;
      vuint32_t LIST:1;
      vuint32_t LAST:1;
      vuint32_t  :2;
      vuint32_t ADC_DATA:12;
    } B;
  } ADC0DR;

  union {                              /* ADC1 result data register */
    vuint32_t R;
    struct {
      vuint32_t TRG_SRC:8;
      vuint32_t CH:8;
      vuint32_t LIST:1;
      vuint32_t LAST:1;
      vuint32_t  :2;
      vuint32_t ADC_DATA:12;
    } B;
  } ADC1DR;

  uint8_t BCTU_reserved4[8];
  union {                              /* LIST Size Status register */
    vuint32_t R;
    struct {
      vuint32_t  :24;                  /* Reserved. */
      vuint32_t LISTSZ:8;              /* Size of the LIST in number of elements. */
    } B;
  } LISTSTAR;

  union {                              /* LIST Channel Address Register */
    vuint32_t R;
    struct {
      vuint32_t LAST_y:1;              /* Last channel in the list of channels. */
      vuint32_t  :3;
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ADC_CH_y:7;            /* ADC channel selection. */
      vuint32_t LAST_y_plus_1:1;       /* Second to last channel in the list of channels. */
      vuint32_t  :3;
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t ADC_CHL_y_plus_1:7;    /* ADC channel selection. */
    } B;
  } LISTCHR[16];
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

struct C55FMC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t RVE:1;                 /* Read Voltage Error */
      vuint32_t RRE:1;                 /* Read Reference Error */
      vuint32_t AEE:1;                 /* Address Encode Error */
      vuint32_t EEE:1;                 /* ECC after ECC Error */
      vuint32_t  :12;
      vuint32_t EER:1;                 /* ECC Event Error */
      vuint32_t RWE:1;                 /* Read-While-Write Event Error */
      vuint32_t SBC:1;                 /* Single Bit Correction */
      vuint32_t  :1;
      vuint32_t PEAS:1;                /* Program Access Space */
      vuint32_t DONE:1;                /* State Machine Status */
      vuint32_t PEG:1;                 /* Program/Erase Good */
      vuint32_t PECIE:1;               /* Program/Erase Complete Interrupt Enable */
      vuint32_t  :3;
      vuint32_t PGM:1;                 /* Program */
      vuint32_t PSUS:1;                /* Program Suspend */
      vuint32_t ERS:1;                 /* Erase */
      vuint32_t ESUS:1;                /* Erase Suspend */
      vuint32_t EHV:1;                 /* Enable High Voltage */
    } B;
  } MCR;

  uint8_t C55FMC_reserved0[4];
  union {                              /* Extended Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t HT:1;                  /* High Temperature Enabled. */
      vuint32_t  :2;
      vuint32_t n256K:5;
      vuint32_t n64Kh:3;
      vuint32_t n32Kh:2;
      vuint32_t n16Kh:3;
      vuint32_t n64Km:3;
      vuint32_t n32Km:2;
      vuint32_t n16Km:3;
      vuint32_t n64Kl:3;
      vuint32_t n32Kl:2;
      vuint32_t n16Kl:3;
    } B;
  } MCRE;

  uint8_t C55FMC_reserved1[4];
  union {                              /* Lock 0 register */
    vuint32_t R;
    struct {
      vuint32_t TSLOCK:1;              /* UTest NVM Lock. */
      vuint32_t  :1;
      vuint32_t LOWLOCK:14;            /* Low Block Lock */
      vuint32_t MIDLOCK:16;            /* Mid Block Lock */
    } B;
  } LOCK0;

  union {                              /* Lock 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHLOCK:16;           /* High Block Lock */
    } B;
  } LOCK1;

  union {                              /* Lock 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KLOCK:32;          /* 256 KB Block Lock */
    } B;
  } LOCK2;

  union {                              /* Lock 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KLOCK:16;          /* 256 KB Block Lock */
    } B;
  } LOCK3;

  uint8_t C55FMC_reserved2[24];
  union {                              /* Select 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWSEL:14;             /* LOW Block Select. */
      vuint32_t MIDSEL:16;             /* Mid Block Select. */
    } B;
  } SEL0;

  union {                              /* Select 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHSEL:16;            /* High Block Select. */
    } B;
  } SEL1;

  union {                              /* Select 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KSEL:32;           /* 256 KB Block Select. */
    } B;
  } SEL2;

  union {                              /* Select 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KSEL:16;           /* 256 KB Block Select. */
    } B;
  } SEL3;

  uint8_t C55FMC_reserved3[8];
  union {                              /* Address register */
    vuint32_t R;
    struct {
      vuint32_t SAD:1;
      vuint32_t aH:1;
      vuint32_t aM:1;
      vuint32_t aL:1;
      vuint32_t a256k:1;
      vuint32_t a64k:1;
      vuint32_t a32k:1;
      vuint32_t a16k:1;
      vuint32_t ADDR:21;
      vuint32_t  :3;
    } B;
  } ADR;

  union {                              /* UTest 0 register */
    vuint32_t R;
    struct {
      vuint32_t UTE:1;
      vuint32_t SBCE:1;
      vuint32_t  :11;
      vuint32_t CPR:1;
      vuint32_t CPA:1;
      vuint32_t CPE:1;
      vuint32_t  :6;
      vuint32_t NAIBP:1;
      vuint32_t AIBPE:1;
      vuint32_t  :1;
      vuint32_t AISUS:1;
      vuint32_t MRE:1;
      vuint32_t MRV:1;
      vuint32_t  :1;
      vuint32_t AIS:1;
      vuint32_t AIE:1;
      vuint32_t AID:1;
    } B;
  } UT0;

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t MISR:32;
    } B;
  } UM[9];

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t MISR:1;                /* MISR[288]. */
    } B;
  } UM9;

  union {                              /* Over-Program Protection 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWOPP:14;             /* Low Block Over-Program Protection[13:0]. */
      vuint32_t MIDOPP:16;             /* Mid Block Over-Program Protection[15:0]. */
    } B;
  } OPP0;

  union {                              /* Over-Program Protection 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHOPP:16;            /* High Block Over-Program Protection[15:0]. */
    } B;
  } OPP1;

  union {                              /* Over-Program Protection 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KOPP:32;           /* 256K Block Over-Program Protection[31:0]. */
    } B;
  } OPP2;

  union {                              /* Over-Program Protection 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KOPP:16;           /* 256K Block Over-Program Protection[47:32]. */
    } B;
  } OPP3;

  union {                              /* Test Mode Disable Password Check register */
    vuint32_t R;
    struct {
      vuint32_t PWD:32;                /* Password challenge */
    } B;
  } TMD;
};


/* ============================================================================
   =============================== Module: CAN_0 ==============================
   ============================================================================ */

struct CAN_0_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze Enable */
      vuint32_t RFEN:1;                /* Rx FIFO Enable */
      vuint32_t HALT:1;                /* Halt FlexCAN */
      vuint32_t NOTRDY:1;              /* FlexCAN Not Ready */
      vuint32_t WAKMSK:1;              /* Wake Up Interrupt Mask */
      vuint32_t SOFTRST:1;             /* Soft Reset */
      vuint32_t FRZACK:1;              /* Freeze Mode Acknowledge */
      vuint32_t SUPV:1;                /* Supervisor Mode */
      vuint32_t SLFWAK:1;              /* Self Wake Up */
      vuint32_t WRNEN:1;               /* Warning Interrupt Enable */
      vuint32_t LPMACK:1;              /* Low-Power Mode Acknowledge */
      vuint32_t WAKSRC:1;              /* Wake Up Source */
      vuint32_t  :1;
      vuint32_t SRXDIS:1;              /* Self Reception Disable */
      vuint32_t IRMQ:1;                /* Individual Rx Masking And Queue Enable */
      vuint32_t DMA:1;                 /* DMA Enable */
      vuint32_t PNET_EN:1;             /* Pretended Networking Enable */
      vuint32_t LPRIOEN:1;             /* Local Priority Enable */
      vuint32_t AEN:1;                 /* Abort Enable */
      vuint32_t FDEN:1;                /* CAN FD operation enable */
      vuint32_t  :1;
      vuint32_t IDAM:2;                /* ID Acceptance Mode */
      vuint32_t  :1;
      vuint32_t MAXMB:7;               /* Number Of The Last Message Buffer */
    } B;
  } MCR;

  union {                              /* Control 1 register */
    vuint32_t R;
    struct {
      vuint32_t PRESDIV:8;             /* Prescaler Division Factor */
      vuint32_t RJW:2;                 /* Resync Jump Width */
      vuint32_t PSEG1:3;               /* Phase Segment 1 */
      vuint32_t PSEG2:3;               /* Phase Segment 2 */
      vuint32_t BOFFMSK:1;             /* Bus Off Interrupt Mask */
      vuint32_t ERRMSK:1;              /* Error Interrupt Mask */
      vuint32_t CLKSRC:1;              /* CAN Engine Clock Source */
      vuint32_t LPB:1;                 /* Loop Back Mode */
      vuint32_t TWRNMSK:1;             /* Tx Warning Interrupt Mask */
      vuint32_t RWRNMSK:1;             /* Rx Warning Interrupt Mask */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t SMP:1;                 /* CAN Bit Sampling */
      vuint32_t BOFFREC:1;             /* Bus Off Recovery */
      vuint32_t TSYN:1;                /* Timer Sync */
      vuint32_t LBUF:1;                /* Lowest Buffer Transmitted First */
      vuint32_t LOM:1;                 /* Listen-Only Mode */
      vuint32_t PROPSEG:3;             /* Propagation Segment */
    } B;
  } CTRL1;

  union {                              /* Free Running Timer */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TIMER:16;              /* Timer Value */
    } B;
  } TIMER;

  uint8_t CAN_0_reserved0[4];
  union {                              /* Rx Mailboxes Global Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MG:32;                 /* Rx Mailboxes Global Mask Bits */
    } B;
  } RXMGMASK;

  union {                              /* Rx 14 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX14M:32;              /* Rx Buffer 14 Mask Bits */
    } B;
  } RX14MASK;

  union {                              /* Rx 15 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX15M:32;              /* Rx Buffer 15 Mask Bits */
    } B;
  } RX15MASK;

  union {                              /* Error Counter */
    vuint32_t R;
    struct {
      vuint32_t RXERRCNT_FAST:8;       /* Receive Error Counter for fast bits */
      vuint32_t TXERRCNT_FAST:8;       /* Transmit Error Counter for fast bits */
      vuint32_t RXERRCNT:8;            /* Receive Error Counter */
      vuint32_t TXERRCNT:8;            /* Transmit Error Counter */
    } B;
  } ECR;

  union {                              /* Error and Status 1 register */
    vuint32_t R;
    struct {
      vuint32_t BIT1ERR_FAST:1;        /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t BIT0ERR_FAST:1;        /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t  :1;
      vuint32_t CRCERR_FAST:1;         /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
      vuint32_t FRMERR_FAST:1;         /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t STFERR_FAST:1;         /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t  :4;
      vuint32_t ERROVR:1;              /* Error Overrun bit */
      vuint32_t ERRINT_FAST:1;         /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t BOFFDONEINT:1;         /* Bus Off Done Interrupt */
      vuint32_t SYNCH:1;               /* CAN Synchronization Status */
      vuint32_t TWRNINT:1;             /* Tx Warning Interrupt Flag */
      vuint32_t RWRNINT:1;             /* Rx Warning Interrupt Flag */
      vuint32_t BIT1ERR:1;             /* Bit1 Error */
      vuint32_t BIT0ERR:1;             /* Bit0 Error */
      vuint32_t ACKERR:1;              /* Acknowledge Error */
      vuint32_t CRCERR:1;              /* Cyclic Redundancy Check Error */
      vuint32_t FRMERR:1;              /* Form Error */
      vuint32_t STFERR:1;              /* Stuffing Error */
      vuint32_t TXWRN:1;               /* TX Error Warning */
      vuint32_t RXWRN:1;               /* Rx Error Warning */
      vuint32_t IDLE:1;
      vuint32_t TX:1;                  /* FlexCAN In Transmission */
      vuint32_t FLTCONF:2;             /* Fault Confinement State */
      vuint32_t RX:1;                  /* FlexCAN In Reception */
      vuint32_t BOFFINT:1;             /* Bus Off Interrupt */
      vuint32_t ERRINT:1;              /* Error Interrupt */
      vuint32_t WAKINT:1;              /* Wake-Up Interrupt */
    } B;
  } ESR1;

  union {                              /* Interrupt Masks 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUF63TO32M:32;         /* Buffer MB i Mask */
    } B;
  } IMASK2;

  union {                              /* Interrupt Masks 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUF31TO0M:32;          /* Buffer MB i Mask */
    } B;
  } IMASK1;

  union {                              /* Interrupt Flags 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUF63TO32I:32;         /* Buffer MB i Interrupt */
    } B;
  } IFLAG2;

  union {                              /* Interrupt Flags 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUF31TO8I:24;          /* Buffer MBi Interrupt */
      vuint32_t BUF7I:1;               /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
      vuint32_t BUF6I:1;               /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
      vuint32_t BUF5I:1;               /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
      vuint32_t BUF4TO1I:4;            /* Buffer MB i Interrupt Or "reserved" */
      vuint32_t BUF0I:1;               /* Buffer MB0 Interrupt Or "reserved" */
    } B;
  } IFLAG1;

  union {                              /* Control 2 register */
    vuint32_t R;
    struct {
      vuint32_t ERRMSK_FAST:1;         /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
      vuint32_t BOFFDONEMSK:1;         /* Bus Off Done Interrupt Mask */
      vuint32_t ECRWRE:1;              /* Error-correction Configuration Register Write Enable */
      vuint32_t WRMFRZ:1;              /* Write-Access To Memory In Freeze Mode */
      vuint32_t RFFN:4;                /* Number Of Rx FIFO Filters */
      vuint32_t TASD:5;                /* Tx Arbitration Start Delay */
      vuint32_t MRP:1;                 /* Mailboxes Reception Priority */
      vuint32_t RRS:1;                 /* Remote Request Storing */
      vuint32_t EACEN:1;               /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
      vuint32_t TIMER_SRC:1;           /* Timer Source */
      vuint32_t  :15;
    } B;
  } CTRL2;

  union {                              /* Error and Status 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t LPTM:7;                /* Lowest Priority Tx Mailbox */
      vuint32_t  :1;
      vuint32_t VPS:1;                 /* Valid Priority Status */
      vuint32_t IMB:1;                 /* Inactive Mailbox */
      vuint32_t  :13;
    } B;
  } ESR2;

  uint8_t CAN_0_reserved1[8];
  union {                              /* CRC Register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t MBCRC:7;               /* CRC Mailbox */
      vuint32_t  :1;
      vuint32_t TXCRC:15;              /* Transmitted CRC value */
    } B;
  } CRCR;

  union {                              /* Rx FIFO Global Mask register */
    vuint32_t R;
    struct {
      vuint32_t FGM:32;                /* Rx FIFO Global Mask Bits */
    } B;
  } RXFGMASK;

  union {                              /* Rx FIFO Information Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t IDHIT:9;               /* Identifier Acceptance Filter Hit Indicator */
    } B;
  } RXFIR;

  union {                              /* CAN Bit Timing Register */
    vuint32_t R;
    struct {
      vuint32_t BTF:1;                 /* Bit Timing Format Enable */
      vuint32_t EPRESDIV:10;           /* Extended Prescaler Division Factor */
      vuint32_t  :1;
      vuint32_t ERJW:4;                /* Extended Resync Jump Width */
      vuint32_t EPROPSEG:6;            /* Extended Propagation Segment */
      vuint32_t EPSEG1:5;              /* Extended Phase Segment 1 */
      vuint32_t EPSEG2:5;              /* Extended Phase Segment 2 */
    } B;
  } CBT;

  uint8_t CAN_0_reserved2[24];
  union {                              /* Interrupt Masks 3 Register */
    vuint32_t R;
    struct {
      vuint32_t BUF95TO64M:32;         /* Buffer MB i Mask */
    } B;
  } IMASK3;

  uint8_t CAN_0_reserved3[4];
  union {                              /* Interrupt Flags 3 Register */
    vuint32_t R;
    struct {
      vuint32_t BUF95TO64:32;          /* Buffer MB i Interrupt */
    } B;
  } IFLAG3;

  uint8_t CAN_0_reserved4[8];
  struct {
    union {                            /* Message Buffer 0 CS Register */
      vuint32_t R;
      struct {
        vuint32_t  :4;
        vuint32_t CODE:4;              /* Message Buffer Code */
        vuint32_t  :1;
        vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
        vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
        vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
        vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
        vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
      } B;
    } CS;
    union {                            /* Message Buffer 0 ID Register */
      vuint32_t R;
      struct {
        vuint32_t PRIO:3;              /* Local Priority */
        vuint32_t ID_STD:11;           /* Frame Identifier Standard */
        vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
      } B;
    } ID;
    union {
      vuint8_t B[8];
      vuint16_t H[4];
      vuint32_t W[2];
    } DATA;
  } MB[96];

  uint8_t CAN_0_reserved5[512];
  union {                              /* Rx Individual Mask Registers */
    vuint32_t R;
    struct {
      vuint32_t MI:32;                 /* Individual Mask Bits */
    } B;
  } RXIMR[96];

  uint8_t CAN_0_reserved6[224];
  union {                              /* Memory Error Control Register */
    vuint32_t R;
    struct {
      vuint32_t ECRWRDIS:1;            /* Error Configuration Register Write Disable */
      vuint32_t  :11;
      vuint32_t HANCEI_MSK:1;          /* Host Access With Non-Correctable Errors Interrupt Mask */
      vuint32_t FANCEI_MSK:1;          /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
      vuint32_t  :1;
      vuint32_t CEI_MSK:1;             /* Correctable Errors Interrupt Mask */
      vuint32_t HAERRIE:1;             /* Host Access Error Injection Enable */
      vuint32_t FAERRIE:1;             /* FlexCAN Access Error Injection Enable */
      vuint32_t EXTERRIE:1;            /* Extended Error Injection Enable */
      vuint32_t  :3;
      vuint32_t RERRDIS:1;             /* Error Report Disable */
      vuint32_t ECCDIS:1;              /* Error Correction Disable */
      vuint32_t NCEFAFRZ:1;            /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
      vuint32_t  :7;
    } B;
  } MECR;

  union {                              /* Error Injection Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t INJADDR:14;            /* Error Injection Address */
    } B;
  } ERRIAR;

  union {                              /* Error Injection Data Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t DFLIP:32;              /* Data flip pattern */
    } B;
  } ERRIDPR;

  union {                              /* Error Injection Parity Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t PFLIP3:5;              /* Parity Flip Pattern For Byte 3 (most significant) */
      vuint32_t  :3;
      vuint32_t PFLIP2:5;              /* Parity Flip Pattern For Byte 2 */
      vuint32_t  :3;
      vuint32_t PFLIP1:5;              /* Parity Flip Pattern For Byte 1 */
      vuint32_t  :3;
      vuint32_t PFLIP0:5;              /* Parity Flip Pattern For Byte 0 (Least Significant) */
    } B;
  } ERRIPPR;

  union {                              /* Error Report Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t NCE:1;                 /* Non-Correctable Error */
      vuint32_t  :5;
      vuint32_t SAID:3;
      vuint32_t  :2;
      vuint32_t ERRADDR:14;            /* Address Where The Error Was Detected */
    } B;
  } RERRAR;

  union {                              /* Error Report Data Register */
    vuint32_t R;
    struct {
      vuint32_t RDATA:32;              /* Raw data word read from memory with error */
    } B;
  } RERRDR;

  union {                              /* Error Report Syndrome Register */
    vuint32_t R;
    struct {
      vuint32_t BE3:1;                 /* Byte Enabled For Byte 3 (Most Significant) */
      vuint32_t  :2;
      vuint32_t SYND3:5;               /* Error Syndrome For Byte 3 (Most Significant) */
      vuint32_t BE2:1;                 /* Byte Enabled For Byte 2 */
      vuint32_t  :2;
      vuint32_t SYND2:5;               /* Error Syndrome For Byte 2 */
      vuint32_t BE1:1;                 /* Byte Enabled For Byte 1 */
      vuint32_t  :2;
      vuint32_t SYND1:5;               /* Error Syndrome for Byte 1 */
      vuint32_t BE0:1;                 /* Byte Enabled For Byte 0 (least significant) */
      vuint32_t  :2;
      vuint32_t SYND0:5;               /* Error Syndrome For Byte 0 (least significant) */
    } B;
  } RERRSYNR;

  union {                              /* Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t HANCEIF:1;             /* Host Access With Non-Correctable Error Interrupt Flag */
      vuint32_t FANCEIF:1;             /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
      vuint32_t  :1;
      vuint32_t CEIF:1;                /* Correctable Error Interrupt Flag */
      vuint32_t  :12;
      vuint32_t HANCEIOF:1;            /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
      vuint32_t FANCEIOF:1;            /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
      vuint32_t  :1;
      vuint32_t CEIOF:1;               /* Correctable Error Interrupt Overrun Flag */
    } B;
  } ERRSR;

  union {                              /* Pretended Networking Control 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t WTOF_MSK:1;            /* Wake Up by Timeout Flag Mask Bit */
      vuint32_t WUMF_MSK:1;            /* Wake Up by Match Flag Mask Bit */
      vuint32_t NMATCH:8;              /* Number of Messages Matching the Same Filtering Criteria */
      vuint32_t  :2;
      vuint32_t PLFS:2;                /* Payload Filtering Selection */
      vuint32_t IDFS:2;                /* ID Filtering Selection */
      vuint32_t FCS:2;                 /* Filtering Combination Selection */
    } B;
  } CTRL1_PN;

  union {                              /* Pretended Networking Control 2 Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t MATCHTO:16;            /* Timeout for No Message Matching the Filtering Criteria */
    } B;
  } CTRL2_PN;

  union {                              /* Pretended Networking Wake Up Match Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t WTOF:1;                /* Wake Up by Timeout Flag Bit */
      vuint32_t WUMF:1;                /* Wake Up by Match Flag Bit */
      vuint32_t MCOUNTER:8;            /* Number of Matches while in Pretended Networking */
      vuint32_t  :8;
    } B;
  } WU_MTC;

  union {                              /* Pretended Networking ID Filter 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FLT_IDE:1;             /* ID Extended Filter */
      vuint32_t FLT_RTR:1;             /* Remote Transmission Request Filter */
      vuint32_t FLT_ID1:29;            /* ID Filter 1 for Pretended Networking filtering */
    } B;
  } FLT_ID1;

  union {                              /* Pretended Networking DLC Filter Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t FLT_DLC_LO:4;          /* Lower Limit for Length of Data Bytes Filter */
      vuint32_t  :12;
      vuint32_t FLT_DLC_HI:4;          /* Upper Limit for Length of Data Bytes Filter */
    } B;
  } FLT_DLC;

  union {                              /* Pretended Networking Payload Low Filter 1 Register */
    vuint32_t R;
    struct {
      vuint32_t Data_byte_0:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
      vuint32_t Data_byte_1:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
      vuint32_t Data_byte_2:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
      vuint32_t Data_byte_3:8;         /* Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
    } B;
  } PL1_LO;

  union {                              /* Pretended Networking Payload High Filter 1 Register */
    vuint32_t R;
    struct {
      vuint32_t Data_byte_4:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
      vuint32_t Data_byte_5:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
      vuint32_t Data_byte_6:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
      vuint32_t Data_byte_7:8;         /* Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
    } B;
  } PL1_HI;

  union {                              /* Pretended Networking ID Filter 2 Register / ID Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t IDE_MSK:1;             /* ID Extended Mask Bit */
      vuint32_t RTR_MSK:1;             /* Remote Transmission Request Mask Bit */
      vuint32_t FLT_ID2_IDMASK:29;     /* ID Filter 2 for Pretended Networking Filtering / ID Mask Bits for Pretended Networking ID Filtering */
    } B;
  } FLT_ID2_IDMASK;

  union {                              /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
    vuint32_t R;
    struct {
      vuint32_t Data_byte_0:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 0. */
      vuint32_t Data_byte_1:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 1. */
      vuint32_t Data_byte_2:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 2. */
      vuint32_t Data_byte_3:8;         /* Payload Filter 2 low order bits / Payload Mask low order bits for Pretended Networking payload filtering corresponding to the data byte 3. */
    } B;
  } PL2_PLMASK_LO;

  union {                              /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
    vuint32_t R;
    struct {
      vuint32_t Data_byte_4:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 4. */
      vuint32_t Data_byte_5:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 5. */
      vuint32_t Data_byte_6:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 6. */
      vuint32_t Data_byte_7:8;         /* Payload Filter 2 high order bits / Payload Mask high order bits for Pretended Networking payload filtering corresponding to the data byte 7. */
    } B;
  } PL2_PLMASK_HI;

  uint8_t CAN_0_reserved7[24];
  struct {
    union {                            /* Wake Up Message Buffer Register for C/S */
      vuint32_t R;
      struct {
        vuint32_t  :9;
        vuint32_t SRR:1;               /* Substitute Remote Request */
        vuint32_t IDE:1;               /* ID Extended Bit */
        vuint32_t RTR:1;               /* Remote Transmission Request Bit */
        vuint32_t DLC:4;               /* Length of Data in Bytes */
        vuint32_t  :16;
      } B;
    } CS;
    union {                            /* Wake Up Message Buffer Register for ID */
      vuint32_t R;
      struct {
        vuint32_t  :3;
        vuint32_t ID:29;               /* Received ID under Pretended Networking mode */
      } B;
    } ID;
    union {                            /* Wake Up Message Buffer Register for Data 0-3 */
      vuint32_t R;
      struct {
        vuint32_t Data_byte_0:8;       /* Received payload corresponding to the data byte 0 under Pretended Networking mode */
        vuint32_t Data_byte_1:8;       /* Received payload corresponding to the data byte 1 under Pretended Networking mode */
        vuint32_t Data_byte_2:8;       /* Received payload corresponding to the data byte 2 under Pretended Networking mode */
        vuint32_t Data_byte_3:8;       /* Received payload corresponding to the data byte 3 under Pretended Networking mode */
      } B;
    } D03;
    union {                            /* Wake Up Message Buffer Register Data 4-7 */
      vuint32_t R;
      struct {
        vuint32_t Data_byte_4:8;       /* Received payload corresponding to the data byte 4 under Pretended Networking mode */
        vuint32_t Data_byte_5:8;       /* Received payload corresponding to the data byte 5 under Pretended Networking mode */
        vuint32_t Data_byte_6:8;       /* Received payload corresponding to the data byte 6 under Pretended Networking mode */
        vuint32_t Data_byte_7:8;       /* Received payload corresponding to the data byte 7 under Pretended Networking mode */
      } B;
    } D47;
  } WMB[4];

  uint8_t CAN_0_reserved8[128];
  union {                              /* CAN FD Control Register */
    vuint32_t R;
    struct {
      vuint32_t FDRATE:1;              /* Bit Rate Switch Enable */
      vuint32_t  :4;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t MBDSR2:2;              /* Message Buffer Data Size for Region 2 */
      vuint32_t  :1;
      vuint32_t MBDSR1:2;              /* Message Buffer Data Size for Region 1 */
      vuint32_t  :1;
      vuint32_t MBDSR0:2;              /* Message Buffer Data Size for Region 0 */
      vuint32_t TDCEN:1;               /* Transceiver Delay Compensation Enable */
      vuint32_t TDCFAIL:1;             /* Transceiver Delay Compensation Fail */
      vuint32_t  :1;
      vuint32_t TDCOFF:5;              /* Transceiver Delay Compensation Offset */
      vuint32_t  :2;
      vuint32_t TDCVAL:6;              /* Transceiver Delay Compensation Value */
    } B;
  } FDCTRL;

  union {                              /* CAN FD Bit Timing Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t FPRESDIV:10;           /* Fast Prescaler Division Factor */
      vuint32_t  :2;
      vuint32_t FRJW:2;                /* Fast Resync Jump Width */
      vuint32_t  :1;
      vuint32_t FPROPSEG:5;            /* Fast Propagation Segment */
      vuint32_t  :2;
      vuint32_t FPSEG1:3;              /* Fast Phase Segment 1 */
      vuint32_t  :2;
      vuint32_t FPSEG2:3;              /* Fast Phase Segment 2 */
    } B;
  } FDCBT;

  union {                              /* CAN FD CRC Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FD_MBCRC:7;            /* CRC Mailbox Number for FD_TXCRC */
      vuint32_t  :3;
      vuint32_t FD_TXCRC:21;           /* Extended Transmitted CRC value */
    } B;
  } FDCRC;
};


/* ============================================================================
   =============================== Module: CAN 1-7 ============================
   ============================================================================ */

struct CAN_1_7_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t FRZ:1;                 /* Freeze Enable */
      vuint32_t RFEN:1;                /* Rx FIFO Enable */
      vuint32_t HALT:1;                /* Halt FlexCAN */
      vuint32_t NOTRDY:1;              /* FlexCAN Not Ready */
      vuint32_t WAKMSK:1;              /* Wake Up Interrupt Mask */
      vuint32_t SOFTRST:1;             /* Soft Reset */
      vuint32_t FRZACK:1;              /* Freeze Mode Acknowledge */
      vuint32_t SUPV:1;                /* Supervisor Mode */
      vuint32_t SLFWAK:1;              /* Self Wake Up */
      vuint32_t WRNEN:1;               /* Warning Interrupt Enable */
      vuint32_t LPMACK:1;              /* Low-Power Mode Acknowledge */
      vuint32_t WAKSRC:1;              /* Wake Up Source */
      vuint32_t  :1;
      vuint32_t SRXDIS:1;              /* Self Reception Disable */
      vuint32_t IRMQ:1;                /* Individual Rx Masking And Queue Enable */
      vuint32_t  :1;
      vuint32_t  :1;                   /* Pretended Networking Enable */
      vuint32_t LPRIOEN:1;             /* Local Priority Enable */
      vuint32_t AEN:1;                 /* Abort Enable */
      vuint32_t  :2;
      vuint32_t IDAM:2;                /* ID Acceptance Mode */
      vuint32_t  :1;
      vuint32_t MAXMB:7;               /* Number Of The Last Message Buffer */
    } B;
  } MCR;

  union {                              /* Control 1 register */
    vuint32_t R;
    struct {
      vuint32_t PRESDIV:8;             /* Prescaler Division Factor */
      vuint32_t RJW:2;                 /* Resync Jump Width */
      vuint32_t PSEG1:3;               /* Phase Segment 1 */
      vuint32_t PSEG2:3;               /* Phase Segment 2 */
      vuint32_t BOFFMSK:1;             /* Bus Off Mask */
      vuint32_t ERRMSK:1;              /* Error Mask */
      vuint32_t CLKSRC:1;              /* CAN Engine Clock Source */
      vuint32_t LPB:1;                 /* Loop Back Mode */
      vuint32_t TWRNMSK:1;             /* Tx Warning Interrupt Mask */
      vuint32_t RWRNMSK:1;             /* Rx Warning Interrupt Mask */
      vuint32_t  :2;
      vuint32_t SMP:1;                 /* CAN Bit Sampling */
      vuint32_t BOFFREC:1;             /* Bus Off Recovery */
      vuint32_t TSYN:1;                /* Timer Sync */
      vuint32_t LBUF:1;                /* Lowest Buffer Transmitted First */
      vuint32_t LOM:1;                 /* Listen-Only Mode */
      vuint32_t PROPSEG:3;             /* Propagation Segment */
    } B;
  } CTRL1;

  union {                              /* Free Running Timer */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TIMER:16;              /* Timer Value */
    } B;
  } TIMER;

  uint8_t CAN_reserved0[4];
  union {                              /* Rx Mailboxes Global Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MG:32;                 /* Rx Mailboxes Global Mask Bits */
    } B;
  } RXMGMASK;

  union {                              /* Rx 14 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX14M:32;              /* Rx Buffer 14 Mask Bits */
    } B;
  } RX14MASK;

  union {                              /* Rx 15 Mask register */
    vuint32_t R;
    struct {
      vuint32_t RX15M:32;              /* Rx Buffer 15 Mask Bits */
    } B;
  } RX15MASK;

  union {                              /* Error Counter */
    vuint32_t R;
    struct {
      vuint32_t RXERRCNT_FAST:8;       /* Receive Error Counter for fast bits */
      vuint32_t TXERRCNT_FAST:8;       /* Transmit Error Counter for fast bits */
      vuint32_t RXERRCNT:8;            /* Receive Error Counter */
      vuint32_t TXERRCNT:8;            /* Transmit Error Counter */
    } B;
  } ECR;

  union {                              /* Error and Status 1 register */
    vuint32_t R;
    struct {
      vuint32_t BIT1ERR_FAST:1;        /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t BIT0ERR_FAST:1;        /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t  :1;
      vuint32_t CRCERR_FAST:1;         /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
      vuint32_t FRMERR_FAST:1;         /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t STFERR_FAST:1;         /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t  :4;
      vuint32_t ERROVR:1;              /* Error Overrun bit */
      vuint32_t ERRINT_FAST:1;         /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
      vuint32_t BOFFDONEINT:1;         /* Bus Off Done Interrupt */
      vuint32_t SYNCH:1;               /* CAN Synchronization Status */
      vuint32_t TWRNINT:1;             /* Tx Warning Interrupt Flag */
      vuint32_t RWRNINT:1;             /* Rx Warning Interrupt Flag */
      vuint32_t BIT1ERR:1;             /* Bit1 Error */
      vuint32_t BIT0ERR:1;             /* Bit0 Error */
      vuint32_t ACKERR:1;              /* Acknowledge Error */
      vuint32_t CRCERR:1;              /* Cyclic Redundancy Check Error */
      vuint32_t FRMERR:1;              /* Form Error */
      vuint32_t STFERR:1;              /* Stuffing Error */
      vuint32_t TXWRN:1;               /* TX Error Warning */
      vuint32_t RXWRN:1;               /* Rx Error Warning */
      vuint32_t IDLE:1;
      vuint32_t TX:1;                  /* FlexCAN In Transmission */
      vuint32_t FLTCONF:2;             /* Fault Confinement State */
      vuint32_t RX:1;                  /* FlexCAN In Reception */
      vuint32_t BOFFINT:1;             /* Bus Off Interrupt */
      vuint32_t ERRINT:1;              /* Error Interrupt */
      vuint32_t WAKINT:1;              /* Wake-Up Interrupt */
    } B;
  } ESR1;

  union {                              /* Interrupt Masks 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUFHM:32;              /* Buffer MB i Mask */
    } B;
  } IMASK2;

  union {                              /* Interrupt Masks 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUFLM:32;              /* Buffer MB i Mask */
    } B;
  } IMASK1;

  union {                              /* Interrupt Flags 2 register */
    vuint32_t R;
    struct {
      vuint32_t BUFHI:32;              /* Buffer MB i Interrupt */
    } B;
  } IFLAG2;

  union {                              /* Interrupt Flags 1 register */
    vuint32_t R;
    struct {
      vuint32_t BUF31TO8I:24;          /* Buffer MBi Interrupt */
      vuint32_t BUF7I:1;               /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
      vuint32_t BUF6I:1;               /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
      vuint32_t BUF5I:1;               /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
      vuint32_t BUF4TO1I:4;            /* Buffer MB i Interrupt Or "reserved" */
      vuint32_t BUF0I:1;               /* Buffer MB0 Interrupt Or "reserved" */
    } B;
  } IFLAG1;

  union {                              /* Control 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t WRMFRZ:1;              /* Write-Access To Memory In Freeze Mode */
      vuint32_t RFFN:4;                /* Number Of Rx FIFO Filters */
      vuint32_t TASD:5;                /* Tx Arbitration Start Delay */
      vuint32_t MRP:1;                 /* Mailboxes Reception Priority */
      vuint32_t RRS:1;                 /* Remote Request Storing */
      vuint32_t EACEN:1;               /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
      vuint32_t  :16;
    } B;
  } CTRL2;

  union {                              /* Error and Status 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t LPTM:7;                /* Lowest Priority Tx Mailbox */
      vuint32_t  :1;
      vuint32_t VPS:1;                 /* Valid Priority Status */
      vuint32_t IMB:1;                 /* Inactive Mailbox */
      vuint32_t  :13;
    } B;
  } ESR2;

  uint8_t CAN_reserved1[8];
  union {                              /* CRC Register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t MBCRC:7;               /* CRC Mailbox */
      vuint32_t  :1;
      vuint32_t TXCRC:15;              /* CRC Transmitted */
    } B;
  } CRCR;

  union {                              /* Rx FIFO Global Mask register */
    vuint32_t R;
    struct {
      vuint32_t FGM:32;                /* Rx FIFO Global Mask Bits */
    } B;
  } RXFGMASK;

  union {                              /* Rx FIFO Information Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t IDHIT:9;               /* Identifier Acceptance Filter Hit Indicator */
    } B;
  } RXFIR;

  uint8_t CAN_reserved2[48];
  struct {
    union {                            /* Message Buffer 0 CS Register */
      vuint32_t R;
      struct {
        vuint32_t  :4;
        vuint32_t CODE:4;              /* Message Buffer Code */
        vuint32_t  :1;
        vuint32_t SRR:1;               /* Substitute Remote Request. Contains a fixed recessive bit. */
        vuint32_t IDE:1;               /* ID Extended. One/zero for extended/standard format frame. */
        vuint32_t RTR:1;               /* Remote Transmission Request. One/zero for remote/data frame. */
        vuint32_t DLC:4;               /* Length of the data to be stored/transmitted. */
        vuint32_t TIMESTAMP:16;        /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
      } B;
    } CS;
    union {                            /* Message Buffer 0 ID Register */
      vuint32_t R;
      struct {
        vuint32_t PRIO:3;              /* Local Priority */
        vuint32_t ID_STD:11;           /* Frame Identifier Standard */
        vuint32_t ID_EXT:18;           /* Frame Identifier Extended */
      } B;
    } ID;
    union {
      vuint8_t B[8];
      vuint16_t H[4];
      vuint32_t W[2];
    } DATA;
  } MB[96];

  uint8_t CAN_reserved3[512];
  union {                              /* Rx Individual Mask Registers */
    vuint32_t R;
    struct {
      vuint32_t MI:32;                 /* Individual Mask Bits */
    } B;
  } RXIMR[96];

  uint8_t CAN_reserved4[512];
  
    union {                              /* CAN FD Control Register */
    vuint32_t R;
    struct {
      vuint32_t FDRATE:1;              /* Bit Rate Switch Enable */
      vuint32_t  :4;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t MBDSR2:2;              /* Message Buffer Data Size for Region 2 */
      vuint32_t  :1;
      vuint32_t MBDSR1:2;              /* Message Buffer Data Size for Region 1 */
      vuint32_t  :1;
      vuint32_t MBDSR0:2;              /* Message Buffer Data Size for Region 0 */
      vuint32_t TDCEN:1;               /* Transceiver Delay Compensation Enable */
      vuint32_t TDCFAIL:1;             /* Transceiver Delay Compensation Fail */
      vuint32_t  :1;
      vuint32_t TDCOFF:5;              /* Transceiver Delay Compensation Offset */
      vuint32_t  :2;
      vuint32_t TDCVAL:6;              /* Transceiver Delay Compensation Value */
    } B;
  } FDCTRL;
  
    union {                              /* CAN FD Bit Timing Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t FPRESDIV:10;           /* Fast Prescaler Division Factor */
      vuint32_t  :2;
      vuint32_t FRJW:2;                /* Fast Resync Jump Width */
      vuint32_t  :1;
      vuint32_t FPROPSEG:5;            /* Fast Propagation Segment */
      vuint32_t  :2;
      vuint32_t FPSEG1:3;              /* Fast Phase Segment 1 */
      vuint32_t  :2;
      vuint32_t FPSEG2:3;              /* Fast Phase Segment 2 */
    } B;
  } FDCBT;
  
    union {                              /* CAN FD CRC Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FD_MBCRC:7;            /* CRC Mailbox Number for FD_TXCRC */
      vuint32_t  :3;
      vuint32_t FD_TXCRC:21;           /* Extended Transmitted CRC value */
    } B;
  } FDCRC;  
};

/* ============================================================================
   =============================== Module: CMP ================================
   ============================================================================ */

struct CMP_tag {
  union {                              /* CMP Control Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t DMAEN:1;               /* DMA Enable */
      vuint32_t  :1;
      vuint32_t IER:1;                 /* Comparator Interrupt Enable Rising */
      vuint32_t IEF:1;                 /* Comparator Interrupt Enable Falling */
      vuint32_t CFR:1;                 /* Analog Comparator Flag Rising */
      vuint32_t CFF:1;                 /* Analog Comparator Flag Falling */
      vuint32_t COUT:1;                /* Analog Comparator Output */
      vuint32_t FPR:8;                 /* Filter Sample Period */
      vuint32_t SE:1;                  /* Sample Enable */
      vuint32_t WE:1;                  /* Windowing Enable */
      vuint32_t  :1;
      vuint32_t PMODE:1;               /* Power Mode Select */
      vuint32_t INVT:1;                /* Comparator invert */
      vuint32_t COS:1;                 /* Comparator Output Select */
      vuint32_t OPE:1;                 /* Comparator Output Pin Enable */
      vuint32_t EN:1;                  /* Comparator Module Enable */
      vuint32_t  :1;
      vuint32_t FILTER_CNT:3;          /* Filter Sample Count */
      vuint32_t  :2;
      vuint32_t HYSTCTR:2;             /* Comparator hard block hysteresis control */
    } B;
  } C0;

  union {                              /* CMP Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :7;
      vuint32_t CHN7:1;                /* Channel 7 input enable */
      vuint32_t CHN6:1;                /* Channel 6 input enable */
      vuint32_t CHN5:1;                /* Channel 5 input enable */
      vuint32_t CHN4:1;                /* Channel 4 input enable */
      vuint32_t CHN3:1;                /* Channel 3 input enable */
      vuint32_t CHN2:1;                /* Channel 2 input enable */
      vuint32_t CHN1:1;                /* Channel 1 input enable */
      vuint32_t CHN0:1;                /* Channel 0 input enable */
      vuint32_t DPSEL:1;               /* DAC output to Plus side ANMUX selection */
      vuint32_t DMSEL:1;               /* DAC output to Minus side ANMUX selection */
      vuint32_t PSEL:3;                /* Plus Input MUX Control */
      vuint32_t MSEL:3;                /* Minus Input MUX Control */
      vuint32_t DACEN:1;               /* DAC Enable */
      vuint32_t VRSEL:1;               /* Supply Voltage Reference Source Select */
      vuint32_t VOSEL:6;               /* DAC Output Voltage Select */
    } B;
  } C1;

  union {                              /* CMP Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t RRE:1;                 /* Round-Robin Enable */
      vuint32_t RRIE:1;                /* Round-Robin interrupt enable */
      vuint32_t FXMP:1;                /* Fixed MUX Port */
      vuint32_t FXDACI:1;              /* Fix DAC input to the fixed mux port side */
      vuint32_t FXMXCH:3;              /* Fixed channel selection */
      vuint32_t  :1;
      vuint32_t CH7F:1;
      vuint32_t CH6F:1;
      vuint32_t CH5F:1;
      vuint32_t CH4F:1;
      vuint32_t CH3F:1;
      vuint32_t CH2F:1;
      vuint32_t CH1F:1;
      vuint32_t CH0F:1;
      vuint32_t NSAM:2;                /* Number of sample clocks */
      vuint32_t  :6;
      vuint32_t ACOn:8;
    } B;
  } C2;
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

struct CMU_tag {
  union {                              /* CMU Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SFM:1;                 /* Start frequency measure. */
      vuint32_t  :13;
      vuint32_t CKSEL1:2;              /* Frequency measure clock selection bit. */
      vuint32_t  :5;
      vuint32_t RCDIV:2;               /* CLKMT0_RMN division factor. */
      vuint32_t CME:1;                 /* CLKMN1 monitor enable. */
    } B;
  } CSR;

  union {                              /* CMU Frequency Display Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t FD:20;                 /* Measured frequency bits. */
    } B;
  } FDR;

  union {                              /* CMU High Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t HFREF:12;              /* High Frequency reference value. */
    } B;
  } HFREFR;

  union {                              /* CMU Low Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t LFREF:12;              /* Low Frequency reference value. */
    } B;
  } LFREFR;

  union {                              /* CMU Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t FHHI:1;                /* CLKMN1 frequency higher than high reference event status. */
      vuint32_t FLLI:1;                /* CLKMN1 frequency less than low reference event status. */
      vuint32_t OLRI:1;                /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status. */
    } B;
  } ISR;

  uint8_t CMU_reserved0[4];
  union {                              /* CMU Measurement Duration Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t MD:20;                 /* Measurement duration bits */
    } B;
  } MDR;
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

struct CRC_tag {
  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t  :18;
      vuint32_t SWAP_BYTEWISE:1;       /* Swap CRC_INP byte-wise */
      vuint32_t SWAP_BITWISE:1;        /* Swap CRC_INP bit-wise */
      vuint32_t POLYG:2;               /* Polynomial selection */
      vuint32_t SWAP:1;                /* Swap selection */
      vuint32_t INV:1;                 /* Inversion selection */
    } B;
  } CFG;

  union {                              /* Input Register */
    vuint32_t R;
    struct {
      vuint32_t INP:32;                /* Input data for the CRC computation */
    } B;
  } INP;

  union {                              /* Current Status Register */
    vuint32_t R;
    struct {
      vuint32_t CSTAT:32;              /* CRC signature status */
    } B;
  } CSTAT;

  union {                              /* Output Register */
    vuint32_t R;
    struct {
      vuint32_t OUTP:32;               /* Final CRC signature */
    } B;
  } OUTP;
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

struct DMA_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t CX:1;                  /* Cancel Transfer */
      vuint32_t ECX:1;                 /* Error Cancel Transfer */
      vuint32_t  :5;
      vuint32_t GRP1PRI:1;             /* Channel Group 1 Priority */
      vuint32_t  :1;
      vuint32_t GRP0PRI:1;             /* Channel Group 0 Priority */
      vuint32_t EMLM:1;                /* Enable Minor Loop Mapping */
      vuint32_t CLM:1;                 /* Continuous Link Mode */
      vuint32_t HALT:1;                /* Halt DMA Operations */
      vuint32_t HOE:1;                 /* Halt On Error */
      vuint32_t ERGA:1;                /* Enable Round Robin Group Arbitration */
      vuint32_t ERCA:1;                /* Enable Round Robin Channel Arbitration */
      vuint32_t EDBG:1;                /* Enable Debug */
      vuint32_t  :1;
    } B;
  } CR;

  union {                              /* Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :13;
      vuint32_t UCE:1;                 /* Uncorrectable ECC error during channel execution. */
      vuint32_t ECX:1;                 /* Transfer Canceled */
      vuint32_t GPE:1;                 /* Group Priority Error */
      vuint32_t CPE:1;                 /* Channel Priority Error */
      vuint32_t  :1;
      vuint32_t ERRCHN:5;              /* Error Channel Number or Canceled Channel Number */
      vuint32_t SAE:1;                 /* Source Address Error */
      vuint32_t SOE:1;                 /* Source Offset Error */
      vuint32_t DAE:1;                 /* Destination Address Error */
      vuint32_t DOE:1;                 /* Destination Offset Error */
      vuint32_t NCE:1;                 /* NBYTES/CITER Configuration Error */
      vuint32_t SGE:1;                 /* Scatter/Gather Configuration Error */
      vuint32_t SBE:1;                 /* Source Bus Error */
      vuint32_t DBE:1;                 /* Destination Bus Error */
    } B;
  } ES;

  uint8_t DMA_reserved0[4];
  union {                              /* Enable Request Register */
    vuint32_t R;
    struct {
      vuint32_t ERQ31:1;               /* Enable DMA Request 31 */
      vuint32_t ERQ30:1;               /* Enable DMA Request 30 */
      vuint32_t ERQ29:1;               /* Enable DMA Request 29 */
      vuint32_t ERQ28:1;               /* Enable DMA Request 28 */
      vuint32_t ERQ27:1;               /* Enable DMA Request 27 */
      vuint32_t ERQ26:1;               /* Enable DMA Request 26 */
      vuint32_t ERQ25:1;               /* Enable DMA Request 25 */
      vuint32_t ERQ24:1;               /* Enable DMA Request 24 */
      vuint32_t ERQ23:1;               /* Enable DMA Request 23 */
      vuint32_t ERQ22:1;               /* Enable DMA Request 22 */
      vuint32_t ERQ21:1;               /* Enable DMA Request 21 */
      vuint32_t ERQ20:1;               /* Enable DMA Request 20 */
      vuint32_t ERQ19:1;               /* Enable DMA Request 19 */
      vuint32_t ERQ18:1;               /* Enable DMA Request 18 */
      vuint32_t ERQ17:1;               /* Enable DMA Request 17 */
      vuint32_t ERQ16:1;               /* Enable DMA Request 16 */
      vuint32_t ERQ15:1;               /* Enable DMA Request 15 */
      vuint32_t ERQ14:1;               /* Enable DMA Request 14 */
      vuint32_t ERQ13:1;               /* Enable DMA Request 13 */
      vuint32_t ERQ12:1;               /* Enable DMA Request 12 */
      vuint32_t ERQ11:1;               /* Enable DMA Request 11 */
      vuint32_t ERQ10:1;               /* Enable DMA Request 10 */
      vuint32_t ERQ9:1;                /* Enable DMA Request 9 */
      vuint32_t ERQ8:1;                /* Enable DMA Request 8 */
      vuint32_t ERQ7:1;                /* Enable DMA Request 7 */
      vuint32_t ERQ6:1;                /* Enable DMA Request 6 */
      vuint32_t ERQ5:1;                /* Enable DMA Request 5 */
      vuint32_t ERQ4:1;                /* Enable DMA Request 4 */
      vuint32_t ERQ3:1;                /* Enable DMA Request 3 */
      vuint32_t ERQ2:1;                /* Enable DMA Request 2 */
      vuint32_t ERQ1:1;                /* Enable DMA Request 1 */
      vuint32_t ERQ0:1;                /* Enable DMA Request 0 */
    } B;
  } ERQ;

  uint8_t DMA_reserved1[4];
  union {                              /* Enable Error Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t EEI31:1;               /* Enable Error Interrupt 31 */
      vuint32_t EEI30:1;               /* Enable Error Interrupt 30 */
      vuint32_t EEI29:1;               /* Enable Error Interrupt 29 */
      vuint32_t EEI28:1;               /* Enable Error Interrupt 28 */
      vuint32_t EEI27:1;               /* Enable Error Interrupt 27 */
      vuint32_t EEI26:1;               /* Enable Error Interrupt 26 */
      vuint32_t EEI25:1;               /* Enable Error Interrupt 25 */
      vuint32_t EEI24:1;               /* Enable Error Interrupt 24 */
      vuint32_t EEI23:1;               /* Enable Error Interrupt 23 */
      vuint32_t EEI22:1;               /* Enable Error Interrupt 22 */
      vuint32_t EEI21:1;               /* Enable Error Interrupt 21 */
      vuint32_t EEI20:1;               /* Enable Error Interrupt 20 */
      vuint32_t EEI19:1;               /* Enable Error Interrupt 19 */
      vuint32_t EEI18:1;               /* Enable Error Interrupt 18 */
      vuint32_t EEI17:1;               /* Enable Error Interrupt 17 */
      vuint32_t EEI16:1;               /* Enable Error Interrupt 16 */
      vuint32_t EEI15:1;               /* Enable Error Interrupt 15 */
      vuint32_t EEI14:1;               /* Enable Error Interrupt 14 */
      vuint32_t EEI13:1;               /* Enable Error Interrupt 13 */
      vuint32_t EEI12:1;               /* Enable Error Interrupt 12 */
      vuint32_t EEI11:1;               /* Enable Error Interrupt 11 */
      vuint32_t EEI10:1;               /* Enable Error Interrupt 10 */
      vuint32_t EEI9:1;                /* Enable Error Interrupt 9 */
      vuint32_t EEI8:1;                /* Enable Error Interrupt 8 */
      vuint32_t EEI7:1;                /* Enable Error Interrupt 7 */
      vuint32_t EEI6:1;                /* Enable Error Interrupt 6 */
      vuint32_t EEI5:1;                /* Enable Error Interrupt 5 */
      vuint32_t EEI4:1;                /* Enable Error Interrupt 4 */
      vuint32_t EEI3:1;                /* Enable Error Interrupt 3 */
      vuint32_t EEI2:1;                /* Enable Error Interrupt 2 */
      vuint32_t EEI1:1;                /* Enable Error Interrupt 1 */
      vuint32_t EEI0:1;                /* Enable Error Interrupt 0 */
    } B;
  } EEI;

  union {                              /* Set Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAER:1;                 /* Set All Enable Requests */
      vuint8_t  :1;
      vuint8_t SERQ:5;                 /* Set Enable Request */
    } B;
  } SERQ;

  union {                              /* Clear Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAER:1;                 /* Clear All Enable Requests */
      vuint8_t  :1;
      vuint8_t CERQ:5;                 /* Clear Enable Request */
    } B;
  } CERQ;

  union {                              /* Set Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAEE:1;                 /* Sets All Enable Error Interrupts */
      vuint8_t  :1;
      vuint8_t SEEI:5;                 /* Set Enable Error Interrupt */
    } B;
  } SEEI;

  union {                              /* Clear Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAEE:1;                 /* Clear All Enable Error Interrupts */
      vuint8_t  :1;
      vuint8_t CEEI:5;                 /* Clear Enable Error Interrupt */
    } B;
  } CEEI;

  union {                              /* Clear Interrupt Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAIR:1;                 /* Clear All Interrupt Requests */
      vuint8_t  :1;
      vuint8_t CINT:5;                 /* Clear Interrupt Request */
    } B;
  } CINT;

  union {                              /* Clear Error Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CAEI:1;                 /* Clear All Error Indicators */
      vuint8_t  :1;
      vuint8_t CERR:5;                 /* Clear Error Indicator */
    } B;
  } CERR;

  union {                              /* Set START Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t SAST:1;                 /* Set All START Bits (activates all channels) */
      vuint8_t  :1;
      vuint8_t SSRT:5;                 /* Set START Bit */
    } B;
  } SSRT;

  union {                              /* Clear DONE Status Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;                  /* No Op enable */
      vuint8_t CADN:1;                 /* Clears All DONE Bits */
      vuint8_t  :1;
      vuint8_t CDNE:5;                 /* Clear DONE Bit */
    } B;
  } CDNE;

  uint8_t DMA_reserved2[4];
  union {                              /* Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t INT31:1;               /* Interrupt Request 31 */
      vuint32_t INT30:1;               /* Interrupt Request 30 */
      vuint32_t INT29:1;               /* Interrupt Request 29 */
      vuint32_t INT28:1;               /* Interrupt Request 28 */
      vuint32_t INT27:1;               /* Interrupt Request 27 */
      vuint32_t INT26:1;               /* Interrupt Request 26 */
      vuint32_t INT25:1;               /* Interrupt Request 25 */
      vuint32_t INT24:1;               /* Interrupt Request 24 */
      vuint32_t INT23:1;               /* Interrupt Request 23 */
      vuint32_t INT22:1;               /* Interrupt Request 22 */
      vuint32_t INT21:1;               /* Interrupt Request 21 */
      vuint32_t INT20:1;               /* Interrupt Request 20 */
      vuint32_t INT19:1;               /* Interrupt Request 19 */
      vuint32_t INT18:1;               /* Interrupt Request 18 */
      vuint32_t INT17:1;               /* Interrupt Request 17 */
      vuint32_t INT16:1;               /* Interrupt Request 16 */
      vuint32_t INT15:1;               /* Interrupt Request 15 */
      vuint32_t INT14:1;               /* Interrupt Request 14 */
      vuint32_t INT13:1;               /* Interrupt Request 13 */
      vuint32_t INT12:1;               /* Interrupt Request 12 */
      vuint32_t INT11:1;               /* Interrupt Request 11 */
      vuint32_t INT10:1;               /* Interrupt Request 10 */
      vuint32_t INT9:1;                /* Interrupt Request 9 */
      vuint32_t INT8:1;                /* Interrupt Request 8 */
      vuint32_t INT7:1;                /* Interrupt Request 7 */
      vuint32_t INT6:1;                /* Interrupt Request 6 */
      vuint32_t INT5:1;                /* Interrupt Request 5 */
      vuint32_t INT4:1;                /* Interrupt Request 4 */
      vuint32_t INT3:1;                /* Interrupt Request 3 */
      vuint32_t INT2:1;                /* Interrupt Request 2 */
      vuint32_t INT1:1;                /* Interrupt Request 1 */
      vuint32_t INT0:1;                /* Interrupt Request 0 */
    } B;
  } INT;

  uint8_t DMA_reserved3[4];
  union {                              /* Error Register */
    vuint32_t R;
    struct {
      vuint32_t ERR31:1;               /* Error In Channel 31 */
      vuint32_t ERR30:1;               /* Error In Channel 30 */
      vuint32_t ERR29:1;               /* Error In Channel 29 */
      vuint32_t ERR28:1;               /* Error In Channel 28 */
      vuint32_t ERR27:1;               /* Error In Channel 27 */
      vuint32_t ERR26:1;               /* Error In Channel 26 */
      vuint32_t ERR25:1;               /* Error In Channel 25 */
      vuint32_t ERR24:1;               /* Error In Channel 24 */
      vuint32_t ERR23:1;               /* Error In Channel 23 */
      vuint32_t ERR22:1;               /* Error In Channel 22 */
      vuint32_t ERR21:1;               /* Error In Channel 21 */
      vuint32_t ERR20:1;               /* Error In Channel 20 */
      vuint32_t ERR19:1;               /* Error In Channel 19 */
      vuint32_t ERR18:1;               /* Error In Channel 18 */
      vuint32_t ERR17:1;               /* Error In Channel 17 */
      vuint32_t ERR16:1;               /* Error In Channel 16 */
      vuint32_t ERR15:1;               /* Error In Channel 15 */
      vuint32_t ERR14:1;               /* Error In Channel 14 */
      vuint32_t ERR13:1;               /* Error In Channel 13 */
      vuint32_t ERR12:1;               /* Error In Channel 12 */
      vuint32_t ERR11:1;               /* Error In Channel 11 */
      vuint32_t ERR10:1;               /* Error In Channel 10 */
      vuint32_t ERR9:1;                /* Error In Channel 9 */
      vuint32_t ERR8:1;                /* Error In Channel 8 */
      vuint32_t ERR7:1;                /* Error In Channel 7 */
      vuint32_t ERR6:1;                /* Error In Channel 6 */
      vuint32_t ERR5:1;                /* Error In Channel 5 */
      vuint32_t ERR4:1;                /* Error In Channel 4 */
      vuint32_t ERR3:1;                /* Error In Channel 3 */
      vuint32_t ERR2:1;                /* Error In Channel 2 */
      vuint32_t ERR1:1;                /* Error In Channel 1 */
      vuint32_t ERR0:1;                /* Error In Channel 0 */
    } B;
  } ERR;

  uint8_t DMA_reserved4[4];
  union {                              /* Hardware Request Status Register */
    vuint32_t R;
    struct {
      vuint32_t HRS31:1;               /* Hardware Request Status Channel 31 */
      vuint32_t HRS30:1;               /* Hardware Request Status Channel 30 */
      vuint32_t HRS29:1;               /* Hardware Request Status Channel 29 */
      vuint32_t HRS28:1;               /* Hardware Request Status Channel 28 */
      vuint32_t HRS27:1;               /* Hardware Request Status Channel 27 */
      vuint32_t HRS26:1;               /* Hardware Request Status Channel 26 */
      vuint32_t HRS25:1;               /* Hardware Request Status Channel 25 */
      vuint32_t HRS24:1;               /* Hardware Request Status Channel 24 */
      vuint32_t HRS23:1;               /* Hardware Request Status Channel 23 */
      vuint32_t HRS22:1;               /* Hardware Request Status Channel 22 */
      vuint32_t HRS21:1;               /* Hardware Request Status Channel 21 */
      vuint32_t HRS20:1;               /* Hardware Request Status Channel 20 */
      vuint32_t HRS19:1;               /* Hardware Request Status Channel 19 */
      vuint32_t HRS18:1;               /* Hardware Request Status Channel 18 */
      vuint32_t HRS17:1;               /* Hardware Request Status Channel 17 */
      vuint32_t HRS16:1;               /* Hardware Request Status Channel 16 */
      vuint32_t HRS15:1;               /* Hardware Request Status Channel 15 */
      vuint32_t HRS14:1;               /* Hardware Request Status Channel 14 */
      vuint32_t HRS13:1;               /* Hardware Request Status Channel 13 */
      vuint32_t HRS12:1;               /* Hardware Request Status Channel 12 */
      vuint32_t HRS11:1;               /* Hardware Request Status Channel 11 */
      vuint32_t HRS10:1;               /* Hardware Request Status Channel 10 */
      vuint32_t HRS9:1;                /* Hardware Request Status Channel 9 */
      vuint32_t HRS8:1;                /* Hardware Request Status Channel 8 */
      vuint32_t HRS7:1;                /* Hardware Request Status Channel 7 */
      vuint32_t HRS6:1;                /* Hardware Request Status Channel 6 */
      vuint32_t HRS5:1;                /* Hardware Request Status Channel 5 */
      vuint32_t HRS4:1;                /* Hardware Request Status Channel 4 */
      vuint32_t HRS3:1;                /* Hardware Request Status Channel 3 */
      vuint32_t HRS2:1;                /* Hardware Request Status Channel 2 */
      vuint32_t HRS1:1;                /* Hardware Request Status Channel 1 */
      vuint32_t HRS0:1;                /* Hardware Request Status Channel 0 */
    } B;
  } HRS;

  uint8_t DMA_reserved5[200];
  union {                              /* Channel n Priority Register */
    vuint8_t R;
    struct {
      vuint8_t ECP:1;                  /* Enable Channel Preemption. */
      vuint8_t DPA:1;                  /* Disable Preempt Ability. */
      vuint8_t GRPPRI:2;               /* Channel n Current Group Priority */
      vuint8_t CHPRI:4;                /* Channel n Arbitration Priority */
    } B;
  } DCHPRI[32];

  uint8_t DMA_reserved6[32];
  union {                              /* Channel n Master ID Register */
    vuint8_t R;
    struct {
      vuint8_t EMI:1;                  /* Enable Master ID replication */
      vuint8_t PAL:1;                  /* Privileged Access Level */
      vuint8_t  :2;
      vuint8_t MID:4;                  /* Master ID */
    } B;
  } DCHMID[32];

  uint8_t DMA_reserved7[3744];
  struct {
    union {                            /* TCD Source Address */
      vuint32_t R;
      struct {
        vuint32_t SADDR:32;            /* Source Address */
      } B;
    } SADDR;
    union {                            /* TCD Transfer Attributes */
      vuint16_t R;
      struct {
        vuint16_t SMOD:5;              /* Source Address Modulo */
        vuint16_t SSIZE:3;             /* Source data transfer size */
        vuint16_t DMOD:5;              /* Destination Address Modulo */
        vuint16_t DSIZE:3;             /* Destination data transfer size */
      } B;
    } ATTR;
    union {                            /* TCD Signed Source Address Offset */
      vuint16_t R;
      struct {
        vuint16_t SOFF:16;             /* Source address signed offset */
      } B;
    } SOFF;
    union {
      union {                          /* TCD Minor Byte Count (Minor Loop Disabled) */
        vuint32_t R;
        struct {
          vuint32_t NBYTES:32;         /* Minor Byte Transfer Count */
        } B;
      } MLNO;
      union {                          /* TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;           /* Source Minor Loop Offset Enable */
          vuint32_t DMLOE:1;           /* Destination Minor Loop Offset enable */
          vuint32_t NBYTES:30;         /* Minor Byte Transfer Count */
        } B;
      } MLOFFNO;
      union {                          /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;           /* Source Minor Loop Offset Enable */
          vuint32_t DMLOE:1;           /* Destination Minor Loop Offset enable */
          vuint32_t MLOFF:20;          /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
          vuint32_t NBYTES:10;         /* Minor Byte Transfer Count */
        } B;
      } MLOFFYES;
    } NBYTES;
    union {                            /* TCD Last Source Address Adjustment */
      vuint32_t R;
      struct {
        vuint32_t SLAST:32;            /* Last Source Address Adjustment */
      } B;
    } SLAST;
    union {                            /* TCD Destination Address */
      vuint32_t R;
      struct {
        vuint32_t DADDR:32;            /* Destination Address */
      } B;
    } DADDR;
    union {
      union {                          /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enable channel-to-channel linking on minor-loop complete */
          vuint16_t CITER:15;          /* Current Major Iteration Count */
        } B;
      } ELINKNO;
      union {                          /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enable channel-to-channel linking on minor-loop complete */
          vuint16_t  :1;
          vuint16_t LINKCH:5;          /* Link Channel Number */
          vuint16_t CITER:9;           /* Current Major Iteration Count */
        } B;
      } ELINKYES;
    } CITER;
    union {                            /* TCD Signed Destination Address Offset */
      vuint16_t R;
      struct {
        vuint16_t DOFF:16;             /* Destination Address Signed Offset */
      } B;
    } DOFF;
    union {                            /* TCD Last Destination Address Adjustment/Scatter Gather Address */
      vuint32_t R;
      struct {
        vuint32_t DLASTSGA:32;
      } B;
    } DLASTSGA;
    union {
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enables channel-to-channel linking on minor loop complete */
          vuint16_t BITER:15;          /* Starting Major Iteration Count */
        } B;
      } ELINKNO;
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;           /* Enables channel-to-channel linking on minor loop complete */
          vuint16_t  :1;
          vuint16_t LINKCH:5;          /* Link Channel Number */
          vuint16_t BITER:9;           /* Starting major iteration count */
        } B;
      } ELINKYES;
    } BITER;
    union {                            /* TCD Control and Status */
      vuint16_t R;
      struct {
        vuint16_t BWC:2;               /* Bandwidth Control */
        vuint16_t  :1;
        vuint16_t MAJORLINKCH:5;       /* Link Channel Number */
        vuint16_t DONE:1;              /* Channel Done */
        vuint16_t ACTIVE:1;            /* Channel Active */
        vuint16_t MAJORELINK:1;        /* Enable channel-to-channel linking on major loop complete */
        vuint16_t ESG:1;               /* Enable Scatter/Gather Processing */
        vuint16_t DREQ:1;              /* Disable Request */
        vuint16_t INTHALF:1;           /* Enable an interrupt when major counter is half complete. */
        vuint16_t INTMAJOR:1;          /* Enable an interrupt when major iteration count completes. */
        vuint16_t START:1;             /* Channel Start */
      } B;
    } CSR;
  } TCD[32];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

struct DMAMUX_tag {
  union {                              /* Channel Configuration register */
    vuint8_t R;
    struct {
      vuint8_t ENBL:1;                 /* DMA Channel Enable */
      vuint8_t TRIG:1;                 /* DMA Channel Trigger Enable */
      vuint8_t SOURCE:6;               /* DMA Channel Source (Slot) */
    } B;
  } CHCFG[16];
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

struct DSPI_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSTR:1;                /* Master/Slave Mode Select */
      vuint32_t CONT_SCKE:1;           /* Continuous SCK Enable */
      vuint32_t DCONF:2;               /* Interface Configuration */
      vuint32_t FRZ:1;                 /* Freeze */
      vuint32_t MTFE:1;                /* Modified Timing Format Enable */
      vuint32_t PCSSE:1;               /* Peripheral Chip Select Strobe Enable */
      vuint32_t ROOE:1;                /* Receive FIFO Overflow Overwrite Enable */
      vuint32_t  :2;
      vuint32_t PCSIS:6;               /* Peripheral Chip Select x Inactive State */
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t DIS_TXF:1;             /* Disable Transmit FIFO */
      vuint32_t DIS_RXF:1;             /* Disable Receive FIFO */
      vuint32_t CLR_TXF:1;             /* Clear TX FIFO */
      vuint32_t CLR_RXF:1;             /* CLR_RXF */
      vuint32_t SMPL_PT:2;             /* Sample Point */
      vuint32_t  :4;
      vuint32_t XSPI:1;                /* Extended SPI Mode */
      vuint32_t FCPCS:1;               /* Fast Continuous PCS Mode. */
      vuint32_t PES:1;                 /* Parity Error Stop */
      vuint32_t HALT:1;                /* Halt */
    } B;
  } MCR;

  uint8_t DSPI_reserved0[4];
  union {                              /* Transfer Count Register */
    vuint32_t R;
    struct {
      vuint32_t SPI_TCNT:16;           /* SPI Transfer Counter */
      vuint32_t  :16;
    } B;
  } TCR;

  union {
    union {                            /* Clock and Transfer Attributes Register (In Master Mode) */
      vuint32_t R;
      struct {
        vuint32_t DBR:1;               /* Double Baud Rate */
        vuint32_t FMSZ:4;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t LSBFE:1;             /* LSB First */
        vuint32_t PCSSCK:2;            /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;              /* After SCK Delay Prescaler */
        vuint32_t PDT:2;               /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;               /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;             /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;               /* After SCK Delay Scaler */
        vuint32_t DT:4;                /* Delay After Transfer Scaler */
        vuint32_t BR:4;                /* Baud Rate Scaler */
      } B;
    } CTAR[6];
    union {                            /* Clock and Transfer Attributes Register (In Slave Mode) */
      vuint32_t R;
      struct {
        vuint32_t FMSZ:5;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t PE:1;                /* Parity Enable */
        vuint32_t PP:1;                /* Parity Polarity */
        vuint32_t FMSZ5:1;             /* MSB of Frame Size when DSI is used in 64-bit Mode */
        vuint32_t  :22;
      } B;
    } CTAR_SLAVE[2];
  } MODE;

  uint8_t DSPI_reserved1[8];
  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t TCF:1;                 /* Transfer Complete Flag */
      vuint32_t TXRXS:1;               /* TX and RX Status */
      vuint32_t SPITCF:1;              /* SPI Frame Transfer Complete Flag. */
      vuint32_t EOQF:1;                /* End of Queue Flag */
      vuint32_t TFUF:1;                /* Transmit FIFO Underflow Flag */
      vuint32_t DSITCF:1;              /* DSI Frame Transfer Complete Flag. */
      vuint32_t TFFF:1;                /* Transmit FIFO Fill Flag */
      vuint32_t BSYF:1;                /* Busy Flag. */
      vuint32_t CMDTCF:1;              /* Command Transfer Complete Flag. */
      vuint32_t DPEF:1;                /* DSI Parity Error Flag */
      vuint32_t SPEF:1;                /* SPI Parity Error Flag */
      vuint32_t DDIF:1;                /* DSI Data Received with Active Bits */
      vuint32_t RFOF:1;                /* Receive FIFO Overflow Flag */
      vuint32_t TFIWF:1;               /* Tranmit FIFO Invalid Write Flag */
      vuint32_t RFDF:1;                /* Receive FIFO Drain Flag */
      vuint32_t CMDFFF:1;              /* Command FIFO Fill Flag */
      vuint32_t TXCTR:4;               /* TX FIFO Counter */
      vuint32_t TXNXTPTR:4;            /* Transmit Next Pointer */
      vuint32_t RXCTR:4;               /* RX FIFO Counter */
      vuint32_t POPNXTPTR:4;           /* Pop Next Pointer */
    } B;
  } SR;

  union {                              /* DMA/Interrupt Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t TCF_RE:1;              /* Transmission Complete Request Enable */
      vuint32_t CMDFFF_RE:1;           /* Command FIFO Fill Flag Request Enable. */
      vuint32_t SPITCF_RE:1;           /* SPI Frame Transmission Complete Request Enable. */
      vuint32_t EOQF_RE:1;             /* Finished Request Enable */
      vuint32_t TFUF_RE:1;             /* Transmit FIFO Underflow Request Enable */
      vuint32_t DSITCF_RE:1;           /* DSI Frame Transmission Complete Request Enable. */
      vuint32_t TFFF_RE:1;             /* Transmit FIFO Fill Request Enable */
      vuint32_t TFFF_DIRS:1;           /* Transmit FIFO Fill DMA or Interrupt Request Select */
      vuint32_t CMDTCF_RE:1;           /* Command Transmission Complete Request Enable. */
      vuint32_t DPEF_RE:1;             /* DSI Parity Error Request Enable */
      vuint32_t SPEF_RE:1;             /* SPI Parity Error Request Enable */
      vuint32_t DDIF_RE:1;             /* DSI data received with active bits Request Enable */
      vuint32_t RFOF_RE:1;             /* Receive FIFO Overflow Request Enable */
      vuint32_t TFIWF_RE:1;            /* Transmit FIFO Invalid Write Request Enable. */
      vuint32_t RFDF_RE:1;             /* Receive FIFO Drain Request Enable */
      vuint32_t RFDF_DIRS:1;           /* Receive FIFO Drain DMA or Interrupt Request Select */
      vuint32_t CMDFFF_DIRS:1;         /* Command FIFO Fill DMA or Interrupt Request Select */
      vuint32_t DDIF_DIRS:1;           /* DSI data received with active bits - DMA or Interrupt Request Select. */
      vuint32_t  :14;
    } B;
  } RSER;

  union {
    union {                            /* PUSH TX FIFO Register In Master Mode */
      vuint32_t R;
      struct {
        vuint32_t CONT:1;              /* Continuous Peripheral Chip Select Enable */
        vuint32_t CTAS:3;              /* Clock and Transfer Attributes Select */
        vuint32_t EOQ:1;               /* End Of Queue */
        vuint32_t CTCNT:1;             /* Clear Transfer Counter */
        vuint32_t PE_MASC:1;           /* Parity Enable or Mask T ASC delay in the current frame */
        vuint32_t PP_MCSC:1;           /* Parity Polarity or Mask T CSC delay in the next frame */
        vuint32_t  :2;
        vuint32_t PCS:6;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR;
    union {                            /* PUSH TX FIFO Register In Slave Mode */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR_SLAVE;
  } PUSHR;

  union {                              /* POP RX FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Received Data */
    } B;
  } POPR;

  union {                              /* Transmit FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t TXCMD_TXDATA:16;       /* Transmit Command or Transmit Data */
      vuint32_t TXDATA:16;             /* Transmit Data */
    } B;
  } TXFR[4];

  uint8_t DSPI_reserved2[48];
  union {                              /* Receive FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Receive Data */
    } B;
  } RXFR[4];

  uint8_t DSPI_reserved3[48];
  union {                              /* DSI Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MTOE:1;                /* Multiple Transfer Operation Enable */
      vuint32_t FMSZ4:1;               /* MSB of the frame size in master mode. */
      vuint32_t MTOCNT:6;              /* Multiple Transfer Operation Count */
      vuint32_t FMSZ5:1;               /* MSB of the frame size in master mode when DSI is used in 64-bit mode. */
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t TXSS:1;                /* Transmit Data Source Select. */
      vuint32_t TPOL:1;                /* Trigger Polarity */
      vuint32_t TRRE:1;                /* Trigger Reception Enable */
      vuint32_t CID:1;                 /* Change In Data Transfer Enable */
      vuint32_t DCONT:1;               /* DSI Continuous Peripheral Chip Select Enable */
      vuint32_t DSICTAS:3;             /* DSI Clock and Transfer Attributes Select */
      vuint32_t DMS:1;                 /* Data Match Stop */
      vuint32_t PES:1;                 /* Parity Error Stop */
      vuint32_t PE:1;                  /* Parity Enable */
      vuint32_t PP:1;                  /* Parity Polarity */
      vuint32_t DPCSx:8;               /* DSI Peripheral Chip Select 0-7 */
    } B;
  } DSICR0;

  union {                              /* DSI Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;           /* Serialized Data */
    } B;
  } SDR0;

  union {                              /* DSI Alternate Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;          /* Alternate Serialized Data */
    } B;
  } ASDR0;

  union {                              /* DSI Transmit Comparison Register 0 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;          /* Compare Data */
    } B;
  } COMPR0;

  union {                              /* DSI Deserialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DESER_DATA:32;         /* Deserialized Data */
    } B;
  } DDR0;

  union {                              /* DSI Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t  :6;
      vuint32_t  :3;
      vuint32_t CSI_PRTY:1;            /* CSI Priority */
      vuint32_t  :1;
      vuint32_t DSI64E:1;              /* DSI 64-bit Mode Enable */
      vuint32_t  :2;
      vuint32_t  :8;
      vuint32_t  :8;
    } B;
  } DSICR1;

  union {                              /* DSI Serialization Source Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;                 /* Source Select */
    } B;
  } SSR0;

  union {                              /* DSI Parallel Input Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IPS7:4;                /* Input Pin Select 7 */
      vuint32_t IPS6:4;                /* Input Pin Select 6 */
      vuint32_t IPS5:4;                /* Input Pin Select 5 */
      vuint32_t IPS4:4;                /* Input Pin Select 5 */
      vuint32_t IPS3:4;                /* Input Pin Select 3 */
      vuint32_t IPS2:4;                /* Input Pin Select 2 */
      vuint32_t IPS1:4;                /* Input Pin Select 1 */
      vuint32_t IPS0:4;                /* Input Pin Select 0 */
    } B;
  } PISR0;

  union {                              /* DSI Parallel Input Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t IPS15:4;               /* Input Pin Select 15 */
      vuint32_t IPS14:4;               /* Input Pin Select 14 */
      vuint32_t IPS13:4;               /* Input Pin Select 13 */
      vuint32_t IPS12:4;               /* Input Pin Select 12 */
      vuint32_t IPS11:4;               /* Input Pin Select 11 */
      vuint32_t IPS10:4;               /* Input Pin Select 10 */
      vuint32_t IPS9:4;                /* Input Pin Select 9 */
      vuint32_t IPS8:4;                /* Input Pin Select 8 */
    } B;
  } PISR1;

  union {                              /* DSI Parallel Input Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t IPS23:4;               /* Input Pin Select 23 */
      vuint32_t IPS22:4;               /* Input Pin Select 22 */
      vuint32_t IPS21:4;               /* Input Pin Select 21 */
      vuint32_t IPS20:4;               /* Input Pin Select 20 */
      vuint32_t IPS19:4;               /* Input Pin Select 19 */
      vuint32_t IPS18:4;               /* Input Pin Select 18 */
      vuint32_t IPS17:4;               /* Input Pin Select 17 */
      vuint32_t IPS16:4;               /* Input Pin Select 16 */
    } B;
  } PISR2;

  union {                              /* DSI Parallel Input Select Register 3 */
    vuint32_t R;
    struct {
      vuint32_t IPS31:4;               /* Input Pin Select 31 */
      vuint32_t IPS30:4;               /* Input Pin Select 30 */
      vuint32_t IPS29:4;               /* Input Pin Select 29 */
      vuint32_t IPS28:4;               /* Input Pin Select 28 */
      vuint32_t IPS27:4;               /* Input Pin Select 27 */
      vuint32_t IPS26:4;               /* Input Pin Select 26 */
      vuint32_t IPS25:4;               /* Input Pin Select 25 */
      vuint32_t IPS24:4;               /* Input Pin Select 24 */
    } B;
  } PISR3;

  union {                              /* DSI Deserialized Data Interrupt Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MASK:32;               /* Mask */
    } B;
  } DIMR0;

  union {                              /* DSI Deserialized Data Polarity Interrupt Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DP:32;                 /* Data Polarity */
    } B;
  } DPIR0;

  union {                              /* DSI Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;           /* Serialized Data */
    } B;
  } SDR1;

  union {                              /* DSI Alternate Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;          /* Alternate Serialized Data */
    } B;
  } ASDR1;

  union {                              /* DSI Transmit Comparison Register 1 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;          /* Compare Data */
    } B;
  } COMPR1;

  union {                              /* DSI Deserialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DESER_DATA:32;         /* Deserialized Data */
    } B;
  } DDR1;

  union {                              /* DSI Serialization Source Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;                 /* Source Select */
    } B;
  } SSR1;

  union {                              /* DSI Parallel Input Select Register 4 */
    vuint32_t R;
    struct {
      vuint32_t IPS39:4;               /* Input Pin Select 39 */
      vuint32_t IPS38:4;               /* Input Pin Select 38 */
      vuint32_t IPS37:4;               /* Input Pin Select 37 */
      vuint32_t IPS36:4;               /* Input Pin Select 36 */
      vuint32_t IPS35:4;               /* Input Pin Select 35 */
      vuint32_t IPS34:4;               /* Input Pin Select 34 */
      vuint32_t IPS33:4;               /* Input Pin Select 33 */
      vuint32_t IPS32:4;               /* Input Pin Select 32 */
    } B;
  } PISR4;

  union {                              /* DSI Parallel Input Select Register 5 */
    vuint32_t R;
    struct {
      vuint32_t IPS47:4;               /* Input Pin Select 47 */
      vuint32_t IPS46:4;               /* Input Pin Select 46 */
      vuint32_t IPS45:4;               /* Input Pin Select 45 */
      vuint32_t IPS44:4;               /* Input Pin Select 44 */
      vuint32_t IPS43:4;               /* Input Pin Select 43 */
      vuint32_t IPS42:4;               /* Input Pin Select 42 */
      vuint32_t IPS41:4;               /* Input Pin Select 41 */
      vuint32_t IPS40:4;               /* Input Pin Select 40 */
    } B;
  } PISR5;

  union {                              /* DSI Parallel Input Select Register 6 */
    vuint32_t R;
    struct {
      vuint32_t IPS55:4;               /* Input Pin Select 55 */
      vuint32_t IPS54:4;               /* Input Pin Select 54 */
      vuint32_t IPS53:4;               /* Input Pin Select 53 */
      vuint32_t IPS52:4;               /* Input Pin Select 52 */
      vuint32_t IPS51:4;               /* Input Pin Select 51 */
      vuint32_t IPS50:4;               /* Input Pin Select 50 */
      vuint32_t IPS49:4;               /* Input Pin Select 49 */
      vuint32_t IPS48:4;               /* Input Pin Select 48 */
    } B;
  } PISR6;

  union {                              /* DSI Parallel Input Select Register 7 */
    vuint32_t R;
    struct {
      vuint32_t IPS63:4;               /* Input Pin Select 63 */
      vuint32_t IPS62:4;               /* Input Pin Select 62 */
      vuint32_t IPS61:4;               /* Input Pin Select 61 */
      vuint32_t IPS60:4;               /* Input Pin Select 60 */
      vuint32_t IPS59:4;               /* Input Pin Select 59 */
      vuint32_t IPS58:4;               /* Input Pin Select 58 */
      vuint32_t IPS57:4;               /* Input Pin Select 57 */
      vuint32_t IPS56:4;               /* Input Pin Select 56 */
    } B;
  } PISR7;

  union {                              /* DSI Deserialized Data Interrupt Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MASK:32;               /* Mask */
    } B;
  } DIMR1;

  union {                              /* DSI Deserialized Data Polarity Interrupt Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DP:32;                 /* Data Polarity */
    } B;
  } DPIR1;

  union {                              /* Clock and Transfer Attributes Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t FMSZE:1;               /* Frame Size Extended */
      vuint32_t  :5;
      vuint32_t DTCP:11;               /* Data Transfer Count Preload */
    } B;
  } CTARE[6];

  uint8_t DSPI_reserved4[8];
  union {                              /* Status Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t RXCTR4:1;              /* RX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t TXCTR4:1;              /* TX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t CMDCTR:5;              /* CMD FIFO Counter */
      vuint32_t CMDNXTPTR:4;           /* Command Next Pointer */
    } B;
  } SREX;

  union {                              /* Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;              /* Trigger Register Enable */
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t ASDR_WT:1;             /* ASDR Write Trigger Enable */
      vuint32_t CID:1;                 /* Change In Data Transfer Enable */
      vuint32_t TRRE:1;                /* Trigger Reception Enable */
    } B;
  } TRIG;
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  union {                              /* Interrupt Event Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t BABR:1;                /* Babbling Receive Error */
      vuint32_t BABT:1;                /* Babbling Transmit Error */
      vuint32_t GRA:1;                 /* Graceful Stop Complete */
      vuint32_t TXF:1;                 /* Transmit Frame Interrupt */
      vuint32_t TXB:1;                 /* Transmit Buffer Interrupt */
      vuint32_t RXF:1;                 /* Receive Frame Interrupt */
      vuint32_t RXB:1;                 /* Receive Buffer Interrupt */
      vuint32_t MII:1;                 /* MII Interrupt. */
      vuint32_t EBERR:1;               /* Ethernet Bus Error */
      vuint32_t LC:1;                  /* Late Collision */
      vuint32_t RL:1;                  /* Collision Retry Limit */
      vuint32_t UN:1;                  /* Transmit FIFO Underrun */
      vuint32_t PLR:1;                 /* Payload Receive Error */
      vuint32_t WAKEUP:1;              /* Node Wakeup Request Indication */
      vuint32_t TS_AVAIL:1;            /* Transmit Timestamp Available */
      vuint32_t TS_TIMER:1;            /* Timestamp Timer */
      vuint32_t RXFLUSH_2:1;
      vuint32_t RXFLUSH_1:1;
      vuint32_t RXFLUSH_0:1;
      vuint32_t  :1;
      vuint32_t PARSERR:1;
      vuint32_t PARSRF:1;
      vuint32_t  :1;
      vuint32_t TXF2:1;                /* Transmit frame interrupt, class 2 */
      vuint32_t TXB2:1;                /* Transmit buffer interrupt, class 2 */
      vuint32_t RXF2:1;                /* Receive frame interrupt, class 2 */
      vuint32_t RXB2:1;                /* Receive buffer interrupt, class 2 */
      vuint32_t TXF1:1;                /* Transmit frame interrupt, class 1 */
      vuint32_t TXB1:1;                /* Transmit buffer interrupt, class 1 */
      vuint32_t RXF1:1;                /* Receive frame interrupt, class 1 */
      vuint32_t RXB1:1;                /* Receive buffer interrupt, class 1 */
    } B;
  } EIR;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t BABR:1;                /* BABR Interrupt Mask */
      vuint32_t BABT:1;                /* BABT Interrupt Mask */
      vuint32_t GRA:1;                 /* GRA Interrupt Mask */
      vuint32_t TXF:1;                 /* TXF Interrupt Mask */
      vuint32_t TXB:1;                 /* TXB Interrupt Mask */
      vuint32_t RXF:1;                 /* RXF Interrupt Mask */
      vuint32_t RXB:1;                 /* RXB Interrupt Mask */
      vuint32_t MII:1;                 /* MII Interrupt Mask */
      vuint32_t EBERR:1;               /* EBERR Interrupt Mask */
      vuint32_t LC:1;                  /* LC Interrupt Mask */
      vuint32_t RL:1;                  /* RL Interrupt Mask */
      vuint32_t UN:1;                  /* UN Interrupt Mask */
      vuint32_t PLR:1;                 /* PLR Interrupt Mask */
      vuint32_t WAKEUP:1;              /* WAKEUP Interrupt Mask */
      vuint32_t TS_AVAIL:1;            /* TS_AVAIL Interrupt Mask */
      vuint32_t TS_TIMER:1;            /* TS_TIMER Interrupt Mask */
      vuint32_t RXFLUSH_2:1;
      vuint32_t RXFLUSH_1:1;
      vuint32_t RXFLUSH_0:1;
      vuint32_t  :1;
      vuint32_t PARSERR:1;
      vuint32_t PARSRF:1;
      vuint32_t  :1;
      vuint32_t TXF2:1;                /* Transmit frame interrupt, class 2 */
      vuint32_t TXB2:1;                /* Transmit buffer interrupt, class 2 */
      vuint32_t RXF2:1;                /* Receive frame interrupt, class 2 */
      vuint32_t RXB2:1;                /* Receive buffer interrupt, class 2 */
      vuint32_t TXF1:1;                /* Transmit frame interrupt, class 1 */
      vuint32_t TXB1:1;                /* Transmit buffer interrupt, class 1 */
      vuint32_t RXF1:1;                /* Receive frame interrupt, class 1 */
      vuint32_t RXB1:1;                /* Receive buffer interrupt, class 1 */
    } B;
  } EIMR;

  uint8_t ENET_reserved1[4];
  union {                              /* Receive Descriptor Active Register - Ring 0 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;                /* Receive Descriptor Active */
      vuint32_t  :24;
    } B;
  } RDAR;

  union {                              /* Transmit Descriptor Active Register - Ring 0 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;                /* Transmit Descriptor Active */
      vuint32_t  :24;
    } B;
  } TDAR;

  uint8_t ENET_reserved2[12];
  union {                              /* Ethernet Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t SVLANDBL:1;            /* S-VLAN double tag */
      vuint32_t VLANUSE2ND:1;          /* VLAN use second tag */
      vuint32_t SVLANEN:1;             /* S-VLAN enable */
      vuint32_t DBSWP:1;               /* Descriptor Byte Swapping Enable */
      vuint32_t  :1;
      vuint32_t DBGEN:1;               /* Debug Enable */
      vuint32_t  :1;
      vuint32_t EN1588:1;              /* EN1588 Enable */
      vuint32_t SLEEP:1;               /* Sleep Mode Enable */
      vuint32_t MAGICEN:1;             /* Magic Packet Detection Enable */
      vuint32_t ETHEREN:1;             /* Ethernet Enable */
      vuint32_t RESET:1;               /* Ethernet MAC Reset */
    } B;
  } ECR;

  uint8_t ENET_reserved3[24];
  union {                              /* MII Management Frame Register */
    vuint32_t R;
    struct {
      vuint32_t ST:2;                  /* Start Of Frame Delimiter */
      vuint32_t OP:2;                  /* Operation Code */
      vuint32_t PA:5;                  /* PHY Address */
      vuint32_t RA:5;                  /* Register Address */
      vuint32_t TA:2;                  /* Turn Around */
      vuint32_t DATA:16;               /* Management Frame Data */
    } B;
  } MMFR;

  union {                              /* MII Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t HOLDTIME:3;            /* Hold time On MDIO Output */
      vuint32_t DIS_PRE:1;             /* Disable Preamble */
      vuint32_t MII_SPEED:6;           /* MII Speed */
      vuint32_t  :1;
    } B;
  } MSCR;

  uint8_t ENET_reserved4[28];
  union {                              /* MIB Control Register */
    vuint32_t R;
    struct {
      vuint32_t MIB_DIS:1;             /* Disable MIB Logic */
      vuint32_t MIB_IDLE:1;            /* MIB Idle */
      vuint32_t MIB_CLEAR:1;           /* MIB Clear */
      vuint32_t  :29;
    } B;
  } MIBC;

  uint8_t ENET_reserved5[28];
  union {                              /* Receive Control Register */
    vuint32_t R;
    struct {
      vuint32_t GRS:1;                 /* Graceful Receive Stopped */
      vuint32_t NLC:1;                 /* Payload Length Check Disable */
      vuint32_t MAX_FL:14;             /* Maximum Frame Length */
      vuint32_t CFEN:1;                /* MAC Control Frame Enable */
      vuint32_t CRCFWD:1;              /* Terminate/Forward Received CRC */
      vuint32_t PAUFWD:1;              /* Terminate/Forward Pause Frames */
      vuint32_t PADEN:1;               /* Enable Frame Padding Remove On Receive */
      vuint32_t  :2;
      vuint32_t RMII_10T:1;
      vuint32_t RMII_MODE:1;           /* RMII Mode Enable */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t FCE:1;                 /* Flow Control Enable */
      vuint32_t BC_REJ:1;              /* Broadcast Frame Reject */
      vuint32_t PROM:1;                /* Promiscuous Mode */
      vuint32_t MII_MODE:1;            /* Media Independent Interface Mode */
      vuint32_t DRT:1;                 /* Disable Receive On Transmit */
      vuint32_t LOOP:1;                /* Internal Loopback */
    } B;
  } RCR;

  uint8_t ENET_reserved6[60];
  union {                              /* Transmit Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t CRCFWD:1;              /* Forward Frame From Application With CRC */
      vuint32_t ADDINS:1;              /* Set MAC Address On Transmit */
      vuint32_t ADDSEL:3;              /* Source MAC Address Select On Transmit */
      vuint32_t RFC_PAUSE:1;           /* Receive Frame Control Pause */
      vuint32_t TFC_PAUSE:1;           /* Transmit Frame Control Pause */
      vuint32_t FDEN:1;                /* Full-Duplex Enable */
      vuint32_t  :1;
      vuint32_t GTS:1;                 /* Graceful Transmit Stop */
    } B;
  } TCR;

  uint8_t ENET_reserved7[28];
  union {                              /* Physical Address Lower Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR1:32;             /* Pause Address */
    } B;
  } PALR;

  union {                              /* Physical Address Upper Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR2:16;
      vuint32_t TYPE:16;               /* Type Field In PAUSE Frames */
    } B;
  } PAUR;

  union {                              /* Opcode/Pause Duration Register */
    vuint32_t R;
    struct {
      vuint32_t OPCODE:16;             /* Opcode Field In PAUSE Frames */
      vuint32_t PAUSE_DUR:16;          /* Pause Duration */
    } B;
  } OPD;

  union {                              /* Transmit Interrupt Coalescing Register */
    vuint32_t R;
    struct {
      vuint32_t ICEN:1;                /* Interrupt Coalescing Enable */
      vuint32_t ICCS:1;                /* Interrupt Coalescing Timer Clock Source Select */
      vuint32_t  :2;                   /* This field must be set to 0. */
      vuint32_t ICFT:8;                /* Interrupt coalescing frame count threshold */
      vuint32_t  :4;                   /* This field must be set to 0. */
      vuint32_t ICTT:16;               /* Interrupt coalescing timer threshold */
    } B;
  } TXIC[3];

  uint8_t ENET_reserved8[4];
  union {                              /* Receive Interrupt Coalescing Register */
    vuint32_t R;
    struct {
      vuint32_t ICEN:1;                /* Interrupt Coalescing Enable */
      vuint32_t ICCS:1;                /* Interrupt Coalescing Timer Clock Source Select */
      vuint32_t  :2;                   /* This field must be set to 0. */
      vuint32_t ICFT:8;                /* Interrupt coalescing frame count threshold */
      vuint32_t  :4;                   /* This field must be set to 0. */
      vuint32_t ICTT:16;               /* Interrupt coalescing timer threshold */
    } B;
  } RXIC[3];

  uint8_t ENET_reserved9[12];
  union {                              /* Descriptor Individual Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR1:32;
    } B;
  } IAUR;

  union {                              /* Descriptor Individual Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR2:32;
    } B;
  } IALR;

  union {                              /* Descriptor Group Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR1:32;
    } B;
  } GAUR;

  union {                              /* Descriptor Group Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR2:32;
    } B;
  } GALR;

  uint8_t ENET_reserved10[28];
  union {                              /* Transmit FIFO Watermark Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t STRFWD:1;              /* Store And Forward Enable */
      vuint32_t  :2;
      vuint32_t TFWR:6;                /* Transmit FIFO Write */
    } B;
  } TFWR;

  uint8_t ENET_reserved11[24];
  union {                              /* Receive Descriptor Ring 1 Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } RDSR1;

  union {                              /* Transmit Buffer Descriptor Ring 1 Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } TDSR1;

  union {                              /* Maximum Receive Buffer Size Register - Ring 1 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t R_BUF_SIZE:10;
      vuint32_t  :4;
    } B;
  } MRBR1;

  union {                              /* Receive Descriptor Ring 2 Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } RDSR2;

  union {                              /* Transmit Buffer Descriptor Ring 2 Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } TDSR2;

  union {                              /* Maximum Receive Buffer Size Register - Ring 2 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t R_BUF_SIZE:10;
      vuint32_t  :4;
    } B;
  } MRBR2;

  uint8_t ENET_reserved12[8];
  union {                              /* Receive Descriptor Ring 0 Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } RDSR;

  union {                              /* Transmit Buffer Descriptor Ring 0 Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:29;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } TDSR;

  union {                              /* Maximum Receive Buffer Size Register - Ring 0 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t R_BUF_SIZE:10;
      vuint32_t  :4;
    } B;
  } MRBR;

  uint8_t ENET_reserved13[4];
  union {                              /* Receive FIFO Section Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_SECTION_FULL:8;     /* Value Of Receive FIFO Section Full Threshold */
    } B;
  } RSFL;

  union {                              /* Receive FIFO Section Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t STAT_SECTION_EMPTY:5;  /* RX Status FIFO Section Empty Threshold */
      vuint32_t  :8;
      vuint32_t RX_SECTION_EMPTY:8;    /* Value Of The Receive FIFO Section Empty Threshold */
    } B;
  } RSEM;

  union {                              /* Receive FIFO Almost Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_ALMOST_EMPTY:8;     /* Value Of The Receive FIFO Almost Empty Threshold */
    } B;
  } RAEM;

  union {                              /* Receive FIFO Almost Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RX_ALMOST_FULL:8;      /* Value Of The Receive FIFO Almost Full Threshold */
    } B;
  } RAFL;

  union {                              /* Transmit FIFO Section Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_SECTION_EMPTY:8;    /* Value Of The Transmit FIFO Section Empty Threshold */
    } B;
  } TSEM;

  union {                              /* Transmit FIFO Almost Empty Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_ALMOST_EMPTY:8;     /* Value of Transmit FIFO Almost Empty Threshold */
    } B;
  } TAEM;

  union {                              /* Transmit FIFO Almost Full Threshold */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TX_ALMOST_FULL:8;      /* Value Of The Transmit FIFO Almost Full Threshold */
    } B;
  } TAFL;

  union {                              /* Transmit Inter-Packet Gap */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IPG:5;                 /* Transmit Inter-Packet Gap */
    } B;
  } TIPG;

  union {                              /* Frame Truncation Length */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t TRUNC_FL:14;           /* Frame Truncation Length */
    } B;
  } FTRL;

  uint8_t ENET_reserved14[12];
  union {                              /* Transmit Accelerator Function Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t PROCHK:1;
      vuint32_t IPCHK:1;
      vuint32_t  :2;
      vuint32_t SHIFT16:1;             /* TX FIFO Shift-16 */
    } B;
  } TACC;

  union {                              /* Receive Accelerator Function Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SHIFT16:1;             /* RX FIFO Shift-16 */
      vuint32_t LINEDIS:1;             /* Enable Discard Of Frames With MAC Layer Errors */
      vuint32_t  :3;
      vuint32_t PRODIS:1;              /* Enable Discard Of Frames With Wrong Protocol Checksum */
      vuint32_t IPDIS:1;               /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
      vuint32_t PADREM:1;              /* Enable Padding Removal For Short IP Frames */
    } B;
  } RACC;

  union {                              /* Receive Classification Match Register for Class n */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t MATCHEN:1;             /* Match Enable */
      vuint32_t  :1;
      vuint32_t CMP3:3;                /* Compare 3 */
      vuint32_t  :1;
      vuint32_t CMP2:3;                /* Compare 2 */
      vuint32_t  :1;
      vuint32_t CMP1:3;                /* Compare 1 */
      vuint32_t  :1;
      vuint32_t CMP0:3;                /* Compare 0 */
    } B;
  } RCMR[2];

  uint8_t ENET_reserved15[8];
  union {                              /* DMA Class Based Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t  :6;
      vuint32_t CALC_NOIPG:1;          /* Calculate no IPG */
      vuint32_t DMA_CLASS_EN:1;        /* DMA class enable */
      vuint32_t IDLE_SLOPE:16;         /* Idle slope */
    } B;
  } DMACFG[2];
  
  union {                              /* Receive Descriptor Active Register - Ring 1 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;                /* Receive Descriptor Active */
      vuint32_t  :24;
    } B;
  } RDAR1;

  union {                              /* Transmit Descriptor Active Register - Ring 1 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;                /* Transmit Descriptor Active */
      vuint32_t  :24;
    } B;
  } TDAR1;

  union {                              /* Receive Descriptor Active Register - Ring 2 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;                /* Receive Descriptor Active */
      vuint32_t  :24;
    } B;
  } RDAR2;

  union {                              /* Transmit Descriptor Active Register - Ring 2 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;                /* Transmit Descriptor Active */
      vuint32_t  :24;
    } B;
  } TDAR2;

  union {                              /* QOS Scheme */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t RX_FLUSH2:1;           /* RX Flush Ring 2 */
      vuint32_t RX_FLUSH1:1;           /* RX Flush Ring 1 */
      vuint32_t RX_FLUSH0:1;           /* RX Flush Ring 0 */
      vuint32_t TX_SCHEME:3;           /* TX scheme configuration */
    } B;
  } QOS;

  uint8_t ENET_reserved16[16];
  union {                              /* Tx Packet Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_PACKETS;

  union {                              /* Tx Broadcast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Broadcast packets */
    } B;
  } RMON_T_BC_PKT;

  union {                              /* Tx Multicast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Multicast packets */
    } B;
  } RMON_T_MC_PKT;

  union {                              /* Tx Packets with CRC/Align Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packets with CRC/align error */
    } B;
  } RMON_T_CRC_ALIGN;

  union {                              /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_UNDERSIZE;

  union {                              /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_OVERSIZE;

  union {                              /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_FRAG;

  union {                              /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_JAB;

  union {                              /* Tx Collision Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_COL;

  union {                              /* Tx 64-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_P64;

  union {                              /* Tx 65- to 127-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_P65TO127;

  union {                              /* Tx 128- to 255-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_P128TO255;

  union {                              /* Tx 256- to 511-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_P256TO511;

  union {                              /* Tx 512- to 1023-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_P512TO1023;

  union {                              /* Tx 1024- to 2047-byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_P1024TO2047;

  union {                              /* Tx Packets Greater Than 2048 Bytes Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPKTS:16;             /* Packet count */
    } B;
  } RMON_T_P_GTE2048;

  union {                              /* Tx Octets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t TXOCTS:32;             /* Octet count */
    } B;
  } RMON_T_OCTETS;

  uint8_t ENET_reserved17[4];
  union {                              /* Frames Transmitted OK Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_FRAME_OK;

  union {                              /* Frames Transmitted with Single Collision Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_1COL;

  union {                              /* Frames Transmitted with Multiple Collisions Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_MCOL;

  union {                              /* Frames Transmitted after Deferral Delay Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_DEF;

  union {                              /* Frames Transmitted with Late Collision Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_LCOL;

  union {                              /* Frames Transmitted with Excessive Collisions Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_EXCOL;

  union {                              /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_MACERR;

  union {                              /* Frames Transmitted with Carrier Sense Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_CSERR;

  uint8_t ENET_reserved18[4];
  union {                              /* Flow Control Pause Frames Transmitted Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_T_FDXFC;

  union {                              /* Octet Count for Frames Transmitted w/o Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Octet count */
    } B;
  } IEEE_T_OCTETS_OK;

  uint8_t ENET_reserved19[12];
  union {                              /* Rx Packet Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_PACKETS;

  union {                              /* Rx Broadcast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_BC_PKT;

  union {                              /* Rx Multicast Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_MC_PKT;

  union {                              /* Rx Packets with CRC/Align Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_CRC_ALIGN;

  union {                              /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_UNDERSIZE;

  union {                              /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_OVERSIZE;

  union {                              /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_FRAG;

  union {                              /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_JAB;

  uint8_t ENET_reserved20[4];
  union {                              /* Rx 64-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_P64;

  union {                              /* Rx 65- to 127-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_P65TO127;

  union {                              /* Rx 128- to 255-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_P128TO255;

  union {                              /* Rx 256- to 511-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_P256TO511;

  union {                              /* Rx 512- to 1023-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_P512TO1023;

  union {                              /* Rx 1024- to 2047-Byte Packets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_P1024TO2047;

  union {                              /* Rx Packets Greater than 2048 Bytes Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Packet count */
    } B;
  } RMON_R_P_GTE2048;

  union {                              /* Rx Octets Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Octet count */
    } B;
  } RMON_R_OCTETS;

  union {                              /* Frames not Counted Correctly Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_R_DROP;

  union {                              /* Frames Received OK Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_R_FRAME_OK;

  union {                              /* Frames Received with CRC Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_R_CRC;

  union {                              /* Frames Received with Alignment Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Frame count */
    } B;
  } IEEE_R_ALIGN;

  union {                              /* Receive FIFO Overflow Count Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Count */
    } B;
  } IEEE_R_MACERR;

  union {                              /* Flow Control Pause Frames Received Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t COUNT:16;              /* Pause frame count */
    } B;
  } IEEE_R_FDXFC;

  union {                              /* Octet Count for Frames Received without Error Statistic Register */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Octet count */
    } B;
  } IEEE_R_OCTETS_OK;

  uint8_t ENET_reserved21[284];
  union {                              /* Adjustable Timer Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t SLAVE:1;               /* Enable Timer Slave Mode */
      vuint32_t  :1;
      vuint32_t CAPTURE:1;             /* Capture Timer Value */
      vuint32_t  :1;
      vuint32_t RESTART:1;             /* Reset Timer */
      vuint32_t  :1;
      vuint32_t PINPER:1;
      vuint32_t  :2;
      vuint32_t PEREN:1;               /* Enable Periodical Event */
      vuint32_t OFFRST:1;              /* Reset Timer On Offset Event */
      vuint32_t OFFEN:1;               /* Enable One-Shot Offset Event */
      vuint32_t  :1;
      vuint32_t EN:1;                  /* Enable Timer */
    } B;
  } ATCR;

  union {                              /* Timer Value Register */
    vuint32_t R;
    struct {
      vuint32_t ATIME:32;
    } B;
  } ATVR;

  union {                              /* Timer Offset Register */
    vuint32_t R;
    struct {
      vuint32_t OFFSET:32;
    } B;
  } ATOFF;

  union {                              /* Timer Period Register */
    vuint32_t R;
    struct {
      vuint32_t PERIOD:32;
    } B;
  } ATPER;

  union {                              /* Timer Correction Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t COR:31;                /* Correction Counter Wrap-Around Value */
    } B;
  } ATCOR;

  union {                              /* Time-Stamping Clock Period Register */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t INC_CORR:7;            /* Correction Increment Value */
      vuint32_t  :1;
      vuint32_t INC:7;                 /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
    } B;
  } ATINC;

  union {                              /* Timestamp of Last Transmitted Frame */
    vuint32_t R;
    struct {
      vuint32_t TIMESTAMP:32;
    } B;
  } ATSTMP;

  uint8_t ENET_reserved22[356];
  union {                              /* Pattern Match Data Register */
    vuint32_t R;
    struct {
      vuint32_t MATCHDATA:32;          /* Match Data */
    } B;
  } MDATA;

  union {                              /* Match Entry Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MATCHMASK:32;          /* Match Mask */
    } B;
  } MMASK;

  union {                              /* Match Entry Rules Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t AF:1;                  /* Accept Frame */
      vuint32_t RF:1;                  /* Reject Frame */
      vuint32_t IM:1;                  /* Invert Match */
      vuint32_t  :5;
      vuint32_t OK_INDEX:8;
      vuint32_t  :8;
      vuint32_t FRMOFF:6;              /* Frame Offset */
      vuint32_t  :2;
    } B;
  } MCONFIG;

  union {                              /* Match Entry Read/Write Command Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t RD:1;                  /* Entry Read Command */
      vuint32_t WR:1;                  /* Entry write command */
      vuint32_t ENTRYADD:8;            /* Entry Address */
    } B;
  } MENTRYRW;

  union {                              /* Receive Parser Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t MAXINDEX:8;            /* Maximum Index */
      vuint32_t  :3;
      vuint32_t PRSRSCLR:1;            /* Clear Parser Statistics Counter */
      vuint32_t  :2;
      vuint32_t INVBYTORD:1;           /* Inverse Frame Byte Order */
      vuint32_t ENPARSER:1;            /* Enable Receive Parser */
    } B;
  } RXPCTL;

  union {                              /* Maximum Frame Offset */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t MXFRMOFF:6;            /* Max. Frame Offset */
    } B;
  } MAXFRMOFF;

  union {                              /* Receive Parser Status */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t RXPRSDN:1;             /* Receive Parser Done */
      vuint32_t  :2;
      vuint32_t INVMAXIDX:1;           /* Invalid Value of MAXINDEX */
      vuint32_t PRSENDERR:1;           /* Parser End Error */
      vuint32_t FMOFFERR:1;            /* Maximum Frame Offset Error */
      vuint32_t NOMTCERR:1;            /* No Match Error */
      vuint32_t TBLDPTERR:1;           /* Table Depth Error */
      vuint32_t MXINDERR:1;            /* Maximum Index Error */
    } B;
  } RXPARST;

  uint8_t ENET_reserved23[4];
  union {                              /* Parser Discard Count */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PARSDSCD;

  union {                              /* Parser Accept Count 0 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSACPT0;

  union {                              /* Parser Reject Count 0 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSRJCT0;

  union {                              /* Parser Accept Count 1 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSACPT1;

  union {                              /* Parser Reject Count 1 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSRJCT1;

  union {                              /* Parser Accept Count 2 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSACPT2;

  union {                              /* Parser Reject Count 2 */
    vuint32_t R;
    struct {
      vuint32_t COUNT:32;              /* Count */
    } B;
  } PRSRJCT2;

  uint8_t ENET_reserved24[72];
  union {                              /* Timer Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TF3:1;                 /* Copy Of Timer Flag For Channel 3 */
      vuint32_t TF2:1;                 /* Copy Of Timer Flag For Channel 2 */
      vuint32_t TF1:1;                 /* Copy Of Timer Flag For Channel 1 */
      vuint32_t TF0:1;                 /* Copy Of Timer Flag For Channel 0 */
    } B;
  } TGSR;

  struct {
    union {                            /* Timer Control Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :24;
        vuint32_t TF:1;                /* Timer Flag */
        vuint32_t TIE:1;               /* Timer Interrupt Enable */
        vuint32_t TMODE:4;             /* Timer Mode */
        vuint32_t  :1;
        vuint32_t TDRE:1;              /* Timer DMA Request Enable */
      } B;
    } TCSR;
    union {                            /* Timer Compare Capture Register */
      vuint32_t R;
      struct {
        vuint32_t TCC:32;              /* Timer Capture Compare */
      } B;
    } TCCR;
  } TIMER[4];
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

struct FCCU_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t FILTER_BYPASS:1;
      vuint32_t FILTER_WIDTH:2;
      vuint32_t  :19;
      vuint32_t DEBUG:1;
      vuint32_t  :1;
      vuint32_t OPS:2;
      vuint32_t  :1;
      vuint32_t OPR:5;
    } B;
  } CTRL;

  union {                              /* CTRL Key Register */
    vuint32_t R;
    struct {
      vuint32_t CTRLK:32;
    } B;
  } CTRLK;

  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t TGL:7;                 /* EOUT Toggling Time */
      vuint32_t FCCU_SET_AFTER_RESET:1;
      vuint32_t FCCU_SET_CLEAR:2;
      vuint32_t  :2;
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t FOME:2;                /* Fault Output Mode Extension */
      vuint32_t OD:1;
      vuint32_t CM:1;
      vuint32_t SM:1;
      vuint32_t PS:1;
      vuint32_t FOM:3;
      vuint32_t  :6;
    } B;
  } CFG;

  uint8_t FCCU_reserved0[16];
  union {                              /* NCF Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFC31:1;
      vuint32_t NCFC30:1;
      vuint32_t NCFC29:1;
      vuint32_t NCFC28:1;
      vuint32_t NCFC27:1;
      vuint32_t NCFC26:1;
      vuint32_t NCFC25:1;
      vuint32_t NCFC24:1;
      vuint32_t NCFC23:1;
      vuint32_t NCFC22:1;
      vuint32_t NCFC21:1;
      vuint32_t NCFC20:1;
      vuint32_t NCFC19:1;
      vuint32_t NCFC18:1;
      vuint32_t NCFC17:1;
      vuint32_t NCFC16:1;
      vuint32_t NCFC15:1;
      vuint32_t NCFC14:1;
      vuint32_t NCFC13:1;
      vuint32_t NCFC12:1;
      vuint32_t NCFC11:1;
      vuint32_t NCFC10:1;
      vuint32_t NCFC9:1;
      vuint32_t NCFC8:1;
      vuint32_t NCFC7:1;
      vuint32_t NCFC6:1;
      vuint32_t NCFC5:1;
      vuint32_t NCFC4:1;
      vuint32_t NCFC3:1;
      vuint32_t NCFC2:1;
      vuint32_t NCFC1:1;
      vuint32_t NCFC0:1;
    } B;
  } NCF_CFG[3];

  uint8_t FCCU_reserved1[36];
  union {                              /* NCFS Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NCFSC31:1;
      vuint32_t NCFSC30:1;
      vuint32_t NCFSC29:1;
      vuint32_t NCFSC28:1;
      vuint32_t NCFSC27:1;
      vuint32_t NCFSC26:1;
      vuint32_t NCFSC25:1;
      vuint32_t NCFSC24:1;
      vuint32_t NCFSC23:1;
      vuint32_t NCFSC22:1;
      vuint32_t NCFSC21:1;
      vuint32_t NCFSC20:1;
      vuint32_t NCFSC19:1;
      vuint32_t NCFSC18:1;
      vuint32_t NCFSC17:1;
      vuint32_t NCFSC16:1;
      vuint32_t NCFSC15:1;
      vuint32_t NCFSC14:1;
      vuint32_t NCFSC13:1;
      vuint32_t NCFSC12:1;
      vuint32_t NCFSC11:1;
      vuint32_t NCFSC10:1;
      vuint32_t NCFSC9:1;
      vuint32_t NCFSC8:1;
      vuint32_t NCFSC7:1;
      vuint32_t NCFSC6:1;
      vuint32_t NCFSC5:1;
      vuint32_t NCFSC4:1;
      vuint32_t NCFSC3:1;
      vuint32_t NCFSC2:1;
      vuint32_t NCFSC1:1;
      vuint32_t NCFSC0:1;
    } B;
  } NCFS_CFG[5];

  uint8_t FCCU_reserved2[32];
  union {                              /* NCF Status Register */
    vuint32_t R;
    struct {
      vuint32_t NCFS31:1;
      vuint32_t NCFS30:1;
      vuint32_t NCFS29:1;
      vuint32_t NCFS28:1;
      vuint32_t NCFS27:1;
      vuint32_t NCFS26:1;
      vuint32_t NCFS25:1;
      vuint32_t NCFS24:1;
      vuint32_t NCFS23:1;
      vuint32_t NCFS22:1;
      vuint32_t NCFS21:1;
      vuint32_t NCFS20:1;
      vuint32_t NCFS19:1;
      vuint32_t NCFS18:1;
      vuint32_t NCFS17:1;
      vuint32_t NCFS16:1;
      vuint32_t NCFS15:1;
      vuint32_t NCFS14:1;
      vuint32_t NCFS13:1;
      vuint32_t NCFS12:1;
      vuint32_t NCFS11:1;
      vuint32_t NCFS10:1;
      vuint32_t NCFS9:1;
      vuint32_t NCFS8:1;
      vuint32_t NCFS7:1;
      vuint32_t NCFS6:1;
      vuint32_t NCFS5:1;
      vuint32_t NCFS4:1;
      vuint32_t NCFS3:1;
      vuint32_t NCFS2:1;
      vuint32_t NCFS1:1;
      vuint32_t NCFS0:1;
    } B;
  } NCF_S[3];

  uint8_t FCCU_reserved3[4];
  union {                              /* NCF Key Register */
    vuint32_t R;
    struct {
      vuint32_t NCFK:32;
    } B;
  } NCFK;

  union {                              /* NCF Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFE31:1;
      vuint32_t NCFE30:1;
      vuint32_t NCFE29:1;
      vuint32_t NCFE28:1;
      vuint32_t NCFE27:1;
      vuint32_t NCFE26:1;
      vuint32_t NCFE25:1;
      vuint32_t NCFE24:1;
      vuint32_t NCFE23:1;
      vuint32_t NCFE22:1;
      vuint32_t NCFE21:1;
      vuint32_t NCFE20:1;
      vuint32_t NCFE19:1;
      vuint32_t NCFE18:1;
      vuint32_t NCFE17:1;
      vuint32_t NCFE16:1;
      vuint32_t NCFE15:1;
      vuint32_t NCFE14:1;
      vuint32_t NCFE13:1;
      vuint32_t NCFE12:1;
      vuint32_t NCFE11:1;
      vuint32_t NCFE10:1;
      vuint32_t NCFE9:1;
      vuint32_t NCFE8:1;
      vuint32_t NCFE7:1;
      vuint32_t NCFE6:1;
      vuint32_t NCFE5:1;
      vuint32_t NCFE4:1;
      vuint32_t NCFE3:1;
      vuint32_t NCFE2:1;
      vuint32_t NCFE1:1;
      vuint32_t NCFE0:1;
    } B;
  } NCF_E[3];

  uint8_t FCCU_reserved4[4];
  union {                              /* NCF Time-out Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NCFTOE31:1;
      vuint32_t NCFTOE30:1;
      vuint32_t NCFTOE29:1;
      vuint32_t NCFTOE28:1;
      vuint32_t NCFTOE27:1;
      vuint32_t NCFTOE26:1;
      vuint32_t NCFTOE25:1;
      vuint32_t NCFTOE24:1;
      vuint32_t NCFTOE23:1;
      vuint32_t NCFTOE22:1;
      vuint32_t NCFTOE21:1;
      vuint32_t NCFTOE20:1;
      vuint32_t NCFTOE19:1;
      vuint32_t NCFTOE18:1;
      vuint32_t NCFTOE17:1;
      vuint32_t NCFTOE16:1;
      vuint32_t NCFTOE15:1;
      vuint32_t NCFTOE14:1;
      vuint32_t NCFTOE13:1;
      vuint32_t NCFTOE12:1;
      vuint32_t NCFTOE11:1;
      vuint32_t NCFTOE10:1;
      vuint32_t NCFTOE9:1;
      vuint32_t NCFTOE8:1;
      vuint32_t NCFTOE7:1;
      vuint32_t NCFTOE6:1;
      vuint32_t NCFTOE5:1;
      vuint32_t NCFTOE4:1;
      vuint32_t NCFTOE3:1;
      vuint32_t NCFTOE2:1;
      vuint32_t NCFTOE1:1;
      vuint32_t NCFTOE0:1;
    } B;
  } NCF_TOE[3];

  uint8_t FCCU_reserved5[4];
  union {                              /* NCF Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t TO:32;
    } B;
  } NCF_TO;

  union {                              /* CFG Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TO:3;
    } B;
  } CFG_TO;

  union {                              /* IO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t EIN1:1;
      vuint32_t EIN0:1;
      vuint32_t  :2;
      vuint32_t EOUTX:2;
    } B;
  } EINOUT;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t PhysicErrorPin:2;
      vuint32_t ESTAT:1;
      vuint32_t STATUS:3;
    } B;
  } STAT;

  union {                              /* NA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t NAFS:8;
    } B;
  } N2AF_STATUS;

  union {                              /* AF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t AF_SRC:2;
      vuint32_t AFFS:8;
    } B;
  } A2FF_STATUS;

  union {                              /* NF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t NF_SRC:2;
      vuint32_t NFFS:8;
    } B;
  } N2FF_STATUS;

  union {                              /* FA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t FAFS:9;
    } B;
  } F2A_STATUS;

  uint8_t FCCU_reserved6[8];
  union {                              /* NCF Fake Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t FNCFC:7;
    } B;
  } NCFF;

  union {                              /* IRQ Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t DMA_REQ:1;
      vuint32_t IRQ_EOUT:1;
      vuint32_t NMI_STAT:1;
      vuint32_t ALRM_STAT:1;
      vuint32_t CFG_TO_STAT:1;
    } B;
  } IRQ_STAT;

  union {                              /* IRQ Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IRQ_EOUT_EN:1;
      vuint32_t  :2;
      vuint32_t CFG_TO_IEN:1;
    } B;
  } IRQ_EN;

  union {                              /* XTMR Register */
    vuint32_t R;
    struct {
      vuint32_t XTMR:32;
    } B;
  } XTMR;

  union {                              /* MCS Register */
    vuint32_t R;
    struct {
      vuint32_t VL3:1;
      vuint32_t FS3:1;
      vuint32_t  :2;
      vuint32_t MCS3:4;
      vuint32_t VL2:1;
      vuint32_t FS2:1;
      vuint32_t  :2;
      vuint32_t MCS2:4;
      vuint32_t VL1:1;
      vuint32_t FS1:1;
      vuint32_t  :2;
      vuint32_t MCS1:4;
      vuint32_t VL0:1;
      vuint32_t FS0:1;
      vuint32_t  :2;
      vuint32_t MCS0:4;
    } B;
  } MCS;

  union {                              /* Transient Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t TRANSKEY:9;
    } B;
  } TRANS_LOCK;

  union {                              /* Permanent Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t PERMNTKEY:9;
    } B;
  } PERMNT_LOCK;

  union {                              /* Delta T Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t T_TRG:14;              /* IRQ DMA trigger time */
      vuint32_t  :2;
      vuint32_t DELTA_T:14;
    } B;
  } DELTA_T;

  union {                              /* IRQ Alarm Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IRQEN31:1;
      vuint32_t IRQEN30:1;
      vuint32_t IRQEN29:1;
      vuint32_t IRQEN28:1;
      vuint32_t IRQEN27:1;
      vuint32_t IRQEN26:1;
      vuint32_t IRQEN25:1;
      vuint32_t IRQEN24:1;
      vuint32_t IRQEN23:1;
      vuint32_t IRQEN22:1;
      vuint32_t IRQEN21:1;
      vuint32_t IRQEN20:1;
      vuint32_t IRQEN19:1;
      vuint32_t IRQEN18:1;
      vuint32_t IRQEN17:1;
      vuint32_t IRQEN16:1;
      vuint32_t IRQEN15:1;
      vuint32_t IRQEN14:1;
      vuint32_t IRQEN13:1;
      vuint32_t IRQEN12:1;
      vuint32_t IRQEN11:1;
      vuint32_t IRQEN10:1;
      vuint32_t IRQEN9:1;
      vuint32_t IRQEN8:1;
      vuint32_t IRQEN7:1;
      vuint32_t IRQEN6:1;
      vuint32_t IRQEN5:1;
      vuint32_t IRQEN4:1;
      vuint32_t IRQEN3:1;
      vuint32_t IRQEN2:1;
      vuint32_t IRQEN1:1;
      vuint32_t IRQEN0:1;
    } B;
  } IRQ_ALARM_EN[3];

  uint8_t FCCU_reserved7[4];
  union {                              /* NMI Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NMIEN31:1;
      vuint32_t NMIEN30:1;
      vuint32_t NMIEN29:1;
      vuint32_t NMIEN28:1;
      vuint32_t NMIEN27:1;
      vuint32_t NMIEN26:1;
      vuint32_t NMIEN25:1;
      vuint32_t NMIEN24:1;
      vuint32_t NMIEN23:1;
      vuint32_t NMIEN22:1;
      vuint32_t NMIEN21:1;
      vuint32_t NMIEN20:1;
      vuint32_t NMIEN19:1;
      vuint32_t NMIEN18:1;
      vuint32_t NMIEN17:1;
      vuint32_t NMIEN16:1;
      vuint32_t NMIEN15:1;
      vuint32_t NMIEN14:1;
      vuint32_t NMIEN13:1;
      vuint32_t NMIEN12:1;
      vuint32_t NMIEN11:1;
      vuint32_t NMIEN10:1;
      vuint32_t NMIEN9:1;
      vuint32_t NMIEN8:1;
      vuint32_t NMIEN7:1;
      vuint32_t NMIEN6:1;
      vuint32_t NMIEN5:1;
      vuint32_t NMIEN4:1;
      vuint32_t NMIEN3:1;
      vuint32_t NMIEN2:1;
      vuint32_t NMIEN1:1;
      vuint32_t NMIEN0:1;
    } B;
  } NMI_EN[3];

  uint8_t FCCU_reserved8[4];
  union {                              /* EOUT Signaling Enable Register */
    vuint32_t R;
    struct {
      vuint32_t EOUTEN31:1;
      vuint32_t EOUTEN30:1;
      vuint32_t EOUTEN29:1;
      vuint32_t EOUTEN28:1;
      vuint32_t EOUTEN27:1;
      vuint32_t EOUTEN26:1;
      vuint32_t EOUTEN25:1;
      vuint32_t EOUTEN24:1;
      vuint32_t EOUTEN23:1;
      vuint32_t EOUTEN22:1;
      vuint32_t EOUTEN21:1;
      vuint32_t EOUTEN20:1;
      vuint32_t EOUTEN19:1;
      vuint32_t EOUTEN18:1;
      vuint32_t EOUTEN17:1;
      vuint32_t EOUTEN16:1;
      vuint32_t EOUTEN15:1;
      vuint32_t EOUTEN14:1;
      vuint32_t EOUTEN13:1;
      vuint32_t EOUTEN12:1;
      vuint32_t EOUTEN11:1;
      vuint32_t EOUTEN10:1;
      vuint32_t EOUTEN9:1;
      vuint32_t EOUTEN8:1;
      vuint32_t EOUTEN7:1;
      vuint32_t EOUTEN6:1;
      vuint32_t EOUTEN5:1;
      vuint32_t EOUTEN4:1;
      vuint32_t EOUTEN3:1;
      vuint32_t EOUTEN2:1;
      vuint32_t EOUTEN1:1;
      vuint32_t EOUTEN0:1;
    } B;
  } EOUT_SIG_EN[3];
};


/* ============================================================================
   =============================== Module: FIRC ===============================
   ============================================================================ */

struct FIRC_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t FIRCTRIM:6;
      vuint32_t  :3;
      vuint32_t FIRCDIV:5;             /* The FIRC Divider bits select the clock divider factor. */
      vuint32_t  :3;
      vuint32_t FIRCS:1;               /* Describes the FIRC clock status. */
      vuint32_t  :3;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

struct FR_tag {
  union {                              /* Module Version Register */
    vuint16_t R;
    struct {
      vuint16_t CHIVER:8;
      vuint16_t PEVER:8;
    } B;
  } MVR;

  union {                              /* Module Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MEN:1;
      vuint16_t SBFF:1;                /* System Bus Failure Freeze */
      vuint16_t SCM:1;
      vuint16_t CHB:1;
      vuint16_t CHA:1;
      vuint16_t SFFE:1;
      vuint16_t ECCE:1;
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t FUM:1;
      vuint16_t FAM:1;
      vuint16_t  :1;
      vuint16_t CLKSEL:1;
      vuint16_t BITRATE:3;
      vuint16_t  :1;
    } B;
  } MCR;

  union {                              /* System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;               /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
    } B;
  } SYMBADHR;

  union {                              /* System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } SYMBADLR;

  union {                              /* Strobe Signal Control Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :3;
      vuint16_t SEL:4;
      vuint16_t  :3;
      vuint16_t ENB:1;
      vuint16_t  :2;
      vuint16_t STBPSEL:2;
    } B;
  } STBSCR;

  uint8_t FR_reserved0[2];
  union {                              /* Message Buffer Data Size Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t MBSEG2DS:7;
      vuint16_t  :1;
      vuint16_t MBSEG1DS:7;
    } B;
  } MBDSR;

  union {                              /* Message Buffer Segment Size and Utilization Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t LAST_MB_SEG1:7;
      vuint16_t  :1;
      vuint16_t LAST_MB_UTIL:7;
    } B;
  } MBSSUTR;

  union {                              /* PE DRAM Access Register */
    vuint16_t R;
    struct {
      vuint16_t INST:4;
      vuint16_t ADDR:11;
      vuint16_t DAD:1;
    } B;
  } PEDRAR;

  union {                              /* PE DRAM Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } PEDRDR;

  union {                              /* Protocol Operation Control Register */
    vuint16_t R;
    struct {
      vuint16_t WME:1;
      vuint16_t  :3;
      vuint16_t EOC_AP:2;
      vuint16_t ERC_AP:2;
      vuint16_t BSY_WMC:1;
      vuint16_t  :3;
      vuint16_t POCCMD:4;
    } B;
  } POCR;

  union {                              /* Global Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
      vuint16_t MIE:1;
      vuint16_t PRIE:1;
      vuint16_t CHIE:1;
      vuint16_t WUPIE:1;
      vuint16_t FAFBIE:1;
      vuint16_t FAFAIE:1;
      vuint16_t RBIE:1;
      vuint16_t TBIE:1;
    } B;
  } GIFER;

  union {                              /* Protocol Interrupt Flag Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IF:1;
      vuint16_t INTL_IF:1;
      vuint16_t ILCF_IF:1;
      vuint16_t CSA_IF:1;
      vuint16_t MRC_IF:1;
      vuint16_t MOC_IF:1;
      vuint16_t CCL_IF:1;
      vuint16_t MXS_IF:1;
      vuint16_t MTX_IF:1;
      vuint16_t LTXB_IF:1;
      vuint16_t LTXA_IF:1;
      vuint16_t TBVB_IF:1;
      vuint16_t TBVA_IF:1;
      vuint16_t TI2_IF:1;
      vuint16_t TI1_IF:1;
      vuint16_t CYS_IF:1;
    } B;
  } PIFR0;

  union {                              /* Protocol Interrupt Flag Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IF:1;
      vuint16_t IPC_IF:1;
      vuint16_t PECF_IF:1;
      vuint16_t PSC_IF:1;
      vuint16_t SSI3_IF:1;
      vuint16_t SSI2_IF:1;
      vuint16_t SSI1_IF:1;
      vuint16_t SSI0_IF:1;
      vuint16_t  :2;
      vuint16_t EVT_IF:1;
      vuint16_t ODT_IF:1;
      vuint16_t  :4;
    } B;
  } PIFR1;

  union {                              /* Protocol Interrupt Enable Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IE:1;
      vuint16_t INTL_IE:1;
      vuint16_t ILCF_IE:1;
      vuint16_t CSA_IE:1;
      vuint16_t MRC_IE:1;
      vuint16_t MOC_IE:1;
      vuint16_t CCL_IE:1;
      vuint16_t MXS_IE:1;
      vuint16_t MTX_IE:1;
      vuint16_t LTXB_IE:1;
      vuint16_t LTXA_IE:1;
      vuint16_t TBVB_IE:1;
      vuint16_t TBVA_IE:1;
      vuint16_t TI2_IE:1;
      vuint16_t TI1_IE:1;
      vuint16_t CYS_IE:1;
    } B;
  } PIER0;

  union {                              /* Protocol Interrupt Enable Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IE:1;
      vuint16_t IPC_IE:1;
      vuint16_t PECF_IE:1;
      vuint16_t PSC_IE:1;
      vuint16_t SSI3_IE:1;
      vuint16_t SSI2_IE:1;
      vuint16_t SSI1_IE:1;
      vuint16_t SSI0_IE:1;
      vuint16_t  :2;
      vuint16_t EVT_IE:1;
      vuint16_t ODT_IE:1;
      vuint16_t  :4;
    } B;
  } PIER1;

  union {                              /* CHI Error Flag Register */
    vuint16_t R;
    struct {
      vuint16_t FRLB_EF:1;
      vuint16_t FRLA_EF:1;
      vuint16_t PCMI_EF:1;
      vuint16_t FOVB_EF:1;
      vuint16_t FOVA_EF:1;
      vuint16_t MBS_EF:1;
      vuint16_t MBU_EF:1;
      vuint16_t LCK_EF:1;
      vuint16_t  :1;
      vuint16_t SBCF_EF:1;
      vuint16_t FID_EF:1;
      vuint16_t DPL_EF:1;
      vuint16_t SPL_EF:1;
      vuint16_t NML_EF:1;
      vuint16_t NMF_EF:1;
      vuint16_t ILSA_EF:1;
    } B;
  } CHIERFR;

  union {                              /* Message Buffer Interrupt Vector Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t TBIVEC:7;
      vuint16_t  :1;
      vuint16_t RBIVEC:7;
    } B;
  } MBIVEC;

  union {                              /* Channel A Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHAERSCNT:16;
    } B;
  } CASERCR;

  union {                              /* Channel B Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHBERSCNT:16;
    } B;
  } CBSERCR;

  union {                              /* Protocol Status Register 0 */
    vuint16_t R;
    struct {
      vuint16_t ERRMODE:2;
      vuint16_t SLOTMODE:2;
      vuint16_t  :1;
      vuint16_t PROTSTATE:3;
      vuint16_t STARTUPSTATE:4;
      vuint16_t  :1;
      vuint16_t WAKEUPSTATUS:3;
    } B;
  } PSR0;

  union {                              /* Protocol Status Register 1 */
    vuint16_t R;
    struct {
      vuint16_t CSAA:1;
      vuint16_t CSP:1;
      vuint16_t  :1;
      vuint16_t REMCSAT:5;
      vuint16_t CPN:1;
      vuint16_t HHR:1;
      vuint16_t FRZ:1;
      vuint16_t APTAC:5;
    } B;
  } PSR1;

  union {                              /* Protocol Status Register 2 */
    vuint16_t R;
    struct {
      vuint16_t NBVB:1;
      vuint16_t NSEB:1;
      vuint16_t STCB:1;
      vuint16_t SBVB:1;
      vuint16_t SSEB:1;
      vuint16_t MTB:1;
      vuint16_t NBVA:1;
      vuint16_t NSEA:1;
      vuint16_t STCA:1;
      vuint16_t SBVA:1;
      vuint16_t SSEA:1;
      vuint16_t MTA:1;
      vuint16_t CKCORFCNT:4;
    } B;
  } PSR2;

  union {                              /* Protocol Status Register 3 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t WUB:1;
      vuint16_t ABVB:1;
      vuint16_t AACB:1;
      vuint16_t ACEB:1;
      vuint16_t ASEB:1;
      vuint16_t AVFB:1;
      vuint16_t  :2;
      vuint16_t WUA:1;
      vuint16_t ABVA:1;
      vuint16_t AACA:1;
      vuint16_t ACEA:1;
      vuint16_t ASEA:1;
      vuint16_t AVFA:1;
    } B;
  } PSR3;

  union {                              /* Macrotick Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t MTCT:14;
    } B;
  } MTCTR;

  union {                              /* Cycle Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :10;
      vuint16_t CYCCNT:6;
    } B;
  } CYCTR;

  union {                              /* Slot Counter Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTA:11;
    } B;
  } SLTCTAR;

  union {                              /* Slot Counter Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTB:11;
    } B;
  } SLTCTBR;

  union {                              /* Rate Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t RATECORR:16;
    } B;
  } RTCORVR;

  union {                              /* Offset Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t OFFSETCORR:16;
    } B;
  } OFCORVR;

  union {                              /* Combined Interrupt Flag Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
    } B;
  } CIFR;

  union {                              /* System Memory Access Time-Out Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t TIMEOUT:8;
    } B;
  } SYMATOR;

  union {                              /* Sync Frame Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SFEVB:4;
      vuint16_t SFEVA:4;
      vuint16_t SFODB:4;
      vuint16_t SFODA:4;
    } B;
  } SFCNTR;

  union {                              /* Sync Frame Table Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SFT_OFFSET:15;
      vuint16_t  :1;
    } B;
  } SFTOR;

  union {                              /* Sync Frame Table Configuration, Control, Status Register */
    vuint16_t R;
    struct {
      vuint16_t ELKT:1;
      vuint16_t OLKT:1;
      vuint16_t CYCNUM:6;
      vuint16_t ELKS:1;
      vuint16_t OLKS:1;
      vuint16_t EVAL:1;
      vuint16_t OVAL:1;
      vuint16_t  :1;
      vuint16_t OPT:1;
      vuint16_t SDVEN:1;
      vuint16_t SIDEN:1;
    } B;
  } SFTCCSR;

  union {                              /* Sync Frame ID Rejection Filter Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SYNFRID:10;
    } B;
  } SFIDRFR;

  union {                              /* Sync Frame ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FVAL:10;
    } B;
  } SFIDAFVR;

  union {                              /* Sync Frame ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FMSK:10;
    } B;
  } SFIDAFMR;

  union {                              /* Network Management Vector Register */
    vuint16_t R;
    struct {
      vuint16_t NMVP:16;
    } B;
  } NMVR[6];

  union {                              /* Network Management Vector Length Register */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t NMVL:4;
    } B;
  } NMVLR;

  union {                              /* Timer Configuration and Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T2_CFG:1;
      vuint16_t T2_REP:1;
      vuint16_t  :1;
      vuint16_t T2SP:1;
      vuint16_t T2TR:1;
      vuint16_t T2ST:1;
      vuint16_t  :3;
      vuint16_t T1_REP:1;
      vuint16_t  :1;
      vuint16_t T1SP:1;
      vuint16_t T1TR:1;
      vuint16_t T1ST:1;
    } B;
  } TICCR;

  union {                              /* Timer 1 Cycle Set Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_CYC_VAL:6;
      vuint16_t  :2;
      vuint16_t T1_CYC_MSK:6;
    } B;
  } TI1CYSR;

  union {                              /* Timer 1 Macrotick Offset Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_MTOFFSET:14;
    } B;
  } TI1MTOR;

  union {
    union {                            /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2CYCVAL:6;          /* Timer T2 Cycle Filter Mask */
        vuint16_t  :2;
        vuint16_t T2CYCMSK:6;          /* Timer T2 Cycle Filter Mask */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;          /* Timer T2 Macrotick High Word */
      } B;
    } REL;
  } TI2CR0;

  union {
    union {                            /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2MOFF:14;           /* Timer T2 Macrotick Offset */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;
      } B;
    } REL;
  } TI2CR1;

  union {                              /* Slot Status Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SLOTNUMBER:11;
    } B;
  } SSSR;

  union {                              /* Slot Status Counter Condition Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t CNTCFG:2;
      vuint16_t MCY:1;
      vuint16_t VFR:1;
      vuint16_t SYF:1;
      vuint16_t NUF:1;
      vuint16_t SUF:1;
      vuint16_t STATUSMASK:4;
    } B;
  } SSCCR;

  union {                              /* Slot Status Register */
    vuint16_t R;
    struct {
      vuint16_t VFB:1;
      vuint16_t SYB:1;
      vuint16_t NFB:1;
      vuint16_t SUB:1;
      vuint16_t SEB:1;
      vuint16_t CEB:1;
      vuint16_t BVB:1;
      vuint16_t TCB:1;
      vuint16_t VFA:1;
      vuint16_t SYA:1;
      vuint16_t NFA:1;
      vuint16_t SUA:1;
      vuint16_t SEA:1;
      vuint16_t CEA:1;
      vuint16_t BVA:1;
      vuint16_t TCA:1;
    } B;
  } SSR[8];

  union {                              /* Slot Status Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SLOTSTATUSCNT:16;
    } B;
  } SSCR[4];

  union {                              /* MTS A Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSACFR;

  union {                              /* MTS B Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSBCFR;

  union {                              /* Receive Shadow Buffer Index Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :4;
      vuint16_t RSBIDX:8;              /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
    } B;
  } RSBIR;

  union {                              /* Receive FIFO Watermark and Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WM:8;                  /* WMA/WMB - Watermark */
      vuint16_t  :7;
      vuint16_t SEL:1;
    } B;
  } RFWMSR;

  union {                              /* Receive FIFO Start Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SIDX:10;               /* SIDXA/SIDXB - Start Index */
    } B;
  } RFSIR;

  union {                              /* Receive FIFO Depth and Size Register */
    vuint16_t R;
    struct {
      vuint16_t FIFO_DEPTH:8;          /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
      vuint16_t  :1;
      vuint16_t ENTRY_SIZE:7;          /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
    } B;
  } RFDSR;

  union {                              /* Receive FIFO A Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFARIR;

  union {                              /* Receive FIFO B Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFBRIR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFVAL:16;           /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
    } B;
  } RFMIDAFVR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFMSK:16;           /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
    } B;
  } RFMIDAFMR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFVAL:11;           /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
    } B;
  } RFFIDRFVR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFMSK:11;
    } B;
  } RFFIDRFMR;

  union {                              /* Receive FIFO Range Filter Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t IBD:1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SID:11;                /* Slot ID */
    } B;
  } RFRFCFR;

  union {                              /* Receive FIFO Range Filter Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :4;
      vuint16_t F3MD:1;
      vuint16_t F2MD:1;
      vuint16_t F1MD:1;
      vuint16_t F0MD:1;
      vuint16_t  :4;
      vuint16_t F3EN:1;
      vuint16_t F2EN:1;
      vuint16_t F1EN:1;
      vuint16_t F0EN:1;
    } B;
  } RFRFCTR;

  union {                              /* Last Dynamic Transmit Slot Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTA:11;
    } B;
  } LDTXSLAR;

  union {                              /* Last Dynamic Transmit Slot Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTB:11;
    } B;
  } LDTXSLBR;

  union {                              /* Protocol Configuration Register 0 */
    vuint16_t R;
    struct {
      vuint16_t action_point_offset:6;
      vuint16_t static_slot_length:10;
    } B;
  } PCR0;

  union {                              /* Protocol Configuration Register 1 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t macro_after_first_static_slot:14;
    } B;
  } PCR1;

  union {                              /* Protocol Configuration Register 2 */
    vuint16_t R;
    struct {
      vuint16_t minislot_after_action_point:6;
      vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
    } B;
  } PCR2;

  union {                              /* Protocol Configuration Register 3 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_symbol_rx_low:6;
      vuint16_t minislot_action_point_offset:5;
      vuint16_t coldstart_attempts:5;
    } B;
  } PCR3;

  union {                              /* Protocol Configuration Register 4 */
    vuint16_t R;
    struct {
      vuint16_t cas_rx_low_max:7;
      vuint16_t wakeup_symbol_rx_window:9;
    } B;
  } PCR4;

  union {                              /* Protocol Configuration Register 5 */
    vuint16_t R;
    struct {
      vuint16_t tss_transmitter:4;
      vuint16_t wakeup_symbol_tx_low:6;
      vuint16_t wakeup_symbol_rx_idle:6;
    } B;
  } PCR5;

  union {                              /* Protocol Configuration Register 6 */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t symbol_window_after_action_point:8;
      vuint16_t macro_initial_offset_a:7;
    } B;
  } PCR6;

  union {                              /* Protocol Configuration Register 7 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_b:9;
      vuint16_t micro_per_macro_nom_half:7;
    } B;
  } PCR7;

  union {                              /* Protocol Configuration Register 8 */
    vuint16_t R;
    struct {
      vuint16_t max_without_clock_correction_fatal:4;
      vuint16_t max_without_clock_correction_passive:4;
      vuint16_t wakeup_symbol_tx_idle:8;
    } B;
  } PCR8;

  union {                              /* Protocol Configuration Register 9 */
    vuint16_t R;
    struct {
      vuint16_t minislot_exists:1;
      vuint16_t symbol_window_exists:1;
      vuint16_t offset_correction_out:14;
    } B;
  } PCR9;

  union {                              /* Protocol Configuration Register 10 */
    vuint16_t R;
    struct {
      vuint16_t single_slot_enabled:1;
      vuint16_t wakeup_channel:1;
      vuint16_t macro_per_cycle:14;
    } B;
  } PCR10;

  union {                              /* Protocol Configuration Register 11 */
    vuint16_t R;
    struct {
      vuint16_t key_slot_used_for_startup:1;
      vuint16_t key_slot_used_for_sync:1;
      vuint16_t offset_correction_start:14;
    } B;
  } PCR11;

  union {                              /* Protocol Configuration Register 12 */
    vuint16_t R;
    struct {
      vuint16_t allow_passive_to_active:5;
      vuint16_t key_slot_header_crc:11;
    } B;
  } PCR12;

  union {                              /* Protocol Configuration Register 13 */
    vuint16_t R;
    struct {
      vuint16_t first_minislot_action_point_offset:6;
      vuint16_t static_slot_after_action_point:10;
    } B;
  } PCR13;

  union {                              /* Protocol Configuration Register 14 */
    vuint16_t R;
    struct {
      vuint16_t rate_correction_out:11;
      vuint16_t listen_timeout:5;
    } B;
  } PCR14;

  union {                              /* Protocol Configuration Register 15 */
    vuint16_t R;
    struct {
      vuint16_t listen_timeout:16;
    } B;
  } PCR15;

  union {                              /* Protocol Configuration Register 16 */
    vuint16_t R;
    struct {
      vuint16_t macro_initial_offset_b:7;
      vuint16_t noise_listen_timeout:9;
    } B;
  } PCR16;

  union {                              /* Protocol Configuration Register 17 */
    vuint16_t R;
    struct {
      vuint16_t noise_listen_timeout:16;
    } B;
  } PCR17;

  union {                              /* Protocol Configuration Register 18 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_pattern:6;
      vuint16_t key_slot_id:10;
    } B;
  } PCR18;

  union {                              /* Protocol Configuration Register 19 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_a:9;
      vuint16_t payload_length_static:7;
    } B;
  } PCR19;

  union {                              /* Protocol Configuration Register 20 */
    vuint16_t R;
    struct {
      vuint16_t micro_initial_offset_b:8;
      vuint16_t micro_initial_offset_a:8;
    } B;
  } PCR20;

  union {                              /* Protocol Configuration Register 21 */
    vuint16_t R;
    struct {
      vuint16_t extern_rate_correction:3;
      vuint16_t latest_tx:13;
    } B;
  } PCR21;

  union {                              /* Protocol Configuration Register 22 */
    vuint16_t R;
    struct {
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t comp_accepted_startup_range_a:11;
      vuint16_t micro_per_cycle:4;
    } B;
  } PCR22;

  union {                              /* Protocol Configuration Register 23 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle:16;
    } B;
  } PCR23;

  union {                              /* Protocol Configuration Register 24 */
    vuint16_t R;
    struct {
      vuint16_t cluster_drift_damping:5;
      vuint16_t max_payload_length_dynamic:7;
      vuint16_t micro_per_cycle_min:4;
    } B;
  } PCR24;

  union {                              /* Protocol Configuration Register 25 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_min:16;
    } B;
  } PCR25;

  union {                              /* Protocol Configuration Register 26 */
    vuint16_t R;
    struct {
      vuint16_t allow_halt_due_to_clock:1;
      vuint16_t comp_accepted_startup_range_b:11;
      vuint16_t micro_per_cycle_max:4;
    } B;
  } PCR26;

  union {                              /* Protocol Configuration Register 27 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_max:16;
    } B;
  } PCR27;

  union {                              /* Protocol Configuration Register 28 */
    vuint16_t R;
    struct {
      vuint16_t dynamic_slot_idle_phase:2;
      vuint16_t macro_after_offset_correction:14;
    } B;
  } PCR28;

  union {                              /* Protocol Configuration Register 29 */
    vuint16_t R;
    struct {
      vuint16_t extern_offset_correction:3;
      vuint16_t minislots_max:13;
    } B;
  } PCR29;

  union {                              /* Protocol Configuration Register 30 */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t sync_node_max:4;
    } B;
  } PCR30;

  union {                              /* StopWatch Count Register */
    vuint16_t R;
    struct {
      vuint16_t STPW:16;               /* StopWatch Count Register */
    } B;
  } STPWR;

  uint8_t FR_reserved1[2];
  union {                              /* Protocol Event Output Enable and StopWatch Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :7;
      vuint16_t STPW_EN:1;             /* Stopwatch count Enable */
      vuint16_t  :5;
      vuint16_t TIM2_EE:1;
      vuint16_t TIM1_EE:1;
      vuint16_t CYC_EE:1;
    } B;
  } PEOER;

  uint8_t FR_reserved2[2];
  union {                              /* Receive FIFO Start Data Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SDO:16;                /* SDOA/SDOB - Start Data Field Offset */
    } B;
  } RFSDOR;

  union {                              /* Receive FIFO System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;
    } B;
  } RFSYMBADHR;

  union {                              /* Receive FIFO System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } RFSYMBADLR;

  union {                              /* Receive FIFO Periodic Timer Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t PTD:14;
    } B;
  } RFPTR;

  union {                              /* Receive FIFO Fill Level and POP Count Register */
    vuint16_t R;
    struct {
      vuint16_t FLB_or_PCB:8;
      vuint16_t FLA_or_PCA:8;
    } B;
  } RFFLPCR;

  union {                              /* ECC Error Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t LRNE_OF:1;
      vuint16_t LRCE_OF:1;
      vuint16_t DRNE_OF:1;
      vuint16_t DRCE_OF:1;
      vuint16_t LRNE_IF:1;
      vuint16_t LRCE_IF:1;
      vuint16_t DRNE_IF:1;
      vuint16_t DRCE_IF:1;
      vuint16_t  :4;
      vuint16_t LRNE_IE:1;
      vuint16_t LRCE_IE:1;
      vuint16_t DRNE_IE:1;
      vuint16_t DRCE_IE:1;
    } B;
  } EEIFER;

  union {                              /* ECC Error Report and Injection Control Register */
    vuint16_t R;
    struct {
      vuint16_t BSY:1;
      vuint16_t  :5;
      vuint16_t ERS:2;
      vuint16_t  :3;
      vuint16_t ERM:1;
      vuint16_t  :2;
      vuint16_t EIM:1;
      vuint16_t EIE:1;
    } B;
  } EERICR;

  union {                              /* ECC Error Report Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EERAR;

  union {                              /* ECC Error Report Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EERDR;

  union {                              /* ECC Error Report Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EERCR;

  union {                              /* ECC Error Injection Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EEIAR;

  union {                              /* ECC Error Injection Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EEIDR;

  union {                              /* ECC Error Injection Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EEICR;

  uint8_t FR_reserved3[1792];
  struct {
    union {                            /* Message Buffer Configuration, Control, Status Register */
      vuint16_t R;
      struct {
        vuint16_t  :3;
        vuint16_t MTD:1;
        vuint16_t CMT:1;
        vuint16_t EDT:1;
        vuint16_t LCKT:1;
        vuint16_t MBIE:1;
        vuint16_t  :3;
        vuint16_t DUP:1;
        vuint16_t DVAL:1;
        vuint16_t EDS:1;
        vuint16_t LCKS:1;
        vuint16_t MBIF:1;
      } B;
    } CCSR;
    union {                            /* Message Buffer Cycle Counter Filter Register */
      vuint16_t R;
      struct {
        vuint16_t MTM:1;
        vuint16_t CHA:1;
        vuint16_t CHB:1;
        vuint16_t CCFE:1;
        vuint16_t CCFMSK:6;
        vuint16_t CCFVAL:6;
      } B;
    } CCFR;
    union {                            /* Message Buffer Frame ID Register */
      vuint16_t R;
      struct {
        vuint16_t  :5;
        vuint16_t FID:11;
      } B;
    } FIDR;
    union {                            /* Message Buffer Index Register */
      vuint16_t R;
      struct {
        vuint16_t  :8;
        vuint16_t MBIDX:8;
      } B;
    } IDXR;
  } MB[128];

  uint8_t FR_reserved4[1024];
  union {                              /* Message Buffer Data Field Offset Register */
    vuint16_t R;
    struct {
      vuint16_t MBDO:16;
    } B;
  } MBDOR[132];

  union {                              /* LRAM ECC Error Test Register */
    vuint16_t R;
    struct {
      vuint16_t LEETD:16;
    } B;
  } LEETR[6];
};


/* ============================================================================
   =============================== Module: FXOSC ==============================
   ============================================================================ */

struct FXOSC_tag {
  union {                              /* FXOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t OSCBYP:1;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t EOCV:8;                /* End of Count Value */
      vuint32_t M_OSC:1;               /* Crystal oscillator clock interrupt mask */
      vuint32_t  :2;
      vuint32_t OSCDIV:5;
      vuint32_t I_OSC:1;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: GPR ================================
   ============================================================================ */

struct GPR_tag {
  union {                              /* GPR Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t EXTREGC:1;             /* This bit enables the external regulator control multiplexed function on PG[6] */
      vuint32_t DEST_ESC_CTRL2:1;      /* Enables the escalation of destructive reset source: SWT0 reset request. This bit will be reset on POR. */
      vuint32_t DEST_ESC_CTRL1:1;      /* Enables the escalation of destructive reset source: functional reset escalation. This bit will be reset on POR. */
      vuint32_t DEST_ESC_CTRL0:1;      /* Enables the escalation of destructive reset source: SSCM secured reset. This bit will be reset on POR. */
      vuint32_t  :5;
      vuint32_t CMP2_STDBY:1;
      vuint32_t CMP1_STDBY:1;
      vuint32_t CMP0_STDBY:1;
      vuint32_t CLKOUT1_STDBY:1;
      vuint32_t LPU_STOP_ACK_BYPASS:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t RTC_SXOSC_FREE_RUNNING:1; /* Enables seamless RTC operation across functional and destructive reset in the specific case when RTC is running on SXOSC. This Bit should be set after SXOSC is enabled by the software. */
      vuint32_t CMP_ACT_SAM:1;         /* Actual sample to the CMP */
      vuint32_t CMP_SAMP_SEL:1;        /* Sample select to the CMP */
      vuint32_t USDHC_BS:2;            /* uSDHC byte_swapper: Swaps the AHB write/read data at the boundary of uSDHC master */
      vuint32_t MLB_BS:2;              /* MLB byte swapper: Swaps the AHB write/read data at the boundary of MLB master */
      vuint32_t FR_BS:2;               /* FlexRay byte swapper: Swaps the AHB write/read data at the boundary of FlexRay master */
      vuint32_t ENET_TX_BS:2;          /* ENET TX byte swapper: Swaps the AHB write/read data at the TX boundary of ENET master */
      vuint32_t ENET_RX_BS:2;          /* ENET RX byte swapper: Swaps the AHB write/read data at the RX boundary of ENET master */
    } B;
  } CTL;

  union {                              /* GPR Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t FLASH_LP_ACK:1;        /* FLASH low power acknowledge status */
      vuint32_t  :8;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } STAT;

  uint8_t GPR_reserved0[8];
  union {                              /* GPR Control Register1 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t IVPR:24;               /* Interrupt Vector Prefix Register Programming */
    } B;
  } CTL1;
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

struct I2C_tag {
  union {                              /* I2C Bus Address Register */
    vuint8_t R;
    struct {
      vuint8_t ADR:7;
      vuint8_t  :1;
    } B;
  } IBAD;

  union {                              /* I2C Bus Frequency Divider Register */
    vuint8_t R;
    struct {
      vuint8_t IBC:8;
    } B;
  } IBFD;

  union {                              /* I2C Bus Control Register */
    vuint8_t R;
    struct {
      vuint8_t MDIS:1;
      vuint8_t IBIE:1;
      vuint8_t MSSL:1;
      vuint8_t TXRX:1;
      vuint8_t NOACK:1;
      vuint8_t RSTA:1;
      vuint8_t DMAEN:1;
      vuint8_t  :1;
    } B;
  } IBCR;

  union {                              /* I2C Bus Status Register */
    vuint8_t R;
    struct {
      vuint8_t TCF:1;
      vuint8_t IAAS:1;
      vuint8_t IBB:1;
      vuint8_t IBAL:1;
      vuint8_t  :1;
      vuint8_t SRW:1;
      vuint8_t IBIF:1;
      vuint8_t RXAK:1;
    } B;
  } IBSR;

  union {                              /* I2C Bus Data I/O Register */
    vuint8_t R;
    struct {
      vuint8_t DATA:8;
    } B;
  } IBDR;

  union {                              /* I2C Bus Interrupt Config Register */
    vuint8_t R;
    struct {
      vuint8_t BIIE:1;
      vuint8_t  :7;
    } B;
  } IBIC;

  union {                              /* I2C Bus Debug Register */
    vuint8_t R;
    struct {
      vuint8_t  :5;
      vuint8_t BYTE_RX:1;
      vuint8_t IPG_DEBUG_HALTED:1;
      vuint8_t IPG_DEBUG_EN:1;
    } B;
  } IBDBG;
};


/* ============================================================================
   =============================== Module: I2S ================================
   ============================================================================ */

struct I2S_tag {
  union {                              /* SAI Transmit Control Register */
    vuint32_t R;
    struct {
      vuint32_t TE:1;                  /* Transmitter Enable */
      vuint32_t STOPE:1;               /* Stop Enable */
      vuint32_t DBGE:1;                /* Debug Enable */
      vuint32_t BCE:1;                 /* Bit Clock Enable */
      vuint32_t  :2;
      vuint32_t FR:1;                  /* FIFO Reset */
      vuint32_t SR:1;                  /* Software Reset */
      vuint32_t  :3;
      vuint32_t WSF:1;                 /* Word Start Flag */
      vuint32_t SEF:1;                 /* Sync Error Flag */
      vuint32_t FEF:1;                 /* FIFO Error Flag */
      vuint32_t FWF:1;                 /* FIFO Warning Flag */
      vuint32_t FRF:1;                 /* FIFO Request Flag */
      vuint32_t  :3;
      vuint32_t WSIE:1;                /* Word Start Interrupt Enable */
      vuint32_t SEIE:1;                /* Sync Error Interrupt Enable */
      vuint32_t FEIE:1;                /* FIFO Error Interrupt Enable */
      vuint32_t FWIE:1;                /* FIFO Warning Interrupt Enable */
      vuint32_t FRIE:1;                /* FIFO Request Interrupt Enable */
      vuint32_t  :3;
      vuint32_t  :3;
      vuint32_t FWDE:1;                /* FIFO Warning DMA Enable */
      vuint32_t FRDE:1;                /* FIFO Request DMA Enable */
    } B;
  } TCSR;

  union {                              /* SAI Transmit Configuration 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TFW:3;                 /* Transmit FIFO Watermark */
    } B;
  } TCR1;

  union {                              /* SAI Transmit Configuration 2 Register */
    vuint32_t R;
    struct {
      vuint32_t SYNC:2;                /* Synchronous Mode */
      vuint32_t BCS:1;                 /* Bit Clock Swap */
      vuint32_t BCI:1;                 /* Bit Clock Input */
      vuint32_t MSEL:2;                /* MCLK Select */
      vuint32_t BCP:1;                 /* Bit Clock Polarity */
      vuint32_t BCD:1;                 /* Bit Clock Direction */
      vuint32_t  :16;
      vuint32_t DIV:8;                 /* Bit Clock Divide */
    } B;
  } TCR2;

  union {                              /* SAI Transmit Configuration 3 Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t CFR:4;                 /* Channel FIFO Reset */
      vuint32_t  :4;
      vuint32_t TCE:4;                 /* Transmit Channel Enable */
      vuint32_t  :12;
      vuint32_t WDFL:4;                /* Word Flag Configuration */
    } B;
  } TCR3;

  union {                              /* SAI Transmit Configuration 4 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t FCONT:1;               /* FIFO Continue on Error */
      vuint32_t FCOMB:2;               /* FIFO Combine Mode */
      vuint32_t FPACK:2;               /* FIFO Packing Mode */
      vuint32_t  :4;
      vuint32_t FRSZ:4;                /* Frame size */
      vuint32_t  :3;
      vuint32_t SYWD:5;                /* Sync Width */
      vuint32_t  :3;
      vuint32_t MF:1;                  /* MSB First */
      vuint32_t FSE:1;                 /* Frame Sync Early */
      vuint32_t ONDEM:1;               /* On Demand Mode */
      vuint32_t FSP:1;                 /* Frame Sync Polarity */
      vuint32_t FSD:1;                 /* Frame Sync Direction */
    } B;
  } TCR4;

  union {                              /* SAI Transmit Configuration 5 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t WNW:5;                 /* Word N Width */
      vuint32_t  :3;
      vuint32_t W0W:5;                 /* Word 0 Width */
      vuint32_t  :3;
      vuint32_t FBT:5;                 /* First Bit Shifted */
      vuint32_t  :8;
    } B;
  } TCR5;

  uint8_t I2S_reserved0[8];
  union {                              /* SAI Transmit Data Register */
    vuint32_t R;
    struct {
      vuint32_t TDR:32;                /* Transmit Data Register */
    } B;
  } TDR[4];

  uint8_t I2S_reserved1[16];
  union {                              /* SAI Transmit FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t WCP:1;                 /* Write Channel Pointer */
      vuint32_t  :11;
      vuint32_t WFP:4;                 /* Write FIFO Pointer */
      vuint32_t  :12;
      vuint32_t RFP:4;                 /* Read FIFO Pointer */
    } B;
  } TFR[4];

  uint8_t I2S_reserved2[16];
  union {                              /* SAI Transmit Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TWM:16;                /* Transmit Word Mask */
    } B;
  } TMR;

  uint8_t I2S_reserved3[28];
  union {                              /* SAI Receive Control Register */
    vuint32_t R;
    struct {
      vuint32_t RE:1;                  /* Receiver Enable */
      vuint32_t STOPE:1;               /* Stop Enable */
      vuint32_t DBGE:1;                /* Debug Enable */
      vuint32_t BCE:1;                 /* Bit Clock Enable */
      vuint32_t  :2;
      vuint32_t FR:1;                  /* FIFO Reset */
      vuint32_t SR:1;                  /* Software Reset */
      vuint32_t  :3;
      vuint32_t WSF:1;                 /* Word Start Flag */
      vuint32_t SEF:1;                 /* Sync Error Flag */
      vuint32_t FEF:1;                 /* FIFO Error Flag */
      vuint32_t FWF:1;                 /* FIFO Warning Flag */
      vuint32_t FRF:1;                 /* FIFO Request Flag */
      vuint32_t  :3;
      vuint32_t WSIE:1;                /* Word Start Interrupt Enable */
      vuint32_t SEIE:1;                /* Sync Error Interrupt Enable */
      vuint32_t FEIE:1;                /* FIFO Error Interrupt Enable */
      vuint32_t FWIE:1;                /* FIFO Warning Interrupt Enable */
      vuint32_t FRIE:1;                /* FIFO Request Interrupt Enable */
      vuint32_t  :3;
      vuint32_t  :3;
      vuint32_t FWDE:1;                /* FIFO Warning DMA Enable */
      vuint32_t FRDE:1;                /* FIFO Request DMA Enable */
    } B;
  } RCSR;

  union {                              /* SAI Receive Configuration 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t RFW:3;                 /* Receive FIFO Watermark */
    } B;
  } RCR1;

  union {                              /* SAI Receive Configuration 2 Register */
    vuint32_t R;
    struct {
      vuint32_t SYNC:2;                /* Synchronous Mode */
      vuint32_t BCS:1;                 /* Bit Clock Swap */
      vuint32_t BCI:1;                 /* Bit Clock Input */
      vuint32_t MSEL:2;                /* MCLK Select */
      vuint32_t BCP:1;                 /* Bit Clock Polarity */
      vuint32_t BCD:1;                 /* Bit Clock Direction */
      vuint32_t  :16;
      vuint32_t DIV:8;                 /* Bit Clock Divide */
    } B;
  } RCR2;

  union {                              /* SAI Receive Configuration 3 Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t CFR:4;                 /* Channel FIFO Reset */
      vuint32_t  :4;
      vuint32_t RCE:4;                 /* Receive Channel Enable */
      vuint32_t  :12;
      vuint32_t WDFL:4;                /* Word Flag Configuration */
    } B;
  } RCR3;

  union {                              /* SAI Receive Configuration 4 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t FCONT:1;               /* FIFO Continue on Error */
      vuint32_t FCOMB:2;               /* FIFO Combine Mode */
      vuint32_t FPACK:2;               /* FIFO Packing Mode */
      vuint32_t  :4;
      vuint32_t FRSZ:4;                /* Frame Size */
      vuint32_t  :3;
      vuint32_t SYWD:5;                /* Sync Width */
      vuint32_t  :3;
      vuint32_t MF:1;                  /* MSB First */
      vuint32_t FSE:1;                 /* Frame Sync Early */
      vuint32_t ONDEM:1;               /* On Demand Mode */
      vuint32_t FSP:1;                 /* Frame Sync Polarity */
      vuint32_t FSD:1;                 /* Frame Sync Direction */
    } B;
  } RCR4;

  union {                              /* SAI Receive Configuration 5 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t WNW:5;                 /* Word N Width */
      vuint32_t  :3;
      vuint32_t W0W:5;                 /* Word 0 Width */
      vuint32_t  :3;
      vuint32_t FBT:5;                 /* First Bit Shifted */
      vuint32_t  :8;
    } B;
  } RCR5;

  uint8_t I2S_reserved4[8];
  union {                              /* SAI Receive Data Register */
    vuint32_t R;
    struct {
      vuint32_t RDR:32;                /* Receive Data Register */
    } B;
  } RDR[4];

  uint8_t I2S_reserved5[16];
  union {                              /* SAI Receive FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t WFP:4;                 /* Write FIFO Pointer */
      vuint32_t RCP:1;                 /* Receive Channel Pointer */
      vuint32_t  :11;
      vuint32_t RFP:4;                 /* Read FIFO Pointer */
    } B;
  } RFR[4];

  uint8_t I2S_reserved6[16];
  union {                              /* SAI Receive Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RWM:16;                /* Receive Word Mask */
    } B;
  } RMR;

  uint8_t I2S_reserved7[28];
  union {                              /* SAI MCLK Control Register */
    vuint32_t R;
    struct {
      vuint32_t DUF:1;                 /* Divider Update Flag */
      vuint32_t MOE:1;                 /* MCLK Output Enable */
      vuint32_t  :4;
      vuint32_t MICS:2;                /* MCLK Input Clock Select */
      vuint32_t  :24;
    } B;
  } MCR;

  union {                              /* SAI MCLK Divide Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FRACT:9;               /* MCLK Fraction */
      vuint32_t DIVIDE:12;             /* MCLK Divide */
    } B;
  } MDR;
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

struct INTC_tag {
  union {                              /* INTC Block Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t HVEN3:1;
      vuint32_t  :3;
      vuint32_t HVEN2:1;
      vuint32_t  :3;
      vuint32_t HVEN1:1;
      vuint32_t  :3;
      vuint32_t HVEN0:1;
    } B;
  } BCR;

  union {                              /* INTC Master Protection Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ID:2;
      vuint32_t  :3;
      vuint32_t MPROT:1;
    } B;
  } MPROT;

  uint8_t INTC_reserved0[8];
  union {                              /* INTC Current Priority Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t PRI:4;
    } B;
  } CPR[3];

  uint8_t INTC_reserved1[4];
  union {                              /* INTC Interrupt Acknowledge Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t VTBA:20;
      vuint32_t INTVEC:10;
      vuint32_t  :2;
    } B;
  } IACKR[3];

  uint8_t INTC_reserved2[4];
  union {                              /* INTC End Of Interrupt Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t EOI:32;
    } B;
  } EOIR[3];

  uint8_t INTC_reserved3[4];
  union {                              /* INTC Software Set/Clear Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t  :6;
      vuint8_t SET:1;
      vuint8_t CLR:1;
    } B;
  } SSCIR[24];

  uint8_t INTC_reserved4[8];
  union {                              /* INTC Priority Select Register */
    vuint16_t R;
    struct {
      vuint16_t PRC_SELN:4;
      vuint16_t  :3;
      vuint16_t SWTN:1;
      vuint16_t  :4;
      vuint16_t PRIN:4;
    } B;
  } PSR[1024];
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

struct JDC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t JIN_IEN:1;
      vuint32_t  :15;
      vuint32_t JOUT_IEN:1;
    } B;
  } MCR;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t JIN_RDY:1;
      vuint32_t  :1;
      vuint32_t JIN_INT:1;
      vuint32_t  :13;
      vuint32_t JOUT_RDY:1;
      vuint32_t  :1;
      vuint32_t JOUT_INT:1;
    } B;
  } MSR;

  union {                              /* JTAG Output Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JOUT_IPS;

  union {                              /* JTAG Input Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JIN_IPS;
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

struct LINFlexD_tag {
  union {                              /* LIN Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CCD:1;
      vuint32_t CFD:1;
      vuint32_t LASE:1;
      vuint32_t AUTOWU:1;
      vuint32_t MBL:4;
      vuint32_t BF:1;
      vuint32_t  :1;
      vuint32_t LBKM:1;
      vuint32_t MME:1;
      vuint32_t SSBL:1;
      vuint32_t RBLM:1;
      vuint32_t SLEEP:1;
      vuint32_t INIT:1;
    } B;
  } LINCR1;

  union {                              /* LIN Interrupt enable register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZIE:1;
      vuint32_t OCIE:1;
      vuint32_t BEIE:1;
      vuint32_t CEIE:1;
      vuint32_t HEIE:1;
      vuint32_t  :2;
      vuint32_t FEIE:1;
      vuint32_t BOIE:1;
      vuint32_t LSIE:1;
      vuint32_t WUIE:1;
      vuint32_t DBFIE:1;
      vuint32_t DBEIETOIE:1;
      vuint32_t DRIE:1;
      vuint32_t DTIE:1;
      vuint32_t HRIE:1;
    } B;
  } LINIER;

  union {                              /* LIN Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t AUTOSYNC_COMP:1;
      vuint32_t RDC:3;
      vuint32_t LINS:4;                /* LIN state */
      vuint32_t  :2;
      vuint32_t RMB:1;
      vuint32_t DRBNE:1;
      vuint32_t RXbusy:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t DBFF:1;
      vuint32_t DBEF:1;
      vuint32_t DRF:1;
      vuint32_t DTF:1;
      vuint32_t HRF:1;
    } B;
  } LINSR;

  union {                              /* LIN Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t BEF:1;
      vuint32_t CEF:1;
      vuint32_t SFEF:1;
      vuint32_t SDEF:1;
      vuint32_t IDPEF:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t  :6;
      vuint32_t NF:1;
    } B;
  } LINESR;

  union {                              /* UART Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :8;
      vuint32_t NEF:3;
      vuint32_t DTU_PCETX:1;           /* Disable Timeout in UART mode */
      vuint32_t SBUR:2;
      vuint32_t WLS:1;
      vuint32_t TDFL_TFC:3;
      vuint32_t RDFL_RFC:3;
      vuint32_t RFBM:1;
      vuint32_t TFBM:1;
      vuint32_t WL1:1;
      vuint32_t PC1:1;
      vuint32_t RxEn:1;
      vuint32_t TxEn:1;
      vuint32_t PC0:1;
      vuint32_t PCE:1;
      vuint32_t WL0:1;
      vuint32_t UART:1;
    } B;
  } UARTCR;

  union {                              /* UART Mode Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t PE:4;
      vuint32_t RMB:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t RFNE:1;
      vuint32_t TO:1;
      vuint32_t DRFRFE:1;
      vuint32_t DTFTFF:1;
      vuint32_t NF:1;
    } B;
  } UARTSR;

  union {                              /* LIN Time-Out Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t MODE:1;
      vuint32_t IOT:1;
      vuint32_t TOCE:1;
      vuint32_t CNT:8;
    } B;
  } LINTCSR;

  union {                              /* LIN Output Compare Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OC2:8;
      vuint32_t OC1:8;
    } B;
  } LINOCR;

  union {                              /* LIN Time-Out Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t RTO:4;
      vuint32_t  :1;
      vuint32_t HTO:7;
    } B;
  } LINTOCR;

  union {                              /* LIN Fractional Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FBR:4;
    } B;
  } LINFBRR;

  union {                              /* LIN Integer Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t IBR:20;
    } B;
  } LINIBRR;

  union {                              /* LIN Checksum Field Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CF:8;
    } B;
  } LINCFR;

  union {                              /* LIN Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TBDE:1;
      vuint32_t IOBE:1;
      vuint32_t IOPE:1;
      vuint32_t WURQ:1;
      vuint32_t DDRQ:1;
      vuint32_t DTRQ:1;
      vuint32_t ABRQ:1;
      vuint32_t HTRQ:1;
      vuint32_t  :8;
    } B;
  } LINCR2;

  union {                              /* Buffer Identifier Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;
      vuint32_t DIR:1;
      vuint32_t CCS:1;
      vuint32_t  :2;
      vuint32_t ID:6;
    } B;
  } BIDR;

  union {                              /* Buffer Data Register Least Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA3:8;
      vuint32_t DATA2:8;
      vuint32_t DATA1:8;
      vuint32_t DATA0:8;
    } B;
  } BDRL;

  union {                              /* Buffer Data Register Most Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA7:8;
      vuint32_t DATA6:8;
      vuint32_t DATA5:8;
      vuint32_t DATA4:8;
    } B;
  } BDRM;

  union {                              /* Identifier Filter Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FACT:16;
    } B;
  } IFER;

  union {                              /* Identifier Filter Match Index */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IFMI:5;
    } B;
  } IFMI;

  union {                              /* Identifier Filter Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t IFM:8;
    } B;
  } IFMR;

  union {                              /* Identifier Filter Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;                 /* Data Field Length */
      vuint32_t DIR:1;                 /* Direction */
      vuint32_t CCS:1;                 /* Classic Checksum */
      vuint32_t  :2;
      vuint32_t ID:6;                  /* Identifier */
    } B;
  } IFCR[16];

  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDFBM:1;
      vuint32_t RDFBM:1;
      vuint32_t TDLIS:1;
      vuint32_t RDLIS:1;
      vuint32_t STOP:1;
      vuint32_t SR:1;
    } B;
  } GCR;

  union {                              /* UART Preset Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PTO:12;
    } B;
  } UARTPTO;

  union {                              /* UART Current Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t CTO:12;
    } B;
  } UARTCTO;

  union {                              /* DMA Tx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DTE:16;
    } B;
  } DMATXE;

  union {                              /* DMA Rx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DRE:16;
    } B;
  } DMARXE;
};


/* ============================================================================
   =============================== Module: LPU ================================
   ============================================================================ */

struct LPU_tag {
  union {                              /* LPU Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t TARGET_MODE:4;         /* Target Chip Mode */
      vuint32_t  :12;
      vuint32_t KEY:16;                /* This field provides the key to change the target mode. Any write access to the register with a value different from the keys is always ignored. Read access will always return the inverted key */
    } B;
  } MCTL;

  union {                              /* LPU Run Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t CAN0_CONT:1;           /* CAN0 continuous operation across LPU modes. CAN CHI frequency will switch from FS80 to LPU_SYS_CLK which will require reconfiguration thus inhibiting continuous operation across LPU modes. */
      vuint32_t  :7;
      vuint32_t DIRECT_DRUN:1;         /* Transition to DRUN on LPU_STANDBY exit */
      vuint32_t SYS_CLK_SEL:1;         /* System clock selection in LPU RUN mode */
      vuint32_t LPU_SLEEP:1;           /* Core sleep request during LPU RUN */
      vuint32_t  :1;
      vuint32_t SXOSC_ON:1;            /* SXOSC control during LPU_RUN */
      vuint32_t SIRC_ON:1;             /* SIRC control during LPU_RUN */
      vuint32_t  :1;
      vuint32_t FXOSC_ON:1;            /* FXOSC control during LPU_RUN */
      vuint32_t FIRC_ON:1;             /* FIRC oscillator control during LPU_RUN */
    } B;
  } RUN_CF;

  union {                              /* LPU Stop Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SXOSC_ON:1;            /* SXOSC control during LPU_STOP */
      vuint32_t SIRC_ON:1;             /* SIRC control during LPU_STOP */
      vuint32_t  :1;
      vuint32_t FXOSC_ON:1;            /* FXOSC control during LPU_STOP */
      vuint32_t FIRC_ON:1;             /* FIRC oscillator control during LPU_STOP */
    } B;
  } STOP_CF;

  union {                              /* LPU Standby Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SXOSC_ON:1;            /* SXOSC control during LPU_STANDBY */
      vuint32_t SIRC_ON:1;             /* SIRC control during LPU_STANDBY */
      vuint32_t  :1;
      vuint32_t FXOSC_ON:1;            /* FXOSC clock source control during LPU_STANDBY */
      vuint32_t FIRC_ON:1;             /* FIRC oscillator control during LPU_STANDBY */
    } B;
  } STANDBY_CF;

  union {                              /* LPU Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t PD2_PWR_STAT:1;        /* Ensures the main domain (power domain 2) is power gated completely. */
      vuint32_t SXOSC_STAT:1;          /* SXOSC clock source status */
      vuint32_t SIRC_STAT:1;           /* SIRC clock status */
      vuint32_t  :1;
      vuint32_t FXOSC_STAT:1;          /* FXOSC clock source status */
      vuint32_t FIRC_STAT:1;           /* FIRC clock status */
      vuint32_t CLK1_STOP:1;           /* FXOSC clock status during LPU mode */
      vuint32_t CLK0_STOP:1;           /* FIRC status during LPU mode */
      vuint32_t  :8;
      vuint32_t MTRANS:1;              /* LPU mode transition */
      vuint32_t  :1;
      vuint32_t CURRENT_MODE:4;        /* Current mode of the chip */
    } B;
  } SR;

  union {                              /* LPU Interrupt control register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t LPU_MRIG_E:1;          /* LPU mode request ignored interrupt enable */
      vuint32_t LPU_NEM_E:1;           /* LPU non-exist mode interrupt enable */
      vuint32_t LPU_MRI_E:1;           /* LPU mode request illegal interrupt enable */
      vuint32_t LPU_MTI_E:1;           /* LPU mode transition illegal interrupt enable */
      vuint32_t  :12;
      vuint32_t LPU_MRIG:1;            /* LPU mode request ignored */
      vuint32_t LPU_NEM:1;             /* LPU non-exist mode interrupt */
      vuint32_t LPU_MRI:1;             /* LPU mode request illegal interrupt */
      vuint32_t LPU_MTI:1;             /* LPU mode transition illegal interrupt */
    } B;
  } ICR;

  union {                              /* Module Disable */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t eMIOS_2:1;
      vuint32_t CMP_2:1;
      vuint32_t CMP_1:1;
      vuint32_t CMP_0:1;
      vuint32_t MEMU_1:1;
      vuint32_t BCTU:1;
      vuint32_t CAN0:1;
      vuint32_t LIN_0:1;
      vuint32_t DSPI_3:1;
      vuint32_t ADC_0:1;
    } B;
  } MDIS;
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[384];
  union {                              /* Clockout 1 Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;              /* CLKOUT1 Source Select */
      vuint32_t  :24;
    } B;
  } CLKOUT1_SC;

  uint8_t MC_CGM_reserved[4];
  
  union {                              /* CLKOUT1_DC Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;                  /* CLKOUT1_DC enable */
      vuint32_t  :4;
      vuint32_t DIV:11;                 /* Divider */
      vuint32_t  :16;
    } B;
  } CLKOUT1_DC;

  uint8_t MC_CGM_reserved1[52];
  union {                              /* Auxiliary Clock 5 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC5_SC;

  union {                              /* Auxiliary Clock 5 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC5_SS;

  uint8_t MC_CGM_reserved2[56];
  union {                              /* System Clock Divider 6 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;                 /* Divider */
      vuint32_t  :16;
    } B;
  } SC_DC6;

  uint8_t MC_CGM_reserved3[60];
  union {                              /* Auxiliary Clock 7 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC7_SC;

  union {                              /* Auxiliary Clock 7 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC7_SS;

  uint8_t MC_CGM_reserved4[56];
  union {                              /* Auxiliary Clock 8 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC8_SC;

  union {                              /* Auxiliary Clock 8 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC8_SS;

  uint8_t MC_CGM_reserved5[56];
  union {                              /* Auxiliary Clock 9 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC9_SC;

  union {                              /* Auxiliary Clock 9 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC9_SS;

  uint8_t MC_CGM_reserved6[1080];
  union {                              /* PCS Switch Duration Register */
    vuint8_t R;
    struct {
      vuint8_t SDUR:8;
    } B;
  } PCS_SDUR;

  uint8_t MC_CGM_reserved7[3];
  union {                              /* PCS Divider Change Register 1 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC1;

  union {                              /* PCS Divider End Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE1;

  union {                              /* PCS Divider Start Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS1;

  union {                              /* PCS Divider Change Register 2 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC2;

  union {                              /* PCS Divider End Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE2;

  union {                              /* PCS Divider Start Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS2;

  uint8_t MC_CGM_reserved8[176];
  union {                              /* Divider Update Abort Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t DIV_UPD_ABRTD:1;
    } B;
  } DIV_UPD_ABRTD;

  union {                              /* System Clock Divider Ratio Change Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t HALT_ABORT_DIS:1;
      vuint32_t SYS_DIV_RATIO_CHNG:1;
    } B;
  } SC_DIV_RC;

  union {                              /* Divider Update Type Register */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_TYPE:1;        /* System Clock Divider Update Type */
      vuint32_t  :24;
      vuint32_t AUX_UPD_TYPE:1;        /* Auxiliary Clock Divider Update Type */
      vuint32_t  :6;
    } B;
  } DIV_UPD_TYPE;

  union {                              /* Divider Update Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t DIV_UPD_TRIGGER:32;
    } B;
  } DIV_UPD_TRIG;

  union {                              /* Divider Update Status Register */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_STAT:1;        /* System Clock Divider Update Status */
      vuint32_t  :24;
      vuint32_t AUX_UPD_STAT:1;        /* Auxiliary Clock Divider Status Type */
      vuint32_t  :6;
    } B;
  } DIV_UPD_STAT;

  uint8_t MC_CGM_reserved9[4];
  union {                              /* System Clock Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :4;
      vuint32_t SWTRG:3;
      vuint32_t SWIP:1;
      vuint32_t  :16;
    } B;
  } SC_SS;

  union {                              /* System Clock Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;
      vuint32_t  :16;
    } B;
  } SC_DC0;

  union {                              /* System Clock Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;
      vuint32_t  :16;
    } B;
  } SC_DC1;

  union {                              /* System Clock Divider 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } SC_DC2;

  union {                              /* System Clock Divider 3 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :13;
      vuint32_t DIV:2;
      vuint32_t  :16;
    } B;
  } SC_DC3;

  union {                              /* System Clock Divider 4 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :13;
      vuint32_t DIV:2;
      vuint32_t  :16;
    } B;
  } SC_DC4;

  union {                              /* System Clock Divider 5 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :12;
      vuint32_t DIV:3;
      vuint32_t  :16;
    } B;
  } SC_DC5;

  uint8_t MC_CGM_reserved10[64];
  union {                              /* Auxiliary Clock 2 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC2_SC;

  union {                              /* Auxiliary Clock 2 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC2_SS;

  uint8_t MC_CGM_reserved12[24];
  union {                              /* Auxiliary Clock 3 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC3_SC;

  union {                              /* Auxiliary Clock 3 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC3_SS;

  uint8_t MC_CGM_reserved13[24];
  union {                              /* Auxiliary Clock 4 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELCTL:1;
      vuint32_t  :24;
    } B;
  } AC4_SC;

  union {                              /* Auxiliary Clock 4 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SELSTAT:1;
      vuint32_t  :24;
    } B;
  } AC4_SS;

  uint8_t MC_CGM_reserved14[56];
  union {                              /* Auxiliary Clock 6 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC6_SC;

  union {                              /* Auxiliary Clock 6 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC6_SS;

  union {                              /* Aux Clock 6 Divider Configuration 0 for CLKOUT_0 */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :10;
      vuint32_t DIV:5;
      vuint32_t  :16;
    } B;
  } AC6_DC0;
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

struct MC_ME_tag {
  union {                              /* Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t S_CURRENT_MODE:4;
      vuint32_t S_MTRANS:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t S_PDO:1;
      vuint32_t  :2;
      vuint32_t S_MVR:1;
      vuint32_t  :2;
      vuint32_t S_FLA:2;
      vuint32_t  :7;
      vuint32_t S_SXOSC:1;             /* 32 KHz external oscillator status */
      vuint32_t S_SIRCON:1;            /* 128 KHz internal RC oscillator status */
      vuint32_t S_PLLON:1;             /* PLL status */
      vuint32_t S_FXOSC:1;             /* 8-40 MHz crystal oscillator status */
      vuint32_t S_FIRCON:1;
      vuint32_t S_SYSCLK:4;
    } B;
  } GS;

  union {                              /* Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t TARGET_MODE:4;         /* Target chip mode */
      vuint32_t  :12;
      vuint32_t KEY:16;
    } B;
  } MCTL;

  union {                              /* Mode Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RESET_DEST:1;
      vuint32_t  :1;
      vuint32_t STANDBY0:1;            /* STANDBY0 mode enable */
      vuint32_t  :2;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t  :1;
      vuint32_t RESET_FUNC:1;
    } B;
  } ME;

  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t I_ICONF_CC:1;
      vuint32_t  :1;
      vuint32_t I_ICONF:1;
      vuint32_t I_IMODE:1;
      vuint32_t I_SAFE:1;
      vuint32_t I_MTC:1;
    } B;
  } IS;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t M_ICONF_CC:1;
      vuint32_t  :1;
      vuint32_t M_ICONF:1;
      vuint32_t M_IMODE:1;
      vuint32_t M_SAFE:1;
      vuint32_t M_MTC:1;
    } B;
  } IM;

  union {                              /* Invalid Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t S_MRIG:1;
      vuint32_t S_MTI:1;
      vuint32_t S_MRI:1;
      vuint32_t S_DMA:1;
      vuint32_t S_NMA:1;
      vuint32_t S_SEA:1;
    } B;
  } IMTS;

  union {                              /* Debug Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t PREVIOUS_MODE:4;
      vuint32_t  :4;
      vuint32_t MPH_BUSY:1;
      vuint32_t  :2;
      vuint32_t PMC_PROG:1;
      vuint32_t DBG_MODE:1;
      vuint32_t CCKL_PROG:1;
      vuint32_t PCS_PROG:1;
      vuint32_t SMR:1;
      vuint32_t CDP_PRPH_0_255:1;      /* Clock Disable Process Pending status for Peripherals 0…255 */
      vuint32_t VREG_CSRC_SC:1;
      vuint32_t CSRC_CSRC_SC:1;
      vuint32_t IRC_SC:1;
      vuint32_t SCSRC_SC:1;
      vuint32_t SYSCLK_SW:1;
      vuint32_t  :1;
      vuint32_t FLASH_SC:1;
      vuint32_t  :4;
      vuint32_t CDP_PRPH_96_127:1;
      vuint32_t CDP_PRPH_64_95:1;
      vuint32_t CDP_PRPH_32_63:1;
      vuint32_t CDP_PRPH_0_31:1;
    } B;
  } DMTS;

  uint8_t MC_ME_reserved0[4];
  union {                              /* RESET Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32Khz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RESET_MC;

  uint8_t MC_ME_reserved1[4];
  union {                              /* SAFE Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32Khz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } SAFE_MC;

  union {                              /* DRUN Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32Khz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } DRUN_MC;

  union {                              /* RUN0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32 KHz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN_MC[4];

  uint8_t MC_ME_reserved2[8];
  union {                              /* STOP0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32 KHz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } STOP_MC;

  uint8_t MC_ME_reserved3[8];
  union {                              /* STANDBY0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :7;
      vuint32_t SXOSCON:1;             /* 32 KHz external oscillator control */
      vuint32_t SIRCON:1;
      vuint32_t PLLON:1;
      vuint32_t FXOSCON:1;
      vuint32_t FIRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } STANDBY_MC;

  uint8_t MC_ME_reserved4[8];
  union {                              /* Peripheral Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t S_IIC_1:1;
      vuint32_t S_IIC_0:1;
      vuint32_t  :1;
      vuint32_t S_FlexRay:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t  :2;
      vuint32_t S_ADC_1:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
      vuint32_t S_ADC_0:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :1;
      vuint32_t S_ACMP_2:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_ACMP_1:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_ACMP_0:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :4;
      vuint32_t S_ENET:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :2;
      vuint32_t S_SAI_2:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_SAI_1:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active. */
      vuint32_t S_SAI_0:1;             /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :2;
      vuint32_t S_SDHC:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_MLB:1;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_USB_SPH:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t S_USBOTG:1;
      vuint32_t S_eMIOS_2:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t S_eMIOS_1:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t S_eMIOS_0:1;           /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t S_BCTU:1;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    } B;
  } PS0;

  union {                              /* Peripheral Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t S_LIN:14;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :6;
      vuint32_t S_DSPI:4;              /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
      vuint32_t  :6;
      vuint32_t S_IIC:2;               /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. 0: Peripheral is frozen 1: Peripheral is active */
    } B;
  } PS1;

  union {                              /* Peripheral Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t S_WKPU:1;
      vuint32_t S_LPU_CTL:1;
      vuint32_t S_PIT_RTI_0:1;
      vuint32_t S_DMAMUX:1;            /* Peripheral status - These bits specify the current status of each peripheral which is controlled by the MC_ME. */
      vuint32_t  :5;
      vuint32_t S_CRC:1;
      vuint32_t S_MEMU_0:1;
      vuint32_t S_JDC:1;
      vuint32_t S_TDM:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t S_FLEXCAN:8;
      vuint32_t  :2;
      vuint32_t S_LIN:4;
    } B;
  } PS2;

  union {                              /* Peripheral Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t S_MEMU_1:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t S_RTC_API:1;
      vuint32_t S_SPI:6;
    } B;
  } PS3;

  uint8_t MC_ME_reserved5[16];
  union {                              /* Run Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t  :1;
      vuint32_t RESET:1;
    } B;
  } RUN_PC[8];

  union {                              /* Low-Power Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t STANDBY0:1;            /* Peripheral control during STANDBY0 */
      vuint32_t  :2;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :8;
    } B;
  } LP_PC[8];

    /* Note on PCTL registers: There are only some PCTL implemented         */
    /*  In order to make the PCTL easily addressable, these are defined     */
    /*  as an array (ie ME.PCTL[x].R). This means you have to be careful    */
    /*  when addressing these registers in order not to access a PCTL that  */
    /*  is not implemented. Following are available: 0-7, 10-12, 15, 20-25, */
    /*  28, 30-33, 40-43, 50-67, 70-77, 80-84, 90-91, 93-94, 96-102, 104    */

  union {                              /* BCTU Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL[104];

  uint8_t MC_ME_reserved6[152];
  union {                              /* Core Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t S_CORE3:1;             /* Core3 Status */
      vuint32_t S_CORE2:1;             /* Core2 Status */
      vuint32_t S_CORE1:1;
      vuint32_t  :1;
    } B;
  } CS;

  union {
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t STANDBY0:2;
      vuint16_t  :2;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t  :1;
      vuint16_t RESET:1;
    } B;
  } CCTL[4];

  uint8_t MC_ME_reserved7[20];
  union {
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;                 /* Reset on Mode Change */
    } B;
  } CADDR[4];
};



/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

struct MC_RGM_tag {
  union {                              /* 'Destructive' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t F_SWT2_RES:1;          /* Flag for SWT2 Reset */
      vuint32_t F_SWT1_RES:2;          /* Flag for SWT1 Reset */
      vuint32_t F_SWT0_RES:1;          /* Flag for SWT0 (Flash Initialization Failure) Reset */
      vuint32_t F_SUF:1;               /* Flag for SUF (STCU unrecoverable fault) */
      vuint32_t F_FUNC_ESC:1;          /* Flag for Functional Reset Escalation */
      vuint32_t F_SSCM_SEC:1;          /* Flag for SSCM Secure Reset Request */
      vuint32_t F_SOFT_DEST:1;         /* Flag for Software Generated Destructive Reset */
      vuint32_t F_HSM_DEST:1;          /* Flag for HSM Destructive Reset */
      vuint32_t  :1;
      vuint32_t F_POR:1;               /* Flag for Power-On Reset */
    } B;
  } DES;

  uint8_t MC_RGM_reserved0[12];
  union {                              /* 'Destructive' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t D_SWT2_RES:1;          /* Disable SWT2 Reset */
      vuint32_t D_SWT1_RES:2;          /* Disable SWT1 Reset */
      vuint32_t D_SWT0_RES:1;          /* Disable SWT0 (Flash Initialization Failure) Reset */
      vuint32_t D_SUF:1;               /* Disable SUF (STCU unrecoverable fault) */
      vuint32_t D_FUNC_ESC:1;          /* Disable Functional Reset Escalation */
      vuint32_t D_SSCM_SEC:1;          /* Disable SSCM Secure Reset Request */
      vuint32_t D_SOFT_DEST:1;         /* Disable Software Generated Destructive Reset */
      vuint32_t D_HSM_DEST:1;          /* Disable HSM Destructive Reset */
      vuint32_t  :1;
      vuint32_t D_POR:1;               /* Disable Power-On Reset */
    } B;
  } DERD;

  uint8_t MC_RGM_reserved1[28];
  union {                              /* 'Destructive' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t BE_SWT2_RES:1;         /* Bidirectional Reset Enable for SWT2 Reset */
      vuint32_t BE_SWT1_RES:1;         /* Bidirectional Reset Enable for SWT1 Reset */
      vuint32_t BE_SWT0_RES:1;         /* Bidirectional Reset Enable for SWT0 (Flash Initialization Failure) Reset */
      vuint32_t BE_SUF:1;              /* Bidirectional Reset Enable for SUF (STCU unrecoverable fault) */
      vuint32_t BE_FUNC_ESC:1;         /* Bidirectional Reset Enable for Functional Reset Escalation */
      vuint32_t BE_SSCM_SEC:1;         /* Bidirectional Reset Enable for SSCM Secure Reset Request */
      vuint32_t BE_SOFT_DEST:1;        /* Bidirectional Reset Enable for Software Generated Destructive Reset */
      vuint32_t BE_HSM_DEST:1;         /* Bidirectional Reset Enable for HSM Generated Functional Reset */
      vuint32_t  :1;
      vuint32_t BE_POR:1;              /* Bidirectional Power-On Reset */
    } B;
  } DBRE;

  uint8_t MC_RGM_reserved2[716];
  union {                              /* 'Functional' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F_LVD_LV_PD2_cold:1;   /* Flag for PD2 LVD at cold point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t F_HVD_LV_cold:1;       /* Flag for High Voltage Detect */
      vuint32_t F_LVD_IO_A_HI:1;       /* Flag for Low-Voltage Detect IOs */
      vuint32_t F_Z2_DBG:1;            /* Flag for Z2 Debug Reset */
      vuint32_t F_Z4B_DBG:1;           /* Flag for Z4B Debug Reset */
      vuint32_t F_Z4A_DBG:1;           /* Flag for Z4A Debug Reset */
      vuint32_t F_FCCU_SHORT:1;        /* Flag for FCCU Short Functional Reset */
      vuint32_t F_FCCU_LONG:1;         /* Flag for FCCU Long Functional Reset */
      vuint32_t F_CMU_OLR:1;           /* Flag for OSC Frequency less than RC */
      vuint32_t F_ST_DONE:1;           /* Flag for Selt Test Completed */
      vuint32_t F_JTAG_FUNC:1;         /* Flag for JTAG Functional Reset */
      vuint32_t F_NMI_WKPU:1;          /* Flag for Non Maskable Interrupt from Wakeup Unit */
      vuint32_t F_SOFT_FUNC:1;         /* Flag for Software Generated Functional Reset */
      vuint32_t F_HSM_FUNC:1;          /* Flag for HSM Generated Functional Reset */
      vuint32_t  :1;
      vuint32_t F_EXR:1;               /* Flag for External Reset */
    } B;
  } FES;

  uint8_t MC_RGM_reserved3[12];
  union {                              /* 'Functional' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t D_LVD_LV_PD2_cold:1;   /* Disable PD2 LVD at cold point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t D_HVD_LV_cold:1;       /* Disable High Voltage Detect */
      vuint32_t D_LVD_IO_A_HI:1;       /* Disable Low Voltage Detect IOs */
      vuint32_t D_Z2_DBG:1;            /* Disable Z2 Debug Rreset */
      vuint32_t D_Z4B_DBG:1;           /* Disable Z4B Debug Reset */
      vuint32_t D_Z4A_DBG:1;           /* Disable Z4A Debug Reset */
      vuint32_t D_FCCU_SHORT:1;        /* Disable FCCU Short Functional Reset */
      vuint32_t D_FCCU_LONG:1;         /* Disable FCCU Long Functional Reset */
      vuint32_t D_CMU_OLR:1;           /* Disable OSC Frequency less than RC */
      vuint32_t D_ST_DONE:1;           /* Disable Selt Test Completed */
      vuint32_t D_JTAG_FUNC:1;         /* Disable JTAG Functional Reset */
      vuint32_t D_NMI_WKPU:1;          /* Disable Non Maskable Interrupt from Wakeup Unit */
      vuint32_t D_SOFT_FUNC:1;         /* Disable Software Generated Functional Reset */
      vuint32_t D_HSM_FUNC:1;          /* Disable HSM Genrated Functional Reset */
      vuint32_t  :1;
      vuint32_t D_EXR:1;               /* Disable External Reset */
    } B;
  } FERD;

  uint8_t MC_RGM_reserved4[12];
  union {                              /* 'Functional' Event Reset DisableAlternate Request Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t AR_LVD_LV_PD2_cold:1;  /* Alternate Request for PD2 LVD at cold point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AR_HVD_LV_cold:1;      /* Alternate Request for High Voltage Detect */
      vuint32_t AR_LVD_IO_A_HI:1;      /* Alternate Request for Low Voltage Detect IOs */
      vuint32_t AR_Z2_DBG:1;           /* Alternate Request for Z2 Debug Reset */
      vuint32_t AR_Z4B_DBG:1;          /* Alternate Request for Z4B Debug Reset */
      vuint32_t AR_Z4A_DBG:1;          /* Alternate Request for Z4A Debug Reset */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AR_CMU_OLR:1;          /* Alternate Request for OSC Frequency less than RC */
      vuint32_t  :1;
      vuint32_t AR_JTAG_FUNC:1;        /* Alternate Request for JTAG functional Reset */
      vuint32_t AR_NMI_WKPU:1;         /* Alternate Request for Non Maskable Interrupt from Wakeup Unit */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AR_EXR:1;              /* Flag for External reset */
    } B;
  } FEAR;

  uint8_t MC_RGM_reserved5[12];
  union {                              /* 'Functional' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t BE_LVD_LV_PD2_cold:1;  /* Bidirectional Reset Enable for PD2 LVD at Cold Point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t BE_HVD_LV_cold:1;      /* Bidirectional Reset Enable for High Voltage Detect */
      vuint32_t BE_LVD_IO_A_HI:1;      /* Bidirectional Reset Enable for Low Voltage Detect IOs */
      vuint32_t BE_Z2_DBG:1;           /* Bidirectional Reset Enable for Z2 debug reset */
      vuint32_t BE_Z4B_DBG:1;          /* Bidirectional Reset Enable for BE_Z4B_DBG */
      vuint32_t BE_Z4A_DBG:1;          /* Bidirectional Reset Enable for Z4A Debug Reset */
      vuint32_t BE_FCCU_SHORT:1;       /* Bidirectional Reset Enable for FCCU Short Functional Reset */
      vuint32_t BE_FCCU_LONG:1;        /* Bidirectional Reset Enable for FCCU Long Functional Reset */
      vuint32_t BE_CMU_OLR:1;          /* Bidirectional Reset Enable for OSC Frequency less than RC */
      vuint32_t BE_ST_DONE:1;          /* Bidirectional Reset Enable for Selt Test Completed */
      vuint32_t BE_JTAG_FUNC:1;        /* Bidirectional Reset Enable for JTAG Function */
      vuint32_t BE_NMI_WKPU:1;         /* Bidirectional Reset Enable for Non Maskable Interrupt from Wakeup Unit */
      vuint32_t BE_SOFT_FUNC:1;        /* Bidirectional Reset Enable for Software Generated Functional Reset */
      vuint32_t BE_HSM_FUNC:1;         /* Bidirectional Reset Enable for HSM Generated Functional Reset */
      vuint32_t  :1;
      vuint32_t BE_EXR:1;              /* Flag for External Reset */
    } B;
  } FBRE;

  uint8_t MC_RGM_reserved6[12];
  union {                              /* 'Functional' Event Short Sequence Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t SS_LVD_LV_PD2_cold:1;  /* Short Sequence for PD2 LVD at Cold Point */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t SS_HVD_LV_cold:1;      /* Short Sequence for High Voltage Detect IOs */
      vuint32_t SS_LVD_IO_A_HI:1;      /* Short Sequence for Low Voltage Detect IOs */
      vuint32_t SS_Z2_DBG:1;           /* Short Sequence for Z2 Debug Reset */
      vuint32_t SS_Z4B_DBG:1;          /* Short Sequence for Z4B Debug Reset */
      vuint32_t SS_Z4A_DBG:1;          /* Short Sequence for Z4A Debug Reset */
      vuint32_t SS_FCCU_SHORT:1;       /* Short Sequence for FCCU Short Functional Reset */
      vuint32_t SS_FCCU_LONG:1;        /* Short Sequence for FCCU Long Functional Reset */
      vuint32_t SS_CMU_OLR:1;          /* Short Sequence for OSC Frequency less than RC */
      vuint32_t SS_ST_DONE:1;          /* Short Sequence for Selt Test Completed */
      vuint32_t SS_FUNC_JTAG:1;        /* Short Sequence for JTAG Functional Reset */
      vuint32_t SS_NMI_WKPU:1;         /* Short Sequence for Non Maskable Interrupt 3 Wakeup Unit */
      vuint32_t SS_SOFT_FUNC:1;        /* Short Sequence for Software Generated Functional Reset */
      vuint32_t SS_HSM_FUNC:1;         /* Short Sequence for HSM Genrated Functional Reset */
      vuint32_t  :1;
      vuint32_t SS_EXR:1;              /* Short Sequence for External Reset */
    } B;
  } FESS;

  uint8_t MC_RGM_reserved7[704];
  union {                              /* 'Functional' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t FRET:4;
    } B;
  } FRET;

  uint8_t MC_RGM_reserved8[3];
  union {                              /* 'Destructive' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t DRET:4;
    } B;
  } DRET;
};


/* ============================================================================
   =============================== Module: MEMU_0 =============================
   ============================================================================ */

struct MEMU_0_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SWR:1;
      vuint32_t  :15;
    } B;
  } CTRL;

  union {                              /* Error flag register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t PR_CE:1;
      vuint32_t PR_UCE:1;
      vuint32_t PR_CEO:1;
      vuint32_t PR_UCO:1;
      vuint32_t PR_EBO:1;
      vuint32_t  :3;
      vuint32_t F_CE:1;
      vuint32_t F_UCE:1;
      vuint32_t F_CEO:1;
      vuint32_t F_UCO:1;
      vuint32_t F_EBO:1;
      vuint32_t  :3;
      vuint32_t SR_CE:1;
      vuint32_t SR_UCE:1;
      vuint32_t SR_CEO:1;
      vuint32_t SR_UCO:1;
      vuint32_t SR_EBO:1;
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {                              /* Debug register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FR_PR_CE:1;
      vuint32_t FR_PR_UCE:1;
      vuint32_t FR_PR_CEO:1;
      vuint32_t FR_PR_UCO:1;
      vuint32_t FR_PR_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_F_CE:1;
      vuint32_t FR_F_UCE:1;
      vuint32_t FR_F_CEO:1;
      vuint32_t FR_F_UCO:1;
      vuint32_t FR_F_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_SR_CE:1;
      vuint32_t FR_SR_UCE:1;
      vuint32_t FR_SR_CEO:1;
      vuint32_t FR_SR_UCO:1;
      vuint32_t FR_SR_EBO:1;
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {                            /* System RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* System RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } SYS_RAM_CERR[10];

  union {                              /* System RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } SYS_RAM_UNCERR_STS;

  union {                              /* System RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {                              /* System RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } SYS_RAM_OFLW;

  uint8_t MEMU_reserved2[1444];
  struct {
    union {                            /* Peripheral RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Peripheral RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } PERIPH_RAM_CERR[2];

  union {                              /* Peripheral RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {                              /* Peripheral RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {                              /* Peripheral RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } PERIPH_RAM_OFLW;

  uint8_t MEMU_reserved3[1508];
  struct {
    union {                            /* Flash memory correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Flash memory correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } FLASH_CERR[20];

  union {                              /* Flash memory uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } FLASH_UNCERR_STS;

  union {                              /* Flash memory uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } FLASH_UNCERR_ADDR;

  union {                              /* Flash memory concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } FLASH_OFLW;
};


/* ============================================================================
   =============================== Module: MEMU_1 =============================
   ============================================================================ */

struct MEMU_1_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SWR:1;
      vuint32_t  :15;
    } B;
  } CTRL;

  union {                              /* Error flag register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t PR_CE:1;
      vuint32_t PR_UCE:1;
      vuint32_t PR_CEO:1;
      vuint32_t PR_UCO:1;
      vuint32_t PR_EBO:1;
      vuint32_t  :3;
      vuint32_t  :5;
      vuint32_t  :3;
      vuint32_t SR_CE:1;
      vuint32_t SR_UCE:1;
      vuint32_t SR_CEO:1;
      vuint32_t SR_UCO:1;
      vuint32_t SR_EBO:1;
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {                              /* Debug register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FR_PR_CE:1;
      vuint32_t FR_PR_UCE:1;
      vuint32_t FR_PR_CEO:1;
      vuint32_t FR_PR_UCO:1;
      vuint32_t FR_PR_EBO:1;
      vuint32_t  :3;
      vuint32_t  :5;
      vuint32_t  :3;
      vuint32_t FR_SR_CE:1;
      vuint32_t FR_SR_UCE:1;
      vuint32_t FR_SR_CEO:1;
      vuint32_t FR_SR_UCO:1;
      vuint32_t FR_SR_EBO:1;
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {                            /* System RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* System RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } SYS_RAM_CERR[3];

  union {                              /* System RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } SYS_RAM_UNCERR_STS;

  union {                              /* System RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {                              /* System RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } SYS_RAM_OFLW;

  uint8_t MEMU_reserved2[1500];
  struct {
    union {                            /* Peripheral RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Peripheral RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } PERIPH_RAM_CERR[1];

  union {                              /* Peripheral RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {                              /* Peripheral RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {                              /* Peripheral RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } PERIPH_RAM_OFLW;

};

/* ============================================================================
   =============================== Module: MLB ================================
   ============================================================================ */

struct MLB_tag {
  union {                              /* MediaLB Control 0 Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;                  /* Not to be written by user. */
      vuint32_t FCT:3;
      vuint32_t CTLRETRY:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t ASYRETRY:1;
      vuint32_t  :4;                   /* Not to be written by user. */
      vuint32_t MLBLK:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t MLBPEN:1;
      vuint32_t MCK:3;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t MLBEN:1;
    } B;
  } C0;

  uint8_t MLB_reserved0[8];
  union {                              /* MediaLB Channel Status 0 Register */
    vuint32_t R;
    struct {
      vuint32_t MCS:32;
    } B;
  } MS0;

  uint8_t MLB_reserved1[4];
  union {                              /* MediaLB Channel Status1 Register */
    vuint32_t R;
    struct {
      vuint32_t MCS:32;
    } B;
  } MS1;

  uint8_t MLB_reserved2[8];
  union {                              /* MediaLB System Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;                  /* Not to be written by user. */
      vuint32_t SERVREQ:1;
      vuint32_t SWSYSCMD:1;
      vuint32_t CSSYSCMD:1;
      vuint32_t UKSYSCMD:1;
      vuint32_t LKSYSCMD:1;
      vuint32_t RSTSYCMD:1;
    } B;
  } MSS;

  union {                              /* MediaLB System Data Register */
    vuint32_t R;
    struct {
      vuint32_t SD3:8;
      vuint32_t SD2:8;
      vuint32_t SD1:8;
      vuint32_t SD0:8;
    } B;
  } MSD;

  uint8_t MLB_reserved3[4];
  union {                              /* MediaLB Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;                   /* Not to be written by user. */
      vuint32_t CTX_BRK:1;
      vuint32_t CTX_PE:1;
      vuint32_t CTX_DONE:1;
      vuint32_t CRX_BRK:1;
      vuint32_t CRX_PE:1;
      vuint32_t CRX_DONE:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t ATX_BRK:1;
      vuint32_t ATX_PE:1;
      vuint32_t ATX_DONE:1;
      vuint32_t ARX_BRK:1;
      vuint32_t ARX_PE:1;
      vuint32_t ARX_DONE:1;
      vuint32_t SYNC_PE:1;
      vuint32_t  :14;                  /* Not to be written by user. */
      vuint32_t ISOC_BFO:1;
      vuint32_t ISOC_PE:1;
    } B;
  } MIEN;

  uint8_t MLB_reserved4[12];
  union {                              /* MediaLB Control 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Not to be written by user. */
      vuint32_t NDA:8;
      vuint32_t CLKM:1;
      vuint32_t LOCK:1;
      vuint32_t  :6;                   /* Not to be written by user. */
    } B;
  } C1;

  uint8_t MLB_reserved6[64];
  union {                              /* HBI Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Not to be written by user. */
      vuint32_t EN:1;
      vuint32_t  :13;                  /* Not to be written by user. */
      vuint32_t RST1:1;
      vuint32_t RST0:1;
    } B;
  } HCTL;

  uint8_t MLB_reserved7[4];
  union {                              /* HBI Channel Mask 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CM:32;
    } B;
  } HCMR0;

  union {                              /* HBI Channel Mask 1 Register */
    vuint32_t R;
    struct {
      vuint32_t C:32;
    } B;
  } HCMR1;

  union {                              /* HBI Channel Error 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CE:32;
    } B;
  } HCER0;

  union {                              /* HBI Channel Error 1 Register */
    vuint32_t R;
    struct {
      vuint32_t E:32;
    } B;
  } HCER1;

  union {                              /* HBI Channel Busy 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CB:32;
    } B;
  } HCBR0;

  union {                              /* HBI Channel Busy 1 Register */
    vuint32_t R;
    struct {
      vuint32_t B:32;
    } B;
  } HCBR1;

  uint8_t MLB_reserved8[32];
  union {                              /* MIF Data 0 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT0;

  union {                              /* MIF Data 1 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT1;

  union {                              /* MIF Data 2 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT2;

  union {                              /* MIF Data 3 Register */
    vuint32_t R;
    struct {
      vuint32_t D:32;
    } B;
  } MDAT3;

  union {                              /* MIF Data Write Enable 0 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE0;

  union {                              /* MIF Data Write Enable 1 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE1;

  union {                              /* MIF Data Write Enable 2 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE2;

  union {                              /* MIF Data Write Enable 3 Register */
    vuint32_t R;
    struct {
      vuint32_t M:32;
    } B;
  } MDWE3;

  union {                              /* MIF Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Not to be written by user. */
      vuint32_t XCMP:1;
    } B;
  } MCTL;

  union {                              /* MIF Address Register */
    vuint32_t R;
    struct {
      vuint32_t WNR:1;
      vuint32_t TB:1;
      vuint32_t  :16;                  /* Not to be written by user. */
      vuint32_t ADDR:6;
      vuint32_t ADR:8;
    } B;
  } MADR;

  uint8_t MLB_reserved9[728];
  union {                              /* AHB Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;                  /* Not to be written by user. */
      vuint32_t MPB:1;
      vuint32_t  :1;                   /* Not to be written by user. */
      vuint32_t DMA_MODE:1;
      vuint32_t SMX:1;
      vuint32_t SCE:1;
    } B;
  } ACTL;

  uint8_t MLB_reserved10[12];
  union {                              /* AHB Channel Status 0 Register */
    vuint32_t R;
    struct {
      vuint32_t INTS_LOG:32;
    } B;
  } ACSR0;

  union {                              /* AHB Channel Status 1 Register */
    vuint32_t R;
    struct {
      vuint32_t L:32;
    } B;
  } ACSR1;

  union {                              /* AHB Channel Mask 0 Register */
    vuint32_t R;
    struct {
      vuint32_t CM:32;
    } B;
  } ACMR0;

  union {                              /* AHB Channel Mask 1 Register */
    vuint32_t R;
    struct {
      vuint32_t CHM:32;
    } B;
  } ACMR1;
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

struct PASS_tag {
  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t CNS:1;
      vuint32_t JUN:1;
      vuint32_t FBE:1;
      vuint32_t  :26;
      vuint32_t LIFE:3;
    } B;
  } LCSTAT;

  uint8_t PASS_reserved0[4];
  union {                              /* Challenge Selector Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t GRP:2;
    } B;
  } CHSEL;

  uint8_t PASS_reserved1[4];
  union {                              /* Challenge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CMST:4;
    } B;
  } CSTAT;

  uint8_t PASS_reserved2[12];
  union {                              /* Challenge Input Register */
    vuint32_t R;
    struct {
      vuint32_t PW32:32;
    } B;
  } CIN[8];

  uint8_t PASS_reserved3[192];
  struct {
    union {                            /* Password Group n - Lock 0 Status Register */
      vuint32_t R;
      struct {
        vuint32_t TSLOCK:1;
        vuint32_t ATSL:1;
        vuint32_t LOWLOCK:14;
        vuint32_t MIDLOCK:16;
      } B;
    } LOCK0;
    union {                            /* Password Group n - Lock 1 Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t HIGHLOCK:16;
      } B;
    } LOCK1;
    union {                            /* Password Group n - Lock 2 Status Register */
      vuint32_t R;
      struct {
        vuint32_t L_256LCK:32;
      } B;
    } LOCK2;
    union {                            /* Password Group n - Lock 3 Status Register */
      vuint32_t R;
      struct {
        vuint32_t PGL:1;
        vuint32_t DBL:1;
        vuint32_t MO:1;
        vuint32_t  :1;
        vuint32_t MSTR:4;
        vuint32_t  :3;
        vuint32_t RL4:1;
        vuint32_t RL3:1;
        vuint32_t RL2:1;
        vuint32_t RL1:1;
        vuint32_t RL0:1;
        vuint32_t U_256LCK:16;
      } B;
    } LOCK3;
  } PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

struct PCM_tag {
  union {                              /* Bus Bridge Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t PRE_FLX:1;             /* Pending read enable (PRE) FLX */
      vuint32_t BRE_FLX:1;             /* Burst read enable (BRE) FLX */
      vuint32_t BWE_FLX:1;             /* Burst Read Enable */
      vuint32_t  :5;
      vuint32_t PRE_ENET:1;            /* Pending Read Enable ENET */
      vuint32_t BRE_ENET:1;            /* Burst read enable (BRE) ENET */
      vuint32_t BWE_ENET:1;            /* Burst Write Enable ENET */
      vuint32_t  :5;
      vuint32_t PRE_DMA:1;             /* Pending read enable (PRE) DMA */
      vuint32_t BRE_DMA:1;             /* Burst read enable (BRE) DMA */
      vuint32_t BWE_DMA:1;             /* Burst write enable (BWE) DMA */
      vuint32_t  :5;
      vuint32_t  :3;
    } B;
  } IAHB_BE0;

  union {                              /* Bus Bridge Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t PRE_uSDHC:1;           /* Pending read enable (PRE) uSDHC */
      vuint32_t BRE_uSDHC:1;           /* Burst read enable (BRE) uSDHC */
      vuint32_t BWE_uSDHC:1;           /* Burst Read Enable uSDHC */
      vuint32_t  :5;
      vuint32_t PRE_USB_1:1;           /* Pending Read Enable USB_1 */
      vuint32_t BRE_USB_1:1;           /* Burst read enable (BRE) USB_1 */
      vuint32_t BWE_USB_1:1;           /* Burst Write Enable USB_1 */
      vuint32_t  :5;
      vuint32_t PRE_USB_0:1;           /* Pending read enable (PRE) DMA */
      vuint32_t BRE_USB_0:1;           /* Burst read enable (BRE) USB_0 */
      vuint32_t BWE_USB_0:1;           /* Burst write enable (BWE) USB_0 */
      vuint32_t  :5;
      vuint32_t PRE_MLB:1;             /* Pending read enable (PRE) MLB */
      vuint32_t BRE_MLB:1;             /* Burst read enable (BRE) MLB */
      vuint32_t BWE_MLB:1;             /* Burst write enable (BWE) MLB */
    } B;
  } IAHB_BE1;

  union {                              /* Bus Bridge Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t PRE_PBRIDGE_A:1;       /* Pending read enable (PRE) PBRIDGE_A */
      vuint32_t BRE_PBRIDGE_A:1;       /* Burst read enable (BRE) PBRIDGE_A */
      vuint32_t BWE_PBRIDGE_A:1;       /* Burst Read Enable PBRIDGE_A */
      vuint32_t  :5;
      vuint32_t PRE_PBRIDGE_B:1;       /* Pending Read Enable PBRIDGE_B */
      vuint32_t BRE_PBRIDGE_B:1;       /* Burst read enable (BRE) PBRIDGE_B */
      vuint32_t BWE_PBRIDGE_B:1;       /* Burst Write Enable PBRIDGE_B */
      vuint32_t  :5;
      vuint32_t PRE_Z2_DATA:1;         /* Pending read enable (PRE) Z2_DATA */
      vuint32_t BRE_Z2_DATA:1;         /* Burst read enable (BRE) Z2_DATA */
      vuint32_t BWE_Z2_DATA:1;         /* Burst write enable (BWE) Z2_DATA */
      vuint32_t  :5;
      vuint32_t PRE_Z2_INST:1;         /* Pending read enable (PRE) Z2_INST */
      vuint32_t BRE_Z2_INST:1;         /* Burst read enable (BRE) Z2_INST */
      vuint32_t BWE_Z2_INST:1;         /* Burst write enable (BWE) Z2_INST */
    } B;
  } IAHB_BE2;

  union {                              /* Bus Bridge Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t PRE_M1:1;              /* Pending read enable (PRE) M1 */
      vuint32_t BRE_M1:1;              /* Burst read enable (BRE) M1 */
      vuint32_t BWE_M1:1;              /* Burst Write Enable M1 */
      vuint32_t  :5;
      vuint32_t PRE_M0:1;              /* Pending Read Enable */
      vuint32_t BRE_M0:1;              /* Burst Read Enable */
      vuint32_t BWE_M0:1;              /* Burst Write Enable */
    } B;
  } IAHB_BE3;

  union {                              /* IPS Clock Gating Module Enable 0 Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t IPS_CGM_SMPU_1:1;      /* IPS clock gating endable for SMPU_1 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_SMPU_0:1;
      vuint32_t  :3;
      vuint32_t IPS_CGM_AXBS_1:1;
      vuint32_t  :3;
      vuint32_t IPS_CGM_AXBS_0:1;      /* IPS clock gating endable for AXBS_0 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_PRAM2:1;       /* IPS clock gating endable for PRAM2 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_PRAM1:1;       /* IPS clock gating endable for PRAM1 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_PRAM0:1;       /* IPS clock gating endable for PRAM0 */
      vuint32_t  :3;
      vuint32_t IPS_CGM_FLASH:1;       /* IPS clock gating endable for PFlash Controller */
    } B;
  } IPS_CGM_EN0;

  union {                              /* IPS Clock Gating Enable 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t IPS_CGM_INTC:1;        /* IPS clock gating endable for INTC */
    } B;
  } IPS_CGM_EN1;
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

struct PFLASH_tag {
  union {                              /* Platform Flash Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t P0_M15PFE:1;
      vuint32_t P0_M14PFE:1;
      vuint32_t P0_M13PFE:1;
      vuint32_t P0_M12PFE:1;
      vuint32_t P0_M11PFE:1;
      vuint32_t P0_M10PFE:1;
      vuint32_t P0_M9PFE:1;
      vuint32_t P0_M8PFE:1;
      vuint32_t P0_M7PFE:1;
      vuint32_t P0_M6PFE:1;
      vuint32_t P0_M5PFE:1;
      vuint32_t P0_M4PFE:1;
      vuint32_t P0_M3PFE:1;
      vuint32_t P0_M2PFE:1;
      vuint32_t P0_M1PFE:1;
      vuint32_t P0_M0PFE:1;
      vuint32_t APC:3;
      vuint32_t RWSC:5;
      vuint32_t  :1;
      vuint32_t P0_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_PFLIM:2;
      vuint32_t P0_BFEN:1;
    } B;
  } PFCR1;

  union {                              /* Platform Flash Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t P1_M15PFE:1;
      vuint32_t P1_M14PFE:1;
      vuint32_t P1_M13PFE:1;
      vuint32_t P1_M12PFE:1;
      vuint32_t P1_M11PFE:1;
      vuint32_t P1_M10PFE:1;
      vuint32_t P1_M9PFE:1;
      vuint32_t P1_M8PFE:1;
      vuint32_t P1_M7PFE:1;
      vuint32_t P1_M6PFE:1;
      vuint32_t P1_M5PFE:1;
      vuint32_t P1_M4PFE:1;
      vuint32_t P1_M3PFE:1;
      vuint32_t P1_M2PFE:1;
      vuint32_t P1_M1PFE:1;
      vuint32_t P1_M0PFE:1;
      vuint32_t  :9;
      vuint32_t P1_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_PFLIM:2;
      vuint32_t P1_BFEN:1;
    } B;
  } PFCR2;

  union {                              /* Platform Flash Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t P0_WCFG:2;
      vuint32_t P1_WCFG:2;
      vuint32_t P2_WCFG:2;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t BAF_DIS:1;
      vuint32_t ARBM:4;                /* Arbitration Mode. This 4-bit field controls the arbitration of concurrent flash access requests from the three AHB ports of the flash memory controller. In both fixed priority or round-robin modes, write requests are prioritized higher than read requests, and read requests are prioritized higher than speculative prefetch requests whenever multiple ports issue concurrent requests. This field is initialized by hardware reset. Specifying a reserved value in this field causes it to default to round-robin arbitration. */
      vuint32_t  :11;
      vuint32_t  :1;
    } B;
  } PFCR3;

  union {                              /* Platform Flash Access Protection Register */
    vuint32_t R;
    struct {
      vuint32_t M0AP:2;
      vuint32_t M1AP:2;
      vuint32_t M2AP:2;
      vuint32_t M3AP:2;
      vuint32_t M4AP:2;
      vuint32_t M5AP:2;
      vuint32_t M6AP:2;
      vuint32_t M7AP:2;
      vuint32_t M8AP:2;
      vuint32_t M9AP:2;
      vuint32_t M10AP:2;
      vuint32_t M11AP:2;
      vuint32_t M12AP:2;
      vuint32_t M13AP:2;
      vuint32_t M14AP:2;
      vuint32_t M15AP:2;
    } B;
  } PFAPR;

  union {                              /* Platform Flash Remap Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t SAFE_CAL:1;
      vuint32_t  :3;
      vuint32_t IRMEN:1;
      vuint32_t  :3;
      vuint32_t GRMEN:1;
    } B;
  } PFCRCR;

  union {                              /* Platform Flash Remap Descriptor Enable Register */
    vuint32_t R;
    struct {
      vuint32_t CRD0EN:1;
      vuint32_t CRD1EN:1;
      vuint32_t CRD2EN:1;
      vuint32_t CRD3EN:1;
      vuint32_t CRD4EN:1;
      vuint32_t CRD5EN:1;
      vuint32_t CRD6EN:1;
      vuint32_t CRD7EN:1;
      vuint32_t CRD8EN:1;
      vuint32_t CRD9EN:1;
      vuint32_t CRD10EN:1;
      vuint32_t CRD11EN:1;
      vuint32_t CRD12EN:1;
      vuint32_t CRD13EN:1;
      vuint32_t CRD14EN:1;
      vuint32_t CRD15EN:1;
      vuint32_t CRD16EN:1;
      vuint32_t CRD17EN:1;
      vuint32_t CRD18EN:1;
      vuint32_t CRD19EN:1;
      vuint32_t CRD20EN:1;
      vuint32_t CRD21EN:1;
      vuint32_t CRD22EN:1;
      vuint32_t CRD23EN:1;
      vuint32_t CRD24EN:1;
      vuint32_t CRD25EN:1;
      vuint32_t CRD26EN:1;
      vuint32_t CRD27EN:1;
      vuint32_t CRD28EN:1;
      vuint32_t CRD29EN:1;
      vuint32_t CRD30EN:1;
      vuint32_t CRD31EN:1;
    } B;
  } PFCRDE;

  union {                              /* Platform Flash Configuration Register 4 */
    vuint32_t R;
    struct {
      vuint32_t P2_M15PFE:1;
      vuint32_t P2_M14PFE:1;
      vuint32_t P2_M13PFE:1;
      vuint32_t P2_M12PFE:1;
      vuint32_t P2_M11PFE:1;
      vuint32_t P2_M10PFE:1;
      vuint32_t P2_M9PFE:1;
      vuint32_t P2_M8PFE:1;
      vuint32_t P2_M7PFE:1;
      vuint32_t P2_M6PFE:1;
      vuint32_t P2_M5PFE:1;
      vuint32_t P2_M4PFE:1;
      vuint32_t P2_M3PFE:1;
      vuint32_t P2_M2PFE:1;
      vuint32_t P2_M1PFE:1;
      vuint32_t P2_M0PFE:1;
      vuint32_t  :9;
      vuint32_t P2_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P2_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P2_PFLIM:2;
      vuint32_t P2_BFEN:1;
    } B;
  } PFCR4;

  uint8_t PFLASH_reserved0[228];
  struct {
    union {                            /* Platform Flash Calibration Region Descriptor n Word0 */
      vuint32_t R;
      struct {
        vuint32_t LSTARTADDR:32;
      } B;
    } Word0;
    union {                            /* Platform Flash Calibration Region Descriptor n Word1 */
      vuint32_t R;
      struct {
        vuint32_t PSTARTADDR:32;
      } B;
    } Word1;
    union {                            /* Platform Flash Calibration Region Descriptor n Word2 */
      vuint32_t R;
      struct {
        vuint32_t M0EN:1;
        vuint32_t M1EN:1;
        vuint32_t M2EN:1;
        vuint32_t M3EN:1;
        vuint32_t M4EN:1;
        vuint32_t M5EN:1;
        vuint32_t M6EN:1;
        vuint32_t M7EN:1;
        vuint32_t M8EN:1;
        vuint32_t M9EN:1;
        vuint32_t M10EN:1;
        vuint32_t M11EN:1;
        vuint32_t M12EN:1;
        vuint32_t M13EN:1;
        vuint32_t M14EN:1;
        vuint32_t M15EN:1;
        vuint32_t  :11;
        vuint32_t CRDSize:5;
      } B;
    } Word2;
    uint8_t PFCRD_reserved0[4];
  } PFCRD[8];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

struct PIT_tag {
  union {                              /* PIT Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MDIS_RTI:1;            /* Module Disable - RTI section */
      vuint32_t MDIS:1;                /* Module Disable - (PIT section) */
      vuint32_t FRZ:1;                 /* Freeze */
    } B;
  } MCR;

  uint8_t PIT_reserved0[236];
  union {                              /* Timer Load Value Register */
    vuint32_t R;
    struct {
      vuint32_t TSV:32;                /* Timer Start Value */
    } B;
  } RTI_LDVAL;

  union {                              /* Current Timer Value Register */
    vuint32_t R;
    struct {
      vuint32_t TVL:32;                /* Current Timer Value */
    } B;
  } RTI_CVAL;

  union {                              /* Timer Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TIE:1;                 /* Timer Interrupt Enable */
      vuint32_t TEN:1;                 /* Timer Enable Bit */
    } B;
  } RTI_TCTRL;

  union {                              /* Timer Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;                 /* Timer Interrupt Flag. */
    } B;
  } RTI_TFLG;

  struct {
    union {                            /* Timer Load Value Register */
      vuint32_t R;
      struct {
        vuint32_t TSV:32;              /* Timer Start Value */
      } B;
    } LDVAL;
    union {                            /* Current Timer Value Register */
      vuint32_t R;
      struct {
        vuint32_t TVL:32;              /* Current Timer Value */
      } B;
    } CVAL;
    union {                            /* Timer Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t CHN:1;               /* Chain Mode */
        vuint32_t TIE:1;               /* Timer Interrupt Enable */
        vuint32_t TEN:1;               /* Timer Enable */
      } B;
    } TCTRL;
    union {                            /* Timer Flag Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t TIF:1;               /* Timer Interrupt Flag */
      } B;
    } TFLG;
  } TIMER[16];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

struct PLLDIG_tag {

  uint8_t PLLDIG_reserved0[24];
  union {                              /* PLL Calibration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t MFDEN:16;              /* Denominator fo fractional loop division factor. */
      vuint32_t  :14;
    } B;
  } PLLCAL3;
  uint8_t PLLDIG_reserved1[4];
  
  union {                              /* PLLDIG PLL Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t EXPDIE:1;              /* External Power Down Cycle Complete indication interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t LOLRE:1;               /* Loss-of-lock reset enable. */
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLLCR;

  union {                              /* PLLDIG PLL Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t ENPHI1:1;              /* PLL PHI1 Output Enable */
      vuint32_t ENPHI:1;               /* PLL PHI Output Enable */
      vuint32_t EXTPDF:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;                /* Loss-of-lock flag. */
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLLSR;

  union {                              /* PLLDIG PLL Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t RFDPHI1:6;             /* PHI1 reduced frequency divider. */
      vuint32_t  :3;
      vuint32_t RFDPHI:6;              /* PHI reduced frequency divider. */
      vuint32_t  :1;
      vuint32_t PREDIV:3;              /* Input clock predivider. */
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t MFD:8;                 /* Loop multiplication factor divider. */
    } B;
  } PLLDV;

  union {                              /* PLLDIG PLL Frequency Modulation Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SSCGBYP:1;             /* Modulation enable. */
      vuint32_t MODSEL:1;              /* Modulation selection. */
      vuint32_t  :3;
      vuint32_t MODPRD:10;             /* Modulation period. */
      vuint32_t  :5;
      vuint32_t INCSTP:11;             /* Increment step. */
    } B;
  } PLLFM;

  union {                              /* PLLDIG PLL Fractional Divide Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t SMDEN:1;               /* Sigma Delta Modulation Enable */
      vuint32_t SDM2:1;                /* Second Order Sigma Delta Modulation Select */
      vuint32_t SDM3:1;                /* Third Order Sigma Delta Modulation Select */
      vuint32_t  :6;
      vuint32_t DTHRCTL:4;             /* Dither Control. */
      vuint32_t DTHDIS:2;              /* Dither Disable. */
      vuint32_t  :1;
      vuint32_t MFN:15;
    } B;
  } PLLFD;
};


/* ============================================================================
   =============================== Module: PMCDIG =============================
   ============================================================================ */

struct PMCDIG_tag {
  union {                              /* RAM Domain Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t MEM_SLEEP_EN:1;        /* Memory Sleep Enable */
      vuint32_t  :3;
      vuint32_t PAD_KEEP_EN:1;         /* PAD Keeper Enable */
      vuint32_t  :7;
      vuint32_t RD256_RET:1;           /* RAM Domain 256K Retention */
      vuint32_t  :3;
      vuint32_t RD128_RET:1;           /* RAM Domain 128K Retention */
      vuint32_t  :3;
      vuint32_t RD64_RET:1;            /* RAM Domain 64K Retention */
    } B;
  } RDCR;

  union {                              /* Supply Gauge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t LP_STATUS:2;           /* Low Power Status */
      vuint32_t  :1;
      vuint32_t HVD_LV_cold:1;         /* HVD LV PD2 Flag */
      vuint32_t  :1;
      vuint32_t LVD_FLASH:1;           /* LVD VDD_HV_ FLA Flag */
      vuint32_t LVD_IO_A_HI:1;         /* LVD IO Segment A High Flag */
      vuint32_t LVD_IO_A_LO:1;         /* LVD IO Segment A Low Flag */
      vuint32_t LVD_LV_PD0_hot:1;      /* LVD VDD_LV PD0 hot point Flag */
      vuint32_t LVD_LV_PD1_hot:1;      /* LVD VDD_LV PD1 hot point Flag */
      vuint32_t LVD_LV_PD2_cold:1;     /* LVD_LV_PD2 Cold Point Flag */
      vuint32_t LVD_LV_PD2_hot:1;      /* LVD LV_PD2 hot Point Flag */
      vuint32_t POR_LV:1;              /* Power On Reset Flag */
    } B;
  } SGSR;

  uint8_t PMCDIG_reserved0[8];
  union {                              /* MISC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t  :3;
      vuint32_t  :1;
      vuint32_t  :7;
      vuint32_t LP_ST_CHG_IN_PRGRS:1;  /* Low Power State Change in Progress */
      vuint32_t FLASH_LP_FAST_EXIT_DIS:1; /* Flash Low Power Fast Exit Disable */
      vuint32_t  :3;
      vuint32_t LVD_PD2_COLD_REE:1;    /* LVD_PD2 Cold Point Flag Reset Event Enable */
      vuint32_t HVD_REE:1;             /* HVD Reset Event Enable */
      vuint32_t  :1;
      vuint32_t LVD_IO_HI_REE:1;       /* LVD_IO_HI Reset Event Enable */
      vuint32_t  :5;
      vuint32_t  :3;
    } B;
  } MCR;
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

struct PRAMC_tag {
  union {                              /* Platform RAM Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t FT_DIS:1;              /* Flow through disabled. */
    } B;
  } PRCR1;
};


/* ============================================================================
   =============================== Module: RTC ================================
   ============================================================================ */

struct RTC_tag {
  union {                              /* RTC Supervisor Control register */
    vuint32_t R;
    struct {
      vuint32_t SUPV:1;                /* RTC Supervisor Bit. */
      vuint32_t  :31;                  /* Reserved. */
    } B;
  } RTCSUPV;

  union {                              /* RTC Control register */
    vuint32_t R;
    struct {
      vuint32_t CNTEN:1;               /* Counter Enable. */
      vuint32_t RTCIE:1;               /* RTC Interrupt Enable. */
      vuint32_t FRZEN:1;               /* Freeze Enable Bit. */
      vuint32_t ROVREN:1;              /* Counter Roll Over Wakeup/Interrupt Enable. */
      vuint32_t  :12;                  /* Reserved. */
      vuint32_t APIEN:1;               /* Autonomous Periodic Interrupt Enable. */
      vuint32_t APIIE:1;               /* API Interrupt Enable. */
      vuint32_t CLKSEL:2;              /* Clock Select. */
      vuint32_t DIV512EN:1;            /* Divide by 512 enable. */
      vuint32_t DIV32EN:1;             /* Divide by 32 enable. */
      vuint32_t  :9;                   /* Reserved. */
      vuint32_t TRIG_EN:1;             /* Trigger enable for Analog Comparator */
    } B;
  } RTCC;

  union {                              /* RTC Status register */
    vuint32_t R;
    struct {
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t RTCF:1;                /* RTC Interrupt Flag. */
      vuint32_t  :10;                  /* Reserved. */
      vuint32_t INV_RTC:1;             /* Invalid rtc write */
      vuint32_t INV_API:1;             /* Invalid APIVAL write */
      vuint32_t INV_ANL:1;             /* Invalid ANLCMP write */
      vuint32_t  :2;
      vuint32_t APIF:1;                /* API Interrupt Flag. */
      vuint32_t  :2;                   /* Reserved. */
      vuint32_t ROVRF:1;               /* Counter Roll Over Interrupt Flag. */
      vuint32_t  :10;                  /* Reserved. */
    } B;
  } RTCS;

  union {                              /* RTC Counter register */
    vuint32_t R;
    struct {
      vuint32_t RTCCNT:32;             /* RTC Counter Value. */
    } B;
  } RTCCNT;

  union {                              /* API Compare Value register */
    vuint32_t R;
    struct {
      vuint32_t APIVAL:32;             /* API Compare Value. */
    } B;
  } APIVAL;

  union {                              /* RTC Compare Value register */
    vuint32_t R;
    struct {
      vuint32_t RTCVAL:32;             /* RTC Compare Value. */
    } B;
  } RTCVAL;

  union {                              /* RTC Analogue comparator count register */
    vuint32_t R;
    struct {
      vuint32_t ANLCMP:32;             /* The trigger_en_out pulse will be generated (after the generation of wakeup_api signal) as per the number of API clocks programmed into this register. */
    } B;
  } ANLCMP_CNT;
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

struct SEMA42_tag {
  union {                              /* Gate Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t GTFSM:4;                /* Gate Finite State Machine. */
    } B;
  } GATE[16];

  uint8_t SEMA42_reserved0[48];
  union {
     union {                          /* Reset Gate Read */
        vuint16_t R;
        struct {
          vuint16_t  :2;
          vuint16_t RSTGSM:2;
          vuint16_t RSTGMS:4;
          vuint16_t RSTGTN:8;
        } B;
      } R;
    union {                            /* Reset Gate Write */
      vuint16_t R;
      struct {
        vuint16_t RSTGDP:8;
        vuint16_t RSTGTN:8;
      } B;
    } W;
  } RSTGT;
};


/* ============================================================================
   =============================== Module: SIRC ===============================
   ============================================================================ */

struct SIRC_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SIRCTRIM:8;            /* SIRC TRIM */
      vuint32_t  :3;
      vuint32_t SIRCDIV:5;             /* The SIRC Divider bits select the clock divider . factor */
      vuint32_t  :3;
      vuint32_t SIRCS:1;               /* Describes the SIRC clock status. */
      vuint32_t  :3;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  union {                              /* SIUL2 MCU ID Register #1 */
    vuint32_t R;
    struct {
      vuint32_t PARTNUM:16;            /* MCU Part Number */
      vuint32_t  :1;
      vuint32_t PKG:5;                 /* Package Settings */
      vuint32_t  :2;
      vuint32_t MAJOR_MASK:4;          /* Major Mask Revision */
      vuint32_t MINOR_MASK:4;          /* Minor Mask Revision */
    } B;
  } MIDR1;

  union {                              /* SIUL2 MCU ID Register #2 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FLASH_SIZE_1:4;        /* Coarse granularity for flash memory size */
      vuint32_t FLASH_SIZE_2:4;        /* Fine granularity for flash memory size */
      vuint32_t  :7;
      vuint32_t PARTNUM:8;             /* ASCII character in MCU Part Number */
      vuint32_t  :8;
    } B;
  } MIDR2;

  uint8_t SIUL2_reserved1[4];
  union {                              /* SIUL2 Interrupt Status Flag Register0 */
    vuint32_t R;
    struct {
      vuint32_t EIF31:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF30:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF29:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF28:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF27:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF26:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF25:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF24:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF23:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF22:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF21:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF20:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF19:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF18:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF17:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF16:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF15:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF14:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF13:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF12:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF11:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF10:1;               /* External Interrupt Status Flag x */
      vuint32_t EIF9:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF8:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF7:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF6:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF5:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF4:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF3:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF2:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF1:1;                /* External Interrupt Status Flag x */
      vuint32_t EIF0:1;                /* External Interrupt Status Flag x */
    } B;
  } ISR0;

  uint8_t SIUL2_reserved2[4];
  union {                              /* SIUL2 Interrupt Request Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t EIRE31:1;
      vuint32_t EIRE30:1;
      vuint32_t EIRE29:1;
      vuint32_t EIRE28:1;
      vuint32_t EIRE27:1;
      vuint32_t EIRE26:1;
      vuint32_t EIRE25:1;
      vuint32_t EIRE24:1;
      vuint32_t EIRE23:1;
      vuint32_t EIRE22:1;
      vuint32_t EIRE21:1;
      vuint32_t EIRE20:1;
      vuint32_t EIRE19:1;
      vuint32_t EIRE18:1;
      vuint32_t EIRE17:1;
      vuint32_t EIRE16:1;
      vuint32_t EIRE15:1;
      vuint32_t EIRE14:1;
      vuint32_t EIRE13:1;
      vuint32_t EIRE12:1;
      vuint32_t EIRE11:1;
      vuint32_t EIRE10:1;
      vuint32_t EIRE9:1;
      vuint32_t EIRE8:1;
      vuint32_t EIRE7:1;
      vuint32_t EIRE6:1;
      vuint32_t EIRE5:1;
      vuint32_t EIRE4:1;
      vuint32_t EIRE3:1;
      vuint32_t EIRE2:1;
      vuint32_t EIRE1:1;
      vuint32_t EIRE0:1;
    } B;
  } IRER0;

  uint8_t SIUL2_reserved3[4];
  union {                              /* SIUL2 Interrupt Request Select Register0 */
    vuint32_t R;
    struct {
      vuint32_t DIRSR31:1;
      vuint32_t DIRSR30:1;
      vuint32_t DIRSR29:1;
      vuint32_t DIRSR28:1;
      vuint32_t DIRSR27:1;
      vuint32_t DIRSR26:1;
      vuint32_t DIRSR25:1;
      vuint32_t DIRSR24:1;
      vuint32_t DIRSR23:1;
      vuint32_t DIRSR22:1;
      vuint32_t DIRSR21:1;
      vuint32_t DIRSR20:1;
      vuint32_t DIRSR19:1;
      vuint32_t DIRSR18:1;
      vuint32_t DIRSR17:1;
      vuint32_t DIRSR16:1;
      vuint32_t DIRSR15:1;
      vuint32_t DIRSR14:1;
      vuint32_t DIRSR13:1;
      vuint32_t DIRSR12:1;
      vuint32_t DIRSR11:1;
      vuint32_t DIRSR10:1;
      vuint32_t DIRSR9:1;
      vuint32_t DIRSR8:1;
      vuint32_t DIRSR7:1;
      vuint32_t DIRSR6:1;
      vuint32_t DIRSR5:1;
      vuint32_t DIRSR4:1;
      vuint32_t DIRSR3:1;
      vuint32_t DIRSR2:1;
      vuint32_t DIRSR1:1;
      vuint32_t DIRSR0:1;
    } B;
  } IRSR0;

  uint8_t SIUL2_reserved4[4];
  union {                              /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IREE31:1;
      vuint32_t IREE30:1;
      vuint32_t IREE29:1;
      vuint32_t IREE28:1;
      vuint32_t IREE27:1;
      vuint32_t IREE26:1;
      vuint32_t IREE25:1;
      vuint32_t IREE24:1;
      vuint32_t IREE23:1;
      vuint32_t IREE22:1;
      vuint32_t IREE21:1;
      vuint32_t IREE20:1;
      vuint32_t IREE19:1;
      vuint32_t IREE18:1;
      vuint32_t IREE17:1;
      vuint32_t IREE16:1;
      vuint32_t IREE15:1;
      vuint32_t IREE14:1;
      vuint32_t IREE13:1;
      vuint32_t IREE12:1;
      vuint32_t IREE11:1;
      vuint32_t IREE10:1;
      vuint32_t IREE9:1;
      vuint32_t IREE8:1;
      vuint32_t IREE7:1;
      vuint32_t IREE6:1;
      vuint32_t IREE5:1;
      vuint32_t IREE4:1;
      vuint32_t IREE3:1;
      vuint32_t IREE2:1;
      vuint32_t IREE1:1;
      vuint32_t IREE0:1;
    } B;
  } IREER0;

  uint8_t SIUL2_reserved5[4];
  union {                              /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IFEE31:1;
      vuint32_t IFEE30:1;
      vuint32_t IFEE29:1;
      vuint32_t IFEE28:1;
      vuint32_t IFEE27:1;
      vuint32_t IFEE26:1;
      vuint32_t IFEE25:1;
      vuint32_t IFEE24:1;
      vuint32_t IFEE23:1;
      vuint32_t IFEE22:1;
      vuint32_t IFEE21:1;
      vuint32_t IFEE20:1;
      vuint32_t IFEE19:1;
      vuint32_t IFEE18:1;
      vuint32_t IFEE17:1;
      vuint32_t IFEE16:1;
      vuint32_t IFEE15:1;
      vuint32_t IFEE14:1;
      vuint32_t IFEE13:1;
      vuint32_t IFEE12:1;
      vuint32_t IFEE11:1;
      vuint32_t IFEE10:1;
      vuint32_t IFEE9:1;
      vuint32_t IFEE8:1;
      vuint32_t IFEE7:1;
      vuint32_t IFEE6:1;
      vuint32_t IFEE5:1;
      vuint32_t IFEE4:1;
      vuint32_t IFEE3:1;
      vuint32_t IFEE2:1;
      vuint32_t IFEE1:1;
      vuint32_t IFEE0:1;
    } B;
  } IFEER0;

  uint8_t SIUL2_reserved6[4];
  union {                              /* SIUL2 Interrupt Filter Enable Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IFE31:1;
      vuint32_t IFE30:1;
      vuint32_t IFE29:1;
      vuint32_t IFE28:1;
      vuint32_t IFE27:1;
      vuint32_t IFE26:1;
      vuint32_t IFE25:1;
      vuint32_t IFE24:1;
      vuint32_t IFE23:1;
      vuint32_t IFE22:1;
      vuint32_t IFE21:1;
      vuint32_t IFE20:1;
      vuint32_t IFE19:1;
      vuint32_t IFE18:1;
      vuint32_t IFE17:1;
      vuint32_t IFE16:1;
      vuint32_t IFE15:1;
      vuint32_t IFE14:1;
      vuint32_t IFE13:1;
      vuint32_t IFE12:1;
      vuint32_t IFE11:1;
      vuint32_t IFE10:1;
      vuint32_t IFE9:1;
      vuint32_t IFE8:1;
      vuint32_t IFE7:1;
      vuint32_t IFE6:1;
      vuint32_t IFE5:1;
      vuint32_t IFE4:1;
      vuint32_t IFE3:1;
      vuint32_t IFE2:1;
      vuint32_t IFE1:1;
      vuint32_t IFE0:1;
    } B;
  } IFER0;

  uint8_t SIUL2_reserved7[4];
  union {                              /* SIUL2 Interrupt Filter Maximum Counter Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t MAXCNT:4;              /* Maximum Interrupt Filter Counter setting */
    } B;
  } IFMCR[32];

  union {                              /* SIUL2 Interrupt Filter Clock Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IFCP:4;                /* Interrupt Filter Clock Prescaler setting */
    } B;
  } IFCPR;

  uint8_t SIUL2_reserved8[380];
  union {                              /* SIUL2 Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t SRC:2;                 /* Slew Rate Control */
      vuint32_t  :2;
      vuint32_t OBE:1;                 /* GPIO Output Buffer Enable */
      vuint32_t ODE:1;                 /* Open Drain Enable */
      vuint32_t SMC:1;                 /* Safe Mode Control */
      vuint32_t APC:1;                 /* Analog Pad Control */
      vuint32_t  :1;
      vuint32_t TTL:1;                 /* TTL/Automotive mode selection */
      vuint32_t IBE:1;                 /* Input Buffer Enable */
      vuint32_t HYS:1;                 /* Input Hysteresis */
      vuint32_t PUS:1;                 /* Pull Select */
      vuint32_t PUE:1;                 /* Pull Enable */
      vuint32_t  :8;
      vuint32_t  :4;
      vuint32_t SSS:4;                 /* Source Signal Select */
    } B;
  } MSCR[264];

  uint8_t SIUL2_reserved9[992];
  union {                              /* SIUL2 Input Multiplexed Signal Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t  :4;
      vuint32_t SSS:4;                 /* Source Signal Select */
    } B;
  } IMCR[512];

  uint8_t SIUL2_reserved10[192];
  union {                              /* SIUL2 GPIO Pad Data Output Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDO_4n:1;					     /* Pad Data Out */
    } B;
  } GPDO[264];

  uint8_t SIUL2_reserved11[248];
  union {                              /* SIUL2 GPIO Pad Data Input Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDI_4n:1;					     /* Pad Data In */
    } B;
  } GPDI[264];

  uint8_t SIUL2_reserved12[248];
  union {                              /* SIUL2 Parallel GPIO Pad Data Out Register */
    vuint16_t R;
    struct {
      vuint16_t PPDO:16;               /* Parallel Pad Data Out */
    } B;
  } PGPDO[32];

  union {                              /* SIUL2 Parallel GPIO Pad Data In Register */
    vuint16_t R;
    struct {
      vuint16_t PPDI:16;               /* Parallel Pad Data In */
    } B;
  } PGPDI[32];

  union {                              /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
    vuint32_t R;
    struct {
      vuint32_t MASK:16;               /* Mask Field */
      vuint32_t MPPDO:16;              /* Masked Parallel Pad Data Out */
    } B;
  } MPGPDO[32];
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

struct SMPU_tag {
  union {                              /* Control/Error Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MERR:16;               /* Master n error, where the bus master number matches the bit number */
      vuint32_t  :12;
      vuint32_t HRL:3;                 /* Hardware revision level */
      vuint32_t GVLD:1;                /* Global Valid (global enable/disable for the SMPU) */
    } B;
  } CES0;

  union {                              /* Control/Error Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MEOVR:16;              /* Master n error overrun, where the bus master number matches the bit number */
      vuint32_t  :12;
      vuint32_t NRGD:4;                /* Number of region descriptors */
    } B;
  } CES1;

  uint8_t SMPU_reserved0[248];
  struct {
    union {                            /* Error Address Register, Bus Master */
      vuint32_t R;
      struct {
        vuint32_t EADDR:32;            /* Error address */
      } B;
    } ADR;
    union {                            /* Error Attribute Detail Register, Bus Master */
      vuint32_t R;
      struct {
        vuint32_t PID:8;
        vuint32_t  :14;
        vuint32_t EATTR:2;             /* Error attributes */
        vuint32_t ERW:1;               /* Error read/write */
        vuint32_t EMN:7;               /* Error master number */
      } B;
    } ADTL;
    union {                            /* Error Attribute Control Detail Register, Bus Master */
      vuint32_t R;
      struct {
        vuint32_t EACD:24;             /* Error access control detail */
        vuint32_t  :8;
      } B;
    } ACDL;
    uint8_t ERROR_reserved0[4];
  } ERROR[16];

  uint8_t SMPU_reserved1[512];
  struct {
    union {                            /* Region Descriptor n, Word 0 */
      vuint32_t R;
      struct {
        vuint32_t SRTADDR:28;          /* Start address */
        vuint32_t RD_UNRW0:4;
      } B;
    } WORD0;
    union {                            /* Region Descriptor n, Word 1 */
      vuint32_t R;
      struct {
        vuint32_t ENDADDR:28;          /* End address */
        vuint32_t RD_UNRW1:4;
      } B;
    } WORD1;
    union {
      union {                          /* Region Descriptor n, Word 2 Format 0 */
        vuint32_t R;
        struct {
          vuint32_t M0P:2;             /* Bus master 0 permissions */
          vuint32_t M1P:2;             /* Bus master 1 permissions */
          vuint32_t M2P:2;             /* Bus master 2 permissions */
          vuint32_t M3P:2;             /* Bus master 3 permissions */
          vuint32_t M4P:2;             /* Bus master 4 permissions */
          vuint32_t M5P:2;             /* Bus master 5 permissions */
          vuint32_t M6P:2;             /* Bus master 6 permissions */
          vuint32_t M7P:2;             /* Bus master 7 permissions */
          vuint32_t M8P:2;             /* Bus master 8 permissions */
          vuint32_t M9P:2;             /* Bus master 9 permissions */
          vuint32_t M10P:2;            /* Bus master 10 permissions */
          vuint32_t M11P:2;            /* Bus master 11 permissions */
          vuint32_t M12P:2;            /* Bus master 12 permissions */
          vuint32_t M13P:2;            /* Bus master 13 permissions */
          vuint32_t M14P:2;            /* Bus master 14 permissions */
          vuint32_t M15P:2;            /* Bus master 15 permissions */
        } B;
      } FMT0;
      union {                          /* Region Descriptor n, Word 2 Format 1 */
        vuint32_t R;
        struct {
          vuint32_t M0S:2;             /* Bus master 0 permission select */
          vuint32_t M1S:2;             /* Bus master 1 permission select */
          vuint32_t M2S:2;             /* Bus master 2 permission select */
          vuint32_t M3S:2;             /* Bus master 3 permission select */
          vuint32_t M4S:2;             /* Bus master 4 permission select */
          vuint32_t M5S:2;             /* Bus master 5 permission select */
          vuint32_t M6S:2;             /* Bus master 6 permission select */
          vuint32_t M7S:2;             /* Bus master 7 permission select */
          vuint32_t M8S:2;             /* Bus master 8 permission select */
          vuint32_t M9S:2;             /* Bus master 9 permission select */
          vuint32_t M10S:2;            /* Bus master 10 permission select */
          vuint32_t M11S:2;            /* Bus master 11 permission select */
          vuint32_t M12S:2;            /* Bus master 12 permission select */
          vuint32_t M13S:2;            /* Bus master 13 permission select */
          vuint32_t M14S:2;            /* Bus master 14 permission select */
          vuint32_t M15S:2;            /* Bus master 15 permission select */
        } B;
      } FMT1;
    } WORD2;
    union {                            /* Region Descriptor n, Word 3 */
      vuint32_t R;
      struct {
        vuint32_t ACCSET1:6;           /* Access controls, Set 1 */
        vuint32_t ACCSET2:6;           /* Access controls, Set 2 */
        vuint32_t ACCSET3:6;           /* Access controls, Set 3 */
        vuint32_t  :9;
        vuint32_t FMT:1;               /* Region Descriptor Format */
        vuint32_t  :2;
        vuint32_t CI:1;                /* Cache Inhibit */
        vuint32_t  :1;
      } B;
    } WORD3;
    union {                            /* Region Descriptor n, Word 4 */
      vuint32_t R;
      struct {
        vuint32_t PID:8;               /* Process Identifier */
        vuint32_t PID_MASK:8;          /* Process Identifier Mask */
        vuint32_t  :15;
        vuint32_t PIDEN:1;             /* Region Descriptor PID Enable */
      } B;
    } WORD4;
    union {                            /* Region Descriptor n, Word 5 */
      vuint32_t R;
      struct {
        vuint32_t MID:8;               /* Master ID of RGDn owner */
        vuint32_t  :20;
        vuint32_t LCK:2;               /* Region Descriptor Lock */
        vuint32_t  :1;
        vuint32_t VLD:1;               /* Valid */
      } B;
    } WORD5;
    uint8_t RGD_reserved0[40];
  } RGD[16];
};


/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

struct SPI_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSTR:1;                /* Master/Slave Mode Select */
      vuint32_t CONT_SCKE:1;           /* Continuous SCK Enable */
      vuint32_t DCONF:2;               /* SPI Configuration. */
      vuint32_t FRZ:1;                 /* Freeze */
      vuint32_t MTFE:1;                /* Modified Timing Format Enable */
      vuint32_t PCSSE:1;               /* Peripheral Chip Select Strobe Enable */
      vuint32_t ROOE:1;                /* Receive FIFO Overflow Overwrite Enable */
      vuint32_t  :2;
      vuint32_t PCSIS:6;               /* Peripheral Chip Select x Inactive State */
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* Module Disable */
      vuint32_t DIS_TXF:1;             /* Disable Transmit FIFO */
      vuint32_t DIS_RXF:1;             /* Disable Receive FIFO */
      vuint32_t CLR_TXF:1;             /* Clear TX FIFO */
      vuint32_t CLR_RXF:1;             /* CLR_RXF */
      vuint32_t SMPL_PT:2;             /* Sample Point */
      vuint32_t  :4;
      vuint32_t XSPI:1;                /* Extended SPI Mode */
      vuint32_t FCPCS:1;               /* Fast Continuous PCS Mode. */
      vuint32_t PES:1;                 /* Parity Error Stop */
      vuint32_t HALT:1;                /* Halt */
    } B;
  } MCR;

  uint8_t SPI_reserved0[4];
  union {                              /* Transfer Count Register */
    vuint32_t R;
    struct {
      vuint32_t SPI_TCNT:16;           /* SPI Transfer Counter */
      vuint32_t  :16;
    } B;
  } TCR;

  union {
    union {                            /* Clock and Transfer Attributes Register (In Master Mode) */
      vuint32_t R;
      struct {
        vuint32_t DBR:1;               /* Double Baud Rate */
        vuint32_t FMSZ:4;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t LSBFE:1;             /* LSB First */
        vuint32_t PCSSCK:2;            /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;              /* After SCK Delay Prescaler */
        vuint32_t PDT:2;               /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;               /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;             /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;               /* After SCK Delay Scaler */
        vuint32_t DT:4;                /* Delay After Transfer Scaler */
        vuint32_t BR:4;                /* Baud Rate Scaler */
      } B;
    } CTAR[6];
    union {                            /* Clock and Transfer Attributes Register (In Slave Mode) */
      vuint32_t R;
      struct {
        vuint32_t FMSZ:5;              /* Frame Size */
        vuint32_t CPOL:1;              /* Clock Polarity */
        vuint32_t CPHA:1;              /* Clock Phase */
        vuint32_t PE:1;                /* Parity Enable */
        vuint32_t PP:1;                /* Parity Polarity */
        vuint32_t  :1;
        vuint32_t  :22;
      } B;
    } CTAR_SLAVE[2];
  } MODE;

  uint8_t SPI_reserved1[8];
  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t TCF:1;                 /* Transfer Complete Flag */
      vuint32_t TXRXS:1;               /* TX and RX Status */
      vuint32_t  :1;
      vuint32_t EOQF:1;                /* End of Queue Flag */
      vuint32_t TFUF:1;                /* Transmit FIFO Underflow Flag */
      vuint32_t  :1;
      vuint32_t TFFF:1;                /* Transmit FIFO Fill Flag */
      vuint32_t BSYF:1;                /* Busy Flag. */
      vuint32_t CMDTCF:1;              /* Command Transfer Complete Flag. */
      vuint32_t  :1;
      vuint32_t SPEF:1;                /* SPI Parity Error Flag */
      vuint32_t  :1;
      vuint32_t RFOF:1;                /* Receive FIFO Overflow Flag */
      vuint32_t TFIWF:1;               /* Tranmit FIFO Invalid Write Flag */
      vuint32_t RFDF:1;                /* Receive FIFO Drain Flag */
      vuint32_t CMDFFF:1;              /* Command FIFO Fill Flag */
      vuint32_t TXCTR:4;               /* TX FIFO Counter */
      vuint32_t TXNXTPTR:4;            /* Transmit Next Pointer */
      vuint32_t RXCTR:4;               /* RX FIFO Counter */
      vuint32_t POPNXTPTR:4;           /* Pop Next Pointer */
    } B;
  } SR;

  union {                              /* DMA/Interrupt Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t TCF_RE:1;              /* Transmission Complete Request Enable */
      vuint32_t CMDFFF_RE:1;           /* Command FIFO Fill Flag Request Enable. */
      vuint32_t  :1;
      vuint32_t EOQF_RE:1;             /* Finished Request Enable */
      vuint32_t TFUF_RE:1;             /* Transmit FIFO Underflow Request Enable */
      vuint32_t  :1;
      vuint32_t TFFF_RE:1;             /* Transmit FIFO Fill Request Enable */
      vuint32_t TFFF_DIRS:1;           /* Transmit FIFO Fill DMA or Interrupt Request Select */
      vuint32_t CMDTCF_RE:1;           /* Command Transmission Complete Request Enable. */
      vuint32_t  :1;
      vuint32_t SPEF_RE:1;             /* SPI Parity Error Request Enable */
      vuint32_t  :1;
      vuint32_t RFOF_RE:1;             /* Receive FIFO Overflow Request Enable */
      vuint32_t TFIWF_RE:1;            /* Transmit FIFO Invalid Write Request Enable. */
      vuint32_t RFDF_RE:1;             /* Receive FIFO Drain Request Enable */
      vuint32_t RFDF_DIRS:1;           /* Receive FIFO Drain DMA or Interrupt Request Select */
      vuint32_t CMDFFF_DIRS:1;         /* Command FIFO Fill DMA or Interrupt Request Select */
      vuint32_t DDIF_DIRS:1;           /* DSI data received with active bits - DMA or Interrupt Request Select. */
      vuint32_t  :14;
    } B;
  } RSER;

  union {
    union {                            /* PUSH TX FIFO Register In Master Mode */
      vuint32_t R;
      struct {
        vuint32_t CONT:1;              /* Continuous Peripheral Chip Select Enable */
        vuint32_t CTAS:3;              /* Clock and Transfer Attributes Select */
        vuint32_t EOQ:1;               /* End Of Queue */
        vuint32_t CTCNT:1;             /* Clear Transfer Counter */
        vuint32_t PE_MASC:1;           /* Parity Enable or Mask T ASC delay in the current frame */
        vuint32_t PP_MCSC:1;           /* Parity Polarity or Mask T CSC delay in the next frame */
        vuint32_t  :2;
        vuint32_t PCS:6;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR;
    union {                            /* PUSH TX FIFO Register In Slave Mode */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t TXDATA:16;           /* Transmit Data */
      } B;
    } PUSHR_SLAVE;
  } PUSHR;

  union {                              /* POP RX FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Received Data */
    } B;
  } POPR;

  union {                              /* Transmit FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t TXCMD_TXDATA:16;       /* Transmit Command or Transmit Data */
      vuint32_t TXDATA:16;             /* Transmit Data */
    } B;
  } TXFR[4];

  uint8_t SPI_reserved2[48];
  union {                              /* Receive FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;             /* Receive Data */
    } B;
  } RXFR[4];

  uint8_t SPI_reserved3[144];
  union {                              /* Clock and Transfer Attributes Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t FMSZE:1;               /* Frame Size Extended */
      vuint32_t  :5;
      vuint32_t DTCP:11;               /* Data Transfer Count Preload */
    } B;
  } CTARE[6];

  uint8_t SPI_reserved4[8];
  union {                              /* Status Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t RXCTR4:1;              /* RX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t TXCTR4:1;              /* TX FIFO Counter[4] */
      vuint32_t  :2;
      vuint32_t CMDCTR:5;              /* CMD FIFO Counter */
      vuint32_t CMDNXTPTR:4;           /* Command Next Pointer */
    } B;
  } SREX;

  union {                              /* Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t ENABLE:1;              /* Trigger Register Enable */
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t ASDR_WT:1;             /* ASDR Write Trigger Enable */
      vuint32_t CID:1;                 /* Change In Data Transfer Enable */
      vuint32_t TRRE:1;                /* Trigger Reception Enable */
    } B;
  } TRIG;
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

struct SSCM_tag {
  union {                              /* SSCM System Status */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t CER:1;                 /* Configuration Error */
      vuint16_t CERS:1;                /* Configuration Error for Safe DCF Clients */
      vuint16_t  :1;
      vuint16_t NXEN:1;                /* Processor 0 Nexus enable status */
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t BMODE:3;               /* Device Boot Mode */
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :2;
    } B;
  } STATUS;

  union {                              /* SSCM System Memory and ID Register */
    vuint16_t R;
    struct {
      vuint16_t JPIN:10;
      vuint16_t  :1;
      vuint16_t MREV:4;                /* Minor Mask Revision */
      vuint16_t  :1;
    } B;
  } MEMCONFIG;

  uint8_t SSCM_reserved0[4];
  union {                              /* SSCM Debug Status Port Register */
    vuint16_t R;
    struct {
      vuint16_t  :7;
      vuint16_t  :1;
      vuint16_t  :5;
      vuint16_t DEBUG_MODE:3;
    } B;
  } DEBUGPORT;

  uint8_t SSCM_reserved1[22];
  union {                              /* SSCM HSM and User Option Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t HSB:3;                 /* HSM Boot Configuration */
      vuint32_t HSE:1;                 /* HSM Enabled */
    } B;
  } UOPS;

  uint8_t SSCM_reserved2[4];
  union {                              /* Processor Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t SADR:32;               /* Processor Start Address */
    } B;
  } PSA;

  uint8_t SSCM_reserved3[4];
  union {                              /* SSCM HSM Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t HADR:32;               /* HSM Start Address */
    } B;
  } HSA;

  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t LC:3;                  /* Life Cycle */
    } B;
  } LCSTAT;
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

struct STCU2_tag {
  union {                              /* STCU2 Run Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t BYP:1;
      vuint32_t MBPLLEN:1;
      vuint32_t LBPLLEN:1;
      vuint32_t  :7;
      vuint32_t RUN:1;
    } B;
  } RUN;

  union {                              /* STCU2 Run Software Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBIE:1;
      vuint32_t LBIE:1;
      vuint32_t MBSWPLLEN:1;
      vuint32_t LBSWPLLEN:1;
      vuint32_t  :6;
      vuint32_t  :1;
      vuint32_t RUNSW:1;
    } B;
  } RUNSW;

  union {                              /* STCU2 SK Code Register */
    vuint32_t R;
    struct {
      vuint32_t SKC:32;
    } B;
  } SKC;

  union {                              /* STCU2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PTR:7;
      vuint32_t LB_DELAY:8;
      vuint32_t  :7;
      vuint32_t WRP:1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t PMOSEN:1;
      vuint32_t MBU:1;
      vuint32_t CLK_CFG:3;
    } B;
  } CFG;

  uint8_t STCU2_reserved0[4];
  union {                              /* STCU2 Watchdog Register Granularity */
    vuint32_t R;
    struct {
      vuint32_t WDGEOC:32;
    } B;
  } WDG;

  union {                              /* STCU2 Interrupt Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t MBIFLG:1;
      vuint32_t LBIFLG:1;
    } B;
  } INT_FLG;

  uint8_t STCU2_reserved1[8];
  union {                              /* STCU2 Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t ABORTHW:1;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t LOCKESW:1;
      vuint32_t WDTOSW:1;
      vuint32_t  :1;
      vuint32_t ENGESW:1;
      vuint32_t INVPSW:1;
      vuint32_t  :6;
      vuint32_t UFSF:1;
      vuint32_t RFSF:1;
      vuint32_t  :3;
      vuint32_t LOCKE:1;
      vuint32_t WDTO:1;
      vuint32_t  :1;
      vuint32_t ENGE:1;
      vuint32_t INVP:1;
    } B;
  } ERR_STAT;

  union {                              /* STCU2 Error FM Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t LOCKEUFM:1;
      vuint32_t WDTOUFM:1;
      vuint32_t  :1;
      vuint32_t ENGEUFM:1;
      vuint32_t INVPUFM:1;
    } B;
  } ERR_FM;

  union {                              /* STCU2 Off-Line LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t LBS2:1;
      vuint32_t LBS1:1;
      vuint32_t LBS0:1;
    } B;
  } LBS;

  union {                              /* STCU2 Off-Line LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t LBE2:1;
      vuint32_t LBE1:1;
      vuint32_t LBE0:1;
    } B;
  } LBE;

  union {                              /* STCU2 On-Line LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t LBSSW2:1;
      vuint32_t LBSSW1:1;
      vuint32_t LBSSW0:1;
    } B;
  } LBSSW;

  union {                              /* STCU2 On-Line LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t LBESW2:1;
      vuint32_t LBESW1:1;
      vuint32_t LBESW0:1;
    } B;
  } LBESW;

  uint8_t STCU2_reserved2[4];
  union {                              /* STCU2 LBIST Unrecoverable FM Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t LBUFM2:1;
      vuint32_t LBUFM1:1;
      vuint32_t LBUFM0:1;
    } B;
  } LBUFM;

  union {                              /* STCU2 Off-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBS31:1;
      vuint32_t MBS30:1;
      vuint32_t MBS29:1;
      vuint32_t MBS28:1;
      vuint32_t MBS27:1;
      vuint32_t MBS26:1;
      vuint32_t MBS25:1;
      vuint32_t MBS24:1;
      vuint32_t MBS23:1;
      vuint32_t MBS22:1;
      vuint32_t MBS21:1;
      vuint32_t MBS20:1;
      vuint32_t MBS19:1;
      vuint32_t MBS18:1;
      vuint32_t MBS17:1;
      vuint32_t MBS16:1;
      vuint32_t MBS15:1;
      vuint32_t MBS14:1;
      vuint32_t MBS13:1;
      vuint32_t MBS12:1;
      vuint32_t MBS11:1;
      vuint32_t MBS10:1;
      vuint32_t MBS9:1;
      vuint32_t MBS8:1;
      vuint32_t MBS7:1;
      vuint32_t MBS6:1;
      vuint32_t MBS5:1;
      vuint32_t MBS4:1;
      vuint32_t MBS3:1;
      vuint32_t MBS2:1;
      vuint32_t MBS1:1;
      vuint32_t MBS0:1;
    } B;
  } MBSL;

  union {                              /* STCU2 Off-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBS63:1;
      vuint32_t MBS62:1;
      vuint32_t MBS61:1;
      vuint32_t MBS60:1;
      vuint32_t MBS59:1;
      vuint32_t MBS58:1;
      vuint32_t MBS57:1;
      vuint32_t MBS56:1;
      vuint32_t MBS55:1;
      vuint32_t MBS54:1;
      vuint32_t MBS53:1;
      vuint32_t MBS52:1;
      vuint32_t MBS51:1;
      vuint32_t MBS50:1;
      vuint32_t MBS49:1;
      vuint32_t MBS48:1;
      vuint32_t MBS47:1;
      vuint32_t MBS46:1;
      vuint32_t MBS45:1;
      vuint32_t MBS44:1;
      vuint32_t MBS43:1;
      vuint32_t MBS42:1;
      vuint32_t MBS41:1;
      vuint32_t MBS40:1;
      vuint32_t MBS39:1;
      vuint32_t MBS38:1;
      vuint32_t MBS37:1;
      vuint32_t MBS36:1;
      vuint32_t MBS35:1;
      vuint32_t MBS34:1;
      vuint32_t MBS33:1;
      vuint32_t MBS32:1;
    } B;
  } MBSM;

  union {                              /* STCU2 Off-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBS75:1;
      vuint32_t MBS74:1;
      vuint32_t MBS73:1;
      vuint32_t MBS72:1;
      vuint32_t MBS71:1;
      vuint32_t MBS70:1;
      vuint32_t MBS69:1;
      vuint32_t MBS68:1;
      vuint32_t MBS67:1;
      vuint32_t MBS66:1;
      vuint32_t MBS65:1;
      vuint32_t MBS64:1;
    } B;
  } MBSH;

  union {                              /* STCU2 Off-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBE31:1;
      vuint32_t MBE30:1;
      vuint32_t MBE29:1;
      vuint32_t MBE28:1;
      vuint32_t MBE27:1;
      vuint32_t MBE26:1;
      vuint32_t MBE25:1;
      vuint32_t MBE24:1;
      vuint32_t MBE23:1;
      vuint32_t MBE22:1;
      vuint32_t MBE21:1;
      vuint32_t MBE20:1;
      vuint32_t MBE19:1;
      vuint32_t MBE18:1;
      vuint32_t MBE17:1;
      vuint32_t MBE16:1;
      vuint32_t MBE15:1;
      vuint32_t MBE14:1;
      vuint32_t MBE13:1;
      vuint32_t MBE12:1;
      vuint32_t MBE11:1;
      vuint32_t MBE10:1;
      vuint32_t MBE9:1;
      vuint32_t MBE8:1;
      vuint32_t MBE7:1;
      vuint32_t MBE6:1;
      vuint32_t MBE5:1;
      vuint32_t MBE4:1;
      vuint32_t MBE3:1;
      vuint32_t MBE2:1;
      vuint32_t MBE1:1;
      vuint32_t MBE0:1;
    } B;
  } MBEL;

  union {                              /* STCU2 Off-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBE63:1;
      vuint32_t MBE62:1;
      vuint32_t MBE61:1;
      vuint32_t MBE60:1;
      vuint32_t MBE59:1;
      vuint32_t MBE58:1;
      vuint32_t MBE57:1;
      vuint32_t MBE56:1;
      vuint32_t MBE55:1;
      vuint32_t MBE54:1;
      vuint32_t MBE53:1;
      vuint32_t MBE52:1;
      vuint32_t MBE51:1;
      vuint32_t MBE50:1;
      vuint32_t MBE49:1;
      vuint32_t MBE48:1;
      vuint32_t MBE47:1;
      vuint32_t MBE46:1;
      vuint32_t MBE45:1;
      vuint32_t MBE44:1;
      vuint32_t MBE43:1;
      vuint32_t MBE42:1;
      vuint32_t MBE41:1;
      vuint32_t MBE40:1;
      vuint32_t MBE39:1;
      vuint32_t MBE38:1;
      vuint32_t MBE37:1;
      vuint32_t MBE36:1;
      vuint32_t MBE35:1;
      vuint32_t MBE34:1;
      vuint32_t MBE33:1;
      vuint32_t MBE32:1;
    } B;
  } MBEM;

  union {                              /* STCU2 Off-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBE75:1;
      vuint32_t MBE74:1;
      vuint32_t MBE73:1;
      vuint32_t MBE72:1;
      vuint32_t MBE71:1;
      vuint32_t MBE70:1;
      vuint32_t MBE69:1;
      vuint32_t MBE68:1;
      vuint32_t MBE67:1;
      vuint32_t MBE66:1;
      vuint32_t MBE65:1;
      vuint32_t MBE64:1;
    } B;
  } MBEH;

  union {                              /* STCU2 On-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW31:1;
      vuint32_t MBSSW30:1;
      vuint32_t MBSSW29:1;
      vuint32_t MBSSW28:1;
      vuint32_t MBSSW27:1;
      vuint32_t MBSSW26:1;
      vuint32_t MBSSW25:1;
      vuint32_t MBSSW24:1;
      vuint32_t MBSSW23:1;
      vuint32_t MBSSW22:1;
      vuint32_t MBSSW21:1;
      vuint32_t MBSSW20:1;
      vuint32_t MBSSW19:1;
      vuint32_t MBSSW18:1;
      vuint32_t MBSSW17:1;
      vuint32_t MBSSW16:1;
      vuint32_t MBSSW15:1;
      vuint32_t MBSSW14:1;
      vuint32_t MBSSW13:1;
      vuint32_t MBSSW12:1;
      vuint32_t MBSSW11:1;
      vuint32_t MBSSW10:1;
      vuint32_t MBSSW9:1;
      vuint32_t MBSSW8:1;
      vuint32_t MBSSW7:1;
      vuint32_t MBSSW6:1;
      vuint32_t MBSSW5:1;
      vuint32_t MBSSW4:1;
      vuint32_t MBSSW3:1;
      vuint32_t MBSSW2:1;
      vuint32_t MBSSW1:1;
      vuint32_t MBSSW0:1;
    } B;
  } MBSLSW;

  union {                              /* STCU2 On-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW63:1;
      vuint32_t MBSSW62:1;
      vuint32_t MBSSW61:1;
      vuint32_t MBSSW60:1;
      vuint32_t MBSSW59:1;
      vuint32_t MBSSW58:1;
      vuint32_t MBSSW57:1;
      vuint32_t MBSSW56:1;
      vuint32_t MBSSW55:1;
      vuint32_t MBSSW54:1;
      vuint32_t MBSSW53:1;
      vuint32_t MBSSW52:1;
      vuint32_t MBSSW51:1;
      vuint32_t MBSSW50:1;
      vuint32_t MBSSW49:1;
      vuint32_t MBSSW48:1;
      vuint32_t MBSSW47:1;
      vuint32_t MBSSW46:1;
      vuint32_t MBSSW45:1;
      vuint32_t MBSSW44:1;
      vuint32_t MBSSW43:1;
      vuint32_t MBSSW42:1;
      vuint32_t MBSSW41:1;
      vuint32_t MBSSW40:1;
      vuint32_t MBSSW39:1;
      vuint32_t MBSSW38:1;
      vuint32_t MBSSW37:1;
      vuint32_t MBSSW36:1;
      vuint32_t MBSSW35:1;
      vuint32_t MBSSW34:1;
      vuint32_t MBSSW33:1;
      vuint32_t MBSSW32:1;
    } B;
  } MBSMSW;

  union {                              /* STCU2 On-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBSSW75:1;
      vuint32_t MBSSW74:1;
      vuint32_t MBSSW73:1;
      vuint32_t MBSSW72:1;
      vuint32_t MBSSW71:1;
      vuint32_t MBSSW70:1;
      vuint32_t MBSSW69:1;
      vuint32_t MBSSW68:1;
      vuint32_t MBSSW67:1;
      vuint32_t MBSSW66:1;
      vuint32_t MBSSW65:1;
      vuint32_t MBSSW64:1;
    } B;
  } MBSHSW;

  union {                              /* STCU2 On-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW31:1;
      vuint32_t MBESW30:1;
      vuint32_t MBESW29:1;
      vuint32_t MBESW28:1;
      vuint32_t MBESW27:1;
      vuint32_t MBESW26:1;
      vuint32_t MBESW25:1;
      vuint32_t MBESW24:1;
      vuint32_t MBESW23:1;
      vuint32_t MBESW22:1;
      vuint32_t MBESW21:1;
      vuint32_t MBESW20:1;
      vuint32_t MBESW19:1;
      vuint32_t MBESW18:1;
      vuint32_t MBESW17:1;
      vuint32_t MBESW16:1;
      vuint32_t MBESW15:1;
      vuint32_t MBESW14:1;
      vuint32_t MBESW13:1;
      vuint32_t MBESW12:1;
      vuint32_t MBESW11:1;
      vuint32_t MBESW10:1;
      vuint32_t MBESW9:1;
      vuint32_t MBESW8:1;
      vuint32_t MBESW7:1;
      vuint32_t MBESW6:1;
      vuint32_t MBESW5:1;
      vuint32_t MBESW4:1;
      vuint32_t MBESW3:1;
      vuint32_t MBESW2:1;
      vuint32_t MBESW1:1;
      vuint32_t MBESW0:1;
    } B;
  } MBELSW;

  union {                              /* STCU2 On-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW63:1;
      vuint32_t MBESW62:1;
      vuint32_t MBESW61:1;
      vuint32_t MBESW60:1;
      vuint32_t MBESW59:1;
      vuint32_t MBESW58:1;
      vuint32_t MBESW57:1;
      vuint32_t MBESW56:1;
      vuint32_t MBESW55:1;
      vuint32_t MBESW54:1;
      vuint32_t MBESW53:1;
      vuint32_t MBESW52:1;
      vuint32_t MBESW51:1;
      vuint32_t MBESW50:1;
      vuint32_t MBESW49:1;
      vuint32_t MBESW48:1;
      vuint32_t MBESW47:1;
      vuint32_t MBESW46:1;
      vuint32_t MBESW45:1;
      vuint32_t MBESW44:1;
      vuint32_t MBESW43:1;
      vuint32_t MBESW42:1;
      vuint32_t MBESW41:1;
      vuint32_t MBESW40:1;
      vuint32_t MBESW39:1;
      vuint32_t MBESW38:1;
      vuint32_t MBESW37:1;
      vuint32_t MBESW36:1;
      vuint32_t MBESW35:1;
      vuint32_t MBESW34:1;
      vuint32_t MBESW33:1;
      vuint32_t MBESW32:1;
    } B;
  } MBEMSW;

  union {                              /* STCU2 On-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBESW75:1;
      vuint32_t MBESW74:1;
      vuint32_t MBESW73:1;
      vuint32_t MBESW72:1;
      vuint32_t MBESW71:1;
      vuint32_t MBESW70:1;
      vuint32_t MBESW69:1;
      vuint32_t MBESW68:1;
      vuint32_t MBESW67:1;
      vuint32_t MBESW66:1;
      vuint32_t MBESW65:1;
      vuint32_t MBESW64:1;
    } B;
  } MBEHSW;

  union {                              /* STCU2 MBIST Unrecoverable FM Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM31:1;
      vuint32_t MBUFM30:1;
      vuint32_t MBUFM29:1;
      vuint32_t MBUFM28:1;
      vuint32_t MBUFM27:1;
      vuint32_t MBUFM26:1;
      vuint32_t MBUFM25:1;
      vuint32_t MBUFM24:1;
      vuint32_t MBUFM23:1;
      vuint32_t MBUFM22:1;
      vuint32_t MBUFM21:1;
      vuint32_t MBUFM20:1;
      vuint32_t MBUFM19:1;
      vuint32_t MBUFM18:1;
      vuint32_t MBUFM17:1;
      vuint32_t MBUFM16:1;
      vuint32_t MBUFM15:1;
      vuint32_t MBUFM14:1;
      vuint32_t MBUFM13:1;
      vuint32_t MBUFM12:1;
      vuint32_t MBUFM11:1;
      vuint32_t MBUFM10:1;
      vuint32_t MBUFM9:1;
      vuint32_t MBUFM8:1;
      vuint32_t MBUFM7:1;
      vuint32_t MBUFM6:1;
      vuint32_t MBUFM5:1;
      vuint32_t MBUFM4:1;
      vuint32_t MBUFM3:1;
      vuint32_t MBUFM2:1;
      vuint32_t MBUFM1:1;
      vuint32_t MBUFM0:1;
    } B;
  } MBUFML;

  union {                              /* STCU2 MBIST Unrecoverable FM Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM63:1;
      vuint32_t MBUFM62:1;
      vuint32_t MBUFM61:1;
      vuint32_t MBUFM60:1;
      vuint32_t MBUFM59:1;
      vuint32_t MBUFM58:1;
      vuint32_t MBUFM57:1;
      vuint32_t MBUFM56:1;
      vuint32_t MBUFM55:1;
      vuint32_t MBUFM54:1;
      vuint32_t MBUFM53:1;
      vuint32_t MBUFM52:1;
      vuint32_t MBUFM51:1;
      vuint32_t MBUFM50:1;
      vuint32_t MBUFM49:1;
      vuint32_t MBUFM48:1;
      vuint32_t MBUFM47:1;
      vuint32_t MBUFM46:1;
      vuint32_t MBUFM45:1;
      vuint32_t MBUFM44:1;
      vuint32_t MBUFM43:1;
      vuint32_t MBUFM42:1;
      vuint32_t MBUFM41:1;
      vuint32_t MBUFM40:1;
      vuint32_t MBUFM39:1;
      vuint32_t MBUFM38:1;
      vuint32_t MBUFM37:1;
      vuint32_t MBUFM36:1;
      vuint32_t MBUFM35:1;
      vuint32_t MBUFM34:1;
      vuint32_t MBUFM33:1;
      vuint32_t MBUFM32:1;
    } B;
  } MBUFMM;

  union {                              /* STCU2 MBIST Unrecoverable FM High Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBUFM75:1;
      vuint32_t MBUFM74:1;
      vuint32_t MBUFM73:1;
      vuint32_t MBUFM72:1;
      vuint32_t MBUFM71:1;
      vuint32_t MBUFM70:1;
      vuint32_t MBUFM69:1;
      vuint32_t MBUFM68:1;
      vuint32_t MBUFM67:1;
      vuint32_t MBUFM66:1;
      vuint32_t MBUFM65:1;
      vuint32_t MBUFM64:1;
    } B;
  } MBUFMH;

  uint8_t STCU2_reserved3[128];
  struct {
    union {                            /* STCU2 LBIST Control Register */
      vuint32_t R;
      struct {
        vuint32_t CSM:1;
        vuint32_t PTR:7;
        vuint32_t  :4;
        vuint32_t PRPGEN:1;
        vuint32_t SHS:3;
        vuint32_t SCEN_OFF:4;
        vuint32_t SCEN_ON:4;
        vuint32_t  :4;
        vuint32_t PFT:1;
        vuint32_t CWS:3;
      } B;
    } CTRL;
    union {                            /* STCU2 LBIST PC Stop Register */
      vuint32_t R;
      struct {
        vuint32_t  :6;
        vuint32_t PCS:26;
      } B;
    } PCS;
    union {                            /* STCU2 LBIST PRPG Low Register */
      vuint32_t R;
      struct {
        vuint32_t PRPGx:32;
      } B;
    } PRPGL;
    union {                            /* STCU2 LBIST PRPG High Register */
      vuint32_t R;
      struct {
        vuint32_t PRPGx:32;
      } B;
    } PRPGH;
    union {                            /* STCU2 Off-Line LBIST MISR Expected Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISREx:32;
      } B;
    } MISREL;
    union {                            /* STCU2 Off-Line LBIST MISR Expected High Register */
      vuint32_t R;
      struct {
        vuint32_t MISREx:32;
      } B;
    } MISREH;
    union {                            /* STCU2 Off-Line LBIST MISR Read Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRx:32;
      } B;
    } MISRRL;
    union {                            /* STCU2 Off-Line LBIST MISR Read High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRx:32;
      } B;
    } MISRRH;
    union {                            /* STCU2 On-Line LBIST MISR Expected Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } MISRELSW;
    union {                            /* STCU2 On-Line LBIST MISR Expected High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } MISREHSW;
    union {                            /* STCU2 On-Line LBIST MISR Read Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;
      } B;
    } MISRRLSW;
    union {                            /* STCU2 On-Line LBIST MISR Read High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;
      } B;
    } MISRRHSW;
    uint8_t LB_reserved0[16];
  } LB[3];

  uint8_t STCU2_reserved4[1088];
  union {                              /* STCU2 MBIST Control Register */
    vuint32_t R;
    struct {
      vuint32_t CSM:1;
      vuint32_t PTR:7;
      vuint32_t  :24;
    } B;
  } MB_CTRL[76];
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

struct STM_tag {
  union {                              /* STM Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CPS:8;                 /* Counter Prescaler. */
      vuint32_t  :3;
	  vuint32_t CSL:1;                 /* Clock Selection. */
	  vuint32_t  :2;
      vuint32_t FRZ:1;                 /* Freeze. */
      vuint32_t TEN:1;                 /* Timer counter Enabled. */
    } B;
  } CR;

  union {                              /* STM Count Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;                /* Timer count value used as the time base for all channels. */
    } B;
  } CNT;

  uint8_t STM_reserved0[8];
  struct {
    union {                            /* STM Channel Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CEN:1;               /* Channel Enable */
      } B;
    } CCR;
    union {                            /* STM Channel Interrupt Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CIF:1;               /* Channel Interrupt Flag */
      } B;
    } CIR;
    union {                            /* STM Channel Compare Register */
      vuint32_t R;
      struct {
        vuint32_t CMP:32;              /* Compare value for channel n. */
      } B;
    } CMP;
    uint8_t CHANNEL_reserved0[4];
  } CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

struct SWT_tag {
  union {                              /* SWT Control Register */
    vuint32_t R;
    struct {
      vuint32_t MAP0:1;
      vuint32_t MAP1:1;
      vuint32_t MAP2:1;
      vuint32_t MAP3:1;
      vuint32_t MAP4:1;
      vuint32_t MAP5:1;
      vuint32_t MAP6:1;
      vuint32_t MAP7:1;
      vuint32_t  :13;
      vuint32_t SMD:2;                 /* Service Mode. */
      vuint32_t RIA:1;
      vuint32_t WND:1;
      vuint32_t ITR:1;
      vuint32_t HLK:1;
      vuint32_t SLK:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t STP:1;
      vuint32_t FRZ:1;
      vuint32_t WEN:1;
    } B;
  } CR;

  union {                              /* SWT Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;
    } B;
  } IR;

  union {                              /* SWT Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t WTO:32;
    } B;
  } TO;

  union {                              /* SWT Window Register */
    vuint32_t R;
    struct {
      vuint32_t WST:32;
    } B;
  } WN;

  union {                              /* SWT Service Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t WSC:16;
    } B;
  } SR;

  union {                              /* SWT Counter Output Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;
    } B;
  } CO;

  union {                              /* SWT Service Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SK:16;                 /* Service Key. */
    } B;
  } SK;
};


/* ============================================================================
   =============================== Module: SXOSC ==============================
   ============================================================================ */

struct SXOSC_tag {
  union {
    vuint32_t R;
    struct {
      vuint32_t OSCBYP:1;              /* 32 KHz oscillator bypass */
      vuint32_t ALC:1;                 /* Auto loop control */
      vuint32_t  :6;
      vuint32_t EOCV:8;                /* End of Counter Value */
      vuint32_t M_OSC:1;               /* SXOSC clock interrupt mask */
      vuint32_t  :2;
      vuint32_t OSCDIV:5;              /* The SXOSC Divider bits select the clock divider factor. */
      vuint32_t I_OSC:1;               /* SXOSC clock interrupt */
      vuint32_t  :7;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

struct TDM_tag {
  union {                              /* TDR Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDRSR5:1;
      vuint32_t TDRSR4:1;
      vuint32_t TDRSR3:1;
      vuint32_t TDRSR2:1;
      vuint32_t TDRSR1:1;
      vuint32_t TDRSR0:1;
    } B;
  } TDRSR;

  union {                              /* Last Flash Programmed Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t LFPAR:24;
    } B;
  } LFPAR;

  union {                              /* Diary Base Address */
    vuint32_t R;
    struct {
      vuint32_t DBA:32;
    } B;
  } DBA;
};


/* ============================================================================
   =============================== Module: UHST ===============================
   ============================================================================ */

struct UHST_tag {
  union {                              /* Identification Register */
    vuint32_t R;
    struct {
      vuint32_t VERSIONID:3;           /* Version ID */
      vuint32_t VERSION:4;             /* Version */
      vuint32_t REVISION:4;            /* Revision */
      vuint32_t TAG:5;                 /* Tag */
      vuint32_t  :2;                   /* Reserved */
      vuint32_t NID:6;
      vuint32_t  :2;                   /* Reserved */
      vuint32_t ID:6;                  /* Configuration number */
    } B;
  } ID;

  union {                              /* General Hardware Parameters Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;                  /* Reserved */
      vuint32_t SM:2;                  /* Serial mode */
      vuint32_t PHYM:4;                /* PHY Mode */
      vuint32_t PHYW:2;                /* PHY Width */
      vuint32_t  :1;
      vuint32_t CLKC:2;                /* VUSB_HS_CLOCK_CONFIGURATION. */
      vuint32_t RT:1;                  /* VUSB_HS_RESET_TYPE. */
    } B;
  } GNLHW;

  union {                              /* Host Hardware Parameters Register */
    vuint32_t R;
    struct {
      vuint32_t TTPER:8;               /* Transaction translator periodic contexts. */
      vuint32_t TTASY:8;               /* Transaction translator contexts. */
      vuint32_t  :12;                  /* Reserved */
      vuint32_t NPORT:3;               /* Number of Ports */
      vuint32_t HC:1;                  /* Host Capable */
    } B;
  } HSTHWP;

  uint8_t UHST_reserved0[4];
  union {                              /* Transmit Buffer Hardware Parameters Register */
    vuint32_t R;
    struct {
      vuint32_t TXLC:1;                /* Transmit local Context Registers */
      vuint32_t  :7;                   /* Reserved */
      vuint32_t TXCHANADD:8;           /* Transmit Channel Address */
      vuint32_t TXADD:8;               /* Transmit Address. */
      vuint32_t TXBURST:8;             /* Transmit Burst. */
    } B;
  } TXBFP;

  union {                              /* Receive Buffer Hardware Parameters Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Reserved */
      vuint32_t RXADD:8;               /* Receive Address. */
      vuint32_t RXBURST:8;             /* Receive Burst. */
    } B;
  } RXBFP;

  uint8_t UHST_reserved1[104];
  struct {
    union {                            /* General Purpose Timer n Load Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;                 /* Reserved */
        vuint32_t GPTLD:24;
      } B;
    } LD;
    union {                            /* General Purpose Timer n Control Register */
      vuint32_t R;
      struct {
        vuint32_t GPTRUN:1;            /* Timer Run */
        vuint32_t GPTRST:1;            /* Timer Reset */
        vuint32_t  :5;                 /* Reserved */
        vuint32_t GPTMODE:1;           /* Timer Mode */
        vuint32_t GPTCNT:24;           /* Timer Count */
      } B;
    } CTL;
  } GPT[2];

  union {                              /* System Bus Interface Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;                  /* Reserved */
      vuint32_t BAWR:3;                /* AMBA Burst Alignment for Writes. Set by parameter VUSB_HS_AHBBRST_ALIGN_WR. */
      vuint32_t BARD:3;                /* AMBA Burst Alignment for Reads. */
      vuint32_t AHBBRST:3;             /* AMBA AHB burst configuration. */
    } B;
  } SBUSCFG;

  uint8_t UHST_reserved2[108];
  union {                              /* Capability Register Length */
    vuint8_t R;
    struct {
      vuint8_t CAPLENGTH:8;            /* This register is used to indicate which offset to add to the register base address at the beginning of the Operational Register. */
    } B;
  } CAPLENGTH;

  uint8_t UHST_reserved3[1];
  union {                              /* Host Controller Interface Version and Capability Registers Length Register */
    vuint16_t R;
    struct {
      vuint16_t HCIVERSION:16;         /* EHCI revision number */
    } B;
  } HCIVERSION;

  union {                              /* Host Controller Structural Parameters Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;                   /* Reserved */
      vuint32_t N_TT:4;                /* Number of Transaction Translators. */
      vuint32_t N_PTT:4;               /* Ports per Transaction Translator */
      vuint32_t  :3;                   /* Reserved */
      vuint32_t PI:1;                  /* Port Indicators */
      vuint32_t N_CC:4;                /* Number of Companion Controllers */
      vuint32_t N_PCC:4;               /* Number Ports per CC */
      vuint32_t  :3;                   /* Reserved */
      vuint32_t PPCA:1;                 /* Power Port Control */
      vuint32_t N_PORTS:4;             /* Number of Ports */
    } B;
  } HCSPARAMS;

  union {                              /* Host Controller Capability Parameters Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Reserved */
      vuint32_t EECP:8;                /* EHCI Extended Capabilities Pointer */
      vuint32_t IST:4;                 /* Isochronous Scheduling Threshold */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t ASP:1;                 /* Asynchronous Schedule Park capability */
      vuint32_t PFL:1;                 /* Programmable Frame List flag */
      vuint32_t ADC:1;                 /* 64-bit addressing capability. */
    } B;
  } HCCPARAMS;

  uint8_t UHST_reserved4[52];
  union {                              /* USB Command Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;                   /* Reserved */
      vuint32_t ITC:8;                 /* Interrupt Threshold Control */
      vuint32_t FS1:1;                 /* Frame list Size 1 */
      vuint32_t ATDTW:1;               /* Add dTD TripWire */
      vuint32_t SUTW:1;                /* Setup TripWire */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t ASPE:1;                /* Asynchronous Schedule Park mode Enable */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t ASP:2;                 /* Asynchronous Schedule Park mode count */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t IAA:1;                 /* Interrupt on Async Advance doorbell */
      vuint32_t ASE:1;                 /* Asynchronous Schedule Enable */
      vuint32_t PSE:1;                 /* Periodic Schedule Enable */
      vuint32_t FS0:2;                 /* Frame list Size 0 */
      vuint32_t RST:1;                 /* Controller Reset */
      vuint32_t RS:1;                  /* Run/Stop */
    } B;
  } USBCMD;

  union {                              /* USB Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;                   /* Reserved */
      vuint32_t TI1:1;                 /* General purpose Timer 1 Interrupt */
      vuint32_t TI0:1;                 /* General purpose Timer 0 Interrupt */
      vuint32_t  :4;                   /* Reserved */
      vuint32_t UPI:1;                 /* USB host Periodic Interrupt */
      vuint32_t UAI:1;                 /* USB host Asynchronous Interrupt */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t NAKI:1;                /* NAK Interrupt */
      vuint32_t AS:1;                  /* Asynchronous schedule Status */
      vuint32_t PS:1;                  /* Periodic schedule Status */
      vuint32_t RCL:1;                 /* Reclamation */
      vuint32_t HCH:1;                 /* Host Controller Halted */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t ULPII:1;               /* ULPI Interrupt */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t SLI:1;                 /* Device-controller suspend */
      vuint32_t SRI:1;                 /* SOF Received */
      vuint32_t  :1;
      vuint32_t AAI:1;                 /* Interrupt on Async Advance */
      vuint32_t SEI:1;                 /* System Error */
      vuint32_t FRI:1;                 /* Frame-list Rollover */
      vuint32_t PCI:1;                 /* Port Change detect */
      vuint32_t UEI:1;                 /* USB Error Interrupt */
      vuint32_t UI:1;                  /* USB Interrupt (USBINT) */
    } B;
  } USBSTS;

  union {                              /* USB Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;                   /* Reserved */
      vuint32_t TIE1:1;                /* General purpose Timer 1 Interrupt Enable */
      vuint32_t TIE0:1;                /* General purpose Timer 0 Interrupt Enable */
      vuint32_t  :4;                   /* Reserved */
      vuint32_t UPIE:1;                /* USB host Periodic Interrupt Enable */
      vuint32_t UAIE:1;                /* USB host Asynchronous Interrupt Enable */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t NAKE:1;                /* NAK Interrupt Enable */
      vuint32_t  :4;                   /* Reserved */
      vuint32_t UALTIE:1;              /* ULPI alt_int Interrupt Enable. */
      vuint32_t ULPIE:1;               /* ULPI Enable */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t  :1;
      vuint32_t SRE:1;                 /* SOF-Received Enable */
      vuint32_t  :1;
      vuint32_t AAE:1;                 /* Interrupt on Async advance Enable */
      vuint32_t SEE:1;                 /* System Error Enable */
      vuint32_t FRE:1;                 /* Frame list Rollover Enable */
      vuint32_t PCE:1;                 /* Port Change detect Enable */
      vuint32_t UEE:1;                 /* USB Error interrupt Enable */
      vuint32_t UE:1;                  /* USB interrupt Enable */
    } B;
  } USBINTR;

  union {                              /* Frame Index Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;                  /* Reserved */
      vuint32_t FRINDEX:14;            /* Frame Index */
    } B;
  } FRINDEX;

  uint8_t UHST_reserved5[4];
  union {                              /* Periodic Frame List Base Address Register */
    vuint32_t R;
    struct {
      vuint32_t BASEADR:20;            /* Base address */
      vuint32_t  :12;                  /* Reserved */
    } B;
  } PERIODICLISTBASE;

  union {                              /* Current Asynchronous List Address Register */
    vuint32_t R;
    struct {
      vuint32_t ASYBASE:27;            /* Link pointer low (LPL) */
      vuint32_t  :5;                   /* Reserved */
    } B;
  } ASYNCLISTADDR;

  uint8_t UHST_reserved6[4];
  union {                              /* Master Interface Data Burst Size Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Reserved */
      vuint32_t TXPBURST:8;            /* Programable TX Burst length */
      vuint32_t RXPBURST:8;            /* Programable RX Burst length */
    } B;
  } BRSTSIZE;

  union {                              /* Transmit FIFO Tuning Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;                  /* Reserved */
      vuint32_t TXFIFOTHRES:6;         /* FIFO burst Threshold */
      vuint32_t  :3;                   /* Reserved */
      vuint32_t TXSCHHEALTH:5;         /* Scheduler Health counter */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t TXSCHOH:7;             /* Scheduler Overhead */
    } B;
  } TXTFLTNG;

  uint8_t UHST_reserved7[8];
  union {                              /* ULPI Register Access */
    vuint32_t R;
    struct {
      vuint32_t ULPI_WU:1;             /* ULPI Wake-Up */
      vuint32_t ULPI_RUN:1;            /* ULPI Run */
      vuint32_t ULPI_RW:1;             /* ULPI Read/Write */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t ULPI_SS:1;             /* ULPI Sync State */
      vuint32_t ULPI_PORT:3;           /* ULPI Port number */
      vuint32_t ULPI_ADDR:8;           /* ULPI data Address */
      vuint32_t ULPI_DATRD:8;          /* ULPI Data Read */
      vuint32_t ULPI_DATWR:8;          /* ULPI Data Write */
    } B;
  } ULPIVWPT;

  uint8_t UHST_reserved8[12];
  union {                              /* Configure Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved */
      vuint32_t  :1;                   /* Reserved */
    } B;
  } CONFIGFLAG;

  union {                              /* Port Status and Control Registers */
    vuint32_t R;
    struct {
      vuint32_t PTS:2;                 /* Port Transceiver Select */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t PSPD:2;                /* Port Speed */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t PFSC:1;                /* Port force Full-Speed Connect */
      vuint32_t PHCD:1;                /* PHY low power suspend */
      vuint32_t WKOC:1;                /* Wake on Over-Current enable */
      vuint32_t WKDS:1;                /* Wake on Disconnect enable */
      vuint32_t WKCN:1;                /* Wake on Connect enable */
      vuint32_t PTC:4;                 /* Port Test Control */
      vuint32_t PIC:2;                 /* Port Indicator Control */
      vuint32_t PO:1;                  /* Port Owner */
      vuint32_t PP:1;                  /* Port Power */
      vuint32_t LS:2;                  /* Line Status */
      vuint32_t HSP:1;                 /* High Speed Port. */
      vuint32_t PR:1;                  /* Port Reset */
      vuint32_t SUSP:1;                /* Suspend */
      vuint32_t FPR:1;                 /* Force Port Resume */
      vuint32_t OCC:1;                 /* Over-Current Change */
      vuint32_t OCA:1;                 /* Over-current active */
      vuint32_t PEC:1;                 /* Port Enable/disable Change */
      vuint32_t PE:1;                  /* Port Enabled/disabled */
      vuint32_t CSC:1;                 /* Connect Change Status */
      vuint32_t CCS:1;                 /* Current Connect Status */
    } B;
  } PORTSC1;

  uint8_t UHST_reserved9[32];
  union {                              /* USB Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;                   /* Reserved */
      vuint32_t ALP:8;                 /* Auto Low Power. */
      vuint32_t SRT:1;                 /* Shorten Reset Time. */
      vuint32_t TXHSD:3;               /* Tx to Tx HS Delay */
      vuint32_t  :7;                   /* Reserved */
      vuint32_t SDIS:1;                /* Stream DISable */
      vuint32_t  :1;
      vuint32_t ES:1;                  /* Endian Select */
      vuint32_t CM:2;                  /* Controller Mode */
    } B;
  } USBMODE;
};


/* ============================================================================
   =============================== Module: UHSTNC =============================
   ============================================================================ */

struct UHSTNC_tag {
  uint8_t UHSTNC_reserved0[512];
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t WAKEUPIS:1;            /* USB Wake up interrupt status. */
      vuint32_t PWRFLTDF:1;            /* VBUS Power Fault current value default. */
      vuint32_t PWRFLTEN:1;            /* Enable VBUS Power fault detection. */
      vuint32_t ENDNSEL:1;             /* Endian Selection of USB Master Port. */
      vuint32_t WAKEUPIC:1;            /* Clear USB Wake up interrupt. */
      vuint32_t  :2;
      vuint32_t PWRFLT:1;              /* Power fault infication. */
      vuint32_t CORE_IE:1;             /* Enable interrupt from core. */
      vuint32_t WAKEUP_IE:1;           /* Enable USB Wake up interrupt. */
    } B;
  } CR;

  uint8_t UHSTNC_reserved1[12];
  union {                              /* USB Endian Mode Select */
    vuint32_t R;
    struct {
      vuint32_t ENDNMODE:32;           /* Select endian mode. */
    } B;
  } ENDNMODE;

  uint8_t UHSTNC_reserved2[8];
  union {                              /* USB Endian Select */
    vuint32_t R;
    struct {
      vuint32_t ENDNMSEL:32;
    } B;
  } ENDNMSEL;
};


/* ============================================================================
   =============================== Module: UOTG ===============================
   ============================================================================ */

struct UOTG_tag {
  union {                              /* Identification register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t REVISION:8;
      vuint32_t  :2;
      vuint32_t NID:6;
      vuint32_t  :2;
      vuint32_t ID:6;                  /* Configuration number */
    } B;
  } ID;

  union {                              /* Hardware General */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t SM:2;
      vuint32_t PHYM:3;
      vuint32_t PHYW:2;
      vuint32_t  :4;
    } B;
  } GNLHW;

  union {                              /* Host Hardware Parameters */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t NPORT:3;
      vuint32_t HC:1;                  /* Host Capable */
    } B;
  } HSTHWP;

  union {                              /* Device Hardware Parameters */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t DEVEP:5;               /* Device Endpoint Number */
      vuint32_t DC:1;
    } B;
  } DEVHWP;

  union {                              /* TX Buffer Hardware Parameters */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TXCHANADD:8;
      vuint32_t TXADD:8;
      vuint32_t TXBURST:8;
    } B;
  } TXBFP;

  union {                              /* RX Buffer Hardware Parameters */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RXADD:8;
      vuint32_t RXBURST:8;
    } B;
  } RXBFP;

  uint8_t UOTG_reserved0[104];
  struct {
    union {                            /* General Purpose Timer Load */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t GPTLD:24;            /* General Purpose Timer Load Value */
      } B;
    } LD;
    union {                            /* General Purpose Timer Controller */
      vuint32_t R;
      struct {
        vuint32_t GPTRUN:1;
        vuint32_t GPTRST:1;
        vuint32_t  :5;
        vuint32_t GPTMODE:1;           /* General Purpose Timer Mode */
        vuint32_t GPTCNT:24;           /* General Purpose Timer Counter */
      } B;
    } CL;
  } GPT[2];

  union {                              /* System Bus Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t BAWR:3;                /* AMBA Burst Alignment for Writes. */
      vuint32_t BARD:3;                /* AMBA Burst Alignment for Reads. */
      vuint32_t AHBBRST:3;
    } B;
  } SBUSCFG;

  uint8_t UOTG_reserved1[108];
  union {                              /* Capability Register Length */
    vuint8_t R;
    struct {
      vuint8_t CAPLENGTH:8;
    } B;
  } CAPLENGTH;

  uint8_t UOTG_reserved2[1];
  union {                              /* Host Controller Interface Version */
    vuint16_t R;
    struct {
      vuint16_t HCIVERSION:16;
    } B;
  } HCIVERSION;

  union {                              /* Host Controller Structural Parameters */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t N_TT:4;                /* Number of Transaction Translators */
      vuint32_t N_PTT:4;               /* Number of Ports per Transaction Translator */
      vuint32_t  :3;
      vuint32_t PI:1;                  /* Port Indicators */
      vuint32_t N_CC:4;                /* Number of Companion Controllers */
      vuint32_t N_PCC:4;
      vuint32_t  :3;
      vuint32_t PPCA:1;
      vuint32_t N_PORTS:4;             /* Number of downstream ports */
    } B;
  } HCSPARAMS;

  union {                              /* Host Controller Capability Parameters */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t EECP:8;
      vuint32_t IST:4;
      vuint32_t  :1;
      vuint32_t ASP:1;
      vuint32_t PFL:1;
      vuint32_t ADC:1;
    } B;
  } HCCPARAMS;

  uint8_t UOTG_reserved3[20];
  union {                              /* Device Controller Interface Version */
    vuint16_t R;
    struct {
      vuint16_t DCIFVER:16;
    } B;
  } DCIFVER;

  uint8_t UOTG_reserved4[2];
  union {                              /* Device Controller Capability Parameters */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t HC:1;
      vuint32_t DC:1;
      vuint32_t  :2;
      vuint32_t DEN:5;
    } B;
  } DCCAPPAR;

  uint8_t UOTG_reserved5[24];
  union {                              /* USB Command Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t ITC:8;                 /* Interrupt Threshold Control */
      vuint32_t FS1:1;                 /* Frame List Size */
      vuint32_t ATDTW:1;               /* Add dTD TripWire */
      vuint32_t SUTW:1;                /* Setup TripWire */
      vuint32_t  :1;
      vuint32_t ASPE:1;
      vuint32_t  :1;
      vuint32_t ASP:2;                 /* Asynchronous Schedule Park Mode Count */
      vuint32_t  :1;
      vuint32_t IAA:1;                 /* Interrupt on Async Advance Doorbell */
      vuint32_t ASE:1;                 /* Asynchronous Schedule Enable */
      vuint32_t PSE:1;                 /* Periodic Schedule Enable */
      vuint32_t FS0:2;
      vuint32_t RST:1;                 /* Controller Reset */
      vuint32_t RS:1;                  /* Run/Stop */
    } B;
  } USBCMD;

  union {                              /* USB Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t TI1:1;                 /* General Purpose Timer Interrupt 1 */
      vuint32_t TI0:1;                 /* General Purpose Timer Interrupt 0 */
      vuint32_t  :4;
      vuint32_t UPI:1;                 /* USB Host Periodic Interrupt */
      vuint32_t UAI:1;                 /* USB Host Asynchronous Interrupt */
      vuint32_t  :1;
      vuint32_t NAKI:1;                /* NAK Interrupt Bit */
      vuint32_t AS:1;                  /* Asynchronous Schedule Status */
      vuint32_t PS:1;                  /* Periodic Schedule Status */
      vuint32_t RCL:1;                 /* Reclamation */
      vuint32_t HCH:1;                 /* HC Halted */
      vuint32_t UALTI:1;               /* ULPI alt_int Interrupt */
      vuint32_t ULPII:1;               /* ULPI Interrupt */
      vuint32_t  :1;
      vuint32_t SLI:1;                 /* DC Suspend */
      vuint32_t SRI:1;                 /* SOF Received */
      vuint32_t URI:1;                 /* USB Reset Received */
      vuint32_t AAI:1;                 /* Interrupt on Async Advance */
      vuint32_t SEI:1;                 /* System Error */
      vuint32_t FRI:1;                 /* Frame List Rollover */
      vuint32_t PCI:1;                 /* Port Change Detect */
      vuint32_t UEI:1;                 /* USB Error Interrupt */
      vuint32_t UI:1;                  /* USB Interrupt */
    } B;
  } USBSTS;

  union {                              /* Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t TIE1:1;
      vuint32_t TIE0:1;
      vuint32_t  :4;
      vuint32_t UPIE:1;
      vuint32_t UAIE:1;
      vuint32_t  :1;
      vuint32_t NAKE:1;
      vuint32_t  :5;
      vuint32_t ULPIE:1;
      vuint32_t  :1;
      vuint32_t SLE:1;
      vuint32_t SRE:1;
      vuint32_t URE:1;
      vuint32_t AAE:1;
      vuint32_t SEE:1;
      vuint32_t FRE:1;
      vuint32_t PCE:1;
      vuint32_t UEE:1;
      vuint32_t UE:1;
    } B;
  } USBINTR;

  union {                              /* USB Frame Index */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t FRINDEX:14;
    } B;
  } FRINDEX;

  uint8_t UOTG_reserved6[4];
  union {
    union {                            /* Device Address */
      vuint32_t R;
      struct {
        vuint32_t USBADR:7;
        vuint32_t USBADRA:1;           /* Device Address Advance */
        vuint32_t  :24;
      } B;
    } DEVADR;
    union {                            /* Frame List Base Address */
      vuint32_t R;
      struct {
        vuint32_t BASEADR:20;
        vuint32_t  :12;
      } B;
    } PERIODICLISTBASE;
  } ADDRESS1;

  union {
    union {                            /* Next Asynch. Address */
      vuint32_t R;
      struct {
        vuint32_t ASYBASE:27;
        vuint32_t  :5;
      } B;
    } ASYNCLISTADDR;
    union {                            /* Endpoint List Address */
      vuint32_t R;
      struct {
        vuint32_t EPBASE:21;           /* Endpoint List Pointer(Low) */
        vuint32_t  :11;
      } B;
    } ENDPLADR;
  } ADDRESS2;

  uint8_t UOTG_reserved7[4];
  union {                              /* Programmable Burst Size */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TXPBURST:8;
      vuint32_t RXPBURST:8;
    } B;
  } BRSTSIZE;

  union {                              /* TX FIFO Fill Tuning */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t TXFIFOTHRES:6;         /* FIFO Burst Threshold */
      vuint32_t  :3;
      vuint32_t TXSCHHEALTH:5;         /* Scheduler Health Counter */
      vuint32_t TXSCHOH:8;             /* Scheduler Overhead */
    } B;
  } TXTFLTNG;

  uint8_t UOTG_reserved8[4];
  union {                              /* IC_USB enable and voltage negotiation */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IC1:1;
      vuint32_t IC_VDD1:3;
    } B;
  } ICUSBEN;

  union {                              /* ULPI Register Access */
    vuint32_t R;
    struct {
      vuint32_t ULPI_WU:1;             /* ULPI Wake-Up */
      vuint32_t ULPI_RUN:1;            /* ULPI Run */
      vuint32_t ULPI_RW:1;             /* ULPI Read/Write */
      vuint32_t  :1;                   /* Reserved */
      vuint32_t ULPI_SS:1;             /* ULPI Sync State */
      vuint32_t ULPI_PORT:3;           /* ULPI Port number */
      vuint32_t ULPI_ADDR:8;           /* ULPI data Address */
      vuint32_t ULPI_DATRD:8;          /* ULPI Data Read */
      vuint32_t ULPI_DATWR:8;          /* ULPI Data Write */
    } B;
  } ULPIVWPT;

  uint8_t UOTG_reserved9[4];
  union {                              /* Endpoint NAK */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t EPTN:4;                /* TX Endpoint NAK */
      vuint32_t  :12;
      vuint32_t EPRN:4;                /* RX Endpoint NAK */
    } B;
  } ENDPNAK;

  union {                              /* Endpoint NAK Enable */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t EPTNE:4;               /* TX Endpoint NAK Enable */
      vuint32_t  :12;
      vuint32_t EPRNE:4;               /* RX Endpoint NAK Enable */
    } B;
  } ENDPNAKE;

  union {                              /* Configure Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved */
      vuint32_t  :1;                   /* Reserved */
    } B;
  } CONFIGFLAG;

  union {                              /* Port Status and Control */
    vuint32_t R;
    struct {
      vuint32_t PTS1:2;                /* Parallel Transceiver Select */
      vuint32_t STS:1;                 /* Serial Transceiver Select */
      vuint32_t PTW:1;                 /* Parallel Transceiver Width */
      vuint32_t PSPD:2;                /* Port Speed */
      vuint32_t PTS0:1;
      vuint32_t PFSC:1;                /* Port Force Full Speed Connect */
      vuint32_t PHCD:1;                /* PHY Low Power Suspend - Clock Disable */
      vuint32_t WKOC:1;                /* Wake on Over-current Enable */
      vuint32_t WKDS:1;                /* Wake on Disconnect Enable */
      vuint32_t WKCN:1;                /* Wake on Connect Enable */
      vuint32_t PTC:4;                 /* Port Test Control */
      vuint32_t PIC:2;                 /* Port Indicator Control */
      vuint32_t PO:1;                  /* Port Owner */
      vuint32_t PP:1;
      vuint32_t LS:2;                  /* Line Status */
      vuint32_t HSP:1;                 /* High-Speed Port */
      vuint32_t PR:1;                  /* Port Reset */
      vuint32_t SUSP:1;                /* Suspend */
      vuint32_t FPR:1;                 /* Force Port Resume */
      vuint32_t OCC:1;                 /* Over-current Change */
      vuint32_t OCA:1;                 /* Over-current Active */
      vuint32_t PEC:1;                 /* Port Enable/Disable Change */
      vuint32_t PE:1;                  /* Port Enabled/Disabled */
      vuint32_t CSC:1;                 /* Connect Status Change */
      vuint32_t CCS:1;                 /* Current Connect Status */
    } B;
  } PORTSC1;

  uint8_t UOTG_reserved10[28];
  union {                              /* On-The-Go Status Control */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t DPIE:1;
      vuint32_t TIMIE:1;               /* One-millisecond timer interrupt enable */
      vuint32_t BSEIE:1;               /* B Session End Interrupt Enable */
      vuint32_t BSVIE:1;               /* B Session Valid Interrupt Enable */
      vuint32_t ASVIE:1;               /* A Session Valid Interrupt Enable */
      vuint32_t AVVIE:1;               /* A VBus Valid Interrupt Enable */
      vuint32_t IDIE:1;                /* USB ID Interrupt Enable */
      vuint32_t  :1;
      vuint32_t DPIS:1;                /* Data Pulse Interrupt Status */
      vuint32_t TIMIS:1;               /* One-millisecond timer interrupt status */
      vuint32_t BSEIS:1;               /* B Session End Interrupt Status */
      vuint32_t BSVIS:1;               /* B Session Valid Interrupt Status */
      vuint32_t ASVIS:1;               /* A Session Valid Interrupt Status */
      vuint32_t AVVIS:1;               /* A VBus Valid Interrupt Status */
      vuint32_t IDIS:1;                /* USB ID Interrupt Status */
      vuint32_t  :1;
      vuint32_t DPS:1;                 /* Data Bus Pulsing Status */
      vuint32_t TIM_TOG:1;             /* One-millisecond timer toggle */
      vuint32_t BSE:1;                 /* B Session End */
      vuint32_t BSV:1;                 /* B Session Valid */
      vuint32_t ASV:1;                 /* A Session Valid */
      vuint32_t AVV:1;                 /* A VBus Valid */
      vuint32_t ID:1;                  /* USB ID */
      vuint32_t HABA:1;                /* Hardware Assist B-Disconnect to A-connect. */
      vuint32_t HADP:1;                /* HADP Hardware Assist Data. */
      vuint32_t IDPU:1;                /* ID Pullup */
      vuint32_t DP:1;                  /* Data Pulsing. */
      vuint32_t OT:1;                  /* OTG Termination */
      vuint32_t HAAR:1;                /* Hardware Assist Auto-Reset. */
      vuint32_t VC:1;                  /* VBUS Charge */
      vuint32_t VD:1;                  /* VBUS Discharge */
    } B;
  } OTGSC;

  union {                              /* USB Device Mode */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t ALP:8;                 /* Auto Low Power */
      vuint32_t SRT:1;                 /* Shorten Reset Time */
      vuint32_t TXHSD:4;               /* Tx to Tx HS Delay. */
      vuint32_t  :6;
      vuint32_t SDIS:1;                /* Stream Disable Mode */
      vuint32_t SLOM:1;                /* Setup Lockout Mode */
      vuint32_t ES:1;                  /* Endian Select */
      vuint32_t CM:2;                  /* Controller Mode */
    } B;
  } USBDMODE;

  union {                              /* Endpoint Setup Status */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENPSTPST:16;           /* Setup Endpoint Status */
    } B;
  } ENPSTPST;

  union {                              /* Endpoint Initialization */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t PETB:4;                /* Prime Endpoint Transmit Buffer */
      vuint32_t  :12;
      vuint32_t PERB:4;                /* Prime Endpoint Receive Buffer */
    } B;
  } ENDPINT;

  union {                              /* Endpoint De-Initialize */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t FETB:4;                /* Flush Endpoint Transmit Buffer */
      vuint32_t  :12;
      vuint32_t FERB:4;                /* Flush Endpoint Receive Buffer */
    } B;
  } ENDPDINT;

  union {                              /* Endpoint Status */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t ETBR:4;                /* Endpoint Transmit Buffer Ready */
      vuint32_t  :12;
      vuint32_t ERBR:4;                /* Endpoint Receive Buffer Ready */
    } B;
  } ENDPST;

  union {                              /* Endpoint Complete */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t ETCE:4;                /* Endpoint Transmit Complete Event */
      vuint32_t  :12;
      vuint32_t ERCE:4;                /* Endpoint Receive Complete Event */
    } B;
  } ENPCPLT;

  union {                              /* Endpoint Control 0 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TXE:1;
      vuint32_t  :3;
      vuint32_t TXT:2;                 /* TX Endpoint Type */
      vuint32_t  :1;
      vuint32_t TXS:1;                 /* TX Endpoint Stall */
      vuint32_t  :8;
      vuint32_t RXE:1;
      vuint32_t  :3;
      vuint32_t RXT:2;                 /* RX Endpoint Type */
      vuint32_t  :1;
      vuint32_t RXS:1;                 /* RX Endpoint Stall */
    } B;
  } ENDPTC0;

  union {                              /* Endpoint Control */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TXE:1;
      vuint32_t TXR:1;                 /* TX Data Toggle Reset */
      vuint32_t TXI:1;
      vuint32_t  :1;
      vuint32_t TXT:2;
      vuint32_t TXD:1;
      vuint32_t TXS:1;
      vuint32_t  :8;
      vuint32_t RXE:1;
      vuint32_t RXR:1;                 /* RX Data Toggle Reset */
      vuint32_t RXI:1;                 /* RX Data Toggle Inhibit */
      vuint32_t  :1;
      vuint32_t RXT:2;                 /* RX Endpoint Type */
      vuint32_t RXD:1;                 /* RX Endpoint Data Sink */
      vuint32_t RXS:1;                 /* RX Endpoint Stall */
    } B;
  } ENDPTC[4];
};


/* ============================================================================
   =============================== Module: UOTGNC =============================
   ============================================================================ */

struct UOTGNC_tag {
  uint8_t UOTGNC_reserved0[512];
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t WAKEUPIS:1;            /* USB wake up interrupt status */
      vuint32_t PWRFLTDF:1;            /* Vbus power fault current value default */
      vuint32_t PWRFLTEN:1;            /* Enable Vbus power fault detection */
      vuint32_t ENDNSEL:1;             /* Endian selection of USB master port */
      vuint32_t WAKEUPIC:1;            /* Clear USB wake up interrupt */
      vuint32_t  :2;
      vuint32_t PWRFLT:1;              /* Power fault indication */
      vuint32_t CORE_IE:1;             /* Enable interrupt from core */
      vuint32_t WAKEUP_IE:1;           /* USB wake up interrupt enable */
    } B;
  } CR;

  uint8_t UOTGNC_reserved1[12];
  union {                              /* USB Endian Mode Select */
    vuint32_t R;
    struct {
      vuint32_t ENDNMODE:32;           /* Select endian mode */
    } B;
  } ENDNMODE;

  uint8_t UOTGNC_reserved2[8];
  union {                              /* USB endian select */
    vuint32_t R;
    struct {
      vuint32_t ENDNMSEL:32;
    } B;
  } ENDNMSEL;
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

struct WKPU_tag {
  union {                              /* NMI Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t NIF0:1;
      vuint32_t NOVF0:1;
      vuint32_t  :6;
      vuint32_t NIF1:1;
      vuint32_t NOVF1:1;
      vuint32_t  :6;
      vuint32_t NIF2:1;
      vuint32_t NOVF2:1;
      vuint32_t  :6;
      vuint32_t RIF:1;                 /* Reset Status Flag */
      vuint32_t ROVF:1;                /* Reset Overrun Status Flag */
      vuint32_t  :6;
    } B;
  } NSR;

  uint8_t WKPU_reserved0[4];
  union {                              /* NMI Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NLOCK0:1;
      vuint32_t NDSS0:2;
      vuint32_t NWRE0:1;
      vuint32_t  :1;
      vuint32_t NREE0:1;
      vuint32_t NFEE0:1;
      vuint32_t NFE0:1;
      vuint32_t NLOCK1:1;
      vuint32_t NDSS1:2;
      vuint32_t NWRE1:1;
      vuint32_t  :1;
      vuint32_t NREE1:1;
      vuint32_t NFEE1:1;
      vuint32_t  :1;
      vuint32_t NLOCK2:1;
      vuint32_t NDSS2:2;
      vuint32_t NWRE2:1;
      vuint32_t  :1;
      vuint32_t NREE2:1;
      vuint32_t NFEE2:1;
      vuint32_t  :1;
      vuint32_t RLOCK:1;
      vuint32_t RDSS:2;
      vuint32_t RWRE:1;
      vuint32_t  :1;
      vuint32_t RREE:1;
      vuint32_t RFEE:1;
      vuint32_t  :1;
    } B;
  } NCR;

  uint8_t WKPU_reserved1[8];
  union {                              /* Wakeup/Interrupt Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t EIF:32;
    } B;
  } WISR;

  union {                              /* Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t EIRE:32;
    } B;
  } IRER;

  union {                              /* Wakeup Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t WRE:32;
    } B;
  } WRER;

  uint8_t WKPU_reserved2[8];
  union {                              /* Wakeup/Interrupt Rising-Edge Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IREE:32;
    } B;
  } WIREER;

  union {                              /* Wakeup/Interrupt Falling-Edge Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IFEEx:32;
    } B;
  } WIFEER;

  union {                              /* Wakeup/Interrupt Filter Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IFE:32;
    } B;
  } WIFER;

  union {                              /* Wakeup/Interrupt Pullup Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IPUE:32;
    } B;
  } WIPUER;
};


/* ============================================================================
   =============================== Module: eMIOS ==============================
   ============================================================================ */

struct eMIOS_tag {
  union {                              /* eMIOS Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t MDIS:1;                /* Module Disable bit. */
      vuint32_t FRZ:1;                 /* Freeze bit. */
      vuint32_t GTBE:1;                /* Global Time Base Enable bit. */
      vuint32_t ETB:1;                 /* External Time Base bit */
      vuint32_t GPREN:1;               /* Global Prescaler Enable bit. */
      vuint32_t  :6;                   /* Reserved. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t GPRE:8;                /* Global Prescaler bits. */
      vuint32_t  :8;                   /* Reserved. */
    } B;
  } MCR;

  union {                              /* eMIOS Global FLAG Register */
    vuint32_t R;
    struct {
      vuint32_t F31_F0:32;             /* Channel [n] mirrored FLAG bit. */
    } B;
  } GFLAG;

  union {                              /* eMIOS Output Update Disable register */
    vuint32_t R;
    struct {
      vuint32_t OU31_OU0:32;           /* Channel [n] Output Update Disable bit. */
    } B;
  } OUDIS;

  union {                              /* eMIOS Disable Channel register */
    vuint32_t R;
    struct {
      vuint32_t CHDIS31_CHDIS0:32;     /* Enable Channel n bit. */
    } B;
  } UCDIS;
};


/* ============================================================================
   =============================== Module: eMIOS_UC ===========================
   ============================================================================ */

struct eMIOS_UC_tag {
  uint8_t eMIOS_reserved0[32];
  struct {
    union {                            /* eMIOS UC A register n */
      vuint32_t R;
      struct {
        vuint32_t  :8;                 /* Reserved. */
        vuint32_t A:24;
      } B;
    } A;
    union {                            /* eMIOS UC B register n */
      vuint32_t R;
      struct {
        vuint32_t  :8;                 /* Reserved. */
        vuint32_t B:24;                /* See text above register figure. */
      } B;
    } B;
    union {                            /* eMIOS CNT register n */
      vuint32_t R;
      struct {
        vuint32_t  :16;                /* Reserved. */
        vuint32_t C:16;                /* The C field contains the value of the internal counter. */
      } B;
    } CNT;
    union {                            /* eMIOS UC Control register n */
      vuint32_t R;
      struct {
        vuint32_t FREN:1;              /* Freeze Enable bit. */
        vuint32_t ODIS:1;              /* Output Disable bit. */
        vuint32_t ODISSL:2;            /* Output Disable select bits. */
        vuint32_t UCPRE:2;             /* Prescaler bits. */
        vuint32_t UCPREN:1;            /* Prescaler Enable bit. */
        vuint32_t DMA:1;               /* Direct Memory Access bit. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t IF:4;                /* Input Filter bits. */
        vuint32_t FCK:1;               /* Filter Clock select bit. */
        vuint32_t FEN:1;               /* FLAG Enable bit. */
        vuint32_t  :3;                 /* Reserved. */
        vuint32_t FORCMA:1;            /* Force Match A bit. */
        vuint32_t FORCMB:1;            /* Force Match B bit. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t BSL:2;               /* Bus Select bits. */
        vuint32_t EDSEL:1;             /* Edge Selection bit. */
        vuint32_t EDPOL:1;             /* Edge Polarity bit. */
        vuint32_t MODE:7;              /* Mode selection bits. */
      } B;
    } C;
    union {                            /* eMIOS UC Status register n */
      vuint32_t R;
      struct {
        vuint32_t OVR:1;               /* Overrun bit. */
        vuint32_t  :15;                /* Reserved. */
        vuint32_t OVFL:1;              /* Overflow bit. */
        vuint32_t  :12;                /* Reserved. */
        vuint32_t UCIN:1;              /* Unified Channel Input pin bit. */
        vuint32_t UCOUT:1;             /* Unified Channel Output pin bit. */
        vuint32_t FLAG:1;              /* FLAG bit. */
      } B;
    } S;
    union {                            /* eMIOS Alternate Address register n */
      vuint32_t R;
      struct {
        vuint32_t  :8;                 /* Reserved. */
        vuint32_t ALTA:24;             /* See text above register figure. */
      } B;
    } ALTA;
    union {                            /* eMIOS UC Control 2 register n */
      vuint32_t R;
      struct {
        vuint32_t  :12;                /* Reserved. */
        vuint32_t UCEXTPRE:4;          /* Extended Prescaler bits [ 0:11 ]. */
        vuint32_t  :1;                 /* Reserved. */
        vuint32_t UCPRECLK:1;          /* Prescaler Clock select bit. */
        vuint32_t  :14;                /* Reserved. */
      } B;
    } C2;
    uint8_t UC_reserved0[4];
  } UC[32];
};


/* ============================================================================
   =============================== Module: uSDHC ==============================
   ============================================================================ */

struct uSDHC_tag {
  union {                              /* DMA System Address */
    vuint32_t R;
    struct {
      vuint32_t DS_ADDR:30;
      vuint32_t  :2;
    } B;
  } DS_ADDR;

  union {                              /* Block Attributes */
    vuint32_t R;
    struct {
      vuint32_t BLKCNT:16;
      vuint32_t  :3;
      vuint32_t BLKSIZE:13;
    } B;
  } BLK_ATT;

  union {                              /* Command Argument */
    vuint32_t R;
    struct {
      vuint32_t CMDARG:32;
    } B;
  } CMD_ARG;

  union {                              /* Command Transfer Type */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t CMDINX:6;
      vuint32_t CMDTYP:2;
      vuint32_t DPSEL:1;
      vuint32_t CICEN:1;
      vuint32_t CCCEN:1;
      vuint32_t  :1;
      vuint32_t RSPTYP:2;
      vuint32_t  :16;
    } B;
  } CMD_XFR_TYP;

  union {                              /* Command Response0 */
    vuint32_t R;
    struct {
      vuint32_t CMDRSP0:32;
    } B;
  } CMD_RSP0;

  union {                              /* Command Response1 */
    vuint32_t R;
    struct {
      vuint32_t CMDRSP1:32;
    } B;
  } CMD_RSP1;

  union {                              /* Command Response2 */
    vuint32_t R;
    struct {
      vuint32_t CMDRSP2:32;
    } B;
  } CMD_RSP2;

  union {                              /* Command Response3 */
    vuint32_t R;
    struct {
      vuint32_t CMDRSP3:32;
    } B;
  } CMD_RSP3;

  union {                              /* Data Buffer Access Port */
    vuint32_t R;
    struct {
      vuint32_t DATCONT:32;
    } B;
  } DATA_BUFF_ACC_PORT;

  union {                              /* Present State */
    vuint32_t R;
    struct {
      vuint32_t DLSL:8;
      vuint32_t CLSL:1;
      vuint32_t  :3;
      vuint32_t WPSPL:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t CINST:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t BREN:1;
      vuint32_t BWEN:1;
      vuint32_t RTA:1;
      vuint32_t WTA:1;
      vuint32_t SDOFF:1;
      vuint32_t PEROFF:1;
      vuint32_t HCKOFF:1;
      vuint32_t BUSOFF:1;
      vuint32_t SDSTB:1;
      vuint32_t DLA:1;
      vuint32_t CDIHB:1;
      vuint32_t CIHB:1;
    } B;
  } PRES_STATE;

  union {                              /* Protocol Control */
    vuint32_t R;
    struct {
      vuint32_t RD_NO8CLK_EN:1;
      vuint32_t NON_EXACT_BLK_RD:1;
      vuint32_t BURST_LEN_EN:3;
      vuint32_t WECRM:1;
      vuint32_t WECINS:1;
      vuint32_t WECINT:1;
      vuint32_t RD_WAIT_POINT:3;
      vuint32_t RD_DONE_NO_8CLK:1;
      vuint32_t IABG:1;
      vuint32_t RWCTL:1;
      vuint32_t CREQ:1;
      vuint32_t SABGREQ:1;
      vuint32_t  :6;
      vuint32_t DMASEL:2;
      vuint32_t CDSS:1;
      vuint32_t CDTL:1;
      vuint32_t EMODE:2;
      vuint32_t D3CD:1;
      vuint32_t DTW:2;
      vuint32_t LCTL:1;
    } B;
  } PROT_CTRL;

  union {                              /* System Control */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t RSTT:1;
      vuint32_t INITA:1;
      vuint32_t RSTD:1;
      vuint32_t RSTC:1;
      vuint32_t RSTA:1;
      vuint32_t IPP_RST_N:1;
      vuint32_t RST_FIFO:1;
      vuint32_t  :2;
      vuint32_t DTOCV:4;
      vuint32_t SDCLKFS:8;
      vuint32_t DVS:4;
      vuint32_t  :4;
    } B;
  } SYS_CTRL;

  union {                              /* Interrupt Status */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DMAE:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AC12E:1;
      vuint32_t  :1;
      vuint32_t DEBE:1;
      vuint32_t DCE:1;
      vuint32_t DTOE:1;
      vuint32_t CIE:1;
      vuint32_t CEBE:1;
      vuint32_t CCE:1;
      vuint32_t CTOE:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t CINT:1;
      vuint32_t CRM:1;
      vuint32_t CINS:1;
      vuint32_t BRR:1;
      vuint32_t BWR:1;
      vuint32_t DINT:1;
      vuint32_t BGE:1;
      vuint32_t TC:1;
      vuint32_t CC:1;
    } B;
  } INT_STATUS;

  union {                              /* Interrupt Status Enable */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DMAESEN:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AC12ESEN:1;
      vuint32_t  :1;
      vuint32_t DEBESEN:1;
      vuint32_t DCESEN:1;
      vuint32_t DTOESEN:1;
      vuint32_t CIESEN:1;
      vuint32_t CEBESEN:1;
      vuint32_t CCESEN:1;
      vuint32_t CTOESEN:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t CINTSEN:1;
      vuint32_t CRMSEN:1;
      vuint32_t CINSSEN:1;
      vuint32_t BRRSEN:1;
      vuint32_t BWRSEN:1;
      vuint32_t DINTSEN:1;
      vuint32_t BGESEN:1;
      vuint32_t TCSEN:1;
      vuint32_t CCSEN:1;
    } B;
  } INT_STATUS_EN;

  union {                              /* Interrupt Signal Enable */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DMAEIEN:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t AC12EIEN:1;
      vuint32_t  :1;
      vuint32_t DEBEIEN:1;
      vuint32_t DCEIEN:1;
      vuint32_t DTOEIEN:1;
      vuint32_t CIEIEN:1;
      vuint32_t CEBEIEN:1;
      vuint32_t CCEIEN:1;
      vuint32_t CTOEIEN:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t CINTIEN:1;
      vuint32_t CRMIEN:1;
      vuint32_t CINSIEN:1;
      vuint32_t BRRIEN:1;
      vuint32_t BWRIEN:1;
      vuint32_t DINTIEN:1;
      vuint32_t BGEIEN:1;
      vuint32_t TCIEN:1;
      vuint32_t CCIEN:1;
    } B;
  } INT_SIGNAL_EN;

  union {                              /* Auto CMD12 Error Status */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t  :1;
      vuint32_t EXECUTE_TUNING:1;
      vuint32_t  :14;
      vuint32_t CNIBAC12E:1;
      vuint32_t  :2;
      vuint32_t AC12IE:1;
      vuint32_t AC12CE:1;
      vuint32_t AC12EBE:1;
      vuint32_t AC12TOE:1;
      vuint32_t AC12NE:1;
    } B;
  } AUTOCMD12_ERR_STATUS;

  union {                              /* Host Controller Capabilities */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t VS18:1;
      vuint32_t VS30:1;
      vuint32_t VS33:1;
      vuint32_t SRS:1;
      vuint32_t DMAS:1;
      vuint32_t HSS:1;
      vuint32_t ADMAS:1;
      vuint32_t  :1;
      vuint32_t MBL:3;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :4;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :2;
    } B;
  } HOST_CTRL_CAP;

  union {                              /* Watermark Level */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t WR_BRST_LEN:5;
      vuint32_t WR_WML:8;
      vuint32_t  :3;
      vuint32_t RD_BRST_LEN:5;
      vuint32_t RD_WML:8;
    } B;
  } WTMK_LVL;

  union {                              /* Mixer Control */
    vuint32_t R;
    struct {
      vuint32_t CMD_DMY_EN:1;
      vuint32_t CMD_DMY_WAIT_CFG:1;
      vuint32_t AC12_RD_POINT:1;
      vuint32_t  :3;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :14;
      vuint32_t AC23EN:1;
      vuint32_t  :1;
      vuint32_t MSBSEL:1;
      vuint32_t DTDSEL:1;
      vuint32_t  :1;
      vuint32_t AC12EN:1;
      vuint32_t BCEN:1;
      vuint32_t DMAEN:1;
    } B;
  } MIX_CTRL;

  uint8_t uSDHC_reserved0[4];
  union {                              /* Force Event */
    vuint32_t R;
    struct {
      vuint32_t FEVTCINT:1;
      vuint32_t  :2;
      vuint32_t FEVTDMAE:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t FEVTAC12E:1;
      vuint32_t  :1;
      vuint32_t FEVTDEBE:1;
      vuint32_t FEVTDCE:1;
      vuint32_t FEVTDTOE:1;
      vuint32_t FEVTCIE:1;
      vuint32_t FEVTCEBE:1;
      vuint32_t FEVTCCE:1;
      vuint32_t FEVTCTOE:1;
      vuint32_t  :8;
      vuint32_t FEVTCNIBAC12E:1;
      vuint32_t  :2;
      vuint32_t FEVTAC12IE:1;
      vuint32_t FEVTAC12EBE:1;
      vuint32_t FEVTAC12CE:1;
      vuint32_t FEVTAC12TOE:1;
      vuint32_t FEVTAC12NE:1;
    } B;
  } FORCE_EVENT;

  union {                              /* ADMA Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t ADMADCE:1;
      vuint32_t ADMALME:1;
      vuint32_t ADMAES:2;
    } B;
  } ADMA_ERR_STATUS;

  union {                              /* ADMA System Address */
    vuint32_t R;
    struct {
      vuint32_t ADS_ADDR:30;
      vuint32_t  :2;
    } B;
  } ADMA_SYS_ADDR;

  uint8_t uSDHC_reserved1[100];
  union {                              /* Vendor Specific Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t AC12_RD_CHKBUSY_EN:1;
      vuint32_t CMD_OE_PRE_EN:1;
      vuint32_t DBG_SEL:4;
      vuint32_t INT_ST_VAL:8;
      vuint32_t CRC_CHK_DIS:1;
      vuint32_t CARD_CLK_SOFT_EN:1;
      vuint32_t IPG_PERCLK_SOFT_EN:1;
      vuint32_t HCLK_SOFT_EN:1;
      vuint32_t BUS_CLK_SOFT_EN:1;
      vuint32_t  :1;
      vuint32_t AC12_ISNOT_ABORT:1;
      vuint32_t FRC_SDCLK_ON:1;
      vuint32_t CLKONJ_IN_ABORT:1;
      vuint32_t WP_POL:1;
      vuint32_t CD_POL:1;
      vuint32_t DAT3_CD_POL:1;
      vuint32_t AC12_WR_CHKBUSY_EN:1;
      vuint32_t CONFLICT_CHK_EN:1;
      vuint32_t VSELECT:1;
      vuint32_t EXT_DMA_EN:1;
    } B;
  } VEND_SPEC;

  uint8_t uSDHC_reserved2[4];
  union {                              /* Vendor Specific 2 Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CARD_INT_AUTO_CLR_DIS:1;
      vuint32_t  :3;
      vuint32_t CARD_INT_D3_TEST:1;
      vuint32_t  :3;
    } B;
  } VEND_SPEC2;

  uint8_t uSDHC_reserved3[48];
  union {                              /* Host Controller Version */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t VVN:8;
      vuint32_t SVN:8;
    } B;
  } HOST_CTRL_VER;
};

#define SRAM0_START 0x40000000UL;
#define ADC_0 (*(volatile struct ADC_tag *) 0xFFE00000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFBE00000UL)
#define AIPS_A (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_B (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define AXBS_0 (*(volatile struct AXBS_tag *) 0xFC004000UL)
#define AXBS_1 (*(volatile struct AXBS_tag *) 0xFC008000UL)
#define BCTU (*(volatile struct BCTU_tag *) 0xFFC10000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_0_tag *) 0xFFEC0000UL)
#define CAN_1 (*(volatile struct CAN_1_7_tag *) 0xFBEC0000UL)
#define CAN_2 (*(volatile struct CAN_1_7_tag *) 0xFFEC4000UL)
#define CAN_3 (*(volatile struct CAN_1_7_tag *) 0xFBEC4000UL)
#define CAN_4 (*(volatile struct CAN_1_7_tag *) 0xFFEC8000UL)
#define CAN_5 (*(volatile struct CAN_1_7_tag *) 0xFBEC8000UL)
#define CAN_6 (*(volatile struct CAN_1_7_tag *) 0xFFECC000UL)
#define CAN_7 (*(volatile struct CAN_1_7_tag *) 0xFBECC000UL)
#define CMP_0 (*(volatile struct CMP_tag *) 0xFFCDC000UL)
#define CMP_1 (*(volatile struct CMP_tag *) 0xFFCE0000UL)
#define CMP_2 (*(volatile struct CMP_tag *) 0xFFCE4000UL)
#define CMU (*(volatile struct CMU_tag *) 0xFFFB0140UL)
#define CRC (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define EDMA (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define ENET (*(volatile struct ENET_tag *) 0xFFCC4000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FIRC (*(volatile struct FIRC_tag *) 0xFFFB0000UL)
#define FR (*(volatile struct FR_tag *) 0xFFE50000UL)
#define FXOSC (*(volatile struct FXOSC_tag *) 0xFFFB0040UL)
#define GPR (*(volatile struct GPR_tag *) 0xFFF94000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0xFFE68000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define I2C_2 (*(volatile struct I2C_tag *) 0xFFE6C000UL)
#define I2C_3 (*(volatile struct I2C_tag *) 0xFBE6C000UL)
#define I2S_0 (*(volatile struct I2S_tag *) 0xFFCB4000UL)
#define I2S_1 (*(volatile struct I2S_tag *) 0xFBCB4000UL)
#define I2S_2 (*(volatile struct I2S_tag *) 0xFFCB8000UL)
#define INTC (*(volatile struct INTC_tag *) 0xFC040000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_10 (*(volatile struct LINFlexD_tag *) 0xFFEA0000UL)
#define LINFlexD_11 (*(volatile struct LINFlexD_tag *) 0xFBEA0000UL)
#define LINFlexD_12 (*(volatile struct LINFlexD_tag *) 0xFFEA4000UL)
#define LINFlexD_13 (*(volatile struct LINFlexD_tag *) 0xFBEA4000UL)
#define LINFlexD_14 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_15 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define LINFlexD_16 (*(volatile struct LINFlexD_tag *) 0xFFEAC000UL)
#define LINFlexD_17 (*(volatile struct LINFlexD_tag *) 0xFBEAC000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFBE90000UL)
#define LINFlexD_4 (*(volatile struct LINFlexD_tag *) 0xFFE94000UL)
#define LINFlexD_5 (*(volatile struct LINFlexD_tag *) 0xFBE94000UL)
#define LINFlexD_6 (*(volatile struct LINFlexD_tag *) 0xFFE98000UL)
#define LINFlexD_7 (*(volatile struct LINFlexD_tag *) 0xFBE98000UL)
#define LINFlexD_8 (*(volatile struct LINFlexD_tag *) 0xFFE9C000UL)
#define LINFlexD_9 (*(volatile struct LINFlexD_tag *) 0xFBE9C000UL)
#define LPU (*(volatile struct LPU_tag *) 0xFFF9C000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU_0 (*(volatile struct MEMU_0_tag *) 0xFFF50000UL)
#define MEMU_1 (*(volatile struct MEMU_1_tag *) 0xFFFEC000UL)
#define MLB (*(volatile struct MLB_tag *) 0xFFC9C000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0080UL)
#define PMCDIG (*(volatile struct PMCDIG_tag *) 0xFFFA0400UL)
#define PRAMC_0 (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PRAMC_1 (*(volatile struct PRAMC_tag *) 0xFC024000UL)
#define PRAMC_2 (*(volatile struct PRAMC_tag *) 0xFC02C000UL)
#define RTC (*(volatile struct RTC_tag *) 0xFFFF0000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIRC (*(volatile struct SIRC_tag *) 0xFFFB00C0UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SPI_0 (*(volatile struct SPI_tag *) 0xFFFCC000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0xFBF9C000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0xFFFD0000UL)
#define SPI_3 (*(volatile struct SPI_tag *) 0xFBFA0000UL)
#define SPI_4 (*(volatile struct SPI_tag *) 0xFFFD4000UL)
#define SPI_5 (*(volatile struct SPI_tag *) 0xFBFA4000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define STM_2 (*(volatile struct STM_tag *) 0xFC070000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_2 (*(volatile struct SWT_tag *) 0xFC058000UL)
#define SXOSC (*(volatile struct SXOSC_tag *) 0xFFFB0100UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define UHST (*(volatile struct UHST_tag *) 0xFFC94000UL)
#define UHSTNC (*(volatile struct UHSTNC_tag *) 0xFFC94000UL)
#define UOTG (*(volatile struct UOTG_tag *) 0xFFC90000UL)
#define UOTGNC (*(volatile struct UOTGNC_tag *) 0xFFC90000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define eMIOS_0 (*(volatile struct eMIOS_tag *) 0xFFC38000UL)
#define eMIOS_1 (*(volatile struct eMIOS_tag *) 0xFBC38000UL)
#define eMIOS_2 (*(volatile struct eMIOS_tag *) 0xFFC3C000UL)
#define eMIOS_UC_0 (*(volatile struct eMIOS_UC_tag *) 0xFFC38000UL)
#define eMIOS_UC_1 (*(volatile struct eMIOS_UC_tag *) 0xFBC38000UL)
#define eMIOS_UC_2 (*(volatile struct eMIOS_UC_tag *) 0xFFC3C000UL)
#define uSDHC (*(volatile struct uSDHC_tag *) 0xFFCA4000UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_CEOCFR1        ADC_0.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_0_CEOCFR2        ADC_0.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_CIMR1          ADC_0.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_0_CIMR2          ADC_0.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_DMAR1          ADC_0.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_0_DMAR2          ADC_0.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_PSR1           ADC_0.PSR1.R                  /* Presampling register 1 */
#define ADC_0_PSR2           ADC_0.PSR2.R                  /* Presampling register 2 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_CTR2           ADC_0.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_NCMR1          ADC_0.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_0_NCMR2          ADC_0.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_JCMR1          ADC_0.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_0_JCMR2          ADC_0.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_0_DSDR           ADC_0.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR16          ADC_0.CDR[16].R               /*  */
#define ADC_0_CDR17          ADC_0.CDR[17].R               /*  */
#define ADC_0_CDR18          ADC_0.CDR[18].R               /*  */
#define ADC_0_CDR19          ADC_0.CDR[19].R               /*  */
#define ADC_0_CDR20          ADC_0.CDR[20].R               /*  */
#define ADC_0_CDR21          ADC_0.CDR[21].R               /*  */
#define ADC_0_CDR22          ADC_0.CDR[22].R               /*  */
#define ADC_0_CDR23          ADC_0.CDR[23].R               /*  */
#define ADC_0_CDR24          ADC_0.CDR[24].R               /*  */
#define ADC_0_CDR25          ADC_0.CDR[25].R               /*  */
#define ADC_0_CDR26          ADC_0.CDR[26].R               /*  */
#define ADC_0_CDR27          ADC_0.CDR[27].R               /*  */
#define ADC_0_CDR28          ADC_0.CDR[28].R               /*  */
#define ADC_0_CDR29          ADC_0.CDR[29].R               /*  */
#define ADC_0_CDR30          ADC_0.CDR[30].R               /*  */
#define ADC_0_CDR31          ADC_0.CDR[31].R               /*  */
#define ADC_0_CDR32          ADC_0.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR33          ADC_0.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR34          ADC_0.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR35          ADC_0.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR36          ADC_0.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR37          ADC_0.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR38          ADC_0.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR39          ADC_0.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR40          ADC_0.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR41          ADC_0.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR42          ADC_0.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR43          ADC_0.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR44          ADC_0.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR45          ADC_0.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR46          ADC_0.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR47          ADC_0.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR48          ADC_0.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR49          ADC_0.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR50          ADC_0.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR51          ADC_0.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR52          ADC_0.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR53          ADC_0.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR54          ADC_0.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR55          ADC_0.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR56          ADC_0.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR57          ADC_0.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR58          ADC_0.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR59          ADC_0.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR60          ADC_0.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR61          ADC_0.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR62          ADC_0.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR63          ADC_0.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR64          ADC_0.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR65          ADC_0.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR66          ADC_0.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR67          ADC_0.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR68          ADC_0.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR69          ADC_0.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR70          ADC_0.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR71          ADC_0.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR72          ADC_0.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR73          ADC_0.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR74          ADC_0.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR75          ADC_0.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR76          ADC_0.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR77          ADC_0.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR78          ADC_0.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR79          ADC_0.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR80          ADC_0.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR81          ADC_0.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR82          ADC_0.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR83          ADC_0.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR84          ADC_0.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR85          ADC_0.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR86          ADC_0.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR87          ADC_0.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR88          ADC_0.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR89          ADC_0.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR90          ADC_0.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR91          ADC_0.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR92          ADC_0.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR93          ADC_0.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR94          ADC_0.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR95          ADC_0.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_0_THRHLR4        ADC_0.THRHLR4.R               /* Threshold Register */
#define ADC_0_THRHLR5        ADC_0.THRHLR5.R               /* Threshold Register */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWSELR4        ADC_0.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_0_CWSELR5        ADC_0.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_0_CWSELR6        ADC_0.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_0_CWSELR7        ADC_0.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_0_CWSELR8        ADC_0.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_0_CWSELR9        ADC_0.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_0_CWSELR10       ADC_0.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_0_CWSELR11       ADC_0.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_CWENR1         ADC_0.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_0_CWENR2         ADC_0.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_AWORR1         ADC_0.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_0_AWORR2         ADC_0.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */

/* ADC */
#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_CEOCFR1        ADC_1.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_1_CEOCFR2        ADC_1.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_CIMR1          ADC_1.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_1_CIMR2          ADC_1.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_DMAR1          ADC_1.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_1_DMAR2          ADC_1.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_PSR1           ADC_1.PSR1.R                  /* Presampling register 1 */
#define ADC_1_PSR2           ADC_1.PSR2.R                  /* Presampling register 2 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_CTR2           ADC_1.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_NCMR1          ADC_1.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_1_NCMR2          ADC_1.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_JCMR1          ADC_1.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_1_JCMR2          ADC_1.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_1_DSDR           ADC_1.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR16          ADC_1.CDR[16].R               /*  */
#define ADC_1_CDR17          ADC_1.CDR[17].R               /*  */
#define ADC_1_CDR18          ADC_1.CDR[18].R               /*  */
#define ADC_1_CDR19          ADC_1.CDR[19].R               /*  */
#define ADC_1_CDR20          ADC_1.CDR[20].R               /*  */
#define ADC_1_CDR21          ADC_1.CDR[21].R               /*  */
#define ADC_1_CDR22          ADC_1.CDR[22].R               /*  */
#define ADC_1_CDR23          ADC_1.CDR[23].R               /*  */
#define ADC_1_CDR24          ADC_1.CDR[24].R               /*  */
#define ADC_1_CDR25          ADC_1.CDR[25].R               /*  */
#define ADC_1_CDR26          ADC_1.CDR[26].R               /*  */
#define ADC_1_CDR27          ADC_1.CDR[27].R               /*  */
#define ADC_1_CDR28          ADC_1.CDR[28].R               /*  */
#define ADC_1_CDR29          ADC_1.CDR[29].R               /*  */
#define ADC_1_CDR30          ADC_1.CDR[30].R               /*  */
#define ADC_1_CDR31          ADC_1.CDR[31].R               /*  */
#define ADC_1_CDR32          ADC_1.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR33          ADC_1.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR34          ADC_1.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR35          ADC_1.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR36          ADC_1.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR37          ADC_1.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR38          ADC_1.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR39          ADC_1.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR40          ADC_1.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR41          ADC_1.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR42          ADC_1.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR43          ADC_1.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR44          ADC_1.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR45          ADC_1.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR46          ADC_1.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR47          ADC_1.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR48          ADC_1.CDR[48].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR49          ADC_1.CDR[49].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR50          ADC_1.CDR[50].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR51          ADC_1.CDR[51].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR52          ADC_1.CDR[52].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR53          ADC_1.CDR[53].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR54          ADC_1.CDR[54].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR55          ADC_1.CDR[55].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR56          ADC_1.CDR[56].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR57          ADC_1.CDR[57].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR58          ADC_1.CDR[58].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR59          ADC_1.CDR[59].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR60          ADC_1.CDR[60].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR61          ADC_1.CDR[61].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR62          ADC_1.CDR[62].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR63          ADC_1.CDR[63].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR64          ADC_1.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR65          ADC_1.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR66          ADC_1.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR67          ADC_1.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR68          ADC_1.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR69          ADC_1.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR70          ADC_1.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR71          ADC_1.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR72          ADC_1.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR73          ADC_1.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR74          ADC_1.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR75          ADC_1.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR76          ADC_1.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR77          ADC_1.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR78          ADC_1.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR79          ADC_1.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR80          ADC_1.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR81          ADC_1.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR82          ADC_1.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR83          ADC_1.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR84          ADC_1.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR85          ADC_1.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR86          ADC_1.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR87          ADC_1.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR88          ADC_1.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR89          ADC_1.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR90          ADC_1.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR91          ADC_1.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR92          ADC_1.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR93          ADC_1.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR94          ADC_1.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR95          ADC_1.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_1_THRHLR4        ADC_1.THRHLR4.R               /* Threshold Register */
#define ADC_1_THRHLR5        ADC_1.THRHLR5.R               /* Threshold Register */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWSELR4        ADC_1.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_1_CWSELR5        ADC_1.CWSELR5.R               /* Channel Watchdog Select Register 5 */
#define ADC_1_CWSELR6        ADC_1.CWSELR6.R               /* Channel Watchdog Select Register 6 */
#define ADC_1_CWSELR7        ADC_1.CWSELR7.R               /* Channel Watchdog Select Register 7 */
#define ADC_1_CWSELR8        ADC_1.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_1_CWSELR9        ADC_1.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_1_CWSELR10       ADC_1.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_1_CWSELR11       ADC_1.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_CWENR1         ADC_1.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_1_CWENR2         ADC_1.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_AWORR1         ADC_1.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_1_AWORR2         ADC_1.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */

/* AIPS */
#define AIPS_A_MPRA          AIPS_A.MPRA.R                 /* Master Privilege Register A */
#define AIPS_A_MPRB          AIPS_A.MPRB.R                 /* Master Privilege Register B */
#define AIPS_A_PACRA         AIPS_A.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRB         AIPS_A.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRC         AIPS_A.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRD         AIPS_A.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRE         AIPS_A.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRF         AIPS_A.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRG         AIPS_A.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRH         AIPS_A.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_A_OPACRA        AIPS_A.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRB        AIPS_A.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRC        AIPS_A.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRD        AIPS_A.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRE        AIPS_A.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRF        AIPS_A.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRG        AIPS_A.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRH        AIPS_A.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRI        AIPS_A.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRJ        AIPS_A.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRK        AIPS_A.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRL        AIPS_A.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRM        AIPS_A.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRN        AIPS_A.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRO        AIPS_A.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRP        AIPS_A.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRQ        AIPS_A.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRR        AIPS_A.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRS        AIPS_A.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRT        AIPS_A.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRU        AIPS_A.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRV        AIPS_A.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRW        AIPS_A.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRX        AIPS_A.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRY        AIPS_A.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRZ        AIPS_A.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAA       AIPS_A.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAB       AIPS_A.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAC       AIPS_A.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAD       AIPS_A.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAE       AIPS_A.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAF       AIPS_A.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AIPS */
#define AIPS_B_MPRA          AIPS_B.MPRA.R                 /* Master Privilege Register A */
#define AIPS_B_MPRB          AIPS_B.MPRB.R                 /* Master Privilege Register B */
#define AIPS_B_PACRA         AIPS_B.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRB         AIPS_B.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRC         AIPS_B.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRD         AIPS_B.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRE         AIPS_B.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRF         AIPS_B.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRG         AIPS_B.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRH         AIPS_B.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_B_OPACRA        AIPS_B.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRB        AIPS_B.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRC        AIPS_B.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRD        AIPS_B.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRE        AIPS_B.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRF        AIPS_B.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRG        AIPS_B.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRH        AIPS_B.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRI        AIPS_B.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRJ        AIPS_B.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRK        AIPS_B.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRL        AIPS_B.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRM        AIPS_B.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRN        AIPS_B.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRO        AIPS_B.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRP        AIPS_B.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRQ        AIPS_B.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRR        AIPS_B.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRS        AIPS_B.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRT        AIPS_B.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRU        AIPS_B.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRV        AIPS_B.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRW        AIPS_B.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRX        AIPS_B.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRY        AIPS_B.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRZ        AIPS_B.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAA       AIPS_B.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAB       AIPS_B.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAC       AIPS_B.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAD       AIPS_B.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAE       AIPS_B.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAF       AIPS_B.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* AXBS */
#define AXBS_0_PRS0          AXBS_0.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS0          AXBS_0.PORT[0].CRS.R          /* Control Register */
#define AXBS_0_PRS1          AXBS_0.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS1          AXBS_0.PORT[1].CRS.R          /* Control Register */
#define AXBS_0_PRS2          AXBS_0.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS2          AXBS_0.PORT[2].CRS.R          /* Control Register */
#define AXBS_0_PRS3          AXBS_0.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS3          AXBS_0.PORT[3].CRS.R          /* Control Register */
#define AXBS_0_PRS4          AXBS_0.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS4          AXBS_0.PORT[4].CRS.R          /* Control Register */
#define AXBS_0_PRS5          AXBS_0.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS5          AXBS_0.PORT[5].CRS.R          /* Control Register */
#define AXBS_0_PRS6          AXBS_0.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS6          AXBS_0.PORT[6].CRS.R          /* Control Register */
#define AXBS_0_PRS7          AXBS_0.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_0_CRS7          AXBS_0.PORT[7].CRS.R          /* Control Register */
#define AXBS_0_MGPCR0        AXBS_0.MGPCR[0].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR1        AXBS_0.MGPCR[1].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR2        AXBS_0.MGPCR[2].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR3        AXBS_0.MGPCR[3].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR4        AXBS_0.MGPCR[4].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR5        AXBS_0.MGPCR[5].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR6        AXBS_0.MGPCR[6].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_0_MGPCR7        AXBS_0.MGPCR[7].MGPCR.R       /* Master General Purpose Control Register */

/* AXBS */
#define AXBS_1_PRS0          AXBS_1.PORT[0].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS0          AXBS_1.PORT[0].CRS.R          /* Control Register */
#define AXBS_1_PRS1          AXBS_1.PORT[1].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS1          AXBS_1.PORT[1].CRS.R          /* Control Register */
#define AXBS_1_PRS2          AXBS_1.PORT[2].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS2          AXBS_1.PORT[2].CRS.R          /* Control Register */
#define AXBS_1_PRS3          AXBS_1.PORT[3].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS3          AXBS_1.PORT[3].CRS.R          /* Control Register */
#define AXBS_1_PRS4          AXBS_1.PORT[4].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS4          AXBS_1.PORT[4].CRS.R          /* Control Register */
#define AXBS_1_PRS5          AXBS_1.PORT[5].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS5          AXBS_1.PORT[5].CRS.R          /* Control Register */
#define AXBS_1_PRS6          AXBS_1.PORT[6].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS6          AXBS_1.PORT[6].CRS.R          /* Control Register */
#define AXBS_1_PRS7          AXBS_1.PORT[7].PRS.R          /* Priority Registers Slave */
#define AXBS_1_CRS7          AXBS_1.PORT[7].CRS.R          /* Control Register */
#define AXBS_1_MGPCR0        AXBS_1.MGPCR[0].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR1        AXBS_1.MGPCR[1].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR2        AXBS_1.MGPCR[2].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR3        AXBS_1.MGPCR[3].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR4        AXBS_1.MGPCR[4].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR5        AXBS_1.MGPCR[5].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR6        AXBS_1.MGPCR[6].MGPCR.R       /* Master General Purpose Control Register */
#define AXBS_1_MGPCR7        AXBS_1.MGPCR[7].MGPCR.R       /* Master General Purpose Control Register */

/* BCTU */
#define BCTU_MCR             BCTU.MCR.R                    /* Module Configuration Register */
#define BCTU_MSR             BCTU.MSR.R                    /* Module Status register */
#define BCTU_TRGCFG_0        BCTU.TRGCFG[0].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_1        BCTU.TRGCFG[1].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_2        BCTU.TRGCFG[2].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_3        BCTU.TRGCFG[3].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_4        BCTU.TRGCFG[4].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_5        BCTU.TRGCFG[5].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_6        BCTU.TRGCFG[6].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_7        BCTU.TRGCFG[7].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_8        BCTU.TRGCFG[8].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_9        BCTU.TRGCFG[9].R              /* Trigger Configuration Register */
#define BCTU_TRGCFG_10       BCTU.TRGCFG[10].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_11       BCTU.TRGCFG[11].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_12       BCTU.TRGCFG[12].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_13       BCTU.TRGCFG[13].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_14       BCTU.TRGCFG[14].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_15       BCTU.TRGCFG[15].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_16       BCTU.TRGCFG[16].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_17       BCTU.TRGCFG[17].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_18       BCTU.TRGCFG[18].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_19       BCTU.TRGCFG[19].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_20       BCTU.TRGCFG[20].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_21       BCTU.TRGCFG[21].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_22       BCTU.TRGCFG[22].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_23       BCTU.TRGCFG[23].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_24       BCTU.TRGCFG[24].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_25       BCTU.TRGCFG[25].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_26       BCTU.TRGCFG[26].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_27       BCTU.TRGCFG[27].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_28       BCTU.TRGCFG[28].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_29       BCTU.TRGCFG[29].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_30       BCTU.TRGCFG[30].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_31       BCTU.TRGCFG[31].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_32       BCTU.TRGCFG[32].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_33       BCTU.TRGCFG[33].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_34       BCTU.TRGCFG[34].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_35       BCTU.TRGCFG[35].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_36       BCTU.TRGCFG[36].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_37       BCTU.TRGCFG[37].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_38       BCTU.TRGCFG[38].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_39       BCTU.TRGCFG[39].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_40       BCTU.TRGCFG[40].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_41       BCTU.TRGCFG[41].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_42       BCTU.TRGCFG[42].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_43       BCTU.TRGCFG[43].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_44       BCTU.TRGCFG[44].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_45       BCTU.TRGCFG[45].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_46       BCTU.TRGCFG[46].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_47       BCTU.TRGCFG[47].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_48       BCTU.TRGCFG[48].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_49       BCTU.TRGCFG[49].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_50       BCTU.TRGCFG[50].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_51       BCTU.TRGCFG[51].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_52       BCTU.TRGCFG[52].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_53       BCTU.TRGCFG[53].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_54       BCTU.TRGCFG[54].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_55       BCTU.TRGCFG[55].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_56       BCTU.TRGCFG[56].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_57       BCTU.TRGCFG[57].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_58       BCTU.TRGCFG[58].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_59       BCTU.TRGCFG[59].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_60       BCTU.TRGCFG[60].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_61       BCTU.TRGCFG[61].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_62       BCTU.TRGCFG[62].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_63       BCTU.TRGCFG[63].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_64       BCTU.TRGCFG[64].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_65       BCTU.TRGCFG[65].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_66       BCTU.TRGCFG[66].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_67       BCTU.TRGCFG[67].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_68       BCTU.TRGCFG[68].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_69       BCTU.TRGCFG[69].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_70       BCTU.TRGCFG[70].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_71       BCTU.TRGCFG[71].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_72       BCTU.TRGCFG[72].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_73       BCTU.TRGCFG[73].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_74       BCTU.TRGCFG[74].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_75       BCTU.TRGCFG[75].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_76       BCTU.TRGCFG[76].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_77       BCTU.TRGCFG[77].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_78       BCTU.TRGCFG[78].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_79       BCTU.TRGCFG[79].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_80       BCTU.TRGCFG[80].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_81       BCTU.TRGCFG[81].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_82       BCTU.TRGCFG[82].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_83       BCTU.TRGCFG[83].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_84       BCTU.TRGCFG[84].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_85       BCTU.TRGCFG[85].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_86       BCTU.TRGCFG[86].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_87       BCTU.TRGCFG[87].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_88       BCTU.TRGCFG[88].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_89       BCTU.TRGCFG[89].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_90       BCTU.TRGCFG[90].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_91       BCTU.TRGCFG[91].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_92       BCTU.TRGCFG[92].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_93       BCTU.TRGCFG[93].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_94       BCTU.TRGCFG[94].R             /* Trigger Configuration Register */
#define BCTU_TRGCFG_95       BCTU.TRGCFG[95].R             /* Trigger Configuration Register */
#define BCTU_WRPROT          BCTU.WRPROT.R                 /* Write Protection register */
#define BCTU_SFTRGR1         BCTU.SFTRGR1.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR2         BCTU.SFTRGR2.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR3         BCTU.SFTRGR3.R                /* Software Trigger register 1 */
#define BCTU_ADC0DR          BCTU.ADC0DR.R                 /* ADC0 Result Data register */
#define BCTU_ADC1DR          BCTU.ADC1DR.R                 /* ADC1 result data register */
#define BCTU_LISTSTAR        BCTU.LISTSTAR.R               /* LIST Size Status register */
#define BCTU_LISTCHR_0       BCTU.LISTCHR[0].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_1       BCTU.LISTCHR[1].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_2       BCTU.LISTCHR[2].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_3       BCTU.LISTCHR[3].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_4       BCTU.LISTCHR[4].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_5       BCTU.LISTCHR[5].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_6       BCTU.LISTCHR[6].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_7       BCTU.LISTCHR[7].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_8       BCTU.LISTCHR[8].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_9       BCTU.LISTCHR[9].R             /* LIST Channel Address Register */
#define BCTU_LISTCHR_10      BCTU.LISTCHR[10].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_11      BCTU.LISTCHR[11].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_12      BCTU.LISTCHR[12].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_13      BCTU.LISTCHR[13].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_14      BCTU.LISTCHR[14].R            /* LIST Channel Address Register */
#define BCTU_LISTCHR_15      BCTU.LISTCHR[15].R            /* LIST Channel Address Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN_0 */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */

#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CBT            CAN_0.CBT.R                   /* CAN Bit Timing Register */
#define CAN_0_IMASK3         CAN_0.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_0_IFLAG3         CAN_0.IFLAG3.R                /* Interrupt Flags 3 Register */

#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_0_CS64           CAN_0.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_0_ID64           CAN_0.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_0_B64            CAN_0.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_0_H64            CAN_0.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_0_W64            CAN_0.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_0_CS65           CAN_0.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_0_ID65           CAN_0.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_0_B65            CAN_0.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_0_H65            CAN_0.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_0_W65            CAN_0.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_0_CS66           CAN_0.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_0_ID66           CAN_0.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_0_B66            CAN_0.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_0_H66            CAN_0.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_0_W66            CAN_0.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_0_CS67           CAN_0.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_0_ID67           CAN_0.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_0_B67            CAN_0.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_0_H67            CAN_0.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_0_W67            CAN_0.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_0_CS68           CAN_0.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_0_ID68           CAN_0.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_0_B68            CAN_0.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_0_H68            CAN_0.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_0_W68            CAN_0.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_0_CS69           CAN_0.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_0_ID69           CAN_0.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_0_B69            CAN_0.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_0_H69            CAN_0.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_0_W69            CAN_0.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_0_CS70           CAN_0.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_0_ID70           CAN_0.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_0_B70            CAN_0.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_0_H70            CAN_0.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_0_W70            CAN_0.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_0_CS71           CAN_0.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_0_ID71           CAN_0.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_0_B71            CAN_0.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_0_H71            CAN_0.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_0_W71            CAN_0.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_0_CS72           CAN_0.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_0_ID72           CAN_0.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_0_B72            CAN_0.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_0_H72            CAN_0.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_0_W72            CAN_0.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_0_CS73           CAN_0.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_0_ID73           CAN_0.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_0_B73            CAN_0.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_0_H73            CAN_0.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_0_W73            CAN_0.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_0_CS74           CAN_0.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_0_ID74           CAN_0.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_0_B74            CAN_0.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_0_H74            CAN_0.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_0_W74            CAN_0.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_0_CS75           CAN_0.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_0_ID75           CAN_0.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_0_B75            CAN_0.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_0_H75            CAN_0.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_0_W75            CAN_0.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_0_CS76           CAN_0.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_0_ID76           CAN_0.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_0_B76            CAN_0.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_0_H76            CAN_0.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_0_W76            CAN_0.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_0_CS77           CAN_0.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_0_ID77           CAN_0.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_0_B77            CAN_0.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_0_H77            CAN_0.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_0_W77            CAN_0.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_0_CS78           CAN_0.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_0_ID78           CAN_0.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_0_B78            CAN_0.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_0_H78            CAN_0.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_0_W78            CAN_0.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_0_CS79           CAN_0.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_0_ID79           CAN_0.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_0_B79            CAN_0.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_0_H79            CAN_0.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_0_W79            CAN_0.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_0_CS80           CAN_0.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_0_ID80           CAN_0.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_0_B80            CAN_0.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_0_H80            CAN_0.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_0_W80            CAN_0.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_0_CS81           CAN_0.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_0_ID81           CAN_0.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_0_B81            CAN_0.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_0_H81            CAN_0.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_0_W81            CAN_0.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_0_CS82           CAN_0.MB[82].CS.R             /* Message Buffer 82 CS Register */
#define CAN_0_ID82           CAN_0.MB[82].ID.R             /* Message Buffer 82 ID Register */
#define CAN_0_B82            CAN_0.MB[82].DATA.B           /* Message Buffer 82 B Register */
#define CAN_0_H82            CAN_0.MB[82].DATA.H           /* Message Buffer 82 H Register */
#define CAN_0_W82            CAN_0.MB[82].DATA.W           /* Message Buffer 82 W Register */
#define CAN_0_CS83           CAN_0.MB[83].CS.R             /* Message Buffer 83 CS Register */
#define CAN_0_ID83           CAN_0.MB[83].ID.R             /* Message Buffer 83 ID Register */
#define CAN_0_B83            CAN_0.MB[83].DATA.B           /* Message Buffer 83 B Register */
#define CAN_0_H83            CAN_0.MB[83].DATA.H           /* Message Buffer 83 H Register */
#define CAN_0_W83            CAN_0.MB[83].DATA.W           /* Message Buffer 83 W Register */
#define CAN_0_CS84           CAN_0.MB[84].CS.R             /* Message Buffer 84 CS Register */
#define CAN_0_ID84           CAN_0.MB[84].ID.R             /* Message Buffer 84 ID Register */
#define CAN_0_B84            CAN_0.MB[84].DATA.B           /* Message Buffer 84 B Register */
#define CAN_0_H84            CAN_0.MB[84].DATA.H           /* Message Buffer 84 H Register */
#define CAN_0_W84            CAN_0.MB[84].DATA.W           /* Message Buffer 84 W Register */
#define CAN_0_CS85           CAN_0.MB[85].CS.R             /* Message Buffer 85 CS Register */
#define CAN_0_ID85           CAN_0.MB[85].ID.R             /* Message Buffer 85 ID Register */
#define CAN_0_B85            CAN_0.MB[85].DATA.B           /* Message Buffer 85 B Register */
#define CAN_0_H85            CAN_0.MB[85].DATA.H           /* Message Buffer 85 H Register */
#define CAN_0_W85            CAN_0.MB[85].DATA.W           /* Message Buffer 85 W Register */
#define CAN_0_CS86           CAN_0.MB[86].CS.R             /* Message Buffer 86 CS Register */
#define CAN_0_ID86           CAN_0.MB[86].ID.R             /* Message Buffer 86 ID Register */
#define CAN_0_B86            CAN_0.MB[86].DATA.B           /* Message Buffer 86 B Register */
#define CAN_0_H86            CAN_0.MB[86].DATA.H           /* Message Buffer 86 H Register */
#define CAN_0_W86            CAN_0.MB[86].DATA.W           /* Message Buffer 86 W Register */
#define CAN_0_CS87           CAN_0.MB[87].CS.R             /* Message Buffer 87 CS Register */
#define CAN_0_ID87           CAN_0.MB[87].ID.R             /* Message Buffer 87 ID Register */
#define CAN_0_B87            CAN_0.MB[87].DATA.B           /* Message Buffer 87 B Register */
#define CAN_0_H87            CAN_0.MB[87].DATA.H           /* Message Buffer 87 H Register */
#define CAN_0_W87            CAN_0.MB[87].DATA.W           /* Message Buffer 87 W Register */
#define CAN_0_CS88           CAN_0.MB[88].CS.R             /* Message Buffer 88 CS Register */
#define CAN_0_ID88           CAN_0.MB[88].ID.R             /* Message Buffer 88 ID Register */
#define CAN_0_B88            CAN_0.MB[88].DATA.B           /* Message Buffer 88 B Register */
#define CAN_0_H88            CAN_0.MB[88].DATA.H           /* Message Buffer 88 H Register */
#define CAN_0_W88            CAN_0.MB[88].DATA.W           /* Message Buffer 88 W Register */
#define CAN_0_CS89           CAN_0.MB[89].CS.R             /* Message Buffer 89 CS Register */
#define CAN_0_ID89           CAN_0.MB[89].ID.R             /* Message Buffer 89 ID Register */
#define CAN_0_B89            CAN_0.MB[89].DATA.B           /* Message Buffer 89 B Register */
#define CAN_0_H89            CAN_0.MB[89].DATA.H           /* Message Buffer 89 H Register */
#define CAN_0_W89            CAN_0.MB[89].DATA.W           /* Message Buffer 89 W Register */
#define CAN_0_CS90           CAN_0.MB[90].CS.R             /* Message Buffer 90 CS Register */
#define CAN_0_ID90           CAN_0.MB[90].ID.R             /* Message Buffer 90 ID Register */
#define CAN_0_B90            CAN_0.MB[90].DATA.B           /* Message Buffer 90 B Register */
#define CAN_0_H90            CAN_0.MB[90].DATA.H           /* Message Buffer 90 H Register */
#define CAN_0_W90            CAN_0.MB[90].DATA.W           /* Message Buffer 90 W Register */
#define CAN_0_CS91           CAN_0.MB[91].CS.R             /* Message Buffer 91 CS Register */
#define CAN_0_ID91           CAN_0.MB[91].ID.R             /* Message Buffer 91 ID Register */
#define CAN_0_B91            CAN_0.MB[91].DATA.B           /* Message Buffer 91 B Register */
#define CAN_0_H91            CAN_0.MB[91].DATA.H           /* Message Buffer 91 H Register */
#define CAN_0_W91            CAN_0.MB[91].DATA.W           /* Message Buffer 91 W Register */
#define CAN_0_CS92           CAN_0.MB[92].CS.R             /* Message Buffer 92 CS Register */
#define CAN_0_ID92           CAN_0.MB[92].ID.R             /* Message Buffer 92 ID Register */
#define CAN_0_B92            CAN_0.MB[92].DATA.B           /* Message Buffer 92 B Register */
#define CAN_0_H92            CAN_0.MB[92].DATA.H           /* Message Buffer 92 H Register */
#define CAN_0_W92            CAN_0.MB[92].DATA.W           /* Message Buffer 92 W Register */
#define CAN_0_CS93           CAN_0.MB[93].CS.R             /* Message Buffer 93 CS Register */
#define CAN_0_ID93           CAN_0.MB[93].ID.R             /* Message Buffer 93 ID Register */
#define CAN_0_B93            CAN_0.MB[93].DATA.B           /* Message Buffer 93 B Register */
#define CAN_0_H93            CAN_0.MB[93].DATA.H           /* Message Buffer 93 H Register */
#define CAN_0_W93            CAN_0.MB[93].DATA.W           /* Message Buffer 93 W Register */
#define CAN_0_CS94           CAN_0.MB[94].CS.R             /* Message Buffer 94 CS Register */
#define CAN_0_ID94           CAN_0.MB[94].ID.R             /* Message Buffer 94 ID Register */
#define CAN_0_B94            CAN_0.MB[94].DATA.B           /* Message Buffer 94 B Register */
#define CAN_0_H94            CAN_0.MB[94].DATA.H           /* Message Buffer 94 H Register */
#define CAN_0_W94            CAN_0.MB[94].DATA.W           /* Message Buffer 94 W Register */
#define CAN_0_CS95           CAN_0.MB[95].CS.R             /* Message Buffer 95 CS Register */
#define CAN_0_ID95           CAN_0.MB[95].ID.R             /* Message Buffer 95 ID Register */
#define CAN_0_B95            CAN_0.MB[95].DATA.B           /* Message Buffer 95 B Register */
#define CAN_0_H95            CAN_0.MB[95].DATA.H           /* Message Buffer 95 H Register */
#define CAN_0_W95            CAN_0.MB[95].DATA.W           /* Message Buffer 95 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR64        CAN_0.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR65        CAN_0.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR66        CAN_0.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR67        CAN_0.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR68        CAN_0.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR69        CAN_0.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR70        CAN_0.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR71        CAN_0.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR72        CAN_0.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR73        CAN_0.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR74        CAN_0.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR75        CAN_0.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR76        CAN_0.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR77        CAN_0.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR78        CAN_0.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR79        CAN_0.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR80        CAN_0.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR81        CAN_0.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR82        CAN_0.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR83        CAN_0.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR84        CAN_0.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR85        CAN_0.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR86        CAN_0.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR87        CAN_0.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR88        CAN_0.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR89        CAN_0.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR90        CAN_0.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR91        CAN_0.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR92        CAN_0.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR93        CAN_0.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR94        CAN_0.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR95        CAN_0.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */
#define CAN_0_CTRL1_PN       CAN_0.CTRL1_PN.R              /* Pretended Networking Control 1 Register */
#define CAN_0_CTRL2_PN       CAN_0.CTRL2_PN.R              /* Pretended Networking Control 2 Register */
#define CAN_0_WU_MTC         CAN_0.WU_MTC.R                /* Pretended Networking Wake Up Match Register */
#define CAN_0_FLT_ID1        CAN_0.FLT_ID1.R               /* Pretended Networking ID Filter 1 Register */
#define CAN_0_FLT_DLC        CAN_0.FLT_DLC.R               /* Pretended Networking DLC Filter Register */
#define CAN_0_PL1_LO         CAN_0.PL1_LO.R                /* Pretended Networking Payload Low Filter 1 Register */
#define CAN_0_PL1_HI         CAN_0.PL1_HI.R                /* Pretended Networking Payload High Filter 1 Register */
#define CAN_0_FLT_ID2_IDMASK CAN_0.FLT_ID2_IDMASK.R        /* Pretended Networking ID Filter 2 Register / ID Mask Register */
#define CAN_0_PL2_PLMASK_LO  CAN_0.PL2_PLMASK_LO.R         /* Pretended Networking Payload Low Filter 2 Register / Payload Low Mask Register */
#define CAN_0_PL2_PLMASK_HI  CAN_0.PL2_PLMASK_HI.R         /* Pretended Networking Payload High Filter 2 low order bits / Payload High Mask Register */
#define CAN_0_WMB0_CS        CAN_0.WMB[0].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB0_ID        CAN_0.WMB[0].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB0_D03       CAN_0.WMB[0].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB0_D47       CAN_0.WMB[0].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB1_CS        CAN_0.WMB[1].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB1_ID        CAN_0.WMB[1].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB1_D03       CAN_0.WMB[1].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB1_D47       CAN_0.WMB[1].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB2_CS        CAN_0.WMB[2].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB2_ID        CAN_0.WMB[2].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB2_D03       CAN_0.WMB[2].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB2_D47       CAN_0.WMB[2].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_WMB3_CS        CAN_0.WMB[3].CS.R             /* Wake Up Message Buffer Register for C/S */
#define CAN_0_WMB3_ID        CAN_0.WMB[3].ID.R             /* Wake Up Message Buffer Register for ID */
#define CAN_0_WMB3_D03       CAN_0.WMB[3].D03.R            /* Wake Up Message Buffer Register for Data 0-3 */
#define CAN_0_WMB3_D47       CAN_0.WMB[3].D47.R            /* Wake Up Message Buffer Register Data 4-7 */
#define CAN_0_FDCTRL         CAN_0.FDCTRL.R                /* CAN FD Control Register */
#define CAN_0_FDCBT          CAN_0.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_0_FDCRC          CAN_0.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CS0            CAN_1.MB[0].CS.R             /* Message Buffer 0 CS Register */
#define CAN_1_ID0            CAN_1.MB[0].ID.R             /* Message Buffer 0 ID Register */
#define CAN_1_B0             CAN_1.MB[0].DATA.B           /* Message Buffer 0 B Register */
#define CAN_1_H0             CAN_1.MB[0].DATA.H           /* Message Buffer 0 H Register */
#define CAN_1_W0             CAN_1.MB[0].DATA.W           /* Message Buffer 0 W Register */
#define CAN_1_CS1            CAN_1.MB[1].CS.R             /* Message Buffer 1 CS Register */
#define CAN_1_ID1            CAN_1.MB[1].ID.R             /* Message Buffer 1 ID Register */
#define CAN_1_B1             CAN_1.MB[1].DATA.B           /* Message Buffer 1 B Register */
#define CAN_1_H1             CAN_1.MB[1].DATA.H           /* Message Buffer 1 H Register */
#define CAN_1_W1             CAN_1.MB[1].DATA.W           /* Message Buffer 1 W Register */
#define CAN_1_CS2            CAN_1.MB[2].CS.R             /* Message Buffer 2 CS Register */
#define CAN_1_ID2            CAN_1.MB[2].ID.R             /* Message Buffer 2 ID Register */
#define CAN_1_B2             CAN_1.MB[2].DATA.B           /* Message Buffer 2 B Register */
#define CAN_1_H2             CAN_1.MB[2].DATA.H           /* Message Buffer 2 H Register */
#define CAN_1_W2             CAN_1.MB[2].DATA.W           /* Message Buffer 2 W Register */
#define CAN_1_CS3            CAN_1.MB[3].CS.R             /* Message Buffer 3 CS Register */
#define CAN_1_ID3            CAN_1.MB[3].ID.R             /* Message Buffer 3 ID Register */
#define CAN_1_B3             CAN_1.MB[3].DATA.B           /* Message Buffer 3 B Register */
#define CAN_1_H3             CAN_1.MB[3].DATA.H           /* Message Buffer 3 H Register */
#define CAN_1_W3             CAN_1.MB[3].DATA.W           /* Message Buffer 3 W Register */
#define CAN_1_CS4            CAN_1.MB[4].CS.R             /* Message Buffer 4 CS Register */
#define CAN_1_ID4            CAN_1.MB[4].ID.R             /* Message Buffer 4 ID Register */
#define CAN_1_B4             CAN_1.MB[4].DATA.B           /* Message Buffer 4 B Register */
#define CAN_1_H4             CAN_1.MB[4].DATA.H           /* Message Buffer 4 H Register */
#define CAN_1_W4             CAN_1.MB[4].DATA.W           /* Message Buffer 4 W Register */
#define CAN_1_CS5            CAN_1.MB[5].CS.R             /* Message Buffer 5 CS Register */
#define CAN_1_ID5            CAN_1.MB[5].ID.R             /* Message Buffer 5 ID Register */
#define CAN_1_B5             CAN_1.MB[5].DATA.B           /* Message Buffer 5 B Register */
#define CAN_1_H5             CAN_1.MB[5].DATA.H           /* Message Buffer 5 H Register */
#define CAN_1_W5             CAN_1.MB[5].DATA.W           /* Message Buffer 5 W Register */
#define CAN_1_CS6            CAN_1.MB[6].CS.R             /* Message Buffer 6 CS Register */
#define CAN_1_ID6            CAN_1.MB[6].ID.R             /* Message Buffer 6 ID Register */
#define CAN_1_B6             CAN_1.MB[6].DATA.B           /* Message Buffer 6 B Register */
#define CAN_1_H6             CAN_1.MB[6].DATA.H           /* Message Buffer 6 H Register */
#define CAN_1_W6             CAN_1.MB[6].DATA.W           /* Message Buffer 6 W Register */
#define CAN_1_CS7            CAN_1.MB[7].CS.R             /* Message Buffer 7 CS Register */
#define CAN_1_ID7            CAN_1.MB[7].ID.R             /* Message Buffer 7 ID Register */
#define CAN_1_B7             CAN_1.MB[7].DATA.B           /* Message Buffer 7 B Register */
#define CAN_1_H7             CAN_1.MB[7].DATA.H           /* Message Buffer 7 H Register */
#define CAN_1_W7             CAN_1.MB[7].DATA.W           /* Message Buffer 7 W Register */
#define CAN_1_CS8            CAN_1.MB[8].CS.R             /* Message Buffer 8 CS Register */
#define CAN_1_ID8            CAN_1.MB[8].ID.R             /* Message Buffer 8 ID Register */
#define CAN_1_B8             CAN_1.MB[8].DATA.B           /* Message Buffer 8 B Register */
#define CAN_1_H8             CAN_1.MB[8].DATA.H           /* Message Buffer 8 H Register */
#define CAN_1_W8             CAN_1.MB[8].DATA.W           /* Message Buffer 8 W Register */
#define CAN_1_CS9            CAN_1.MB[9].CS.R             /* Message Buffer 9 CS Register */
#define CAN_1_ID9            CAN_1.MB[9].ID.R             /* Message Buffer 9 ID Register */
#define CAN_1_B9             CAN_1.MB[9].DATA.B           /* Message Buffer 9 B Register */
#define CAN_1_H9             CAN_1.MB[9].DATA.H           /* Message Buffer 9 H Register */
#define CAN_1_W9             CAN_1.MB[9].DATA.W           /* Message Buffer 9 W Register */
#define CAN_1_CS10           CAN_1.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_1_ID10           CAN_1.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_1_B10            CAN_1.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_1_H10            CAN_1.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_1_W10            CAN_1.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_1_CS11           CAN_1.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_1_ID11           CAN_1.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_1_B11            CAN_1.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_1_H11            CAN_1.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_1_W11            CAN_1.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_1_CS12           CAN_1.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_1_ID12           CAN_1.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_1_B12            CAN_1.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_1_H12            CAN_1.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_1_W12            CAN_1.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_1_CS13           CAN_1.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_1_ID13           CAN_1.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_1_B13            CAN_1.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_1_H13            CAN_1.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_1_W13            CAN_1.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_1_CS14           CAN_1.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_1_ID14           CAN_1.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_1_B14            CAN_1.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_1_H14            CAN_1.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_1_W14            CAN_1.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_1_CS15           CAN_1.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_1_ID15           CAN_1.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_1_B15            CAN_1.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_1_H15            CAN_1.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_1_W15            CAN_1.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_1_CS16           CAN_1.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_1_ID16           CAN_1.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_1_B16            CAN_1.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_1_H16            CAN_1.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_1_W16            CAN_1.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_1_CS17           CAN_1.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_1_ID17           CAN_1.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_1_B17            CAN_1.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_1_H17            CAN_1.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_1_W17            CAN_1.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_1_CS18           CAN_1.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_1_ID18           CAN_1.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_1_B18            CAN_1.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_1_H18            CAN_1.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_1_W18            CAN_1.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_1_CS19           CAN_1.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_1_ID19           CAN_1.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_1_B19            CAN_1.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_1_H19            CAN_1.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_1_W19            CAN_1.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_1_CS20           CAN_1.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_1_ID20           CAN_1.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_1_B20            CAN_1.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_1_H20            CAN_1.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_1_W20            CAN_1.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_1_CS21           CAN_1.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_1_ID21           CAN_1.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_1_B21            CAN_1.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_1_H21            CAN_1.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_1_W21            CAN_1.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_1_CS22           CAN_1.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_1_ID22           CAN_1.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_1_B22            CAN_1.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_1_H22            CAN_1.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_1_W22            CAN_1.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_1_CS23           CAN_1.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_1_ID23           CAN_1.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_1_B23            CAN_1.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_1_H23            CAN_1.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_1_W23            CAN_1.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_1_CS24           CAN_1.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_1_ID24           CAN_1.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_1_B24            CAN_1.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_1_H24            CAN_1.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_1_W24            CAN_1.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_1_CS25           CAN_1.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_1_ID25           CAN_1.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_1_B25            CAN_1.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_1_H25            CAN_1.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_1_W25            CAN_1.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_1_CS26           CAN_1.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_1_ID26           CAN_1.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_1_B26            CAN_1.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_1_H26            CAN_1.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_1_W26            CAN_1.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_1_CS27           CAN_1.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_1_ID27           CAN_1.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_1_B27            CAN_1.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_1_H27            CAN_1.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_1_W27            CAN_1.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_1_CS28           CAN_1.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_1_ID28           CAN_1.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_1_B28            CAN_1.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_1_H28            CAN_1.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_1_W28            CAN_1.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_1_CS29           CAN_1.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_1_ID29           CAN_1.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_1_B29            CAN_1.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_1_H29            CAN_1.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_1_W29            CAN_1.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_1_CS30           CAN_1.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_1_ID30           CAN_1.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_1_B30            CAN_1.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_1_H30            CAN_1.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_1_W30            CAN_1.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_1_CS31           CAN_1.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_1_ID31           CAN_1.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_1_B31            CAN_1.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_1_H31            CAN_1.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_1_W31            CAN_1.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_1_CS32           CAN_1.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_1_ID32           CAN_1.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_1_B32            CAN_1.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_1_H32            CAN_1.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_1_W32            CAN_1.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_1_CS33           CAN_1.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_1_ID33           CAN_1.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_1_B33            CAN_1.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_1_H33            CAN_1.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_1_W33            CAN_1.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_1_CS34           CAN_1.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_1_ID34           CAN_1.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_1_B34            CAN_1.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_1_H34            CAN_1.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_1_W34            CAN_1.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_1_CS35           CAN_1.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_1_ID35           CAN_1.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_1_B35            CAN_1.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_1_H35            CAN_1.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_1_W35            CAN_1.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_1_CS36           CAN_1.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_1_ID36           CAN_1.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_1_B36            CAN_1.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_1_H36            CAN_1.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_1_W36            CAN_1.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_1_CS37           CAN_1.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_1_ID37           CAN_1.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_1_B37            CAN_1.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_1_H37            CAN_1.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_1_W37            CAN_1.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_1_CS38           CAN_1.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_1_ID38           CAN_1.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_1_B38            CAN_1.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_1_H38            CAN_1.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_1_W38            CAN_1.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_1_CS39           CAN_1.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_1_ID39           CAN_1.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_1_B39            CAN_1.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_1_H39            CAN_1.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_1_W39            CAN_1.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_1_CS40           CAN_1.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_1_ID40           CAN_1.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_1_B40            CAN_1.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_1_H40            CAN_1.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_1_W40            CAN_1.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_1_CS41           CAN_1.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_1_ID41           CAN_1.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_1_B41            CAN_1.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_1_H41            CAN_1.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_1_W41            CAN_1.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_1_CS42           CAN_1.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_1_ID42           CAN_1.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_1_B42            CAN_1.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_1_H42            CAN_1.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_1_W42            CAN_1.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_1_CS43           CAN_1.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_1_ID43           CAN_1.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_1_B43            CAN_1.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_1_H43            CAN_1.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_1_W43            CAN_1.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_1_CS44           CAN_1.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_1_ID44           CAN_1.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_1_B44            CAN_1.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_1_H44            CAN_1.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_1_W44            CAN_1.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_1_CS45           CAN_1.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_1_ID45           CAN_1.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_1_B45            CAN_1.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_1_H45            CAN_1.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_1_W45            CAN_1.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_1_CS46           CAN_1.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_1_ID46           CAN_1.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_1_B46            CAN_1.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_1_H46            CAN_1.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_1_W46            CAN_1.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_1_CS47           CAN_1.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_1_ID47           CAN_1.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_1_B47            CAN_1.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_1_H47            CAN_1.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_1_W47            CAN_1.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_1_CS48           CAN_1.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_1_ID48           CAN_1.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_1_B48            CAN_1.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_1_H48            CAN_1.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_1_W48            CAN_1.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_1_CS49           CAN_1.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_1_ID49           CAN_1.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_1_B49            CAN_1.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_1_H49            CAN_1.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_1_W49            CAN_1.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_1_CS50           CAN_1.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_1_ID50           CAN_1.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_1_B50            CAN_1.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_1_H50            CAN_1.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_1_W50            CAN_1.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_1_CS51           CAN_1.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_1_ID51           CAN_1.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_1_B51            CAN_1.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_1_H51            CAN_1.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_1_W51            CAN_1.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_1_CS52           CAN_1.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_1_ID52           CAN_1.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_1_B52            CAN_1.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_1_H52            CAN_1.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_1_W52            CAN_1.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_1_CS53           CAN_1.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_1_ID53           CAN_1.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_1_B53            CAN_1.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_1_H53            CAN_1.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_1_W53            CAN_1.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_1_CS54           CAN_1.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_1_ID54           CAN_1.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_1_B54            CAN_1.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_1_H54            CAN_1.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_1_W54            CAN_1.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_1_CS55           CAN_1.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_1_ID55           CAN_1.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_1_B55            CAN_1.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_1_H55            CAN_1.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_1_W55            CAN_1.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_1_CS56           CAN_1.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_1_ID56           CAN_1.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_1_B56            CAN_1.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_1_H56            CAN_1.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_1_W56            CAN_1.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_1_CS57           CAN_1.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_1_ID57           CAN_1.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_1_B57            CAN_1.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_1_H57            CAN_1.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_1_W57            CAN_1.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_1_CS58           CAN_1.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_1_ID58           CAN_1.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_1_B58            CAN_1.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_1_H58            CAN_1.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_1_W58            CAN_1.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_1_CS59           CAN_1.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_1_ID59           CAN_1.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_1_B59            CAN_1.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_1_H59            CAN_1.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_1_W59            CAN_1.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_1_CS60           CAN_1.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_1_ID60           CAN_1.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_1_B60            CAN_1.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_1_H60            CAN_1.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_1_W60            CAN_1.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_1_CS61           CAN_1.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_1_ID61           CAN_1.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_1_B61            CAN_1.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_1_H61            CAN_1.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_1_W61            CAN_1.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_1_CS62           CAN_1.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_1_ID62           CAN_1.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_1_B62            CAN_1.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_1_H62            CAN_1.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_1_W62            CAN_1.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_1_CS63           CAN_1.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_1_ID63           CAN_1.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_1_B63            CAN_1.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_1_H63            CAN_1.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_1_W63            CAN_1.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_1_CS64           CAN_1.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_1_ID64           CAN_1.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_1_B64            CAN_1.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_1_H64            CAN_1.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_1_W64            CAN_1.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_1_CS65           CAN_1.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_1_ID65           CAN_1.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_1_B65            CAN_1.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_1_H65            CAN_1.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_1_W65            CAN_1.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_1_CS66           CAN_1.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_1_ID66           CAN_1.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_1_B66            CAN_1.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_1_H66            CAN_1.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_1_W66            CAN_1.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_1_CS67           CAN_1.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_1_ID67           CAN_1.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_1_B67            CAN_1.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_1_H67            CAN_1.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_1_W67            CAN_1.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_1_CS68           CAN_1.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_1_ID68           CAN_1.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_1_B68            CAN_1.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_1_H68            CAN_1.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_1_W68            CAN_1.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_1_CS69           CAN_1.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_1_ID69           CAN_1.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_1_B69            CAN_1.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_1_H69            CAN_1.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_1_W69            CAN_1.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_1_CS70           CAN_1.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_1_ID70           CAN_1.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_1_B70            CAN_1.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_1_H70            CAN_1.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_1_W70            CAN_1.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_1_CS71           CAN_1.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_1_ID71           CAN_1.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_1_B71            CAN_1.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_1_H71            CAN_1.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_1_W71            CAN_1.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_1_CS72           CAN_1.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_1_ID72           CAN_1.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_1_B72            CAN_1.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_1_H72            CAN_1.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_1_W72            CAN_1.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_1_CS73           CAN_1.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_1_ID73           CAN_1.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_1_B73            CAN_1.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_1_H73            CAN_1.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_1_W73            CAN_1.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_1_CS74           CAN_1.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_1_ID74           CAN_1.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_1_B74            CAN_1.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_1_H74            CAN_1.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_1_W74            CAN_1.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_1_CS75           CAN_1.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_1_ID75           CAN_1.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_1_B75            CAN_1.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_1_H75            CAN_1.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_1_W75            CAN_1.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_1_CS76           CAN_1.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_1_ID76           CAN_1.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_1_B76            CAN_1.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_1_H76            CAN_1.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_1_W76            CAN_1.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_1_CS77           CAN_1.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_1_ID77           CAN_1.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_1_B77            CAN_1.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_1_H77            CAN_1.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_1_W77            CAN_1.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_1_CS78           CAN_1.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_1_ID78           CAN_1.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_1_B78            CAN_1.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_1_H78            CAN_1.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_1_W78            CAN_1.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_1_CS79           CAN_1.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_1_ID79           CAN_1.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_1_B79            CAN_1.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_1_H79            CAN_1.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_1_W79            CAN_1.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_1_CS80           CAN_1.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_1_ID80           CAN_1.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_1_B80            CAN_1.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_1_H80            CAN_1.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_1_W80            CAN_1.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_1_CS81           CAN_1.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_1_ID81           CAN_1.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_1_B81            CAN_1.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_1_H81            CAN_1.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_1_W81            CAN_1.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_1_CS82           CAN_1.MB[82].CS.R             /* Message Buffer 82 CS Register */
#define CAN_1_ID82           CAN_1.MB[82].ID.R             /* Message Buffer 82 ID Register */
#define CAN_1_B82            CAN_1.MB[82].DATA.B           /* Message Buffer 82 B Register */
#define CAN_1_H82            CAN_1.MB[82].DATA.H           /* Message Buffer 82 H Register */
#define CAN_1_W82            CAN_1.MB[82].DATA.W           /* Message Buffer 82 W Register */
#define CAN_1_CS83           CAN_1.MB[83].CS.R             /* Message Buffer 83 CS Register */
#define CAN_1_ID83           CAN_1.MB[83].ID.R             /* Message Buffer 83 ID Register */
#define CAN_1_B83            CAN_1.MB[83].DATA.B           /* Message Buffer 83 B Register */
#define CAN_1_H83            CAN_1.MB[83].DATA.H           /* Message Buffer 83 H Register */
#define CAN_1_W83            CAN_1.MB[83].DATA.W           /* Message Buffer 83 W Register */
#define CAN_1_CS84           CAN_1.MB[84].CS.R             /* Message Buffer 84 CS Register */
#define CAN_1_ID84           CAN_1.MB[84].ID.R             /* Message Buffer 84 ID Register */
#define CAN_1_B84            CAN_1.MB[84].DATA.B           /* Message Buffer 84 B Register */
#define CAN_1_H84            CAN_1.MB[84].DATA.H           /* Message Buffer 84 H Register */
#define CAN_1_W84            CAN_1.MB[84].DATA.W           /* Message Buffer 84 W Register */
#define CAN_1_CS85           CAN_1.MB[85].CS.R             /* Message Buffer 85 CS Register */
#define CAN_1_ID85           CAN_1.MB[85].ID.R             /* Message Buffer 85 ID Register */
#define CAN_1_B85            CAN_1.MB[85].DATA.B           /* Message Buffer 85 B Register */
#define CAN_1_H85            CAN_1.MB[85].DATA.H           /* Message Buffer 85 H Register */
#define CAN_1_W85            CAN_1.MB[85].DATA.W           /* Message Buffer 85 W Register */
#define CAN_1_CS86           CAN_1.MB[86].CS.R             /* Message Buffer 86 CS Register */
#define CAN_1_ID86           CAN_1.MB[86].ID.R             /* Message Buffer 86 ID Register */
#define CAN_1_B86            CAN_1.MB[86].DATA.B           /* Message Buffer 86 B Register */
#define CAN_1_H86            CAN_1.MB[86].DATA.H           /* Message Buffer 86 H Register */
#define CAN_1_W86            CAN_1.MB[86].DATA.W           /* Message Buffer 86 W Register */
#define CAN_1_CS87           CAN_1.MB[87].CS.R             /* Message Buffer 87 CS Register */
#define CAN_1_ID87           CAN_1.MB[87].ID.R             /* Message Buffer 87 ID Register */
#define CAN_1_B87            CAN_1.MB[87].DATA.B           /* Message Buffer 87 B Register */
#define CAN_1_H87            CAN_1.MB[87].DATA.H           /* Message Buffer 87 H Register */
#define CAN_1_W87            CAN_1.MB[87].DATA.W           /* Message Buffer 87 W Register */
#define CAN_1_CS88           CAN_1.MB[88].CS.R             /* Message Buffer 88 CS Register */
#define CAN_1_ID88           CAN_1.MB[88].ID.R             /* Message Buffer 88 ID Register */
#define CAN_1_B88            CAN_1.MB[88].DATA.B           /* Message Buffer 88 B Register */
#define CAN_1_H88            CAN_1.MB[88].DATA.H           /* Message Buffer 88 H Register */
#define CAN_1_W88            CAN_1.MB[88].DATA.W           /* Message Buffer 88 W Register */
#define CAN_1_CS89           CAN_1.MB[89].CS.R             /* Message Buffer 89 CS Register */
#define CAN_1_ID89           CAN_1.MB[89].ID.R             /* Message Buffer 89 ID Register */
#define CAN_1_B89            CAN_1.MB[89].DATA.B           /* Message Buffer 89 B Register */
#define CAN_1_H89            CAN_1.MB[89].DATA.H           /* Message Buffer 89 H Register */
#define CAN_1_W89            CAN_1.MB[89].DATA.W           /* Message Buffer 89 W Register */
#define CAN_1_CS90           CAN_1.MB[90].CS.R             /* Message Buffer 90 CS Register */
#define CAN_1_ID90           CAN_1.MB[90].ID.R             /* Message Buffer 90 ID Register */
#define CAN_1_B90            CAN_1.MB[90].DATA.B           /* Message Buffer 90 B Register */
#define CAN_1_H90            CAN_1.MB[90].DATA.H           /* Message Buffer 90 H Register */
#define CAN_1_W90            CAN_1.MB[90].DATA.W           /* Message Buffer 90 W Register */
#define CAN_1_CS91           CAN_1.MB[91].CS.R             /* Message Buffer 91 CS Register */
#define CAN_1_ID91           CAN_1.MB[91].ID.R             /* Message Buffer 91 ID Register */
#define CAN_1_B91            CAN_1.MB[91].DATA.B           /* Message Buffer 91 B Register */
#define CAN_1_H91            CAN_1.MB[91].DATA.H           /* Message Buffer 91 H Register */
#define CAN_1_W91            CAN_1.MB[91].DATA.W           /* Message Buffer 91 W Register */
#define CAN_1_CS92           CAN_1.MB[92].CS.R             /* Message Buffer 92 CS Register */
#define CAN_1_ID92           CAN_1.MB[92].ID.R             /* Message Buffer 92 ID Register */
#define CAN_1_B92            CAN_1.MB[92].DATA.B           /* Message Buffer 92 B Register */
#define CAN_1_H92            CAN_1.MB[92].DATA.H           /* Message Buffer 92 H Register */
#define CAN_1_W92            CAN_1.MB[92].DATA.W           /* Message Buffer 92 W Register */
#define CAN_1_CS93           CAN_1.MB[93].CS.R             /* Message Buffer 93 CS Register */
#define CAN_1_ID93           CAN_1.MB[93].ID.R             /* Message Buffer 93 ID Register */
#define CAN_1_B93            CAN_1.MB[93].DATA.B           /* Message Buffer 93 B Register */
#define CAN_1_H93            CAN_1.MB[93].DATA.H           /* Message Buffer 93 H Register */
#define CAN_1_W93            CAN_1.MB[93].DATA.W           /* Message Buffer 93 W Register */
#define CAN_1_CS94           CAN_1.MB[94].CS.R             /* Message Buffer 94 CS Register */
#define CAN_1_ID94           CAN_1.MB[94].ID.R             /* Message Buffer 94 ID Register */
#define CAN_1_B94            CAN_1.MB[94].DATA.B           /* Message Buffer 94 B Register */
#define CAN_1_H94            CAN_1.MB[94].DATA.H           /* Message Buffer 94 H Register */
#define CAN_1_W94            CAN_1.MB[94].DATA.W           /* Message Buffer 94 W Register */
#define CAN_1_CS95           CAN_1.MB[95].CS.R             /* Message Buffer 95 CS Register */
#define CAN_1_ID95           CAN_1.MB[95].ID.R             /* Message Buffer 95 ID Register */
#define CAN_1_B95            CAN_1.MB[95].DATA.B           /* Message Buffer 95 B Register */
#define CAN_1_H95            CAN_1.MB[95].DATA.H           /* Message Buffer 95 H Register */
#define CAN_1_W95            CAN_1.MB[95].DATA.W           /* Message Buffer 95 W Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR64        CAN_1.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR65        CAN_1.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR66        CAN_1.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR67        CAN_1.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR68        CAN_1.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR69        CAN_1.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR70        CAN_1.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR71        CAN_1.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR72        CAN_1.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR73        CAN_1.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR74        CAN_1.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR75        CAN_1.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR76        CAN_1.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR77        CAN_1.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR78        CAN_1.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR79        CAN_1.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR80        CAN_1.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR81        CAN_1.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR82        CAN_1.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR83        CAN_1.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR84        CAN_1.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR85        CAN_1.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR86        CAN_1.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR87        CAN_1.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR88        CAN_1.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR89        CAN_1.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR90        CAN_1.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR91        CAN_1.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR92        CAN_1.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR93        CAN_1.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR94        CAN_1.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR95        CAN_1.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_1_FDCTRL         CAN_1.FDCTRL.R                /* CAN FD Control Register */
#define CAN_1_FDCBT          CAN_1.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_1_FDCRC          CAN_1.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R             /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R             /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B           /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H           /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W           /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R             /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R             /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B           /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H           /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W           /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R             /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R             /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B           /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H           /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W           /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R             /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R             /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B           /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H           /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W           /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R             /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R             /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B           /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H           /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W           /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R             /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R             /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B           /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H           /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W           /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R             /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R             /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B           /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H           /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W           /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R             /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R             /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B           /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H           /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W           /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R             /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R             /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B           /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H           /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W           /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R             /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R             /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B           /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H           /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W           /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_2_CS64           CAN_2.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_2_ID64           CAN_2.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_2_B64            CAN_2.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_2_H64            CAN_2.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_2_W64            CAN_2.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_2_CS65           CAN_2.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_2_ID65           CAN_2.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_2_B65            CAN_2.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_2_H65            CAN_2.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_2_W65            CAN_2.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_2_CS66           CAN_2.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_2_ID66           CAN_2.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_2_B66            CAN_2.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_2_H66            CAN_2.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_2_W66            CAN_2.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_2_CS67           CAN_2.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_2_ID67           CAN_2.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_2_B67            CAN_2.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_2_H67            CAN_2.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_2_W67            CAN_2.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_2_CS68           CAN_2.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_2_ID68           CAN_2.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_2_B68            CAN_2.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_2_H68            CAN_2.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_2_W68            CAN_2.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_2_CS69           CAN_2.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_2_ID69           CAN_2.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_2_B69            CAN_2.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_2_H69            CAN_2.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_2_W69            CAN_2.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_2_CS70           CAN_2.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_2_ID70           CAN_2.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_2_B70            CAN_2.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_2_H70            CAN_2.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_2_W70            CAN_2.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_2_CS71           CAN_2.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_2_ID71           CAN_2.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_2_B71            CAN_2.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_2_H71            CAN_2.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_2_W71            CAN_2.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_2_CS72           CAN_2.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_2_ID72           CAN_2.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_2_B72            CAN_2.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_2_H72            CAN_2.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_2_W72            CAN_2.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_2_CS73           CAN_2.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_2_ID73           CAN_2.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_2_B73            CAN_2.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_2_H73            CAN_2.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_2_W73            CAN_2.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_2_CS74           CAN_2.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_2_ID74           CAN_2.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_2_B74            CAN_2.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_2_H74            CAN_2.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_2_W74            CAN_2.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_2_CS75           CAN_2.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_2_ID75           CAN_2.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_2_B75            CAN_2.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_2_H75            CAN_2.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_2_W75            CAN_2.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_2_CS76           CAN_2.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_2_ID76           CAN_2.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_2_B76            CAN_2.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_2_H76            CAN_2.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_2_W76            CAN_2.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_2_CS77           CAN_2.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_2_ID77           CAN_2.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_2_B77            CAN_2.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_2_H77            CAN_2.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_2_W77            CAN_2.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_2_CS78           CAN_2.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_2_ID78           CAN_2.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_2_B78            CAN_2.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_2_H78            CAN_2.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_2_W78            CAN_2.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_2_CS79           CAN_2.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_2_ID79           CAN_2.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_2_B79            CAN_2.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_2_H79            CAN_2.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_2_W79            CAN_2.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_2_CS80           CAN_2.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_2_ID80           CAN_2.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_2_B80            CAN_2.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_2_H80            CAN_2.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_2_W80            CAN_2.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_2_CS81           CAN_2.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_2_ID81           CAN_2.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_2_B81            CAN_2.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_2_H81            CAN_2.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_2_W81            CAN_2.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_2_CS82           CAN_2.MB[82].CS.R             /* Message Buffer 82 CS Register */
#define CAN_2_ID82           CAN_2.MB[82].ID.R             /* Message Buffer 82 ID Register */
#define CAN_2_B82            CAN_2.MB[82].DATA.B           /* Message Buffer 82 B Register */
#define CAN_2_H82            CAN_2.MB[82].DATA.H           /* Message Buffer 82 H Register */
#define CAN_2_W82            CAN_2.MB[82].DATA.W           /* Message Buffer 82 W Register */
#define CAN_2_CS83           CAN_2.MB[83].CS.R             /* Message Buffer 83 CS Register */
#define CAN_2_ID83           CAN_2.MB[83].ID.R             /* Message Buffer 83 ID Register */
#define CAN_2_B83            CAN_2.MB[83].DATA.B           /* Message Buffer 83 B Register */
#define CAN_2_H83            CAN_2.MB[83].DATA.H           /* Message Buffer 83 H Register */
#define CAN_2_W83            CAN_2.MB[83].DATA.W           /* Message Buffer 83 W Register */
#define CAN_2_CS84           CAN_2.MB[84].CS.R             /* Message Buffer 84 CS Register */
#define CAN_2_ID84           CAN_2.MB[84].ID.R             /* Message Buffer 84 ID Register */
#define CAN_2_B84            CAN_2.MB[84].DATA.B           /* Message Buffer 84 B Register */
#define CAN_2_H84            CAN_2.MB[84].DATA.H           /* Message Buffer 84 H Register */
#define CAN_2_W84            CAN_2.MB[84].DATA.W           /* Message Buffer 84 W Register */
#define CAN_2_CS85           CAN_2.MB[85].CS.R             /* Message Buffer 85 CS Register */
#define CAN_2_ID85           CAN_2.MB[85].ID.R             /* Message Buffer 85 ID Register */
#define CAN_2_B85            CAN_2.MB[85].DATA.B           /* Message Buffer 85 B Register */
#define CAN_2_H85            CAN_2.MB[85].DATA.H           /* Message Buffer 85 H Register */
#define CAN_2_W85            CAN_2.MB[85].DATA.W           /* Message Buffer 85 W Register */
#define CAN_2_CS86           CAN_2.MB[86].CS.R             /* Message Buffer 86 CS Register */
#define CAN_2_ID86           CAN_2.MB[86].ID.R             /* Message Buffer 86 ID Register */
#define CAN_2_B86            CAN_2.MB[86].DATA.B           /* Message Buffer 86 B Register */
#define CAN_2_H86            CAN_2.MB[86].DATA.H           /* Message Buffer 86 H Register */
#define CAN_2_W86            CAN_2.MB[86].DATA.W           /* Message Buffer 86 W Register */
#define CAN_2_CS87           CAN_2.MB[87].CS.R             /* Message Buffer 87 CS Register */
#define CAN_2_ID87           CAN_2.MB[87].ID.R             /* Message Buffer 87 ID Register */
#define CAN_2_B87            CAN_2.MB[87].DATA.B           /* Message Buffer 87 B Register */
#define CAN_2_H87            CAN_2.MB[87].DATA.H           /* Message Buffer 87 H Register */
#define CAN_2_W87            CAN_2.MB[87].DATA.W           /* Message Buffer 87 W Register */
#define CAN_2_CS88           CAN_2.MB[88].CS.R             /* Message Buffer 88 CS Register */
#define CAN_2_ID88           CAN_2.MB[88].ID.R             /* Message Buffer 88 ID Register */
#define CAN_2_B88            CAN_2.MB[88].DATA.B           /* Message Buffer 88 B Register */
#define CAN_2_H88            CAN_2.MB[88].DATA.H           /* Message Buffer 88 H Register */
#define CAN_2_W88            CAN_2.MB[88].DATA.W           /* Message Buffer 88 W Register */
#define CAN_2_CS89           CAN_2.MB[89].CS.R             /* Message Buffer 89 CS Register */
#define CAN_2_ID89           CAN_2.MB[89].ID.R             /* Message Buffer 89 ID Register */
#define CAN_2_B89            CAN_2.MB[89].DATA.B           /* Message Buffer 89 B Register */
#define CAN_2_H89            CAN_2.MB[89].DATA.H           /* Message Buffer 89 H Register */
#define CAN_2_W89            CAN_2.MB[89].DATA.W           /* Message Buffer 89 W Register */
#define CAN_2_CS90           CAN_2.MB[90].CS.R             /* Message Buffer 90 CS Register */
#define CAN_2_ID90           CAN_2.MB[90].ID.R             /* Message Buffer 90 ID Register */
#define CAN_2_B90            CAN_2.MB[90].DATA.B           /* Message Buffer 90 B Register */
#define CAN_2_H90            CAN_2.MB[90].DATA.H           /* Message Buffer 90 H Register */
#define CAN_2_W90            CAN_2.MB[90].DATA.W           /* Message Buffer 90 W Register */
#define CAN_2_CS91           CAN_2.MB[91].CS.R             /* Message Buffer 91 CS Register */
#define CAN_2_ID91           CAN_2.MB[91].ID.R             /* Message Buffer 91 ID Register */
#define CAN_2_B91            CAN_2.MB[91].DATA.B           /* Message Buffer 91 B Register */
#define CAN_2_H91            CAN_2.MB[91].DATA.H           /* Message Buffer 91 H Register */
#define CAN_2_W91            CAN_2.MB[91].DATA.W           /* Message Buffer 91 W Register */
#define CAN_2_CS92           CAN_2.MB[92].CS.R             /* Message Buffer 92 CS Register */
#define CAN_2_ID92           CAN_2.MB[92].ID.R             /* Message Buffer 92 ID Register */
#define CAN_2_B92            CAN_2.MB[92].DATA.B           /* Message Buffer 92 B Register */
#define CAN_2_H92            CAN_2.MB[92].DATA.H           /* Message Buffer 92 H Register */
#define CAN_2_W92            CAN_2.MB[92].DATA.W           /* Message Buffer 92 W Register */
#define CAN_2_CS93           CAN_2.MB[93].CS.R             /* Message Buffer 93 CS Register */
#define CAN_2_ID93           CAN_2.MB[93].ID.R             /* Message Buffer 93 ID Register */
#define CAN_2_B93            CAN_2.MB[93].DATA.B           /* Message Buffer 93 B Register */
#define CAN_2_H93            CAN_2.MB[93].DATA.H           /* Message Buffer 93 H Register */
#define CAN_2_W93            CAN_2.MB[93].DATA.W           /* Message Buffer 93 W Register */
#define CAN_2_CS94           CAN_2.MB[94].CS.R             /* Message Buffer 94 CS Register */
#define CAN_2_ID94           CAN_2.MB[94].ID.R             /* Message Buffer 94 ID Register */
#define CAN_2_B94            CAN_2.MB[94].DATA.B           /* Message Buffer 94 B Register */
#define CAN_2_H94            CAN_2.MB[94].DATA.H           /* Message Buffer 94 H Register */
#define CAN_2_W94            CAN_2.MB[94].DATA.W           /* Message Buffer 94 W Register */
#define CAN_2_CS95           CAN_2.MB[95].CS.R             /* Message Buffer 95 CS Register */
#define CAN_2_ID95           CAN_2.MB[95].ID.R             /* Message Buffer 95 ID Register */
#define CAN_2_B95            CAN_2.MB[95].DATA.B           /* Message Buffer 95 B Register */
#define CAN_2_H95            CAN_2.MB[95].DATA.H           /* Message Buffer 95 H Register */
#define CAN_2_W95            CAN_2.MB[95].DATA.W           /* Message Buffer 95 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR64        CAN_2.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR65        CAN_2.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR66        CAN_2.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR67        CAN_2.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR68        CAN_2.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR69        CAN_2.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR70        CAN_2.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR71        CAN_2.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR72        CAN_2.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR73        CAN_2.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR74        CAN_2.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR75        CAN_2.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR76        CAN_2.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR77        CAN_2.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR78        CAN_2.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR79        CAN_2.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR80        CAN_2.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR81        CAN_2.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR82        CAN_2.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR83        CAN_2.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR84        CAN_2.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR85        CAN_2.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR86        CAN_2.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR87        CAN_2.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR88        CAN_2.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR89        CAN_2.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR90        CAN_2.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR91        CAN_2.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR92        CAN_2.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR93        CAN_2.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR94        CAN_2.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR95        CAN_2.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_2_FDCTRL         CAN_2.FDCTRL.R                /* CAN FD Control Register */
#define CAN_2_FDCBT          CAN_2.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_2_FDCRC          CAN_2.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_3_MCR            CAN_3.MCR.R                   /* Module Configuration Register */
#define CAN_3_CTRL1          CAN_3.CTRL1.R                 /* Control 1 register */
#define CAN_3_TIMER          CAN_3.TIMER.R                 /* Free Running Timer */
#define CAN_3_RXMGMASK       CAN_3.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_3_RX14MASK       CAN_3.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_3_RX15MASK       CAN_3.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_3_ECR            CAN_3.ECR.R                   /* Error Counter */
#define CAN_3_ESR1           CAN_3.ESR1.R                  /* Error and Status 1 register */
#define CAN_3_IMASK2         CAN_3.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_3_IMASK1         CAN_3.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_3_IFLAG2         CAN_3.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_3_IFLAG1         CAN_3.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_3_CTRL2          CAN_3.CTRL2.R                 /* Control 2 register */
#define CAN_3_ESR2           CAN_3.ESR2.R                  /* Error and Status 2 register */
#define CAN_3_CRCR           CAN_3.CRCR.R                  /* CRC Register */
#define CAN_3_RXFGMASK       CAN_3.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_3_RXFIR          CAN_3.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_3_CS0            CAN_3.MB[0].CS.R             /* Message Buffer 0 CS Register */
#define CAN_3_ID0            CAN_3.MB[0].ID.R             /* Message Buffer 0 ID Register */
#define CAN_3_B0             CAN_3.MB[0].DATA.B           /* Message Buffer 0 B Register */
#define CAN_3_H0             CAN_3.MB[0].DATA.H           /* Message Buffer 0 H Register */
#define CAN_3_W0             CAN_3.MB[0].DATA.W           /* Message Buffer 0 W Register */
#define CAN_3_CS1            CAN_3.MB[1].CS.R             /* Message Buffer 1 CS Register */
#define CAN_3_ID1            CAN_3.MB[1].ID.R             /* Message Buffer 1 ID Register */
#define CAN_3_B1             CAN_3.MB[1].DATA.B           /* Message Buffer 1 B Register */
#define CAN_3_H1             CAN_3.MB[1].DATA.H           /* Message Buffer 1 H Register */
#define CAN_3_W1             CAN_3.MB[1].DATA.W           /* Message Buffer 1 W Register */
#define CAN_3_CS2            CAN_3.MB[2].CS.R             /* Message Buffer 2 CS Register */
#define CAN_3_ID2            CAN_3.MB[2].ID.R             /* Message Buffer 2 ID Register */
#define CAN_3_B2             CAN_3.MB[2].DATA.B           /* Message Buffer 2 B Register */
#define CAN_3_H2             CAN_3.MB[2].DATA.H           /* Message Buffer 2 H Register */
#define CAN_3_W2             CAN_3.MB[2].DATA.W           /* Message Buffer 2 W Register */
#define CAN_3_CS3            CAN_3.MB[3].CS.R             /* Message Buffer 3 CS Register */
#define CAN_3_ID3            CAN_3.MB[3].ID.R             /* Message Buffer 3 ID Register */
#define CAN_3_B3             CAN_3.MB[3].DATA.B           /* Message Buffer 3 B Register */
#define CAN_3_H3             CAN_3.MB[3].DATA.H           /* Message Buffer 3 H Register */
#define CAN_3_W3             CAN_3.MB[3].DATA.W           /* Message Buffer 3 W Register */
#define CAN_3_CS4            CAN_3.MB[4].CS.R             /* Message Buffer 4 CS Register */
#define CAN_3_ID4            CAN_3.MB[4].ID.R             /* Message Buffer 4 ID Register */
#define CAN_3_B4             CAN_3.MB[4].DATA.B           /* Message Buffer 4 B Register */
#define CAN_3_H4             CAN_3.MB[4].DATA.H           /* Message Buffer 4 H Register */
#define CAN_3_W4             CAN_3.MB[4].DATA.W           /* Message Buffer 4 W Register */
#define CAN_3_CS5            CAN_3.MB[5].CS.R             /* Message Buffer 5 CS Register */
#define CAN_3_ID5            CAN_3.MB[5].ID.R             /* Message Buffer 5 ID Register */
#define CAN_3_B5             CAN_3.MB[5].DATA.B           /* Message Buffer 5 B Register */
#define CAN_3_H5             CAN_3.MB[5].DATA.H           /* Message Buffer 5 H Register */
#define CAN_3_W5             CAN_3.MB[5].DATA.W           /* Message Buffer 5 W Register */
#define CAN_3_CS6            CAN_3.MB[6].CS.R             /* Message Buffer 6 CS Register */
#define CAN_3_ID6            CAN_3.MB[6].ID.R             /* Message Buffer 6 ID Register */
#define CAN_3_B6             CAN_3.MB[6].DATA.B           /* Message Buffer 6 B Register */
#define CAN_3_H6             CAN_3.MB[6].DATA.H           /* Message Buffer 6 H Register */
#define CAN_3_W6             CAN_3.MB[6].DATA.W           /* Message Buffer 6 W Register */
#define CAN_3_CS7            CAN_3.MB[7].CS.R             /* Message Buffer 7 CS Register */
#define CAN_3_ID7            CAN_3.MB[7].ID.R             /* Message Buffer 7 ID Register */
#define CAN_3_B7             CAN_3.MB[7].DATA.B           /* Message Buffer 7 B Register */
#define CAN_3_H7             CAN_3.MB[7].DATA.H           /* Message Buffer 7 H Register */
#define CAN_3_W7             CAN_3.MB[7].DATA.W           /* Message Buffer 7 W Register */
#define CAN_3_CS8            CAN_3.MB[8].CS.R             /* Message Buffer 8 CS Register */
#define CAN_3_ID8            CAN_3.MB[8].ID.R             /* Message Buffer 8 ID Register */
#define CAN_3_B8             CAN_3.MB[8].DATA.B           /* Message Buffer 8 B Register */
#define CAN_3_H8             CAN_3.MB[8].DATA.H           /* Message Buffer 8 H Register */
#define CAN_3_W8             CAN_3.MB[8].DATA.W           /* Message Buffer 8 W Register */
#define CAN_3_CS9            CAN_3.MB[9].CS.R             /* Message Buffer 9 CS Register */
#define CAN_3_ID9            CAN_3.MB[9].ID.R             /* Message Buffer 9 ID Register */
#define CAN_3_B9             CAN_3.MB[9].DATA.B           /* Message Buffer 9 B Register */
#define CAN_3_H9             CAN_3.MB[9].DATA.H           /* Message Buffer 9 H Register */
#define CAN_3_W9             CAN_3.MB[9].DATA.W           /* Message Buffer 9 W Register */
#define CAN_3_CS10           CAN_3.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_3_ID10           CAN_3.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_3_B10            CAN_3.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_3_H10            CAN_3.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_3_W10            CAN_3.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_3_CS11           CAN_3.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_3_ID11           CAN_3.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_3_B11            CAN_3.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_3_H11            CAN_3.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_3_W11            CAN_3.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_3_CS12           CAN_3.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_3_ID12           CAN_3.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_3_B12            CAN_3.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_3_H12            CAN_3.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_3_W12            CAN_3.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_3_CS13           CAN_3.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_3_ID13           CAN_3.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_3_B13            CAN_3.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_3_H13            CAN_3.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_3_W13            CAN_3.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_3_CS14           CAN_3.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_3_ID14           CAN_3.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_3_B14            CAN_3.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_3_H14            CAN_3.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_3_W14            CAN_3.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_3_CS15           CAN_3.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_3_ID15           CAN_3.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_3_B15            CAN_3.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_3_H15            CAN_3.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_3_W15            CAN_3.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_3_CS16           CAN_3.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_3_ID16           CAN_3.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_3_B16            CAN_3.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_3_H16            CAN_3.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_3_W16            CAN_3.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_3_CS17           CAN_3.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_3_ID17           CAN_3.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_3_B17            CAN_3.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_3_H17            CAN_3.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_3_W17            CAN_3.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_3_CS18           CAN_3.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_3_ID18           CAN_3.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_3_B18            CAN_3.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_3_H18            CAN_3.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_3_W18            CAN_3.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_3_CS19           CAN_3.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_3_ID19           CAN_3.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_3_B19            CAN_3.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_3_H19            CAN_3.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_3_W19            CAN_3.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_3_CS20           CAN_3.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_3_ID20           CAN_3.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_3_B20            CAN_3.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_3_H20            CAN_3.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_3_W20            CAN_3.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_3_CS21           CAN_3.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_3_ID21           CAN_3.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_3_B21            CAN_3.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_3_H21            CAN_3.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_3_W21            CAN_3.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_3_CS22           CAN_3.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_3_ID22           CAN_3.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_3_B22            CAN_3.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_3_H22            CAN_3.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_3_W22            CAN_3.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_3_CS23           CAN_3.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_3_ID23           CAN_3.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_3_B23            CAN_3.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_3_H23            CAN_3.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_3_W23            CAN_3.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_3_CS24           CAN_3.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_3_ID24           CAN_3.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_3_B24            CAN_3.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_3_H24            CAN_3.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_3_W24            CAN_3.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_3_CS25           CAN_3.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_3_ID25           CAN_3.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_3_B25            CAN_3.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_3_H25            CAN_3.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_3_W25            CAN_3.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_3_CS26           CAN_3.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_3_ID26           CAN_3.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_3_B26            CAN_3.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_3_H26            CAN_3.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_3_W26            CAN_3.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_3_CS27           CAN_3.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_3_ID27           CAN_3.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_3_B27            CAN_3.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_3_H27            CAN_3.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_3_W27            CAN_3.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_3_CS28           CAN_3.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_3_ID28           CAN_3.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_3_B28            CAN_3.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_3_H28            CAN_3.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_3_W28            CAN_3.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_3_CS29           CAN_3.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_3_ID29           CAN_3.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_3_B29            CAN_3.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_3_H29            CAN_3.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_3_W29            CAN_3.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_3_CS30           CAN_3.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_3_ID30           CAN_3.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_3_B30            CAN_3.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_3_H30            CAN_3.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_3_W30            CAN_3.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_3_CS31           CAN_3.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_3_ID31           CAN_3.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_3_B31            CAN_3.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_3_H31            CAN_3.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_3_W31            CAN_3.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_3_CS32           CAN_3.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_3_ID32           CAN_3.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_3_B32            CAN_3.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_3_H32            CAN_3.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_3_W32            CAN_3.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_3_CS33           CAN_3.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_3_ID33           CAN_3.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_3_B33            CAN_3.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_3_H33            CAN_3.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_3_W33            CAN_3.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_3_CS34           CAN_3.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_3_ID34           CAN_3.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_3_B34            CAN_3.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_3_H34            CAN_3.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_3_W34            CAN_3.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_3_CS35           CAN_3.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_3_ID35           CAN_3.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_3_B35            CAN_3.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_3_H35            CAN_3.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_3_W35            CAN_3.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_3_CS36           CAN_3.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_3_ID36           CAN_3.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_3_B36            CAN_3.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_3_H36            CAN_3.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_3_W36            CAN_3.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_3_CS37           CAN_3.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_3_ID37           CAN_3.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_3_B37            CAN_3.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_3_H37            CAN_3.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_3_W37            CAN_3.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_3_CS38           CAN_3.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_3_ID38           CAN_3.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_3_B38            CAN_3.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_3_H38            CAN_3.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_3_W38            CAN_3.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_3_CS39           CAN_3.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_3_ID39           CAN_3.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_3_B39            CAN_3.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_3_H39            CAN_3.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_3_W39            CAN_3.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_3_CS40           CAN_3.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_3_ID40           CAN_3.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_3_B40            CAN_3.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_3_H40            CAN_3.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_3_W40            CAN_3.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_3_CS41           CAN_3.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_3_ID41           CAN_3.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_3_B41            CAN_3.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_3_H41            CAN_3.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_3_W41            CAN_3.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_3_CS42           CAN_3.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_3_ID42           CAN_3.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_3_B42            CAN_3.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_3_H42            CAN_3.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_3_W42            CAN_3.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_3_CS43           CAN_3.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_3_ID43           CAN_3.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_3_B43            CAN_3.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_3_H43            CAN_3.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_3_W43            CAN_3.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_3_CS44           CAN_3.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_3_ID44           CAN_3.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_3_B44            CAN_3.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_3_H44            CAN_3.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_3_W44            CAN_3.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_3_CS45           CAN_3.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_3_ID45           CAN_3.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_3_B45            CAN_3.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_3_H45            CAN_3.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_3_W45            CAN_3.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_3_CS46           CAN_3.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_3_ID46           CAN_3.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_3_B46            CAN_3.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_3_H46            CAN_3.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_3_W46            CAN_3.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_3_CS47           CAN_3.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_3_ID47           CAN_3.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_3_B47            CAN_3.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_3_H47            CAN_3.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_3_W47            CAN_3.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_3_CS48           CAN_3.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_3_ID48           CAN_3.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_3_B48            CAN_3.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_3_H48            CAN_3.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_3_W48            CAN_3.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_3_CS49           CAN_3.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_3_ID49           CAN_3.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_3_B49            CAN_3.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_3_H49            CAN_3.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_3_W49            CAN_3.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_3_CS50           CAN_3.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_3_ID50           CAN_3.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_3_B50            CAN_3.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_3_H50            CAN_3.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_3_W50            CAN_3.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_3_CS51           CAN_3.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_3_ID51           CAN_3.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_3_B51            CAN_3.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_3_H51            CAN_3.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_3_W51            CAN_3.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_3_CS52           CAN_3.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_3_ID52           CAN_3.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_3_B52            CAN_3.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_3_H52            CAN_3.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_3_W52            CAN_3.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_3_CS53           CAN_3.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_3_ID53           CAN_3.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_3_B53            CAN_3.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_3_H53            CAN_3.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_3_W53            CAN_3.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_3_CS54           CAN_3.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_3_ID54           CAN_3.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_3_B54            CAN_3.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_3_H54            CAN_3.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_3_W54            CAN_3.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_3_CS55           CAN_3.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_3_ID55           CAN_3.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_3_B55            CAN_3.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_3_H55            CAN_3.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_3_W55            CAN_3.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_3_CS56           CAN_3.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_3_ID56           CAN_3.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_3_B56            CAN_3.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_3_H56            CAN_3.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_3_W56            CAN_3.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_3_CS57           CAN_3.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_3_ID57           CAN_3.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_3_B57            CAN_3.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_3_H57            CAN_3.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_3_W57            CAN_3.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_3_CS58           CAN_3.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_3_ID58           CAN_3.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_3_B58            CAN_3.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_3_H58            CAN_3.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_3_W58            CAN_3.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_3_CS59           CAN_3.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_3_ID59           CAN_3.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_3_B59            CAN_3.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_3_H59            CAN_3.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_3_W59            CAN_3.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_3_CS60           CAN_3.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_3_ID60           CAN_3.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_3_B60            CAN_3.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_3_H60            CAN_3.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_3_W60            CAN_3.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_3_CS61           CAN_3.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_3_ID61           CAN_3.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_3_B61            CAN_3.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_3_H61            CAN_3.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_3_W61            CAN_3.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_3_CS62           CAN_3.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_3_ID62           CAN_3.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_3_B62            CAN_3.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_3_H62            CAN_3.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_3_W62            CAN_3.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_3_CS63           CAN_3.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_3_ID63           CAN_3.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_3_B63            CAN_3.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_3_H63            CAN_3.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_3_W63            CAN_3.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_3_CS64           CAN_3.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_3_ID64           CAN_3.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_3_B64            CAN_3.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_3_H64            CAN_3.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_3_W64            CAN_3.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_3_CS65           CAN_3.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_3_ID65           CAN_3.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_3_B65            CAN_3.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_3_H65            CAN_3.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_3_W65            CAN_3.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_3_CS66           CAN_3.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_3_ID66           CAN_3.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_3_B66            CAN_3.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_3_H66            CAN_3.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_3_W66            CAN_3.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_3_CS67           CAN_3.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_3_ID67           CAN_3.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_3_B67            CAN_3.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_3_H67            CAN_3.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_3_W67            CAN_3.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_3_CS68           CAN_3.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_3_ID68           CAN_3.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_3_B68            CAN_3.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_3_H68            CAN_3.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_3_W68            CAN_3.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_3_CS69           CAN_3.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_3_ID69           CAN_3.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_3_B69            CAN_3.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_3_H69            CAN_3.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_3_W69            CAN_3.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_3_CS70           CAN_3.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_3_ID70           CAN_3.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_3_B70            CAN_3.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_3_H70            CAN_3.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_3_W70            CAN_3.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_3_CS71           CAN_3.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_3_ID71           CAN_3.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_3_B71            CAN_3.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_3_H71            CAN_3.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_3_W71            CAN_3.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_3_CS72           CAN_3.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_3_ID72           CAN_3.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_3_B72            CAN_3.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_3_H72            CAN_3.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_3_W72            CAN_3.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_3_CS73           CAN_3.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_3_ID73           CAN_3.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_3_B73            CAN_3.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_3_H73            CAN_3.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_3_W73            CAN_3.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_3_CS74           CAN_3.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_3_ID74           CAN_3.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_3_B74            CAN_3.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_3_H74            CAN_3.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_3_W74            CAN_3.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_3_CS75           CAN_3.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_3_ID75           CAN_3.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_3_B75            CAN_3.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_3_H75            CAN_3.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_3_W75            CAN_3.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_3_CS76           CAN_3.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_3_ID76           CAN_3.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_3_B76            CAN_3.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_3_H76            CAN_3.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_3_W76            CAN_3.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_3_CS77           CAN_3.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_3_ID77           CAN_3.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_3_B77            CAN_3.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_3_H77            CAN_3.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_3_W77            CAN_3.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_3_CS78           CAN_3.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_3_ID78           CAN_3.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_3_B78            CAN_3.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_3_H78            CAN_3.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_3_W78            CAN_3.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_3_CS79           CAN_3.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_3_ID79           CAN_3.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_3_B79            CAN_3.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_3_H79            CAN_3.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_3_W79            CAN_3.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_3_CS80           CAN_3.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_3_ID80           CAN_3.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_3_B80            CAN_3.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_3_H80            CAN_3.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_3_W80            CAN_3.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_3_CS81           CAN_3.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_3_ID81           CAN_3.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_3_B81            CAN_3.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_3_H81            CAN_3.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_3_W81            CAN_3.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_3_CS82           CAN_3.MB[82].CS.R             /* Message Buffer 82 CS Register */
#define CAN_3_ID82           CAN_3.MB[82].ID.R             /* Message Buffer 82 ID Register */
#define CAN_3_B82            CAN_3.MB[82].DATA.B           /* Message Buffer 82 B Register */
#define CAN_3_H82            CAN_3.MB[82].DATA.H           /* Message Buffer 82 H Register */
#define CAN_3_W82            CAN_3.MB[82].DATA.W           /* Message Buffer 82 W Register */
#define CAN_3_CS83           CAN_3.MB[83].CS.R             /* Message Buffer 83 CS Register */
#define CAN_3_ID83           CAN_3.MB[83].ID.R             /* Message Buffer 83 ID Register */
#define CAN_3_B83            CAN_3.MB[83].DATA.B           /* Message Buffer 83 B Register */
#define CAN_3_H83            CAN_3.MB[83].DATA.H           /* Message Buffer 83 H Register */
#define CAN_3_W83            CAN_3.MB[83].DATA.W           /* Message Buffer 83 W Register */
#define CAN_3_CS84           CAN_3.MB[84].CS.R             /* Message Buffer 84 CS Register */
#define CAN_3_ID84           CAN_3.MB[84].ID.R             /* Message Buffer 84 ID Register */
#define CAN_3_B84            CAN_3.MB[84].DATA.B           /* Message Buffer 84 B Register */
#define CAN_3_H84            CAN_3.MB[84].DATA.H           /* Message Buffer 84 H Register */
#define CAN_3_W84            CAN_3.MB[84].DATA.W           /* Message Buffer 84 W Register */
#define CAN_3_CS85           CAN_3.MB[85].CS.R             /* Message Buffer 85 CS Register */
#define CAN_3_ID85           CAN_3.MB[85].ID.R             /* Message Buffer 85 ID Register */
#define CAN_3_B85            CAN_3.MB[85].DATA.B           /* Message Buffer 85 B Register */
#define CAN_3_H85            CAN_3.MB[85].DATA.H           /* Message Buffer 85 H Register */
#define CAN_3_W85            CAN_3.MB[85].DATA.W           /* Message Buffer 85 W Register */
#define CAN_3_CS86           CAN_3.MB[86].CS.R             /* Message Buffer 86 CS Register */
#define CAN_3_ID86           CAN_3.MB[86].ID.R             /* Message Buffer 86 ID Register */
#define CAN_3_B86            CAN_3.MB[86].DATA.B           /* Message Buffer 86 B Register */
#define CAN_3_H86            CAN_3.MB[86].DATA.H           /* Message Buffer 86 H Register */
#define CAN_3_W86            CAN_3.MB[86].DATA.W           /* Message Buffer 86 W Register */
#define CAN_3_CS87           CAN_3.MB[87].CS.R             /* Message Buffer 87 CS Register */
#define CAN_3_ID87           CAN_3.MB[87].ID.R             /* Message Buffer 87 ID Register */
#define CAN_3_B87            CAN_3.MB[87].DATA.B           /* Message Buffer 87 B Register */
#define CAN_3_H87            CAN_3.MB[87].DATA.H           /* Message Buffer 87 H Register */
#define CAN_3_W87            CAN_3.MB[87].DATA.W           /* Message Buffer 87 W Register */
#define CAN_3_CS88           CAN_3.MB[88].CS.R             /* Message Buffer 88 CS Register */
#define CAN_3_ID88           CAN_3.MB[88].ID.R             /* Message Buffer 88 ID Register */
#define CAN_3_B88            CAN_3.MB[88].DATA.B           /* Message Buffer 88 B Register */
#define CAN_3_H88            CAN_3.MB[88].DATA.H           /* Message Buffer 88 H Register */
#define CAN_3_W88            CAN_3.MB[88].DATA.W           /* Message Buffer 88 W Register */
#define CAN_3_CS89           CAN_3.MB[89].CS.R             /* Message Buffer 89 CS Register */
#define CAN_3_ID89           CAN_3.MB[89].ID.R             /* Message Buffer 89 ID Register */
#define CAN_3_B89            CAN_3.MB[89].DATA.B           /* Message Buffer 89 B Register */
#define CAN_3_H89            CAN_3.MB[89].DATA.H           /* Message Buffer 89 H Register */
#define CAN_3_W89            CAN_3.MB[89].DATA.W           /* Message Buffer 89 W Register */
#define CAN_3_CS90           CAN_3.MB[90].CS.R             /* Message Buffer 90 CS Register */
#define CAN_3_ID90           CAN_3.MB[90].ID.R             /* Message Buffer 90 ID Register */
#define CAN_3_B90            CAN_3.MB[90].DATA.B           /* Message Buffer 90 B Register */
#define CAN_3_H90            CAN_3.MB[90].DATA.H           /* Message Buffer 90 H Register */
#define CAN_3_W90            CAN_3.MB[90].DATA.W           /* Message Buffer 90 W Register */
#define CAN_3_CS91           CAN_3.MB[91].CS.R             /* Message Buffer 91 CS Register */
#define CAN_3_ID91           CAN_3.MB[91].ID.R             /* Message Buffer 91 ID Register */
#define CAN_3_B91            CAN_3.MB[91].DATA.B           /* Message Buffer 91 B Register */
#define CAN_3_H91            CAN_3.MB[91].DATA.H           /* Message Buffer 91 H Register */
#define CAN_3_W91            CAN_3.MB[91].DATA.W           /* Message Buffer 91 W Register */
#define CAN_3_CS92           CAN_3.MB[92].CS.R             /* Message Buffer 92 CS Register */
#define CAN_3_ID92           CAN_3.MB[92].ID.R             /* Message Buffer 92 ID Register */
#define CAN_3_B92            CAN_3.MB[92].DATA.B           /* Message Buffer 92 B Register */
#define CAN_3_H92            CAN_3.MB[92].DATA.H           /* Message Buffer 92 H Register */
#define CAN_3_W92            CAN_3.MB[92].DATA.W           /* Message Buffer 92 W Register */
#define CAN_3_CS93           CAN_3.MB[93].CS.R             /* Message Buffer 93 CS Register */
#define CAN_3_ID93           CAN_3.MB[93].ID.R             /* Message Buffer 93 ID Register */
#define CAN_3_B93            CAN_3.MB[93].DATA.B           /* Message Buffer 93 B Register */
#define CAN_3_H93            CAN_3.MB[93].DATA.H           /* Message Buffer 93 H Register */
#define CAN_3_W93            CAN_3.MB[93].DATA.W           /* Message Buffer 93 W Register */
#define CAN_3_CS94           CAN_3.MB[94].CS.R             /* Message Buffer 94 CS Register */
#define CAN_3_ID94           CAN_3.MB[94].ID.R             /* Message Buffer 94 ID Register */
#define CAN_3_B94            CAN_3.MB[94].DATA.B           /* Message Buffer 94 B Register */
#define CAN_3_H94            CAN_3.MB[94].DATA.H           /* Message Buffer 94 H Register */
#define CAN_3_W94            CAN_3.MB[94].DATA.W           /* Message Buffer 94 W Register */
#define CAN_3_CS95           CAN_3.MB[95].CS.R             /* Message Buffer 95 CS Register */
#define CAN_3_ID95           CAN_3.MB[95].ID.R             /* Message Buffer 95 ID Register */
#define CAN_3_B95            CAN_3.MB[95].DATA.B           /* Message Buffer 95 B Register */
#define CAN_3_H95            CAN_3.MB[95].DATA.H           /* Message Buffer 95 H Register */
#define CAN_3_W95            CAN_3.MB[95].DATA.W           /* Message Buffer 95 W Register */
#define CAN_3_RXIMR0         CAN_3.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR1         CAN_3.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR2         CAN_3.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR3         CAN_3.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR4         CAN_3.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR5         CAN_3.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR6         CAN_3.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR7         CAN_3.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR8         CAN_3.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR9         CAN_3.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR10        CAN_3.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR11        CAN_3.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR12        CAN_3.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR13        CAN_3.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR14        CAN_3.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR15        CAN_3.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR16        CAN_3.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR17        CAN_3.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR18        CAN_3.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR19        CAN_3.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR20        CAN_3.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR21        CAN_3.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR22        CAN_3.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR23        CAN_3.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR24        CAN_3.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR25        CAN_3.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR26        CAN_3.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR27        CAN_3.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR28        CAN_3.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR29        CAN_3.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR30        CAN_3.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR31        CAN_3.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR32        CAN_3.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR33        CAN_3.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR34        CAN_3.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR35        CAN_3.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR36        CAN_3.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR37        CAN_3.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR38        CAN_3.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR39        CAN_3.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR40        CAN_3.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR41        CAN_3.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR42        CAN_3.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR43        CAN_3.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR44        CAN_3.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR45        CAN_3.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR46        CAN_3.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR47        CAN_3.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR48        CAN_3.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR49        CAN_3.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR50        CAN_3.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR51        CAN_3.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR52        CAN_3.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR53        CAN_3.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR54        CAN_3.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR55        CAN_3.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR56        CAN_3.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR57        CAN_3.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR58        CAN_3.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR59        CAN_3.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR60        CAN_3.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR61        CAN_3.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR62        CAN_3.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR63        CAN_3.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR64        CAN_3.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR65        CAN_3.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR66        CAN_3.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR67        CAN_3.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR68        CAN_3.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR69        CAN_3.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR70        CAN_3.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR71        CAN_3.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR72        CAN_3.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR73        CAN_3.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR74        CAN_3.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR75        CAN_3.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR76        CAN_3.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR77        CAN_3.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR78        CAN_3.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR79        CAN_3.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR80        CAN_3.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR81        CAN_3.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR82        CAN_3.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR83        CAN_3.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR84        CAN_3.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR85        CAN_3.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR86        CAN_3.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR87        CAN_3.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR88        CAN_3.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR89        CAN_3.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR90        CAN_3.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR91        CAN_3.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR92        CAN_3.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR93        CAN_3.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR94        CAN_3.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR95        CAN_3.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_3_FDCTRL         CAN_3.FDCTRL.R                /* CAN FD Control Register */
#define CAN_3_FDCBT          CAN_3.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_3_FDCRC          CAN_3.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_4_MCR            CAN_4.MCR.R                   /* Module Configuration Register */
#define CAN_4_CTRL1          CAN_4.CTRL1.R                 /* Control 1 register */
#define CAN_4_TIMER          CAN_4.TIMER.R                 /* Free Running Timer */
#define CAN_4_RXMGMASK       CAN_4.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_4_RX14MASK       CAN_4.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_4_RX15MASK       CAN_4.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_4_ECR            CAN_4.ECR.R                   /* Error Counter */
#define CAN_4_ESR1           CAN_4.ESR1.R                  /* Error and Status 1 register */
#define CAN_4_IMASK2         CAN_4.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_4_IMASK1         CAN_4.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_4_IFLAG2         CAN_4.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_4_IFLAG1         CAN_4.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_4_CTRL2          CAN_4.CTRL2.R                 /* Control 2 register */
#define CAN_4_ESR2           CAN_4.ESR2.R                  /* Error and Status 2 register */
#define CAN_4_CRCR           CAN_4.CRCR.R                  /* CRC Register */
#define CAN_4_RXFGMASK       CAN_4.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_4_RXFIR          CAN_4.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_4_CS0            CAN_4.MB[0].CS.R             /* Message Buffer 0 CS Register */
#define CAN_4_ID0            CAN_4.MB[0].ID.R             /* Message Buffer 0 ID Register */
#define CAN_4_B0             CAN_4.MB[0].DATA.B           /* Message Buffer 0 B Register */
#define CAN_4_H0             CAN_4.MB[0].DATA.H           /* Message Buffer 0 H Register */
#define CAN_4_W0             CAN_4.MB[0].DATA.W           /* Message Buffer 0 W Register */
#define CAN_4_CS1            CAN_4.MB[1].CS.R             /* Message Buffer 1 CS Register */
#define CAN_4_ID1            CAN_4.MB[1].ID.R             /* Message Buffer 1 ID Register */
#define CAN_4_B1             CAN_4.MB[1].DATA.B           /* Message Buffer 1 B Register */
#define CAN_4_H1             CAN_4.MB[1].DATA.H           /* Message Buffer 1 H Register */
#define CAN_4_W1             CAN_4.MB[1].DATA.W           /* Message Buffer 1 W Register */
#define CAN_4_CS2            CAN_4.MB[2].CS.R             /* Message Buffer 2 CS Register */
#define CAN_4_ID2            CAN_4.MB[2].ID.R             /* Message Buffer 2 ID Register */
#define CAN_4_B2             CAN_4.MB[2].DATA.B           /* Message Buffer 2 B Register */
#define CAN_4_H2             CAN_4.MB[2].DATA.H           /* Message Buffer 2 H Register */
#define CAN_4_W2             CAN_4.MB[2].DATA.W           /* Message Buffer 2 W Register */
#define CAN_4_CS3            CAN_4.MB[3].CS.R             /* Message Buffer 3 CS Register */
#define CAN_4_ID3            CAN_4.MB[3].ID.R             /* Message Buffer 3 ID Register */
#define CAN_4_B3             CAN_4.MB[3].DATA.B           /* Message Buffer 3 B Register */
#define CAN_4_H3             CAN_4.MB[3].DATA.H           /* Message Buffer 3 H Register */
#define CAN_4_W3             CAN_4.MB[3].DATA.W           /* Message Buffer 3 W Register */
#define CAN_4_CS4            CAN_4.MB[4].CS.R             /* Message Buffer 4 CS Register */
#define CAN_4_ID4            CAN_4.MB[4].ID.R             /* Message Buffer 4 ID Register */
#define CAN_4_B4             CAN_4.MB[4].DATA.B           /* Message Buffer 4 B Register */
#define CAN_4_H4             CAN_4.MB[4].DATA.H           /* Message Buffer 4 H Register */
#define CAN_4_W4             CAN_4.MB[4].DATA.W           /* Message Buffer 4 W Register */
#define CAN_4_CS5            CAN_4.MB[5].CS.R             /* Message Buffer 5 CS Register */
#define CAN_4_ID5            CAN_4.MB[5].ID.R             /* Message Buffer 5 ID Register */
#define CAN_4_B5             CAN_4.MB[5].DATA.B           /* Message Buffer 5 B Register */
#define CAN_4_H5             CAN_4.MB[5].DATA.H           /* Message Buffer 5 H Register */
#define CAN_4_W5             CAN_4.MB[5].DATA.W           /* Message Buffer 5 W Register */
#define CAN_4_CS6            CAN_4.MB[6].CS.R             /* Message Buffer 6 CS Register */
#define CAN_4_ID6            CAN_4.MB[6].ID.R             /* Message Buffer 6 ID Register */
#define CAN_4_B6             CAN_4.MB[6].DATA.B           /* Message Buffer 6 B Register */
#define CAN_4_H6             CAN_4.MB[6].DATA.H           /* Message Buffer 6 H Register */
#define CAN_4_W6             CAN_4.MB[6].DATA.W           /* Message Buffer 6 W Register */
#define CAN_4_CS7            CAN_4.MB[7].CS.R             /* Message Buffer 7 CS Register */
#define CAN_4_ID7            CAN_4.MB[7].ID.R             /* Message Buffer 7 ID Register */
#define CAN_4_B7             CAN_4.MB[7].DATA.B           /* Message Buffer 7 B Register */
#define CAN_4_H7             CAN_4.MB[7].DATA.H           /* Message Buffer 7 H Register */
#define CAN_4_W7             CAN_4.MB[7].DATA.W           /* Message Buffer 7 W Register */
#define CAN_4_CS8            CAN_4.MB[8].CS.R             /* Message Buffer 8 CS Register */
#define CAN_4_ID8            CAN_4.MB[8].ID.R             /* Message Buffer 8 ID Register */
#define CAN_4_B8             CAN_4.MB[8].DATA.B           /* Message Buffer 8 B Register */
#define CAN_4_H8             CAN_4.MB[8].DATA.H           /* Message Buffer 8 H Register */
#define CAN_4_W8             CAN_4.MB[8].DATA.W           /* Message Buffer 8 W Register */
#define CAN_4_CS9            CAN_4.MB[9].CS.R             /* Message Buffer 9 CS Register */
#define CAN_4_ID9            CAN_4.MB[9].ID.R             /* Message Buffer 9 ID Register */
#define CAN_4_B9             CAN_4.MB[9].DATA.B           /* Message Buffer 9 B Register */
#define CAN_4_H9             CAN_4.MB[9].DATA.H           /* Message Buffer 9 H Register */
#define CAN_4_W9             CAN_4.MB[9].DATA.W           /* Message Buffer 9 W Register */
#define CAN_4_CS10           CAN_4.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_4_ID10           CAN_4.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_4_B10            CAN_4.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_4_H10            CAN_4.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_4_W10            CAN_4.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_4_CS11           CAN_4.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_4_ID11           CAN_4.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_4_B11            CAN_4.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_4_H11            CAN_4.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_4_W11            CAN_4.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_4_CS12           CAN_4.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_4_ID12           CAN_4.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_4_B12            CAN_4.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_4_H12            CAN_4.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_4_W12            CAN_4.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_4_CS13           CAN_4.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_4_ID13           CAN_4.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_4_B13            CAN_4.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_4_H13            CAN_4.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_4_W13            CAN_4.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_4_CS14           CAN_4.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_4_ID14           CAN_4.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_4_B14            CAN_4.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_4_H14            CAN_4.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_4_W14            CAN_4.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_4_CS15           CAN_4.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_4_ID15           CAN_4.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_4_B15            CAN_4.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_4_H15            CAN_4.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_4_W15            CAN_4.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_4_CS16           CAN_4.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_4_ID16           CAN_4.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_4_B16            CAN_4.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_4_H16            CAN_4.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_4_W16            CAN_4.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_4_CS17           CAN_4.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_4_ID17           CAN_4.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_4_B17            CAN_4.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_4_H17            CAN_4.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_4_W17            CAN_4.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_4_CS18           CAN_4.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_4_ID18           CAN_4.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_4_B18            CAN_4.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_4_H18            CAN_4.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_4_W18            CAN_4.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_4_CS19           CAN_4.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_4_ID19           CAN_4.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_4_B19            CAN_4.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_4_H19            CAN_4.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_4_W19            CAN_4.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_4_CS20           CAN_4.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_4_ID20           CAN_4.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_4_B20            CAN_4.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_4_H20            CAN_4.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_4_W20            CAN_4.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_4_CS21           CAN_4.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_4_ID21           CAN_4.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_4_B21            CAN_4.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_4_H21            CAN_4.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_4_W21            CAN_4.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_4_CS22           CAN_4.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_4_ID22           CAN_4.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_4_B22            CAN_4.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_4_H22            CAN_4.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_4_W22            CAN_4.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_4_CS23           CAN_4.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_4_ID23           CAN_4.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_4_B23            CAN_4.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_4_H23            CAN_4.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_4_W23            CAN_4.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_4_CS24           CAN_4.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_4_ID24           CAN_4.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_4_B24            CAN_4.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_4_H24            CAN_4.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_4_W24            CAN_4.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_4_CS25           CAN_4.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_4_ID25           CAN_4.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_4_B25            CAN_4.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_4_H25            CAN_4.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_4_W25            CAN_4.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_4_CS26           CAN_4.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_4_ID26           CAN_4.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_4_B26            CAN_4.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_4_H26            CAN_4.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_4_W26            CAN_4.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_4_CS27           CAN_4.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_4_ID27           CAN_4.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_4_B27            CAN_4.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_4_H27            CAN_4.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_4_W27            CAN_4.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_4_CS28           CAN_4.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_4_ID28           CAN_4.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_4_B28            CAN_4.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_4_H28            CAN_4.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_4_W28            CAN_4.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_4_CS29           CAN_4.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_4_ID29           CAN_4.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_4_B29            CAN_4.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_4_H29            CAN_4.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_4_W29            CAN_4.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_4_CS30           CAN_4.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_4_ID30           CAN_4.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_4_B30            CAN_4.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_4_H30            CAN_4.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_4_W30            CAN_4.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_4_CS31           CAN_4.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_4_ID31           CAN_4.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_4_B31            CAN_4.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_4_H31            CAN_4.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_4_W31            CAN_4.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_4_CS32           CAN_4.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_4_ID32           CAN_4.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_4_B32            CAN_4.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_4_H32            CAN_4.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_4_W32            CAN_4.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_4_CS33           CAN_4.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_4_ID33           CAN_4.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_4_B33            CAN_4.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_4_H33            CAN_4.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_4_W33            CAN_4.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_4_CS34           CAN_4.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_4_ID34           CAN_4.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_4_B34            CAN_4.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_4_H34            CAN_4.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_4_W34            CAN_4.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_4_CS35           CAN_4.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_4_ID35           CAN_4.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_4_B35            CAN_4.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_4_H35            CAN_4.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_4_W35            CAN_4.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_4_CS36           CAN_4.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_4_ID36           CAN_4.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_4_B36            CAN_4.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_4_H36            CAN_4.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_4_W36            CAN_4.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_4_CS37           CAN_4.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_4_ID37           CAN_4.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_4_B37            CAN_4.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_4_H37            CAN_4.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_4_W37            CAN_4.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_4_CS38           CAN_4.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_4_ID38           CAN_4.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_4_B38            CAN_4.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_4_H38            CAN_4.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_4_W38            CAN_4.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_4_CS39           CAN_4.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_4_ID39           CAN_4.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_4_B39            CAN_4.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_4_H39            CAN_4.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_4_W39            CAN_4.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_4_CS40           CAN_4.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_4_ID40           CAN_4.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_4_B40            CAN_4.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_4_H40            CAN_4.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_4_W40            CAN_4.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_4_CS41           CAN_4.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_4_ID41           CAN_4.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_4_B41            CAN_4.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_4_H41            CAN_4.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_4_W41            CAN_4.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_4_CS42           CAN_4.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_4_ID42           CAN_4.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_4_B42            CAN_4.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_4_H42            CAN_4.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_4_W42            CAN_4.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_4_CS43           CAN_4.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_4_ID43           CAN_4.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_4_B43            CAN_4.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_4_H43            CAN_4.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_4_W43            CAN_4.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_4_CS44           CAN_4.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_4_ID44           CAN_4.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_4_B44            CAN_4.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_4_H44            CAN_4.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_4_W44            CAN_4.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_4_CS45           CAN_4.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_4_ID45           CAN_4.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_4_B45            CAN_4.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_4_H45            CAN_4.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_4_W45            CAN_4.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_4_CS46           CAN_4.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_4_ID46           CAN_4.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_4_B46            CAN_4.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_4_H46            CAN_4.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_4_W46            CAN_4.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_4_CS47           CAN_4.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_4_ID47           CAN_4.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_4_B47            CAN_4.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_4_H47            CAN_4.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_4_W47            CAN_4.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_4_CS48           CAN_4.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_4_ID48           CAN_4.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_4_B48            CAN_4.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_4_H48            CAN_4.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_4_W48            CAN_4.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_4_CS49           CAN_4.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_4_ID49           CAN_4.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_4_B49            CAN_4.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_4_H49            CAN_4.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_4_W49            CAN_4.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_4_CS50           CAN_4.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_4_ID50           CAN_4.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_4_B50            CAN_4.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_4_H50            CAN_4.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_4_W50            CAN_4.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_4_CS51           CAN_4.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_4_ID51           CAN_4.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_4_B51            CAN_4.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_4_H51            CAN_4.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_4_W51            CAN_4.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_4_CS52           CAN_4.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_4_ID52           CAN_4.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_4_B52            CAN_4.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_4_H52            CAN_4.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_4_W52            CAN_4.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_4_CS53           CAN_4.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_4_ID53           CAN_4.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_4_B53            CAN_4.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_4_H53            CAN_4.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_4_W53            CAN_4.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_4_CS54           CAN_4.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_4_ID54           CAN_4.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_4_B54            CAN_4.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_4_H54            CAN_4.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_4_W54            CAN_4.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_4_CS55           CAN_4.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_4_ID55           CAN_4.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_4_B55            CAN_4.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_4_H55            CAN_4.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_4_W55            CAN_4.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_4_CS56           CAN_4.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_4_ID56           CAN_4.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_4_B56            CAN_4.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_4_H56            CAN_4.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_4_W56            CAN_4.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_4_CS57           CAN_4.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_4_ID57           CAN_4.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_4_B57            CAN_4.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_4_H57            CAN_4.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_4_W57            CAN_4.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_4_CS58           CAN_4.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_4_ID58           CAN_4.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_4_B58            CAN_4.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_4_H58            CAN_4.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_4_W58            CAN_4.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_4_CS59           CAN_4.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_4_ID59           CAN_4.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_4_B59            CAN_4.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_4_H59            CAN_4.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_4_W59            CAN_4.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_4_CS60           CAN_4.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_4_ID60           CAN_4.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_4_B60            CAN_4.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_4_H60            CAN_4.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_4_W60            CAN_4.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_4_CS61           CAN_4.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_4_ID61           CAN_4.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_4_B61            CAN_4.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_4_H61            CAN_4.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_4_W61            CAN_4.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_4_CS62           CAN_4.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_4_ID62           CAN_4.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_4_B62            CAN_4.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_4_H62            CAN_4.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_4_W62            CAN_4.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_4_CS63           CAN_4.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_4_ID63           CAN_4.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_4_B63            CAN_4.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_4_H63            CAN_4.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_4_W63            CAN_4.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_4_CS64           CAN_4.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_4_ID64           CAN_4.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_4_B64            CAN_4.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_4_H64            CAN_4.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_4_W64            CAN_4.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_4_CS65           CAN_4.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_4_ID65           CAN_4.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_4_B65            CAN_4.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_4_H65            CAN_4.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_4_W65            CAN_4.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_4_CS66           CAN_4.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_4_ID66           CAN_4.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_4_B66            CAN_4.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_4_H66            CAN_4.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_4_W66            CAN_4.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_4_CS67           CAN_4.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_4_ID67           CAN_4.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_4_B67            CAN_4.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_4_H67            CAN_4.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_4_W67            CAN_4.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_4_CS68           CAN_4.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_4_ID68           CAN_4.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_4_B68            CAN_4.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_4_H68            CAN_4.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_4_W68            CAN_4.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_4_CS69           CAN_4.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_4_ID69           CAN_4.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_4_B69            CAN_4.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_4_H69            CAN_4.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_4_W69            CAN_4.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_4_CS70           CAN_4.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_4_ID70           CAN_4.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_4_B70            CAN_4.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_4_H70            CAN_4.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_4_W70            CAN_4.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_4_CS71           CAN_4.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_4_ID71           CAN_4.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_4_B71            CAN_4.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_4_H71            CAN_4.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_4_W71            CAN_4.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_4_CS72           CAN_4.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_4_ID72           CAN_4.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_4_B72            CAN_4.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_4_H72            CAN_4.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_4_W72            CAN_4.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_4_CS73           CAN_4.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_4_ID73           CAN_4.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_4_B73            CAN_4.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_4_H73            CAN_4.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_4_W73            CAN_4.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_4_CS74           CAN_4.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_4_ID74           CAN_4.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_4_B74            CAN_4.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_4_H74            CAN_4.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_4_W74            CAN_4.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_4_CS75           CAN_4.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_4_ID75           CAN_4.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_4_B75            CAN_4.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_4_H75            CAN_4.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_4_W75            CAN_4.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_4_CS76           CAN_4.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_4_ID76           CAN_4.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_4_B76            CAN_4.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_4_H76            CAN_4.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_4_W76            CAN_4.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_4_CS77           CAN_4.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_4_ID77           CAN_4.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_4_B77            CAN_4.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_4_H77            CAN_4.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_4_W77            CAN_4.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_4_CS78           CAN_4.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_4_ID78           CAN_4.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_4_B78            CAN_4.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_4_H78            CAN_4.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_4_W78            CAN_4.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_4_CS79           CAN_4.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_4_ID79           CAN_4.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_4_B79            CAN_4.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_4_H79            CAN_4.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_4_W79            CAN_4.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_4_CS80           CAN_4.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_4_ID80           CAN_4.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_4_B80            CAN_4.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_4_H80            CAN_4.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_4_W80            CAN_4.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_4_CS81           CAN_4.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_4_ID81           CAN_4.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_4_B81            CAN_4.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_4_H81            CAN_4.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_4_W81            CAN_4.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_4_CS82           CAN_4.MB[82].CS.R             /* Message Buffer 82 CS Register */
#define CAN_4_ID82           CAN_4.MB[82].ID.R             /* Message Buffer 82 ID Register */
#define CAN_4_B82            CAN_4.MB[82].DATA.B           /* Message Buffer 82 B Register */
#define CAN_4_H82            CAN_4.MB[82].DATA.H           /* Message Buffer 82 H Register */
#define CAN_4_W82            CAN_4.MB[82].DATA.W           /* Message Buffer 82 W Register */
#define CAN_4_CS83           CAN_4.MB[83].CS.R             /* Message Buffer 83 CS Register */
#define CAN_4_ID83           CAN_4.MB[83].ID.R             /* Message Buffer 83 ID Register */
#define CAN_4_B83            CAN_4.MB[83].DATA.B           /* Message Buffer 83 B Register */
#define CAN_4_H83            CAN_4.MB[83].DATA.H           /* Message Buffer 83 H Register */
#define CAN_4_W83            CAN_4.MB[83].DATA.W           /* Message Buffer 83 W Register */
#define CAN_4_CS84           CAN_4.MB[84].CS.R             /* Message Buffer 84 CS Register */
#define CAN_4_ID84           CAN_4.MB[84].ID.R             /* Message Buffer 84 ID Register */
#define CAN_4_B84            CAN_4.MB[84].DATA.B           /* Message Buffer 84 B Register */
#define CAN_4_H84            CAN_4.MB[84].DATA.H           /* Message Buffer 84 H Register */
#define CAN_4_W84            CAN_4.MB[84].DATA.W           /* Message Buffer 84 W Register */
#define CAN_4_CS85           CAN_4.MB[85].CS.R             /* Message Buffer 85 CS Register */
#define CAN_4_ID85           CAN_4.MB[85].ID.R             /* Message Buffer 85 ID Register */
#define CAN_4_B85            CAN_4.MB[85].DATA.B           /* Message Buffer 85 B Register */
#define CAN_4_H85            CAN_4.MB[85].DATA.H           /* Message Buffer 85 H Register */
#define CAN_4_W85            CAN_4.MB[85].DATA.W           /* Message Buffer 85 W Register */
#define CAN_4_CS86           CAN_4.MB[86].CS.R             /* Message Buffer 86 CS Register */
#define CAN_4_ID86           CAN_4.MB[86].ID.R             /* Message Buffer 86 ID Register */
#define CAN_4_B86            CAN_4.MB[86].DATA.B           /* Message Buffer 86 B Register */
#define CAN_4_H86            CAN_4.MB[86].DATA.H           /* Message Buffer 86 H Register */
#define CAN_4_W86            CAN_4.MB[86].DATA.W           /* Message Buffer 86 W Register */
#define CAN_4_CS87           CAN_4.MB[87].CS.R             /* Message Buffer 87 CS Register */
#define CAN_4_ID87           CAN_4.MB[87].ID.R             /* Message Buffer 87 ID Register */
#define CAN_4_B87            CAN_4.MB[87].DATA.B           /* Message Buffer 87 B Register */
#define CAN_4_H87            CAN_4.MB[87].DATA.H           /* Message Buffer 87 H Register */
#define CAN_4_W87            CAN_4.MB[87].DATA.W           /* Message Buffer 87 W Register */
#define CAN_4_CS88           CAN_4.MB[88].CS.R             /* Message Buffer 88 CS Register */
#define CAN_4_ID88           CAN_4.MB[88].ID.R             /* Message Buffer 88 ID Register */
#define CAN_4_B88            CAN_4.MB[88].DATA.B           /* Message Buffer 88 B Register */
#define CAN_4_H88            CAN_4.MB[88].DATA.H           /* Message Buffer 88 H Register */
#define CAN_4_W88            CAN_4.MB[88].DATA.W           /* Message Buffer 88 W Register */
#define CAN_4_CS89           CAN_4.MB[89].CS.R             /* Message Buffer 89 CS Register */
#define CAN_4_ID89           CAN_4.MB[89].ID.R             /* Message Buffer 89 ID Register */
#define CAN_4_B89            CAN_4.MB[89].DATA.B           /* Message Buffer 89 B Register */
#define CAN_4_H89            CAN_4.MB[89].DATA.H           /* Message Buffer 89 H Register */
#define CAN_4_W89            CAN_4.MB[89].DATA.W           /* Message Buffer 89 W Register */
#define CAN_4_CS90           CAN_4.MB[90].CS.R             /* Message Buffer 90 CS Register */
#define CAN_4_ID90           CAN_4.MB[90].ID.R             /* Message Buffer 90 ID Register */
#define CAN_4_B90            CAN_4.MB[90].DATA.B           /* Message Buffer 90 B Register */
#define CAN_4_H90            CAN_4.MB[90].DATA.H           /* Message Buffer 90 H Register */
#define CAN_4_W90            CAN_4.MB[90].DATA.W           /* Message Buffer 90 W Register */
#define CAN_4_CS91           CAN_4.MB[91].CS.R             /* Message Buffer 91 CS Register */
#define CAN_4_ID91           CAN_4.MB[91].ID.R             /* Message Buffer 91 ID Register */
#define CAN_4_B91            CAN_4.MB[91].DATA.B           /* Message Buffer 91 B Register */
#define CAN_4_H91            CAN_4.MB[91].DATA.H           /* Message Buffer 91 H Register */
#define CAN_4_W91            CAN_4.MB[91].DATA.W           /* Message Buffer 91 W Register */
#define CAN_4_CS92           CAN_4.MB[92].CS.R             /* Message Buffer 92 CS Register */
#define CAN_4_ID92           CAN_4.MB[92].ID.R             /* Message Buffer 92 ID Register */
#define CAN_4_B92            CAN_4.MB[92].DATA.B           /* Message Buffer 92 B Register */
#define CAN_4_H92            CAN_4.MB[92].DATA.H           /* Message Buffer 92 H Register */
#define CAN_4_W92            CAN_4.MB[92].DATA.W           /* Message Buffer 92 W Register */
#define CAN_4_CS93           CAN_4.MB[93].CS.R             /* Message Buffer 93 CS Register */
#define CAN_4_ID93           CAN_4.MB[93].ID.R             /* Message Buffer 93 ID Register */
#define CAN_4_B93            CAN_4.MB[93].DATA.B           /* Message Buffer 93 B Register */
#define CAN_4_H93            CAN_4.MB[93].DATA.H           /* Message Buffer 93 H Register */
#define CAN_4_W93            CAN_4.MB[93].DATA.W           /* Message Buffer 93 W Register */
#define CAN_4_CS94           CAN_4.MB[94].CS.R             /* Message Buffer 94 CS Register */
#define CAN_4_ID94           CAN_4.MB[94].ID.R             /* Message Buffer 94 ID Register */
#define CAN_4_B94            CAN_4.MB[94].DATA.B           /* Message Buffer 94 B Register */
#define CAN_4_H94            CAN_4.MB[94].DATA.H           /* Message Buffer 94 H Register */
#define CAN_4_W94            CAN_4.MB[94].DATA.W           /* Message Buffer 94 W Register */
#define CAN_4_CS95           CAN_4.MB[95].CS.R             /* Message Buffer 95 CS Register */
#define CAN_4_ID95           CAN_4.MB[95].ID.R             /* Message Buffer 95 ID Register */
#define CAN_4_B95            CAN_4.MB[95].DATA.B           /* Message Buffer 95 B Register */
#define CAN_4_H95            CAN_4.MB[95].DATA.H           /* Message Buffer 95 H Register */
#define CAN_4_W95            CAN_4.MB[95].DATA.W           /* Message Buffer 95 W Register */
#define CAN_4_RXIMR0         CAN_4.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR1         CAN_4.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR2         CAN_4.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR3         CAN_4.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR4         CAN_4.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR5         CAN_4.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR6         CAN_4.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR7         CAN_4.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR8         CAN_4.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR9         CAN_4.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_4_RXIMR10        CAN_4.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR11        CAN_4.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR12        CAN_4.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR13        CAN_4.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR14        CAN_4.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR15        CAN_4.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR16        CAN_4.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR17        CAN_4.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR18        CAN_4.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR19        CAN_4.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR20        CAN_4.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR21        CAN_4.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR22        CAN_4.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR23        CAN_4.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR24        CAN_4.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR25        CAN_4.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR26        CAN_4.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR27        CAN_4.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR28        CAN_4.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR29        CAN_4.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR30        CAN_4.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR31        CAN_4.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR32        CAN_4.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR33        CAN_4.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR34        CAN_4.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR35        CAN_4.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR36        CAN_4.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR37        CAN_4.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR38        CAN_4.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR39        CAN_4.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR40        CAN_4.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR41        CAN_4.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR42        CAN_4.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR43        CAN_4.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR44        CAN_4.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR45        CAN_4.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR46        CAN_4.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR47        CAN_4.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR48        CAN_4.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR49        CAN_4.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR50        CAN_4.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR51        CAN_4.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR52        CAN_4.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR53        CAN_4.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR54        CAN_4.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR55        CAN_4.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR56        CAN_4.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR57        CAN_4.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR58        CAN_4.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR59        CAN_4.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR60        CAN_4.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR61        CAN_4.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR62        CAN_4.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR63        CAN_4.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR64        CAN_4.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR65        CAN_4.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR66        CAN_4.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR67        CAN_4.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR68        CAN_4.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR69        CAN_4.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR70        CAN_4.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR71        CAN_4.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR72        CAN_4.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR73        CAN_4.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR74        CAN_4.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR75        CAN_4.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR76        CAN_4.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR77        CAN_4.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR78        CAN_4.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR79        CAN_4.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR80        CAN_4.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR81        CAN_4.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR82        CAN_4.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR83        CAN_4.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR84        CAN_4.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR85        CAN_4.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR86        CAN_4.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR87        CAN_4.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR88        CAN_4.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR89        CAN_4.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR90        CAN_4.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR91        CAN_4.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR92        CAN_4.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR93        CAN_4.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR94        CAN_4.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_4_RXIMR95        CAN_4.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_4_FDCTRL         CAN_4.FDCTRL.R                /* CAN FD Control Register */
#define CAN_4_FDCBT          CAN_4.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_4_FDCRC          CAN_4.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_5_MCR            CAN_5.MCR.R                   /* Module Configuration Register */
#define CAN_5_CTRL1          CAN_5.CTRL1.R                 /* Control 1 register */
#define CAN_5_TIMER          CAN_5.TIMER.R                 /* Free Running Timer */
#define CAN_5_RXMGMASK       CAN_5.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_5_RX14MASK       CAN_5.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_5_RX15MASK       CAN_5.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_5_ECR            CAN_5.ECR.R                   /* Error Counter */
#define CAN_5_ESR1           CAN_5.ESR1.R                  /* Error and Status 1 register */
#define CAN_5_IMASK2         CAN_5.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_5_IMASK1         CAN_5.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_5_IFLAG2         CAN_5.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_5_IFLAG1         CAN_5.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_5_CTRL2          CAN_5.CTRL2.R                 /* Control 2 register */
#define CAN_5_ESR2           CAN_5.ESR2.R                  /* Error and Status 2 register */
#define CAN_5_CRCR           CAN_5.CRCR.R                  /* CRC Register */
#define CAN_5_RXFGMASK       CAN_5.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_5_RXFIR          CAN_5.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_5_CS0            CAN_5.MB[0].CS.R             /* Message Buffer 0 CS Register */
#define CAN_5_ID0            CAN_5.MB[0].ID.R             /* Message Buffer 0 ID Register */
#define CAN_5_B0             CAN_5.MB[0].DATA.B           /* Message Buffer 0 B Register */
#define CAN_5_H0             CAN_5.MB[0].DATA.H           /* Message Buffer 0 H Register */
#define CAN_5_W0             CAN_5.MB[0].DATA.W           /* Message Buffer 0 W Register */
#define CAN_5_CS1            CAN_5.MB[1].CS.R             /* Message Buffer 1 CS Register */
#define CAN_5_ID1            CAN_5.MB[1].ID.R             /* Message Buffer 1 ID Register */
#define CAN_5_B1             CAN_5.MB[1].DATA.B           /* Message Buffer 1 B Register */
#define CAN_5_H1             CAN_5.MB[1].DATA.H           /* Message Buffer 1 H Register */
#define CAN_5_W1             CAN_5.MB[1].DATA.W           /* Message Buffer 1 W Register */
#define CAN_5_CS2            CAN_5.MB[2].CS.R             /* Message Buffer 2 CS Register */
#define CAN_5_ID2            CAN_5.MB[2].ID.R             /* Message Buffer 2 ID Register */
#define CAN_5_B2             CAN_5.MB[2].DATA.B           /* Message Buffer 2 B Register */
#define CAN_5_H2             CAN_5.MB[2].DATA.H           /* Message Buffer 2 H Register */
#define CAN_5_W2             CAN_5.MB[2].DATA.W           /* Message Buffer 2 W Register */
#define CAN_5_CS3            CAN_5.MB[3].CS.R             /* Message Buffer 3 CS Register */
#define CAN_5_ID3            CAN_5.MB[3].ID.R             /* Message Buffer 3 ID Register */
#define CAN_5_B3             CAN_5.MB[3].DATA.B           /* Message Buffer 3 B Register */
#define CAN_5_H3             CAN_5.MB[3].DATA.H           /* Message Buffer 3 H Register */
#define CAN_5_W3             CAN_5.MB[3].DATA.W           /* Message Buffer 3 W Register */
#define CAN_5_CS4            CAN_5.MB[4].CS.R             /* Message Buffer 4 CS Register */
#define CAN_5_ID4            CAN_5.MB[4].ID.R             /* Message Buffer 4 ID Register */
#define CAN_5_B4             CAN_5.MB[4].DATA.B           /* Message Buffer 4 B Register */
#define CAN_5_H4             CAN_5.MB[4].DATA.H           /* Message Buffer 4 H Register */
#define CAN_5_W4             CAN_5.MB[4].DATA.W           /* Message Buffer 4 W Register */
#define CAN_5_CS5            CAN_5.MB[5].CS.R             /* Message Buffer 5 CS Register */
#define CAN_5_ID5            CAN_5.MB[5].ID.R             /* Message Buffer 5 ID Register */
#define CAN_5_B5             CAN_5.MB[5].DATA.B           /* Message Buffer 5 B Register */
#define CAN_5_H5             CAN_5.MB[5].DATA.H           /* Message Buffer 5 H Register */
#define CAN_5_W5             CAN_5.MB[5].DATA.W           /* Message Buffer 5 W Register */
#define CAN_5_CS6            CAN_5.MB[6].CS.R             /* Message Buffer 6 CS Register */
#define CAN_5_ID6            CAN_5.MB[6].ID.R             /* Message Buffer 6 ID Register */
#define CAN_5_B6             CAN_5.MB[6].DATA.B           /* Message Buffer 6 B Register */
#define CAN_5_H6             CAN_5.MB[6].DATA.H           /* Message Buffer 6 H Register */
#define CAN_5_W6             CAN_5.MB[6].DATA.W           /* Message Buffer 6 W Register */
#define CAN_5_CS7            CAN_5.MB[7].CS.R             /* Message Buffer 7 CS Register */
#define CAN_5_ID7            CAN_5.MB[7].ID.R             /* Message Buffer 7 ID Register */
#define CAN_5_B7             CAN_5.MB[7].DATA.B           /* Message Buffer 7 B Register */
#define CAN_5_H7             CAN_5.MB[7].DATA.H           /* Message Buffer 7 H Register */
#define CAN_5_W7             CAN_5.MB[7].DATA.W           /* Message Buffer 7 W Register */
#define CAN_5_CS8            CAN_5.MB[8].CS.R             /* Message Buffer 8 CS Register */
#define CAN_5_ID8            CAN_5.MB[8].ID.R             /* Message Buffer 8 ID Register */
#define CAN_5_B8             CAN_5.MB[8].DATA.B           /* Message Buffer 8 B Register */
#define CAN_5_H8             CAN_5.MB[8].DATA.H           /* Message Buffer 8 H Register */
#define CAN_5_W8             CAN_5.MB[8].DATA.W           /* Message Buffer 8 W Register */
#define CAN_5_CS9            CAN_5.MB[9].CS.R             /* Message Buffer 9 CS Register */
#define CAN_5_ID9            CAN_5.MB[9].ID.R             /* Message Buffer 9 ID Register */
#define CAN_5_B9             CAN_5.MB[9].DATA.B           /* Message Buffer 9 B Register */
#define CAN_5_H9             CAN_5.MB[9].DATA.H           /* Message Buffer 9 H Register */
#define CAN_5_W9             CAN_5.MB[9].DATA.W           /* Message Buffer 9 W Register */
#define CAN_5_CS10           CAN_5.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_5_ID10           CAN_5.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_5_B10            CAN_5.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_5_H10            CAN_5.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_5_W10            CAN_5.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_5_CS11           CAN_5.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_5_ID11           CAN_5.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_5_B11            CAN_5.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_5_H11            CAN_5.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_5_W11            CAN_5.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_5_CS12           CAN_5.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_5_ID12           CAN_5.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_5_B12            CAN_5.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_5_H12            CAN_5.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_5_W12            CAN_5.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_5_CS13           CAN_5.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_5_ID13           CAN_5.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_5_B13            CAN_5.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_5_H13            CAN_5.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_5_W13            CAN_5.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_5_CS14           CAN_5.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_5_ID14           CAN_5.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_5_B14            CAN_5.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_5_H14            CAN_5.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_5_W14            CAN_5.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_5_CS15           CAN_5.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_5_ID15           CAN_5.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_5_B15            CAN_5.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_5_H15            CAN_5.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_5_W15            CAN_5.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_5_CS16           CAN_5.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_5_ID16           CAN_5.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_5_B16            CAN_5.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_5_H16            CAN_5.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_5_W16            CAN_5.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_5_CS17           CAN_5.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_5_ID17           CAN_5.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_5_B17            CAN_5.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_5_H17            CAN_5.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_5_W17            CAN_5.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_5_CS18           CAN_5.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_5_ID18           CAN_5.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_5_B18            CAN_5.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_5_H18            CAN_5.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_5_W18            CAN_5.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_5_CS19           CAN_5.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_5_ID19           CAN_5.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_5_B19            CAN_5.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_5_H19            CAN_5.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_5_W19            CAN_5.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_5_CS20           CAN_5.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_5_ID20           CAN_5.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_5_B20            CAN_5.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_5_H20            CAN_5.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_5_W20            CAN_5.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_5_CS21           CAN_5.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_5_ID21           CAN_5.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_5_B21            CAN_5.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_5_H21            CAN_5.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_5_W21            CAN_5.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_5_CS22           CAN_5.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_5_ID22           CAN_5.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_5_B22            CAN_5.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_5_H22            CAN_5.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_5_W22            CAN_5.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_5_CS23           CAN_5.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_5_ID23           CAN_5.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_5_B23            CAN_5.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_5_H23            CAN_5.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_5_W23            CAN_5.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_5_CS24           CAN_5.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_5_ID24           CAN_5.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_5_B24            CAN_5.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_5_H24            CAN_5.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_5_W24            CAN_5.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_5_CS25           CAN_5.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_5_ID25           CAN_5.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_5_B25            CAN_5.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_5_H25            CAN_5.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_5_W25            CAN_5.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_5_CS26           CAN_5.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_5_ID26           CAN_5.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_5_B26            CAN_5.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_5_H26            CAN_5.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_5_W26            CAN_5.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_5_CS27           CAN_5.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_5_ID27           CAN_5.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_5_B27            CAN_5.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_5_H27            CAN_5.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_5_W27            CAN_5.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_5_CS28           CAN_5.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_5_ID28           CAN_5.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_5_B28            CAN_5.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_5_H28            CAN_5.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_5_W28            CAN_5.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_5_CS29           CAN_5.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_5_ID29           CAN_5.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_5_B29            CAN_5.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_5_H29            CAN_5.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_5_W29            CAN_5.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_5_CS30           CAN_5.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_5_ID30           CAN_5.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_5_B30            CAN_5.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_5_H30            CAN_5.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_5_W30            CAN_5.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_5_CS31           CAN_5.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_5_ID31           CAN_5.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_5_B31            CAN_5.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_5_H31            CAN_5.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_5_W31            CAN_5.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_5_CS32           CAN_5.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_5_ID32           CAN_5.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_5_B32            CAN_5.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_5_H32            CAN_5.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_5_W32            CAN_5.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_5_CS33           CAN_5.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_5_ID33           CAN_5.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_5_B33            CAN_5.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_5_H33            CAN_5.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_5_W33            CAN_5.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_5_CS34           CAN_5.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_5_ID34           CAN_5.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_5_B34            CAN_5.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_5_H34            CAN_5.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_5_W34            CAN_5.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_5_CS35           CAN_5.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_5_ID35           CAN_5.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_5_B35            CAN_5.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_5_H35            CAN_5.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_5_W35            CAN_5.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_5_CS36           CAN_5.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_5_ID36           CAN_5.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_5_B36            CAN_5.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_5_H36            CAN_5.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_5_W36            CAN_5.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_5_CS37           CAN_5.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_5_ID37           CAN_5.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_5_B37            CAN_5.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_5_H37            CAN_5.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_5_W37            CAN_5.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_5_CS38           CAN_5.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_5_ID38           CAN_5.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_5_B38            CAN_5.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_5_H38            CAN_5.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_5_W38            CAN_5.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_5_CS39           CAN_5.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_5_ID39           CAN_5.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_5_B39            CAN_5.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_5_H39            CAN_5.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_5_W39            CAN_5.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_5_CS40           CAN_5.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_5_ID40           CAN_5.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_5_B40            CAN_5.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_5_H40            CAN_5.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_5_W40            CAN_5.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_5_CS41           CAN_5.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_5_ID41           CAN_5.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_5_B41            CAN_5.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_5_H41            CAN_5.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_5_W41            CAN_5.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_5_CS42           CAN_5.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_5_ID42           CAN_5.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_5_B42            CAN_5.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_5_H42            CAN_5.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_5_W42            CAN_5.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_5_CS43           CAN_5.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_5_ID43           CAN_5.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_5_B43            CAN_5.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_5_H43            CAN_5.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_5_W43            CAN_5.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_5_CS44           CAN_5.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_5_ID44           CAN_5.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_5_B44            CAN_5.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_5_H44            CAN_5.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_5_W44            CAN_5.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_5_CS45           CAN_5.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_5_ID45           CAN_5.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_5_B45            CAN_5.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_5_H45            CAN_5.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_5_W45            CAN_5.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_5_CS46           CAN_5.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_5_ID46           CAN_5.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_5_B46            CAN_5.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_5_H46            CAN_5.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_5_W46            CAN_5.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_5_CS47           CAN_5.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_5_ID47           CAN_5.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_5_B47            CAN_5.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_5_H47            CAN_5.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_5_W47            CAN_5.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_5_CS48           CAN_5.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_5_ID48           CAN_5.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_5_B48            CAN_5.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_5_H48            CAN_5.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_5_W48            CAN_5.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_5_CS49           CAN_5.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_5_ID49           CAN_5.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_5_B49            CAN_5.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_5_H49            CAN_5.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_5_W49            CAN_5.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_5_CS50           CAN_5.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_5_ID50           CAN_5.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_5_B50            CAN_5.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_5_H50            CAN_5.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_5_W50            CAN_5.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_5_CS51           CAN_5.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_5_ID51           CAN_5.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_5_B51            CAN_5.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_5_H51            CAN_5.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_5_W51            CAN_5.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_5_CS52           CAN_5.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_5_ID52           CAN_5.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_5_B52            CAN_5.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_5_H52            CAN_5.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_5_W52            CAN_5.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_5_CS53           CAN_5.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_5_ID53           CAN_5.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_5_B53            CAN_5.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_5_H53            CAN_5.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_5_W53            CAN_5.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_5_CS54           CAN_5.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_5_ID54           CAN_5.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_5_B54            CAN_5.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_5_H54            CAN_5.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_5_W54            CAN_5.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_5_CS55           CAN_5.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_5_ID55           CAN_5.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_5_B55            CAN_5.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_5_H55            CAN_5.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_5_W55            CAN_5.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_5_CS56           CAN_5.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_5_ID56           CAN_5.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_5_B56            CAN_5.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_5_H56            CAN_5.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_5_W56            CAN_5.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_5_CS57           CAN_5.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_5_ID57           CAN_5.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_5_B57            CAN_5.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_5_H57            CAN_5.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_5_W57            CAN_5.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_5_CS58           CAN_5.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_5_ID58           CAN_5.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_5_B58            CAN_5.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_5_H58            CAN_5.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_5_W58            CAN_5.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_5_CS59           CAN_5.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_5_ID59           CAN_5.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_5_B59            CAN_5.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_5_H59            CAN_5.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_5_W59            CAN_5.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_5_CS60           CAN_5.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_5_ID60           CAN_5.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_5_B60            CAN_5.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_5_H60            CAN_5.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_5_W60            CAN_5.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_5_CS61           CAN_5.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_5_ID61           CAN_5.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_5_B61            CAN_5.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_5_H61            CAN_5.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_5_W61            CAN_5.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_5_CS62           CAN_5.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_5_ID62           CAN_5.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_5_B62            CAN_5.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_5_H62            CAN_5.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_5_W62            CAN_5.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_5_CS63           CAN_5.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_5_ID63           CAN_5.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_5_B63            CAN_5.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_5_H63            CAN_5.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_5_W63            CAN_5.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_5_CS64           CAN_5.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_5_ID64           CAN_5.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_5_B64            CAN_5.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_5_H64            CAN_5.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_5_W64            CAN_5.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_5_CS65           CAN_5.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_5_ID65           CAN_5.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_5_B65            CAN_5.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_5_H65            CAN_5.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_5_W65            CAN_5.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_5_CS66           CAN_5.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_5_ID66           CAN_5.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_5_B66            CAN_5.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_5_H66            CAN_5.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_5_W66            CAN_5.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_5_CS67           CAN_5.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_5_ID67           CAN_5.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_5_B67            CAN_5.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_5_H67            CAN_5.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_5_W67            CAN_5.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_5_CS68           CAN_5.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_5_ID68           CAN_5.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_5_B68            CAN_5.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_5_H68            CAN_5.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_5_W68            CAN_5.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_5_CS69           CAN_5.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_5_ID69           CAN_5.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_5_B69            CAN_5.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_5_H69            CAN_5.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_5_W69            CAN_5.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_5_CS70           CAN_5.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_5_ID70           CAN_5.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_5_B70            CAN_5.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_5_H70            CAN_5.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_5_W70            CAN_5.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_5_CS71           CAN_5.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_5_ID71           CAN_5.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_5_B71            CAN_5.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_5_H71            CAN_5.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_5_W71            CAN_5.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_5_CS72           CAN_5.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_5_ID72           CAN_5.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_5_B72            CAN_5.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_5_H72            CAN_5.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_5_W72            CAN_5.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_5_CS73           CAN_5.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_5_ID73           CAN_5.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_5_B73            CAN_5.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_5_H73            CAN_5.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_5_W73            CAN_5.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_5_CS74           CAN_5.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_5_ID74           CAN_5.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_5_B74            CAN_5.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_5_H74            CAN_5.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_5_W74            CAN_5.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_5_CS75           CAN_5.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_5_ID75           CAN_5.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_5_B75            CAN_5.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_5_H75            CAN_5.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_5_W75            CAN_5.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_5_CS76           CAN_5.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_5_ID76           CAN_5.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_5_B76            CAN_5.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_5_H76            CAN_5.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_5_W76            CAN_5.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_5_CS77           CAN_5.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_5_ID77           CAN_5.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_5_B77            CAN_5.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_5_H77            CAN_5.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_5_W77            CAN_5.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_5_CS78           CAN_5.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_5_ID78           CAN_5.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_5_B78            CAN_5.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_5_H78            CAN_5.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_5_W78            CAN_5.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_5_CS79           CAN_5.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_5_ID79           CAN_5.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_5_B79            CAN_5.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_5_H79            CAN_5.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_5_W79            CAN_5.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_5_CS80           CAN_5.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_5_ID80           CAN_5.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_5_B80            CAN_5.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_5_H80            CAN_5.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_5_W80            CAN_5.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_5_CS81           CAN_5.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_5_ID81           CAN_5.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_5_B81            CAN_5.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_5_H81            CAN_5.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_5_W81            CAN_5.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_5_CS82           CAN_5.MB[82].CS.R             /* Message Buffer 82 CS Register */
#define CAN_5_ID82           CAN_5.MB[82].ID.R             /* Message Buffer 82 ID Register */
#define CAN_5_B82            CAN_5.MB[82].DATA.B           /* Message Buffer 82 B Register */
#define CAN_5_H82            CAN_5.MB[82].DATA.H           /* Message Buffer 82 H Register */
#define CAN_5_W82            CAN_5.MB[82].DATA.W           /* Message Buffer 82 W Register */
#define CAN_5_CS83           CAN_5.MB[83].CS.R             /* Message Buffer 83 CS Register */
#define CAN_5_ID83           CAN_5.MB[83].ID.R             /* Message Buffer 83 ID Register */
#define CAN_5_B83            CAN_5.MB[83].DATA.B           /* Message Buffer 83 B Register */
#define CAN_5_H83            CAN_5.MB[83].DATA.H           /* Message Buffer 83 H Register */
#define CAN_5_W83            CAN_5.MB[83].DATA.W           /* Message Buffer 83 W Register */
#define CAN_5_CS84           CAN_5.MB[84].CS.R             /* Message Buffer 84 CS Register */
#define CAN_5_ID84           CAN_5.MB[84].ID.R             /* Message Buffer 84 ID Register */
#define CAN_5_B84            CAN_5.MB[84].DATA.B           /* Message Buffer 84 B Register */
#define CAN_5_H84            CAN_5.MB[84].DATA.H           /* Message Buffer 84 H Register */
#define CAN_5_W84            CAN_5.MB[84].DATA.W           /* Message Buffer 84 W Register */
#define CAN_5_CS85           CAN_5.MB[85].CS.R             /* Message Buffer 85 CS Register */
#define CAN_5_ID85           CAN_5.MB[85].ID.R             /* Message Buffer 85 ID Register */
#define CAN_5_B85            CAN_5.MB[85].DATA.B           /* Message Buffer 85 B Register */
#define CAN_5_H85            CAN_5.MB[85].DATA.H           /* Message Buffer 85 H Register */
#define CAN_5_W85            CAN_5.MB[85].DATA.W           /* Message Buffer 85 W Register */
#define CAN_5_CS86           CAN_5.MB[86].CS.R             /* Message Buffer 86 CS Register */
#define CAN_5_ID86           CAN_5.MB[86].ID.R             /* Message Buffer 86 ID Register */
#define CAN_5_B86            CAN_5.MB[86].DATA.B           /* Message Buffer 86 B Register */
#define CAN_5_H86            CAN_5.MB[86].DATA.H           /* Message Buffer 86 H Register */
#define CAN_5_W86            CAN_5.MB[86].DATA.W           /* Message Buffer 86 W Register */
#define CAN_5_CS87           CAN_5.MB[87].CS.R             /* Message Buffer 87 CS Register */
#define CAN_5_ID87           CAN_5.MB[87].ID.R             /* Message Buffer 87 ID Register */
#define CAN_5_B87            CAN_5.MB[87].DATA.B           /* Message Buffer 87 B Register */
#define CAN_5_H87            CAN_5.MB[87].DATA.H           /* Message Buffer 87 H Register */
#define CAN_5_W87            CAN_5.MB[87].DATA.W           /* Message Buffer 87 W Register */
#define CAN_5_CS88           CAN_5.MB[88].CS.R             /* Message Buffer 88 CS Register */
#define CAN_5_ID88           CAN_5.MB[88].ID.R             /* Message Buffer 88 ID Register */
#define CAN_5_B88            CAN_5.MB[88].DATA.B           /* Message Buffer 88 B Register */
#define CAN_5_H88            CAN_5.MB[88].DATA.H           /* Message Buffer 88 H Register */
#define CAN_5_W88            CAN_5.MB[88].DATA.W           /* Message Buffer 88 W Register */
#define CAN_5_CS89           CAN_5.MB[89].CS.R             /* Message Buffer 89 CS Register */
#define CAN_5_ID89           CAN_5.MB[89].ID.R             /* Message Buffer 89 ID Register */
#define CAN_5_B89            CAN_5.MB[89].DATA.B           /* Message Buffer 89 B Register */
#define CAN_5_H89            CAN_5.MB[89].DATA.H           /* Message Buffer 89 H Register */
#define CAN_5_W89            CAN_5.MB[89].DATA.W           /* Message Buffer 89 W Register */
#define CAN_5_CS90           CAN_5.MB[90].CS.R             /* Message Buffer 90 CS Register */
#define CAN_5_ID90           CAN_5.MB[90].ID.R             /* Message Buffer 90 ID Register */
#define CAN_5_B90            CAN_5.MB[90].DATA.B           /* Message Buffer 90 B Register */
#define CAN_5_H90            CAN_5.MB[90].DATA.H           /* Message Buffer 90 H Register */
#define CAN_5_W90            CAN_5.MB[90].DATA.W           /* Message Buffer 90 W Register */
#define CAN_5_CS91           CAN_5.MB[91].CS.R             /* Message Buffer 91 CS Register */
#define CAN_5_ID91           CAN_5.MB[91].ID.R             /* Message Buffer 91 ID Register */
#define CAN_5_B91            CAN_5.MB[91].DATA.B           /* Message Buffer 91 B Register */
#define CAN_5_H91            CAN_5.MB[91].DATA.H           /* Message Buffer 91 H Register */
#define CAN_5_W91            CAN_5.MB[91].DATA.W           /* Message Buffer 91 W Register */
#define CAN_5_CS92           CAN_5.MB[92].CS.R             /* Message Buffer 92 CS Register */
#define CAN_5_ID92           CAN_5.MB[92].ID.R             /* Message Buffer 92 ID Register */
#define CAN_5_B92            CAN_5.MB[92].DATA.B           /* Message Buffer 92 B Register */
#define CAN_5_H92            CAN_5.MB[92].DATA.H           /* Message Buffer 92 H Register */
#define CAN_5_W92            CAN_5.MB[92].DATA.W           /* Message Buffer 92 W Register */
#define CAN_5_CS93           CAN_5.MB[93].CS.R             /* Message Buffer 93 CS Register */
#define CAN_5_ID93           CAN_5.MB[93].ID.R             /* Message Buffer 93 ID Register */
#define CAN_5_B93            CAN_5.MB[93].DATA.B           /* Message Buffer 93 B Register */
#define CAN_5_H93            CAN_5.MB[93].DATA.H           /* Message Buffer 93 H Register */
#define CAN_5_W93            CAN_5.MB[93].DATA.W           /* Message Buffer 93 W Register */
#define CAN_5_CS94           CAN_5.MB[94].CS.R             /* Message Buffer 94 CS Register */
#define CAN_5_ID94           CAN_5.MB[94].ID.R             /* Message Buffer 94 ID Register */
#define CAN_5_B94            CAN_5.MB[94].DATA.B           /* Message Buffer 94 B Register */
#define CAN_5_H94            CAN_5.MB[94].DATA.H           /* Message Buffer 94 H Register */
#define CAN_5_W94            CAN_5.MB[94].DATA.W           /* Message Buffer 94 W Register */
#define CAN_5_CS95           CAN_5.MB[95].CS.R             /* Message Buffer 95 CS Register */
#define CAN_5_ID95           CAN_5.MB[95].ID.R             /* Message Buffer 95 ID Register */
#define CAN_5_B95            CAN_5.MB[95].DATA.B           /* Message Buffer 95 B Register */
#define CAN_5_H95            CAN_5.MB[95].DATA.H           /* Message Buffer 95 H Register */
#define CAN_5_W95            CAN_5.MB[95].DATA.W           /* Message Buffer 95 W Register */
#define CAN_5_RXIMR0         CAN_5.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR1         CAN_5.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR2         CAN_5.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR3         CAN_5.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR4         CAN_5.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR5         CAN_5.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR6         CAN_5.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR7         CAN_5.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR8         CAN_5.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR9         CAN_5.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_5_RXIMR10        CAN_5.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR11        CAN_5.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR12        CAN_5.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR13        CAN_5.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR14        CAN_5.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR15        CAN_5.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR16        CAN_5.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR17        CAN_5.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR18        CAN_5.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR19        CAN_5.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR20        CAN_5.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR21        CAN_5.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR22        CAN_5.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR23        CAN_5.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR24        CAN_5.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR25        CAN_5.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR26        CAN_5.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR27        CAN_5.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR28        CAN_5.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR29        CAN_5.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR30        CAN_5.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR31        CAN_5.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR32        CAN_5.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR33        CAN_5.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR34        CAN_5.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR35        CAN_5.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR36        CAN_5.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR37        CAN_5.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR38        CAN_5.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR39        CAN_5.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR40        CAN_5.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR41        CAN_5.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR42        CAN_5.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR43        CAN_5.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR44        CAN_5.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR45        CAN_5.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR46        CAN_5.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR47        CAN_5.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR48        CAN_5.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR49        CAN_5.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR50        CAN_5.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR51        CAN_5.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR52        CAN_5.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR53        CAN_5.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR54        CAN_5.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR55        CAN_5.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR56        CAN_5.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR57        CAN_5.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR58        CAN_5.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR59        CAN_5.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR60        CAN_5.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR61        CAN_5.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR62        CAN_5.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR63        CAN_5.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR64        CAN_5.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR65        CAN_5.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR66        CAN_5.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR67        CAN_5.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR68        CAN_5.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR69        CAN_5.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR70        CAN_5.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR71        CAN_5.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR72        CAN_5.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR73        CAN_5.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR74        CAN_5.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR75        CAN_5.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR76        CAN_5.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR77        CAN_5.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR78        CAN_5.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR79        CAN_5.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR80        CAN_5.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR81        CAN_5.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR82        CAN_5.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR83        CAN_5.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR84        CAN_5.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR85        CAN_5.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR86        CAN_5.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR87        CAN_5.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR88        CAN_5.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR89        CAN_5.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR90        CAN_5.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR91        CAN_5.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR92        CAN_5.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR93        CAN_5.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR94        CAN_5.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_5_RXIMR95        CAN_5.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_5_FDCTRL         CAN_5.FDCTRL.R                /* CAN FD Control Register */
#define CAN_5_FDCBT          CAN_5.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_5_FDCRC          CAN_5.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_6_MCR            CAN_6.MCR.R                   /* Module Configuration Register */
#define CAN_6_CTRL1          CAN_6.CTRL1.R                 /* Control 1 register */
#define CAN_6_TIMER          CAN_6.TIMER.R                 /* Free Running Timer */
#define CAN_6_RXMGMASK       CAN_6.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_6_RX14MASK       CAN_6.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_6_RX15MASK       CAN_6.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_6_ECR            CAN_6.ECR.R                   /* Error Counter */
#define CAN_6_ESR1           CAN_6.ESR1.R                  /* Error and Status 1 register */
#define CAN_6_IMASK2         CAN_6.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_6_IMASK1         CAN_6.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_6_IFLAG2         CAN_6.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_6_IFLAG1         CAN_6.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_6_CTRL2          CAN_6.CTRL2.R                 /* Control 2 register */
#define CAN_6_ESR2           CAN_6.ESR2.R                  /* Error and Status 2 register */
#define CAN_6_CRCR           CAN_6.CRCR.R                  /* CRC Register */
#define CAN_6_RXFGMASK       CAN_6.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_6_RXFIR          CAN_6.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_6_CS0            CAN_6.MB[0].CS.R             /* Message Buffer 0 CS Register */
#define CAN_6_ID0            CAN_6.MB[0].ID.R             /* Message Buffer 0 ID Register */
#define CAN_6_B0             CAN_6.MB[0].DATA.B           /* Message Buffer 0 B Register */
#define CAN_6_H0             CAN_6.MB[0].DATA.H           /* Message Buffer 0 H Register */
#define CAN_6_W0             CAN_6.MB[0].DATA.W           /* Message Buffer 0 W Register */
#define CAN_6_CS1            CAN_6.MB[1].CS.R             /* Message Buffer 1 CS Register */
#define CAN_6_ID1            CAN_6.MB[1].ID.R             /* Message Buffer 1 ID Register */
#define CAN_6_B1             CAN_6.MB[1].DATA.B           /* Message Buffer 1 B Register */
#define CAN_6_H1             CAN_6.MB[1].DATA.H           /* Message Buffer 1 H Register */
#define CAN_6_W1             CAN_6.MB[1].DATA.W           /* Message Buffer 1 W Register */
#define CAN_6_CS2            CAN_6.MB[2].CS.R             /* Message Buffer 2 CS Register */
#define CAN_6_ID2            CAN_6.MB[2].ID.R             /* Message Buffer 2 ID Register */
#define CAN_6_B2             CAN_6.MB[2].DATA.B           /* Message Buffer 2 B Register */
#define CAN_6_H2             CAN_6.MB[2].DATA.H           /* Message Buffer 2 H Register */
#define CAN_6_W2             CAN_6.MB[2].DATA.W           /* Message Buffer 2 W Register */
#define CAN_6_CS3            CAN_6.MB[3].CS.R             /* Message Buffer 3 CS Register */
#define CAN_6_ID3            CAN_6.MB[3].ID.R             /* Message Buffer 3 ID Register */
#define CAN_6_B3             CAN_6.MB[3].DATA.B           /* Message Buffer 3 B Register */
#define CAN_6_H3             CAN_6.MB[3].DATA.H           /* Message Buffer 3 H Register */
#define CAN_6_W3             CAN_6.MB[3].DATA.W           /* Message Buffer 3 W Register */
#define CAN_6_CS4            CAN_6.MB[4].CS.R             /* Message Buffer 4 CS Register */
#define CAN_6_ID4            CAN_6.MB[4].ID.R             /* Message Buffer 4 ID Register */
#define CAN_6_B4             CAN_6.MB[4].DATA.B           /* Message Buffer 4 B Register */
#define CAN_6_H4             CAN_6.MB[4].DATA.H           /* Message Buffer 4 H Register */
#define CAN_6_W4             CAN_6.MB[4].DATA.W           /* Message Buffer 4 W Register */
#define CAN_6_CS5            CAN_6.MB[5].CS.R             /* Message Buffer 5 CS Register */
#define CAN_6_ID5            CAN_6.MB[5].ID.R             /* Message Buffer 5 ID Register */
#define CAN_6_B5             CAN_6.MB[5].DATA.B           /* Message Buffer 5 B Register */
#define CAN_6_H5             CAN_6.MB[5].DATA.H           /* Message Buffer 5 H Register */
#define CAN_6_W5             CAN_6.MB[5].DATA.W           /* Message Buffer 5 W Register */
#define CAN_6_CS6            CAN_6.MB[6].CS.R             /* Message Buffer 6 CS Register */
#define CAN_6_ID6            CAN_6.MB[6].ID.R             /* Message Buffer 6 ID Register */
#define CAN_6_B6             CAN_6.MB[6].DATA.B           /* Message Buffer 6 B Register */
#define CAN_6_H6             CAN_6.MB[6].DATA.H           /* Message Buffer 6 H Register */
#define CAN_6_W6             CAN_6.MB[6].DATA.W           /* Message Buffer 6 W Register */
#define CAN_6_CS7            CAN_6.MB[7].CS.R             /* Message Buffer 7 CS Register */
#define CAN_6_ID7            CAN_6.MB[7].ID.R             /* Message Buffer 7 ID Register */
#define CAN_6_B7             CAN_6.MB[7].DATA.B           /* Message Buffer 7 B Register */
#define CAN_6_H7             CAN_6.MB[7].DATA.H           /* Message Buffer 7 H Register */
#define CAN_6_W7             CAN_6.MB[7].DATA.W           /* Message Buffer 7 W Register */
#define CAN_6_CS8            CAN_6.MB[8].CS.R             /* Message Buffer 8 CS Register */
#define CAN_6_ID8            CAN_6.MB[8].ID.R             /* Message Buffer 8 ID Register */
#define CAN_6_B8             CAN_6.MB[8].DATA.B           /* Message Buffer 8 B Register */
#define CAN_6_H8             CAN_6.MB[8].DATA.H           /* Message Buffer 8 H Register */
#define CAN_6_W8             CAN_6.MB[8].DATA.W           /* Message Buffer 8 W Register */
#define CAN_6_CS9            CAN_6.MB[9].CS.R             /* Message Buffer 9 CS Register */
#define CAN_6_ID9            CAN_6.MB[9].ID.R             /* Message Buffer 9 ID Register */
#define CAN_6_B9             CAN_6.MB[9].DATA.B           /* Message Buffer 9 B Register */
#define CAN_6_H9             CAN_6.MB[9].DATA.H           /* Message Buffer 9 H Register */
#define CAN_6_W9             CAN_6.MB[9].DATA.W           /* Message Buffer 9 W Register */
#define CAN_6_CS10           CAN_6.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_6_ID10           CAN_6.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_6_B10            CAN_6.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_6_H10            CAN_6.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_6_W10            CAN_6.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_6_CS11           CAN_6.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_6_ID11           CAN_6.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_6_B11            CAN_6.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_6_H11            CAN_6.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_6_W11            CAN_6.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_6_CS12           CAN_6.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_6_ID12           CAN_6.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_6_B12            CAN_6.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_6_H12            CAN_6.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_6_W12            CAN_6.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_6_CS13           CAN_6.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_6_ID13           CAN_6.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_6_B13            CAN_6.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_6_H13            CAN_6.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_6_W13            CAN_6.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_6_CS14           CAN_6.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_6_ID14           CAN_6.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_6_B14            CAN_6.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_6_H14            CAN_6.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_6_W14            CAN_6.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_6_CS15           CAN_6.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_6_ID15           CAN_6.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_6_B15            CAN_6.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_6_H15            CAN_6.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_6_W15            CAN_6.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_6_CS16           CAN_6.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_6_ID16           CAN_6.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_6_B16            CAN_6.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_6_H16            CAN_6.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_6_W16            CAN_6.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_6_CS17           CAN_6.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_6_ID17           CAN_6.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_6_B17            CAN_6.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_6_H17            CAN_6.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_6_W17            CAN_6.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_6_CS18           CAN_6.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_6_ID18           CAN_6.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_6_B18            CAN_6.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_6_H18            CAN_6.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_6_W18            CAN_6.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_6_CS19           CAN_6.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_6_ID19           CAN_6.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_6_B19            CAN_6.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_6_H19            CAN_6.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_6_W19            CAN_6.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_6_CS20           CAN_6.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_6_ID20           CAN_6.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_6_B20            CAN_6.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_6_H20            CAN_6.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_6_W20            CAN_6.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_6_CS21           CAN_6.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_6_ID21           CAN_6.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_6_B21            CAN_6.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_6_H21            CAN_6.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_6_W21            CAN_6.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_6_CS22           CAN_6.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_6_ID22           CAN_6.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_6_B22            CAN_6.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_6_H22            CAN_6.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_6_W22            CAN_6.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_6_CS23           CAN_6.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_6_ID23           CAN_6.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_6_B23            CAN_6.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_6_H23            CAN_6.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_6_W23            CAN_6.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_6_CS24           CAN_6.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_6_ID24           CAN_6.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_6_B24            CAN_6.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_6_H24            CAN_6.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_6_W24            CAN_6.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_6_CS25           CAN_6.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_6_ID25           CAN_6.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_6_B25            CAN_6.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_6_H25            CAN_6.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_6_W25            CAN_6.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_6_CS26           CAN_6.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_6_ID26           CAN_6.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_6_B26            CAN_6.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_6_H26            CAN_6.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_6_W26            CAN_6.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_6_CS27           CAN_6.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_6_ID27           CAN_6.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_6_B27            CAN_6.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_6_H27            CAN_6.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_6_W27            CAN_6.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_6_CS28           CAN_6.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_6_ID28           CAN_6.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_6_B28            CAN_6.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_6_H28            CAN_6.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_6_W28            CAN_6.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_6_CS29           CAN_6.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_6_ID29           CAN_6.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_6_B29            CAN_6.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_6_H29            CAN_6.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_6_W29            CAN_6.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_6_CS30           CAN_6.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_6_ID30           CAN_6.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_6_B30            CAN_6.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_6_H30            CAN_6.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_6_W30            CAN_6.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_6_CS31           CAN_6.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_6_ID31           CAN_6.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_6_B31            CAN_6.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_6_H31            CAN_6.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_6_W31            CAN_6.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_6_CS32           CAN_6.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_6_ID32           CAN_6.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_6_B32            CAN_6.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_6_H32            CAN_6.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_6_W32            CAN_6.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_6_CS33           CAN_6.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_6_ID33           CAN_6.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_6_B33            CAN_6.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_6_H33            CAN_6.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_6_W33            CAN_6.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_6_CS34           CAN_6.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_6_ID34           CAN_6.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_6_B34            CAN_6.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_6_H34            CAN_6.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_6_W34            CAN_6.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_6_CS35           CAN_6.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_6_ID35           CAN_6.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_6_B35            CAN_6.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_6_H35            CAN_6.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_6_W35            CAN_6.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_6_CS36           CAN_6.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_6_ID36           CAN_6.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_6_B36            CAN_6.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_6_H36            CAN_6.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_6_W36            CAN_6.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_6_CS37           CAN_6.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_6_ID37           CAN_6.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_6_B37            CAN_6.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_6_H37            CAN_6.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_6_W37            CAN_6.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_6_CS38           CAN_6.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_6_ID38           CAN_6.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_6_B38            CAN_6.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_6_H38            CAN_6.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_6_W38            CAN_6.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_6_CS39           CAN_6.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_6_ID39           CAN_6.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_6_B39            CAN_6.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_6_H39            CAN_6.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_6_W39            CAN_6.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_6_CS40           CAN_6.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_6_ID40           CAN_6.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_6_B40            CAN_6.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_6_H40            CAN_6.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_6_W40            CAN_6.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_6_CS41           CAN_6.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_6_ID41           CAN_6.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_6_B41            CAN_6.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_6_H41            CAN_6.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_6_W41            CAN_6.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_6_CS42           CAN_6.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_6_ID42           CAN_6.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_6_B42            CAN_6.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_6_H42            CAN_6.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_6_W42            CAN_6.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_6_CS43           CAN_6.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_6_ID43           CAN_6.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_6_B43            CAN_6.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_6_H43            CAN_6.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_6_W43            CAN_6.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_6_CS44           CAN_6.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_6_ID44           CAN_6.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_6_B44            CAN_6.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_6_H44            CAN_6.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_6_W44            CAN_6.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_6_CS45           CAN_6.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_6_ID45           CAN_6.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_6_B45            CAN_6.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_6_H45            CAN_6.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_6_W45            CAN_6.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_6_CS46           CAN_6.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_6_ID46           CAN_6.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_6_B46            CAN_6.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_6_H46            CAN_6.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_6_W46            CAN_6.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_6_CS47           CAN_6.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_6_ID47           CAN_6.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_6_B47            CAN_6.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_6_H47            CAN_6.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_6_W47            CAN_6.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_6_CS48           CAN_6.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_6_ID48           CAN_6.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_6_B48            CAN_6.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_6_H48            CAN_6.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_6_W48            CAN_6.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_6_CS49           CAN_6.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_6_ID49           CAN_6.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_6_B49            CAN_6.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_6_H49            CAN_6.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_6_W49            CAN_6.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_6_CS50           CAN_6.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_6_ID50           CAN_6.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_6_B50            CAN_6.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_6_H50            CAN_6.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_6_W50            CAN_6.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_6_CS51           CAN_6.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_6_ID51           CAN_6.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_6_B51            CAN_6.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_6_H51            CAN_6.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_6_W51            CAN_6.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_6_CS52           CAN_6.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_6_ID52           CAN_6.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_6_B52            CAN_6.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_6_H52            CAN_6.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_6_W52            CAN_6.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_6_CS53           CAN_6.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_6_ID53           CAN_6.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_6_B53            CAN_6.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_6_H53            CAN_6.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_6_W53            CAN_6.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_6_CS54           CAN_6.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_6_ID54           CAN_6.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_6_B54            CAN_6.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_6_H54            CAN_6.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_6_W54            CAN_6.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_6_CS55           CAN_6.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_6_ID55           CAN_6.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_6_B55            CAN_6.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_6_H55            CAN_6.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_6_W55            CAN_6.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_6_CS56           CAN_6.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_6_ID56           CAN_6.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_6_B56            CAN_6.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_6_H56            CAN_6.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_6_W56            CAN_6.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_6_CS57           CAN_6.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_6_ID57           CAN_6.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_6_B57            CAN_6.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_6_H57            CAN_6.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_6_W57            CAN_6.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_6_CS58           CAN_6.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_6_ID58           CAN_6.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_6_B58            CAN_6.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_6_H58            CAN_6.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_6_W58            CAN_6.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_6_CS59           CAN_6.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_6_ID59           CAN_6.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_6_B59            CAN_6.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_6_H59            CAN_6.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_6_W59            CAN_6.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_6_CS60           CAN_6.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_6_ID60           CAN_6.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_6_B60            CAN_6.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_6_H60            CAN_6.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_6_W60            CAN_6.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_6_CS61           CAN_6.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_6_ID61           CAN_6.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_6_B61            CAN_6.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_6_H61            CAN_6.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_6_W61            CAN_6.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_6_CS62           CAN_6.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_6_ID62           CAN_6.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_6_B62            CAN_6.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_6_H62            CAN_6.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_6_W62            CAN_6.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_6_CS63           CAN_6.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_6_ID63           CAN_6.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_6_B63            CAN_6.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_6_H63            CAN_6.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_6_W63            CAN_6.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_6_CS64           CAN_6.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_6_ID64           CAN_6.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_6_B64            CAN_6.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_6_H64            CAN_6.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_6_W64            CAN_6.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_6_CS65           CAN_6.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_6_ID65           CAN_6.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_6_B65            CAN_6.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_6_H65            CAN_6.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_6_W65            CAN_6.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_6_CS66           CAN_6.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_6_ID66           CAN_6.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_6_B66            CAN_6.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_6_H66            CAN_6.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_6_W66            CAN_6.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_6_CS67           CAN_6.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_6_ID67           CAN_6.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_6_B67            CAN_6.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_6_H67            CAN_6.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_6_W67            CAN_6.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_6_CS68           CAN_6.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_6_ID68           CAN_6.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_6_B68            CAN_6.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_6_H68            CAN_6.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_6_W68            CAN_6.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_6_CS69           CAN_6.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_6_ID69           CAN_6.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_6_B69            CAN_6.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_6_H69            CAN_6.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_6_W69            CAN_6.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_6_CS70           CAN_6.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_6_ID70           CAN_6.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_6_B70            CAN_6.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_6_H70            CAN_6.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_6_W70            CAN_6.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_6_CS71           CAN_6.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_6_ID71           CAN_6.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_6_B71            CAN_6.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_6_H71            CAN_6.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_6_W71            CAN_6.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_6_CS72           CAN_6.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_6_ID72           CAN_6.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_6_B72            CAN_6.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_6_H72            CAN_6.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_6_W72            CAN_6.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_6_CS73           CAN_6.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_6_ID73           CAN_6.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_6_B73            CAN_6.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_6_H73            CAN_6.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_6_W73            CAN_6.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_6_CS74           CAN_6.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_6_ID74           CAN_6.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_6_B74            CAN_6.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_6_H74            CAN_6.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_6_W74            CAN_6.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_6_CS75           CAN_6.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_6_ID75           CAN_6.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_6_B75            CAN_6.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_6_H75            CAN_6.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_6_W75            CAN_6.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_6_CS76           CAN_6.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_6_ID76           CAN_6.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_6_B76            CAN_6.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_6_H76            CAN_6.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_6_W76            CAN_6.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_6_CS77           CAN_6.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_6_ID77           CAN_6.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_6_B77            CAN_6.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_6_H77            CAN_6.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_6_W77            CAN_6.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_6_CS78           CAN_6.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_6_ID78           CAN_6.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_6_B78            CAN_6.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_6_H78            CAN_6.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_6_W78            CAN_6.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_6_CS79           CAN_6.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_6_ID79           CAN_6.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_6_B79            CAN_6.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_6_H79            CAN_6.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_6_W79            CAN_6.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_6_CS80           CAN_6.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_6_ID80           CAN_6.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_6_B80            CAN_6.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_6_H80            CAN_6.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_6_W80            CAN_6.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_6_CS81           CAN_6.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_6_ID81           CAN_6.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_6_B81            CAN_6.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_6_H81            CAN_6.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_6_W81            CAN_6.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_6_CS82           CAN_6.MB[82].CS.R             /* Message Buffer 82 CS Register */
#define CAN_6_ID82           CAN_6.MB[82].ID.R             /* Message Buffer 82 ID Register */
#define CAN_6_B82            CAN_6.MB[82].DATA.B           /* Message Buffer 82 B Register */
#define CAN_6_H82            CAN_6.MB[82].DATA.H           /* Message Buffer 82 H Register */
#define CAN_6_W82            CAN_6.MB[82].DATA.W           /* Message Buffer 82 W Register */
#define CAN_6_CS83           CAN_6.MB[83].CS.R             /* Message Buffer 83 CS Register */
#define CAN_6_ID83           CAN_6.MB[83].ID.R             /* Message Buffer 83 ID Register */
#define CAN_6_B83            CAN_6.MB[83].DATA.B           /* Message Buffer 83 B Register */
#define CAN_6_H83            CAN_6.MB[83].DATA.H           /* Message Buffer 83 H Register */
#define CAN_6_W83            CAN_6.MB[83].DATA.W           /* Message Buffer 83 W Register */
#define CAN_6_CS84           CAN_6.MB[84].CS.R             /* Message Buffer 84 CS Register */
#define CAN_6_ID84           CAN_6.MB[84].ID.R             /* Message Buffer 84 ID Register */
#define CAN_6_B84            CAN_6.MB[84].DATA.B           /* Message Buffer 84 B Register */
#define CAN_6_H84            CAN_6.MB[84].DATA.H           /* Message Buffer 84 H Register */
#define CAN_6_W84            CAN_6.MB[84].DATA.W           /* Message Buffer 84 W Register */
#define CAN_6_CS85           CAN_6.MB[85].CS.R             /* Message Buffer 85 CS Register */
#define CAN_6_ID85           CAN_6.MB[85].ID.R             /* Message Buffer 85 ID Register */
#define CAN_6_B85            CAN_6.MB[85].DATA.B           /* Message Buffer 85 B Register */
#define CAN_6_H85            CAN_6.MB[85].DATA.H           /* Message Buffer 85 H Register */
#define CAN_6_W85            CAN_6.MB[85].DATA.W           /* Message Buffer 85 W Register */
#define CAN_6_CS86           CAN_6.MB[86].CS.R             /* Message Buffer 86 CS Register */
#define CAN_6_ID86           CAN_6.MB[86].ID.R             /* Message Buffer 86 ID Register */
#define CAN_6_B86            CAN_6.MB[86].DATA.B           /* Message Buffer 86 B Register */
#define CAN_6_H86            CAN_6.MB[86].DATA.H           /* Message Buffer 86 H Register */
#define CAN_6_W86            CAN_6.MB[86].DATA.W           /* Message Buffer 86 W Register */
#define CAN_6_CS87           CAN_6.MB[87].CS.R             /* Message Buffer 87 CS Register */
#define CAN_6_ID87           CAN_6.MB[87].ID.R             /* Message Buffer 87 ID Register */
#define CAN_6_B87            CAN_6.MB[87].DATA.B           /* Message Buffer 87 B Register */
#define CAN_6_H87            CAN_6.MB[87].DATA.H           /* Message Buffer 87 H Register */
#define CAN_6_W87            CAN_6.MB[87].DATA.W           /* Message Buffer 87 W Register */
#define CAN_6_CS88           CAN_6.MB[88].CS.R             /* Message Buffer 88 CS Register */
#define CAN_6_ID88           CAN_6.MB[88].ID.R             /* Message Buffer 88 ID Register */
#define CAN_6_B88            CAN_6.MB[88].DATA.B           /* Message Buffer 88 B Register */
#define CAN_6_H88            CAN_6.MB[88].DATA.H           /* Message Buffer 88 H Register */
#define CAN_6_W88            CAN_6.MB[88].DATA.W           /* Message Buffer 88 W Register */
#define CAN_6_CS89           CAN_6.MB[89].CS.R             /* Message Buffer 89 CS Register */
#define CAN_6_ID89           CAN_6.MB[89].ID.R             /* Message Buffer 89 ID Register */
#define CAN_6_B89            CAN_6.MB[89].DATA.B           /* Message Buffer 89 B Register */
#define CAN_6_H89            CAN_6.MB[89].DATA.H           /* Message Buffer 89 H Register */
#define CAN_6_W89            CAN_6.MB[89].DATA.W           /* Message Buffer 89 W Register */
#define CAN_6_CS90           CAN_6.MB[90].CS.R             /* Message Buffer 90 CS Register */
#define CAN_6_ID90           CAN_6.MB[90].ID.R             /* Message Buffer 90 ID Register */
#define CAN_6_B90            CAN_6.MB[90].DATA.B           /* Message Buffer 90 B Register */
#define CAN_6_H90            CAN_6.MB[90].DATA.H           /* Message Buffer 90 H Register */
#define CAN_6_W90            CAN_6.MB[90].DATA.W           /* Message Buffer 90 W Register */
#define CAN_6_CS91           CAN_6.MB[91].CS.R             /* Message Buffer 91 CS Register */
#define CAN_6_ID91           CAN_6.MB[91].ID.R             /* Message Buffer 91 ID Register */
#define CAN_6_B91            CAN_6.MB[91].DATA.B           /* Message Buffer 91 B Register */
#define CAN_6_H91            CAN_6.MB[91].DATA.H           /* Message Buffer 91 H Register */
#define CAN_6_W91            CAN_6.MB[91].DATA.W           /* Message Buffer 91 W Register */
#define CAN_6_CS92           CAN_6.MB[92].CS.R             /* Message Buffer 92 CS Register */
#define CAN_6_ID92           CAN_6.MB[92].ID.R             /* Message Buffer 92 ID Register */
#define CAN_6_B92            CAN_6.MB[92].DATA.B           /* Message Buffer 92 B Register */
#define CAN_6_H92            CAN_6.MB[92].DATA.H           /* Message Buffer 92 H Register */
#define CAN_6_W92            CAN_6.MB[92].DATA.W           /* Message Buffer 92 W Register */
#define CAN_6_CS93           CAN_6.MB[93].CS.R             /* Message Buffer 93 CS Register */
#define CAN_6_ID93           CAN_6.MB[93].ID.R             /* Message Buffer 93 ID Register */
#define CAN_6_B93            CAN_6.MB[93].DATA.B           /* Message Buffer 93 B Register */
#define CAN_6_H93            CAN_6.MB[93].DATA.H           /* Message Buffer 93 H Register */
#define CAN_6_W93            CAN_6.MB[93].DATA.W           /* Message Buffer 93 W Register */
#define CAN_6_CS94           CAN_6.MB[94].CS.R             /* Message Buffer 94 CS Register */
#define CAN_6_ID94           CAN_6.MB[94].ID.R             /* Message Buffer 94 ID Register */
#define CAN_6_B94            CAN_6.MB[94].DATA.B           /* Message Buffer 94 B Register */
#define CAN_6_H94            CAN_6.MB[94].DATA.H           /* Message Buffer 94 H Register */
#define CAN_6_W94            CAN_6.MB[94].DATA.W           /* Message Buffer 94 W Register */
#define CAN_6_CS95           CAN_6.MB[95].CS.R             /* Message Buffer 95 CS Register */
#define CAN_6_ID95           CAN_6.MB[95].ID.R             /* Message Buffer 95 ID Register */
#define CAN_6_B95            CAN_6.MB[95].DATA.B           /* Message Buffer 95 B Register */
#define CAN_6_H95            CAN_6.MB[95].DATA.H           /* Message Buffer 95 H Register */
#define CAN_6_W95            CAN_6.MB[95].DATA.W           /* Message Buffer 95 W Register */
#define CAN_6_RXIMR0         CAN_6.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR1         CAN_6.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR2         CAN_6.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR3         CAN_6.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR4         CAN_6.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR5         CAN_6.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR6         CAN_6.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR7         CAN_6.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR8         CAN_6.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR9         CAN_6.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_6_RXIMR10        CAN_6.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR11        CAN_6.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR12        CAN_6.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR13        CAN_6.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR14        CAN_6.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR15        CAN_6.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR16        CAN_6.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR17        CAN_6.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR18        CAN_6.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR19        CAN_6.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR20        CAN_6.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR21        CAN_6.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR22        CAN_6.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR23        CAN_6.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR24        CAN_6.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR25        CAN_6.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR26        CAN_6.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR27        CAN_6.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR28        CAN_6.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR29        CAN_6.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR30        CAN_6.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR31        CAN_6.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR32        CAN_6.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR33        CAN_6.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR34        CAN_6.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR35        CAN_6.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR36        CAN_6.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR37        CAN_6.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR38        CAN_6.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR39        CAN_6.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR40        CAN_6.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR41        CAN_6.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR42        CAN_6.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR43        CAN_6.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR44        CAN_6.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR45        CAN_6.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR46        CAN_6.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR47        CAN_6.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR48        CAN_6.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR49        CAN_6.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR50        CAN_6.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR51        CAN_6.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR52        CAN_6.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR53        CAN_6.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR54        CAN_6.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR55        CAN_6.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR56        CAN_6.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR57        CAN_6.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR58        CAN_6.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR59        CAN_6.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR60        CAN_6.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR61        CAN_6.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR62        CAN_6.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR63        CAN_6.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR64        CAN_6.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR65        CAN_6.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR66        CAN_6.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR67        CAN_6.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR68        CAN_6.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR69        CAN_6.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR70        CAN_6.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR71        CAN_6.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR72        CAN_6.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR73        CAN_6.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR74        CAN_6.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR75        CAN_6.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR76        CAN_6.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR77        CAN_6.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR78        CAN_6.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR79        CAN_6.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR80        CAN_6.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR81        CAN_6.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR82        CAN_6.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR83        CAN_6.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR84        CAN_6.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR85        CAN_6.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR86        CAN_6.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR87        CAN_6.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR88        CAN_6.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR89        CAN_6.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR90        CAN_6.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR91        CAN_6.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR92        CAN_6.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR93        CAN_6.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR94        CAN_6.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_6_RXIMR95        CAN_6.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_6_FDCTRL         CAN_6.FDCTRL.R                /* CAN FD Control Register */
#define CAN_6_FDCBT          CAN_6.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_6_FDCRC          CAN_6.FDCRC.R                 /* CAN FD CRC Register */

/* CAN */
#define CAN_7_MCR            CAN_7.MCR.R                   /* Module Configuration Register */
#define CAN_7_CTRL1          CAN_7.CTRL1.R                 /* Control 1 register */
#define CAN_7_TIMER          CAN_7.TIMER.R                 /* Free Running Timer */
#define CAN_7_RXMGMASK       CAN_7.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_7_RX14MASK       CAN_7.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_7_RX15MASK       CAN_7.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_7_ECR            CAN_7.ECR.R                   /* Error Counter */
#define CAN_7_ESR1           CAN_7.ESR1.R                  /* Error and Status 1 register */
#define CAN_7_IMASK2         CAN_7.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_7_IMASK1         CAN_7.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_7_IFLAG2         CAN_7.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_7_IFLAG1         CAN_7.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_7_CTRL2          CAN_7.CTRL2.R                 /* Control 2 register */
#define CAN_7_ESR2           CAN_7.ESR2.R                  /* Error and Status 2 register */
#define CAN_7_CRCR           CAN_7.CRCR.R                  /* CRC Register */
#define CAN_7_RXFGMASK       CAN_7.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_7_RXFIR          CAN_7.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_7_CS0            CAN_7.MB[0].CS.R             /* Message Buffer 0 CS Register */
#define CAN_7_ID0            CAN_7.MB[0].ID.R             /* Message Buffer 0 ID Register */
#define CAN_7_B0             CAN_7.MB[0].DATA.B           /* Message Buffer 0 B Register */
#define CAN_7_H0             CAN_7.MB[0].DATA.H           /* Message Buffer 0 H Register */
#define CAN_7_W0             CAN_7.MB[0].DATA.W           /* Message Buffer 0 W Register */
#define CAN_7_CS1            CAN_7.MB[1].CS.R             /* Message Buffer 1 CS Register */
#define CAN_7_ID1            CAN_7.MB[1].ID.R             /* Message Buffer 1 ID Register */
#define CAN_7_B1             CAN_7.MB[1].DATA.B           /* Message Buffer 1 B Register */
#define CAN_7_H1             CAN_7.MB[1].DATA.H           /* Message Buffer 1 H Register */
#define CAN_7_W1             CAN_7.MB[1].DATA.W           /* Message Buffer 1 W Register */
#define CAN_7_CS2            CAN_7.MB[2].CS.R             /* Message Buffer 2 CS Register */
#define CAN_7_ID2            CAN_7.MB[2].ID.R             /* Message Buffer 2 ID Register */
#define CAN_7_B2             CAN_7.MB[2].DATA.B           /* Message Buffer 2 B Register */
#define CAN_7_H2             CAN_7.MB[2].DATA.H           /* Message Buffer 2 H Register */
#define CAN_7_W2             CAN_7.MB[2].DATA.W           /* Message Buffer 2 W Register */
#define CAN_7_CS3            CAN_7.MB[3].CS.R             /* Message Buffer 3 CS Register */
#define CAN_7_ID3            CAN_7.MB[3].ID.R             /* Message Buffer 3 ID Register */
#define CAN_7_B3             CAN_7.MB[3].DATA.B           /* Message Buffer 3 B Register */
#define CAN_7_H3             CAN_7.MB[3].DATA.H           /* Message Buffer 3 H Register */
#define CAN_7_W3             CAN_7.MB[3].DATA.W           /* Message Buffer 3 W Register */
#define CAN_7_CS4            CAN_7.MB[4].CS.R             /* Message Buffer 4 CS Register */
#define CAN_7_ID4            CAN_7.MB[4].ID.R             /* Message Buffer 4 ID Register */
#define CAN_7_B4             CAN_7.MB[4].DATA.B           /* Message Buffer 4 B Register */
#define CAN_7_H4             CAN_7.MB[4].DATA.H           /* Message Buffer 4 H Register */
#define CAN_7_W4             CAN_7.MB[4].DATA.W           /* Message Buffer 4 W Register */
#define CAN_7_CS5            CAN_7.MB[5].CS.R             /* Message Buffer 5 CS Register */
#define CAN_7_ID5            CAN_7.MB[5].ID.R             /* Message Buffer 5 ID Register */
#define CAN_7_B5             CAN_7.MB[5].DATA.B           /* Message Buffer 5 B Register */
#define CAN_7_H5             CAN_7.MB[5].DATA.H           /* Message Buffer 5 H Register */
#define CAN_7_W5             CAN_7.MB[5].DATA.W           /* Message Buffer 5 W Register */
#define CAN_7_CS6            CAN_7.MB[6].CS.R             /* Message Buffer 6 CS Register */
#define CAN_7_ID6            CAN_7.MB[6].ID.R             /* Message Buffer 6 ID Register */
#define CAN_7_B6             CAN_7.MB[6].DATA.B           /* Message Buffer 6 B Register */
#define CAN_7_H6             CAN_7.MB[6].DATA.H           /* Message Buffer 6 H Register */
#define CAN_7_W6             CAN_7.MB[6].DATA.W           /* Message Buffer 6 W Register */
#define CAN_7_CS7            CAN_7.MB[7].CS.R             /* Message Buffer 7 CS Register */
#define CAN_7_ID7            CAN_7.MB[7].ID.R             /* Message Buffer 7 ID Register */
#define CAN_7_B7             CAN_7.MB[7].DATA.B           /* Message Buffer 7 B Register */
#define CAN_7_H7             CAN_7.MB[7].DATA.H           /* Message Buffer 7 H Register */
#define CAN_7_W7             CAN_7.MB[7].DATA.W           /* Message Buffer 7 W Register */
#define CAN_7_CS8            CAN_7.MB[8].CS.R             /* Message Buffer 8 CS Register */
#define CAN_7_ID8            CAN_7.MB[8].ID.R             /* Message Buffer 8 ID Register */
#define CAN_7_B8             CAN_7.MB[8].DATA.B           /* Message Buffer 8 B Register */
#define CAN_7_H8             CAN_7.MB[8].DATA.H           /* Message Buffer 8 H Register */
#define CAN_7_W8             CAN_7.MB[8].DATA.W           /* Message Buffer 8 W Register */
#define CAN_7_CS9            CAN_7.MB[9].CS.R             /* Message Buffer 9 CS Register */
#define CAN_7_ID9            CAN_7.MB[9].ID.R             /* Message Buffer 9 ID Register */
#define CAN_7_B9             CAN_7.MB[9].DATA.B           /* Message Buffer 9 B Register */
#define CAN_7_H9             CAN_7.MB[9].DATA.H           /* Message Buffer 9 H Register */
#define CAN_7_W9             CAN_7.MB[9].DATA.W           /* Message Buffer 9 W Register */
#define CAN_7_CS10           CAN_7.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_7_ID10           CAN_7.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_7_B10            CAN_7.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_7_H10            CAN_7.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_7_W10            CAN_7.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_7_CS11           CAN_7.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_7_ID11           CAN_7.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_7_B11            CAN_7.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_7_H11            CAN_7.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_7_W11            CAN_7.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_7_CS12           CAN_7.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_7_ID12           CAN_7.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_7_B12            CAN_7.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_7_H12            CAN_7.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_7_W12            CAN_7.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_7_CS13           CAN_7.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_7_ID13           CAN_7.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_7_B13            CAN_7.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_7_H13            CAN_7.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_7_W13            CAN_7.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_7_CS14           CAN_7.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_7_ID14           CAN_7.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_7_B14            CAN_7.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_7_H14            CAN_7.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_7_W14            CAN_7.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_7_CS15           CAN_7.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_7_ID15           CAN_7.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_7_B15            CAN_7.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_7_H15            CAN_7.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_7_W15            CAN_7.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_7_CS16           CAN_7.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_7_ID16           CAN_7.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_7_B16            CAN_7.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_7_H16            CAN_7.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_7_W16            CAN_7.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_7_CS17           CAN_7.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_7_ID17           CAN_7.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_7_B17            CAN_7.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_7_H17            CAN_7.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_7_W17            CAN_7.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_7_CS18           CAN_7.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_7_ID18           CAN_7.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_7_B18            CAN_7.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_7_H18            CAN_7.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_7_W18            CAN_7.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_7_CS19           CAN_7.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_7_ID19           CAN_7.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_7_B19            CAN_7.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_7_H19            CAN_7.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_7_W19            CAN_7.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_7_CS20           CAN_7.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_7_ID20           CAN_7.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_7_B20            CAN_7.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_7_H20            CAN_7.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_7_W20            CAN_7.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_7_CS21           CAN_7.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_7_ID21           CAN_7.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_7_B21            CAN_7.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_7_H21            CAN_7.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_7_W21            CAN_7.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_7_CS22           CAN_7.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_7_ID22           CAN_7.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_7_B22            CAN_7.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_7_H22            CAN_7.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_7_W22            CAN_7.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_7_CS23           CAN_7.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_7_ID23           CAN_7.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_7_B23            CAN_7.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_7_H23            CAN_7.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_7_W23            CAN_7.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_7_CS24           CAN_7.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_7_ID24           CAN_7.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_7_B24            CAN_7.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_7_H24            CAN_7.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_7_W24            CAN_7.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_7_CS25           CAN_7.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_7_ID25           CAN_7.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_7_B25            CAN_7.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_7_H25            CAN_7.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_7_W25            CAN_7.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_7_CS26           CAN_7.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_7_ID26           CAN_7.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_7_B26            CAN_7.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_7_H26            CAN_7.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_7_W26            CAN_7.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_7_CS27           CAN_7.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_7_ID27           CAN_7.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_7_B27            CAN_7.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_7_H27            CAN_7.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_7_W27            CAN_7.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_7_CS28           CAN_7.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_7_ID28           CAN_7.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_7_B28            CAN_7.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_7_H28            CAN_7.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_7_W28            CAN_7.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_7_CS29           CAN_7.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_7_ID29           CAN_7.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_7_B29            CAN_7.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_7_H29            CAN_7.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_7_W29            CAN_7.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_7_CS30           CAN_7.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_7_ID30           CAN_7.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_7_B30            CAN_7.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_7_H30            CAN_7.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_7_W30            CAN_7.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_7_CS31           CAN_7.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_7_ID31           CAN_7.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_7_B31            CAN_7.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_7_H31            CAN_7.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_7_W31            CAN_7.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_7_CS32           CAN_7.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_7_ID32           CAN_7.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_7_B32            CAN_7.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_7_H32            CAN_7.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_7_W32            CAN_7.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_7_CS33           CAN_7.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_7_ID33           CAN_7.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_7_B33            CAN_7.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_7_H33            CAN_7.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_7_W33            CAN_7.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_7_CS34           CAN_7.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_7_ID34           CAN_7.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_7_B34            CAN_7.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_7_H34            CAN_7.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_7_W34            CAN_7.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_7_CS35           CAN_7.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_7_ID35           CAN_7.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_7_B35            CAN_7.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_7_H35            CAN_7.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_7_W35            CAN_7.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_7_CS36           CAN_7.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_7_ID36           CAN_7.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_7_B36            CAN_7.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_7_H36            CAN_7.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_7_W36            CAN_7.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_7_CS37           CAN_7.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_7_ID37           CAN_7.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_7_B37            CAN_7.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_7_H37            CAN_7.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_7_W37            CAN_7.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_7_CS38           CAN_7.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_7_ID38           CAN_7.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_7_B38            CAN_7.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_7_H38            CAN_7.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_7_W38            CAN_7.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_7_CS39           CAN_7.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_7_ID39           CAN_7.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_7_B39            CAN_7.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_7_H39            CAN_7.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_7_W39            CAN_7.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_7_CS40           CAN_7.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_7_ID40           CAN_7.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_7_B40            CAN_7.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_7_H40            CAN_7.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_7_W40            CAN_7.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_7_CS41           CAN_7.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_7_ID41           CAN_7.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_7_B41            CAN_7.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_7_H41            CAN_7.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_7_W41            CAN_7.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_7_CS42           CAN_7.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_7_ID42           CAN_7.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_7_B42            CAN_7.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_7_H42            CAN_7.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_7_W42            CAN_7.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_7_CS43           CAN_7.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_7_ID43           CAN_7.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_7_B43            CAN_7.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_7_H43            CAN_7.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_7_W43            CAN_7.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_7_CS44           CAN_7.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_7_ID44           CAN_7.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_7_B44            CAN_7.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_7_H44            CAN_7.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_7_W44            CAN_7.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_7_CS45           CAN_7.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_7_ID45           CAN_7.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_7_B45            CAN_7.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_7_H45            CAN_7.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_7_W45            CAN_7.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_7_CS46           CAN_7.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_7_ID46           CAN_7.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_7_B46            CAN_7.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_7_H46            CAN_7.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_7_W46            CAN_7.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_7_CS47           CAN_7.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_7_ID47           CAN_7.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_7_B47            CAN_7.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_7_H47            CAN_7.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_7_W47            CAN_7.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_7_CS48           CAN_7.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_7_ID48           CAN_7.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_7_B48            CAN_7.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_7_H48            CAN_7.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_7_W48            CAN_7.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_7_CS49           CAN_7.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_7_ID49           CAN_7.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_7_B49            CAN_7.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_7_H49            CAN_7.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_7_W49            CAN_7.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_7_CS50           CAN_7.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_7_ID50           CAN_7.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_7_B50            CAN_7.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_7_H50            CAN_7.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_7_W50            CAN_7.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_7_CS51           CAN_7.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_7_ID51           CAN_7.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_7_B51            CAN_7.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_7_H51            CAN_7.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_7_W51            CAN_7.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_7_CS52           CAN_7.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_7_ID52           CAN_7.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_7_B52            CAN_7.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_7_H52            CAN_7.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_7_W52            CAN_7.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_7_CS53           CAN_7.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_7_ID53           CAN_7.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_7_B53            CAN_7.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_7_H53            CAN_7.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_7_W53            CAN_7.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_7_CS54           CAN_7.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_7_ID54           CAN_7.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_7_B54            CAN_7.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_7_H54            CAN_7.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_7_W54            CAN_7.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_7_CS55           CAN_7.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_7_ID55           CAN_7.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_7_B55            CAN_7.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_7_H55            CAN_7.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_7_W55            CAN_7.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_7_CS56           CAN_7.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_7_ID56           CAN_7.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_7_B56            CAN_7.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_7_H56            CAN_7.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_7_W56            CAN_7.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_7_CS57           CAN_7.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_7_ID57           CAN_7.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_7_B57            CAN_7.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_7_H57            CAN_7.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_7_W57            CAN_7.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_7_CS58           CAN_7.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_7_ID58           CAN_7.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_7_B58            CAN_7.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_7_H58            CAN_7.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_7_W58            CAN_7.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_7_CS59           CAN_7.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_7_ID59           CAN_7.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_7_B59            CAN_7.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_7_H59            CAN_7.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_7_W59            CAN_7.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_7_CS60           CAN_7.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_7_ID60           CAN_7.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_7_B60            CAN_7.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_7_H60            CAN_7.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_7_W60            CAN_7.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_7_CS61           CAN_7.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_7_ID61           CAN_7.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_7_B61            CAN_7.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_7_H61            CAN_7.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_7_W61            CAN_7.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_7_CS62           CAN_7.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_7_ID62           CAN_7.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_7_B62            CAN_7.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_7_H62            CAN_7.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_7_W62            CAN_7.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_7_CS63           CAN_7.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_7_ID63           CAN_7.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_7_B63            CAN_7.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_7_H63            CAN_7.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_7_W63            CAN_7.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_7_CS64           CAN_7.MB[64].CS.R             /* Message Buffer 64 CS Register */
#define CAN_7_ID64           CAN_7.MB[64].ID.R             /* Message Buffer 64 ID Register */
#define CAN_7_B64            CAN_7.MB[64].DATA.B           /* Message Buffer 64 B Register */
#define CAN_7_H64            CAN_7.MB[64].DATA.H           /* Message Buffer 64 H Register */
#define CAN_7_W64            CAN_7.MB[64].DATA.W           /* Message Buffer 64 W Register */
#define CAN_7_CS65           CAN_7.MB[65].CS.R             /* Message Buffer 65 CS Register */
#define CAN_7_ID65           CAN_7.MB[65].ID.R             /* Message Buffer 65 ID Register */
#define CAN_7_B65            CAN_7.MB[65].DATA.B           /* Message Buffer 65 B Register */
#define CAN_7_H65            CAN_7.MB[65].DATA.H           /* Message Buffer 65 H Register */
#define CAN_7_W65            CAN_7.MB[65].DATA.W           /* Message Buffer 65 W Register */
#define CAN_7_CS66           CAN_7.MB[66].CS.R             /* Message Buffer 66 CS Register */
#define CAN_7_ID66           CAN_7.MB[66].ID.R             /* Message Buffer 66 ID Register */
#define CAN_7_B66            CAN_7.MB[66].DATA.B           /* Message Buffer 66 B Register */
#define CAN_7_H66            CAN_7.MB[66].DATA.H           /* Message Buffer 66 H Register */
#define CAN_7_W66            CAN_7.MB[66].DATA.W           /* Message Buffer 66 W Register */
#define CAN_7_CS67           CAN_7.MB[67].CS.R             /* Message Buffer 67 CS Register */
#define CAN_7_ID67           CAN_7.MB[67].ID.R             /* Message Buffer 67 ID Register */
#define CAN_7_B67            CAN_7.MB[67].DATA.B           /* Message Buffer 67 B Register */
#define CAN_7_H67            CAN_7.MB[67].DATA.H           /* Message Buffer 67 H Register */
#define CAN_7_W67            CAN_7.MB[67].DATA.W           /* Message Buffer 67 W Register */
#define CAN_7_CS68           CAN_7.MB[68].CS.R             /* Message Buffer 68 CS Register */
#define CAN_7_ID68           CAN_7.MB[68].ID.R             /* Message Buffer 68 ID Register */
#define CAN_7_B68            CAN_7.MB[68].DATA.B           /* Message Buffer 68 B Register */
#define CAN_7_H68            CAN_7.MB[68].DATA.H           /* Message Buffer 68 H Register */
#define CAN_7_W68            CAN_7.MB[68].DATA.W           /* Message Buffer 68 W Register */
#define CAN_7_CS69           CAN_7.MB[69].CS.R             /* Message Buffer 69 CS Register */
#define CAN_7_ID69           CAN_7.MB[69].ID.R             /* Message Buffer 69 ID Register */
#define CAN_7_B69            CAN_7.MB[69].DATA.B           /* Message Buffer 69 B Register */
#define CAN_7_H69            CAN_7.MB[69].DATA.H           /* Message Buffer 69 H Register */
#define CAN_7_W69            CAN_7.MB[69].DATA.W           /* Message Buffer 69 W Register */
#define CAN_7_CS70           CAN_7.MB[70].CS.R             /* Message Buffer 70 CS Register */
#define CAN_7_ID70           CAN_7.MB[70].ID.R             /* Message Buffer 70 ID Register */
#define CAN_7_B70            CAN_7.MB[70].DATA.B           /* Message Buffer 70 B Register */
#define CAN_7_H70            CAN_7.MB[70].DATA.H           /* Message Buffer 70 H Register */
#define CAN_7_W70            CAN_7.MB[70].DATA.W           /* Message Buffer 70 W Register */
#define CAN_7_CS71           CAN_7.MB[71].CS.R             /* Message Buffer 71 CS Register */
#define CAN_7_ID71           CAN_7.MB[71].ID.R             /* Message Buffer 71 ID Register */
#define CAN_7_B71            CAN_7.MB[71].DATA.B           /* Message Buffer 71 B Register */
#define CAN_7_H71            CAN_7.MB[71].DATA.H           /* Message Buffer 71 H Register */
#define CAN_7_W71            CAN_7.MB[71].DATA.W           /* Message Buffer 71 W Register */
#define CAN_7_CS72           CAN_7.MB[72].CS.R             /* Message Buffer 72 CS Register */
#define CAN_7_ID72           CAN_7.MB[72].ID.R             /* Message Buffer 72 ID Register */
#define CAN_7_B72            CAN_7.MB[72].DATA.B           /* Message Buffer 72 B Register */
#define CAN_7_H72            CAN_7.MB[72].DATA.H           /* Message Buffer 72 H Register */
#define CAN_7_W72            CAN_7.MB[72].DATA.W           /* Message Buffer 72 W Register */
#define CAN_7_CS73           CAN_7.MB[73].CS.R             /* Message Buffer 73 CS Register */
#define CAN_7_ID73           CAN_7.MB[73].ID.R             /* Message Buffer 73 ID Register */
#define CAN_7_B73            CAN_7.MB[73].DATA.B           /* Message Buffer 73 B Register */
#define CAN_7_H73            CAN_7.MB[73].DATA.H           /* Message Buffer 73 H Register */
#define CAN_7_W73            CAN_7.MB[73].DATA.W           /* Message Buffer 73 W Register */
#define CAN_7_CS74           CAN_7.MB[74].CS.R             /* Message Buffer 74 CS Register */
#define CAN_7_ID74           CAN_7.MB[74].ID.R             /* Message Buffer 74 ID Register */
#define CAN_7_B74            CAN_7.MB[74].DATA.B           /* Message Buffer 74 B Register */
#define CAN_7_H74            CAN_7.MB[74].DATA.H           /* Message Buffer 74 H Register */
#define CAN_7_W74            CAN_7.MB[74].DATA.W           /* Message Buffer 74 W Register */
#define CAN_7_CS75           CAN_7.MB[75].CS.R             /* Message Buffer 75 CS Register */
#define CAN_7_ID75           CAN_7.MB[75].ID.R             /* Message Buffer 75 ID Register */
#define CAN_7_B75            CAN_7.MB[75].DATA.B           /* Message Buffer 75 B Register */
#define CAN_7_H75            CAN_7.MB[75].DATA.H           /* Message Buffer 75 H Register */
#define CAN_7_W75            CAN_7.MB[75].DATA.W           /* Message Buffer 75 W Register */
#define CAN_7_CS76           CAN_7.MB[76].CS.R             /* Message Buffer 76 CS Register */
#define CAN_7_ID76           CAN_7.MB[76].ID.R             /* Message Buffer 76 ID Register */
#define CAN_7_B76            CAN_7.MB[76].DATA.B           /* Message Buffer 76 B Register */
#define CAN_7_H76            CAN_7.MB[76].DATA.H           /* Message Buffer 76 H Register */
#define CAN_7_W76            CAN_7.MB[76].DATA.W           /* Message Buffer 76 W Register */
#define CAN_7_CS77           CAN_7.MB[77].CS.R             /* Message Buffer 77 CS Register */
#define CAN_7_ID77           CAN_7.MB[77].ID.R             /* Message Buffer 77 ID Register */
#define CAN_7_B77            CAN_7.MB[77].DATA.B           /* Message Buffer 77 B Register */
#define CAN_7_H77            CAN_7.MB[77].DATA.H           /* Message Buffer 77 H Register */
#define CAN_7_W77            CAN_7.MB[77].DATA.W           /* Message Buffer 77 W Register */
#define CAN_7_CS78           CAN_7.MB[78].CS.R             /* Message Buffer 78 CS Register */
#define CAN_7_ID78           CAN_7.MB[78].ID.R             /* Message Buffer 78 ID Register */
#define CAN_7_B78            CAN_7.MB[78].DATA.B           /* Message Buffer 78 B Register */
#define CAN_7_H78            CAN_7.MB[78].DATA.H           /* Message Buffer 78 H Register */
#define CAN_7_W78            CAN_7.MB[78].DATA.W           /* Message Buffer 78 W Register */
#define CAN_7_CS79           CAN_7.MB[79].CS.R             /* Message Buffer 79 CS Register */
#define CAN_7_ID79           CAN_7.MB[79].ID.R             /* Message Buffer 79 ID Register */
#define CAN_7_B79            CAN_7.MB[79].DATA.B           /* Message Buffer 79 B Register */
#define CAN_7_H79            CAN_7.MB[79].DATA.H           /* Message Buffer 79 H Register */
#define CAN_7_W79            CAN_7.MB[79].DATA.W           /* Message Buffer 79 W Register */
#define CAN_7_CS80           CAN_7.MB[80].CS.R             /* Message Buffer 80 CS Register */
#define CAN_7_ID80           CAN_7.MB[80].ID.R             /* Message Buffer 80 ID Register */
#define CAN_7_B80            CAN_7.MB[80].DATA.B           /* Message Buffer 80 B Register */
#define CAN_7_H80            CAN_7.MB[80].DATA.H           /* Message Buffer 80 H Register */
#define CAN_7_W80            CAN_7.MB[80].DATA.W           /* Message Buffer 80 W Register */
#define CAN_7_CS81           CAN_7.MB[81].CS.R             /* Message Buffer 81 CS Register */
#define CAN_7_ID81           CAN_7.MB[81].ID.R             /* Message Buffer 81 ID Register */
#define CAN_7_B81            CAN_7.MB[81].DATA.B           /* Message Buffer 81 B Register */
#define CAN_7_H81            CAN_7.MB[81].DATA.H           /* Message Buffer 81 H Register */
#define CAN_7_W81            CAN_7.MB[81].DATA.W           /* Message Buffer 81 W Register */
#define CAN_7_CS82           CAN_7.MB[82].CS.R     