#include <hidef.h>		 	/* for EnableInterrupts macro */
#include "derivative.h"		/* include peripheral declarations */
#include "keyboard.h" 
#include "pwm.h" 
#include "adc.h"


void busclk_init(void);

unsigned char tecla;
unsigned int AN0_POT;



void busclk_init() {				//PLL INITIALIZATION		

	CPMUCLKS_PLLSEL = 1;			// FBUS = FPLL/2.   FBUS = 32MHz, 
	CPMUREFDIV_REFFRQ = 1;			// Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		// FREF=4/(1+1) = 2MHZ		
	CPMUSYNR_VCOFRQ = 0x00;         // FVCO is between 32MHZ and 48MHZ	
	CPMUSYNR_SYNDIV = 0x7;			// FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x2x(7+1) = 32MHZ
	CPMUPOSTDIV_POSTDIV = 0x0;		// FPLL = FVCO/(POSTDIV+1).  FPLL = 32MHZ/(0+1)    FPLL = 32MHz	
	CPMUOSC_OSCE = 1;				// External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	CPMUIFLG = 0xFF;				// clear CMPMU flags
	  
	//ECLKCTL_NECLK = 0;				// BUSCLock by PT7 enabled	
	}



void main(void) {
	 
 	
	//busclk_init();
	//EnableInterrupts;
	keyboard_init();				// Config. keyboard interface
	pwm_init();						// Config. control for RGB LED
	
	for(;;) {				// loop forever 
		 __RESET_WATCHDOG();	// feeds the dog 
		 tecla = keypad();
		 RGB_Led(tecla);
	}


}



