#include <hidef.h>		 	/* for EnableInterrupts macro */
#include "derivative.h"		/* include peripheral declarations */
#include "keyboard.h" 
#include "pwm.h" 
#include "adc.h"

unsigned int direction = 0;
unsigned int LED = 1, DT_LED = 0, DT_LEDaux = 0;
unsigned int buzzer_buzzy = 1, buzzer_dir = PWM_DOWN, kbuzzeraux =0, kbuzzer = 10;
 


void pwm_init(){
	
	  
	  /********************************************/
	  /************ PWM INITIALIZATION ************/
	  /********************************************/
	  
	  //1. Select 8 bit (CONxx=0) or 16 bit (CONxx=1) operation.
	  PWM1CTL = 0;
	  
	  //2. Select the clock source (PWMCLK register).
	  PWM1CLK_PCLK1 = 0;		// Clock A
	  PWM1CLK_PCLK3 = 0;		// Clock B
	  PWM1CLK_PCLK5 = 0;		// Clock A

	  
	  //3. Configure prescaler clock (PWMPRCLK register).
	  PWM1PRCLK = 0x44;		// Prescaler Select for Clock A-B, CLKPWM = BUS_CLK/16 = 16Mhz/16 = 1MHz
	  PWM1SCLA = 2;			// Clock SA = ClockA/(2*PWMSCLA) = 1MHz/(2*2) = 250kHz
		
	  
	  //4. Configure duty (PWMDTYx) and period (PWMPERx).
	  PWM1PER1 = 200;		// PWM1_PER = (1/Clock A)*PWMPER1 = 200 usec  -> 5.00kHz
	  PWM1PER3 = 200;		// PWM3_PER = (1/Clock B)*PWMPER3 = 200 usec  -> 5.00kHz
	  PWM1PER5 = 200;		// PWM5_PER = (1/Clock A)*PWMPER5 = 200 usec  -> 5.00kHz
	  
	  PWM1DTY1 = 0;
	  PWM1DTY3 = 0;
	  PWM1DTY5 = 0;
	  
	  //5. Select the PWM polarity (PWMPOL).
	  PWM1POL_PPOL1 = 0;
	  PWM1POL_PPOL3 = 0;
	  PWM1POL_PPOL5 = 0;
	  
	  //6. Select left aligned (CAEx=0) or center aligned (CAEx=1) output.
	  PWM0CAE = 0x00;
	  
	  //7. Enable the needed channels (PWMEx=1).
	  PWM1E_PWME1 = 1;		// Pulse width channel 1 is enabled [LED Red]
	  PWM1E_PWME3 = 1;		// Pulse width channel 3 is enabled	[LED Blue]
	  PWM1E_PWME5 = 1;		// Pulse width channel 5 is enabled [LED Green]
}

void RGB_Led(int a) {
	
	DT_LEDaux = a*22;
	if(DT_LED < DT_LEDaux){DT_LED = DT_LEDaux;}

	if(LED==1 && direction == PWM_UP){						// LED Red
		  if(PWM1DTY1<DT_LED){PWM1DTY1++;}
	else if(PWM1DTY1==DT_LED){direction = PWM_DOWN;}
	} 
	else if(LED==1 && direction == PWM_DOWN){
		  if(PWM1DTY1>LED_MIN){PWM1DTY1--;}
		  else {direction = PWM_UP; DT_LED = DT_LEDaux; LED++;}
	}
	
	
	
	else if(LED==2 && direction == PWM_UP){					// LED Purple
		  if(PWM1DTY1<DT_LED){PWM1DTY1++;PWM1DTY3++;}
	else if(PWM1DTY1==DT_LED){direction = PWM_DOWN;}
	} 
	else if(LED == 2 && direction == PWM_DOWN){
		  if(PWM1DTY1>LED_MIN){PWM1DTY1--; PWM1DTY3--;} else {direction = PWM_UP; DT_LED = DT_LEDaux; LED++;}
	}
	

	
	else if(LED==3 && direction == PWM_UP){					// LED Blue
		  if(PWM1DTY3<DT_LED){PWM1DTY3++;}
	else if(PWM1DTY3==DT_LED){direction = PWM_DOWN;}
	} 
	else if(LED==3 && direction == PWM_DOWN){
		  if(PWM1DTY3>LED_MIN){PWM1DTY3--;} else {direction = PWM_UP; DT_LED = DT_LEDaux; LED++;}
	}



	else if(LED==4 && direction == PWM_UP){					// LED Ice blue
		  if(PWM1DTY5<DT_LED){PWM1DTY3++;PWM1DTY5++;}
	else if(PWM1DTY5==DT_LED){direction = PWM_DOWN;}
	} 
	else if(LED == 4 && direction == PWM_DOWN){
		  if(PWM1DTY5>LED_MIN){PWM1DTY3--; PWM1DTY5--;} else {direction = PWM_UP; DT_LED = DT_LEDaux; LED++;}
	}
	
	
	
	else if(LED==5 && direction == PWM_UP){					// LED Green
		  if(PWM1DTY5<DT_LED){PWM1DTY5++;}
	else if(PWM1DTY5==DT_LED){direction = PWM_DOWN;}
	} 
	else if(LED==5 && direction == PWM_DOWN){
		  if(PWM1DTY5>LED_MIN){PWM1DTY5--;} else {direction = PWM_UP; DT_LED = DT_LEDaux; LED++;}
	}
	

	
	else if(LED==6 && direction == PWM_UP){					// LED Yellow
		  if(PWM1DTY5<DT_LED){PWM1DTY5++;PWM1DTY1++;}
	else if(PWM1DTY5==DT_LED){direction = PWM_DOWN;}
	} 
	else if(LED == 6 && direction == PWM_DOWN){
		  if(PWM1DTY5>LED_MIN){PWM1DTY5--; PWM1DTY1--;} 
		  else {direction = PWM_UP; DT_LED = DT_LEDaux; LED=1;}
	}
	
	
}



